/*
 * Decompiled with CFR 0.152.
 */
package oracle.jbo.client.remote;

import com.sun.java.util.collections.ArrayList;
import com.sun.java.util.collections.HashMap;
import java.util.Enumeration;
import java.util.Hashtable;
import oracle.jbo.ApplicationModule;
import oracle.jbo.AttributeList;
import oracle.jbo.DeleteEvent;
import oracle.jbo.InsertEvent;
import oracle.jbo.InvalidObjAccessException;
import oracle.jbo.InvalidOperException;
import oracle.jbo.Key;
import oracle.jbo.NavigationEvent;
import oracle.jbo.RangeRefreshEvent;
import oracle.jbo.Row;
import oracle.jbo.RowIterator;
import oracle.jbo.RowSet;
import oracle.jbo.RowSetIterator;
import oracle.jbo.RowSetListener;
import oracle.jbo.RowSetManagementListener;
import oracle.jbo.ScrollEvent;
import oracle.jbo.UpdateEvent;
import oracle.jbo.Variable;
import oracle.jbo.VariableValueManager;
import oracle.jbo.ViewCriteria;
import oracle.jbo.ViewObject;
import oracle.jbo.XMLInterface;
import oracle.jbo.client.remote.ApplicationModuleImpl;
import oracle.jbo.client.remote.ClientComponentObject;
import oracle.jbo.client.remote.ClientVariableValueManager;
import oracle.jbo.client.remote.InternalListenerManager;
import oracle.jbo.client.remote.RowSetIteratorImpl;
import oracle.jbo.client.remote.ViewUsageImpl;
import oracle.jbo.common.Diagnostic;
import oracle.jbo.common.JboXMLUtil;
import oracle.jbo.common.RowSetHelper;
import oracle.jbo.common.SvcMsgIteratorState;
import oracle.jbo.common.ws.WSRowSetIteratorMarshaller;
import oracle.jbo.common.ws.WSVariableValueManagerMarshaller;
import oracle.xml.parser.v2.XSLStylesheet;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

class RowSetImpl
extends RowSetHelper
implements WSVariableValueManagerMarshaller,
WSRowSetIteratorMarshaller,
InternalListenerManager,
RowSetListener,
RowSet,
ClientComponentObject {
    public static final byte VIEWLINK_MODE_UNINITIALIZED = -1;
    public static final byte VIEWLINK_MODE_INCONSISTENT = 0;
    public static final byte VIEWLINK_MODE_CONSISTENT = 1;
    public static final byte VIEWLINK_MODE_DEFAULT = 2;
    ApplicationModuleImpl am;
    ViewUsageImpl mVO;
    byte mAccessMode;
    boolean mExecuted;
    boolean mMaxFetchSizeExceeded;
    private boolean mIsForwardOnly;
    private int mId;
    private RowSetIteratorImpl defaultIter;
    private ArrayList mRowSetIterators;
    private boolean mIsDefaultRS;
    private boolean mIsNameGenerated;
    private boolean mIsAssociationConsistent;
    private int mViewLinkMode;
    private int mERCResponseId;
    private long mEstimatedRowCount;
    private RowSetIterator[] mMasterRowSetIterators;
    private ClientVariableValueManager mVariableManager;
    private static /* synthetic */ Class class$oracle$jbo$CSMessageBundle;

    private /* synthetic */ void $init$() {
        this.mAccessMode = 0;
        this.mExecuted = false;
        this.mMaxFetchSizeExceeded = false;
        this.mIsForwardOnly = false;
        this.mRowSetIterators = new ArrayList(4);
        this.mIsDefaultRS = false;
        this.mIsNameGenerated = false;
        this.mIsAssociationConsistent = false;
        this.mViewLinkMode = -1;
        this.mERCResponseId = -1;
        this.mEstimatedRowCount = -1;
        this.mMasterRowSetIterators = null;
        this.mVariableManager = null;
    }

    static RowSetImpl createDefaultRowSet(ViewUsageImpl viewUsageImpl) {
        return (RowSetImpl)viewUsageImpl.mAM.getDefaultRowSet(viewUsageImpl);
    }

    RowSetImpl(ApplicationModuleImpl applicationModuleImpl, ViewUsageImpl viewUsageImpl, int n, String string, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, int n2) {
        this.$init$();
        this.am = applicationModuleImpl;
        this.mVO = viewUsageImpl;
        this.init(n, string, bl, bl2, bl3, bl4, bl5, n2);
    }

    public final Object getSyncLock() {
        return this.mVO.getSyncLock();
    }

    boolean isBatchMode() {
        int n = this.getViewObjectImpl().getSyncMode();
        return n == 2 || n == 5000;
    }

    void init(int n, String string, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, int n2) {
        this.mId = n;
        this.mIsDefaultRS = bl;
        this.mExecuted = bl2;
        this.mIsNameGenerated = bl3;
        this.mIsForwardOnly = bl4;
        this.mIsAssociationConsistent = bl5;
        this.mViewLinkMode = n2;
        this.setName(string);
        this.am.registerObject(n, this);
        this.mVO.addRowSet(this);
        if (this.mIsDefaultRS) {
            this.mVO.setDefaultRowSetImpl(this);
        }
    }

    public final boolean isNameGenerated() {
        return this.mIsNameGenerated;
    }

    public void closeRowSet() {
        this.clearClientSide(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clearClientSide(boolean bl) {
        Object object = this.getSyncLock();
        synchronized (object) {
            RowSetIteratorImpl[] rowSetIteratorImplArray = (RowSetIteratorImpl[])this.mRowSetIterators.toArray((Object[])new RowSetIteratorImpl[this.mRowSetIterators.size()]);
            int n = 0;
            while (n < rowSetIteratorImplArray.length) {
                rowSetIteratorImplArray[n].clearClientSide(bl);
                ++n;
            }
            this.mRowSetIterators.clear();
            if (this.defaultIter != null) {
                this.defaultIter.clearClientSide(bl);
            }
            this.mVO.removeRowSet(this);
            if (bl) {
                this.am.removeAndUnregisterObject(this.mId);
            } else {
                this.am.unregisterObject(this.mId, this);
            }
            this.am = null;
            this.mMaxFetchSizeExceeded = false;
        }
    }

    public void closeRowSetIterator() {
        if (this.defaultIter != null) {
            this.defaultIter.closeRowSetIterator();
        }
    }

    public final boolean isMaxFetchSizeExceeded() {
        return this.mMaxFetchSizeExceeded;
    }

    public boolean isFetchComplete() {
        return this.am.isFetchComplete(this.mId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void resetRowSet() {
        Object object = this.getSyncLock();
        synchronized (object) {
            int n = 0;
            while (n < this.mRowSetIterators.size()) {
                ((RowSetIteratorImpl)this.mRowSetIterators.get(n)).resetIterator();
                ++n;
            }
        }
    }

    public int getRemoteId() {
        return this.mId;
    }

    public byte getROTEntryType() {
        return 1;
    }

    void setDefaultRowSetIteratorImpl(RowSetIteratorImpl rowSetIteratorImpl) {
        this.defaultIter = rowSetIteratorImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RowSetIteratorImpl getDefaultRowSetIteratorImpl() {
        if (this.defaultIter == null) {
            Object object = this.getSyncLock();
            synchronized (object) {
                RowSetIteratorImpl.createDefaultRowSetIterator(this);
                Diagnostic.ASSERT(this.defaultIter != null, "Default Row Set Iterator is null");
            }
        }
        return this.defaultIter;
    }

    boolean isDefaultRS() {
        return this.mIsDefaultRS;
    }

    public RowSet getRowSet() {
        return this.mIsDefaultRS ? this.mVO.getRowSet() : this;
    }

    public RowSetIterator getRowSetIterator() {
        return this.mIsDefaultRS ? this.mVO.getRowSetIterator() : this;
    }

    public void addListener(Object object) {
        this.getDefaultRowSetIteratorImpl().addListener(object);
    }

    public void addInternalListener(Object object) {
        this.getDefaultRowSetIteratorImpl().addInternalListener(object);
    }

    public void removeInternalListener(Object object) {
        this.getDefaultRowSetIteratorImpl().removeInternalListener(object);
    }

    public void removeListener(Object object) {
        if (this.defaultIter != null) {
            this.getDefaultRowSetIteratorImpl().removeListener(object);
        }
    }

    public void addManagementListener(RowSetManagementListener rowSetManagementListener) {
        this.getDefaultRowSetIteratorImpl().addManagementListener(rowSetManagementListener);
    }

    public void removeManagementListener(RowSetManagementListener rowSetManagementListener) {
        if (this.defaultIter != null) {
            this.getDefaultRowSetIteratorImpl().removeManagementListener(rowSetManagementListener);
        }
    }

    public Hashtable getProperties() {
        return this.mVO.getProperties();
    }

    void removeInternalListeners() {
        if (this.mMasterRowSetIterators != null) {
            int n = 0;
            while (n < this.mMasterRowSetIterators.length) {
                RowSetIterator rowSetIterator = this.mMasterRowSetIterators[n];
                ((InternalListenerManager)((Object)rowSetIterator)).removeInternalListener(this);
                ++n;
            }
        }
    }

    void clearDetailSets() {
        if (this.mRowSetIterators != null) {
            int n = 0;
            while (n < this.mRowSetIterators.size()) {
                RowSetIteratorImpl rowSetIteratorImpl = (RowSetIteratorImpl)this.mRowSetIterators.get(n);
                rowSetIteratorImpl.clearDetailSets();
                ++n;
            }
        }
    }

    void setMasterRowSetIterators(RowSetIterator[] rowSetIteratorArray) {
        this.mMasterRowSetIterators = rowSetIteratorArray;
    }

    public boolean setMasterRowSetIterator(RowSetIterator rowSetIterator) {
        if (rowSetIterator == null) {
            this.removeInternalListeners();
        } else if (this.mMasterRowSetIterators != null) {
            RowSetIterator rowSetIterator2 = null;
            boolean bl = false;
            int n = 0;
            while (n < this.mMasterRowSetIterators.length) {
                rowSetIterator2 = this.mMasterRowSetIterators[n];
                if (rowSetIterator2.getRowSet().getViewObject() == rowSetIterator.getRowSet().getViewObject()) {
                    bl = true;
                    break;
                }
                ++n;
            }
            if (bl && rowSetIterator2 != null) {
                ((InternalListenerManager)((Object)rowSetIterator2)).removeInternalListener(this);
                this.mMasterRowSetIterators[n] = rowSetIterator;
            } else {
                RowSetIterator[] rowSetIteratorArray = new RowSetIterator[this.mMasterRowSetIterators.length + 1];
                System.arraycopy(this.mMasterRowSetIterators, 0, rowSetIteratorArray, 0, this.mMasterRowSetIterators.length);
                rowSetIteratorArray[this.mMasterRowSetIterators.length] = rowSetIterator;
                this.mMasterRowSetIterators = rowSetIteratorArray;
            }
        }
        this.am.setMasterRowSetIterator(this.mId, ViewUsageImpl.getImplObject(rowSetIterator).getRemoteId());
        return true;
    }

    public boolean removeMasterRowSetIterator(RowSetIterator rowSetIterator) {
        this.am.removeMasterRowSetIterator(this.mId, ViewUsageImpl.getImplObject(rowSetIterator).getRemoteId());
        return true;
    }

    RowSetIterator[] getMasterRSIsInternal() {
        return this.mMasterRowSetIterators;
    }

    public RowSetIterator[] getMasterRowSetIterators() {
        if (this.isBatchMode()) {
            return this.getMasterRSIsInternal();
        }
        RowSetIterator[] rowSetIteratorArray = this.am.getMasterRowSetIterators(this.mId);
        RowSetIterator[] rowSetIteratorArray2 = null;
        if (rowSetIteratorArray != null) {
            rowSetIteratorArray2 = new RowSetIterator[rowSetIteratorArray.length];
            int n = 0;
            while (n < rowSetIteratorArray.length) {
                rowSetIteratorArray2[n] = ((RowSetIteratorImpl)rowSetIteratorArray[n]).getRowSetIterator();
                ++n;
            }
        }
        return rowSetIteratorArray2;
    }

    boolean isDetailRowSet() {
        return this.mMasterRowSetIterators != null && this.mMasterRowSetIterators.length > 0;
    }

    public ApplicationModule getApplicationModule() {
        return this.am;
    }

    public Object[] getRowFilterValues() {
        if (this.defaultIter == null) {
            return null;
        }
        return this.getDefaultRowSetIteratorImpl().getRowFilterValues();
    }

    public void setRowFilterValues(Object[] objectArray) {
        if (this.defaultIter != null) {
            this.getDefaultRowSetIteratorImpl().setRowFilterValues(objectArray);
        }
    }

    public SvcMsgIteratorState getCliIteratorState() {
        if (this.defaultIter == null) {
            return null;
        }
        return this.getDefaultRowSetIteratorImpl().getCliIteratorState();
    }

    public void prepareForBatchMode(SvcMsgIteratorState svcMsgIteratorState, boolean bl) {
    }

    public int setRangeStart(int n) {
        return this.getDefaultRowSetIteratorImpl().setRangeStart(n);
    }

    public int getRangeStart() {
        if (this.defaultIter == null) {
            return -1;
        }
        return this.getDefaultRowSetIteratorImpl().getRangeStart();
    }

    public int setRangeSize(int n) {
        return this.getDefaultRowSetIteratorImpl().setRangeSize(n);
    }

    public int getRangeSize() {
        if (this.defaultIter == null) {
            return 1;
        }
        return this.getDefaultRowSetIteratorImpl().getRangeSize();
    }

    public int getRangeIndexOf(Row row) {
        return this.getDefaultRowSetIteratorImpl().getRangeIndexOf(row);
    }

    public int scrollRange(int n) {
        return this.getDefaultRowSetIteratorImpl().scrollRange(n);
    }

    public int getEstimatedRangePageCount() {
        return this.getDefaultRowSetIteratorImpl().getEstimatedRangePageCount();
    }

    public int scrollToRangePage(int n) {
        return this.getDefaultRowSetIteratorImpl().scrollToRangePage(n);
    }

    public int scrollRangeTo(Row row, int n) {
        return this.getDefaultRowSetIteratorImpl().scrollRangeTo(row, n);
    }

    public Row[] getFilteredRows(String string, Object object) {
        return this.getDefaultRowSetIteratorImpl().getFilteredRows(string, object);
    }

    public Row[] getFilteredRowsInRange(String string, Object object) {
        return this.getDefaultRowSetIteratorImpl().getFilteredRowsInRange(string, object);
    }

    public Row[] getAllRowsInRange() {
        return this.getDefaultRowSetIteratorImpl().getAllRowsInRange();
    }

    public Row[] getNextRangeSet() {
        return this.getDefaultRowSetIteratorImpl().getNextRangeSet();
    }

    public Row[] getPreviousRangeSet() {
        return this.getDefaultRowSetIteratorImpl().getPreviousRangeSet();
    }

    public Enumeration enumerateRowsInRange() {
        return this.getDefaultRowSetIteratorImpl().enumerateRowsInRange();
    }

    public Row next() {
        return this.getDefaultRowSetIteratorImpl().next();
    }

    public Row previous() {
        return this.getDefaultRowSetIteratorImpl().previous();
    }

    public boolean hasNext() {
        return this.getDefaultRowSetIteratorImpl().hasNext();
    }

    public boolean hasPrevious() {
        return this.getDefaultRowSetIteratorImpl().hasPrevious();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getRowCount() {
        Object object = this.getSyncLock();
        synchronized (object) {
            int n = this.am.getRowCount(this.mId);
            return n;
        }
    }

    public int getFetchedRowCount() {
        return this.getDefaultRowSetIteratorImpl().getFetchedRowCount();
    }

    public boolean isRangeAtBottom() {
        return this.getDefaultRowSetIteratorImpl().isRangeAtBottom();
    }

    public boolean isRangeAtTop() {
        return this.getDefaultRowSetIteratorImpl().isRangeAtTop();
    }

    public void insertRow(Row row) {
        this.getDefaultRowSetIteratorImpl().insertRow(row);
    }

    public void insertRowAtRangeIndex(int n, Row row) {
        this.getDefaultRowSetIteratorImpl().insertRowAtRangeIndex(n, row);
    }

    public void removeCurrentRow() {
        this.getDefaultRowSetIteratorImpl().removeCurrentRow();
    }

    public void removeCurrentRowFromCollection() {
        this.getDefaultRowSetIteratorImpl().removeCurrentRowFromCollection();
    }

    public Row removeCurrentRowAndRetain() {
        return this.getDefaultRowSetIteratorImpl().removeCurrentRowAndRetain();
    }

    public Row first() {
        return this.getDefaultRowSetIteratorImpl().first();
    }

    public Row last() {
        return this.getDefaultRowSetIteratorImpl().last();
    }

    public Row getCurrentRow() {
        return this.getDefaultRowSetIteratorImpl().getCurrentRow();
    }

    public int getCurrentRowIndex() {
        return this.getDefaultRowSetIteratorImpl().getCurrentRowIndex();
    }

    public int getCurrentRowSlot() {
        return this.getDefaultRowSetIteratorImpl().getCurrentRowSlot();
    }

    public Row getRow(Key key) {
        return this.getDefaultRowSetIteratorImpl().getRow(key);
    }

    public Row getRowAtRangeIndex(int n) {
        return this.getDefaultRowSetIteratorImpl().getRowAtRangeIndex(n);
    }

    public int getIterMode() {
        return this.getDefaultRowSetIteratorImpl().getIterMode();
    }

    public void setIterMode(int n) {
        this.getDefaultRowSetIteratorImpl().setIterMode(n);
    }

    public boolean isRowValidation() {
        return this.getDefaultRowSetIteratorImpl().isRowValidation();
    }

    public void setRowValidation(boolean bl) {
        this.getDefaultRowSetIteratorImpl().setRowValidation(bl);
    }

    public boolean setCurrentRow(Row row) {
        return this.getDefaultRowSetIteratorImpl().setCurrentRow(row);
    }

    public boolean setCurrentRowAtRangeIndex(int n) {
        return this.getDefaultRowSetIteratorImpl().setCurrentRowAtRangeIndex(n);
    }

    public Row createAndInitRow(AttributeList attributeList) {
        return this.getDefaultRowSetIteratorImpl().createAndInitRow(attributeList);
    }

    public Row createRow() {
        return this.getDefaultRowSetIteratorImpl().createRow();
    }

    public Object getParent() {
        return this.mVO;
    }

    public ViewObject getViewObject() {
        return this.mVO;
    }

    ViewUsageImpl getViewObjectImpl() {
        return this.mVO;
    }

    public RowSetIterator createRowSetIterator(String string) {
        if (this.mIsForwardOnly && this.mRowSetIterators.size() > 0) {
            Class clazz = class$oracle$jbo$CSMessageBundle;
            if (clazz == null) {
                clazz = class$oracle$jbo$CSMessageBundle = RowSetImpl.class$("oracle.jbo.CSMessageBundle");
            }
            throw new InvalidOperException(clazz, "25011", new Object[]{this.getName()});
        }
        RowSetIterator rowSetIterator = this.am.createRowSetIterator(this, string);
        return rowSetIterator;
    }

    public RowSetIterator[] getRowSetIterators() {
        if (this.am == null) {
            throw new InvalidObjAccessException(112, this.getName());
        }
        RowSetIterator[] rowSetIteratorArray = this.am.getRowSetIterators(this.mId);
        RowSetIterator[] rowSetIteratorArray2 = null;
        if (rowSetIteratorArray != null) {
            rowSetIteratorArray2 = new RowSetIterator[rowSetIteratorArray.length];
            int n = 0;
            while (n < rowSetIteratorArray.length) {
                rowSetIteratorArray2[n] = ((RowSetIteratorImpl)rowSetIteratorArray[n]).isDefaultRSI() ? rowSetIteratorArray[n].getRowSet() : rowSetIteratorArray[n];
                ++n;
            }
        }
        return rowSetIteratorArray2;
    }

    public RowSetIterator findRowSetIterator(String string) {
        if (this.isBatchMode()) {
            int n = 0;
            while (n < this.mRowSetIterators.size()) {
                RowSetIteratorImpl rowSetIteratorImpl = (RowSetIteratorImpl)this.mRowSetIterators.get(n);
                if (rowSetIteratorImpl.getName().equals(string)) {
                    return rowSetIteratorImpl.getRowSetIterator();
                }
                ++n;
            }
            return null;
        }
        RowSetIterator rowSetIterator = this.am.findRowSetIterator(this, string);
        if (rowSetIterator == null) {
            return null;
        }
        return ((RowSetIteratorImpl)rowSetIterator).isDefaultRSI() ? rowSetIterator.getRowSet() : rowSetIterator;
    }

    void addRowSetIterator(RowSetIterator rowSetIterator) {
        this.mRowSetIterators.add((Object)rowSetIterator);
    }

    void removeRowSetIterator(RowSetIterator rowSetIterator) {
        if (this.mRowSetIterators.contains((Object)rowSetIterator)) {
            if (rowSetIterator == this.defaultIter) {
                this.defaultIter = null;
            }
            this.mRowSetIterators.remove((Object)rowSetIterator);
        }
    }

    public int getRowCountInRange() {
        return this.getDefaultRowSetIteratorImpl().getRowCountInRange();
    }

    public void reset() {
        this.getDefaultRowSetIteratorImpl().reset();
    }

    void resetEstimatedRowCount() {
        this.mEstimatedRowCount = -1;
    }

    void adjustEstimatedRowCount(int n) {
        if (this.defaultIter != null && this.defaultIter.adjustEstimatedRowCount(n)) {
            return;
        }
        if (this.mEstimatedRowCount >= 0L && this.mERCResponseId != this.am.getResponseEntriesId()) {
            this.mEstimatedRowCount += (long)n;
            if (this.mEstimatedRowCount < 0L) {
                this.mEstimatedRowCount = 0L;
            }
        }
    }

    public long getEstimatedRowCount() {
        long l = -1;
        if (this.defaultIter != null && (l = this.defaultIter.getEstimatedRowCount()) >= 0L) {
            return l;
        }
        if (this.mEstimatedRowCount == (long)-1 && !this.isBatchMode()) {
            this.mERCResponseId = this.am.getResponseEntriesId();
            this.mEstimatedRowCount = this.am.getEstimatedRowCount(this.mId);
        }
        return this.mEstimatedRowCount;
    }

    void setEstimatedRowCount(long l) {
        if (this.defaultIter != null) {
            this.defaultIter.setEstimatedRowCount(l);
        }
        this.mEstimatedRowCount = l;
    }

    public RowSet[] getDetailRowSets() {
        return this.getDefaultRowSetIteratorImpl().getDetailRowSets();
    }

    public RowSet createDetailRowSet(String string, String string2) {
        return this.getDefaultRowSetIteratorImpl().createDetailRowSet(string, string2);
    }

    public void setNamedWhereClauseParams(AttributeList attributeList) {
    }

    public AttributeList getNamedWhereClauseParams() {
        return null;
    }

    public void setWhereClauseParams(Object[] objectArray) {
        this.am.setWhereClauseParams(this.mId, objectArray);
    }

    public void setWhereClauseParam(int n, Object object) {
        this.am.setWhereClauseParam(this.mId, n, object);
    }

    public void defineNamedWhereClauseParam(String string, Object object, int[] nArray) {
        this.am.defineNamedWhereClauseParam(this.mId, string, object, nArray);
    }

    public void removeNamedWhereClauseParam(String string) {
        this.am.removeNamedWhereClauseParam(this.mId, string);
    }

    public Object getNamedWhereClauseParam(String string) {
        return this.am.getNamedWhereClauseParam(this.mId, string);
    }

    public void setNamedWhereClauseParam(String string, Object object) {
        this.am.setNamedWhereClauseParam(this.mId, string, object);
    }

    public void skipNamedWhereClauseParam(String string) {
        this.am.skipNamedWhereClauseParam(this.mId, string);
    }

    public Object[] getWhereClauseParams() {
        return this.am.getWhereClauseParams(this.mId);
    }

    public boolean isExecuted() {
        return this.mExecuted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeQuery() {
        Object object = this.getSyncLock();
        synchronized (object) {
            this.resetRowSet();
            this.mVO.syncCriteria();
            this.am.executeQuery(this.mId);
            this.mExecuted = true;
        }
    }

    public boolean cancelQuery() {
        return this.am.cancelQuery(this.mId);
    }

    public Row[] findByKey(Key key, int n) {
        return this.getDefaultRowSetIteratorImpl().findByKey(key, n);
    }

    public Key createKey(AttributeList attributeList) {
        return this.mVO.createKey(attributeList);
    }

    public RowIterator findByViewCriteria(ViewCriteria viewCriteria, int n, int n2) {
        return this.getDefaultRowSetIteratorImpl().findByViewCriteria(viewCriteria, n, n2);
    }

    public Row[] findByEntity(int n, int n2) {
        return this.getDefaultRowSetIteratorImpl().findByEntity(n, n2);
    }

    public boolean isForwardOnly() {
        return this.mIsForwardOnly;
    }

    public byte getAccessMode() {
        return this.mAccessMode;
    }

    public final void setAccessMode(byte by) {
        if (this.mAccessMode != by) {
            if (this.mRowSetIterators.size() > 1) {
                Class clazz = class$oracle$jbo$CSMessageBundle;
                if (clazz == null) {
                    clazz = class$oracle$jbo$CSMessageBundle = RowSetImpl.class$("oracle.jbo.CSMessageBundle");
                }
                throw new InvalidOperException(clazz, "25011", new Object[]{this.getName()});
            }
            this.mAccessMode = by;
            this.getDefaultRowSetIteratorImpl().setCacheInSync(false);
            this.am.setAccessMode(this.mId, by);
        }
    }

    public void setForwardOnly(boolean bl) {
        if (this.mIsForwardOnly != bl) {
            if (this.mRowSetIterators.size() > 1) {
                Class clazz = class$oracle$jbo$CSMessageBundle;
                if (clazz == null) {
                    clazz = class$oracle$jbo$CSMessageBundle = RowSetImpl.class$("oracle.jbo.CSMessageBundle");
                }
                throw new InvalidOperException(clazz, "25011", new Object[]{this.getName()});
            }
            this.mIsForwardOnly = bl;
            if (this.mIsForwardOnly && this.getRangeSize() != 1) {
                this.getDefaultRowSetIteratorImpl().setRangeSizeInternal(1);
                this.getDefaultRowSetIteratorImpl().setCacheInSync(false);
            }
            this.am.setForwardOnly(this.mId, this.mIsForwardOnly);
        }
    }

    public boolean isAssociationConsistent() {
        return this.mIsAssociationConsistent;
    }

    public void setAssociationConsistent(boolean bl) {
        int n;
        int n2 = n = bl ? 1 : 0;
        if (this.mViewLinkMode != 1 && this.mViewLinkMode != 0 || n != this.mViewLinkMode) {
            this.mIsAssociationConsistent = bl;
            this.am.setAssociationConsistent(this.mId, this.mIsAssociationConsistent);
        }
        this.mViewLinkMode = n;
    }

    void clearClientCache() {
        int n = 0;
        while (n < this.mRowSetIterators.size()) {
            ((RowSetIteratorImpl)this.mRowSetIterators.get(n)).clearClientCache();
            ++n;
        }
    }

    protected void finalize() {
        Diagnostic.println("--## finlCLI RowSetImpl id=" + this.mId + ", name=" + this.getName() + ", obj=" + this);
        if (this.am != null) {
            this.am.objectFinalized(this.mId);
        }
    }

    public Node writeXML(long l, HashMap hashMap) {
        return this.am.writeRowSetXMLWithMap(this.mId, l, hashMap);
    }

    public Node writeXML(int n, long l) {
        return this.am.writeRowSetXML(this.mId, n, l);
    }

    public void readXML(Element element, int n) {
        this.am.readRowSetXML(this.mId, element, n);
    }

    public Node writeXML(long l, HashMap hashMap, XSLStylesheet xSLStylesheet) {
        return JboXMLUtil.writeAndProcessXML((XMLInterface)this, l, hashMap, xSLStylesheet);
    }

    public Node writeXML(int n, long l, XSLStylesheet xSLStylesheet) {
        return JboXMLUtil.writeAndProcessXML((XMLInterface)this, n, l, xSLStylesheet);
    }

    public void readXML(Element element, int n, XSLStylesheet xSLStylesheet) {
        JboXMLUtil.processAndReadXML(this, element, n, xSLStylesheet);
    }

    public void rangeRefreshed(RangeRefreshEvent rangeRefreshEvent) {
        if (rangeRefreshEvent.isReset()) {
            RowSetIterator rowSetIterator = (RowSetIterator)rangeRefreshEvent.getSource();
            this.masterNavigated(new NavigationEvent(rowSetIterator, rowSetIterator.getCurrentRow(), null), false);
        }
    }

    public void rangeScrolled(ScrollEvent scrollEvent) {
    }

    public void rowInserted(InsertEvent insertEvent) {
    }

    public void rowDeleted(DeleteEvent deleteEvent) {
    }

    public void rowUpdated(UpdateEvent updateEvent) {
    }

    void masterRowHandleChanged(RowSetIterator rowSetIterator, Object object, Object object2) {
        if (this.mMasterRowSetIterators != null && this.mRowSetIterators != null) {
            int n = 0;
            while (n < this.mRowSetIterators.size()) {
                RowSetIteratorImpl rowSetIteratorImpl = (RowSetIteratorImpl)this.mRowSetIterators.get(n);
                rowSetIteratorImpl.masterRowHandleChanged(rowSetIterator, object, object2);
                ++n;
            }
        }
    }

    void masterRowHandlesChanged(RowSetIterator rowSetIterator, Object[] objectArray, Object[] objectArray2, int n) {
        if (this.mMasterRowSetIterators != null && this.mRowSetIterators != null) {
            int n2 = 0;
            while (n2 < this.mRowSetIterators.size()) {
                RowSetIteratorImpl rowSetIteratorImpl = (RowSetIteratorImpl)this.mRowSetIterators.get(n2);
                rowSetIteratorImpl.masterRowHandlesChanged(rowSetIterator, objectArray, objectArray2, n);
                ++n2;
            }
        }
    }

    void masterNavigated(NavigationEvent navigationEvent, boolean bl) {
        if (this.mMasterRowSetIterators != null && this.mRowSetIterators != null) {
            int n = 0;
            while (n < this.mRowSetIterators.size()) {
                RowSetIteratorImpl rowSetIteratorImpl = (RowSetIteratorImpl)this.mRowSetIterators.get(n);
                rowSetIteratorImpl.masterNavigated(navigationEvent, bl);
                ++n;
            }
        }
    }

    public void navigated(NavigationEvent navigationEvent) {
        this.masterNavigated(navigationEvent, true);
    }

    public String getFullName() {
        return this.getViewObject().getFullName() + '.' + this.getName();
    }

    public void findAndSetCurrentRowByKey(Key key, int n) {
        if (this.defaultIter != null) {
            this.getDefaultRowSetIteratorImpl().findAndSetCurrentRowByKey(key, n);
        }
    }

    public VariableValueManager getVariableManager() {
        return this.mVariableManager;
    }

    public boolean hasVariables() {
        return this.mVariableManager != null;
    }

    public VariableValueManager ensureVariableManager() {
        if (this.mVariableManager == null) {
            ClientVariableValueManager clientVariableValueManager = (ClientVariableValueManager)this.mVO.ensureVariableManager();
            this.mVariableManager = new ClientVariableValueManager(this.am, this, new ClientVariableValueManager[]{clientVariableValueManager});
        }
        return this.mVariableManager;
    }

    public java.util.ArrayList getVariableOpers() {
        return this.mVariableManager != null ? this.mVariableManager.getBatchOpers() : null;
    }

    public void resetVariableOpers() {
        if (this.mVariableManager != null) {
            this.mVariableManager.resetBatchOpers();
        }
    }

    public void mergeVariableValues(Variable[] variableArray, Object[] objectArray) {
        this.mergeVariableValues(variableArray, objectArray, true);
    }

    void mergeVariableValues(Variable[] variableArray, Object[] objectArray, boolean bl) {
        if (variableArray != null && variableArray.length > 0) {
            this.ensureVariableManager();
            this.mVariableManager.mergeVariableValues(variableArray, objectArray, bl);
        }
    }

    public Class getMessageBundleClass() {
        return this.getViewObjectImpl().getMessageBundleClass();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

