/*
 * Decompiled with CFR 0.152.
 */
package oracle.jbo;

import oracle.jbo.RangeEvent;
import oracle.jbo.RowSetIterator;

public class ScrollEvent
extends RangeEvent {
    static final long serialVersionUID = -4180459954318060858L;
    int mRangeStartBefore;

    public ScrollEvent(RowSetIterator rowSetIterator, int n) {
        super(rowSetIterator);
        this.mRangeStartBefore = n;
    }

    public int getRangeStartBefore() {
        return this.mRangeStartBefore;
    }

    public int getScrollAmount() {
        return this.getRangeStart() - this.getRangeStartBefore();
    }

    public int getFirstNewRowRangeIndex() {
        if (this.getScrollAmount() > 0) {
            return this.getRowCountInRange() - this.getNewRowCountInRange();
        }
        return 0;
    }

    public int getNewRowCountInRange() {
        int n = this.getScrollAmount();
        if (n < 0) {
            n = -n;
        }
        if (n > this.getRowCountInRange()) {
            n = this.getRowCountInRange();
        }
        return n;
    }

    public String toString() {
        return "[" + this.toString("ScrollEvent") + " startB4=" + this.getRangeStartBefore() + " amt=" + this.getScrollAmount() + " firstNew=" + this.getFirstNewRowRangeIndex() + " newCount=" + this.getNewRowCountInRange() + "]";
    }
}

