/*
 * Decompiled with CFR 0.152.
 */
package oracle.i18n.util.builder;

import java.io.Serializable;
import java.util.Vector;
import oracle.i18n.util.GDKOracleMetaData;

public abstract class UnicodeMap
implements Serializable {
    static final long serialVersionUID = GDKOracleMetaData.getOracleVersionID();
    static final int INDEX_ARRAY_SIZE = 256;
    static final int DATA_ARRAY_MAX = 65536;
    static final char HIGH_BYTE_MASK = '\uff00';
    static final char LOW_BYTE_MASK = '\u00ff';
    static final int ONE_BYTE_SHIFT = 8;
    static final int TWO_BYTE_SHIFT = 16;
    static final int LOW_2BYTE_MASK = 65535;
    protected int[] indexArray = null;
    protected int[][] surrogateTable = null;

    protected void setIndexArray(int[] nArray) {
        this.indexArray = new int[256];
        for (int i = 0; i < 256; ++i) {
            this.indexArray[i] = nArray[i];
        }
    }

    protected void setSurrogateTable(Vector vector) {
        if (vector == null) {
            return;
        }
        int n = vector.size();
        if (n > 0) {
            this.surrogateTable = new int[n][1024];
            for (int i = 0; i < n; ++i) {
                System.arraycopy((int[])vector.elementAt(i), 0, this.surrogateTable[i], 0, 1024);
            }
        }
    }
}

