/*
 * Decompiled with CFR 0.152.
 */
package oracle.i18n.text;

import java.io.UTFDataFormatException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.sql.SQLException;
import oracle.gss.util.NLSError;
import oracle.i18n.text.OraCharset;
import oracle.i18n.text.OraCharsetDecoder;
import oracle.i18n.text.OraCharsetEncoder;

class OraCharsetAL16UTF16
extends OraCharset {
    static final byte[] REPLACEMENT_CHAR_IN_BYTES = new byte[]{-1, -3};

    OraCharsetAL16UTF16(String string, int n) {
        super(string, n);
    }

    public boolean contains(Charset charset) {
        return true;
    }

    public CharsetDecoder newDecoder() {
        return new OraCharsetDecoder(this, 0.5f, 1.0f);
    }

    public CharsetEncoder newEncoder() {
        return new OraCharsetEncoder(this, 2.0f, 2.0f, REPLACEMENT_CHAR_IN_BYTES);
    }

    String toStringWithReplacement(byte[] byArray, int n, int n2) {
        try {
            char[] cArray = new char[Math.min(byArray.length - n >>> 1, n2 >>> 1)];
            int n3 = OraCharsetAL16UTF16.AL16UTF16BytesToJavaChars(byArray, n, n2, cArray, OraCharset.CharacterConverterBehavior.REPLACEMENT);
            return new String(cArray, 0, n3);
        }
        catch (UTFDataFormatException uTFDataFormatException) {
            return "";
        }
    }

    String toString(byte[] byArray, int n, int n2) throws SQLException {
        try {
            char[] cArray = new char[Math.min(byArray.length - n >>> 1, n2 >>> 1)];
            int n3 = OraCharsetAL16UTF16.AL16UTF16BytesToJavaChars(byArray, n, n2, cArray, OraCharset.CharacterConverterBehavior.REPORT_ERROR);
            return new String(cArray, 0, n3);
        }
        catch (UTFDataFormatException uTFDataFormatException) {
            NLSError.throwSQLException(17037, this);
            return "";
        }
    }

    byte[] convertWithReplacement(String string) {
        char[] cArray = string.toCharArray();
        byte[] byArray = new byte[cArray.length * 2];
        OraCharsetAL16UTF16.javaCharsToAL16UTF16Bytes(cArray, cArray.length, byArray);
        return byArray;
    }

    byte[] convert(String string) throws SQLException {
        return this.convertWithReplacement(string);
    }
}

