/*
 * Decompiled with CFR 0.152.
 */
package oracle.adf.model.servlet;

import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.logging.Level;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import oracle.adf.model.BindingRequestHandler;
import oracle.adf.model.servlet.HttpBindingRequestHandler;
import oracle.adf.share.perf.PerfUtil;
import oracle.adf.share.perf.StateTracker;
import oracle.adf.share.perf.Timer;

public class ADFBindingFilter
implements Filter {
    public static final String INIT_PARAMETER_NAME = "CpxFileName";
    public static final String INIT_PARAMETER_ENCODING = "encoding";
    public static final String INIT_PARAMETER_UNAUTHORIZED_PAGE = "unauthorizedErrorPage";
    public static final String SESSION_INVALIDATE_BINDINGCONTAINER_DEF = "adf_session_invalidate_bindingcontainer_def";
    private FilterConfig mFilterConfig;
    private static String FILTER_SENSOR_GROUP = "/oracle/adf/model/servlet/ADFBindingFilter";
    private static String FILTER_TIMER_NAME = "doFilter";
    private static String FILTER_URL_NAME = "url";
    private static Timer sFilterTimer = Timer.createTimer((Level)Level.INFO, (String)FILTER_SENSOR_GROUP, (String)FILTER_TIMER_NAME, (String)"ADFBindingFilter doFilter timer");
    private static StateTracker sUrlState = StateTracker.createStateTracker((Level)Level.INFO, (String)FILTER_SENSOR_GROUP, (String)FILTER_URL_NAME, (byte)5, (String)"", (String)"ADFBindingFilter request URL");
    private boolean mIsDesignTime;
    private WeakReference mOC4JContextRef;

    private /* synthetic */ void $init$() {
        this.mIsDesignTime = false;
        this.mOC4JContextRef = null;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        this.mFilterConfig = filterConfig;
        ServletContext servletContext = this.mFilterConfig.getServletContext();
        this.mOC4JContextRef = new WeakReference<Object>(BindingRequestHandler.loadApplication());
        this.mIsDesignTime = "Design Time Engine Servlet Context".equals(servletContext.getServletContextName());
    }

    public void destroy() {
        this.mFilterConfig = null;
        Object var1_1 = null;
        Object t = this.mOC4JContextRef.get();
        var1_1 = t;
        if (t != null) {
            BindingRequestHandler.destroyApplication(var1_1);
        }
        this.mOC4JContextRef = null;
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        if (this.mIsDesignTime) {
            filterChain.doFilter(servletRequest, servletResponse);
            return;
        }
        boolean bl = sUrlState.isActive();
        if (bl) {
            sFilterTimer.start();
        }
        HttpBindingRequestHandler httpBindingRequestHandler = new HttpBindingRequestHandler(this.mFilterConfig.getServletContext(), (HttpServletRequest)servletRequest, (HttpServletResponse)servletResponse);
        httpBindingRequestHandler.setUnauthorizedPage(this.mFilterConfig.getInitParameter(INIT_PARAMETER_UNAUTHORIZED_PAGE));
        httpBindingRequestHandler.setTargetEncoding(this.mFilterConfig.getInitParameter(INIT_PARAMETER_ENCODING));
        httpBindingRequestHandler.setBindingContextDefName(this.mFilterConfig.getServletContext().getInitParameter(INIT_PARAMETER_NAME));
        try {
            httpBindingRequestHandler.beginRequest();
            filterChain.doFilter(servletRequest, servletResponse);
            Object var7_6 = null;
            httpBindingRequestHandler.endRequest();
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            httpBindingRequestHandler.endRequest();
            throw throwable;
        }
        if (bl) {
            sUrlState.update((Object)PerfUtil.getUrl((HttpServletRequest)((HttpServletRequest)servletRequest)));
            sFilterTimer.stop();
        }
    }

    public ADFBindingFilter() {
        this.$init$();
    }
}

