/*
 * Decompiled with CFR 0.152.
 */
package oracle.adf.model.generic;

import com.sun.java.util.collections.HashMap;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Locale;
import oracle.adf.model.generic.StructureDefImpl;
import oracle.jbo.AttributeDef;
import oracle.jbo.AttributeHints;
import oracle.jbo.AttributeList;
import oracle.jbo.JboException;
import oracle.jbo.LocaleContext;
import oracle.jbo.common.AttributeDefHelper;
import oracle.jbo.common.Diagnostic;
import oracle.jbo.common.JBOClass;
import oracle.jbo.common.JboNameUtil;
import oracle.jbo.common.StringManager;
import oracle.jbo.format.Formatter;
import oracle.jbo.format.FormatterFactory;
import oracle.jbo.mom.DefinitionObject;
import oracle.jbo.mom.xml.DefElement;
import oracle.jbo.rules.JboPrecisionScaleValidator;
import oracle.jbo.rules.JboValidatorContext;
import oracle.jbo.rules.JboValidatorInterface;
import oracle.jbo.rules.RulesBeanUtils;
import oracle.jbo.rules.ValidationManager;

public class AttributeDefImpl
extends DefinitionObject
implements ValidationManager,
AttributeHints,
AttributeDef {
    private String name;
    private String columnName;
    private int index;
    private Class columnType;
    private Class type;
    private boolean isSelected;
    private boolean isQueriable;
    private byte updateable;
    private boolean primarykey;
    private boolean mandatory;
    private int precision;
    private int scale;
    private String elemClassName;
    private String javaTypeName;
    private ArrayList mValidators;
    private StructureDefImpl mDef;

    private /* synthetic */ void $init$() {
        this.columnType = null;
        this.type = null;
        this.isSelected = false;
        this.isQueriable = false;
    }

    public AttributeDefImpl(String string, String string2, String string3, boolean bl, int n) {
        this(null, string, string3, n, string2, string2, bl ? (byte)2 : 0, false, false, null);
        if (Diagnostic.isOn()) {
            Diagnostic.println((String)("Missing StructureDefinition reference from an attributeDef of name:" + this.name));
        }
    }

    public AttributeDefImpl(StructureDefImpl structureDefImpl, String string, String string2, int n, String string3, String string4, byte by, boolean bl, boolean bl2, String string5) {
        this.$init$();
        this.init(string, string2, n, string3, string4, false, false, by, bl, bl2, string5);
    }

    AttributeDefImpl(StructureDefImpl structureDefImpl) {
        this.$init$();
        this.mDef = structureDefImpl;
    }

    void init(String string, String string2, int n, String string3, String string4, boolean bl, boolean bl2, byte by, boolean bl3, boolean bl4, String string5) {
        this.name = string;
        this.columnName = string2;
        this.index = n;
        this.javaTypeName = string3;
        this.isSelected = bl;
        this.isQueriable = bl2;
        this.updateable = by;
        this.primarykey = bl3;
        this.mandatory = bl4;
        this.elemClassName = string5;
        if (string4 == null || string4.length() == 0) {
            string4 = string3;
        }
        this.columnType = JBOClass.findDataClass((String)string4);
        if (string2 == null) {
            this.columnName = this.name;
        }
    }

    StructureDefImpl getDef() {
        return this.mDef;
    }

    void setDef(StructureDefImpl structureDefImpl) {
        this.mDef = structureDefImpl;
    }

    void loadFromXML(DefElement defElement, int n) {
        this.init(defElement.readString("Name"), defElement.readString("SourceName"), n, defElement.readString("Type"), defElement.readString("SourceType"), defElement.readBoolean("IsSelected"), defElement.readBoolean("IsQueriable"), AttributeDefHelper.convertUpdateableStringToFlag((String)defElement.readString("IsUpdateable")), defElement.readBoolean("PrimaryKey"), defElement.readBoolean("IsNotNull"), null);
        this.setPrecisionScale(defElement.readInt("Precision"), defElement.readInt("Scale"), defElement.readBoolean("PrecisionRule"));
        RulesBeanUtils.loadValidators((DefElement)defElement, (ValidationManager)this, (Class)this.mDef.getMessageBundleClass());
        this.loadProperties(defElement);
    }

    public void setPrecisionScale(int n, int n2) {
        this.setPrecisionScale(n, n2, true);
    }

    public void setPrecisionScale(int n, int n2, boolean bl) {
        this.precision = n;
        if (n > 0) {
            this.scale = n2;
            if (bl) {
                JboPrecisionScaleValidator jboPrecisionScaleValidator = new JboPrecisionScaleValidator();
                jboPrecisionScaleValidator.setPrecision(n);
                jboPrecisionScaleValidator.setScale(n2);
                if (jboPrecisionScaleValidator != null) {
                    this.addValidator((JboValidatorInterface)jboPrecisionScaleValidator);
                }
            }
        }
    }

    public AttributeHints getUIHelper() {
        return this;
    }

    public String getLocaleName(LocaleContext localeContext, String string) {
        return JboNameUtil.getLocaleName((LocaleContext)localeContext, (String)string);
    }

    String getStringFromMessageBundle(String string, LocaleContext localeContext) {
        Class clazz = null;
        if (this.getDef() != null) {
            clazz = this.getDef().getMessageBundleClass();
        }
        if (clazz != null) {
            String string2 = this.getName() + "_" + string;
            return StringManager.getLocalizedString((String)clazz.getName(), (String)string2, null, (Locale)(localeContext != null ? localeContext.getLocale() : null), (boolean)false);
        }
        return null;
    }

    String getControlHint(LocaleContext localeContext, String string) {
        String string2;
        HashMap hashMap;
        String string3 = this.getStringFromMessageBundle(string, localeContext);
        if (string3 == null && (string3 = (String)(hashMap = this.getPropertiesMap()).get((Object)(string2 = this.getLocaleName(localeContext, string)))) == null && !hashMap.containsKey((Object)string2)) {
            string3 = (String)hashMap.get((Object)string);
        }
        return string3 == null ? (String)this.getProperty(string) : string3;
    }

    public String getLabel(LocaleContext localeContext) {
        String string = this.getControlHint(localeContext, "LABEL");
        if (string == null) {
            string = this.getName();
        }
        return string;
    }

    public String getTooltip(LocaleContext localeContext) {
        return this.getControlHint(localeContext, "TOOLTIP");
    }

    public String getDisplayHint(LocaleContext localeContext) {
        String string = this.getControlHint(localeContext, "DISPLAYHINT");
        if (string == null) {
            string = "Display";
        }
        return string;
    }

    public int getControlType(LocaleContext localeContext) {
        String string = this.getControlHint(localeContext, "CONTROLTYPE");
        if (string != null) {
            return Integer.parseInt(string);
        }
        return 100;
    }

    public int getDisplayWidth(LocaleContext localeContext) {
        String string = this.getControlHint(localeContext, "DISPLAYWIDTH");
        if (string != null) {
            return Integer.parseInt(string);
        }
        return this.getPrecision();
    }

    public int getDisplayHeight(LocaleContext localeContext) {
        String string = this.getControlHint(localeContext, "DISPLAYHEIGHT");
        if (string != null) {
            return Integer.parseInt(string);
        }
        return 1;
    }

    public String getHint(LocaleContext localeContext, String string) {
        if (string.equals("LABEL")) {
            return this.getLabel(localeContext);
        }
        if (string.equals("TOOLTIP")) {
            return this.getTooltip(localeContext);
        }
        if (string.equals("DISPLAYWIDTH")) {
            return Integer.toString(this.getDisplayWidth(localeContext));
        }
        return this.getControlHint(localeContext, string);
    }

    public String getHintValue(LocaleContext localeContext, String string) {
        return this.getControlHint(localeContext, string);
    }

    public String getFormat(LocaleContext localeContext) {
        if (!this.hasFormatInformation(localeContext)) {
            return null;
        }
        String string = this.getControlHint(localeContext, "FMT_FORMAT");
        if (string == null) {
            string = this.getFormatter(localeContext).getDefaultFormatString();
        }
        return string;
    }

    public Formatter getFormatter(LocaleContext localeContext) {
        if (!this.hasFormatInformation(localeContext)) {
            return null;
        }
        return FormatterFactory.getFormatter((String)this.getFormatterClassName(localeContext), (LocaleContext)localeContext);
    }

    public boolean hasFormatInformation(LocaleContext localeContext) {
        String string = this.getControlHint(localeContext, "FMT_FORMATTER");
        return string != null && !string.equals("");
    }

    public String getFormattedAttribute(AttributeList attributeList, LocaleContext localeContext) {
        Object object = attributeList.getAttribute(this.getIndex());
        if (object == null) {
            return null;
        }
        if (object.equals("")) {
            return "";
        }
        if (!this.hasFormatInformation(localeContext)) {
            return object.toString();
        }
        try {
            String string;
            Formatter formatter = this.getFormatter(localeContext);
            String string2 = this.getFormat(localeContext);
            formatter.setLocale(localeContext);
            String string3 = string = formatter.format(string2, object);
            return string3;
        }
        catch (Exception exception) {
            throw new JboException((Throwable)exception);
        }
    }

    public Object parseFormattedAttribute(String string, LocaleContext localeContext) {
        if (string == null) {
            return null;
        }
        if (string.equals("")) {
            return "";
        }
        if (!this.hasFormatInformation(localeContext)) {
            return string;
        }
        try {
            Formatter formatter = this.getFormatter(localeContext);
            String string2 = this.getFormat(localeContext);
            formatter.setLocale(localeContext);
            Object object = formatter.parse(string2, string);
            if (object == null) {
                String string3 = string;
                return string3;
            }
            Object object2 = object;
            return object2;
        }
        catch (ParseException parseException) {
            String string4 = string;
            return string4;
        }
        catch (Exception exception) {
            throw new JboException((Throwable)exception);
        }
    }

    public boolean displayInShortForm(LocaleContext localeContext) {
        String string = this.getControlHint(localeContext, "FORMTYPE");
        if (string == null) {
            return false;
        }
        return string.equals("Summary");
    }

    public String getFormatterClassName(LocaleContext localeContext) {
        return this.getControlHint(localeContext, "FMT_FORMATTER");
    }

    public String getName() {
        return this.name;
    }

    public String getColumnName() {
        return this.columnName;
    }

    Class getColumnType() {
        return this.columnType;
    }

    public String getColumnNameForQuery() {
        return this.columnName;
    }

    public int getIndex() {
        return this.index;
    }

    public Class getJavaType() {
        if (this.type == null) {
            this.type = JBOClass.findDataClass((String)this.javaTypeName);
        }
        return this.type;
    }

    public String getJavaTypeName() {
        return this.javaTypeName;
    }

    public int getSQLType() {
        return 0;
    }

    public byte getAttributeKind() {
        return 0;
    }

    public boolean isSelected() {
        return this.isSelected;
    }

    public boolean isQueriable() {
        return this.isQueriable;
    }

    public byte getUpdateableFlag() {
        return this.updateable;
    }

    public boolean isPrimaryKey() {
        return this.primarykey;
    }

    public boolean isMandatory() {
        return this.mandatory;
    }

    public int getPrecision() {
        return this.precision;
    }

    public int getScale() {
        return this.scale;
    }

    public Class getElemType() {
        if (this.elemClassName != null && this.elemClassName.length() > 0) {
            try {
                Class clazz = JBOClass.forName((String)this.elemClassName);
                return clazz;
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new JboException((Throwable)classNotFoundException);
            }
        }
        return null;
    }

    public int getElemSQLType() {
        return 0;
    }

    public void addValidator(JboValidatorInterface jboValidatorInterface) {
        if (this.mValidators == null) {
            this.mValidators = new ArrayList(4);
        }
        this.mValidators.add(jboValidatorInterface);
    }

    public ArrayList getValidators() {
        return this.mValidators != null ? (ArrayList)this.mValidators.clone() : new ArrayList(0);
    }

    public void validate(AttributeList attributeList, Object object) {
        if (this.mValidators != null) {
            JboValidatorContext jboValidatorContext = new JboValidatorContext(181, (Object)attributeList, this.getDef().getFullName(), (AttributeDef)this, attributeList.getAttribute(this.getIndex()), object);
            int n = 0;
            while (n < this.mValidators.size()) {
                ((JboValidatorInterface)this.mValidators.get(n)).validate(jboValidatorContext);
                ++n;
            }
        }
    }
}

