/*
 * Decompiled with CFR 0.152.
 */
package oracle.adf.model.adapter.dataformat;

import oracle.adf.model.adapter.AdapterDCService;
import oracle.adf.model.adapter.dataformat.AccessorDef;
import oracle.adf.model.adapter.dataformat.FormatDataHandler;
import oracle.adf.model.adapter.dataformat.FormatStructureHandler;
import oracle.adf.model.adapter.dataformat.MethodDef;
import oracle.adf.model.adapter.dataformat.StructureDef;
import oracle.adf.model.utils.JSR227Util;
import oracle.adf.model.utils.SimpleStringBuffer;
import oracle.adf.model.utils.StandardOperationDef;
import oracle.binding.meta.Definition;
import oracle.binding.meta.DefinitionContext;
import oracle.binding.meta.NamedDefinition;
import oracle.binding.meta.StructureDefinition;

public final class FormatHelper {
    public static final String METHOD_CREATE = "loadData";
    public static final String DATA = "Data";
    public static final String OPERATIONS = "Operations";

    public static final StructureHelper getStructureHelper(FormatStructureHandler formatStructureHandler) {
        return new StructureHelper(formatStructureHandler);
    }

    public static final DataHelper getDataHelper(FormatDataHandler formatDataHandler) {
        return new DataHelper(formatDataHandler);
    }

    public static StructureDef createStandardCollectionOpStructure(NamedDefinition namedDefinition) {
        StructureDef structureDef = new StructureDef(new SimpleStringBuffer(50).append(namedDefinition != null ? namedDefinition.getFullName() : "").append("_").append(OPERATIONS).toString(), (Definition)namedDefinition);
        structureDef.addMethod(FormatHelper.createParentedOp(JSR227Util.createExecuteAction(), structureDef));
        structureDef.addMethod(FormatHelper.createParentedOp(JSR227Util.createFirstAction(), structureDef));
        structureDef.addMethod(FormatHelper.createParentedOp(JSR227Util.createPreviousAction(), structureDef));
        structureDef.addMethod(FormatHelper.createParentedOp(JSR227Util.createNextAction(), structureDef));
        structureDef.addMethod(FormatHelper.createParentedOp(JSR227Util.createLastAction(), structureDef));
        return structureDef;
    }

    private static StandardOperationDef createParentedOp(StandardOperationDef standardOperationDef, StructureDef structureDef) {
        if (standardOperationDef != null) {
            standardOperationDef.setParent(structureDef);
        }
        return standardOperationDef;
    }

    public static class StructureHelper {
        private FormatStructureHandler _handler;

        private StructureHelper(FormatStructureHandler formatStructureHandler) {
            this._handler = formatStructureHandler;
        }

        public MethodDef getRootMethod(StructureDefinition structureDefinition, boolean bl, DefinitionContext definitionContext) {
            if (this._handler == null || structureDefinition == null) {
                return null;
            }
            MethodDef methodDef = new MethodDef(FormatHelper.METHOD_CREATE, structureDefinition);
            String string = new SimpleStringBuffer(50).append(structureDefinition.getName()).append(".").append(FormatHelper.METHOD_CREATE).append("_").append(FormatHelper.DATA).toString();
            StructureDefinition structureDefinition2 = this._handler.getStructure(string, definitionContext);
            if (structureDefinition2 != null) {
                methodDef.setReturnType(structureDefinition2, bl);
                if (bl) {
                    methodDef.setReturnCollectionStructure(FormatHelper.createStandardCollectionOpStructure((NamedDefinition)structureDefinition2));
                }
            }
            return methodDef;
        }

        public AccessorDef getRootAccessor(StructureDefinition structureDefinition, boolean bl, DefinitionContext definitionContext) {
            if (this._handler == null || structureDefinition == null) {
                return null;
            }
            String string = new SimpleStringBuffer(50).append(structureDefinition.getName()).append("_").append(FormatHelper.DATA).toString();
            StructureDefinition structureDefinition2 = this._handler.getStructure(string, definitionContext);
            AccessorDef accessorDef = new AccessorDef(FormatHelper.DATA, structureDefinition, structureDefinition2, bl);
            accessorDef.setBindPath(new SimpleStringBuffer(50).append(structureDefinition.getFullName()).append(".").append(AdapterDCService.DC_ROOT_ACC_NAME).toString());
            if (bl) {
                accessorDef.setCollectionStructure(FormatHelper.createStandardCollectionOpStructure((NamedDefinition)structureDefinition2));
            }
            return accessorDef;
        }
    }

    public static class DataHelper {
        private FormatDataHandler _handler;

        private DataHelper(FormatDataHandler formatDataHandler) {
            this._handler = formatDataHandler;
        }
    }
}

