/*
 * Decompiled with CFR 0.152.
 */
package oracle.jbo.server;

import com.sun.java.util.collections.ArrayList;
import com.sun.java.util.collections.Collection;
import com.sun.java.util.collections.HashMap;
import com.sun.java.util.collections.Iterator;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import oracle.jbo.ApplicationModule;
import oracle.jbo.AttributeDef;
import oracle.jbo.AttributeList;
import oracle.jbo.CriteriaClauses;
import oracle.jbo.DMLException;
import oracle.jbo.DeadEntityAccessException;
import oracle.jbo.InvalidDefNameException;
import oracle.jbo.InvalidObjAccessException;
import oracle.jbo.InvalidObjNameException;
import oracle.jbo.InvalidOperException;
import oracle.jbo.InvalidParamException;
import oracle.jbo.JboException;
import oracle.jbo.Key;
import oracle.jbo.NameClashException;
import oracle.jbo.NoDefException;
import oracle.jbo.ReadXMLException;
import oracle.jbo.Row;
import oracle.jbo.RowComparator;
import oracle.jbo.RowIterator;
import oracle.jbo.RowMatch;
import oracle.jbo.RowMatchBindValueSupplier;
import oracle.jbo.RowReadXMLException;
import oracle.jbo.RowSet;
import oracle.jbo.RowSetIterator;
import oracle.jbo.RowSetManagementListener;
import oracle.jbo.SQLStmtException;
import oracle.jbo.SortCriteria;
import oracle.jbo.StructureDef;
import oracle.jbo.TooManyObjectsException;
import oracle.jbo.ValidationException;
import oracle.jbo.Variable;
import oracle.jbo.VariableValueManager;
import oracle.jbo.ViewCriteria;
import oracle.jbo.ViewCriteriaManager;
import oracle.jbo.ViewCriteriaRow;
import oracle.jbo.ViewLink;
import oracle.jbo.ViewObject;
import oracle.jbo.XMLInterface;
import oracle.jbo.common.Diagnostic;
import oracle.jbo.common.EventGroup;
import oracle.jbo.common.InstrumentedEvent;
import oracle.jbo.common.JboEnvUtil;
import oracle.jbo.common.JboNameUtil;
import oracle.jbo.common.JboXMLUtil;
import oracle.jbo.common.NamedObjectImpl;
import oracle.jbo.common.RowSetIteratorHelper;
import oracle.jbo.common.SvcMsgIteratorState;
import oracle.jbo.common.ViewObjectDynAttr;
import oracle.jbo.common.ViewObjectSubclassDef;
import oracle.jbo.common.WeakHashlist;
import oracle.jbo.common.WeakHashtable;
import oracle.jbo.common.WeakVector;
import oracle.jbo.common.ws.WSRowSetIteratorMarshaller;
import oracle.jbo.common.ws.WSRowSetMarshaller;
import oracle.jbo.domain.DomainAttributeDef;
import oracle.jbo.domain.NullValue;
import oracle.jbo.server.ApplicationModuleDefImpl;
import oracle.jbo.server.ApplicationModuleImpl;
import oracle.jbo.server.Association;
import oracle.jbo.server.AssociationDefImpl;
import oracle.jbo.server.AssociationEnd;
import oracle.jbo.server.AttributeDefImpl;
import oracle.jbo.server.AttributeListImpl;
import oracle.jbo.server.ComponentObjectImpl;
import oracle.jbo.server.DBTransaction;
import oracle.jbo.server.DBTransactionImpl;
import oracle.jbo.server.DefObject;
import oracle.jbo.server.Entity;
import oracle.jbo.server.EntityAssociation;
import oracle.jbo.server.EntityAssociationReference;
import oracle.jbo.server.EntityCache;
import oracle.jbo.server.EntityDefImpl;
import oracle.jbo.server.EntityEvent;
import oracle.jbo.server.EntityImpl;
import oracle.jbo.server.EntityListener;
import oracle.jbo.server.EntityReference;
import oracle.jbo.server.EntityRowSetImpl;
import oracle.jbo.server.IteratorStateHolder;
import oracle.jbo.server.MapInfo;
import oracle.jbo.server.MetaObjectManager;
import oracle.jbo.server.NullDBTransactionImpl;
import oracle.jbo.server.QueryCollection;
import oracle.jbo.server.RowFilter;
import oracle.jbo.server.RowFilterKey;
import oracle.jbo.server.RowQualifier;
import oracle.jbo.server.RowSetImpl;
import oracle.jbo.server.RowSetStateHolder;
import oracle.jbo.server.SQLBuilder;
import oracle.jbo.server.StmtWithBindVars;
import oracle.jbo.server.TransactionEvent;
import oracle.jbo.server.TransactionListener;
import oracle.jbo.server.TransactionPostListener;
import oracle.jbo.server.ViewAttributeDefImpl;
import oracle.jbo.server.ViewCriteriaAdapter;
import oracle.jbo.server.ViewCriteriaManagerImpl;
import oracle.jbo.server.ViewDefImpl;
import oracle.jbo.server.ViewLinkAccessorInfo;
import oracle.jbo.server.ViewLinkDefImpl;
import oracle.jbo.server.ViewLinkImpl;
import oracle.jbo.server.ViewRowImpl;
import oracle.jbo.server.ViewRowSetImpl;
import oracle.jbo.server.ViewRowSetIteratorImpl;
import oracle.jbo.server.ViewRowStorage;
import oracle.jbo.server.ViewUsageHelper;
import oracle.jbo.server.XmlDocumentReader;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XMLElement;
import oracle.xml.parser.v2.XSLStylesheet;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.traversal.DocumentTraversal;
import org.w3c.dom.traversal.NodeFilter;
import org.w3c.dom.traversal.NodeIterator;

public class ViewObjectImpl
extends ComponentObjectImpl
implements RowMatchBindValueSupplier,
ViewCriteriaManager,
ViewObjectDynAttr,
WSRowSetIteratorMarshaller,
WSRowSetMarshaller,
TransactionPostListener,
TransactionListener,
EntityListener,
ViewObject {
    public static final byte FETCH_AS_NEEDED = 0;
    public static final byte FETCH_ALL = 1;
    public static final byte FETCH_DEFAULT = 2;
    public static final int FULLSQL_MODE_NO_AUGMENTATION = 0;
    public static final int FULLSQL_MODE_AUGMENTATION = 1;
    public static final String XML_ELEM_PASSIVATE_TRANSIENT = "PASSIVATE_TRANSIENT_VALUE";
    protected ViewDefImpl mViewDef;
    private boolean mIsNameGenerated;
    private boolean mIsInternal;
    protected ArrayList mAssocRefs;
    protected String mOptimizerHint;
    protected String mAssocFromClause;
    protected String mAssocClause;
    protected String mUserDefinedQuery;
    protected String mOrderBy;
    private String mSortBy;
    private SortCriteria[] mSortCriteria;
    protected String mWhere;
    private boolean mNestedSelectForFullSql;
    private int mViewLinkAccessorRetained;
    private RowMatch mRowQualifier;
    private RowMatch mRowMatchFromViewCriteria;
    protected ViewRowSetImpl mViewRowSet;
    protected ViewAttributeDefImpl[] mAttrDefs;
    protected int mChgAttrIndUseCount;
    protected int[] mChangedAttrIndices;
    protected HashMap mAttrDefsTab;
    protected ViewAttributeDefImpl[] mKeyAttrRefs;
    protected HashMap mAttrDefsForExtendedVOs;
    protected boolean mAutoPostChanges;
    boolean mKeyModified;
    boolean bPassivate;
    private int mMaxFetchSize;
    private int mQueryMode;
    private ArrayList mSrcAttributes;
    private ArrayList mSrcViewLinks;
    private ArrayList mDstAttributes;
    private int mDynAttrCount;
    private int mDynAttrOffset;
    private WeakHashlist mQCs;
    private ViewCriteriaManagerImpl mCriteriaManager;
    private int mQueryChanged;
    private WeakVector mRowSets;
    private WeakHashtable mRowSetMap;
    private ArrayList mUserRowSets;
    private int mRowSetId;
    private byte mFetchMode;
    short mFetchSize;
    private long mSignature;
    private HashMap mProxyClassNames;
    private HashMap mRowProxyClassNames;
    private ArrayList mFreedStmts;
    private boolean mPrepareRollback;
    private boolean mListenToEntityEvents;
    private int mEventPropagation;
    private HashMap mDirtyQCs;
    private int mBindingStyle;
    private int mFullSqlMode;
    private int mInitSQLStmtBufLen;
    private ViewLinkAccessorInfo mViewLinkAccessorInfo;
    private int[] mFKeyMap;
    private ViewRowSetImpl mByKeyFinderRS;
    private boolean mManageRowsByKey;
    private boolean mAllWhereFragments;
    private boolean mDefaultAssocConsistent;
    private int mNonEquiJoinVLCount;
    private int[] mDiscrColLoadIndices;
    private boolean mIsForScan;
    private AttributeDef[] mScanRowFilterAttributeDefs;
    private HashMap mSubclassDefs;
    boolean mCreatingEntities;
    private RowComparator mRowComparator;
    private int mQueryTimeOut;
    protected static final String QC_TAG = "QC";
    protected static final String NEW_ROW_TRACKER = "NR";
    protected static final String NEW_ROW_INDEX = "Idx";
    protected static final String TRANSIENT_DATA_ROWTAG = "Tr";
    protected static final String DATA_ROWKEYTAG = "Ke";
    protected static final String NEW_ROW_HANDLE = "Hdl";
    public static boolean mUsePersColl = true;
    public static int mDefaultMaxRowsPerNode = 70;
    public static int mDefaultMaxActiveNodes = 30;
    public static final int MIN_ROWS_PER_NODE = 5;
    public static final int MIN_ACTIVE_NODES = 2;
    static final int ATTR_TAB_CREATE_THRESHOLD = 15;
    static int EVENT_PROPAGATION_UPDATE = 1;
    static int EVENT_PROPAGATION_REMOVE = 2;
    private static final int QUERY_CHANGED = 1;
    private static final int QUERY_CHANGED_WHERE = 2;
    private static final int QUERY_CHANGED_VIEW_CRITERIA = 4;
    private static final int QUERY_CHANGED_ORDER_BY = 8;
    private static final int QUERY_CHANGED_RECALC_DFLT_ASSOC_CONS = 4096;
    ArrayList mTransActivatedNewRows;
    private static /* synthetic */ Class class$oracle$jbo$CSMessageBundle;
    private static /* synthetic */ Class class$oracle$jbo$RowIterator;
    private static /* synthetic */ Class class$oracle$jbo$server$ViewRowImpl;
    private static /* synthetic */ Class class$oracle$jbo$server$RetainAccessorDomain;
    private static /* synthetic */ Class class$oracle$jbo$server$ViewDefImpl;

    private /* synthetic */ void $init$() {
        this.mIsNameGenerated = false;
        this.mIsInternal = false;
        this.mAssocRefs = new ArrayList(4);
        this.mNestedSelectForFullSql = true;
        this.mViewLinkAccessorRetained = -1;
        this.mAttrDefs = null;
        this.mChgAttrIndUseCount = 0;
        this.mChangedAttrIndices = null;
        this.mAttrDefsTab = null;
        this.mKeyAttrRefs = null;
        this.mAttrDefsForExtendedVOs = null;
        this.mAutoPostChanges = false;
        this.mKeyModified = false;
        this.bPassivate = true;
        this.mMaxFetchSize = -1;
        this.mQueryMode = 4;
        this.mSrcAttributes = null;
        this.mSrcViewLinks = null;
        this.mDstAttributes = null;
        this.mDynAttrCount = 0;
        this.mDynAttrOffset = -1;
        this.mQCs = new WeakHashlist(4);
        this.mCriteriaManager = null;
        this.mQueryChanged = 0;
        this.mRowSets = new WeakVector(4);
        this.mRowSetMap = new WeakHashtable(4);
        this.mUserRowSets = new ArrayList(4);
        this.mRowSetId = 0;
        this.mFetchMode = 0;
        this.mFetchSize = 1;
        this.mSignature = 0L;
        this.mProxyClassNames = new HashMap(3);
        this.mRowProxyClassNames = new HashMap(3);
        this.mFreedStmts = new ArrayList();
        this.mPrepareRollback = false;
        this.mListenToEntityEvents = true;
        this.mEventPropagation = 0;
        this.mDirtyQCs = new HashMap(4);
        this.mBindingStyle = -1;
        this.mFullSqlMode = 0;
        this.mInitSQLStmtBufLen = -1;
        this.mViewLinkAccessorInfo = null;
        this.mFKeyMap = null;
        this.mByKeyFinderRS = null;
        this.mManageRowsByKey = false;
        this.mAllWhereFragments = true;
        this.mDefaultAssocConsistent = true;
        this.mNonEquiJoinVLCount = 0;
        this.mDiscrColLoadIndices = null;
        this.mIsForScan = false;
        this.mScanRowFilterAttributeDefs = null;
        this.mSubclassDefs = null;
        this.mCreatingEntities = false;
        this.mQueryTimeOut = -1;
        this.mTransActivatedNewRows = null;
    }

    public ViewObjectImpl() {
        this(null, null);
    }

    public ViewObjectImpl(String string, ViewDefImpl viewDefImpl) {
        this.$init$();
        this.mSignature = System.currentTimeMillis();
        if (string != null) {
            this.setName(string);
        }
    }

    public final Object getSyncLock() {
        ApplicationModule applicationModule = this.getApplicationModule();
        if (applicationModule == null) {
            throw new InvalidObjAccessException(111, this.getName());
        }
        return applicationModule.getSyncLock();
    }

    public final boolean isNameGenerated() {
        return this.mIsNameGenerated;
    }

    final void setNameGenerated(boolean bl) {
        this.mIsNameGenerated = bl;
    }

    public final boolean isInternal() {
        return this.mIsInternal;
    }

    final void setInternal(boolean bl) {
        this.mIsInternal = bl;
    }

    public Object getProperty(String string) {
        Object object = null;
        if (this.mProperties != null) {
            object = this.mProperties.get((Object)string);
        }
        if (object == null) {
            object = this.getViewDef().getProperty(string);
        }
        return object;
    }

    public HashMap getPropertiesMap() {
        HashMap hashMap = super.getPropertiesMap();
        HashMap hashMap2 = ((NamedObjectImpl)this.getViewDef()).getPropertiesMap();
        HashMap hashMap3 = null;
        if (hashMap2 != null) {
            hashMap3 = (HashMap)hashMap2.clone();
        }
        if (hashMap == null) {
            return hashMap3;
        }
        if (hashMap3 == null) {
            return hashMap;
        }
        Iterator iterator = hashMap.keySet().iterator();
        while (iterator.hasNext()) {
            Object object = iterator.next();
            hashMap3.put(object, hashMap.get(object));
        }
        return hashMap3;
    }

    public final ApplicationModule getApplicationModule() {
        NamedObjectImpl namedObjectImpl = this.getParent();
        if (namedObjectImpl instanceof ApplicationModuleImpl) {
            return (ApplicationModuleImpl)namedObjectImpl;
        }
        return null;
    }

    public String getDefName() {
        String string;
        ViewDefImpl viewDefImpl = (ViewDefImpl)this.getDef();
        if (viewDefImpl == null) {
            Class clazz = class$oracle$jbo$server$ViewDefImpl;
            if (clazz == null) {
                clazz = class$oracle$jbo$server$ViewDefImpl = ViewObjectImpl.class$("oracle.jbo.server.ViewDefImpl");
            }
            string = JboNameUtil.getLastPartOfName(clazz.getName());
        } else {
            string = viewDefImpl.getName();
        }
        return string;
    }

    public String getDefFullName() {
        String string;
        ViewDefImpl viewDefImpl = (ViewDefImpl)this.getDef();
        if (viewDefImpl == null) {
            Class clazz = class$oracle$jbo$server$ViewDefImpl;
            if (clazz == null) {
                clazz = class$oracle$jbo$server$ViewDefImpl = ViewObjectImpl.class$("oracle.jbo.server.ViewDefImpl");
            }
            string = clazz.getName();
        } else {
            string = viewDefImpl.getFullName();
        }
        return string;
    }

    protected ViewDefImpl getViewDef() {
        return this.mViewDef;
    }

    DefObject getDef() {
        return this.getViewDef();
    }

    void setDef(DefObject defObject) {
        if (this.mViewDef == defObject) {
            return;
        }
        super.setDef(defObject);
        if (this.mViewDef != defObject) {
            this.resetState();
        }
        if (defObject == null) {
            this.mAssocRefs.clear();
            this.mAttrDefs = null;
            this.mChangedAttrIndices = null;
            this.mAttrDefsTab = null;
            this.mSrcAttributes = null;
            this.mSrcViewLinks = null;
            this.mDstAttributes = null;
            this.mQCs = null;
            this.clearViewCriterias();
            Locale locale = this.getApplicationModule().getSession().getLocale();
            this.mViewDef.removeResourceBundle(locale);
        }
        this.mViewDef = (ViewDefImpl)defObject;
        if (defObject != null) {
            this.initFromDef();
        } else {
            this.resetDefaultAssocConsistent();
        }
    }

    protected void initFromDef() {
        String[] stringArray;
        this.mFetchMode = this.mViewDef.getFetchMode();
        this.mFetchSize = this.mViewDef.getFetchSize();
        this.mMaxFetchSize = this.mViewDef.getMaxFetchSize();
        this.mOptimizerHint = this.mViewDef.getQueryHint();
        this.mManageRowsByKey = this.mViewDef.isManageRowsByKey();
        this.bPassivate = this.mViewDef.isPassivationEnabled();
        boolean bl = false;
        if (this.mWhere != null) {
            this.mWhere = null;
            bl = true;
        }
        if (this.mOrderBy != null) {
            this.mOrderBy = null;
            bl = true;
        }
        if ((stringArray = this.getApplyViewCriteriaNames()) != null && stringArray.length > 0) {
            bl = true;
        }
        this.clearViewCriterias();
        this.setQueryMode(0);
        if (bl) {
            this.setQueryAsChanged(true);
        }
        this.resetDefaultAssocConsistent();
    }

    void resetState() {
        DBTransaction dBTransaction;
        if (this.mRowSets.size() > 0) {
            int n = 0;
            while (n < this.mRowSets.size()) {
                ViewRowSetImpl viewRowSetImpl = (ViewRowSetImpl)this.mRowSets.elementAt(n);
                if (viewRowSetImpl != null) {
                    viewRowSetImpl.close();
                }
                ++n;
            }
            if (this.mViewRowSet != null) {
                this.mViewRowSet.setDefaultRS(false);
                this.mViewRowSet = null;
            }
            this.mDirtyQCs.clear();
            this.mRowSets.removeAllElements();
            this.mRowSetMap.clear();
            this.mUserRowSets.clear();
            this.clearQueryCollectionCache();
            this.closeStatements();
        }
        if (this.mViewDef != null && this.mRowSets.size() == 0 && (dBTransaction = this.getDBTransaction()) != null && !(dBTransaction instanceof NullDBTransactionImpl)) {
            dBTransaction.removeTransactionListener(this);
            dBTransaction.removeTransactionPostListener(this);
            this.removeEntityListeners();
        }
    }

    public ViewAttributeDefImpl[] getViewAttributeDefImpls() {
        this.initViewAttributeDefImpls();
        return this.mAttrDefs;
    }

    public ViewLink[] getViewLinks() {
        return (ViewLink[])this.mAssocRefs.toArray((Object[])new ViewLink[this.mAssocRefs.size()]);
    }

    public String[] getViewLinkNames() {
        ViewLink[] viewLinkArray = this.getViewLinks();
        String[] stringArray = new String[viewLinkArray.length];
        int n = 0;
        while (n < viewLinkArray.length) {
            stringArray[n] = viewLinkArray[n].getName();
            ++n;
        }
        return stringArray;
    }

    void addEntityAssocAttrs(AssociationDefImpl associationDefImpl, boolean bl) {
        AttributeDefImpl[] attributeDefImplArray;
        AttributeDefImpl[] attributeDefImplArray2;
        ViewAttributeDefImpl[] viewAttributeDefImplArray = this.getViewAttributeDefImpls();
        AttributeDefImpl[] attributeDefImplArray3 = attributeDefImplArray2 = !bl ? associationDefImpl.getAttributeDefImpls() : associationDefImpl.getOtherAttributeDefImpls();
        if (attributeDefImplArray2 != null) {
            int n = 0;
            while (n < attributeDefImplArray2.length) {
                int n2 = 0;
                while (n2 < viewAttributeDefImplArray.length) {
                    if (viewAttributeDefImplArray[n2].getAttributeDefImpl() == attributeDefImplArray2[n]) {
                        if (this.mSrcAttributes == null) {
                            this.mSrcAttributes = new ArrayList(3);
                            this.mSrcViewLinks = new ArrayList(3);
                        }
                        this.mSrcAttributes.add((Object)viewAttributeDefImplArray[n2]);
                        this.mSrcViewLinks.add(null);
                    }
                    ++n2;
                }
                ++n;
            }
        }
        AttributeDefImpl[] attributeDefImplArray4 = attributeDefImplArray = !bl ? associationDefImpl.getOtherAttributeDefImpls() : associationDefImpl.getAttributeDefImpls();
        if (attributeDefImplArray != null) {
            int n = 0;
            while (n < attributeDefImplArray.length) {
                int n3 = 0;
                while (n3 < viewAttributeDefImplArray.length) {
                    if (viewAttributeDefImplArray[n3].getAttributeDefImpl() == attributeDefImplArray[n]) {
                        if (this.mDstAttributes == null) {
                            this.mDstAttributes = new ArrayList(3);
                        }
                        this.mDstAttributes.add((Object)viewAttributeDefImplArray[n3]);
                    }
                    ++n3;
                }
                ++n;
            }
        }
    }

    void addViewLinkAttrs(ViewLinkImpl viewLinkImpl, ViewLinkDefImpl viewLinkDefImpl, boolean bl) {
        AttributeDefImpl[] attributeDefImplArray;
        AttributeDefImpl[] attributeDefImplArray2;
        AttributeDefImpl[] attributeDefImplArray3 = attributeDefImplArray2 = !bl ? viewLinkDefImpl.getAttributeDefImpls() : viewLinkDefImpl.getOtherAttributeDefImpls();
        if (attributeDefImplArray2 != null) {
            int n = 0;
            while (n < attributeDefImplArray2.length) {
                if (this.mSrcAttributes == null) {
                    this.mSrcAttributes = new ArrayList(3);
                    this.mSrcViewLinks = new ArrayList(3);
                }
                this.mSrcAttributes.add((Object)attributeDefImplArray2[n]);
                this.mSrcViewLinks.add((Object)viewLinkImpl);
                ++n;
            }
        }
        AttributeDefImpl[] attributeDefImplArray4 = attributeDefImplArray = !bl ? viewLinkDefImpl.getOtherAttributeDefImpls() : viewLinkDefImpl.getAttributeDefImpls();
        if (attributeDefImplArray != null) {
            int n = 0;
            while (n < attributeDefImplArray.length) {
                if (this.mDstAttributes == null) {
                    this.mDstAttributes = new ArrayList(3);
                }
                this.mDstAttributes.add((Object)attributeDefImplArray[n]);
                ++n;
            }
        }
    }

    protected void addViewLink(ViewLinkImpl viewLinkImpl, boolean bl) {
        if (!this.mAssocRefs.contains((Object)viewLinkImpl)) {
            this.mAssocRefs.add((Object)viewLinkImpl);
            if (viewLinkImpl.getDestination() == this) {
                boolean bl2;
                ViewObjectImpl viewObjectImpl = (ViewObjectImpl)viewLinkImpl.getSource();
                this.addViewLinkAttrs(viewLinkImpl, viewLinkImpl.getViewLinkDef(), bl);
                this.setQueryChanged(true);
                this.mAssocClause = null;
                if (viewObjectImpl != null && this.mViewRowSet != null) {
                    this.mViewRowSet.setMasterRSI(viewObjectImpl.getDefaultRowSet().getDefaultRowSetIterator(), false);
                }
                if (!(bl2 = viewLinkImpl.getViewLinkDef().isEquiJoin())) {
                    ++this.mNonEquiJoinVLCount;
                }
                this.setDefaultAssocConsistent(this.mDefaultAssocConsistent && bl2);
            }
        }
    }

    void removeViewLink(ViewLinkImpl viewLinkImpl, boolean bl) {
        ViewAttributeDefImpl viewAttributeDefImpl;
        if (viewLinkImpl.getDestination() == this && bl) {
            AttributeDefImpl[] attributeDefImplArray;
            AttributeDefImpl[] attributeDefImplArray2 = viewLinkImpl.getViewLinkDef().getAttributeDefImpls();
            if (attributeDefImplArray2 != null) {
                int n = 0;
                while (n < attributeDefImplArray2.length) {
                    int n2;
                    if (this.mSrcAttributes != null && this.mSrcAttributes.contains((Object)attributeDefImplArray2[n]) && (n2 = this.mSrcAttributes.indexOf((Object)attributeDefImplArray2[n])) >= 0) {
                        this.mSrcAttributes.remove(n2);
                        this.mSrcViewLinks.remove(n2);
                    }
                    ++n;
                }
            }
            if ((attributeDefImplArray = viewLinkImpl.getViewLinkDef().getOtherAttributeDefImpls()) != null) {
                int n = 0;
                while (n < attributeDefImplArray.length) {
                    if (this.mDstAttributes != null && this.mDstAttributes.contains((Object)attributeDefImplArray[n])) {
                        this.mDstAttributes.remove((Object)attributeDefImplArray[n]);
                    }
                    ++n;
                }
            }
            this.setQueryChanged(true);
            this.mAssocClause = null;
            int n = 0;
            while (n < this.mRowSets.size()) {
                ViewRowSetImpl viewRowSetImpl = (ViewRowSetImpl)this.mRowSets.elementAt(n);
                if (viewRowSetImpl != null) {
                    viewRowSetImpl.removeUnusedMasterRowSetIterators(viewLinkImpl);
                }
                ++n;
            }
        }
        if (bl && (viewAttributeDefImpl = (ViewAttributeDefImpl)viewLinkImpl.getSourceAccessor()) != null && viewAttributeDefImpl.getParent() == this) {
            this.removeAttrDef(viewAttributeDefImpl);
        }
        if (this.mAssocRefs != null) {
            this.mAssocRefs.remove((Object)viewLinkImpl);
            if (!viewLinkImpl.getViewLinkDef().isEquiJoin()) {
                --this.mNonEquiJoinVLCount;
            }
            this.resetDefaultAssocConsistent();
        }
    }

    public boolean isReadOnly() {
        return this.mViewDef.isReadOnly() && this.getDynamicAttributeCount() == 0;
    }

    public QueryCollection getQueryCollection() {
        return this.getDefaultRowSet().getQueryCollection();
    }

    public boolean hasDefaultRowSet() {
        return this.mViewRowSet != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ViewRowSetImpl getDefaultRowSet() {
        if (this.mViewRowSet == null) {
            Object object = this.getSyncLock();
            synchronized (object) {
                if (this.mViewRowSet == null) {
                    this.mViewRowSet = this.createViewRowSet(this.getName(), true);
                }
            }
        }
        return this.mViewRowSet;
    }

    public int getQueryTimeOut() {
        return this.mQueryTimeOut;
    }

    public void setQueryTimeOut(int n) {
        this.mQueryTimeOut = n;
    }

    public boolean cancelQuery() {
        return this.getDefaultRowSet().cancelQuery();
    }

    public String getWhereClause() {
        return this.mWhere;
    }

    public void addWhereClause(String string) {
        if ((string = JboNameUtil.fastTrim(string)) == null || string.length() == 0) {
            return;
        }
        if (this.mWhere != null) {
            this.setWhereClause(this.mWhere + " " + string);
        } else {
            this.setWhereClause(string);
        }
    }

    public void setWhereClause(String string) {
        string = JboNameUtil.fastTrim(string);
        if (!(this.mWhere != null && this.mWhere.length() != 0 || string != null && string.length() != 0)) {
            return;
        }
        if (string == null || !string.equals(this.mWhere)) {
            this.mWhere = string;
            if (this.mFullSqlMode == 0) {
                this.mUserDefinedQuery = null;
            }
            this.setQueryAsChanged(4098);
        }
    }

    public RowQualifier getRowQualifier() {
        return (RowQualifier)this.getRowMatch();
    }

    public void setRowQualifier(RowQualifier rowQualifier) {
        this.setRowMatch(rowQualifier);
    }

    public RowMatch getRowMatch() {
        return this.mRowQualifier;
    }

    public void setRowMatch(RowMatch rowMatch) {
        if (rowMatch == null ? this.mRowQualifier == null : rowMatch.equals(this.mRowQualifier)) {
            return;
        }
        this.mRowQualifier = rowMatch;
        this.setQueryAsChanged(true);
    }

    public RowMatch getRowMatchFromViewCriteria() {
        return this.mRowMatchFromViewCriteria;
    }

    protected void setRowMatchFromViewCriteria(RowMatch rowMatch) {
        this.mRowMatchFromViewCriteria = rowMatch;
    }

    protected boolean rowQualifies(ViewRowImpl viewRowImpl) {
        RowMatch rowMatch = this.getRowMatch();
        if (rowMatch != null && !rowMatch.rowQualifies(viewRowImpl)) {
            return false;
        }
        rowMatch = this.getRowMatchFromViewCriteria();
        return rowMatch == null || rowMatch.rowQualifies(viewRowImpl);
    }

    public String getOrderByClause() {
        return this.mOrderBy;
    }

    public void addOrderByClause(String string) {
        if ((string = JboNameUtil.fastTrim(string)) == null || string.length() == 0) {
            return;
        }
        if (this.mOrderBy != null) {
            this.setOrderByClause(this.mOrderBy + ", " + string);
        } else {
            this.setOrderByClause(string);
        }
    }

    public void setOrderByClause(String string) {
        string = JboNameUtil.fastTrim(string);
        if (!(this.mOrderBy != null && this.mOrderBy.length() != 0 || string != null && string.length() != 0)) {
            return;
        }
        if (string != null && string.length() == 0) {
            string = null;
        }
        if (string == null || !string.equals(this.mOrderBy)) {
            this.mOrderBy = string;
            if (this.mFullSqlMode == 0) {
                this.mUserDefinedQuery = null;
            }
            this.setQueryAsChanged(8);
        }
    }

    public String getSortBy() {
        return this.mSortBy;
    }

    public void setSortBy(String string) {
        string = JboNameUtil.fastTrim(string);
        if (!(this.mSortBy != null && this.mSortBy.length() != 0 || string != null && string.length() != 0)) {
            return;
        }
        if (string != null && string.length() == 0) {
            string = null;
        }
        if (string == null || !string.equals(this.mSortBy)) {
            this.mSortBy = string;
            this.mSortCriteria = null;
            this.setQueryAsChanged(true);
        }
    }

    protected void processSortCriteria() {
        if (this.mSortCriteria == null) {
            if (this.mSortBy != null && this.mSortBy.length() > 0) {
                this.mSortCriteria = JboEnvUtil.parseSortBy(this.mSortBy);
                if (this.mSortCriteria.length == 0) {
                    this.mSortCriteria = null;
                }
            }
            this.mRowComparator = null;
        }
    }

    public SortCriteria[] getSortCriteria() {
        return this.mSortCriteria;
    }

    public Object[] getWhereClauseParams() {
        return this.getDefaultRowSet().getWhereClauseParams();
    }

    public boolean isExecuted() {
        return this.getDefaultRowSet().isExecuted();
    }

    public void setWhereClauseParams(Object[] objectArray) {
        this.getDefaultRowSet().setWhereClauseParams(objectArray);
    }

    public void refreshWhereClauseParams() {
        this.getDefaultRowSet().refreshWhereClauseParams();
    }

    public void defineNamedWhereClauseParam(String string, Object object, int[] nArray) {
        this.getDefaultRowSet().defineNamedWhereClauseParam(string, object, nArray);
    }

    public void removeNamedWhereClauseParam(String string) {
        this.getDefaultRowSet().removeNamedWhereClauseParam(string);
    }

    public Object getNamedWhereClauseParam(String string) {
        return this.getDefaultRowSet().getNamedWhereClauseParam(string);
    }

    public void setNamedWhereClauseParam(String string, Object object) {
        this.getDefaultRowSet().setNamedWhereClauseParam(string, object);
    }

    public void skipNamedWhereClauseParam(String string) {
        this.getDefaultRowSet().skipNamedWhereClauseParam(string);
    }

    public void setWhereClauseParam(int n, Object object) {
        this.getDefaultRowSet().setWhereClauseParam(n, object);
    }

    public void setNamedWhereClauseParams(AttributeList attributeList) {
        this.getDefaultRowSet().setNamedWhereClauseParams(attributeList);
    }

    public AttributeList getNamedWhereClauseParams() {
        return this.getDefaultRowSet().getNamedWhereClauseParams();
    }

    String getFullAttributeDefImplName(int n) {
        return this.getViewDef() == null ? null : this.getViewDef().getFullAttributeDefImplName(n);
    }

    String getFullAttributeDefImplName(ViewAttributeDefImpl viewAttributeDefImpl) {
        return this.getViewDef() == null ? null : this.getViewDef().getFullAttributeDefImplName(viewAttributeDefImpl);
    }

    public DBTransaction getDBTransaction() {
        return this.getRootApplicationModule().getDBTransaction();
    }

    DBTransactionImpl getDBTransactionImpl() {
        return this.getRootApplicationModule().getDBTransactionImpl();
    }

    SQLBuilder getSQLBuilder() {
        return this.getDBTransactionImpl().getSQLBuilder();
    }

    public int getFullSqlMode() {
        return this.mFullSqlMode;
    }

    public void setFullSqlMode(int n) {
        this.mFullSqlMode = n;
        this.setQueryAsChanged(true);
    }

    boolean isFullSql() {
        if (this.mUserDefinedQuery != null && this.mFullSqlMode == 1) {
            return true;
        }
        return this.mViewDef.isFullSql();
    }

    StmtWithBindVars getQueryStmt(int n) {
        if (this.mUserDefinedQuery != null && this.mFullSqlMode == 1) {
            return new StmtWithBindVars(this.mUserDefinedQuery, n);
        }
        return this.mViewDef.getQueryStmt(n);
    }

    public String getUserDefinedQuery() {
        if (this.mUserDefinedQuery != null) {
            return this.mUserDefinedQuery;
        }
        return null;
    }

    public void setNestedSelectForFullSql(boolean bl) {
        this.mNestedSelectForFullSql = bl;
    }

    void processViewLinkAccessors() {
        ViewAttributeDefImpl[] viewAttributeDefImplArray = this.getViewAttributeDefImpls();
        int n = 0;
        while (n < viewAttributeDefImplArray.length) {
            String string;
            ViewAttributeDefImpl viewAttributeDefImpl;
            ViewAttributeDefImpl viewAttributeDefImpl2 = viewAttributeDefImplArray[n];
            byte by = viewAttributeDefImpl2.getAttributeKind();
            if ((by == 2 || by == 6) && (viewAttributeDefImpl = (ViewAttributeDefImpl)this.lookupAttributeDef(string = ViewObjectImpl.vlAccResultAttrName(viewAttributeDefImpl2))) == null) {
                viewAttributeDefImpl = (ViewAttributeDefImpl)this.addDynamicAttribute(string);
                Class clazz = class$oracle$jbo$server$RetainAccessorDomain;
                if (clazz == null) {
                    clazz = ViewObjectImpl.class$("oracle.jbo.server.RetainAccessorDomain");
                }
                viewAttributeDefImpl.mJavaType = clazz;
                this.setPassivatableTransientAttribute(viewAttributeDefImpl, true);
            }
            ++n;
        }
    }

    public boolean isViewLinkAccessorRetained() {
        return this.mViewLinkAccessorRetained == -1 ? this.getViewDef().isViewLinkAccessorRetained() : this.mViewLinkAccessorRetained == 1;
    }

    public void setViewLinkAccessorRetained(boolean bl) {
        int n = this.mViewLinkAccessorRetained = bl ? 1 : 0;
        if (bl) {
            this.processViewLinkAccessors();
        }
    }

    public String getQuery() {
        return this.buildQuery(this.getDefaultRowSet().getWhereClauseParams().length, false);
    }

    private int computeInitSQLStmtBufLen(int n, String string, String string2, StmtWithBindVars stmtWithBindVars) {
        String[] stringArray;
        int n2;
        ViewDefImpl viewDefImpl = this.getViewDef();
        int n3 = stmtWithBindVars != null ? stmtWithBindVars.mStmt.length() : string.length() + string2.length();
        n3 += 40;
        if (this.mOptimizerHint != null) {
            n3 += this.mOptimizerHint.length();
        }
        StmtWithBindVars stmtWithBindVars2 = viewDefImpl.getWhereClause(n);
        String string3 = stmtWithBindVars2.mStmt;
        if (string3 != null && (n2 = string3.length()) > 0) {
            n3 += 10 + n2;
        }
        if ((string3 = this.getWhereClause()) != null && (n2 = string3.length()) > 0) {
            n3 += 10 + n2;
        }
        if ((stringArray = this.getApplyViewCriteriaNames()) != null && stringArray.length > 0 && (string3 = this.getViewCriteriaClause(true)) != null) {
            n3 += 20 + string3.length();
        }
        if (this.mAssocRefs != null) {
            n3 += this.mAssocRefs.size() * 60;
        }
        if (!AssociationDefImpl.isAssocWhereEarlySet() && this.mViewLinkAccessorInfo != null && !this.mIsForScan) {
            AttributeDefImpl[] attributeDefImplArray;
            AssociationEnd associationEnd;
            AssociationEnd associationEnd2 = associationEnd = this.mViewLinkAccessorInfo.mViewLinkDef != null ? this.mViewLinkAccessorInfo.mViewLinkDef.getDestinationEnd() : this.mViewLinkAccessorInfo.mAccessorDef.getOtherAssociationEnd();
            if (associationEnd != null && (attributeDefImplArray = associationEnd.getAttributeDefImpls()) != null) {
                n3 += attributeDefImplArray.length * 60;
            }
        }
        if ((string3 = this.getOrderByClause()) != null && (n2 = string3.length()) > 0) {
            n3 += 10 + n2;
        } else {
            string3 = viewDefImpl.getOrderByClause();
            if (string3 != null && (n2 = string3.length()) > 0) {
                n3 += 10 + n2;
            }
        }
        return n3;
    }

    protected String buildQuery(int n, boolean bl) {
        if (this.mUserDefinedQuery != null && this.mFullSqlMode == 0) {
            if (Diagnostic.isOn()) {
                Diagnostic.println("ViewObject: " + this.mObjName + " UserDefined Query: " + this.mUserDefinedQuery);
            }
            return this.mUserDefinedQuery;
        }
        ViewDefImpl viewDefImpl = this.getViewDef();
        String string = viewDefImpl.getSelectClause();
        String string2 = this.buildFromClause();
        boolean bl2 = true;
        StmtWithBindVars stmtWithBindVars = null;
        if (this.isFullSql() || string == null || string.length() == 0 || string2 == null || string2.length() == 0) {
            bl2 = false;
            stmtWithBindVars = this.getQueryStmt(n);
            if (stmtWithBindVars.mStmt == null || stmtWithBindVars.mStmt.length() == 0) {
                return null;
            }
        }
        int n2 = this.mInitSQLStmtBufLen;
        boolean bl3 = false;
        if (n2 <= 0) {
            n2 = this.computeInitSQLStmtBufLen(n, string, string2, stmtWithBindVars);
            bl3 = true;
        }
        StringBuffer stringBuffer = new StringBuffer(n2);
        boolean bl4 = false;
        if (this.isFullSql()) {
            if (this.mNestedSelectForFullSql) {
                if (this.mOptimizerHint == null || bl) {
                    stringBuffer.append("SELECT * FROM (");
                } else {
                    bl4 = true;
                    stringBuffer.append("SELECT ").append("/*+ ").append(this.mOptimizerHint).append(" */ * FROM (");
                }
            }
            stringBuffer.append(stmtWithBindVars.mStmt);
            if (this.mNestedSelectForFullSql) {
                stringBuffer.append(") QRSLT ");
            }
            n = stmtWithBindVars.mNoBindVars;
        } else if (!bl2) {
            stringBuffer.append(stmtWithBindVars.mStmt);
            n = stmtWithBindVars.mNoBindVars;
        } else {
            stringBuffer.append("SELECT ");
            if (this.mOptimizerHint != null) {
                stringBuffer.append("/*+ ").append(this.mOptimizerHint).append(" */ ");
            }
            stringBuffer.append(string).append(" FROM ").append(string2);
        }
        bl4 |= this.buildWhereClause(stringBuffer, n);
        if (!bl) {
            bl4 |= this.buildOrderByClause(stringBuffer, this.getOrderByClause() == null ? viewDefImpl.getOrderByClause() : null);
            this.processSortCriteria();
        }
        String string3 = !bl4 && this.isFullSql() ? stmtWithBindVars.mStmt : stringBuffer.toString();
        int n3 = string3.length();
        this.mInitSQLStmtBufLen = n3 + 30;
        if (bl) {
            if (this.mOptimizerHint != null) {
                this.mInitSQLStmtBufLen += this.mOptimizerHint.length();
            }
            if (this.isFullSql()) {
                this.mInitSQLStmtBufLen += 30;
            }
        }
        if (Diagnostic.isOn()) {
            Diagnostic.println(this.getName() + ">#q " + (bl3 ? "computed" : "old") + " SQLStmtBufLen: " + n2 + ", actual=" + n3 + ", storing=" + this.mInitSQLStmtBufLen + (n3 > n2 ? " ACT > COMP (QRY)!!!" : ""));
        }
        if (!bl && this.getDefaultRowSet().isRangePaging()) {
            string3 = this.buildRangePagingQuery(string3, n);
        }
        if (Diagnostic.isOn()) {
            Diagnostic.println(string3);
        }
        return string3;
    }

    protected String buildRangePagingQuery(String string, int n) {
        if (this.getSQLBuilder().supportsRowNumQuery()) {
            return new StringBuffer(100 + string.length()).append("SELECT * FROM (SELECT /*+ FIRST_ROWS */ IQ.*, ROWNUM AS Z_R_N FROM (").append(string).append(") IQ  WHERE ROWNUM < :").append(Integer.toString(n++)).append(") WHERE Z_R_N > :").append(Integer.toString(n)).toString();
        }
        return string;
    }

    protected void bindRangePagingParams(PreparedStatement preparedStatement, int n, int n2, int n3) {
        if (this.getSQLBuilder().supportsRowNumQuery()) {
            if (Diagnostic.isOn()) {
                Diagnostic.println("setting rownum query between (" + n2 + ", " + (n2 + n3 + 3) + ")");
            }
            try {
                preparedStatement.setInt(n++, n2 + n3 + 3);
                preparedStatement.setInt(n, n2);
            }
            catch (SQLException sQLException) {
                Class clazz;
                try {
                    if (preparedStatement != null) {
                        preparedStatement.close();
                        preparedStatement = null;
                    }
                }
                catch (SQLException sQLException2) {
                    // empty catch block
                }
                if (Diagnostic.isOn()) {
                    Diagnostic.println("ViewUsageHelper.createViewAttributeDefImpls failed...");
                    Diagnostic.printStackTrace(sQLException);
                }
                if ((clazz = class$oracle$jbo$CSMessageBundle) == null) {
                    clazz = class$oracle$jbo$CSMessageBundle = ViewObjectImpl.class$("oracle.jbo.CSMessageBundle");
                }
                throw new SQLStmtException(clazz, "27122", this.getQuery(), sQLException);
            }
        }
    }

    public long getQueryHitCount(ViewRowSetImpl viewRowSetImpl) {
        return this.getQueryHitCount(viewRowSetImpl, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long getQueryHitCount(ViewRowSetImpl viewRowSetImpl, Row[] rowArray) {
        long l;
        int n;
        block14: {
            n = 0;
            String string = this.getSQLBuilder().getQueryHitCountSQL(viewRowSetImpl);
            if (string == null) {
                return 0L;
            }
            if (InstrumentedEvent.isActive) {
                n = InstrumentedEvent.startEvent(EventGroup.JDBC_SELECT, "getQueryHitCount for " + viewRowSetImpl.getName());
            }
            PreparedStatement preparedStatement = null;
            l = 0L;
            try {
                try {
                    if (Diagnostic.isOn()) {
                        Diagnostic.println(new StringBuffer("ViewObject: ").append(this.mObjName).append(" Estimated Row Count Query Statement:"));
                        Diagnostic.println(new StringBuffer("\"").append(string).append("\""));
                    }
                    preparedStatement = this.getDBTransaction().createPreparedStatement(string, 1);
                    this.setBindingStyleForStmt(preparedStatement);
                    this.getSQLBuilder().doPreparedStatementDefineColumnType(preparedStatement, 1, -5);
                    if (Diagnostic.isOn()) {
                        Diagnostic.println("Bind params for ViewObject.getQueryHitCount: " + this.getName());
                    }
                    this.bindParametersForCollection(null, viewRowSetImpl.getParametersAsStorageTypes(rowArray), preparedStatement);
                    ResultSet resultSet = preparedStatement.executeQuery();
                    resultSet.next();
                    l = resultSet.getLong(1);
                }
                catch (SQLException sQLException) {
                    Class clazz;
                    if (Diagnostic.isOn()) {
                        Diagnostic.println("ViewObjectImpl.getQueryHitCount failed...");
                        Diagnostic.printStackTrace(sQLException);
                    }
                    if ((clazz = class$oracle$jbo$CSMessageBundle) == null) {
                        clazz = class$oracle$jbo$CSMessageBundle = ViewObjectImpl.class$("oracle.jbo.CSMessageBundle");
                    }
                    throw new DMLException(clazz, "26044", new Object[]{this.getName(), string}, sQLException);
                }
                Object var12_8 = null;
                if (preparedStatement == null) break block14;
            }
            catch (Throwable throwable) {
                Object var12_9 = null;
                if (preparedStatement == null) throw throwable;
                try {
                    preparedStatement.close();
                    throw throwable;
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                throw throwable;
            }
            try {}
            catch (SQLException sQLException) {}
            preparedStatement.close();
        }
        if (Diagnostic.isOn()) {
            Diagnostic.println("ViewObject: " + this.getName() + " Estimated Row Count: " + l);
        }
        if (!InstrumentedEvent.isActive) return l;
        InstrumentedEvent.endEvent(n, "ViewObject: " + this.getName() + " Estimated Row Count: " + l);
        return l;
    }

    void buildFromClause(AssociationEnd associationEnd) {
        if (this.mAssocFromClause == null) {
            String string = this.buildFromClause();
            String string2 = associationEnd.getDBObjectName();
            String string3 = associationEnd.getAliasName();
            if (string3 != null && string.indexOf(string3) < 0) {
                StringBuffer stringBuffer = new StringBuffer(this.mAssocFromClause);
                if (stringBuffer.length() > 0) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(string2).append(" ").append(string3);
                this.mAssocFromClause = stringBuffer.toString();
            }
        }
    }

    protected String buildFromClause() {
        String string = this.mViewDef.getFromClause();
        if (this.mAssocRefs == null) {
            this.mAssocFromClause = "";
        }
        if (this.mAssocFromClause != null && this.mAssocFromClause.length() > 0) {
            string = string + ", " + this.mAssocFromClause;
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer("");
        int n = 0;
        while (n < this.mAssocRefs.size()) {
            ViewLinkImpl viewLinkImpl = (ViewLinkImpl)this.mAssocRefs.get(n);
            if (viewLinkImpl.getDestination() == this) {
                AssociationEnd associationEnd = viewLinkImpl.getViewLinkDef().getSourceEnd();
                String string2 = associationEnd.getDBObjectName();
                String string3 = associationEnd.getAliasName();
                if (string3 != null && string.indexOf(string3) < 0 && stringBuffer.toString().indexOf(string3) < 0) {
                    if (stringBuffer.length() > 0) {
                        stringBuffer.append(", ");
                    }
                    stringBuffer.append(string2).append(" ").append(string3);
                }
            }
            ++n;
        }
        this.mAssocFromClause = stringBuffer.toString();
        if (this.mAssocFromClause.length() > 0) {
            string = string + ", " + this.mAssocFromClause;
        }
        return string;
    }

    protected boolean buildWhereClause(StringBuffer stringBuffer, int n) {
        String string;
        boolean bl = true;
        String string2 = null;
        if (this.mAllWhereFragments) {
            StmtWithBindVars stmtWithBindVars = this.mViewDef.getWhereClause(n);
            string2 = stmtWithBindVars.mStmt;
            n = stmtWithBindVars.mNoBindVars;
            if (string2 != null && string2.length() > 0) {
                stringBuffer.append(bl ? " WHERE " : " AND ").append(string2);
                bl = false;
            }
        }
        if ((string = this.getWhereClause()) != null && string.length() > 0) {
            stringBuffer.append(bl ? " WHERE (" : " AND (").append(string).append(")");
            bl = false;
        }
        if (this.mAllWhereFragments) {
            string = this.getViewCriteriaClause(true);
            if (string != null && string.length() > 0) {
                stringBuffer.append(bl ? " WHERE (" : " AND (").append(string).append(")");
                bl = false;
            }
            this.processViewCriteriaForRowMatch();
            string = this.getAssociationClause(n);
            if (string != null && string.length() > 0) {
                stringBuffer.append(bl ? " WHERE " : " AND ").append(string);
                bl = false;
            }
        }
        this.recalcDefaultAssocConsistent();
        return bl ^ true;
    }

    void processCacheFilters() {
        this.processViewCriteriaForRowMatch();
        this.processSortCriteria();
    }

    void processViewCriteriaForRowMatch() {
        String string = this.getViewCriteriaClause(false);
        if (string != null && string.length() > 0) {
            if (Diagnostic.isOn()) {
                Diagnostic.println("VCs converted to RowMatch: " + string);
            }
            RowMatch rowMatch = new RowMatch(string);
            this.setRowMatchFromViewCriteria(rowMatch);
        } else {
            this.setRowMatchFromViewCriteria(null);
        }
    }

    protected boolean buildOrderByClause(StringBuffer stringBuffer, String string) {
        String string2;
        boolean bl = true;
        if (string != null && string.length() > 0) {
            stringBuffer.append(" ORDER BY ").append(string);
            bl = false;
        }
        if ((string2 = this.getOrderByClause()) != null && string2.length() > 0) {
            stringBuffer.append(bl ? " ORDER BY " : ", ").append(string2);
            bl = false;
        }
        return bl ^ true;
    }

    public void setQuery(String string) {
        int n = 0;
        while (n < this.mAssocRefs.size()) {
            ViewLinkImpl viewLinkImpl = (ViewLinkImpl)this.mAssocRefs.get(n);
            if (viewLinkImpl.getDestination() == this) {
                Class clazz = class$oracle$jbo$CSMessageBundle;
                if (clazz == null) {
                    clazz = class$oracle$jbo$CSMessageBundle = ViewObjectImpl.class$("oracle.jbo.CSMessageBundle");
                }
                throw new InvalidOperException(clazz, "26016", new Object[]{this.getName()});
            }
            ++n;
        }
        if (string != null && string.length() == 0) {
            string = null;
        }
        this.mUserDefinedQuery = string;
        this.setQueryAsChanged(true);
    }

    public Object[] getParametersAsStorageTypes() {
        return this.getDefaultRowSet().getParametersAsStorageTypes();
    }

    public Class getRowClass() {
        if (this.getViewDef() == null) {
            Class clazz = class$oracle$jbo$server$ViewRowImpl;
            if (clazz == null) {
                clazz = class$oracle$jbo$server$ViewRowImpl = ViewObjectImpl.class$("oracle.jbo.server.ViewRowImpl");
            }
            return clazz;
        }
        return this.getViewDef().getRowClass();
    }

    private ViewDefImpl findViewDefFromDiscrVals(ResultSet resultSet, AttributeList attributeList) {
        ViewDefImpl viewDefImpl = this.getViewDef();
        AttributeDefImpl[] attributeDefImplArray = viewDefImpl.getDiscrColumns();
        if (attributeDefImplArray == null || resultSet == null && attributeList == null || !viewDefImpl.hasExtendedDefObjects()) {
            return viewDefImpl;
        }
        Object[] objectArray = new Object[attributeDefImplArray.length];
        DBTransactionImpl dBTransactionImpl = this.getDBTransactionImpl();
        int[] nArray = this.getDiscrColLoadIndices();
        boolean bl = true;
        int n = 0;
        while (n < attributeDefImplArray.length) {
            ViewAttributeDefImpl viewAttributeDefImpl = (ViewAttributeDefImpl)attributeDefImplArray[n];
            if (resultSet != null) {
                int n2 = nArray[n];
                if (n2 >= 0) {
                    objectArray[n] = viewAttributeDefImpl.loadFromResultSet(resultSet, n2 + 1, dBTransactionImpl);
                }
            } else {
                Object object = attributeList.getAttribute(viewAttributeDefImpl.getName());
                if (object != null) {
                    objectArray[n] = object;
                }
            }
            if (objectArray[n] != null) {
                bl = false;
            }
            ++n;
        }
        ViewDefImpl viewDefImpl2 = (ViewDefImpl)viewDefImpl.findDefForDiscrValues(objectArray, true);
        if (viewDefImpl2 == null) {
            if (resultSet == null && bl) {
                viewDefImpl2 = viewDefImpl;
            } else {
                String string = null;
                if (Diagnostic.isOn()) {
                    string = "Discr values: ";
                    int n3 = 0;
                    while (n3 < objectArray.length) {
                        if (n3 > 0) {
                            string = string + ",";
                        }
                        string = string + objectArray[n3];
                        ++n3;
                    }
                    Diagnostic.println("ViewObjectImpl.findViewDefFromDiscrVals: returning null, no matching discrVals for " + this.getName());
                    Diagnostic.println("  " + string);
                }
                return null;
            }
        }
        return viewDefImpl2;
    }

    public ViewRowImpl createInstance(ViewRowSetImpl viewRowSetImpl, AttributeList attributeList) {
        ViewDefImpl viewDefImpl = this.findViewDefFromDiscrVals(null, attributeList);
        ViewRowImpl viewRowImpl = null;
        if (viewDefImpl == null) {
            viewDefImpl = this.getViewDef();
        }
        viewRowImpl = viewDefImpl.newInstance(null, null, this, viewRowSetImpl, attributeList);
        if (!viewDefImpl.isFinderView()) {
            viewRowSetImpl.initForeignKeyValues(viewRowImpl);
        }
        viewRowImpl.callCreate(attributeList);
        return viewRowImpl;
    }

    ViewRowImpl createInstanceWithEntities(int[] nArray, EntityImpl[] entityImplArray, ViewRowSetImpl viewRowSetImpl, AttributeList attributeList) {
        ViewDefImpl viewDefImpl = this.findViewDefFromDiscrVals(null, attributeList);
        ViewRowImpl viewRowImpl = null;
        if (viewDefImpl == null) {
            viewDefImpl = this.getViewDef();
        }
        if ((entityImplArray = (viewRowImpl = viewDefImpl.newInstance(nArray, entityImplArray, this, viewRowSetImpl, attributeList)).getEntities()) != null && (entityImplArray[0].getPostState() == 0 || entityImplArray[0].getPostState() == -1)) {
            viewRowImpl.callCreate(attributeList);
        }
        return viewRowImpl;
    }

    public ViewRowImpl createInstanceFromResultSet(QueryCollection queryCollection, ResultSet resultSet) {
        ViewRowImpl viewRowImpl = this.createRowFromResultSet(queryCollection, resultSet);
        if (viewRowImpl != null) {
            try {
                viewRowImpl.entityCacheAdd();
            }
            catch (DeadEntityAccessException deadEntityAccessException) {
                if (Diagnostic.isOn() && queryCollection.isRangePaging()) {
                    Diagnostic.println("*** Ignore deleted row error for range query.");
                }
                ViewRowImpl viewRowImpl2 = null;
                return viewRowImpl2;
            }
        }
        return viewRowImpl;
    }

    public ViewRowImpl createInstanceFromResultSet(QueryCollection queryCollection, ResultSet resultSet, boolean bl) {
        return this.createRowFromResultSet(queryCollection, resultSet, bl);
    }

    protected ViewRowImpl createNewRowForCollection(Object object) {
        ViewDefImpl viewDefImpl = this.getViewDef();
        return viewDefImpl.createBlankInstance(null, null, this, (QueryCollection)object, null, null, false);
    }

    protected void populateAttributeForRow(ViewRowImpl viewRowImpl, int n, Object object) {
        viewRowImpl.populateAttribute(n, object);
    }

    protected int[] getDiscrColLoadIndices() {
        AttributeDefImpl[] attributeDefImplArray = this.getViewDef().getDiscrColumns();
        if (attributeDefImplArray != null && this.mDiscrColLoadIndices == null) {
            this.mDiscrColLoadIndices = ViewObjectImpl.calcDiscrColLoadIndices(attributeDefImplArray, this.getAttributeDefs());
        }
        return this.mDiscrColLoadIndices;
    }

    static int[] calcDiscrColLoadIndices(AttributeDefImpl[] attributeDefImplArray, AttributeDef[] attributeDefArray) {
        int[] nArray = new int[attributeDefImplArray.length];
        int n = 0;
        while (n < attributeDefImplArray.length) {
            int n2 = 0;
            boolean bl = false;
            nArray[n] = -1;
            int n3 = 0;
            while (n3 < attributeDefArray.length) {
                AttributeDef attributeDef = attributeDefArray[n3];
                byte by = attributeDef.getAttributeKind();
                if ((by == 0 || by == 1) && attributeDef.isSelected()) {
                    if (attributeDef == attributeDefImplArray[n]) {
                        bl = true;
                        nArray[n] = n2;
                        break;
                    }
                    ++n2;
                } else if (attributeDef == attributeDefImplArray[n]) {
                    bl = true;
                    break;
                }
                ++n3;
            }
            if (!bl) {
                Diagnostic.ASSERT(false, "Discr attr " + attributeDefImplArray[n].getName() + " not found in the attr list");
            }
            ++n;
        }
        return nArray;
    }

    protected ViewRowImpl createRowFromResultSet(Object object, ResultSet resultSet) {
        if (resultSet == null) {
            return null;
        }
        ViewDefImpl viewDefImpl = this.findViewDefFromDiscrVals(resultSet, null);
        ViewRowImpl viewRowImpl = null;
        if (viewDefImpl == null) {
            viewDefImpl = this.getViewDef();
        }
        viewRowImpl = viewDefImpl.createInstanceFromResultSet(this, (QueryCollection)object, resultSet);
        return viewRowImpl;
    }

    protected ViewRowImpl createRowFromResultSet(Object object, ResultSet resultSet, boolean bl) {
        if (resultSet == null) {
            return null;
        }
        ViewDefImpl viewDefImpl = this.findViewDefFromDiscrVals(resultSet, null);
        ViewRowImpl viewRowImpl = null;
        if (viewDefImpl == null) {
            viewDefImpl = this.getViewDef();
        }
        viewRowImpl = viewDefImpl.createInstanceFromResultSet(this, (QueryCollection)object, resultSet, true);
        return viewRowImpl;
    }

    protected int getEntityDefCount() {
        return this.getViewDef() == null ? 0 : this.getViewDef().getEntityDefCount();
    }

    protected EntityDefImpl getEntityDef(int n) {
        return this.getViewDef() == null ? null : this.getViewDef().getEntityDef(n);
    }

    protected EntityDefImpl[] getEntityDefs() {
        return this.getViewDef() == null ? null : this.getViewDef().getEntityDefs();
    }

    protected int[] getLockParticipants() {
        int n = 0;
        EntityReference[] entityReferenceArray = this.getViewDef().getEntityReferences();
        if (entityReferenceArray != null) {
            int n2 = 0;
            while (n2 < entityReferenceArray.length) {
                if (entityReferenceArray[n2].isLockParticipant()) {
                    ++n;
                }
                ++n2;
            }
        }
        int[] nArray = new int[n];
        int n3 = 0;
        while (n > 0 && n3 < entityReferenceArray.length) {
            if (entityReferenceArray[n3].isLockParticipant()) {
                nArray[--n] = n3;
            }
            ++n3;
        }
        return nArray;
    }

    protected int[] getDeleteParticipants() {
        int n = 0;
        EntityReference[] entityReferenceArray = this.getViewDef().getEntityReferences();
        if (entityReferenceArray != null) {
            int n2 = 0;
            while (n2 < entityReferenceArray.length) {
                if (entityReferenceArray[n2].isDeleteParticipant()) {
                    ++n;
                }
                ++n2;
            }
        }
        int[] nArray = new int[n];
        int n3 = 0;
        while (n > 0 && n3 < entityReferenceArray.length) {
            if (entityReferenceArray[n3].isDeleteParticipant()) {
                nArray[--n] = n3;
            }
            ++n3;
        }
        return nArray;
    }

    protected int[] getInsertParticipants() {
        int n = 0;
        EntityReference[] entityReferenceArray = this.getViewDef().getEntityReferences();
        if (entityReferenceArray != null) {
            int n2 = 0;
            while (n2 < entityReferenceArray.length) {
                if (entityReferenceArray[n2].isInsertParticipant()) {
                    ++n;
                }
                ++n2;
            }
        }
        int[] nArray = new int[n];
        int n3 = 0;
        while (n > 0 && n3 < entityReferenceArray.length) {
            if (entityReferenceArray[n3].isInsertParticipant()) {
                nArray[--n] = n3;
            }
            ++n3;
        }
        return nArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addAttrDef(ViewAttributeDefImpl viewAttributeDefImpl) {
        Object object = this.getSyncLock();
        synchronized (object) {
            int n = this.mAttrDefs.length;
            ViewAttributeDefImpl[] viewAttributeDefImplArray = new ViewAttributeDefImpl[n + 1];
            System.arraycopy(this.mAttrDefs, 0, viewAttributeDefImplArray, 0, n);
            this.mAttrDefs = viewAttributeDefImplArray;
            this.mAttrDefs[n++] = viewAttributeDefImpl;
            if (this.mAttrDefsTab != null) {
                this.mAttrDefsTab.put((Object)viewAttributeDefImpl.getName(), (Object)viewAttributeDefImpl);
            } else if (n > 15) {
                this.mAttrDefsTab = new HashMap(n * 2);
                int n2 = 0;
                while (n2 < n) {
                    this.mAttrDefsTab.put((Object)this.mAttrDefs[n2].getName(), (Object)this.mAttrDefs[n2]);
                    ++n2;
                }
            }
            this.mChangedAttrIndices = new int[n];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeAttrDef(AttributeDef attributeDef) {
        Object object = this.getSyncLock();
        synchronized (object) {
            int n = 0;
            while (n < this.mAttrDefs.length) {
                if (attributeDef == this.mAttrDefs[n]) {
                    ViewAttributeDefImpl[] viewAttributeDefImplArray = new ViewAttributeDefImpl[this.mAttrDefs.length - 1];
                    int n2 = 0;
                    int n3 = 0;
                    while (n2 < this.mAttrDefs.length) {
                        if (n2 != n) {
                            if (n2 > n) {
                                --this.mAttrDefs[n2].mIndex;
                            }
                            viewAttributeDefImplArray[n3++] = this.mAttrDefs[n2];
                        }
                        ++n2;
                    }
                    this.mAttrDefs = viewAttributeDefImplArray;
                    if (this.mDynAttrOffset >= 0 && attributeDef.getIndex() >= this.mDynAttrOffset) {
                        --this.mDynAttrCount;
                        break;
                    }
                    if (this.mDynAttrOffset <= 0) break;
                    --this.mDynAttrOffset;
                    break;
                }
                ++n;
            }
            if (this.mAttrDefsTab != null) {
                this.mAttrDefsTab.remove((Object)attributeDef.getName());
            }
        }
    }

    public AttributeDef[] getAttributeDefs() {
        this.initViewAttributeDefImpls();
        return this.mAttrDefs;
    }

    public AttributeDef[] getKeyAttributeDefs() {
        this.initViewAttributeDefImpls();
        return this.mKeyAttrRefs;
    }

    public AttributeDef[] getAttrDefsForEntityAttr(String string, String string2) {
        int[] nArray = this.getAttrIndicesForEntityAttr(string, string2);
        AttributeDef[] attributeDefArray = new AttributeDef[nArray.length];
        int n = 0;
        while (n < nArray.length) {
            attributeDefArray[n] = this.getAttributeDef(nArray[n]);
            ++n;
        }
        return attributeDefArray;
    }

    public int[] getAttrIndicesForEntityAttr(String string, String string2) {
        EntityDefImpl entityDefImpl = EntityDefImpl.findDefObject(string);
        EntityDefImpl[] entityDefImplArray = this.getEntityDefs();
        if (entityDefImplArray == null || entityDefImplArray.length == 0) {
            return new int[0];
        }
        HashMap hashMap = null;
        int n = 0;
        while (n < entityDefImplArray.length) {
            if (entityDefImpl.isBaseDefFor(entityDefImplArray[n])) {
                AttributeDefImpl attributeDefImpl = entityDefImplArray[n].getAttributeDefImpl(string2);
                int[] nArray = this.getViewDef().viewAttrsForEntityAttr(attributeDefImpl);
                if (entityDefImplArray.length == 1) {
                    if (nArray == null) {
                        nArray = new int[]{};
                    }
                    return nArray;
                }
                if (nArray != null) {
                    if (hashMap == null) {
                        hashMap = new HashMap(4);
                    }
                    int n2 = 0;
                    while (n2 < nArray.length) {
                        hashMap.put((Object)new Integer(nArray[n2]), (Object)attributeDefImpl);
                        ++n2;
                    }
                }
            }
            ++n;
        }
        if (hashMap != null) {
            int[] nArray = new int[hashMap.size()];
            int n3 = this.getAttributeCount();
            int n4 = 0;
            int n5 = 0;
            while (n5 < n3) {
                if (hashMap.get((Object)new Integer(n5)) != null) {
                    nArray[n4++] = n5;
                }
                ++n5;
            }
            return nArray;
        }
        return new int[0];
    }

    public int getCalculatedAttributeCount() {
        return this.getViewDef().getCalculatedAttributeCount();
    }

    public AttributeDefImpl[] getPrimaryKeys() {
        return this.getViewDef() == null ? null : (this.mKeyAttrRefs == null ? this.mViewDef.getPrimaryKeys() : this.mKeyAttrRefs);
    }

    private final MapInfo[] getMapInfo() {
        return this.getViewDef() == null ? null : this.mViewDef.getMapInfo();
    }

    protected String getAssociationClause(int n) {
        if (this.mAssocRefs == null) {
            this.mAssocClause = "";
        }
        if (this.mAssocClause != null && this.mAssocClause.length() > 0) {
            return this.mAssocClause;
        }
        if (this.mAssocRefs.size() > 0 && !this.getViewDef().isFinderView()) {
            StringBuffer stringBuffer = new StringBuffer();
            int n2 = 0;
            while (n2 < this.mAssocRefs.size()) {
                ViewLinkImpl viewLinkImpl = (ViewLinkImpl)this.mAssocRefs.get(n2);
                if (viewLinkImpl.getDestination() == this) {
                    StmtWithBindVars stmtWithBindVars = viewLinkImpl.getViewLinkDef().getAssociationClause(this, n, viewLinkImpl.mReversedUsage);
                    String string = stmtWithBindVars.mStmt;
                    n = stmtWithBindVars.mNoBindVars;
                    if (string != null) {
                        if (stringBuffer.length() > 0) {
                            stringBuffer.append(" AND ");
                        }
                        stringBuffer.append(string);
                    }
                }
                ++n2;
            }
            this.mAssocClause = stringBuffer.toString();
        }
        if (!AssociationDefImpl.isAssocWhereEarlySet() && this.mViewLinkAccessorInfo != null && !this.mIsForScan) {
            String string = this.mViewLinkAccessorInfo.mAccessorDef.getAssociationClause(this.mViewLinkAccessorInfo.mViewLinkDef, this.mViewLinkAccessorInfo.mIsReverseAccessor, n);
            this.mAssocClause = this.mAssocClause != null && this.mAssocClause.length() > 0 ? this.mAssocClause + " AND " + string : string;
        }
        return this.mAssocClause;
    }

    public void executeQuery() {
        this.getDefaultRowSet().executeQuery();
    }

    public void executeEmptyRowSet() {
        this.getDefaultRowSet().executeEmptyRowSet();
    }

    public Object[] executeDetailQuery(Row[] rowArray) {
        int n = 0;
        if (InstrumentedEvent.isActive) {
            n = InstrumentedEvent.startEvent(EventGroup.EXECUTE_QUERY, "ViewObject executeQuery " + this.getName());
        }
        Object[] objectArray = this.getDefaultRowSet().executeDetailQuery(rowArray);
        if (InstrumentedEvent.isActive) {
            InstrumentedEvent.endEvent(n);
        }
        return objectArray;
    }

    public Comparator getRowComparator() {
        if (this.mRowComparator == null) {
            this.mRowComparator = new RowComparator(this.getSortCriteria());
        }
        return this.mRowComparator;
    }

    public void sortRows(Row[] rowArray) {
        if (rowArray == null) {
            return;
        }
        Arrays.sort(rowArray, this.getRowComparator());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void executeQueryForCollection(Object object, Object[] objectArray, int n) {
        Object object2 = this.getSyncLock();
        synchronized (object2) {
            int n2 = 0;
            if (InstrumentedEvent.isActive) {
                n2 = InstrumentedEvent.startEvent(EventGroup.EXECUTE_QUERY, "ViewObject executeQueryForCollection " + this.getName());
            }
            try {
                ((QueryCollection)object).executeQuery(objectArray, n);
                Object var7_6 = null;
                if (!InstrumentedEvent.isActive) return;
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                if (!InstrumentedEvent.isActive) throw throwable;
                InstrumentedEvent.endEvent(n2);
                throw throwable;
            }
            InstrumentedEvent.endEvent(n2);
            {
            }
            return;
        }
    }

    protected void setResultSetForCollection(Object object, ResultSet resultSet) {
        ((QueryCollection)object).setResultSet(resultSet);
    }

    protected boolean hasNextForCollection(Object object) {
        return ((QueryCollection)object).hasNextInResultSet();
    }

    protected void setFetchCompleteForCollection(Object object, boolean bl) {
        ((QueryCollection)object).setFetchComplete(bl);
    }

    protected Object getUserDataForCollection(Object object) {
        return ((QueryCollection)object).getUserData();
    }

    protected void setUserDataForCollection(Object object, Object object2) {
        ((QueryCollection)object).setUserData(object2);
    }

    protected void releaseUserDataForCollection(Object object, Object object2) {
    }

    public int getAttributeCount() {
        this.initViewAttributeDefImpls();
        if (this.mAttrDefs == null) {
            return 0;
        }
        return this.mAttrDefs.length;
    }

    public AttributeDef findAttributeDef(String string) {
        AttributeDef attributeDef = this.lookupAttributeDef(string);
        if (attributeDef != null) {
            return attributeDef;
        }
        throw new NoDefException(131, string, this.getName());
    }

    public AttributeDef lookupAttributeDef(String string) {
        if (string == null) {
            throw new InvalidDefNameException(131, string);
        }
        this.initViewAttributeDefImpls();
        if (this.mAttrDefsTab != null) {
            AttributeDef attributeDef = (AttributeDef)this.mAttrDefsTab.get((Object)string);
            if (attributeDef != null) {
                return attributeDef;
            }
        } else {
            string = string.intern();
            if (this.mAttrDefs != null) {
                int n = 0;
                while (n < this.mAttrDefs.length) {
                    if (this.mAttrDefs[n].getName() == string) {
                        return this.mAttrDefs[n];
                    }
                    ++n;
                }
            }
        }
        return null;
    }

    public AttributeDef getAttributeDef(int n) {
        this.initViewAttributeDefImpls();
        return n >= 0 && this.mAttrDefs != null && n < this.mAttrDefs.length ? this.mAttrDefs[n] : null;
    }

    public int getDynamicAttributeCount() {
        return this.mDynAttrCount;
    }

    public int getDynamicAttributeOffset() {
        return this.mDynAttrOffset;
    }

    public AttributeDef addDynamicAttribute(String string) {
        if (string != null && string.length() == 0) {
            string = null;
        }
        this.initViewAttributeDefImpls();
        if (this.mAttrDefs == null) {
            return null;
        }
        if (this.lookupAttributeDef(string) != null) {
            throw new NameClashException(131, string);
        }
        if (!JboNameUtil.isNameValid(string)) {
            throw new InvalidDefNameException(131, string);
        }
        ViewAttributeDefImpl viewAttributeDefImpl = new ViewAttributeDefImpl(string, null, null, this.mAttrDefs.length, 4, false, null, null, null, null, this);
        viewAttributeDefImpl.mUpdateable = (byte)2;
        this.addAttrDef(viewAttributeDefImpl);
        if (this.mDynAttrOffset == -1) {
            this.mDynAttrOffset = this.mAttrDefs.length - 1;
        }
        ++this.mDynAttrCount;
        return viewAttributeDefImpl;
    }

    public int getAttributeIndexOf(String string) {
        if (this.mAttrDefs == null) {
            this.initViewAttributeDefImpls();
        }
        if (this.mAttrDefsTab != null) {
            AttributeDef attributeDef = (AttributeDef)this.mAttrDefsTab.get((Object)string);
            if (attributeDef != null) {
                return attributeDef.getIndex();
            }
        } else {
            string = string.intern();
            if (this.mAttrDefs != null) {
                int n = 0;
                while (n < this.mAttrDefs.length) {
                    if (this.mAttrDefs[n].mName == string) {
                        return n;
                    }
                    ++n;
                }
            }
        }
        return -1;
    }

    boolean isSourceAttribute(int[] nArray) {
        if (nArray == null || nArray.length == 0 || this.mSrcAttributes == null) {
            return false;
        }
        int n = 0;
        while (n < nArray.length) {
            int n2 = 0;
            while (n2 < this.mSrcAttributes.size()) {
                if (((ViewAttributeDefImpl)this.mSrcAttributes.get(n2)).getIndex() == nArray[n]) {
                    return true;
                }
                ++n2;
            }
            ++n;
        }
        return false;
    }

    ViewLinkImpl findViewLink(EntityReference entityReference, EntityAssociation entityAssociation) {
        int n = 0;
        while (n < this.mAssocRefs.size()) {
            ViewLinkDefImpl viewLinkDefImpl = ((ViewLinkImpl)this.mAssocRefs.get(n)).getViewLinkDef();
            if (viewLinkDefImpl.getEntityAssociation() == entityAssociation && (viewLinkDefImpl.getEntityAssociationReference().getEntityReference() == entityReference || viewLinkDefImpl.getEntityAssociationReference().getOtherEntityReference() == entityReference)) {
                return (ViewLinkImpl)this.mAssocRefs.get(n);
            }
            ++n;
        }
        return null;
    }

    ViewLinkImpl findViewLink(ViewAttributeDefImpl viewAttributeDefImpl) {
        if (viewAttributeDefImpl.getAttributeDefImpl() == null) {
            return null;
        }
        Association association = ((AssociationDefImpl)viewAttributeDefImpl.getAttributeDefImpl()).getAssociation();
        ViewLinkDefImpl viewLinkDefImpl = null;
        if (association instanceof ViewLinkDefImpl) {
            viewLinkDefImpl = (ViewLinkDefImpl)association;
        }
        if (viewLinkDefImpl == null) {
            return null;
        }
        return this.findViewLink(viewLinkDefImpl);
    }

    ViewLinkImpl findViewLink(ViewLinkDefImpl viewLinkDefImpl) {
        int n = 0;
        while (n < this.mAssocRefs.size()) {
            if (((ViewLinkImpl)this.mAssocRefs.get(n)).getViewLinkDef() == viewLinkDefImpl) {
                return (ViewLinkImpl)this.mAssocRefs.get(n);
            }
            ++n;
        }
        return null;
    }

    public boolean isDynamicAttribute(int n) {
        this.initViewAttributeDefImpls();
        return this.mAttrDefs != null && this.mAttrDefs[n].getAttributeKind() == 4;
    }

    public boolean isDynamicAttribute(String string) {
        int n = this.getAttributeIndexOf(string);
        if (n < 0) {
            throw new NoDefException(131, string, this.getName());
        }
        return this.isDynamicAttribute(n);
    }

    public void validate() {
        if (!this.hasDefaultRowSet()) {
            return;
        }
        this.activateIteratorState(null, true);
        QueryCollection queryCollection = this.getQueryCollection();
        ArrayList arrayList = new ArrayList(5);
        if (queryCollection == null) {
            return;
        }
        int n = queryCollection.size() - 1;
        while (n > 0) {
            try {
                ViewRowImpl viewRowImpl = (ViewRowImpl)queryCollection.get(n);
                switch (viewRowImpl.getPostState()) {
                    case 0: 
                    case 2: {
                        viewRowImpl.validate();
                        break;
                    }
                    case 3: {
                        this.mViewRowSet.removeRowAt(n);
                    }
                }
            }
            catch (JboException jboException) {
                arrayList.add((Object)jboException);
            }
            --n;
        }
        if (arrayList.size() > 0) {
            Class clazz = class$oracle$jbo$CSMessageBundle;
            if (clazz == null) {
                clazz = class$oracle$jbo$CSMessageBundle = ViewObjectImpl.class$("oracle.jbo.CSMessageBundle");
            }
            ValidationException.raise(clazz, "27003", new Object[]{this.getName()}, arrayList, this.getDBTransactionImpl().isBundledExceptionMode(), false);
        }
    }

    void saveBuffer() {
    }

    public boolean isAutoPostChanges() {
        return this.mAutoPostChanges;
    }

    public void setAutoPostChanges(boolean bl) {
        this.mAutoPostChanges = bl;
    }

    void updateQueryCollectionCache(QueryCollection queryCollection, RowFilter rowFilter, boolean bl) {
        RowFilter rowFilter2;
        RowFilter rowFilter3 = rowFilter2 = rowFilter == null ? (RowFilter)new RowFilterKey(this) : rowFilter;
        if (queryCollection.isForwardOnly()) {
            RowFilter rowFilter4 = queryCollection.getRowFilter();
            if (rowFilter4 == null) {
                rowFilter4 = rowFilter2;
            }
            this.mQCs.put(rowFilter4, queryCollection);
            return;
        }
        QueryCollection queryCollection2 = this.getCachedQueryCollection(rowFilter2);
        int n = queryCollection2 == null ? -1 : queryCollection2.getNumUserParams();
        boolean bl2 = true;
        if (queryCollection2 != null && queryCollection2 != queryCollection) {
            if (queryCollection2.isPinned() || queryCollection2.isDirty()) {
                bl2 = false;
                this.removeQueryCollectionFromCache(queryCollection2, rowFilter2);
                Object object = this.getBindingStyle() != 2 ? (Object)queryCollection2 : (Object)new Object[]{"qc", queryCollection2};
                queryCollection2.setRowFilter(new RowFilterKey(this, new Object[]{object}), 0);
            } else {
                queryCollection2.closeCollection();
            }
        }
        this.mQCs.put(rowFilter2, queryCollection);
        queryCollection.setRowFilter(rowFilter, n);
        if (queryCollection2 != null && queryCollection2 != queryCollection && bl) {
            int n2 = 0;
            while (n2 < this.mRowSets.size()) {
                ViewRowSetImpl viewRowSetImpl = (ViewRowSetImpl)this.mRowSets.elementAt(n2);
                if (viewRowSetImpl != null && viewRowSetImpl.getQueryCollection() == queryCollection2) {
                    viewRowSetImpl.notifyQueryCollectionChanged(queryCollection);
                }
                ++n2;
            }
        }
    }

    ViewRowSetImpl findRowSetForQueryCollection(QueryCollection queryCollection, boolean bl) {
        int n = 0;
        while (n < this.mRowSets.size()) {
            ViewRowSetImpl viewRowSetImpl = (ViewRowSetImpl)this.mRowSets.elementAt(n);
            if (viewRowSetImpl != null && viewRowSetImpl.getQueryCollection() == queryCollection) {
                if (bl && !(viewRowSetImpl instanceof EntityRowSetImpl)) {
                    return viewRowSetImpl;
                }
                if (!bl) {
                    return viewRowSetImpl;
                }
            }
            ++n;
        }
        return null;
    }

    protected QueryCollection getCachedQueryCollection(RowFilter rowFilter) {
        RowFilter rowFilter2 = rowFilter == null ? (RowFilter)new RowFilterKey(this) : rowFilter;
        QueryCollection queryCollection = (QueryCollection)this.mQCs.get(rowFilter2);
        if (queryCollection == null) {
            queryCollection = (QueryCollection)this.mDirtyQCs.get((Object)rowFilter2);
        } else if (queryCollection.isPinnedTemporarily()) {
            this.unpinQC(queryCollection);
            queryCollection.setPinnedTemporarily(false);
        }
        return queryCollection;
    }

    protected Enumeration getAllCachedQueryCollections() {
        return this.mQCs != null ? this.mQCs.elements() : null;
    }

    void removeQueryCollectionFromCache(QueryCollection queryCollection, RowFilter rowFilter) {
        RowFilter rowFilter2;
        RowFilter rowFilter3 = rowFilter2 = rowFilter == null ? (RowFilter)new RowFilterKey(this) : rowFilter;
        if (this.mQCs != null) {
            this.mQCs.remove(rowFilter2);
        }
        if (this.mDirtyQCs != null) {
            this.mDirtyQCs.remove((Object)rowFilter2);
        }
    }

    protected RowFilter buildRowFilter(Object[] objectArray) {
        return new RowFilterKey(this, objectArray, this.getBindingStyle());
    }

    protected Enumeration getRowFilters() {
        Hashtable<Object, Object> hashtable = new Hashtable<Object, Object>(4);
        Enumeration enumeration = this.mQCs.keys();
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            hashtable.put(e, e);
        }
        Iterator iterator = this.mDirtyQCs.keySet().iterator();
        while (iterator.hasNext()) {
            Object object = iterator.next();
            hashtable.put(object, object);
        }
        return hashtable.keys();
    }

    protected boolean isCollectionPresent(RowFilter rowFilter) {
        return this.getCachedQueryCollection(rowFilter) != null;
    }

    protected RowFilter[] getQualifyingRowFilters(Object[] objectArray) {
        RowFilter rowFilter = this.buildRowFilter(objectArray);
        if (this.isCollectionPresent(rowFilter)) {
            return new RowFilter[]{rowFilter};
        }
        return null;
    }

    protected RowFilter buildNewCollection(Object[] objectArray) {
        QueryCollection queryCollection = new QueryCollection(this);
        queryCollection.createColumnList();
        RowFilter rowFilter = this.buildRowFilter(objectArray);
        this.updateQueryCollectionCache(queryCollection, rowFilter, false);
        this.pinQC(queryCollection);
        queryCollection.setPinnedTemporarily(true);
        return rowFilter;
    }

    protected RowFilter[] buildQualifyingRowFilters(Object[] objectArray) {
        RowFilter rowFilter = this.buildNewCollection(objectArray);
        if (rowFilter == null) {
            return null;
        }
        return new RowFilter[]{rowFilter};
    }

    void clearQueryCollectionCache() {
        if (Diagnostic.isOn()) {
            Diagnostic.println("Clear QueryCollection in cache for VO " + this.getName());
        }
        Enumeration enumeration = this.mQCs.elements();
        while (enumeration.hasMoreElements()) {
            ((QueryCollection)enumeration.nextElement()).closeCollection();
        }
        this.mQCs.clear();
    }

    RowFilter getQCRowFilter(QueryCollection queryCollection) {
        RowFilter rowFilter = queryCollection.getRowFilter();
        return rowFilter == null ? (RowFilter)new RowFilterKey(this) : rowFilter;
    }

    void pinQC(QueryCollection queryCollection) {
        this.mDirtyQCs.put((Object)this.getQCRowFilter(queryCollection), (Object)queryCollection);
    }

    void unpinQC(QueryCollection queryCollection) {
        this.mDirtyQCs.remove((Object)this.getQCRowFilter(queryCollection));
    }

    protected void markQueryCollectionDirty(QueryCollection queryCollection, boolean bl) {
        if (queryCollection != null && !queryCollection.isForwardOnly()) {
            queryCollection.setDirty(bl);
            if (bl) {
                queryCollection.setPinnedTemporarily(false);
                this.pinQC(queryCollection);
            } else if (this.getMaxFetchSize() != 0) {
                this.unpinQC(queryCollection);
            }
        }
    }

    boolean clearQueryCollectionCache(QueryCollection queryCollection, boolean bl) {
        boolean bl2;
        boolean bl3 = bl2 = this.findRowSetForQueryCollection(queryCollection, false) != null;
        if (!(bl2 || !bl && queryCollection.isDirty() || queryCollection.isPinned())) {
            RowFilter rowFilter = this.getQCRowFilter(queryCollection);
            queryCollection.closeCollection();
            this.mQCs.remove(rowFilter);
            this.mDirtyQCs.remove((Object)rowFilter);
            return true;
        }
        return false;
    }

    void clearQueryCollectionCache(ViewRowSetImpl viewRowSetImpl) {
        ArrayList arrayList = new ArrayList(5);
        int n = 0;
        while (n < this.mRowSets.size()) {
            ViewRowSetImpl viewRowSetImpl2 = (ViewRowSetImpl)this.mRowSets.elementAt(n);
            if (viewRowSetImpl2 != viewRowSetImpl) {
                arrayList.add((Object)viewRowSetImpl2.getQueryCollection());
            }
            ++n;
        }
        Enumeration enumeration = this.mQCs.elements();
        if (Diagnostic.isOn()) {
            Diagnostic.println("Clear QueryCollection in cache for RowSet " + viewRowSetImpl.getName());
        }
        while (enumeration.hasMoreElements()) {
            QueryCollection queryCollection = (QueryCollection)enumeration.nextElement();
            if (arrayList.contains((Object)queryCollection) || queryCollection.isDirty() || queryCollection.isPinned()) continue;
            RowFilter rowFilter = this.getQCRowFilter(queryCollection);
            queryCollection.closeCollection();
            this.mQCs.remove(rowFilter);
        }
    }

    public byte getFetchMode() {
        return this.mFetchMode;
    }

    protected void setFetchMode(byte by) {
        switch (by) {
            case 2: {
                this.mFetchMode = 0;
                break;
            }
            case 0: 
            case 1: {
                this.mFetchMode = by;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    public int getBindingStyle() {
        if (this.mBindingStyle == -1) {
            return this.getViewDef().getBindingStyle();
        }
        return this.mBindingStyle;
    }

    public void setBindingStyle(int n) {
        this.mBindingStyle = n;
    }

    AssociationDefImpl getAssocAccessorDef() {
        return this.mViewLinkAccessorInfo == null ? null : this.mViewLinkAccessorInfo.mAccessorDef;
    }

    ViewLinkAccessorInfo getViewLinkAccessorInfo() {
        return this.mViewLinkAccessorInfo;
    }

    void setViewLinkAccessorInfo(ViewLinkAccessorInfo viewLinkAccessorInfo) {
        this.mViewLinkAccessorInfo = viewLinkAccessorInfo;
    }

    public short getFetchSize() {
        return this.mFetchSize;
    }

    public int getMaxFetchSize() {
        return this.mMaxFetchSize;
    }

    public void setFetchSize(short s) {
        if (s < 1) {
            throw new IllegalArgumentException();
        }
        this.mFetchSize = s;
    }

    public void setMaxFetchSize(int n) {
        if (n < -1) {
            throw new IllegalArgumentException();
        }
        this.mMaxFetchSize = n;
    }

    public int getQueryMode() {
        return this.mQueryMode;
    }

    public void setQueryMode(int n) {
        boolean bl = this.getViewDef().isQueryThruEntity();
        if (bl && (n & 4) != 0) {
            Class clazz = class$oracle$jbo$CSMessageBundle;
            if (clazz == null) {
                clazz = class$oracle$jbo$CSMessageBundle = ViewObjectImpl.class$("oracle.jbo.CSMessageBundle");
            }
            throw new InvalidParamException(clazz, "25066", new Object[]{this.getName()});
        }
        if (n == 0) {
            int n2 = n = !bl ? 4 : 2;
        }
        if (this.mQueryMode != n) {
            this.mQueryMode = n;
            this.setQueryAsChanged(true);
        }
    }

    public void addQueryMode(int n) {
        this.mQueryMode |= n;
    }

    public ViewCriteria createViewCriteria() {
        return new ViewCriteria(this);
    }

    protected boolean addViewCriteriaToWhereClause() {
        ViewCriteria viewCriteria = this.getViewCriteria();
        return viewCriteria == null ? true : viewCriteria.isCriteriaForQuery();
    }

    ViewCriteriaManagerImpl getViewCriteriaManager() {
        if (this.mCriteriaManager == null) {
            this.mCriteriaManager = new ViewCriteriaManagerImpl(this);
        }
        return this.mCriteriaManager;
    }

    public void applyViewCriteria(ViewCriteria viewCriteria) {
        if (this.getViewCriteria() == null && viewCriteria == null) {
            return;
        }
        this.getViewCriteriaManager().applyViewCriteria(viewCriteria);
        this.criteriaChanged(null);
    }

    public void applyViewCriteria(ViewCriteria viewCriteria, String string) {
        if (this.getViewCriteria(string) == null && viewCriteria == null) {
            return;
        }
        this.getViewCriteriaManager().applyViewCriteria(viewCriteria, string);
        this.criteriaChanged(null);
    }

    public void clearViewCriterias() {
        if (this.mCriteriaManager != null) {
            this.mCriteriaManager.clearViewCriterias();
            this.criteriaChanged(null);
        }
    }

    public ViewCriteria getViewCriteria() {
        return this.mCriteriaManager != null ? this.mCriteriaManager.getViewCriteria() : null;
    }

    public ViewCriteria getViewCriteria(String string) {
        return this.mCriteriaManager != null ? this.mCriteriaManager.getViewCriteria(string) : null;
    }

    public void putViewCriteria(String string, ViewCriteria viewCriteria) {
        this.getViewCriteriaManager().putViewCriteria(string, viewCriteria);
    }

    public ViewCriteria removeViewCriteria(String string) {
        this.removeApplyViewCriteriaName(string);
        return this.getViewCriteriaManager().removeViewCriteria(string);
    }

    public String[] getApplyViewCriteriaNames() {
        return this.mCriteriaManager != null ? this.mCriteriaManager.getApplyViewCriteriaNames() : new String[]{};
    }

    public void setApplyViewCriteriaNames(String[] stringArray) {
        this.getViewCriteriaManager().setApplyViewCriteriaNames(stringArray);
        this.criteriaChanged(null);
    }

    public void setApplyViewCriteriaName(String string) {
        this.setApplyViewCriteriaNames(new String[]{string});
    }

    public boolean removeApplyViewCriteriaName(String string) {
        boolean bl = this.getViewCriteriaManager().removeApplyViewCriteriaName(string);
        this.criteriaChanged(null);
        return bl;
    }

    public ViewCriteria[] getApplyViewCriterias(int n) {
        return this.mCriteriaManager != null ? this.mCriteriaManager.getApplyViewCriterias(n) : new ViewCriteria[]{};
    }

    public String[] getAllViewCriteriaNames() {
        return this.mCriteriaManager != null ? this.mCriteriaManager.getAllViewCriteriaNames() : new String[]{};
    }

    public ViewCriteria[] getAllViewCriterias() {
        return this.mCriteriaManager != null ? this.mCriteriaManager.getAllViewCriterias() : new ViewCriteria[]{};
    }

    public void setViewCriteriaAdapter(ViewCriteriaAdapter viewCriteriaAdapter) {
        this.getViewCriteriaManager().setCriteriaAdapter(viewCriteriaAdapter);
    }

    public CriteriaClauses buildViewCriteriaClauses(ViewCriteria viewCriteria) {
        return this.mCriteriaManager != null ? this.mCriteriaManager.buildViewCriteriaClauses(viewCriteria) : null;
    }

    public String getViewCriteriaClause() {
        ViewCriteria viewCriteria = this.getViewCriteria();
        if (viewCriteria != null) {
            return this.getViewCriteriaManager().getViewCriteriaClause(viewCriteria.isCriteriaForQuery());
        }
        return null;
    }

    public String getViewCriteriaClause(boolean bl) {
        if (this.mAttrDefs == null) {
            this.initViewAttributeDefImpls();
        }
        if (this.mAttrDefs != null) {
            return this.getViewCriteriaManager().getViewCriteriaClause(bl);
        }
        return null;
    }

    public void criteriaChanged(ViewCriteria viewCriteria) {
        if (this.mFullSqlMode == 0) {
            this.mUserDefinedQuery = null;
        }
        this.setQueryAsChanged(4100);
    }

    static String vlAccResultAttrName(AttributeDef attributeDef) {
        return attributeDef.getName() + "__viewlink_result__";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initViewAttributeDefImpls() {
        if (this.mViewDef == null || this.mAttrDefs != null) {
            return;
        }
        Object object = this.getSyncLock();
        synchronized (object) {
            if (this.mViewDef == null || this.mAttrDefs != null) {
                return;
            }
            this.mAttrDefs = new ViewAttributeDefImpl[0];
            if (!this.mViewDef.isDefResolved()) {
                ViewUsageHelper.createViewAttributeDefImpls(this.getDefaultRowSet());
            }
            AttributeDefImpl[] attributeDefImplArray = this.mViewDef.getAttributeDefImpls();
            ArrayList arrayList = new ArrayList(4);
            this.mAttrDefs = new ViewAttributeDefImpl[attributeDefImplArray.length];
            if (attributeDefImplArray.length > 15) {
                this.mAttrDefsTab = new HashMap(attributeDefImplArray.length * 2);
            }
            int n = 0;
            while (n < attributeDefImplArray.length) {
                ViewAttributeDefImpl viewAttributeDefImpl;
                this.mAttrDefs[n] = viewAttributeDefImpl = (ViewAttributeDefImpl)attributeDefImplArray[n];
                if (this.mAttrDefsTab != null) {
                    this.mAttrDefsTab.put((Object)this.mAttrDefs[n].getName(), (Object)this.mAttrDefs[n]);
                }
                if (viewAttributeDefImpl.isPrimaryKey()) {
                    arrayList.add((Object)viewAttributeDefImpl);
                }
                ++n;
            }
            this.mChangedAttrIndices = new int[this.mAttrDefs.length];
            this.mKeyAttrRefs = (ViewAttributeDefImpl[])arrayList.toArray((Object[])new ViewAttributeDefImpl[arrayList.size()]);
            if (this.isViewLinkAccessorRetained()) {
                this.processViewLinkAccessors();
            }
        }
    }

    public boolean isForScan() {
        return this.mIsForScan;
    }

    void setForScan(boolean bl) {
        this.mIsForScan = bl;
    }

    public AttributeDef[] getScanRowFilterAttributeDefs() {
        return this.mScanRowFilterAttributeDefs;
    }

    void setScanRowFilterAttributeDefs(AttributeDef[] attributeDefArray) {
        this.mScanRowFilterAttributeDefs = attributeDefArray;
    }

    public void setKeyAttributeDefs(int[] nArray) {
        if (nArray == null) {
            nArray = new int[]{};
        }
        int n = nArray.length;
        int n2 = this.getKeyAttributeDefs().length;
        int n3 = 0;
        int n4 = 0;
        while (n4 < n2) {
            if (n3 < n && this.mKeyAttrRefs[n4].getIndex() == nArray[n3]) {
                ++n3;
            } else {
                EntityReference entityReference = this.mKeyAttrRefs[n4].getEntityReference();
                if (entityReference != null && entityReference.isDeleteParticipant() && this.mKeyAttrRefs[n4].mAttrDesc.mPrimaryKey) {
                    throw new JboException("Required attribute '" + this.mKeyAttrRefs[n4].getName() + "' as a key constituent");
                }
            }
            ++n4;
        }
        this.innerSetKeyAttributeDefs(nArray);
        this.resetState();
    }

    void innerSetKeyAttributeDefs(int[] nArray) {
        int n = nArray.length;
        ViewAttributeDefImpl[] viewAttributeDefImplArray = new ViewAttributeDefImpl[n];
        if (this.mAttrDefs == null) {
            this.initViewAttributeDefImpls();
        }
        int n2 = 0;
        while (n2 < n) {
            viewAttributeDefImplArray[n2] = this.mAttrDefs[nArray[n2]];
            ++n2;
        }
        this.mKeyAttrRefs = viewAttributeDefImplArray;
        this.mKeyModified = true;
        if (this.mByKeyFinderRS != null) {
            ((ViewObjectImpl)this.mByKeyFinderRS.getViewObject()).mKeyAttrRefs = this.mKeyAttrRefs;
        }
    }

    public boolean isManageRowsByKey() {
        return this.mManageRowsByKey;
    }

    public void setManageRowsByKey(boolean bl) {
        this.mManageRowsByKey = bl;
    }

    public RowSet getRowSet() {
        return this;
    }

    public RowSetIterator getRowSetIterator() {
        return this;
    }

    public Row next() {
        return this.getDefaultRowSet().next();
    }

    public Row previous() {
        return this.getDefaultRowSet().previous();
    }

    public Row first() {
        return this.getDefaultRowSet().first();
    }

    public Row last() {
        return this.getDefaultRowSet().last();
    }

    public boolean doesRowFilterMatch(Row[] rowArray, Object[] objectArray) {
        return this.getDefaultRowSet().doesRowFilterMatch(rowArray, objectArray);
    }

    public Object[] refreshCollection(Row[] rowArray, boolean bl, boolean bl2) {
        return this.getDefaultRowSet().refreshCollection(rowArray, bl, bl2);
    }

    public void reset() {
        this.getDefaultRowSet().reset();
    }

    public boolean hasNext() {
        return this.getDefaultRowSet().hasNext();
    }

    public boolean hasPrevious() {
        return this.getDefaultRowSet().hasPrevious();
    }

    public boolean isRangeAtBottom() {
        return this.getDefaultRowSet().isRangeAtBottom();
    }

    public boolean isRangeAtTop() {
        return this.getDefaultRowSet().isRangeAtTop();
    }

    public int getFetchedRowCount() {
        return this.getDefaultRowSet().getFetchedRowCount();
    }

    public int getRowCount() {
        return this.getDefaultRowSet().getRowCount();
    }

    public long getEstimatedRowCount() {
        return this.getDefaultRowSet().getEstimatedRowCount();
    }

    public long getDetailEstimatedRowCount(Row[] rowArray) {
        return this.getDefaultRowSet().getDetailEstimatedRowCount(rowArray);
    }

    public Object[] getRowFilterValues() {
        if (this.mViewRowSet == null) {
            return null;
        }
        return this.getDefaultRowSet().getRowFilterValues();
    }

    public void setRowFilterValues(Object[] objectArray) {
        if (this.mViewRowSet != null) {
            this.getDefaultRowSet().setRowFilterValues(objectArray);
        }
    }

    public SvcMsgIteratorState getCliIteratorState() {
        return null;
    }

    public void prepareForBatchMode(SvcMsgIteratorState svcMsgIteratorState, boolean bl) {
        if (this.mViewRowSet != null) {
            this.getDefaultRowSet().prepareForBatchMode(svcMsgIteratorState, bl);
        }
    }

    public int setRangeSize(int n) {
        return this.getDefaultRowSet().setRangeSize(n);
    }

    public int getRangeSize() {
        if (this.mViewRowSet == null) {
            return 1;
        }
        return this.getDefaultRowSet().getRangeSize();
    }

    public int getRangeStart() {
        if (this.mViewRowSet == null) {
            return -1;
        }
        return this.getDefaultRowSet().getRangeStart();
    }

    public int setRangeStart(int n) {
        return this.getDefaultRowSet().setRangeStart(n);
    }

    public int scrollRange(int n) {
        return this.getDefaultRowSet().scrollRange(n);
    }

    public int scrollToRangePage(int n) {
        return this.getDefaultRowSet().scrollToRangePage(n);
    }

    public int getEstimatedRangePageCount() {
        return this.getDefaultRowSet().getEstimatedRangePageCount();
    }

    public int scrollRangeTo(Row row, int n) {
        return this.getDefaultRowSet().scrollRangeTo(row, n);
    }

    public Row getRow(Key key) {
        return this.getDefaultRowSet().getRow(key);
    }

    public Row getRowAtRangeIndex(int n) {
        return this.getDefaultRowSet().getRowAtRangeIndex(n);
    }

    public Row getRowFromHandle(Object object) {
        return this.getDefaultRowSet().getRowFromHandle(object);
    }

    public void removeRowHandle(Object object) {
        this.getDefaultRowSet().removeRowHandle(object);
    }

    public Row getCurrentRow() {
        return this.getDefaultRowSet().getCurrentRow();
    }

    public int getCurrentRowIndex() {
        return this.getDefaultRowSet().getCurrentRowIndex();
    }

    public int getCurrentRowSlot() {
        return this.getDefaultRowSet().getCurrentRowSlot();
    }

    public int getIterMode() {
        return this.getDefaultRowSet().getIterMode();
    }

    public void setIterMode(int n) {
        this.getDefaultRowSet().setIterMode(n);
    }

    public boolean isRowValidation() {
        return this.getDefaultRowSet().isRowValidation();
    }

    public void setRowValidation(boolean bl) {
        this.getDefaultRowSet().setRowValidation(bl);
    }

    public boolean setCurrentRow(Row row) {
        return this.getDefaultRowSet().setCurrentRow(row);
    }

    public boolean setCurrentRowAtRangeIndex(int n) {
        return this.getDefaultRowSet().setCurrentRowAtRangeIndex(n);
    }

    public Row createAndInitRow(AttributeList attributeList) {
        return this.getDefaultRowSet().createAndInitRow(attributeList);
    }

    public Row createRow() {
        return this.getDefaultRowSet().createRow();
    }

    public void insertRow(Row row) {
        this.getDefaultRowSet().insertRow(row);
    }

    public void insertRowAtRangeIndex(int n, Row row) {
        this.getDefaultRowSet().insertRowAtRangeIndex(n, row);
    }

    public void removeCurrentRow() {
        this.getDefaultRowSet().removeCurrentRow();
    }

    public void removeCurrentRowFromCollection() {
        this.getDefaultRowSet().removeCurrentRowFromCollection();
    }

    public Row removeCurrentRowAndRetain() {
        return this.getDefaultRowSet().removeCurrentRowAndRetain();
    }

    public int getRangeIndexOf(Row row) {
        return this.getDefaultRowSet().getRangeIndexOf(row);
    }

    public Enumeration enumerateRowsInRange() {
        return this.getDefaultRowSet().enumerateRowsInRange();
    }

    public Row[] getAllRowsInRange() {
        return this.getDefaultRowSet().getAllRowsInRange();
    }

    public Row[] getNextRangeSet() {
        return this.getDefaultRowSet().getNextRangeSet();
    }

    public Row[] getPreviousRangeSet() {
        return this.getDefaultRowSet().getPreviousRangeSet();
    }

    public ViewObject getViewObject() {
        return this;
    }

    public boolean setMasterRowSetIterator(RowSetIterator rowSetIterator) {
        return this.getDefaultRowSet().setMasterRowSetIterator(rowSetIterator);
    }

    public boolean removeMasterRowSetIterator(RowSetIterator rowSetIterator) {
        return this.getDefaultRowSet().removeMasterRowSetIterator(rowSetIterator);
    }

    public RowSetIterator[] getMasterRowSetIterators() {
        return this.getDefaultRowSet().getMasterRowSetIterators();
    }

    public RowSet[] getDetailRowSets() {
        if (this.getDef() == null) {
            throw new InvalidObjAccessException(111, this.getName());
        }
        return this.mViewRowSet != null ? this.getDefaultRowSet().getDetailRowSets() : new RowSet[]{};
    }

    public RowSet createDetailRowSet(String string, String string2) {
        return this.getDefaultRowSet().createDetailRowSet(string, string2);
    }

    public void addListener(Object object) {
        this.getDefaultRowSet().getDefaultRowSetIterator().addListener(object);
    }

    public void removeListener(Object object) {
        if (this.mViewRowSet != null) {
            this.getDefaultRowSet().removeListener(object);
        }
    }

    public void addManagementListener(RowSetManagementListener rowSetManagementListener) {
        this.getDefaultRowSet().getDefaultRowSetIterator().addManagementListener(rowSetManagementListener);
    }

    public void removeManagementListener(RowSetManagementListener rowSetManagementListener) {
        if (this.mViewRowSet != null) {
            this.getDefaultRowSet().removeManagementListener(rowSetManagementListener);
        }
    }

    public RowSet createRowSet(String string) {
        ViewRowSetImpl viewRowSetImpl = this.createViewRowSet(string, false);
        this.mUserRowSets.add((Object)viewRowSetImpl);
        return viewRowSetImpl;
    }

    public RowSetIterator createRowSetIterator(String string) {
        return this.getDefaultRowSet().createRowSetIterator(string);
    }

    public RowSetIterator[] getRowSetIterators() {
        return this.getDefaultRowSet().getRowSetIterators();
    }

    public RowSetIterator findRowSetIterator(String string) {
        return this.getDefaultRowSet().findRowSetIterator(string);
    }

    public int getRowCountInRange() {
        return this.getDefaultRowSet().getRowCountInRange();
    }

    public Key buildKey(Object[] objectArray) {
        if (objectArray == null) {
            return null;
        }
        Object[] objectArray2 = new Object[objectArray.length];
        AttributeDef[] attributeDefArray = this.getKeyAttributeDefs();
        int n = 0;
        while (n < objectArray.length) {
            Class clazz;
            Object object = objectArray[n];
            if (object != null && !(object instanceof NullValue) && !(clazz = attributeDefArray[n].getJavaType()).isInstance(object)) {
                object = ((AttributeDefImpl)attributeDefArray[n]).convertToJava(object);
            }
            objectArray2[n] = object;
            ++n;
        }
        return new Key(objectArray2);
    }

    public Row[] findInCacheByKey(Key key, int n) {
        return this.getDefaultRowSet().findInCacheByKey(key, n);
    }

    public Row[] findByKey(Key key, int n) {
        return this.getDefaultRowSet().findByKey(key, n);
    }

    public void findAndSetCurrentRowByKey(Key key, int n) {
        this.getDefaultRowSet().findAndSetCurrentRowByKey(key, n);
    }

    public Row[] findByKey(Key key, int n, boolean bl) {
        return this.getDefaultRowSet().findByKey(key, n, bl);
    }

    public Key createKey(AttributeList attributeList) {
        return RowSetIteratorHelper.createKey(attributeList, this.getKeyAttributeDefs());
    }

    public Row[] findByEntity(int n, int n2) {
        return this.getDefaultRowSet().findByEntity(n, n2);
    }

    public RowIterator findByViewCriteria(ViewCriteria viewCriteria, int n, int n2) {
        return this.getDefaultRowSet().findByViewCriteria(viewCriteria, n, n2);
    }

    protected void setQueryChanged(boolean bl) {
        if (this.mMaxFetchSize != 0 || bl) {
            this.mQueryChanged = bl ? (this.mQueryChanged |= 1) : 0;
        }
        if (bl) {
            int n = 0;
            while (n < this.mRowSets.size()) {
                ViewRowSetImpl viewRowSetImpl = (ViewRowSetImpl)this.mRowSets.elementAt(n);
                if (viewRowSetImpl != null) {
                    viewRowSetImpl.resetExecuted();
                    viewRowSetImpl.refresh(true, false);
                }
                ++n;
            }
            this.mInitSQLStmtBufLen = -1;
        }
    }

    void setQueryAsChanged(int n) {
        boolean bl;
        boolean bl2 = bl = n != 0;
        if (bl) {
            this.mQueryChanged |= n;
        }
        this.setQueryAsChanged(bl);
    }

    protected void setQueryAsChanged(boolean bl) {
        if (this.mMaxFetchSize != 0 || bl) {
            this.mQueryChanged = bl ? (this.mQueryChanged |= 1) : 0;
            if (bl) {
                this.mInitSQLStmtBufLen = -1;
            }
        }
    }

    protected boolean isQueryChanged() {
        return this.mQueryChanged != 0;
    }

    boolean isRowSetDirty() {
        int n = 0;
        while (n < this.mRowSets.size()) {
            ViewRowSetImpl viewRowSetImpl = (ViewRowSetImpl)this.mRowSets.elementAt(n);
            if (viewRowSetImpl != null && viewRowSetImpl.isDirty()) {
                return true;
            }
            ++n;
        }
        return false;
    }

    protected void notifyRowInserted(ViewRowSetImpl viewRowSetImpl, Row row, int n) {
        viewRowSetImpl.notifyRowInserted(row, n, false, true);
    }

    void addNewRowTracker(QueryCollection queryCollection, ViewRowImpl viewRowImpl, int n, boolean bl) {
        ArrayList arrayList = queryCollection.mNewRowTracker;
        if (bl && arrayList != null && arrayList.size() != 0) {
            int n2 = arrayList.size();
            boolean bl2 = true;
            int n3 = n2 - 1;
            while (n3 >= 0) {
                NewRowTracker newRowTracker = (NewRowTracker)arrayList.get(n3);
                if (newRowTracker.mRow == viewRowImpl || newRowTracker.mRow.getHandle().equals(viewRowImpl.getHandle())) {
                    if (newRowTracker.mIndex != Integer.MIN_VALUE) {
                        return;
                    }
                    this.NewRowTracker_removeAndAdjust(queryCollection, viewRowImpl, Integer.MIN_VALUE);
                    arrayList = queryCollection.mNewRowTracker;
                }
                --n3;
            }
        }
        if (arrayList == null) {
            int n4 = this.getRangeSize();
            queryCollection.mNewRowTracker = arrayList = new ArrayList(n4 < 4 ? 4 : n4);
        }
        arrayList.add((Object)new NewRowTracker(n, viewRowImpl));
    }

    void notifyRowInserted(QueryCollection queryCollection, Row row, int n) {
        this.markQueryCollectionDirty(queryCollection, true);
        if (!this.isInternal()) {
            this.addNewRowTracker(queryCollection, (ViewRowImpl)row, n, true);
        }
        int n2 = 0;
        while (n2 < this.mRowSets.size()) {
            ViewRowSetImpl viewRowSetImpl = (ViewRowSetImpl)this.mRowSets.elementAt(n2);
            if (viewRowSetImpl != null && (viewRowSetImpl.isReceiveAllInsertEvents() || viewRowSetImpl.getQueryCollection() == queryCollection)) {
                viewRowSetImpl.notifyRowInserted(row, n, true, viewRowSetImpl.getQueryCollection() == queryCollection);
            }
            ++n2;
        }
        int n3 = 0;
        while (n3 < this.mRowSets.size()) {
            boolean bl;
            ViewRowSetImpl viewRowSetImpl = (ViewRowSetImpl)this.mRowSets.elementAt(n3);
            boolean bl2 = bl = viewRowSetImpl != null && viewRowSetImpl.getQueryCollection() == queryCollection;
            if (viewRowSetImpl != null && (viewRowSetImpl.isReceiveAllInsertEvents() || bl)) {
                if (bl) {
                    this.notifyRowInserted(viewRowSetImpl, row, n);
                } else {
                    viewRowSetImpl.notifyRowInserted(row, n, false, bl);
                }
            }
            ++n3;
        }
    }

    protected void notifyRowDeleted(ViewRowSetImpl viewRowSetImpl, Row row, int n) {
        viewRowSetImpl.notifyRowDeleted(row, n, false, true);
    }

    void notifyRowDeleted(QueryCollection queryCollection, Row row, int n, boolean bl) {
        this.markQueryCollectionDirty(queryCollection, true);
        if (queryCollection.mNewRowTracker != null) {
            this.NewRowTracker_removeAndAdjust(queryCollection, (ViewRowImpl)row, n);
        }
        int n2 = 0;
        while (n2 < this.mRowSets.size()) {
            ViewRowSetImpl viewRowSetImpl = (ViewRowSetImpl)this.mRowSets.elementAt(n2);
            if (viewRowSetImpl != null && viewRowSetImpl.getQueryCollection() == queryCollection) {
                viewRowSetImpl.notifyRowDeleted(row, n, true, bl);
            }
            ++n2;
        }
        int n3 = 0;
        while (n3 < this.mRowSets.size()) {
            ViewRowSetImpl viewRowSetImpl = (ViewRowSetImpl)this.mRowSets.elementAt(n3);
            if (viewRowSetImpl != null && viewRowSetImpl.getQueryCollection() == queryCollection) {
                this.notifyRowDeleted(viewRowSetImpl, row, n);
            }
            ++n3;
        }
    }

    void notifyRowUpdated(QueryCollection queryCollection, Row row, EntityImpl entityImpl, boolean bl) {
        int[] nArray;
        if (bl) {
            this.markQueryCollectionDirty(queryCollection, true);
        }
        if ((nArray = this.mViewDef.viewAttrsForEntityDef(entityImpl.mEbi)) != null && nArray.length > 0) {
            this.notifyRowUpdated(queryCollection, row, nArray, bl);
        }
    }

    void notifyRowUpdated(QueryCollection queryCollection, Row row, int[] nArray, boolean bl) {
        if (bl) {
            this.markQueryCollectionDirty(queryCollection, true);
        }
        Row[] rowArray = null;
        boolean bl2 = row instanceof EntityImpl;
        if (!bl2) {
            rowArray = new Row[]{row};
        }
        int n = 0;
        while (n < this.mRowSets.size()) {
            ViewRowSetImpl viewRowSetImpl = (ViewRowSetImpl)this.mRowSets.elementAt(n);
            if (viewRowSetImpl != null && (viewRowSetImpl.isReceiveAllInsertEvents() || viewRowSetImpl.getQueryCollection() == queryCollection) && (!bl2 || (rowArray = queryCollection.getRows((EntityImpl)row)) != null && rowArray.length != 0)) {
                this.notifyRowUpdated(viewRowSetImpl, rowArray, nArray);
            }
            ++n;
        }
    }

    protected void notifyRowUpdated(ViewRowSetImpl viewRowSetImpl, Row[] rowArray, int[] nArray) {
        viewRowSetImpl.notifyRowUpdated(rowArray, nArray);
    }

    public RowSet[] getRowSets() {
        ArrayList arrayList = new ArrayList();
        int n = 0;
        while (n < this.mRowSets.size()) {
            ViewRowSetImpl viewRowSetImpl = (ViewRowSetImpl)this.mRowSets.elementAt(n);
            if (viewRowSetImpl != null) {
                arrayList.add((Object)viewRowSetImpl.getRowSet());
            }
            ++n;
        }
        return (RowSet[])arrayList.toArray((Object[])new RowSet[arrayList.size()]);
    }

    int getNumRowSets() {
        return this.mRowSets.size();
    }

    public RowSet findRowSet(String string) {
        if (string == null || string.length() == 0) {
            return this.getRowSet();
        }
        if (!JboNameUtil.isNameValid(string)) {
            throw new InvalidObjNameException(112, string);
        }
        ViewRowSetImpl viewRowSetImpl = this.getRowSetImpl(string);
        if (viewRowSetImpl == null) {
            return null;
        }
        return viewRowSetImpl.getRowSet();
    }

    ViewRowSetImpl getRowSetImpl(String string) {
        return (ViewRowSetImpl)this.mRowSetMap.get(string);
    }

    public ViewRowSetImpl getRowSetImpl(String string, Object object) {
        return this.getRowSetImpl(string);
    }

    String getRowSetName(String string, boolean bl, boolean[] blArray) {
        boolean bl2;
        boolean bl3 = bl2 = string == null || string.equals("");
        while (true) {
            if (bl2) {
                String string2 = this.getName();
                string = new StringBuffer(string2.length() + 4).append(string2).append('_').append(this.mRowSetId++).toString();
            } else if (!MetaObjectManager.getSingleton().is323Compatible() && !JboNameUtil.isNameValid(string)) {
                throw new InvalidObjNameException(112, string);
            }
            if (this.getRowSetImpl(string) == null) break;
            if (!bl2 && !bl) {
                throw new NameClashException(112, string);
            }
            if (!bl) continue;
            bl2 = true;
        }
        blArray[0] = bl2;
        return string;
    }

    ViewRowSetImpl createViewRowSet(String string, boolean bl) {
        boolean[] blArray = new boolean[1];
        ViewRowSetImpl viewRowSetImpl = new ViewRowSetImpl(this, this.getRowSetName(string, bl, blArray), null, bl);
        viewRowSetImpl.setNameGenerated(blArray[0]);
        return viewRowSetImpl;
    }

    protected void addRowSet(ViewRowSetImpl viewRowSetImpl) {
        if (this.mRowSets.size() == 0) {
            this.addTxnAndEntityListeners(this.getDBTransaction());
        }
        this.mRowSets.addElement(viewRowSetImpl);
        this.mRowSetMap.put(viewRowSetImpl.getName(), viewRowSetImpl);
        this.refreshEventPropagation();
    }

    protected void removeRowSet(ViewRowSetImpl viewRowSetImpl) {
        if (viewRowSetImpl == this.mViewRowSet) {
            viewRowSetImpl.setDefaultRS(false);
            this.mViewRowSet = null;
        }
        this.mRowSets.removeElement(viewRowSetImpl);
        this.mRowSetMap.remove(viewRowSetImpl.getName());
        this.mUserRowSets.remove((Object)viewRowSetImpl);
    }

    ArrayList getViewLinkSourceAttributes() {
        return this.mSrcAttributes;
    }

    ArrayList getViewLinksForSourceAttributes() {
        return this.mSrcViewLinks;
    }

    protected ArrayList getViewLinkDestinationAttributes() {
        return this.mDstAttributes;
    }

    int[] getFKeyMap() {
        if (this.mFKeyMap == null) {
            if (this.mDstAttributes == null || this.mDstAttributes.size() == 0) {
                return null;
            }
            int n = this.mDstAttributes.size();
            this.mFKeyMap = new int[n];
            int n2 = 0;
            while (n2 < n) {
                this.mFKeyMap[n2] = ((ViewAttributeDefImpl)this.mDstAttributes.get(n2)).getIndex();
                ++n2;
            }
        }
        return this.mFKeyMap;
    }

    protected boolean isForeignKey(ViewAttributeDefImpl viewAttributeDefImpl) {
        return this.mDstAttributes == null ? false : this.mDstAttributes.contains((Object)viewAttributeDefImpl);
    }

    public long getSignature() {
        return this.mSignature;
    }

    public String getProxyClassName() {
        return this.getViewDef().getEffectiveClientProxyClassName();
    }

    public String getProxyInterfaceName() {
        return this.getViewDef().getComponentInterfaceName();
    }

    protected void setProxyClassName(String string, String string2) {
        this.mProxyClassNames.put((Object)string, (Object)string2);
    }

    public String getRowProxyClassName() {
        return this.getViewDef().getEffectiveRowClientProxyClassName();
    }

    String getRowProxyClassName(String string) {
        if (string != null) {
            return (String)this.mRowProxyClassNames.get((Object)string);
        }
        return null;
    }

    void setRowProxyClassName(String string, String string2) {
        this.mRowProxyClassNames.put((Object)string, (Object)string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove() {
        if (this.getApplicationModule() == null) {
            this.removeInternal();
        } else {
            Object object = this.getSyncLock();
            synchronized (object) {
                this.removeInternal();
            }
        }
    }

    private void removeInternal() {
        this.removeFinderRowSet();
        if (this.mAssocRefs.size() != 0) {
            String string = ((ViewLinkImpl)this.mAssocRefs.get(0)).getName();
            Class clazz = class$oracle$jbo$CSMessageBundle;
            if (clazz == null) {
                clazz = class$oracle$jbo$CSMessageBundle = ViewObjectImpl.class$("oracle.jbo.CSMessageBundle");
            }
            throw new InvalidOperException(clazz, "25008", new Object[]{this.getName(), string});
        }
        this.closeRowSet();
        RowSet[] rowSetArray = this.getRowSets();
        int n = 0;
        while (n < rowSetArray.length) {
            rowSetArray[n].closeRowSet();
            ++n;
        }
        if (this.getParent() != null && this.getRootApplicationModule().hasTransaction()) {
            this.closeStatements();
        }
        super.remove();
    }

    public void closeRowSet() {
        if (this.mViewRowSet != null) {
            this.mViewRowSet.closeRowSet();
        }
    }

    public void closeRowSetIterator() {
        if (this.mViewRowSet != null) {
            this.mViewRowSet.closeRowSetIterator();
        }
    }

    public byte getAccessMode() {
        return this.getDefaultRowSet().getAccessMode();
    }

    public void setAccessMode(byte by) {
        this.getDefaultRowSet().setAccessMode(by);
    }

    public void setForwardOnly(boolean bl) {
        this.getDefaultRowSet().setForwardOnly(bl);
    }

    public boolean isForwardOnly() {
        return this.getDefaultRowSet().isForwardOnly();
    }

    public void setAssociationConsistent(boolean bl) {
        this.getDefaultRowSet().setAssociationConsistent(bl);
    }

    void recalcDefaultAssocConsistent() {
        if ((this.mQueryChanged & 0x1000) == 0) {
            return;
        }
        if ((this.mQueryChanged & 2) != 0) {
            String string = this.getWhereClause();
            if (string == null || string.length() == 0) {
                this.resetDefaultAssocConsistent();
            } else {
                this.setDefaultAssocConsistent(false);
            }
        }
        if (this.mAllWhereFragments && (this.mQueryChanged & 4) != 0) {
            String string = this.getViewCriteriaClause(true);
            if (string == null || string.length() == 0) {
                this.resetDefaultAssocConsistent();
            } else {
                this.setDefaultAssocConsistent(false);
            }
        }
        this.mQueryChanged &= 0xFFFFEFFF;
    }

    private void resetDefaultAssocConsistent() {
        String string;
        if (this.mNonEquiJoinVLCount > 0 || this.mWhere != null && this.mWhere.length() > 0 || this.mCriteriaManager != null && (string = this.mCriteriaManager.getViewCriteriaClause(true)) != null && string.length() > 0) {
            return;
        }
        if (this.getEntityDefCount() == 0) {
            this.mDefaultAssocConsistent = false;
        } else if (ViewRowSetImpl.getDefaultViewLinkMode() != 2) {
            this.mDefaultAssocConsistent = false;
        } else if (this.mViewDef != null) {
            this.mDefaultAssocConsistent = this.hasSingleUpdateParticipant();
        }
    }

    void setDefaultAssocConsistent(boolean bl) {
        this.mDefaultAssocConsistent = this.getEntityDefCount() == 0 ? false : bl;
    }

    boolean isDefaultAssocConsistent() {
        return this.mDefaultAssocConsistent;
    }

    public boolean isFetchComplete() {
        return this.getDefaultRowSet().isFetchComplete();
    }

    public final boolean isMaxFetchSizeExceeded() {
        return this.getDefaultRowSet().isMaxFetchSizeExceeded();
    }

    public boolean isAssociationConsistent() {
        return this.getDefaultRowSet().isAssociationConsistent();
    }

    protected PreparedStatement getPreparedStatement(int n, boolean[] blArray) {
        int n2 = 0;
        StringBuffer stringBuffer = null;
        if (InstrumentedEvent.isActive) {
            stringBuffer = new StringBuffer(100);
            n2 = InstrumentedEvent.startEvent(EventGroup.VIEWOBJECT_GETSTATEMENT, "Viewobject: " + this.getName() + " getting prepared statement");
        }
        PreparedStatement preparedStatement = null;
        boolean bl = true;
        if (this.isQueryChanged()) {
            this.closeStatements();
        } else {
            CacheStatement cacheStatement;
            CacheStatement cacheStatement2 = cacheStatement = this.mFreedStmts.size() > 0 ? (CacheStatement)this.mFreedStmts.get(0) : null;
            if (cacheStatement != null) {
                this.mFreedStmts.remove(0);
                preparedStatement = cacheStatement.mStmt;
                bl = cacheStatement.mNeedsDefines;
                if (bl) {
                    if (Diagnostic.isOn()) {
                        Diagnostic.println("ViewObject: " + this.getName() + " Redefining and reusing prepared Statement");
                    }
                    if (InstrumentedEvent.isActive) {
                        stringBuffer.append("ViewObject: Re-defining and reusing prepared Statement");
                    }
                } else {
                    if (Diagnostic.isOn()) {
                        Diagnostic.println("ViewObject: " + this.getName() + " Reusing defined prepared Statement");
                    }
                    if (InstrumentedEvent.isActive) {
                        stringBuffer.append("ViewObject: Reusing defined prepared Statement");
                    }
                }
            }
        }
        if (preparedStatement == null) {
            String string;
            DBTransactionImpl dBTransactionImpl;
            if (Diagnostic.isOn()) {
                Diagnostic.println("ViewObject: " + this.getName() + " Created new QUERY statement");
            }
            if (InstrumentedEvent.isActive) {
                stringBuffer.append("ViewObject: Creating new QUERY statement");
            }
            if ((preparedStatement = (dBTransactionImpl = this.getDBTransactionImpl()).createReUsePreparedStatement(string = this.buildQuery(n, false), this.getFetchSize())) != null) {
                this.getSQLBuilder().doStatementSetBindingStyle(preparedStatement, this.getBindingStyle());
            }
            if (InstrumentedEvent.isActive) {
                stringBuffer.append(string);
            }
        }
        blArray[0] = bl;
        if (InstrumentedEvent.isActive) {
            InstrumentedEvent.endEvent(n2, stringBuffer.toString());
        }
        return preparedStatement;
    }

    void setBindingStyleForStmt(Statement statement) {
        this.getSQLBuilder().doStatementSetBindingStyle(statement, this.getBindingStyle());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void freeStatement(PreparedStatement preparedStatement, boolean bl, boolean bl2) {
        Object object = this.getSyncLock();
        synchronized (object) {
            if (preparedStatement == null) {
                return;
            }
            DBTransactionImpl dBTransactionImpl = this.getDBTransactionImpl();
            try {
                WeakVector weakVector = this.mQCs.getList();
                int n = 0;
                while (n < weakVector.size()) {
                    QueryCollection queryCollection = (QueryCollection)weakVector.elementAt(n);
                    if (queryCollection != null && queryCollection.mStatement == preparedStatement) {
                        queryCollection.mStatement = null;
                        break;
                    }
                    ++n;
                }
                if (!bl2 && !dBTransactionImpl.isSingleUseStatement(preparedStatement)) {
                    this.mFreedStmts.add((Object)new CacheStatement(preparedStatement, bl));
                } else {
                    if (Diagnostic.isOn()) {
                        Diagnostic.println("ViewObject: " + this.getName() + " close single-use prepared statements");
                    }
                    try {
                        dBTransactionImpl.closeStatement(preparedStatement, true);
                    }
                    catch (Exception exception) {
                    }
                }
                Object var11_10 = null;
                this.mQCs.doneList();
            }
            catch (Throwable throwable) {
                Object var11_11 = null;
                this.mQCs.doneList();
                throw throwable;
            }
        }
    }

    void closeStatements() {
        if (Diagnostic.isOn()) {
            Diagnostic.println("ViewObject: " + this.getName() + " close prepared statements...");
        }
        DBTransactionImpl dBTransactionImpl = this.getDBTransactionImpl();
        try {
            WeakVector weakVector = this.mQCs.getList();
            int n = 0;
            while (n < weakVector.size()) {
                try {
                    QueryCollection queryCollection = (QueryCollection)weakVector.elementAt(n);
                    if (queryCollection != null && queryCollection.mStatement != null) {
                        dBTransactionImpl.closeStatement(queryCollection.mStatement, true);
                        queryCollection.mStatement = null;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ++n;
            }
            Object var7_6 = null;
            this.mQCs.doneList();
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.mQCs.doneList();
            throw throwable;
        }
        this.closeFreedStatements();
    }

    public void closeFreedStatements() {
        if (this.mFreedStmts.size() == 0) {
            return;
        }
        DBTransactionImpl dBTransactionImpl = this.getDBTransactionImpl();
        while (this.mFreedStmts.size() > 0) {
            CacheStatement cacheStatement = (CacheStatement)this.mFreedStmts.get(0);
            dBTransactionImpl.closeStatement(cacheStatement.mStmt, true);
            this.mFreedStmts.remove(0);
        }
    }

    public void showCursorUsage(Writer writer) {
        PrintWriter printWriter = new PrintWriter(writer, true);
        printWriter.println("ViewObject " + this.getName());
        Enumeration enumeration = this.mQCs.elements();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            if (((QueryCollection)enumeration.nextElement()).mStatement == null) continue;
            ++n;
        }
        printWriter.println("\tNumber of prepared statements in-use: " + n);
        printWriter.println("\tNumber of prepared statements freed: " + this.mFreedStmts.size());
    }

    protected void beforeEntityRemove(Entity entity) {
    }

    protected void afterEntityRemove(Entity entity) {
    }

    void afterRowUpdate(EntityImpl entityImpl, int n, int[] nArray, EntityEvent entityEvent, boolean bl, boolean bl2) {
        if (n == 0) {
            return;
        }
        try {
            QueryCollection queryCollection;
            WeakVector weakVector = this.mQCs.getList();
            byte by = entityImpl.getPostState();
            int n2 = n;
            boolean bl3 = true;
            int n3 = 0;
            while (n3 < weakVector.size()) {
                queryCollection = (QueryCollection)weakVector.elementAt(n3);
                if (queryCollection != null) {
                    if (bl) {
                        n2 = this.updateReferenceEntities(queryCollection, entityImpl, n2, nArray, null, queryCollection.getRows(entityImpl), true);
                        bl3 = false;
                    }
                    boolean bl4 = false;
                    if (bl2) {
                        bl4 = this.moveRows(queryCollection, entityImpl, entityEvent);
                    }
                    if (!bl4 && (this.mEventPropagation & EVENT_PROPAGATION_UPDATE) != 0) {
                        int[] nArray2 = new int[n2];
                        System.arraycopy(nArray, 0, nArray2, 0, n2);
                        this.notifyRowUpdated(queryCollection, (Row)entityImpl, nArray2, entityEvent.isMarkQCDirty());
                    }
                }
                ++n3;
            }
            if ((by == 0 || by == -1) && entityImpl.isInRowList()) {
                int n4 = 0;
                while (n4 < weakVector.size()) {
                    queryCollection = (QueryCollection)weakVector.elementAt(n4);
                    if (queryCollection != null && queryCollection.isAssociationConsistent()) {
                        this.createNewRowInQC(queryCollection, entityImpl, entityEvent);
                    }
                    ++n4;
                }
            }
            Object var17_16 = null;
            this.mQCs.doneList();
        }
        catch (Throwable throwable) {
            Object var17_17 = null;
            this.mQCs.doneList();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void sourceChanged(EntityEvent var1_1) {
        if (this.mPrepareRollback) {
            return;
        }
        var31_2 = this.getSyncLock();
        synchronized (var31_2) {
            var2_3 = this.mChgAttrIndUseCount;
            try {
                var3_4 = var1_1.getEntity();
                var4_5 = var1_1.getEventType();
                var5_6 = var3_4.getPostState();
                switch (var4_5) {
                    case 1: {
                        if (var5_6 == 3 || var5_6 == 4) {
                            try {
                                var6_7 = this.mQCs.getList();
                                var7_8 = 0;
                                while (var7_8 < var6_7.size()) {
                                    var8_9 = (QueryCollection)var6_7.elementAt(var7_8);
                                    if (var8_9 != null) {
                                        var8_9.afterRemove(var3_4);
                                    }
                                    ++var7_8;
                                }
                                this.afterEntityRemove(var3_4);
                                var33_10 = null;
                                this.mQCs.doneList();
                            }
                            catch (Throwable var32_12) {
                                var33_11 = null;
                                this.mQCs.doneList();
                                throw var32_12;
                            }
                        }
                        break;
                    }
                    case 0: {
                        if (var5_6 != 2 && var5_6 != 1 && var5_6 != 0 && var5_6 != -1) break;
                        var9_13 = var1_1.getChangedColumns();
                        var10_14 = null;
                        this.getAttributeCount();
                        var11_15 = null;
                        var12_16 = false;
                        var14_17 = 0;
                        var20_18 = var1_1.getOldValues();
                        var21_19 = this.mViewDef.getEntityDefCount() > 1;
                        var22_20 = false;
                        var23_21 = 0;
                        while (var23_21 < var9_13.length) {
                            var18_26 = var3_4.mEbi.getAttributeDefImpl(var9_13[var23_21]);
                            var11_15 = this.mViewDef.viewAttrsForEntityAttr(var18_26);
                            if (var11_15 == null) ** GOTO lbl82
                            var24_28 = 0;
                            while (var24_28 < var11_15.length) {
                                var15_23 = var11_15[var24_28];
                                var19_27 = this.mAttrDefs[var15_23];
                                if (this.mDstAttributes == null || !this.isForeignKey(var19_27)) ** GOTO lbl69
                                var13_22 = false;
                                var16_24 = var3_4.getAttribute(var18_26.mIndex);
                                var17_25 = var20_18[var23_21];
                                if (var17_25 != null && var16_24 != null) {
                                    if (!var16_24.equals(var17_25)) {
                                        var13_22 = true;
                                    }
                                } else if (var17_25 != null || var16_24 != null) {
                                    var13_22 = true;
                                }
                                if (!var13_22) ** GOTO lbl80
                                if (Diagnostic.isOn()) {
                                    // empty if block
                                }
                                var12_16 = true;
lbl69:
                                // 2 sources

                                if (var21_19) {
                                    var22_20 = var19_27.isJoinFK();
                                    if (Diagnostic.isOn() && var22_20) {
                                        Diagnostic.println("VO: " + this.getName() + "Join key '" + var19_27.mName + "' value changed");
                                    }
                                }
                                if (var10_14 == null) {
                                    if (this.mChgAttrIndUseCount == 0) {
                                        ++this.mChgAttrIndUseCount;
                                        var10_14 = this.mChangedAttrIndices;
                                    } else {
                                        var10_14 = new int[this.getAttributeCount()];
                                    }
                                }
                                var10_14[var14_17++] = var15_23;
lbl80:
                                // 2 sources

                                ++var24_28;
                            }
lbl82:
                            // 2 sources

                            ++var23_21;
                        }
                        if ((this.mEventPropagation & ViewObjectImpl.EVENT_PROPAGATION_UPDATE) != 0 || var22_20 || var12_16 || var5_6 == 0 || var5_6 == -1) {
                            this.afterRowUpdate(var3_4, var14_17, var10_14, var1_1, var22_20, var12_16);
                        }
                        break;
                    }
                    case 2: {
                        this.beforeEntityRemove(var3_4);
                        break;
                    }
                    case 3: {
                        try {
                            var25_29 = this.mQCs.getList();
                            var26_30 = var1_1.getNewKey();
                            var27_31 = 0;
                            while (var27_31 < var25_29.size()) {
                                var28_32 = (QueryCollection)var25_29.elementAt(var27_31);
                                if (var28_32 != null && (var29_33 = var28_32.getRows(var3_4)) != null) {
                                    var30_34 = 0;
                                    while (var30_34 < var29_33.length) {
                                        ((ViewRowImpl)var29_33[var30_34]).getRowStorage().setChangedPK(var3_4, var26_30);
                                        ++var30_34;
                                    }
                                }
                                ++var27_31;
                            }
                            var35_35 = null;
                            this.mQCs.doneList();
                            break;
                        }
                        catch (Throwable var34_37) {
                            var35_36 = null;
                            this.mQCs.doneList();
                            throw var34_37;
                        }
                    }
                }
                var37_38 = null;
                this.mChgAttrIndUseCount = var2_3;
            }
            catch (Throwable var36_40) {
                var37_39 = null;
                this.mChgAttrIndUseCount = var2_3;
                throw var36_40;
            }
        }
    }

    public void afterCommit(TransactionEvent transactionEvent) {
        ApplicationModuleImpl applicationModuleImpl = (ApplicationModuleImpl)this.getParent();
        if (Diagnostic.isOn()) {
            Diagnostic.println(this.mObjName + " notify COMMIT ... ");
        }
        if (((ApplicationModuleDefImpl)applicationModuleImpl.getDef()).isRequeryOnCommit()) {
            this.notifyRefresh();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearCache() {
        Object object = this.getSyncLock();
        synchronized (object) {
            this.doClearCache();
            this.notifyViewClearCache();
        }
    }

    void doClearCache() {
        if (Diagnostic.isOn()) {
            Diagnostic.println("Clearing VO cache for " + this.mObjName);
        }
        this.clearQueryCollectionCache();
        this.mDirtyQCs.clear();
        this.notifyRefresh();
    }

    public void afterRollback(TransactionEvent transactionEvent) {
        if (Diagnostic.isOn()) {
            Diagnostic.println(this.mObjName + " notify ROLLBACK ... ");
        }
        this.mPrepareRollback = false;
        this.doClearCache();
    }

    public void afterRemove(TransactionEvent transactionEvent) {
    }

    public void beforeCommit(TransactionEvent transactionEvent) {
    }

    public void beforeRollback(TransactionEvent transactionEvent) {
        this.mPrepareRollback = true;
    }

    public boolean isTransientTransactionListener() {
        return false;
    }

    public void postChanges(TransactionEvent transactionEvent) {
    }

    void afterPost(TransactionEvent transactionEvent) {
        Enumeration enumeration = this.mQCs.elements();
        while (enumeration.hasMoreElements()) {
            QueryCollection queryCollection = (QueryCollection)enumeration.nextElement();
            queryCollection.markForReset();
            this.clearQueryCollectionCache(queryCollection, false);
        }
        if (this.mMaxFetchSize != 0) {
            this.mDirtyQCs.clear();
        }
    }

    void resetIterators(QueryCollection queryCollection) {
        int n = 0;
        while (n < this.mRowSets.size()) {
            ViewRowSetImpl viewRowSetImpl = (ViewRowSetImpl)this.mRowSets.elementAt(n);
            if (viewRowSetImpl != null && queryCollection == viewRowSetImpl.getQueryCollection()) {
                viewRowSetImpl.resetIterators();
            }
            ++n;
        }
    }

    public boolean isPostedToDB() {
        return false;
    }

    public void setPostedToDB(boolean bl) {
    }

    public int getTransPostHandle() {
        return -1;
    }

    public void setTransPostHandle(int n) {
    }

    void beforePost(TransactionEvent transactionEvent) {
    }

    public boolean isTransientTransactionPostListener() {
        return false;
    }

    private void notifyViewClearCache() {
        this.getDBTransactionImpl().fireViewClearCacheEvent(new ViewObject[]{this});
    }

    private void notifyRefresh() {
        int n = 0;
        while (n < this.mRowSets.size()) {
            ViewRowSetImpl viewRowSetImpl = (ViewRowSetImpl)this.mRowSets.elementAt(n);
            if (viewRowSetImpl != null) {
                viewRowSetImpl.resetQC();
            }
            ++n;
        }
        int n2 = 0;
        while (n2 < this.mRowSets.size()) {
            ViewRowSetImpl viewRowSetImpl = (ViewRowSetImpl)this.mRowSets.elementAt(n2);
            if (viewRowSetImpl != null) {
                viewRowSetImpl.notifyRefresh(true, false, false, false, null);
            }
            ++n2;
        }
    }

    public void setListenToEntityEvents(boolean bl) {
        if (this.mListenToEntityEvents == bl) {
            return;
        }
        this.mListenToEntityEvents = bl;
        if (bl) {
            if (this.mRowSets.size() == 0) {
                this.addEntityListeners();
            }
        } else {
            this.removeEntityListeners();
        }
    }

    void addEntityListeners() {
        if (!this.mListenToEntityEvents) {
            return;
        }
        DBTransaction dBTransaction = this.getDBTransaction();
        if (dBTransaction == null || dBTransaction instanceof NullDBTransactionImpl) {
            return;
        }
        EntityDefImpl[] entityDefImplArray = this.getEntityDefs();
        if (entityDefImplArray == null) {
            return;
        }
        int n = 0;
        while (n < entityDefImplArray.length) {
            ((DBTransactionImpl)dBTransaction).findEntityCache(entityDefImplArray[n]).addEntityListener(this);
            ++n;
        }
    }

    void removeEntityListeners() {
        DBTransaction dBTransaction = this.getDBTransaction();
        if (dBTransaction == null || dBTransaction instanceof NullDBTransactionImpl) {
            return;
        }
        EntityDefImpl[] entityDefImplArray = this.getEntityDefs();
        if (entityDefImplArray == null) {
            return;
        }
        int n = 0;
        while (n < entityDefImplArray.length) {
            EntityCache entityCache = ((DBTransactionImpl)dBTransaction).getEntityCache(entityDefImplArray[n]);
            if (entityCache != null) {
                entityCache.removeEntityListener(this);
            }
            ++n;
        }
    }

    void addTxnAndEntityListeners(DBTransaction dBTransaction) {
        if (dBTransaction == null) {
            throw new InvalidObjAccessException(111, this.getName());
        }
        dBTransaction.addTransactionListener(this);
        dBTransaction.addTransactionPostListener(this);
        this.addEntityListeners();
    }

    void propagateEvent(int n) {
        this.mEventPropagation |= n;
    }

    boolean refreshEventPropagation() {
        int n = 0;
        while (n < this.mRowSets.size()) {
            ViewRowSetImpl viewRowSetImpl = (ViewRowSetImpl)this.mRowSets.elementAt(n);
            if (viewRowSetImpl != null && viewRowSetImpl.refreshEventPropagation()) {
                return true;
            }
            ++n;
        }
        return false;
    }

    int updateReferenceEntities(QueryCollection queryCollection, EntityImpl entityImpl, int n, int[] nArray, ViewAttributeDefImpl[] viewAttributeDefImplArray, Row[] rowArray, boolean bl) {
        int n2 = n;
        if (rowArray == null || !(rowArray[0] instanceof ViewRowImpl)) {
            return n2;
        }
        ViewRowImpl viewRowImpl = (ViewRowImpl)rowArray[0];
        int n3 = 0;
        while (n3 < n2) {
            block34: {
                ViewAttributeDefImpl viewAttributeDefImpl;
                block33: {
                    block32: {
                        viewAttributeDefImpl = null;
                        if (viewAttributeDefImplArray == null) break block32;
                        viewAttributeDefImpl = viewAttributeDefImplArray[n3];
                        break block33;
                    }
                    int n4 = nArray[n3];
                    if (n4 < 0) break block34;
                    viewAttributeDefImpl = this.mAttrDefs[n4];
                }
                if (!viewAttributeDefImpl.isJoinFK()) break block34;
                ArrayList arrayList = viewAttributeDefImpl.getEntityAssociationReferences();
                int n5 = 0;
                while (arrayList != null && n5 < arrayList.size()) {
                    block35: {
                        EntityImpl entityImpl2;
                        Key key;
                        EntityImpl entityImpl3 = null;
                        EntityAssociationReference entityAssociationReference = (EntityAssociationReference)arrayList.get(n5);
                        if (!entityAssociationReference.getOtherEntityReference().isReference() || (key = this.getForeignKeys(entityImpl2 = (EntityImpl)viewRowImpl.getEntity(entityAssociationReference.getEntityReference()), entityAssociationReference)) == null) break block35;
                        EntityReference entityReference = entityAssociationReference.getOtherEntityReference();
                        int n6 = this.mViewDef.getEntityIndex(entityReference);
                        EntityImpl entityImpl4 = viewRowImpl.getEntity(n6);
                        AssociationEnd associationEnd = entityAssociationReference.getEntityAssociation().findEndByName(entityAssociationReference.getOtherEndName());
                        if (associationEnd.isPrimaryKeys()) {
                            if (!key.isNull()) {
                                entityImpl3 = entityReference.getEntityDef().findByPKExtended(this.getDBTransactionImpl(), key, true);
                            }
                        } else {
                            Row row = viewRowImpl.getEntity(entityAssociationReference.getEntityReference());
                            AssociationDefImpl associationDefImpl = entityAssociationReference.getAccessor();
                            Object object = associationDefImpl.get(row);
                            if (object instanceof EntityImpl) {
                                entityImpl3 = (EntityImpl)object;
                            } else if (object instanceof RowIterator) {
                                entityImpl3 = (EntityImpl)((RowIterator)object).first();
                            }
                        }
                        if (entityImpl3 == null) {
                            if (entityImpl != null && (entityImpl.getPostState() == 0 || entityImpl.getPostState() == -1) && entityReference.isInsertParticipant() && !key.isNull()) {
                                entityImpl3 = (EntityImpl)viewRowImpl.getEntity(entityReference);
                                this.initReferenceEntity(entityImpl3, key, entityAssociationReference);
                                entityImpl3.getEntityCache().add(entityImpl3);
                                ViewAttributeDefImpl[] viewAttributeDefImplArray2 = entityReference.getViewAttributeDefImpls();
                                if (bl) {
                                    int n7 = 0;
                                    while (n7 < viewAttributeDefImplArray2.length) {
                                        int n8 = viewAttributeDefImplArray2[n7].getAttributeDefImpl().getIndex();
                                        if (entityImpl3.isAttributeChanged(n8)) {
                                            if (viewAttributeDefImplArray == null) {
                                                nArray[n2++] = viewAttributeDefImplArray2[n7].getIndex();
                                            } else {
                                                viewAttributeDefImplArray[n2++] = viewAttributeDefImplArray2[n7];
                                            }
                                        }
                                        ++n7;
                                    }
                                }
                            } else if (Diagnostic.isOn()) {
                                Diagnostic.println("Referenced row not found in VO: " + this.getName() + ", EO base: " + entityReference.getName() + ", key: " + key);
                            }
                        } else {
                            if (entityImpl3.getPostState() == 3) {
                                throw new DeadEntityAccessException(entityImpl3.getEntityDef().getName(), entityImpl3.getPrimaryKey());
                            }
                            if (entityImpl3.getPostState() == 4) {
                                throw new DeadEntityAccessException(entityImpl3.getEntityDef().getName(), entityImpl3.getPrimaryKey());
                            }
                        }
                        if (queryCollection != null) {
                            int n9 = 0;
                            while (n9 < rowArray.length) {
                                queryCollection.updateReference((ViewRowImpl)rowArray[n9], entityImpl3, n6);
                                ++n9;
                            }
                        } else {
                            viewRowImpl.updateReference(n6, entityImpl3);
                        }
                        if (entityImpl4 == entityImpl3) break block35;
                        ViewAttributeDefImpl[] viewAttributeDefImplArray3 = entityReference.getViewAttributeDefImpls();
                        int n10 = 0;
                        while (n10 < viewAttributeDefImplArray3.length) {
                            block37: {
                                ViewAttributeDefImpl viewAttributeDefImpl2;
                                block36: {
                                    viewAttributeDefImpl2 = viewAttributeDefImplArray3[n10];
                                    AttributeDefImpl attributeDefImpl = viewAttributeDefImpl2.getAttributeDefImpl();
                                    if (entityImpl4 == null || entityImpl3 == null) break block36;
                                    int n11 = attributeDefImpl.mIndex;
                                    Object object = entityImpl4.getAttribute(n11);
                                    Object object2 = entityImpl3.getAttribute(n11);
                                    if (object == null || object2 == null ? object == null && object2 == null : object2.equals(object)) break block37;
                                }
                                if (bl) {
                                    if (viewAttributeDefImplArray == null) {
                                        nArray[n2++] = viewAttributeDefImpl2.mIndex;
                                    } else {
                                        viewAttributeDefImplArray[n2++] = viewAttributeDefImpl2;
                                    }
                                }
                            }
                            ++n10;
                        }
                    }
                    ++n5;
                }
            }
            ++n3;
        }
        return n2;
    }

    Key getForeignKeys(EntityImpl entityImpl, EntityAssociationReference entityAssociationReference) {
        AttributeDefImpl[] attributeDefImplArray;
        if (entityImpl != null && (attributeDefImplArray = entityAssociationReference.getEntityAssociation().getAttributeDefImplsByEndName(entityAssociationReference.getEndName())) != null) {
            Object[] objectArray = new Object[attributeDefImplArray.length];
            int n = 0;
            while (n < attributeDefImplArray.length) {
                objectArray[n] = entityImpl.getAttribute(attributeDefImplArray[n].getIndex());
                if (objectArray[n] == null && !entityImpl.isAttributeChanged(attributeDefImplArray[n].getIndex())) {
                    return null;
                }
                ++n;
            }
            return new Key(objectArray);
        }
        return null;
    }

    private boolean createRowWithEntity(int n, EntityImpl entityImpl, QueryCollection queryCollection) {
        ViewRowSetImpl viewRowSetImpl;
        ViewRowImpl viewRowImpl;
        Row[] rowArray;
        boolean bl = false;
        if (!entityImpl.isInRowList() || this.mCreatingEntities) {
            return bl;
        }
        if (n >= 0 && ((rowArray = queryCollection.getRows(entityImpl)) == null || rowArray.length == 0) && this.rowQualifies(viewRowImpl = (ViewRowImpl)(viewRowSetImpl = queryCollection.getRowSetImpl()).createRowWithEntities(new int[]{n}, new EntityImpl[]{entityImpl}, queryCollection.getRowInitValues()))) {
            queryCollection.add(-1, viewRowImpl);
            bl = true;
        }
        return bl;
    }

    private int bldKeysForMovingRows(QueryCollection queryCollection, EntityImpl entityImpl, EntityEvent entityEvent, Object[] objectArray, Object[] objectArray2) {
        int[] nArray = this.getFKeyMap();
        if (nArray == null) {
            return -1;
        }
        RowFilter rowFilter = queryCollection.getRowFilter();
        Object[] objectArray3 = rowFilter.getWhereClauseParams();
        int n = -1;
        int n2 = this.getBindingStyle();
        if (objectArray3 == null) {
            return -1;
        }
        if (n2 == 2) {
            int n3 = 0;
            while (n3 < objectArray3.length) {
                objectArray[n3] = new Object[]{((Object[])objectArray3[n3])[0], ((Object[])objectArray3[n3])[1]};
                ++n3;
            }
        } else {
            System.arraycopy(objectArray3, 0, objectArray, 0, objectArray3.length);
        }
        ViewDefImpl viewDefImpl = this.getViewDef();
        if (objectArray2 != null) {
            if (n2 == 2) {
                int n4 = 0;
                while (n4 < objectArray3.length) {
                    objectArray2[n4] = new Object[]{((Object[])objectArray3[n4])[0], ((Object[])objectArray3[n4])[1]};
                    ++n4;
                }
            } else {
                System.arraycopy(objectArray3, 0, objectArray2, 0, objectArray3.length);
            }
        }
        Object[] objectArray4 = entityEvent.getOldValues();
        int[] nArray2 = entityEvent.getChangedColumns();
        int n5 = queryCollection.getNumUserParams();
        MapInfo[] mapInfoArray = this.getMapInfo();
        int n6 = 0;
        int n7 = objectArray3.length - nArray.length;
        while (n6 < nArray.length) {
            int n8 = nArray[n6];
            if (n8 >= 0) {
                int n9 = mapInfoArray[n8].getSourceIndex();
                if (n9 >= 0 && viewDefImpl.getEntityReference(n9).getEntityDef() == entityImpl.getEntityDef()) {
                    int n10 = mapInfoArray[n8].getIndex();
                    if (n7 >= 0) {
                        if (n2 == 2) {
                            ((Object[])objectArray[n7])[1] = entityImpl.getAttribute(n10);
                        } else {
                            objectArray[n7] = entityImpl.getAttribute(n10);
                        }
                        if (objectArray2 != null) {
                            if (n2 == 2) {
                                ((Object[])objectArray2[n7])[1] = ((Object[])objectArray[n7])[1];
                            } else {
                                objectArray2[n7] = objectArray[n7];
                            }
                            int n11 = 0;
                            while (n11 < nArray2.length) {
                                if (nArray2[n11] == n10) {
                                    if (n2 == 2) {
                                        ((Object[])objectArray2[n7])[1] = objectArray4[n11];
                                    } else {
                                        objectArray2[n7] = objectArray4[n11];
                                    }
                                    break;
                                }
                                ++n11;
                            }
                        }
                    }
                } else {
                    return -1;
                }
                if (n < 0 && n9 >= 0 && this.getEntityDef(n9).isBaseDefFor(entityImpl.getEntityDef())) {
                    n = n9;
                }
            }
            ++n6;
            ++n7;
        }
        return n;
    }

    private void createNewRowInQC(QueryCollection queryCollection, EntityImpl entityImpl, EntityEvent entityEvent) {
        RowFilter rowFilter = queryCollection.getRowFilter();
        ViewDefImpl viewDefImpl = this.getViewDef();
        if (rowFilter == null || this.getFKeyMap() == null) {
            int n;
            int n2 = this.getEntityDefCount();
            if (n2 > 0 && this.getEntityDef(n = 0).isBaseDefFor(entityImpl.getEntityDef()) && viewDefImpl.getEntityReference(n).isInsertParticipant()) {
                this.createRowWithEntity(n, entityImpl, queryCollection);
                return;
            }
            return;
        }
        Object[] objectArray = new Object[rowFilter.getParamLength()];
        int n = this.bldKeysForMovingRows(queryCollection, entityImpl, entityEvent, objectArray, null);
        if (n >= 0 && viewDefImpl.getEntityReference(n).isInsertParticipant() && rowFilter.whereClauseParamQualifies(objectArray)) {
            this.createRowWithEntity(n, entityImpl, queryCollection);
        }
    }

    private boolean performMove(QueryCollection queryCollection, EntityImpl entityImpl) {
        EntityImpl entityImpl2 = queryCollection.getEntityCacheAdd();
        if (entityImpl2 == null) {
            return true;
        }
        if (entityImpl2 == entityImpl) {
            return false;
        }
        Key key = entityImpl2.getOrigPrimaryKey();
        Key key2 = entityImpl.getOrigPrimaryKey();
        return key == null || !key.equals(key2);
    }

    private boolean moveRows(QueryCollection queryCollection, EntityImpl entityImpl, EntityEvent entityEvent) {
        block18: {
            int n;
            Object[] objectArray;
            Object[] objectArray2;
            RowFilter rowFilter;
            block17: {
                Row[] rowArray;
                rowFilter = queryCollection.getRowFilter();
                if (rowFilter == null || this.getFKeyMap() == null) {
                    return false;
                }
                int n2 = rowFilter.getParamLength();
                objectArray2 = new Object[n2];
                n = this.bldKeysForMovingRows(queryCollection, entityImpl, entityEvent, objectArray2, objectArray = new Object[n2]);
                if (n < 0 || !rowFilter.whereClauseParamQualifies(objectArray)) break block17;
                if (Diagnostic.isOn()) {
                    Diagnostic.println(this.mObjName + ": Move rows from this QC");
                }
                if ((rowArray = queryCollection.getRows(entityImpl)) == null) break block18;
                RowFilter[] rowFilterArray = this.getQualifyingRowFilters(objectArray2);
                if (rowFilterArray == null) {
                    rowFilterArray = this.buildQualifyingRowFilters(objectArray2);
                }
                queryCollection.afterRemove(entityImpl);
                int n3 = 0;
                while (n3 < rowArray.length) {
                    if (rowFilterArray != null) {
                        int n4 = 0;
                        while (n4 < rowFilterArray.length) {
                            QueryCollection queryCollection2 = this.getCachedQueryCollection(rowFilterArray[n4]);
                            if (queryCollection2 != null) {
                                queryCollection2.setViewLinkMode(queryCollection.getViewLinkMode());
                                if (this.performMove(queryCollection2, entityImpl)) {
                                    boolean bl = true;
                                    if (queryCollection2.fetchUnpostedRows() && queryCollection2.getRows(entityImpl) != null) {
                                        bl = false;
                                    }
                                    if (bl) {
                                        queryCollection2.add(-1, rowArray[n3]);
                                    }
                                }
                            }
                            ++n4;
                        }
                    }
                    ++n3;
                }
                break block18;
            }
            if (n >= 0 && rowFilter.whereClauseParamQualifies(objectArray2)) {
                RowFilter[] rowFilterArray;
                if (Diagnostic.isOn()) {
                    Diagnostic.println(this.mObjName + ": Move rows into this QC");
                }
                if ((rowFilterArray = this.getQualifyingRowFilters(objectArray)) != null) {
                    int n5 = 0;
                    while (n5 < rowFilterArray.length) {
                        Row[] rowArray;
                        QueryCollection queryCollection3 = this.getCachedQueryCollection(rowFilterArray[n5]);
                        if (queryCollection3 != null && (rowArray = queryCollection3.getRows(entityImpl)) != null) {
                            queryCollection3.afterRemove(entityImpl);
                            int n6 = 0;
                            while (n6 < rowArray.length) {
                                if (this.performMove(queryCollection3, entityImpl)) {
                                    queryCollection.add(-1, rowArray[n6]);
                                }
                                ++n6;
                            }
                        }
                        ++n5;
                    }
                }
            }
        }
        return true;
    }

    void moveRow(ViewRowImpl viewRowImpl, Object[] objectArray) {
        RowFilter[] rowFilterArray = this.getQualifyingRowFilters(objectArray);
        boolean bl = false;
        if (rowFilterArray == null) {
            rowFilterArray = this.buildQualifyingRowFilters(objectArray);
            bl = true;
        }
        if (rowFilterArray != null) {
            int n = 0;
            while (n < rowFilterArray.length) {
                QueryCollection queryCollection = this.getCachedQueryCollection(rowFilterArray[n]);
                if (queryCollection != null) {
                    ArrayList arrayList;
                    queryCollection.setViewLinkMode(viewRowImpl.getQueryCollection().getViewLinkMode());
                    queryCollection.fetchUnpostedRows();
                    boolean bl2 = true;
                    if (!bl && (arrayList = queryCollection.findByKey(viewRowImpl.getKey(), 1)).size() > 0) {
                        bl2 = false;
                    }
                    if (bl2) {
                        queryCollection.add(-1, viewRowImpl);
                    }
                }
                ++n;
            }
        }
    }

    private void initReferenceEntity(EntityImpl entityImpl, Key key, EntityAssociationReference entityAssociationReference) {
        AttributeDefImpl[] attributeDefImplArray = entityAssociationReference.getAccessor().getOtherAttributeDefImpls();
        Object[] objectArray = key.getKeyValues();
        int n = attributeDefImplArray.length - 1;
        while (n >= 0) {
            entityImpl.populateAttributeAsChanged(attributeDefImplArray[n].getIndex(), objectArray[n]);
            --n;
        }
    }

    protected ViewObjectImpl findViewLinkAccessorVO(AssociationDefImpl associationDefImpl, String string, ViewDefImpl viewDefImpl, ViewLinkDefImpl viewLinkDefImpl) {
        return (ViewObjectImpl)this.getRootApplicationModule().findViewObject(string);
    }

    protected ViewObjectImpl createViewLinkAccessorVO(AssociationDefImpl associationDefImpl, String string, ViewDefImpl viewDefImpl, ViewLinkDefImpl viewLinkDefImpl) {
        ViewObjectImpl viewObjectImpl = (ViewObjectImpl)this.getRootApplicationModule().createViewObject(string, viewDefImpl);
        return viewObjectImpl;
    }

    static ViewRowSetImpl doCreateViewLinkAccessorRS(AssociationDefImpl associationDefImpl, ViewObjectImpl viewObjectImpl, Row row, Object[] objectArray) {
        ViewRowSetImpl viewRowSetImpl = viewObjectImpl.createViewRowSet(null, false);
        viewRowSetImpl.setRangeSize(-1);
        viewRowSetImpl.setParamValues(associationDefImpl.getParamValues(viewObjectImpl.getViewDef(), viewObjectImpl.getBindingStyle(), row, objectArray));
        viewRowSetImpl.setStateToPassivate(false);
        return viewRowSetImpl;
    }

    protected ViewRowSetImpl createViewLinkAccessorRS(AssociationDefImpl associationDefImpl, ViewObjectImpl viewObjectImpl, Row row, Object[] objectArray) {
        ViewRowSetImpl viewRowSetImpl = ViewObjectImpl.doCreateViewLinkAccessorRS(associationDefImpl, viewObjectImpl, row, objectArray);
        return viewRowSetImpl;
    }

    protected ViewRowSetImpl createViewLinkScanBaseRS(AssociationDefImpl associationDefImpl, ViewObjectImpl viewObjectImpl, Row row) {
        return viewObjectImpl.getDefaultRowSet();
    }

    void createViewLinkAccessor(String string, String string2, ViewLink viewLink, ViewObject viewObject, ViewObject viewObject2) {
        this.initViewAttributeDefImpls();
        if (this.mAttrDefs == null) {
            return;
        }
        ViewLinkImpl viewLinkImpl = (ViewLinkImpl)viewLink;
        ViewLinkDefImpl viewLinkDefImpl = viewLinkImpl.getViewLinkDef();
        AssociationDefImpl associationDefImpl = null;
        Class clazz = class$oracle$jbo$RowIterator;
        if (clazz == null) {
            clazz = class$oracle$jbo$RowIterator = ViewObjectImpl.class$("oracle.jbo.RowIterator");
        }
        associationDefImpl = new AssociationDefImpl(string, null, clazz);
        associationDefImpl.setAssociation(viewLinkDefImpl);
        associationDefImpl.setEndName(((ViewObjectImpl)viewObject).getViewDef().getName());
        associationDefImpl.setOtherEndName(((ViewObjectImpl)viewObject2).getViewDef().getName());
        associationDefImpl.setAssociationVOName(string2);
        ViewAttributeDefImpl viewAttributeDefImpl = new ViewAttributeDefImpl(string, null, associationDefImpl, viewObject.getAttributeCount(), associationDefImpl.getAttributeKind(), false, null, null, null, null, this);
        viewLinkImpl.setSourceAccessor(viewAttributeDefImpl);
        this.addAttrDef(viewAttributeDefImpl);
        if (this.mDynAttrOffset == -1) {
            this.mDynAttrOffset = this.mAttrDefs.length - 1;
        }
        ++this.mDynAttrCount;
    }

    public AttributeDef findViewLinkAccessor(ViewLink viewLink) {
        this.initViewAttributeDefImpls();
        if (this.mAttrDefs == null) {
            return null;
        }
        ViewLinkImpl viewLinkImpl = (ViewLinkImpl)viewLink;
        ViewLinkDefImpl viewLinkDefImpl = viewLinkImpl.getViewLinkDef();
        if (viewLinkDefImpl == null) {
            Diagnostic.ASSERT(false, "View link definition is null for view link: " + viewLinkImpl.getName());
        }
        int n = 0;
        while (n < this.mAttrDefs.length) {
            ViewAttributeDefImpl viewAttributeDefImpl = this.mAttrDefs[n];
            boolean bl = viewLinkImpl.isReversedUsage();
            boolean bl2 = viewAttributeDefImpl.isReverseAccessor();
            if (viewAttributeDefImpl.findViewLinkDefImpl() == viewLinkDefImpl && (viewLinkImpl.getSource() == this ? !bl && !bl2 || bl && bl2 : viewLinkImpl.getDestination() == this && (!bl && bl2 || bl && !bl2))) {
                return viewAttributeDefImpl;
            }
            ++n;
        }
        return null;
    }

    boolean hasQuery() {
        return this.mViewDef.hasQuery() || this.mUserDefinedQuery != null;
    }

    public ViewRowSetImpl getByKeyFinderRS() {
        return this.mByKeyFinderRS;
    }

    private void setUseOnlyUsageWhere(boolean bl) {
        if (bl == this.mAllWhereFragments) {
            this.mAllWhereFragments = bl ^ true;
            this.setQueryAsChanged(true);
        }
    }

    void removeFinderRowSet() {
        if (this.mByKeyFinderRS != null) {
            ViewObject viewObject = this.mByKeyFinderRS.getViewObject();
            if (viewObject != null) {
                viewObject.remove();
            }
            this.mByKeyFinderRS = null;
        }
    }

    protected ViewObjectImpl createFinderVO(String string) {
        String string2 = JboNameUtil.getInstNameFromDefName(this.getViewDef().getName()) + string;
        ViewObjectImpl viewObjectImpl = (ViewObjectImpl)((ApplicationModuleImpl)this.getApplicationModule()).createViewObject(string2, this.getViewDef());
        viewObjectImpl.setInternal(true);
        viewObjectImpl.bPassivate = false;
        this.initViewAttributeDefImpls();
        return viewObjectImpl;
    }

    protected Row[] retrieveByKey(ViewRowSetImpl viewRowSetImpl, Key key, int n) {
        return this.retrieveByKey(viewRowSetImpl, key, n, false);
    }

    protected Row[] retrieveByKey(ViewRowSetImpl viewRowSetImpl, Key key, int n, boolean bl) {
        ViewObjectImpl viewObjectImpl;
        int n2 = this.getBindingStyle();
        if (this.mByKeyFinderRS == null) {
            Variable[] variableArray;
            VariableValueManager variableValueManager;
            viewObjectImpl = this.createFinderVO("_findByKey_");
            viewObjectImpl.getAttributeCount();
            viewObjectImpl.mKeyAttrRefs = this.mKeyAttrRefs;
            if (n2 == 2 && (variableValueManager = this.getVariableManager()) != null && (variableArray = variableValueManager.getVariablesOfKind("where")) != null) {
                int n3 = 0;
                while (n3 < variableArray.length) {
                    Variable variable = variableArray[n3];
                    viewObjectImpl.defineNamedWhereClauseParam(variable.getName(), variable.getDefaultValue(), (int[])variable.getExtendedData());
                    ++n3;
                }
            }
        } else {
            viewObjectImpl = (ViewObjectImpl)this.mByKeyFinderRS.getViewObject();
        }
        viewObjectImpl.setUseOnlyUsageWhere(bl);
        EntityReference[] entityReferenceArray = this.getViewDef().getEntityReferences();
        StringBuffer stringBuffer = new StringBuffer(100);
        viewRowSetImpl.setExecuteMaster(true);
        boolean bl2 = false;
        Object[] objectArray = null;
        int n4 = 0;
        if (!bl || this.isFullSql()) {
            String string;
            objectArray = viewRowSetImpl.getParameters(false);
            String string2 = this.getWhereClause();
            if (string2 != null && string2.length() > 0) {
                stringBuffer.append(string2);
                bl2 = true;
            }
            if ((string = this.getViewCriteriaClause()) != null && string.length() > 0) {
                stringBuffer.append(bl2 ? " AND " : "").append(string);
                bl2 = true;
            }
            if ((string = this.getAssociationClause(n4 = viewRowSetImpl.getWhereClauseParams().length)) != null && string.length() > 0) {
                stringBuffer.append(bl2 ? " AND " : "").append(string);
                bl2 = true;
            }
        }
        Object[] objectArray2 = key.getKeyValues();
        AttributeDefImpl[] attributeDefImplArray = (AttributeDefImpl[])this.getKeyAttributeDefs();
        ArrayList arrayList = new ArrayList(objectArray2.length);
        boolean bl3 = false;
        if (objectArray != null) {
            n4 = objectArray.length;
        }
        int n5 = 0;
        while (n5 < objectArray2.length) {
            if (objectArray2[n5] != null) {
                if (n5 < attributeDefImplArray.length) {
                    String string = ((ViewAttributeDefImpl)attributeDefImplArray[n5]).getColumnNameForQuery();
                    if (string.indexOf(46) > 0 || this.isFullSql() && string.equals(((ViewAttributeDefImpl)attributeDefImplArray[n5]).getAliasName())) {
                        stringBuffer.append(bl2 ? " AND " : "").append(string);
                    } else {
                        stringBuffer.append(bl2 ? " AND " : "").append("\"").append(string).append("\"");
                    }
                } else {
                    Class clazz = class$oracle$jbo$CSMessageBundle;
                    if (clazz == null) {
                        clazz = class$oracle$jbo$CSMessageBundle = ViewObjectImpl.class$("oracle.jbo.CSMessageBundle");
                    }
                    throw new InvalidParamException(clazz, "25043", new Object[]{objectArray2[n5], new Integer(n5), this.getName()});
                }
                bl2 = true;
                if (objectArray2[n5] instanceof NullValue) {
                    stringBuffer.append(" IS NULL");
                    bl3 = true;
                } else {
                    if (n2 == 1 || n2 == 2) {
                        stringBuffer.append(" = :").append(++n4);
                    } else {
                        stringBuffer.append(" = ?");
                    }
                    arrayList.add(objectArray2[n5]);
                }
            } else {
                bl3 = true;
            }
            ++n5;
        }
        viewObjectImpl.setWhereClause(stringBuffer.toString());
        this.mByKeyFinderRS = this.mByKeyFinderRS == null ? viewObjectImpl.getDefaultRowSet() : viewObjectImpl.createViewRowSet(null, false);
        this.mByKeyFinderRS.setAssociationConsistent(false);
        this.mByKeyFinderRS.setWhereClauseParams(null);
        if (objectArray != null || arrayList.size() > 0) {
            int n6 = 0;
            int n7 = 0;
            while (objectArray != null && n7 < objectArray.length) {
                if (n2 != 2) {
                    this.mByKeyFinderRS.setWhereClauseParam(n6++, objectArray[n7]);
                } else {
                    String string = (String)((Object[])objectArray[n7])[0];
                    Object object = ((Object[])objectArray[n7])[1];
                    VariableValueManager variableValueManager = this.mByKeyFinderRS.getVariableManager();
                    if (variableValueManager == null || variableValueManager.lookupVariable(string) == null) {
                        this.mByKeyFinderRS.defineNamedWhereClauseParam(string, null, null);
                    }
                    this.mByKeyFinderRS.setNamedWhereClauseParam((String)((Object[])objectArray[n7])[0], ((Object[])objectArray[n7])[1]);
                    ++n6;
                }
                ++n7;
            }
            int n8 = 0;
            while (n8 < arrayList.size()) {
                this.mByKeyFinderRS.setWhereClauseParam(n6++, arrayList.get(n8));
                ++n8;
            }
        }
        viewObjectImpl.setOrderByClause(this.getOrderByClause());
        this.mByKeyFinderRS.setRangeSize(n);
        viewObjectImpl.setMaxFetchSize(-1);
        this.mByKeyFinderRS.executeQuery();
        Row[] rowArray = this.mByKeyFinderRS.getAllRowsInRange();
        return !bl3 && entityReferenceArray != null ? this.mByKeyFinderRS.findByKey(key, n, bl, true) : rowArray;
    }

    public static ViewRowSetIteratorImpl getImplObject(Object object) {
        ViewRowSetIteratorImpl viewRowSetIteratorImpl = object instanceof ViewObjectImpl ? ((ViewObjectImpl)object).getDefaultRowSet().getDefaultRowSetIterator() : (object instanceof ViewRowSetImpl ? ((ViewRowSetImpl)object).getDefaultRowSetIterator() : (ViewRowSetIteratorImpl)object);
        return viewRowSetIteratorImpl;
    }

    public final String createXMLDefinition(int n) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        StringBuffer stringBuffer = new StringBuffer("<!ELEMENT ").append(this.getXMLElementTag()).append(" (").append(this.printXMLDefinition(this.createViewRowSet(null, false), new Hashtable(this.getAttributeDefs().length + 2), printWriter, n)).append("+)>");
        printWriter.println(stringBuffer);
        stringWriter.flush();
        return stringWriter.toString();
    }

    ViewRowSetImpl createSecondaryRowSetForWriteXML(ViewRowSetImpl viewRowSetImpl) {
        ViewRowSetImpl viewRowSetImpl2 = this.createViewRowSet(null, false);
        QueryCollection queryCollection = viewRowSetImpl.mQC;
        ArrayList arrayList = new ArrayList(5);
        if (queryCollection != null && queryCollection.getRowCount() > 0) {
            int n = 0;
            while (n < queryCollection.getRowCount()) {
                arrayList.add(queryCollection.get(n));
                ++n;
            }
        }
        viewRowSetImpl2.executeQuery();
        boolean bl = viewRowSetImpl2.mQC != viewRowSetImpl.mQC;
        int n = 0;
        while (n < arrayList.size()) {
            viewRowSetImpl2.insertRow(bl ? (Row)arrayList.get(n) : viewRowSetImpl2.makeRowCopy((ViewRowImpl)arrayList.get(n)));
            ++n;
        }
        viewRowSetImpl2.setForwardOnly(true);
        return viewRowSetImpl2;
    }

    public Node writeXML(long l, HashMap hashMap) {
        XMLDocument xMLDocument = new XMLDocument();
        hashMap = ViewRowImpl.validateVOAttrXMLRules(this.getViewDef().getFullName(), hashMap);
        ViewRowSetImpl viewRowSetImpl = this.getDefaultRowSet();
        Element element = xMLDocument.createElement(this.getXMLElementTag());
        xMLDocument.appendChild((Node)element);
        this.appendXMLElementNodes(viewRowSetImpl, (Document)xMLDocument, element, -2, l, hashMap);
        Element element2 = xMLDocument.getDocumentElement();
        element2.getParentNode().removeChild(element2);
        return element2;
    }

    public Node writeXML(int n, long l, XSLStylesheet xSLStylesheet) {
        return JboXMLUtil.writeAndProcessXML((XMLInterface)this, n, l, xSLStylesheet);
    }

    public Node writeXML(long l, HashMap hashMap, XSLStylesheet xSLStylesheet) {
        return JboXMLUtil.writeAndProcessXML((XMLInterface)this, l, hashMap, xSLStylesheet);
    }

    public final Node writeXML(int n, long l) {
        XMLDocument xMLDocument = new XMLDocument();
        ViewRowSetImpl viewRowSetImpl = this.getDefaultRowSet();
        Element element = xMLDocument.createElement(this.getXMLElementTag());
        xMLDocument.appendChild((Node)element);
        this.appendXMLElementNodes(viewRowSetImpl, (Document)xMLDocument, element, n, l);
        Element element2 = xMLDocument.getDocumentElement();
        element2.getParentNode().removeChild(element2);
        return element2;
    }

    protected String printXMLDefinition(RowSetImpl rowSetImpl, Hashtable hashtable, PrintWriter printWriter, int n) {
        return rowSetImpl.printXMLDefinition(hashtable, printWriter, n);
    }

    protected void appendXMLElementNodes(RowSetImpl rowSetImpl, Document document, Node node, int n, long l, HashMap hashMap) {
        rowSetImpl.getXMLElementNode(document, node, n, l, hashMap);
    }

    protected void appendXMLElementNodes(RowSetImpl rowSetImpl, Document document, Node node, int n, long l) {
        rowSetImpl.getXMLElementNode(document, node, n, l, null);
    }

    public final void readXML(Element element, int n, XSLStylesheet xSLStylesheet) {
        JboXMLUtil.processAndReadXML(this, element, n, xSLStylesheet);
    }

    public final void readXML(Element element, int n) {
        ViewRowSetImpl viewRowSetImpl = this.getDefaultRowSet();
        if (!viewRowSetImpl.isExecuted()) {
            viewRowSetImpl.executeQuery();
        }
        this.updateRowSetFromXML(element, n, viewRowSetImpl);
    }

    public void readFromXml(XmlDocumentReader xmlDocumentReader, Element element) {
        Element element2;
        ViewRowSetImpl viewRowSetImpl = this.getDefaultRowSet();
        if (!viewRowSetImpl.isExecuted()) {
            viewRowSetImpl.executeQuery();
        }
        NodeIterator nodeIterator = xmlDocumentReader.createRowNodeIterator(this, element);
        ArrayList arrayList = this.updateRowSetFromXML(element, -2, viewRowSetImpl, xmlDocumentReader, nodeIterator);
        NodeIterator nodeIterator2 = xmlDocumentReader.createDeletedRowNodeIterator(this, element);
        while ((element2 = (Element)nodeIterator2.nextNode()) != null) {
            element2.setAttribute("bc4j-action", "remove");
        }
        while (nodeIterator2.previousNode() != null) {
        }
        ArrayList arrayList2 = this.updateRowSetFromXML(element, -2, viewRowSetImpl, xmlDocumentReader, nodeIterator2);
        if (arrayList2.size() > 0) {
            arrayList.addAll((Collection)arrayList2);
        }
        if (arrayList.size() > 0) {
            throw new ReadXMLException(element.getTagName(), arrayList);
        }
    }

    public String getXMLElementTag() {
        String string = (String)this.getProperty("XML_ELEMENT");
        return string != null ? string : this.mViewDef.getXMLElementTag();
    }

    public String getXMLRowElementTag() {
        return this.mViewDef.getXMLRowElementTag();
    }

    protected void updateRowSetFromXML(Element element, int n, RowSetImpl rowSetImpl) {
        RowNodeFilter rowNodeFilter;
        DocumentTraversal documentTraversal = (DocumentTraversal)((Object)element.getOwnerDocument());
        NodeIterator nodeIterator = documentTraversal.createNodeIterator(element, 1, rowNodeFilter = new RowNodeFilter(element, this.getViewDef().getXMLRowElementTag()), false);
        ArrayList arrayList = this.updateRowSetFromXML(element, n, rowSetImpl, null, nodeIterator);
        if (arrayList.size() > 0) {
            throw new ReadXMLException(element.getTagName(), arrayList);
        }
    }

    ArrayList updateRowSetFromXML(Element element, int n, RowSetImpl rowSetImpl, XmlDocumentReader xmlDocumentReader, NodeIterator nodeIterator) {
        AttributeDefImpl[] attributeDefImplArray = (AttributeDefImpl[])this.getKeyAttributeDefs();
        Object[] objectArray = this.getDefaultKeyValues(rowSetImpl);
        Element element2 = (Element)nodeIterator.nextNode();
        AttributeDefImpl[] attributeDefImplArray2 = new AttributeDefImpl[attributeDefImplArray.length];
        System.arraycopy(attributeDefImplArray, 0, attributeDefImplArray2, 0, attributeDefImplArray2.length);
        AttributeDefImpl[] attributeDefImplArray3 = this.getViewAttributeDefImpls();
        Object[] objectArray2 = new Object[objectArray.length];
        ArrayList arrayList = new ArrayList(1);
        Key key = null;
        while (element2 != null) {
            System.arraycopy(objectArray, 0, objectArray2, 0, objectArray.length);
            boolean bl = this.readKeyAttributes(xmlDocumentReader, element2, attributeDefImplArray2, objectArray2);
            key = new Key(objectArray2);
            Row[] rowArray = rowSetImpl.findByKey(key, 2);
            if (rowArray != null && rowArray.length > 1) {
                ArrayList arrayList2 = new ArrayList(1);
                arrayList2.add((Object)new TooManyObjectsException(this.getViewDef().getFullName(), key));
                arrayList.add((Object)new RowReadXMLException(key, element2.getTagName(), arrayList2));
            } else {
                Object object = ViewRowImpl.updateRowFromXML(rowSetImpl, n, element2, attributeDefImplArray3, bl, (ViewRowImpl)(rowArray != null && rowArray.length > 0 ? rowArray[0] : null), true, xmlDocumentReader);
                if (object != null) {
                    RowReadXMLException rowReadXMLException = (RowReadXMLException)object;
                    rowReadXMLException.setRowKey(new Key(key.getKeyValues()));
                    arrayList.add(object);
                }
            }
            element2 = (Element)nodeIterator.nextNode();
        }
        nodeIterator.detach();
        return arrayList;
    }

    protected boolean checkPassivateViewAttributes() {
        return this.getViewDef().isPassivateTransients();
    }

    protected final boolean isPassivatableTransientAttribute(ViewAttributeDefImpl viewAttributeDefImpl) {
        return viewAttributeDefImpl.isPassivatableTransientAttribute(this);
    }

    protected final void setPassivatableTransientAttribute(ViewAttributeDefImpl viewAttributeDefImpl, boolean bl) {
        if (viewAttributeDefImpl != null && this.findAttributeDef(viewAttributeDefImpl.getName()) == viewAttributeDefImpl) {
            viewAttributeDefImpl.mPassivate = bl;
        }
    }

    protected void passivateState(Document document, Element element) {
    }

    protected void passivateState(ViewRowImpl viewRowImpl, Document document, Element element) {
        if (this.mViewRowSet != null) {
            this.passivateState(this.getDefaultRowSet(), viewRowImpl, document, element);
        }
    }

    protected void passivateState(ViewRowSetImpl viewRowSetImpl, ViewRowImpl viewRowImpl, Document document, Element element) {
        ViewAttributeDefImpl[] viewAttributeDefImplArray;
        if ((this.getCalculatedAttributeCount() > 0 || this.isViewLinkAccessorRetained()) && (viewAttributeDefImplArray = this.mAttrDefs) != null) {
            int n = viewAttributeDefImplArray.length;
            ArrayList arrayList = new ArrayList(n);
            int n2 = 0;
            while (n2 < n) {
                switch (viewAttributeDefImplArray[n2].getAttributeKind()) {
                    case 1: 
                    case 3: 
                    case 4: {
                        if (!this.isPassivatableTransientAttribute(viewAttributeDefImplArray[n2])) break;
                        arrayList.add((Object)viewAttributeDefImplArray[n2]);
                    }
                }
                ++n2;
            }
            n = arrayList.size();
            if (n > 0) {
                if (this.mKeyAttrRefs != null && this.mKeyAttrRefs.length == 0 && Diagnostic.isOn()) {
                    Diagnostic.println("*** ViewObject:" + this.getName() + " with no Key Attribute will fail on activation! ***");
                }
                if (viewRowSetImpl.isDefaultRS()) {
                    this.passivateTransients(null, (AttributeDefImpl[])arrayList.toArray((Object[])new ViewAttributeDefImpl[n]), document, element);
                } else {
                    this.passivateTransients(viewRowSetImpl, null, (AttributeDefImpl[])arrayList.toArray((Object[])new ViewAttributeDefImpl[n]), document, element);
                }
            }
        }
    }

    AttributeDefImpl[] getVOManagedAttributes() {
        ViewAttributeDefImpl[] viewAttributeDefImplArray = this.getViewAttributeDefImpls();
        ArrayList arrayList = new ArrayList();
        int n = 0;
        while (n < viewAttributeDefImplArray.length) {
            switch (viewAttributeDefImplArray[n].getAttributeKind()) {
                case 1: 
                case 3: 
                case 4: {
                    arrayList.add((Object)viewAttributeDefImplArray[n]);
                }
            }
            ++n;
        }
        return (AttributeDefImpl[])arrayList.toArray((Object[])new AttributeDefImpl[arrayList.size()]);
    }

    /*
     * Unable to fully structure code
     */
    protected void passivateNewRowTracker(QueryCollection var1_1, RowFilterKey var2_2, Document var3_3, Element var4_4) {
        var7_5 = (XMLElement)var3_3.createElement("QC");
        var6_6 = var3_3.createElement("Ke");
        var6_6.appendChild(var3_3.createTextNode(var2_2.streamToString()));
        var7_5.appendChild((Node)var6_6);
        var8_7 = var1_1.mNewRowTracker;
        var9_8 = var8_7 != null ? var8_7.size() : 0;
        var11_9 = this.getVOManagedAttributes();
        var12_10 = 0;
        while (var12_10 < var9_8) {
            var10_12 = (NewRowTracker)var8_7.get(var12_10);
            var13_13 = var10_12.mRow;
            var14_14 = var13_13.getEntities();
            if (var14_14 == null || var14_14.length <= 0) ** GOTO lbl-1000
            var15_15 = false;
            var16_16 = 0;
            while (var16_16 < var14_14.length) {
                if (var14_14[var16_16] != null && ((var17_17 = var14_14[var16_16].getEntityState()) == 0 || var17_17 == -1)) {
                    var15_15 = true;
                    break;
                }
                ++var16_16;
            }
            if (!var15_15) {
                var8_7.remove(var12_10);
                --var12_10;
                --var9_8;
            } else lbl-1000:
            // 2 sources

            {
                var5_11 = (XMLElement)var3_3.createElement("NR");
                var6_6 = var3_3.createElement("Ke");
                var6_6.appendChild(var3_3.createTextNode(var10_12.mRow.getKey().toStringFormat(false)));
                var5_11.appendChild((Node)var6_6);
                if (var13_13.getPostState() == -1) {
                    var18_18 = (XMLElement)var3_3.createElement("Row");
                    var19_19 = this.getInsertParticipants();
                    var20_20 = 0;
                    while (var20_20 < var19_19.length) {
                        var21_21 = (XMLElement)var3_3.createElement("EO");
                        var21_21.setAttribute("Name", new Integer(var20_20).toString());
                        var14_14[var20_20].appendXMLElementNodes(var3_3, (Node)var21_21, 0, 0x10000000L, var14_14[var20_20].getAttributeDefImpls());
                        var18_18.appendChild((Node)var21_21);
                        ++var20_20;
                    }
                    if (var11_9.length > 0) {
                        var22_22 = (XMLElement)var3_3.createElement("Attrs");
                        var13_13.appendXMLElementNodes(var3_3, (Node)var22_22, 0, 0L, var11_9);
                        if (var22_22.getChildNodes().getLength() > 0) {
                            var18_18.appendChild((Node)var22_22);
                        }
                    }
                    var5_11.appendChild((Node)var18_18);
                    var5_11.setAttribute("New", "1");
                }
                var5_11.setAttribute("Hdl", var13_13.getHandle().toString());
                var5_11.setAttribute("Idx", new Integer(var10_12.mIndex).toString());
                var7_5.appendChild((Node)var5_11);
            }
            ++var12_10;
        }
        if (var9_8 > 0) {
            var4_4.appendChild((Node)var7_5);
        }
    }

    protected void passivateTransients(ViewRowImpl viewRowImpl, AttributeDefImpl[] attributeDefImplArray, Document document, Element element) {
        if (this.mViewRowSet != null) {
            this.passivateTransients(this.getDefaultRowSet(), viewRowImpl, attributeDefImplArray, document, element);
        }
    }

    protected void passivateTransients(ViewRowSetImpl viewRowSetImpl, ViewRowImpl viewRowImpl, AttributeDefImpl[] attributeDefImplArray, Document document, Element element) {
        Object var10_6 = null;
        boolean bl = false;
        int n = viewRowSetImpl.getFetchedRowCount();
        if (n > 0) {
            ViewRowImpl viewRowImpl2;
            int n2 = 0;
            if (viewRowImpl == null) {
                bl = true;
                viewRowImpl2 = (ViewRowImpl)viewRowSetImpl.getRow(n2++);
            } else {
                viewRowImpl2 = viewRowImpl;
            }
            if (viewRowImpl2 != null) {
                do {
                    Element element2 = null;
                    element2 = document.createElement(TRANSIENT_DATA_ROWTAG);
                    Element element3 = document.createElement(DATA_ROWKEYTAG);
                    element3.appendChild(document.createTextNode(viewRowImpl2.getKey().toStringFormat(false)));
                    element2.appendChild(element3);
                    int n3 = 0;
                    while (n3 < attributeDefImplArray.length) {
                        Element element4 = viewRowImpl2.renderAttributeInXMLElement(document, attributeDefImplArray[n3], false);
                        if (element4 != null) {
                            element2.appendChild(element4);
                        }
                        ++n3;
                    }
                    if (!element2.getFirstChild().equals(element2.getLastChild())) {
                        element.appendChild(element2);
                    }
                    if (!bl || n2 >= n) break;
                    viewRowImpl2 = (ViewRowImpl)viewRowSetImpl.getRow(n2++);
                } while (viewRowImpl2 != null);
            }
        }
    }

    protected void activateNewRowTracker(Element element) {
        this.activateNewRowTracker(this.getDefaultRowSet(), element);
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void activateNewRowTracker(ViewRowSetImpl var1_1, Element var2_2) {
        try {
            block63: {
                block61: {
                    var3_3 = null;
                    var4_4 = var2_2.getElementsByTagName("QC");
                    var5_5 = var4_4.getLength();
                    if (var5_5 == 0) {
                        return;
                    }
                    var6_6 = this.getKeyAttributeDefs();
                    var7_7 = var6_6.length;
                    var8_8 = this.getViewDef();
                    var9_9 = var8_8.getEntityReferences();
                    var10_10 = var9_9 != null ? var9_9.length : 0;
                    var11_11 = new int[var10_10];
                    var12_12 = new EntityImpl[var10_10];
                    var28_13 = null;
                    var20_14 = 0;
                    while (true) {
                        if (var20_14 >= var7_7) {
                            var29_15 = var1_1.getWhereClauseParams().length;
                            var31_16 = var2_2.getAttribute("Ex");
                            if (var31_16.length() > 0 || var1_1.isExecuted()) {
                                var30_17 = var1_1.getViewLinkMode();
                                ** try [egrp 1[TRYBLOCK] [0 : 169->190)] { 
lbl23:
                                // 1 sources

                                break;
                            }
                            break block61;
                        }
                        if (((ViewAttributeDefImpl)var6_6[var20_14]).mAttrDesc == null) {
                            if (var28_13 == null) {
                                var28_13 = new boolean[var7_7];
                            }
                            var28_13[var20_14] = true;
                        }
                        ++var20_14;
                    }
                    {
                        var1_1.setViewLinkMode((byte)0);
                        var1_1.execute(true, true, true, false, false, null);
                        var71_18 = null;
                        var1_1.setViewLinkMode(var30_17);
                        try {
                            var32_20 = this.mQCs.getList();
                            var21_22 = 0;
                            while (true) {
                                if (var21_22 >= var32_20.size()) {
                                    v0 = null;
                                    break;
                                }
                                var13_24 = (QueryCollection)var32_20.elementAt(var21_22);
                                if (var13_24 != null) {
                                    var13_24.setAssociationConsistent(var1_1.isAssociationConsistent());
                                }
                                ++var21_22;
                            }
                        }
                        catch (Throwable var72_26) {
                            v0 = null;
                        }
                        var73_28 = v0;
                        this.mQCs.doneList();
                        break block63;
                    }
lbl54:
                    // 1 sources

                    catch (Throwable var70_30) {
                        var71_19 = null;
                        var1_1.setViewLinkMode(var30_17);
                        ** try [egrp 2[TRYBLOCK] [1 : 206->269)] { 
lbl59:
                        // 1 sources

                        var32_21 = this.mQCs.getList();
                        var21_23 = 0;
                        while (true) {
                            if (var21_23 >= var32_21.size()) {
                                v1 = null;
                            }
                            var13_25 = (QueryCollection)var32_21.elementAt(var21_23);
                            if (var13_25 != null) {
                                var13_25.setAssociationConsistent(var1_1.isAssociationConsistent());
                            }
                            ++var21_23;
                        }
lbl70:
                        // 1 sources

                        catch (Throwable var72_27) {
                            v1 = null;
                        }
                    }
                    var73_29 = v1;
                    this.mQCs.doneList();
                    throw var70_30;
                }
                var1_1.ensureStorage();
            }
            var33_31 = var1_1.mParamValues;
            var34_32 = var1_1.getQueryCollection();
            var35_33 = new ArrayList[var10_10];
            var39_34 = this.getDBTransactionImpl();
            var21_22 = 0;
            while (true) {
                block65: {
                    if (var21_22 < var10_10) break block65;
                    var40_38 = null;
                    var41_39 = var1_1.isDefaultRS();
                    var42_40 = 0;
                    if (true) ** GOTO lbl283
                }
                var36_35 = var9_9[var21_22].getEntityDef();
                var37_36 = var39_34.getEntityCache(var36_35);
                var38_37 = var37_36.getModifiedRows();
                if (var38_37 != null) {
                    var35_33[var21_22] = (ArrayList)var38_37.clone();
                }
                var11_11[var21_22] = var21_22;
                ++var21_22;
            }
        }
        catch (JboException var68_80) {
            throw var68_80;
        }
        catch (Exception var69_81) {
            throw new JboException(var69_81);
        }
        do {
            var14_41 = (Element)var4_4.item(var42_40);
            if (var41_39) {
                var24_49 = var14_41.getFirstChild();
                var22_47 = RowFilterKey.streamStringToValues(var24_49.getFirstChild().getNodeValue());
                var23_48 = this.buildRowFilter(var22_47);
                var13_24 = var23_48.isNull() != false ? var34_32 : this.getCachedQueryCollection(var23_48);
                if (var13_24 == null) {
                    var13_24 = this.getCachedQueryCollection(this.buildNewCollection(var22_47));
                    var13_24.setAssociationConsistent(var1_1.isAssociationConsistent());
                }
                var1_1.setParamValues(var22_47);
                var1_1.setQueryCollection(var13_24);
                var30_17 = var13_24.getViewLinkMode();
                try {
                    var13_24.setViewLinkMode((byte)0);
                    var13_24.executeQuery(var22_47, var29_15);
                    var75_78 = null;
                    var13_24.setViewLinkMode(var30_17);
                }
                catch (Throwable var74_79) {
                    var75_78 = null;
                    var13_24.setViewLinkMode(var30_17);
                    throw var74_79;
                }
            } else {
                var13_24 = var1_1.getQueryCollection();
                var22_47 = var33_31;
            }
            var16_43 = var14_41.getElementsByTagName("NR");
            var18_45 = var16_43.getLength();
            var43_53 = this.getVOManagedAttributes();
            var20_14 = 0;
            while (var20_14 < var18_45) {
                block67: {
                    block70: {
                        block69: {
                            block68: {
                                var15_42 = (Element)var16_43.item(var20_14);
                                var25_50 = new Key(var15_42.getFirstChild().getFirstChild().getNodeValue(), var6_6);
                                var27_52 = true;
                                var21_22 = 0;
                                while (var21_22 < var10_10) {
                                    block64: {
                                        var26_51 = ViewRowImpl.getEntityKeyFromViewRowKey(var25_50, var21_22, this);
                                        try {
                                            block66: {
                                                if (var26_51 != null) break block66;
                                                var38_37 = var35_33[var21_22];
                                                var12_12[var21_22] = null;
                                                if (var38_37 == null) break block64;
                                                var45_55 = 0;
                                                if (true) ** GOTO lbl167
                                            }
                                            var12_12[var21_22] = var9_9[var21_22].getEntityDef().findByPrimaryKey(var39_34, var26_51);
                                        }
                                        catch (Exception var46_56) {
                                            if (Diagnostic.isOn()) {
                                                Diagnostic.printStackTrace(var46_56);
                                            }
                                            var12_12[var21_22] = null;
                                        }
                                        break block64;
                                        do {
                                            var44_54 = (EntityImpl)var38_37.get(0);
                                            var38_37.remove(0);
                                            if (!(var44_54.getKey() != null || var3_3 != null && var3_3.contains((Object)var44_54))) {
                                                var12_12[var21_22] = var44_54;
                                                if (var3_3 == null) {
                                                    var3_3 = new ArrayList();
                                                }
                                                var3_3.add((Object)var44_54);
                                                break;
                                            }
                                            ++var45_55;
lbl167:
                                            // 2 sources

                                        } while (var45_55 < var38_37.size());
                                        if (var38_37.size() == 0) {
                                            var35_33[var21_22] = null;
                                        }
                                    }
                                    if (var27_52 && var9_9[var21_22].isInsertParticipant()) {
                                        var27_52 = var12_12[var21_22] == null;
                                    }
                                    ++var21_22;
                                }
                                var17_44 = var8_8.newInstance(var11_11, var12_12, this, var1_1, null);
                                var17_44.usePersistentId(new Long(var15_42.getAttribute("Hdl")));
                                var47_57 = this.getInsertParticipants();
                                if (var17_44 == null) break block67;
                                if (var28_13 == null) break block68;
                                var48_58 = var25_50.getKeyValues();
                                var19_46 = 0;
                                if (true) ** GOTO lbl197
                            }
                            if (!var27_52) break block69;
                            var49_59 = var25_50.getKeyValues();
                            var50_60 = this.getMapInfo();
                            var19_46 = 0;
                            if (true) ** GOTO lbl207
                        }
                        var58_68 = var17_44.getEntities();
                        var59_69 = 0;
                        if (true) ** GOTO lbl233
                        do {
                            if (var28_13[var19_46]) {
                                var17_44.setAttribute(var6_6[var19_46].getIndex(), var48_58[var19_46]);
                            }
                            ++var19_46;
lbl197:
                            // 2 sources

                        } while (var19_46 < var6_6.length);
                        break block70;
                        do {
                            var51_61 = true;
                            var52_62 = var50_60[var6_6[var19_46].getIndex()];
                            if (var52_62.getSourceIndex() > 0) {
                                v2 = var51_61 = var17_44.getEntity(var52_62.getSourceIndex()) != null;
                            }
                            if (var51_61) {
                                var17_44.populateAttributeAsChanged(var6_6[var19_46].getIndex(), var49_59[var19_46]);
                            }
                            ++var19_46;
lbl207:
                            // 2 sources

                        } while (var19_46 < var6_6.length);
                        var53_63 = var17_44.getEntities();
                        var54_64 = 0;
                        while (var54_64 < var47_57.length) {
                            var53_63[var54_64].addInitializedEntityToCache();
                            var53_63[var54_64].setInvalid();
                            ++var54_64;
                        }
                        var55_65 = new AttributeListImpl();
                        var56_66 = this.getBindingStyle();
                        var21_22 = var29_15;
                        while (var21_22 < var22_47.length) {
                            var57_67 = var56_66 == 2 ? ((Object[])var22_47[var21_22])[1] : var22_47[var21_22];
                            var55_65.setAttribute(new Integer(var21_22).toString(), var57_67);
                            ++var21_22;
                        }
                        if (var40_38 == null) {
                            var40_38 = this.getViewLinkDestinationAttributes();
                        }
                        if (var40_38 != null) {
                            var1_1.initForeignKeyValues(var17_44, var40_38, var55_65);
                        }
                        break block70;
                        do {
                            if (var58_68[var59_69] == null && var12_12[var59_69] != null) {
                                var17_44.setEntity(var59_69, var12_12[var59_69]);
                            }
                            ++var59_69;
lbl233:
                            // 2 sources

                        } while (var59_69 < var58_68.length);
                        if (this.getViewDef().isManageRowsByKey()) {
                            var17_44.getQueryCollection().updateReferencedEntities(var17_44, true);
                        }
                    }
                    var19_46 = new Integer(var15_42.getAttribute("Idx"));
                    if (var19_46 == -2147483648) {
                        var13_24.addNewRow(var17_44);
                    } else {
                        var60_70 = var13_24.findByKey(var25_50, 1);
                        if (var60_70.size() > 0) {
                            var61_71 = (Row)var60_70.get(0);
                            var61_71.removeFromCollection();
                        }
                        if (var19_46 > (var21_22 = var13_24.getFetchedRowCount())) {
                            while (var21_22 < var19_46 && var13_24.hasMoreRow()) {
                                ++var21_22;
                            }
                            var19_46 = var21_22;
                        }
                        var13_24.add(var19_46, var17_44, true, true);
                    }
                    var31_16 = var15_42.getAttribute("New");
                    if (var31_16 != null && var31_16.length() > 0) {
                        var62_72 = ((XMLElement)var15_42).getChildrenByTagName("Row");
                        var63_73 = var17_44.getEntities();
                        var64_74 = var62_72.item(0).getChildNodes();
                        var66_76 = 0;
                        while (var66_76 < var47_57.length) {
                            var65_75 = var47_57[var66_76];
                            var63_73[var65_75].readAttrsFromXML((Element)var64_74.item(var65_75), var63_73[var65_75].getAttributeDefImpls(), 1);
                            ++var66_76;
                        }
                        if (var43_53.length > 0 && var64_74.getLength() > var47_57.length) {
                            var17_44.readAttrsFromXML((Element)var64_74.item(var47_57.length), var43_53, 0, null);
                        }
                        var67_77 = 0;
                        while (var67_77 < var47_57.length) {
                            var63_73[var47_57[var67_77]].adjustContainershipForActivate();
                            ++var67_77;
                        }
                        this.addActivatedRowToInitialize(var17_44);
                    }
                }
                ++var20_14;
            }
            if (var1_1.isExecuted() && var13_24.isAssociationConsistent()) {
                var13_24.findUnpostedRows(false, true);
                var13_24.fetchUnpostedRows();
            }
            if (var41_39) {
                var1_1.setParamValues(var33_31);
                var1_1.setQueryCollection(var34_32);
            }
            ++var42_40;
lbl283:
            // 2 sources

        } while (var42_40 < var5_5);
    }

    void addActivatedRowToInitialize(Row row) {
        if (this.mTransActivatedNewRows == null) {
            this.mTransActivatedNewRows = new ArrayList(5);
        }
        this.mTransActivatedNewRows.add((Object)row);
    }

    void initializeActivatedNewRows() {
        if (this.mTransActivatedNewRows != null) {
            int n = 0;
            while (n < this.mTransActivatedNewRows.size()) {
                ((Row)this.mTransActivatedNewRows.get(n)).setNewRowState((byte)-1);
                ++n;
            }
        }
        this.mTransActivatedNewRows = null;
    }

    protected ViewRowImpl handleActivatedRowNotFound(Key key) {
        if (Diagnostic.isOn()) {
            Diagnostic.println("Row " + key + " - could not activated");
        }
        return null;
    }

    protected void activateTransientAttribute(ViewRowImpl viewRowImpl, Node node, AttributeDefImpl attributeDefImpl) {
        viewRowImpl.readAttributeFromXMLElement(node, attributeDefImpl, true);
    }

    protected void activateTransients(AttributeDefImpl[] attributeDefImplArray, Element element) {
        this.activateTransients(this.getDefaultRowSet(), attributeDefImplArray, element);
    }

    protected void activateTransients(ViewRowSetImpl viewRowSetImpl, AttributeDefImpl[] attributeDefImplArray, Element element) {
        if (element != null) {
            try {
                NodeList nodeList = element.getElementsByTagName(TRANSIENT_DATA_ROWTAG);
                int n = attributeDefImplArray.length;
                int[] nArray = new int[n];
                int n2 = 0;
                while (n2 < n) {
                    nArray[n2] = attributeDefImplArray[n2].getIndex();
                    ++n2;
                }
                AttributeDef[] attributeDefArray = this.getKeyAttributeDefs();
                int n3 = 0;
                while (n3 < nodeList.getLength()) {
                    Node node = nodeList.item(n3);
                    Key key = new Key(node.getFirstChild().getFirstChild().getNodeValue(), attributeDefArray);
                    ViewRowImpl viewRowImpl = (ViewRowImpl)viewRowSetImpl.getRow(key);
                    if (viewRowImpl == null) {
                        viewRowImpl = this.handleActivatedRowNotFound(key);
                    }
                    if (viewRowImpl != null) {
                        int n4 = 0;
                        while (n4 < n) {
                            this.activateTransientAttribute(viewRowImpl, node, attributeDefImplArray[n4]);
                            ++n4;
                        }
                        this.notifyRowUpdated(viewRowImpl.getQueryCollection(), (Row)viewRowImpl, nArray, false);
                    }
                    ++n3;
                }
            }
            catch (JboException jboException) {
                throw jboException;
            }
            catch (Exception exception) {
                throw new JboException(exception);
            }
        }
    }

    protected void activateState(Element element) {
    }

    protected void activateState(ViewRowImpl viewRowImpl, Element element) {
        this.activateState(this.getDefaultRowSet(), viewRowImpl, element);
    }

    protected void activateState(ViewRowSetImpl viewRowSetImpl, ViewRowImpl viewRowImpl, Element element) {
        if (this.mAttrDefs == null) {
            this.initViewAttributeDefImpls();
        }
        if (element != null && (this.getCalculatedAttributeCount() > 0 || this.isViewLinkAccessorRetained())) {
            ViewAttributeDefImpl[] viewAttributeDefImplArray = this.mAttrDefs;
            int n = viewAttributeDefImplArray.length;
            ArrayList arrayList = new ArrayList(n);
            int n2 = 0;
            while (n2 < n) {
                switch (viewAttributeDefImplArray[n2].getAttributeKind()) {
                    case 1: 
                    case 3: 
                    case 4: {
                        if (!this.isPassivatableTransientAttribute(viewAttributeDefImplArray[n2])) break;
                        arrayList.add((Object)viewAttributeDefImplArray[n2]);
                    }
                }
                ++n2;
            }
            n = arrayList.size();
            if (n > 0) {
                if (this.mKeyAttrRefs != null && this.mKeyAttrRefs.length == 0) {
                    Class clazz;
                    if (Diagnostic.isOn()) {
                        Diagnostic.println("*** ViewObject:" + this.getName() + " with no Key Attribute found on activation! ***");
                    }
                    if ((clazz = class$oracle$jbo$CSMessageBundle) == null) {
                        clazz = class$oracle$jbo$CSMessageBundle = ViewObjectImpl.class$("oracle.jbo.CSMessageBundle");
                    }
                    throw new JboException(clazz, "25052", new Object[]{this.getName()});
                }
                if (viewRowSetImpl.isDefaultRS()) {
                    this.activateTransients((AttributeDefImpl[])arrayList.toArray((Object[])new ViewAttributeDefImpl[n]), element);
                } else {
                    this.activateTransients(viewRowSetImpl, (AttributeDefImpl[])arrayList.toArray((Object[])new ViewAttributeDefImpl[n]), element);
                }
            }
        }
    }

    public void readRowXML(Element element, int n) {
        boolean bl = false;
        ViewObjectImpl viewObjectImpl = (ViewObjectImpl)this.getViewObject();
        AttributeDefImpl[] attributeDefImplArray = (AttributeDefImpl[])viewObjectImpl.getKeyAttributeDefs();
        Object[] objectArray = new Object[attributeDefImplArray.length];
        int n2 = 0;
        while (n2 < attributeDefImplArray.length) {
            Object object = null;
            NodeList nodeList = ((XMLElement)element).getChildrenByTagName(attributeDefImplArray[n2].getXMLElementTag() + "-Old");
            if (nodeList.getLength() > 0) {
                bl = true;
                object = attributeDefImplArray[n2].getXMLContentValue((Element)nodeList.item(0), false);
            } else {
                nodeList = ((XMLElement)element).getChildrenByTagName(attributeDefImplArray[n2].getXMLElementTag());
                if (nodeList.getLength() > 0) {
                    object = attributeDefImplArray[n2].getXMLContentValue((Element)nodeList.item(0), false);
                }
            }
            objectArray[n2] = object;
            ++n2;
        }
        Row[] rowArray = this.findByKey(new Key(objectArray), 1);
        Object object = ViewRowImpl.updateRowFromXML(this.mViewRowSet, n, element, this.mAttrDefs, bl, (ViewRowImpl)(rowArray.length > 0 ? rowArray[0] : null), false, null);
        if (object instanceof JboException) {
            throw (JboException)object;
        }
    }

    public void readRowXML(Element element, int n, XSLStylesheet xSLStylesheet) {
        if (xSLStylesheet != null) {
            XMLDocument xMLDocument = new XMLDocument();
            element.getParentNode().removeChild(element);
            try {
                xMLDocument.appendChild((Node)element);
            }
            catch (Exception exception) {
                xMLDocument.appendChild(xMLDocument.adoptNode((Node)element));
            }
            xMLDocument = JboXMLUtil.processXSL(xMLDocument, xSLStylesheet);
            element = xMLDocument.getDocumentElement();
        }
        this.readRowXML(element, n);
    }

    public void setQueryOptimizerHint(String string) {
        this.mOptimizerHint = string;
    }

    public String getQueryOptimizerHint() {
        return this.mOptimizerHint;
    }

    public void dumpQCs() {
        System.out.println("!!! ViewObject " + this.getName());
        Enumeration enumeration = this.mQCs.elements();
        while (enumeration.hasMoreElements()) {
            QueryCollection queryCollection = (QueryCollection)enumeration.nextElement();
            RowFilter rowFilter = queryCollection.getRowFilter();
            System.out.println("%%%%%%% qc.rowFilter " + rowFilter);
        }
    }

    public Row findRowInQCs(Object[] objectArray, Key key, Object object) {
        RowFilter rowFilter = this.buildRowFilter(objectArray);
        QueryCollection queryCollection = this.getCachedQueryCollection(rowFilter);
        ArrayList arrayList = null;
        Row row = null;
        if (queryCollection != null) {
            if (key.isNull()) {
                ViewRowStorage viewRowStorage = queryCollection.getRowStorageFromId(((Integer)object).intValue());
                if (viewRowStorage != null) {
                    return viewRowStorage.getRowImpl();
                }
            } else {
                arrayList = queryCollection.findByKey(key, 1);
                if ((arrayList == null || arrayList.size() == 0) && queryCollection != null && (row = this.NewRowTracker_findRow(queryCollection, key)) != null) {
                    return row;
                }
            }
        }
        if (arrayList == null || arrayList.size() == 0) {
            ViewRowSetImpl viewRowSetImpl = queryCollection == null ? this.getDefaultRowSet() : queryCollection.getRowSetImpl();
            Row[] rowArray = this.retrieveByKey(viewRowSetImpl, key, 1, true);
            if (rowArray != null && rowArray.length > 0) {
                row = rowArray[0];
            }
        } else {
            row = (Row)arrayList.get(0);
        }
        return row;
    }

    ViewAttributeDefImpl[] getViewAttrDefsFromNames(String[] stringArray) {
        ViewAttributeDefImpl[] viewAttributeDefImplArray = this.getViewAttributeDefImpls();
        if (stringArray == null) {
            return viewAttributeDefImplArray;
        }
        ArrayList arrayList = new ArrayList(stringArray.length);
        int n = 0;
        while (n < stringArray.length) {
            String string = stringArray[n].intern();
            int n2 = 0;
            while (n2 < viewAttributeDefImplArray.length) {
                if (viewAttributeDefImplArray[n2].getName().equals(string)) {
                    arrayList.add((Object)viewAttributeDefImplArray[n2]);
                    break;
                }
                ++n2;
            }
            ++n;
        }
        return (ViewAttributeDefImpl[])arrayList.toArray((Object[])new ViewAttributeDefImpl[arrayList.size()]);
    }

    public void activateIteratorState(Element element, boolean bl) {
        this.getDefaultRowSet().activateIteratorState(element, bl);
    }

    protected ViewRowImpl activateCurrentRow(ViewRowSetIteratorImpl viewRowSetIteratorImpl, ViewRowSetImpl viewRowSetImpl, Key key) {
        ViewRowImpl viewRowImpl;
        block7: {
            viewRowImpl = null;
            AttributeDef[] attributeDefArray = this.getKeyAttributeDefs();
            if (attributeDefArray == null || attributeDefArray.length == 0) {
                return (ViewRowImpl)viewRowSetImpl.getRow(null);
            }
            viewRowImpl = (ViewRowImpl)viewRowSetImpl.getRow(key);
            if (viewRowImpl == null) {
                try {
                    Row[] rowArray = viewRowSetImpl.findByKey(key, 1, true, false);
                    if (rowArray.length == 1) {
                        viewRowImpl = (ViewRowImpl)rowArray[0];
                    } else if (Diagnostic.isOn()) {
                        Diagnostic.println("Activation Warning: Failed to reset currency to row with key:" + key);
                    }
                }
                catch (JboException jboException) {
                    if (!Diagnostic.isOn()) break block7;
                    Diagnostic.println("Activation Warning: Ignoring exception from findByKey during activateCurrentRow");
                }
            }
        }
        return viewRowImpl;
    }

    private IteratorStateHolder getIteratorState(ViewRowSetImpl viewRowSetImpl) {
        IteratorStateHolder iteratorStateHolder = null;
        if (viewRowSetImpl != null) {
            iteratorStateHolder = viewRowSetImpl.getIteratorState();
        }
        return iteratorStateHolder;
    }

    void NewRowTracker_removeAndAdjust(QueryCollection queryCollection, ViewRowImpl viewRowImpl, int n) {
        ArrayList arrayList = queryCollection.mNewRowTracker;
        int n2 = arrayList.size();
        boolean bl = true;
        int n3 = n2 - 1;
        while (n3 >= 0) {
            NewRowTracker newRowTracker = (NewRowTracker)arrayList.get(n3);
            if (newRowTracker.mRow == viewRowImpl) {
                bl = false;
                arrayList.remove(n3);
                if (arrayList.size() == 0) {
                    queryCollection.mNewRowTracker = null;
                }
            } else if (n <= newRowTracker.mIndex && bl && newRowTracker.mIndex > 0) {
                --newRowTracker.mIndex;
            }
            --n3;
        }
    }

    ViewRowImpl NewRowTracker_findRow(QueryCollection queryCollection, Key key) {
        ArrayList arrayList = queryCollection.mNewRowTracker;
        if (arrayList != null && arrayList.size() != 0) {
            int n = arrayList.size();
            boolean bl = true;
            int n2 = n - 1;
            while (n2 >= 0) {
                NewRowTracker newRowTracker = (NewRowTracker)arrayList.get(n2);
                if (newRowTracker.mRow.getKey().equals(key)) {
                    return newRowTracker.mRow;
                }
                --n2;
            }
        }
        return null;
    }

    XMLElement passivateDynamicInfo(XMLDocument xMLDocument) {
        XMLElement xMLElement = (XMLElement)xMLDocument.createElement("Dyn");
        if (this.mViewDef.isFullSql()) {
            Element element = xMLDocument.createElement("Se");
            CDATASection cDATASection = xMLDocument.createCDATASection("Se");
            String string = this.getUserDefinedQuery();
            if (string == null) {
                string = this.mViewDef.getQuery();
            }
            cDATASection.setNodeValue(string);
            element.appendChild(cDATASection);
            xMLElement.appendChild((Node)element);
        } else {
            ViewDefImpl viewDefImpl = this.mViewDef;
            Element element = xMLDocument.createElement("EO");
            CDATASection cDATASection = xMLDocument.createCDATASection("EO");
            EntityReference entityReference = viewDefImpl.getEntityReference(0);
            if (entityReference != null) {
                cDATASection.setNodeValue(entityReference.getEntityDef().getFullName());
            }
            element.appendChild(cDATASection);
            xMLElement.appendChild((Node)element);
            element = xMLDocument.createElement("Se");
            cDATASection = xMLDocument.createCDATASection("Se");
            cDATASection.setNodeValue(viewDefImpl.mSelect);
            element.appendChild(cDATASection);
            xMLElement.appendChild((Node)element);
            element = xMLDocument.createElement("Fr");
            cDATASection = xMLDocument.createCDATASection("Fr");
            cDATASection.setNodeValue(viewDefImpl.mFrom);
            element.appendChild(cDATASection);
            xMLElement.appendChild((Node)element);
            element = xMLDocument.createElement("Wh");
            cDATASection = xMLDocument.createCDATASection("Wh");
            cDATASection.setNodeValue(viewDefImpl.mWhere != null ? viewDefImpl.mWhere : "%null%");
            element.appendChild(cDATASection);
            xMLElement.appendChild((Node)element);
            element = xMLDocument.createElement("Or");
            cDATASection = xMLDocument.createCDATASection("Or");
            cDATASection.setNodeValue(viewDefImpl.getOrderByClause() != null ? viewDefImpl.getOrderByClause() : "%null%");
            element.appendChild(cDATASection);
            xMLElement.appendChild((Node)element);
        }
        return xMLElement;
    }

    protected void prepareForActivation(Element element) {
    }

    protected void prepareForPassivation(Document document, Element element) {
    }

    void doPassivateSettings(XMLDocument xMLDocument, XMLElement xMLElement) {
        String string;
        VariableValueManager variableValueManager;
        String string2;
        CDATASection cDATASection;
        Element element;
        String[] stringArray;
        this.prepareForPassivation((Document)xMLDocument, (Element)xMLElement);
        if (this.mKeyModified) {
            XMLElement xMLElement2 = (XMLElement)xMLDocument.createElement("Attrs");
            ViewAttributeDefImpl[] viewAttributeDefImplArray = this.mKeyAttrRefs;
            int n = viewAttributeDefImplArray.length;
            int n2 = 0;
            while (n2 < n) {
                XMLElement xMLElement3 = (XMLElement)xMLDocument.createElement("a");
                xMLElement3.appendChild((Node)xMLDocument.createTextNode(new Integer(viewAttributeDefImplArray[n2].mIndex).toString()));
                xMLElement2.appendChild((Node)xMLElement3);
                ++n2;
            }
            xMLElement.appendChild((Node)xMLElement2);
        }
        xMLElement.setAttribute("sig", new Long(this.mSignature).toString());
        if (this.mViewDef.isViewLinkAccessorRetained() != this.isViewLinkAccessorRetained()) {
            xMLElement.setAttribute("acr", new Boolean(this.isViewLinkAccessorRetained()).toString());
        }
        if ((stringArray = this.getAllViewCriteriaNames()) != null && stringArray.length > 0) {
            int n = 0;
            while (n < stringArray.length) {
                ViewCriteria viewCriteria = this.getViewCriteria(stringArray[n]);
                if (viewCriteria != null && viewCriteria.size() > 0) {
                    Element element2 = xMLDocument.createElement("VC");
                    Element element3 = null;
                    int n3 = 0;
                    while (n3 < viewCriteria.size()) {
                        element3 = null;
                        ViewCriteriaRow viewCriteriaRow = (ViewCriteriaRow)viewCriteria.elementAt(n3);
                        int n4 = 0;
                        while (n4 < viewCriteriaRow.getAttributeCount()) {
                            Object object;
                            if (element3 == null) {
                                element3 = xMLDocument.createElement("Row");
                                ((XMLElement)element3).setAttribute("uc", viewCriteriaRow.isUpperColumns() ? "1" : "0");
                                ((XMLElement)element3).setAttribute("cj", "" + viewCriteriaRow.getConjunction());
                            }
                            if ((object = viewCriteriaRow.getAttribute(n4)) != null) {
                                element = xMLDocument.createElement("a");
                                ((XMLElement)element).setAttribute("i", "" + n4);
                                cDATASection = xMLDocument.createCDATASection("v");
                                cDATASection.setNodeValue(object.toString());
                                element.appendChild(cDATASection);
                                element3.appendChild(element);
                            }
                            ++n4;
                        }
                        if (element3 != null) {
                            element2.appendChild(element3);
                        }
                        ++n3;
                    }
                    ((XMLElement)element2).setAttribute("name", stringArray[n]);
                    if (element2.getChildNodes().getLength() > 0) {
                        xMLElement.appendChild((Node)element2);
                    }
                }
                ++n;
            }
            String string3 = JboXMLUtil.serializeStrings(this.getApplyViewCriteriaNames());
            if (string3 != null && string3.length() > 0) {
                xMLElement.setAttribute("avcs", string3);
            }
        }
        if ((string2 = this.mWhere) != null && string2.length() > 0) {
            element = xMLDocument.createElement("Wh");
            cDATASection = xMLDocument.createCDATASection("Wh");
            cDATASection.setNodeValue(string2);
            element.appendChild(cDATASection);
            xMLElement.appendChild((Node)element);
        }
        if ((string2 = this.mOrderBy) != null && string2.length() > 0) {
            element = xMLDocument.createElement("Or");
            cDATASection = xMLDocument.createCDATASection("Or");
            cDATASection.setNodeValue(string2);
            element.appendChild(cDATASection);
            xMLElement.appendChild((Node)element);
        }
        if (this.mUserDefinedQuery != null) {
            element = xMLDocument.createElement("uq");
            cDATASection = xMLDocument.createCDATASection("uq");
            cDATASection.setNodeValue(this.mUserDefinedQuery);
            element.appendChild(cDATASection);
            xMLElement.appendChild((Node)element);
        }
        ViewRowImpl viewRowImpl = this.doPassivateSettings(null, this.mViewRowSet, xMLDocument, xMLElement, true);
        ViewDefImpl viewDefImpl = this.mViewDef;
        if (this.mMaxFetchSize != viewDefImpl.getMaxFetchSize()) {
            xMLElement.setAttribute("ms", new Integer(this.mMaxFetchSize).toString());
        }
        if (this.mFetchMode != viewDefImpl.getFetchMode()) {
            xMLElement.setAttribute("fm", new Byte(this.mFetchMode).toString());
        }
        if (this.mFetchSize != viewDefImpl.getFetchSize()) {
            xMLElement.setAttribute("fs", new Short(this.mFetchSize).toString());
        }
        if (this.mManageRowsByKey != viewDefImpl.isManageRowsByKey()) {
            xMLElement.setAttribute("mk", new Boolean(this.mManageRowsByKey).toString());
        }
        int n = 0;
        while (n < this.mRowSets.size()) {
            ViewRowSetImpl viewRowSetImpl = (ViewRowSetImpl)this.mRowSets.elementAt(n);
            if (viewRowSetImpl != null && viewRowSetImpl.isPassivationEnabled() && !viewRowSetImpl.isDefaultRS()) {
                XMLElement xMLElement4 = (XMLElement)xMLDocument.createElement("RS");
                xMLElement4.setAttribute("Name", viewRowSetImpl.getName());
                this.doPassivateSettings(null, viewRowSetImpl, xMLDocument, xMLElement4, false);
                xMLElement.appendChild((Node)xMLElement4);
            }
            ++n;
        }
        XMLElement xMLElement5 = (XMLElement)xMLDocument.createElement("cud");
        this.passivateState((Document)xMLDocument, (Element)xMLElement5);
        if (xMLElement5.getChildNodes().getLength() > 0) {
            xMLElement.appendChild((Node)xMLElement5);
        }
        xMLElement5 = (XMLElement)xMLDocument.createElement("cd");
        this.passivateState(viewRowImpl, (Document)xMLDocument, (Element)xMLElement5);
        if (this.mQCs != null) {
            Enumeration enumeration = this.mQCs.keys();
            while (enumeration.hasMoreElements()) {
                RowFilter rowFilter = (RowFilter)enumeration.nextElement();
                QueryCollection queryCollection = (QueryCollection)this.mQCs.get(rowFilter);
                if (queryCollection.mNewRowTracker == null || !(rowFilter instanceof RowFilterKey)) continue;
                this.passivateNewRowTracker(queryCollection, (RowFilterKey)rowFilter, (Document)xMLDocument, (Element)xMLElement5);
            }
        }
        if (xMLElement5.getChildNodes().getLength() > 0) {
            xMLElement.appendChild((Node)xMLElement5);
        }
        if ((variableValueManager = this.getVariableManager()) != null && (string = variableValueManager.getPassivatableVariables()) != null && string.length() > 0) {
            Element element4 = xMLDocument.createElement("vars");
            CDATASection cDATASection2 = xMLDocument.createCDATASection("vars");
            cDATASection2.setNodeValue(string);
            element4.appendChild(cDATASection2);
            xMLElement.appendChild((Node)element4);
        }
    }

    XMLElement passivateParamArray(XMLDocument xMLDocument, XMLElement xMLElement, String string, Object[] objectArray) {
        XMLElement xMLElement2 = null;
        if (objectArray != null && objectArray.length > 0) {
            ApplicationModuleImpl applicationModuleImpl = (ApplicationModuleImpl)this.getApplicationModule();
            xMLElement2 = (XMLElement)xMLDocument.createElement(string);
            xMLElement2.setAttribute("ct", "" + objectArray.length);
            xMLElement.appendChild((Node)xMLElement2);
            XMLElement xMLElement3 = null;
            Node node = null;
            Class<?> clazz = new Object[2].getClass();
            int n = 0;
            while (n < objectArray.length) {
                xMLElement3 = (XMLElement)xMLDocument.createElement("arg");
                if (objectArray[n] == null) {
                    node = xMLDocument.createCDATASection("%null%");
                } else {
                    String string2;
                    node = null;
                    Object object = null;
                    Object object2 = null;
                    if (clazz != objectArray[n].getClass()) {
                        object2 = objectArray[n];
                    } else {
                        Object[] objectArray2 = (Object[])objectArray[n];
                        object = objectArray2[0];
                        object2 = objectArray2[1];
                        if (objectArray2[1] == null) {
                            node = xMLDocument.createCDATASection("%null%");
                        }
                    }
                    if (object != null && (string2 = object.toString()).length() > 0) {
                        xMLElement3.setAttribute("n", string2.toString());
                    }
                    if (node == null) {
                        if (object2.getClass() != QC_TAG.getClass()) {
                            xMLElement3.setAttribute("t", object2.getClass().getName());
                        }
                        node = DomainAttributeDef.getXMLContentNode((Document)xMLDocument, object2, true, true);
                    }
                }
                xMLElement3.appendChild(node);
                xMLElement2.appendChild((Node)xMLElement3);
                ++n;
            }
        }
        return xMLElement2;
    }

    ViewRowImpl doPassivateSettings(RowSetStateHolder rowSetStateHolder, ViewRowSetImpl viewRowSetImpl, XMLDocument xMLDocument, XMLElement xMLElement, boolean bl) {
        RowSetStateHolder rowSetStateHolder2;
        ViewRowImpl viewRowImpl = null;
        if (viewRowSetImpl == null && rowSetStateHolder == null) {
            xMLElement.setAttribute("RS", "0");
            return viewRowImpl;
        }
        IteratorStateHolder iteratorStateHolder = rowSetStateHolder2 = rowSetStateHolder != null ? rowSetStateHolder : this.getIteratorState(viewRowSetImpl);
        if (viewRowSetImpl != null) {
            String string;
            this.passivateParamArray(xMLDocument, xMLElement, "exFK", viewRowSetImpl.mExecuteParamValues);
            this.passivateParamArray(xMLDocument, xMLElement, "exArgs", viewRowSetImpl.mExecuteUserParams != null ? viewRowSetImpl.mExecuteUserParams.toArray() : null);
            if (viewRowSetImpl.hasParamsChanged()) {
                this.passivateParamArray(xMLDocument, xMLElement, "fk", viewRowSetImpl.mParamValues);
                this.passivateParamArray(xMLDocument, xMLElement, "args", viewRowSetImpl.getWhereClauseParams());
            } else {
                xMLElement.setAttribute("da", "1");
            }
            VariableValueManager variableValueManager = viewRowSetImpl.getVariableManager();
            if (variableValueManager != null && (string = variableValueManager.getLocalPassivatableVariables()) != null && string.length() > 0) {
                Element element = xMLDocument.createElement("rsvars");
                CDATASection cDATASection = xMLDocument.createCDATASection("rsvars");
                cDATASection.setNodeValue(string);
                element.appendChild(cDATASection);
                xMLElement.appendChild((Node)element);
            }
        } else {
            this.passivateParamArray(xMLDocument, xMLElement, "exFK", rowSetStateHolder.mExecuteKeyParams);
            this.passivateParamArray(xMLDocument, xMLElement, "exArgs", rowSetStateHolder.mExecuteWhereParams);
            this.passivateParamArray(xMLDocument, xMLElement, "fk", rowSetStateHolder.mKeyParams);
            this.passivateParamArray(xMLDocument, xMLElement, "args", rowSetStateHolder.mWhereParams);
            if (rowSetStateHolder.mVariables != null) {
                Element element = xMLDocument.createElement("rsvars");
                CDATASection cDATASection = xMLDocument.createCDATASection("rsvars");
                cDATASection.setNodeValue(rowSetStateHolder.mVariables);
                element.appendChild(cDATASection);
                xMLElement.appendChild((Node)element);
            }
        }
        String string = null;
        if (rowSetStateHolder2 != null) {
            xMLElement.setAttribute("It", "1");
            if (rowSetStateHolder2.mCurrentRowKeyStr != null) {
                string = rowSetStateHolder2.mCurrentRowKeyStr;
            }
            if (rowSetStateHolder2.mRangeSize > -1) {
                xMLElement.setAttribute("Sz", Integer.toString(rowSetStateHolder2.mRangeSize));
            }
            if (rowSetStateHolder2.mRangeStart > -1) {
                xMLElement.setAttribute("St", Integer.toString(rowSetStateHolder2.mRangeStart));
            }
            if (rowSetStateHolder2.mIterMode != 0) {
                xMLElement.setAttribute("im", Integer.toString(rowSetStateHolder2.mIterMode));
            }
        } else if (viewRowSetImpl != null && viewRowSetImpl.mDefaultView != null) {
            int n;
            Key key;
            xMLElement.setAttribute("It", "1");
            viewRowImpl = (ViewRowImpl)viewRowSetImpl.getCurrentRow();
            if (viewRowImpl != null && (key = viewRowImpl.getKey()) != null) {
                string = key.toStringFormat(key.isNull());
            }
            if ((n = viewRowSetImpl.getRangeSize()) != 1) {
                xMLElement.setAttribute("Sz", Integer.toString(n));
            }
            if ((n = viewRowSetImpl.getRangeStart()) > -1) {
                xMLElement.setAttribute("St", Integer.toString(n));
            }
            if ((n = viewRowSetImpl.getIterMode()) != this.mViewDef.getIterMode()) {
                xMLElement.setAttribute("im", Integer.toString(n));
            }
        }
        if (string != null) {
            Element element = xMLDocument.createElement("Key");
            CDATASection cDATASection = xMLDocument.createCDATASection("Key");
            cDATASection.setNodeValue(string);
            element.appendChild(cDATASection);
            xMLElement.appendChild((Node)element);
        }
        if (rowSetStateHolder != null) {
            if (rowSetStateHolder.mForwardOnly) {
                xMLElement.setAttribute("fo", "1");
            }
            if (rowSetStateHolder.mViewLinkMode != 2) {
                xMLElement.setAttribute("ac", new Byte(rowSetStateHolder.mViewLinkMode).toString());
            }
            if (rowSetStateHolder.mExecuted) {
                xMLElement.setAttribute("Ex", "1");
            }
        } else {
            boolean bl2;
            if (viewRowSetImpl.isForwardOnly()) {
                xMLElement.setAttribute("fo", "1");
            }
            if (viewRowSetImpl.getViewLinkMode() != 2) {
                xMLElement.setAttribute("ac", new Byte(viewRowSetImpl.getViewLinkMode()).toString());
            }
            RowSetStateHolder rowSetStateHolder3 = rowSetStateHolder2 instanceof RowSetStateHolder ? rowSetStateHolder2 : null;
            QueryCollection queryCollection = viewRowSetImpl.getQueryCollection();
            boolean bl3 = bl2 = rowSetStateHolder2 == null && viewRowSetImpl.isExecuted() && queryCollection != null && queryCollection.isExecuted();
            if (rowSetStateHolder3 != null && rowSetStateHolder3.mExecuted || bl2) {
                xMLElement.setAttribute("Ex", "1");
            }
        }
        return viewRowImpl;
    }

    void doActivateSettings(XMLElement xMLElement, NodeList nodeList, int n, String string) {
        String string2;
        this.clearCache();
        this.prepareForActivation((Element)xMLElement);
        Node node = nodeList.item(n);
        if (node != null && node.getNodeName() == "Attrs") {
            ++n;
            NodeList nodeList2 = node.getChildNodes();
            int n2 = nodeList2.getLength();
            int[] nArray = new int[n2];
            try {
                while (n2 > 0) {
                    nArray[--n2] = Integer.valueOf(nodeList2.item(n2).getFirstChild().getNodeValue());
                }
                this.innerSetKeyAttributeDefs(nArray);
            }
            catch (NumberFormatException numberFormatException) {
                throw new JboException(numberFormatException);
            }
            node = nodeList.item(n);
        }
        while (node != null && node.getNodeName() == "VC") {
            ++n;
            ViewCriteria viewCriteria = this.createViewCriteria();
            Node node2 = node.getFirstChild();
            while (node2 != null) {
                ViewCriteriaRow viewCriteriaRow = viewCriteria.createViewCriteriaRow();
                viewCriteriaRow.setUpperColumns(Integer.valueOf(((XMLElement)node2).getAttribute("uc")) == 1);
                viewCriteriaRow.setConjunction(Integer.valueOf(((XMLElement)node2).getAttribute("cj")));
                Node node3 = node2.getFirstChild();
                while (node3 != null) {
                    viewCriteriaRow.setAttribute(Integer.valueOf(((XMLElement)node3).getAttribute("i")), (Object)node3.getFirstChild().getNodeValue());
                    node3 = node3.getNextSibling();
                }
                viewCriteria.addElement(viewCriteriaRow);
                node2 = node2.getNextSibling();
            }
            this.putViewCriteria(((XMLElement)node).getAttribute("name"), viewCriteria);
            node = nodeList.item(n);
        }
        String string3 = xMLElement.getAttribute("avcs");
        if (string3 != null && string3.length() > 0) {
            this.applyViewCriteria(this.getViewCriteria(string3), string3);
        }
        if (node != null && node.getNodeName() == "Wh") {
            this.setWhereClause(node.getFirstChild().getNodeValue());
            node = nodeList.item(++n);
        }
        if (node != null && node.getNodeName() == "Or") {
            this.setOrderByClause(node.getFirstChild().getNodeValue());
            node = nodeList.item(++n);
        }
        if (node != null && node.getNodeName() == "uq") {
            this.setQuery(node.getFirstChild().getNodeValue());
            node = nodeList.item(++n);
        }
        if (node != null && node.getNodeName() == "vars") {
            VariableValueManager variableValueManager = this.ensureVariableManager();
            variableValueManager.activatePassivatedVariables(node.getFirstChild().getNodeValue());
            node = nodeList.item(++n);
        }
        if ((string2 = xMLElement.getAttribute("ms")) != null && string2.length() > 0) {
            this.setMaxFetchSize(Integer.valueOf(string2));
        }
        if ((string2 = xMLElement.getAttribute("fo")).length() > 0) {
            this.setForwardOnly("1".equals(string2));
        }
        try {
            string2 = xMLElement.getAttribute("sig");
            if (string2.length() > 0) {
                this.mSignature = Long.valueOf(string2);
            }
            if ((string2 = xMLElement.getAttribute("acr")).length() > 0) {
                this.setViewLinkAccessorRetained(Boolean.valueOf(string2));
            }
            if ((string2 = xMLElement.getAttribute("fm")).length() > 0) {
                this.mFetchMode = Byte.valueOf(string2);
            }
            if ((string2 = xMLElement.getAttribute("fs")).length() > 0) {
                this.mFetchSize = Short.valueOf(string2);
            }
            if ((string2 = xMLElement.getAttribute("mk")).length() > 0) {
                this.mManageRowsByKey = Boolean.valueOf(string2);
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw new JboException(numberFormatException);
        }
        RowSetStateHolder rowSetStateHolder = null;
        VariableValueManager variableValueManager = this.ensureVariableManager();
        string2 = xMLElement.getAttribute("RS");
        if (string2.length() == 0) {
            rowSetStateHolder = new RowSetStateHolder(this.getDefaultRowSet());
            n = ViewObjectImpl.doActivateSettings(rowSetStateHolder, xMLElement, nodeList, node, n, string, variableValueManager);
        }
        if (n > 0) {
            node = nodeList.item(n);
        }
        while (node != null && node.getNodeName() == "RS") {
            String string4 = ((XMLElement)node).getAttribute("Name");
            ViewRowSetImpl viewRowSetImpl = (ViewRowSetImpl)this.findRowSet(string4);
            if (viewRowSetImpl == null) {
                viewRowSetImpl = (ViewRowSetImpl)this.createRowSet(string4);
            }
            NodeList nodeList3 = node.getChildNodes();
            ViewObjectImpl.doActivateSettings(new RowSetStateHolder(viewRowSetImpl), xMLElement, nodeList3, nodeList3.item(0), 0, null, variableValueManager);
            node = nodeList.item(++n);
        }
        if (node != null && node.getNodeName() == "cud") {
            this.activateState((Element)node);
        } else {
            this.activateState(null);
        }
    }

    static Object[] activateParams(XMLElement xMLElement, VariableValueManager variableValueManager) {
        int n = new Integer(xMLElement.getAttribute("ct"));
        Object[] objectArray = new Object[n];
        NodeList nodeList = xMLElement.getChildNodes();
        String string = "";
        int n2 = 0;
        while (n2 < n) {
            XMLElement xMLElement2 = (XMLElement)nodeList.item(n2);
            Node node = xMLElement2.getFirstChild();
            string = xMLElement2.getAttribute("n");
            String string2 = xMLElement2.getAttribute("t");
            if (string2.length() == 0) {
                string2 = "java.lang.String";
            }
            if (string != null && string.length() > 0) {
                Variable variable;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = string;
                if (node != null) {
                    objectArray2[1] = AttributeDefImpl.getXMLContentValueForParam(string2, (Element)xMLElement2, true);
                }
                if ("%null%".equals(objectArray2[1])) {
                    objectArray2[1] = null;
                }
                objectArray[n2] = objectArray2;
                if (variableValueManager != null && (variable = variableValueManager.lookupVariable((String)objectArray2[0])) == null) {
                    variable = variableValueManager.addVariable((String)objectArray2[0]);
                    variable.setVariableKind("where");
                    variable.setExtendedData(null);
                    variable.setDefaultValue(objectArray2[1]);
                }
            } else if (node != null) {
                objectArray[n2] = AttributeDefImpl.getXMLContentValueForParam(string2, (Element)xMLElement2, true);
            } else {
                objectArray[n2] = "";
                if ("%null%".equals(objectArray[n2])) {
                    objectArray[n2] = null;
                }
            }
            ++n2;
        }
        return objectArray;
    }

    static int doActivateSettings(RowSetStateHolder rowSetStateHolder, XMLElement xMLElement, NodeList nodeList, Node node, int n, String string, VariableValueManager variableValueManager) {
        String string2 = xMLElement.getAttribute("fo");
        if (string2.length() > 0) {
            rowSetStateHolder.mForwardOnly = "1".equals(string2);
        }
        if ((string2 = xMLElement.getAttribute("ac")).length() > 0) {
            rowSetStateHolder.mViewLinkMode = new Byte(string2);
        }
        if ((string2 = xMLElement.getAttribute("Ex")).length() > 0) {
            rowSetStateHolder.mExecuted = true;
        }
        if (node != null && node.getNodeName() == "exFK") {
            Object[] objectArray = ViewObjectImpl.activateParams((XMLElement)node, variableValueManager);
            rowSetStateHolder.mExecuteKeyParams = objectArray;
            node = nodeList.item(++n);
        }
        if (node != null && node.getNodeName() == "exArgs") {
            Object[] objectArray = ViewObjectImpl.activateParams((XMLElement)node, variableValueManager);
            rowSetStateHolder.mExecuteWhereParams = objectArray;
            node = nodeList.item(++n);
        }
        if (node != null && node.getNodeName() == "fk") {
            Object[] objectArray = ViewObjectImpl.activateParams((XMLElement)node, variableValueManager);
            rowSetStateHolder.mKeyParams = objectArray;
            rowSetStateHolder.mDiffParams = true;
            node = nodeList.item(++n);
        } else {
            string2 = xMLElement.getAttribute("da");
            if (string2.length() == 0 && rowSetStateHolder.mExecuteKeyParams != null && rowSetStateHolder.mExecuteKeyParams.length > 0) {
                rowSetStateHolder.mDiffParams = true;
            }
        }
        if (node != null && node.getNodeName() == "rsvars") {
            rowSetStateHolder.mVariables = node.getFirstChild().getNodeValue();
            node = nodeList.item(++n);
        }
        if (node != null && node.getNodeName() == "args") {
            Object[] objectArray = ViewObjectImpl.activateParams((XMLElement)node, variableValueManager);
            rowSetStateHolder.mWhereParams = objectArray;
            rowSetStateHolder.mDiffParams = true;
            node = nodeList.item(++n);
        } else {
            string2 = xMLElement.getAttribute("da");
            if (string2.length() == 0 && rowSetStateHolder.mExecuteKeyParams != null && rowSetStateHolder.mExecuteKeyParams.length > 0) {
                rowSetStateHolder.mDiffParams = true;
            }
        }
        if (node != null && node.getNodeName() == "rsvars") {
            rowSetStateHolder.mVariables = node.getFirstChild().getNodeValue();
            node = nodeList.item(++n);
        }
        if ((string2 = xMLElement.getAttribute("It")).length() > 0) {
            Object var12_12 = null;
            Object var13_13 = null;
            if (node != null && node.getNodeName() == "Key") {
                rowSetStateHolder.mCurrentRowKeyStr = node.getFirstChild().getNodeValue();
                node = nodeList.item(++n);
            }
            if ((string2 = xMLElement.getAttribute("Sz")).length() > 0) {
                rowSetStateHolder.mRangeSize = new Integer(string2);
            }
            if ((string2 = xMLElement.getAttribute("St")).length() > 0) {
                rowSetStateHolder.mRangeStart = new Integer(string2);
            }
            if ((string2 = xMLElement.getAttribute("im")).length() > 0) {
                rowSetStateHolder.mIterMode = Integer.valueOf(string2);
            }
            rowSetStateHolder.mMasterViewName = string;
        }
        if (rowSetStateHolder.mRowSet != null) {
            rowSetStateHolder.activateRowSet(rowSetStateHolder.mRowSet);
        }
        return n;
    }

    protected void resetSession() {
    }

    public void setPassivationEnabled(boolean bl) {
        this.bPassivate = bl;
    }

    public boolean isPassivationEnabled() {
        return this.bPassivate;
    }

    Key getKeyFromEntityKey(String string, Key key) {
        if (key == null) {
            return null;
        }
        AttributeDef[] attributeDefArray = this.getKeyAttributeDefs();
        int n = attributeDefArray.length;
        Object[] objectArray = new Object[n];
        EntityDefImpl entityDefImpl = EntityDefImpl.findDefObject(string);
        AttributeDefImpl[] attributeDefImplArray = entityDefImpl.getPrimaryKeys();
        int n2 = attributeDefImplArray.length;
        int n3 = 0;
        while (n3 < n) {
            objectArray[n3] = null;
            ViewAttributeDefImpl viewAttributeDefImpl = (ViewAttributeDefImpl)attributeDefArray[n3];
            int n4 = 0;
            while (n4 < n2) {
                if (viewAttributeDefImpl.getReferenceAttribute() == attributeDefImplArray[n4]) {
                    objectArray[n3] = key.getAttribute(n4);
                }
                ++n4;
            }
            ++n3;
        }
        return new Key(objectArray);
    }

    boolean hasSingleUpdateParticipant() {
        boolean bl = true;
        EntityReference[] entityReferenceArray = this.mViewDef.getEntityReferences();
        if (entityReferenceArray != null && entityReferenceArray.length > 1) {
            int n = 0;
            int n2 = 0;
            while (n2 < entityReferenceArray.length && n < 2) {
                if (entityReferenceArray[n2].isInsertParticipant()) {
                    ++n;
                }
                ++n2;
            }
            bl = n < 2;
        }
        return bl;
    }

    public Row[] getFilteredRows(RowQualifier rowQualifier) {
        return this.getDefaultRowSet().getFilteredRows(rowQualifier);
    }

    public Row[] getFilteredRowsInRange(RowQualifier rowQualifier) {
        return this.getDefaultRowSet().getFilteredRowsInRange(rowQualifier);
    }

    public Row[] getFilteredRows(String string, Object object) {
        return this.getDefaultRowSet().getFilteredRows(string, object);
    }

    public Row[] getFilteredRowsInRange(String string, Object object) {
        return this.getDefaultRowSet().getFilteredRowsInRange(string, object);
    }

    private Object[] getDefaultKeyValues(RowSetImpl rowSetImpl) {
        AttributeDefImpl[] attributeDefImplArray = (AttributeDefImpl[])this.getKeyAttributeDefs();
        Object[] objectArray = null;
        try {
            Row row = rowSetImpl.createRow();
            objectArray = row.getKey().getKeyValues();
            row.remove();
        }
        catch (TooManyObjectsException tooManyObjectsException) {
            Diagnostic.println("ViewObject.updateRowSetFromXML - temp. row create failed!");
        }
        if (objectArray == null) {
            objectArray = new Object[attributeDefImplArray.length];
        }
        return objectArray;
    }

    private boolean readKeyAttributes(XmlDocumentReader xmlDocumentReader, Element element, AttributeDefImpl[] attributeDefImplArray, Object[] objectArray) {
        boolean bl = false;
        int n = 0;
        while (n < attributeDefImplArray.length) {
            Object object = null;
            Object object2 = null;
            if (xmlDocumentReader != null) {
                Element element2;
                Element element3 = xmlDocumentReader.getChildElement(element, attributeDefImplArray[n].getXMLElementTag(), 0);
                if (element3 != null) {
                    object2 = attributeDefImplArray[n].getXMLContentValue(element3, false);
                }
                if ((element2 = xmlDocumentReader.getChildElement(element, attributeDefImplArray[n].getXMLElementTag(), 1)) != null && (object = attributeDefImplArray[n].getXMLContentValue(element2, false)) != null && object2 != null && !object2.equals(object)) {
                    bl = true;
                    object2 = object;
                }
                objectArray[n] = object2;
            } else {
                NodeList nodeList = ((XMLElement)element).getChildrenByTagName(attributeDefImplArray[n].getXMLElementTag() + "-Old");
                if (nodeList.getLength() == 0) {
                    nodeList = ((XMLElement)element).getChildrenByTagName(attributeDefImplArray[n].getXMLElementTag());
                    if (nodeList.getLength() > 0) {
                        objectArray[n] = object2 = attributeDefImplArray[n].getXMLContentValue((Element)nodeList.item(0), false);
                    }
                } else {
                    objectArray[n] = object2 = attributeDefImplArray[n].getXMLContentValue((Element)nodeList.item(0), false);
                    bl = true;
                }
            }
            ++n;
        }
        return bl;
    }

    StructureDef getSubclassDef(ViewDefImpl viewDefImpl) {
        StructureDef structureDef;
        if (viewDefImpl == null) {
            return this;
        }
        if (this.mSubclassDefs == null) {
            this.mSubclassDefs = new HashMap(4);
        }
        if ((structureDef = (StructureDef)this.mSubclassDefs.get((Object)viewDefImpl)) == null) {
            structureDef = new ViewObjectSubclassDef(this, viewDefImpl);
            this.mSubclassDefs.put((Object)viewDefImpl, (Object)structureDef);
        }
        return structureDef;
    }

    protected void bindParametersForCollection(QueryCollection queryCollection, Object[] objectArray, PreparedStatement preparedStatement) throws SQLException {
        if (Diagnostic.isOn() && queryCollection != null && queryCollection.getViewObjectImpl() != null) {
            Diagnostic.println("Bind params for ViewObject: " + queryCollection.getViewObjectImpl().getName());
            if (!queryCollection.getRowSetImpl().isDefaultRS()) {
                Diagnostic.println("For RowSet : " + queryCollection.getRowSetImpl().getName());
            }
        }
        this.getSQLBuilder().bindParametersForStmt(this.getBindingStyle(), objectArray, preparedStatement);
        if (queryCollection != null && queryCollection.isRangePaging()) {
            queryCollection.getViewObjectImpl().bindRangePagingParams(preparedStatement, (objectArray != null ? objectArray.length : 0) + 1, queryCollection.mPageStart, queryCollection.mPageSize);
        }
    }

    public Object getRowMatchBindValue(Row row, String string) {
        char c = string.charAt(0);
        QueryCollection queryCollection = ((ViewRowImpl)row).getQueryCollection();
        if (c >= '0' && c <= '9') {
            int n = new Integer(string) - 1;
            return queryCollection.getRowFilter().getParamValues()[n];
        }
        return queryCollection.getRowSetImpl().ensureVariableManager().getVariableValue(string);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public class CacheStatement {
        PreparedStatement mStmt;
        boolean mNeedsDefines;

        CacheStatement(PreparedStatement preparedStatement, boolean bl) {
            this.mStmt = preparedStatement;
            this.mNeedsDefines = bl;
        }
    }

    public class NewRowTracker {
        int mIndex;
        ViewRowImpl mRow;

        NewRowTracker(int n, ViewRowImpl viewRowImpl) {
            this.mIndex = n;
            this.mRow = viewRowImpl;
        }
    }

    public class RowNodeFilter
    implements NodeFilter {
        private Node mVoNode;
        private String mRowNodeName;

        RowNodeFilter(Node node, String string) {
            this.mVoNode = node;
            this.mRowNodeName = string;
        }

        public short acceptNode(Node node) {
            short s = 3;
            String string = node.getNodeName();
            if (node.getNodeType() == 1 && this.mVoNode.equals(node.getParentNode()) && string.equals(this.mRowNodeName)) {
                s = 1;
            }
            return s;
        }
    }
}

