/*
 * Decompiled with CFR 0.152.
 */
package oracle.jbo.server;

import java.util.ArrayList;
import java.util.HashMap;
import oracle.jbo.CriteriaAdapter;
import oracle.jbo.CriteriaClauses;
import oracle.jbo.NoObjException;
import oracle.jbo.ViewCriteria;
import oracle.jbo.ViewCriteriaManager;
import oracle.jbo.ViewObject;
import oracle.jbo.common.Diagnostic;
import oracle.jbo.common.JBOClass;
import oracle.jbo.common.PropertyMetadata;
import oracle.jbo.server.ViewCriteriaAdapter;
import oracle.jbo.server.ViewObjectImpl;

class ViewCriteriaManagerImpl
implements ViewCriteriaManager {
    private ViewObject mViewObject;
    private HashMap mViewCriterias;
    private String[] mApplyViewCriteriaNames;
    private CriteriaAdapter mCriteriaAdapter;
    private String mRowMatchClause;
    private String mQueryWhereClause;
    private int mClauseBuilt;
    static final String DFLT_VIEW_CRITERIA_NAME = "__DefaultViewCriteria__";
    private static /* synthetic */ Class class$oracle$jbo$server$ViewCriteriaAdapter;

    private /* synthetic */ void $init$() {
        this.mClauseBuilt = 0;
    }

    ViewCriteriaManagerImpl(ViewObject viewObject) {
        this.$init$();
        this.mViewObject = viewObject;
    }

    void initViewCriteriaManager() {
        if (this.mViewCriterias == null) {
            this.mViewCriterias = new HashMap(10);
        }
    }

    public void criteriaChanged(ViewCriteria viewCriteria) {
        if (this.isViewCriteriaApplied(viewCriteria)) {
            this.mClauseBuilt &= ~viewCriteria.getCriteriaMode();
            if ((this.mClauseBuilt & ViewCriteria.CRITERIA_MODE_QUERY) == 0) {
                this.mQueryWhereClause = null;
            }
            if ((this.mClauseBuilt & ViewCriteria.CRITERIA_MODE_CACHE) == 0) {
                this.mRowMatchClause = null;
            }
            ((ViewObjectImpl)this.mViewObject).criteriaChanged(viewCriteria);
        }
    }

    public void clearViewCriterias() {
        if (this.mViewCriterias != null) {
            this.mViewCriterias.clear();
        }
        this.mApplyViewCriteriaNames = null;
        this.mCriteriaAdapter = null;
        this.mClauseBuilt = 0;
        this.mRowMatchClause = null;
        this.mQueryWhereClause = null;
    }

    public void applyViewCriteria(ViewCriteria viewCriteria) {
        this.applyViewCriteria(viewCriteria, null);
    }

    public void applyViewCriteria(ViewCriteria viewCriteria, String string) {
        this.clearViewCriterias();
        if (viewCriteria != null) {
            if (string == null || string.length() <= 0) {
                string = DFLT_VIEW_CRITERIA_NAME;
            }
            this.putViewCriteria(string, viewCriteria);
            this.setApplyViewCriteriaName(string);
        }
    }

    public ViewCriteria getViewCriteria() {
        return this.getViewCriteria(DFLT_VIEW_CRITERIA_NAME);
    }

    public ViewCriteria getViewCriteria(String string) {
        if (this.mViewCriterias == null) {
            return null;
        }
        return (ViewCriteria)this.mViewCriterias.get(string);
    }

    public void putViewCriteria(String string, ViewCriteria viewCriteria) {
        this.initViewCriteriaManager();
        this.mViewCriterias.put(string, viewCriteria);
        viewCriteria.setViewCriteriaManager(this);
        if (this.isViewCriteriaNameApplied(string)) {
            this.criteriaChanged(viewCriteria);
        }
    }

    public ViewCriteria removeViewCriteria(String string) {
        if (this.mViewCriterias != null) {
            this.removeApplyViewCriteriaName(string);
            ViewCriteria viewCriteria = this.getViewCriteria(string);
            if (viewCriteria != null) {
                viewCriteria.setViewCriteriaManager(null);
                return (ViewCriteria)this.mViewCriterias.remove(string);
            }
        }
        return null;
    }

    boolean isViewCriteriaNameApplied(String string) {
        boolean bl = false;
        if (this.mApplyViewCriteriaNames != null) {
            int n = 0;
            while (n < this.mApplyViewCriteriaNames.length) {
                if (this.mApplyViewCriteriaNames[n].equals(string)) {
                    bl = true;
                    break;
                }
                ++n;
            }
        }
        return bl;
    }

    boolean isViewCriteriaApplied(ViewCriteria viewCriteria) {
        if (this.mApplyViewCriteriaNames != null) {
            int n = 0;
            while (n < this.mApplyViewCriteriaNames.length) {
                ViewCriteria viewCriteria2 = this.getViewCriteria(this.mApplyViewCriteriaNames[n]);
                if (viewCriteria2 == viewCriteria) {
                    return true;
                }
                ++n;
            }
        }
        return false;
    }

    public String[] getApplyViewCriteriaNames() {
        return this.mApplyViewCriteriaNames;
    }

    public void setApplyViewCriteriaNames(String[] stringArray) {
        this.mApplyViewCriteriaNames = stringArray;
        this.mClauseBuilt = 0;
        this.getApplyViewCriterias(-1);
    }

    public void setApplyViewCriteriaName(String string) {
        this.setApplyViewCriteriaNames(new String[]{string});
    }

    public boolean removeApplyViewCriteriaName(String string) {
        boolean bl = false;
        if (string != null && this.mApplyViewCriteriaNames != null && this.mApplyViewCriteriaNames.length > 0) {
            String[] stringArray = new String[this.mApplyViewCriteriaNames.length - 1];
            int n = 0;
            int n2 = 0;
            while (n2 < this.mApplyViewCriteriaNames.length) {
                if (string.equals(this.mApplyViewCriteriaNames[n2])) {
                    bl = true;
                } else {
                    stringArray[n] = this.mApplyViewCriteriaNames[n2];
                    ++n;
                }
                ++n2;
            }
            this.setApplyViewCriteriaNames(stringArray);
        }
        return bl;
    }

    public ViewCriteria[] getApplyViewCriterias(int n) {
        ViewCriteria[] viewCriteriaArray;
        if (this.mApplyViewCriteriaNames != null) {
            int n2 = this.mApplyViewCriteriaNames.length;
            ArrayList<ViewCriteria> arrayList = new ArrayList<ViewCriteria>(n2);
            int n3 = 0;
            while (n3 < n2) {
                ViewCriteria viewCriteria = this.getViewCriteria(this.mApplyViewCriteriaNames[n3]);
                if (viewCriteria == null) {
                    throw new NoObjException(173, this.mApplyViewCriteriaNames[n3]);
                }
                if ((viewCriteria.getCriteriaMode() & n) != 0) {
                    arrayList.add(viewCriteria);
                }
                ++n3;
            }
            viewCriteriaArray = arrayList.toArray(new ViewCriteria[arrayList.size()]);
        } else {
            viewCriteriaArray = new ViewCriteria[]{};
        }
        return viewCriteriaArray;
    }

    public String[] getAllViewCriteriaNames() {
        if (this.mViewCriterias != null) {
            return this.mViewCriterias.keySet().toArray(new String[this.mViewCriterias.size()]);
        }
        return null;
    }

    public ViewCriteria[] getAllViewCriterias() {
        if (this.mViewCriterias != null) {
            return this.mViewCriterias.values().toArray(new ViewCriteria[this.mViewCriterias.size()]);
        }
        return null;
    }

    public CriteriaClauses buildViewCriteriaClauses(ViewCriteria viewCriteria) {
        Object object = this.mCriteriaAdapter;
        if (object == null) {
            String string = PropertyMetadata.PN_VIEWCRITERIA_ADAPTER.getProperty();
            if (string == null || string.trim().length() == 0) {
                object = ((ViewObjectImpl)this.mViewObject).getSQLBuilder().getViewCriteriaAdapter();
            } else {
                Class clazz;
                if (Diagnostic.isOn()) {
                    Diagnostic.println("Loading ViewCriteriaAdapter " + string);
                }
                if ((clazz = class$oracle$jbo$server$ViewCriteriaAdapter) == null) {
                    clazz = class$oracle$jbo$server$ViewCriteriaAdapter = ViewCriteriaManagerImpl.class$("oracle.jbo.server.ViewCriteriaAdapter");
                }
                Class clazz2 = JBOClass.findCustomClass(string, clazz);
                object = (ViewCriteriaAdapter)JBOClass.newInstance(clazz2);
            }
        }
        this.setCriteriaAdapter(object);
        return CriteriaClauses.buildCriteriaClauses(viewCriteria, this.mCriteriaAdapter);
    }

    public String getViewCriteriaClause(boolean bl) {
        int n;
        int n2 = n = bl ? ViewCriteria.CRITERIA_MODE_QUERY : ViewCriteria.CRITERIA_MODE_CACHE;
        if ((this.mClauseBuilt & n) != 0) {
            return bl ? this.mQueryWhereClause : this.mRowMatchClause;
        }
        ViewCriteria[] viewCriteriaArray = this.getApplyViewCriterias(n);
        String string = null;
        if (viewCriteriaArray != null) {
            int n3 = 0;
            int n4 = 0;
            while (n4 < viewCriteriaArray.length) {
                ViewCriteria viewCriteria = viewCriteriaArray[n4];
                int n5 = viewCriteria.getCriteriaMode();
                CriteriaClauses criteriaClauses = this.buildViewCriteriaClauses(viewCriteria);
                if ((n5 & n) != 0) {
                    String string2;
                    String string3 = string2 = bl ? criteriaClauses.getClauseForQuery() : criteriaClauses.getClauseForCache();
                    if (viewCriteriaArray.length == 1) {
                        return string2;
                    }
                    if (string2 != null) {
                        n3 += string2.length() + 10;
                    }
                }
                ++n4;
            }
            if (n3 == 0) {
                return null;
            }
            StringBuffer stringBuffer = new StringBuffer(n3);
            int n6 = 0;
            while (n6 < viewCriteriaArray.length) {
                ViewCriteria viewCriteria = viewCriteriaArray[n6];
                int n7 = viewCriteria.getCriteriaMode();
                CriteriaClauses criteriaClauses = viewCriteria.getClauses();
                String string4 = null;
                if ((n7 & n) != 0) {
                    String string5 = string4 = bl ? criteriaClauses.getClauseForQuery() : criteriaClauses.getClauseForCache();
                }
                if (string4 != null && string4.length() > 0) {
                    if (stringBuffer.length() > 0) {
                        stringBuffer.append(" AND (");
                    } else {
                        stringBuffer.append(" (");
                    }
                    stringBuffer.append(string4).append(") ");
                }
                ++n6;
            }
            string = stringBuffer.toString();
        }
        if (bl) {
            this.mQueryWhereClause = string;
        } else {
            this.mRowMatchClause = string;
        }
        this.mClauseBuilt |= n;
        return string;
    }

    void setCriteriaAdapter(Object object) {
        this.mCriteriaAdapter = object instanceof CriteriaAdapter ? (CriteriaAdapter)object : new 1CustomCriteriaAdapterImpl((ViewCriteriaAdapter)object);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class 1CustomCriteriaAdapterImpl
    implements CriteriaAdapter {
        ViewCriteriaAdapter mVCA;

        1CustomCriteriaAdapterImpl(ViewCriteriaAdapter viewCriteriaAdapter) {
            this.mVCA = viewCriteriaAdapter;
        }

        public String getCriteriaClause(ViewCriteria viewCriteria) {
            return this.mVCA.getViewCriteriaClause(viewCriteria.getViewObject(), viewCriteria);
        }
    }
}

