/*
 * Decompiled with CFR 0.152.
 */
package oracle.jbo.server;

import com.sun.java.util.collections.ArrayList;
import com.sun.java.util.collections.HashMap;
import java.beans.BeanInfo;
import java.beans.Introspector;
import oracle.jbo.common.Diagnostic;
import oracle.jbo.common.JBOClass;
import oracle.jbo.common.StringManager;
import oracle.jbo.mom.ContainerDefImpl;
import oracle.jbo.mom.xml.DefElement;
import oracle.jbo.server.ApplicationModuleDefImpl;
import oracle.jbo.server.DefObject;
import oracle.jbo.server.EntityAssociation;
import oracle.jbo.server.EntityDefImpl;
import oracle.jbo.server.MetaObjectManager;
import oracle.jbo.server.ViewDefImpl;
import oracle.jbo.server.ViewLinkDefImpl;
import oracle.jbo.server.rules.JbiValidator;
import oracle.jbo.server.util.JboNamedData;

class PackageDefImpl
extends ContainerDefImpl {
    protected HashMap mValidatorTypes;

    private /* synthetic */ void $init$() {
        this.mValidatorTypes = null;
    }

    PackageDefImpl() {
        this(MetaObjectManager.getSingleton());
    }

    PackageDefImpl(MetaObjectManager metaObjectManager) {
        super(metaObjectManager);
        this.$init$();
    }

    protected ArrayList getContainerDefNames(boolean bl) {
        return this.getPackageDefNames(bl);
    }

    ArrayList getEntityDefNames(boolean bl) {
        ArrayList arrayList = new ArrayList();
        this.getChildObjectNames(bl, "Entity", arrayList);
        return arrayList;
    }

    ArrayList getViewDefNames(boolean bl) {
        ArrayList arrayList = new ArrayList();
        this.getChildObjectNames(bl, "ViewObject", arrayList);
        return arrayList;
    }

    ArrayList getEntityAssociationDefNames(boolean bl) {
        ArrayList arrayList = new ArrayList();
        this.getChildObjectNames(bl, "Association", arrayList);
        return arrayList;
    }

    ArrayList getViewLinkDefNames(boolean bl) {
        ArrayList arrayList = new ArrayList();
        this.getChildObjectNames(bl, "ViewLink", arrayList);
        return arrayList;
    }

    ArrayList getApplicationModuleDefNames(boolean bl) {
        ArrayList arrayList = new ArrayList();
        this.getChildObjectNames(bl, "AppModule", arrayList);
        return arrayList;
    }

    ArrayList getPackageDefNames(boolean bl) {
        ArrayList arrayList = new ArrayList();
        this.getChildObjectNames(bl, "JboPackage", arrayList);
        return arrayList;
    }

    protected void setIsProject(boolean bl) {
        super.setIsProject(bl);
    }

    protected void setXMLName(String string, String string2) {
        this.mXMLFileName = string;
        this.mXMLSectionName = string2;
    }

    protected void setJavaPackageName(String string) {
        this.mJavaPackageName = string;
    }

    protected String getJavaPackageName() {
        if (this.mJavaPackageName == null) {
            return this.getClass().getName();
        }
        return this.mJavaPackageName;
    }

    protected void addChild(DefObject defObject, String string) {
        super.addChild(defObject, string);
    }

    protected void addChild(DefObject defObject) {
        super.addChild(defObject);
    }

    protected void removeChild(DefObject defObject, String string) {
        super.removeChild(defObject, string);
    }

    public JbiValidator getValidatorByName(String string) {
        if (this.mValidatorTypes != null) {
            return (JbiValidator)this.mValidatorTypes.get((Object)string);
        }
        return null;
    }

    private JbiValidator createNewValidatorInstance(DefElement defElement, String string) throws Exception {
        Class clazz = JBOClass.forName(string);
        JbiValidator jbiValidator = (JbiValidator)clazz.newInstance();
        BeanInfo beanInfo = Introspector.getBeanInfo(clazz);
        ArrayList arrayList = defElement.getChildrenList("NamedData");
        if (arrayList != null) {
            int n = 0;
            while (n < arrayList.size()) {
                JboNamedData jboNamedData = new JboNamedData();
                jboNamedData.loadFromXMLFile((DefElement)arrayList.get(n));
                jboNamedData.setBeanProperty(beanInfo, jbiValidator);
                ++n;
            }
        }
        return jbiValidator;
    }

    public void loadContainees(DefElement defElement, boolean bl) {
        if (bl) {
            if (Diagnostic.isOn()) {
                Diagnostic.println("Loading from individual XML files");
            }
            this.loadContainees(defElement);
        } else {
            this.loadEntities(defElement);
            this.loadAssociations(defElement);
            this.loadViewObjects(defElement);
            this.loadViewLinks(defElement);
            this.loadAppModules(defElement);
        }
    }

    protected ContainerDefImpl createContainerType(String string) {
        if (string.equalsIgnoreCase("JboPackage") || string.equalsIgnoreCase("JboEjbPackage")) {
            return new PackageDefImpl();
        }
        return null;
    }

    private void loadEntities(DefElement defElement) {
        ArrayList arrayList;
        if (Diagnostic.isOn()) {
            Diagnostic.println("Loading Entities for the Package '" + this.getFullName() + "'.");
        }
        if ((arrayList = defElement.getChildrenList("Entity")) != null && arrayList.size() > 0) {
            EntityDefImpl entityDefImpl = null;
            int n = 0;
            while (n < arrayList.size()) {
                DefElement defElement2 = (DefElement)arrayList.get(n);
                entityDefImpl = EntityDefImpl.loadFromXML(defElement2);
                entityDefImpl.setFullName(this.getJavaPackageName() + "." + entityDefImpl.getName());
                this.addChild(entityDefImpl, "Entity");
                if (Diagnostic.isOn()) {
                    Diagnostic.println("Successfully loaded Entity '" + entityDefImpl.getFullName() + "'.");
                }
                ++n;
            }
        }
    }

    private void loadViewObjects(DefElement defElement) {
        ArrayList arrayList = defElement.getChildrenList("ViewObject");
        if (arrayList != null && arrayList.size() > 0) {
            ViewDefImpl viewDefImpl = null;
            int n = 0;
            while (n < arrayList.size()) {
                DefElement defElement2 = (DefElement)arrayList.get(n);
                viewDefImpl = ViewDefImpl.loadFromXML(defElement2);
                viewDefImpl.setFullName(this.getJavaPackageName() + "." + viewDefImpl.getName());
                this.addChild(viewDefImpl, "ViewObject");
                if (Diagnostic.isOn()) {
                    Diagnostic.println("Successfully loaded View Object '" + viewDefImpl.getFullName() + "'.");
                }
                ++n;
            }
        }
    }

    private void loadAssociations(DefElement defElement) {
        ArrayList arrayList = defElement.getChildrenList("Association");
        if (arrayList != null && arrayList.size() > 0) {
            EntityAssociation entityAssociation = null;
            int n = 0;
            while (n < arrayList.size()) {
                DefElement defElement2 = (DefElement)arrayList.get(n);
                entityAssociation = EntityAssociation.loadFromXML(defElement2);
                entityAssociation.setFullName(this.getJavaPackageName() + "." + entityAssociation.getName());
                this.addChild(entityAssociation, "Association");
                if (Diagnostic.isOn()) {
                    Diagnostic.println("Successfully loaded Entity Association '" + entityAssociation.getFullName() + "'.");
                }
                ++n;
            }
        }
    }

    private void loadViewLinks(DefElement defElement) {
        ArrayList arrayList = defElement.getChildrenList("ViewLink");
        if (arrayList != null && arrayList.size() > 0) {
            ViewLinkDefImpl viewLinkDefImpl = null;
            int n = 0;
            while (n < arrayList.size()) {
                DefElement defElement2 = (DefElement)arrayList.get(n);
                viewLinkDefImpl = ViewLinkDefImpl.loadFromXML(defElement2);
                viewLinkDefImpl.setFullName(this.getJavaPackageName() + "." + viewLinkDefImpl.getName());
                this.addChild(viewLinkDefImpl, "ViewLink");
                if (Diagnostic.isOn()) {
                    Diagnostic.println("Successfully loaded ViewLink '" + viewLinkDefImpl.getFullName() + "'.");
                }
                ++n;
            }
        }
    }

    private void loadAppModules(DefElement defElement) {
        ArrayList arrayList = defElement.getChildrenList("AppModule");
        if (arrayList != null && arrayList.size() > 0) {
            ApplicationModuleDefImpl applicationModuleDefImpl = null;
            int n = 0;
            while (n < arrayList.size()) {
                DefElement defElement2 = (DefElement)arrayList.get(n);
                applicationModuleDefImpl = ApplicationModuleDefImpl.loadFromXML(defElement2);
                applicationModuleDefImpl.setFullName(this.getJavaPackageName() + "." + applicationModuleDefImpl.getName());
                this.addChild(applicationModuleDefImpl, "AppModule");
                if (Diagnostic.isOn()) {
                    Diagnostic.println("Successfully loaded ApplicationModule '" + applicationModuleDefImpl.getFullName() + "'.");
                }
                ++n;
            }
        }
    }

    protected boolean hasJava() {
        return super.hasJava();
    }

    protected void loadFromXMLFile(DefElement defElement) {
        ArrayList arrayList = defElement.readStringArrayList("MessageBundles");
        if (arrayList != null && arrayList.size() > 0) {
            StringManager.getSingleton().appendCustomMessageBundles(arrayList);
        }
        super.loadFromXMLFile(defElement);
    }
}

