/*
 * Decompiled with CFR 0.152.
 */
package oracle.jbo.server;

import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.transaction.InvalidTransactionException;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import oracle.jbo.JboException;
import oracle.jbo.common.Diagnostic;
import oracle.jbo.server.DefaultJTATxnHandlerImpl;

public class JTATxnHandlerImpl
extends DefaultJTATxnHandlerImpl
implements Synchronization {
    private Transaction mSuspendedTransaction;
    private static final String TM_JNDI_NAME = "java:comp/pm/TransactionManager";

    public void doRegister() {
        try {
            Transaction transaction = JTATxnHandlerImpl.getCurrentTransaction();
            if (transaction != null) {
                transaction.registerSynchronization((Synchronization)this);
            } else if (Diagnostic.isOn()) {
                Diagnostic.println("Unable to find Current transaction");
            }
        }
        catch (IllegalStateException illegalStateException) {
            throw illegalStateException;
        }
        catch (RollbackException rollbackException) {
            throw new IllegalStateException(rollbackException.getMessage());
        }
        catch (SystemException systemException) {
            throw new IllegalStateException(systemException.getMessage());
        }
    }

    public void beforeCompletion() {
        block8: {
            try {
                Transaction transaction = JTATxnHandlerImpl.getCurrentTransaction();
                int n = transaction.getStatus();
                if (Diagnostic.isOn()) {
                    Diagnostic.println("Before completion: status=" + this.getStatusAsString(n));
                }
                switch (n) {
                    case 1: 
                    case 4: 
                    case 9: {
                        this.doRollback();
                        break;
                    }
                    case 0: 
                    case 8: {
                        this.doPostChanges();
                        break;
                    }
                    default: {
                        if (Diagnostic.isOn()) {
                            Diagnostic.println("Unknown Transaction status " + this.getStatusAsString(n));
                        }
                        break;
                    }
                }
            }
            catch (Exception exception) {
                if (!Diagnostic.isOn()) break block8;
                Diagnostic.printStackTrace(exception);
            }
        }
    }

    public void afterCompletion(int n) {
        if (Diagnostic.isOn()) {
            Diagnostic.println("AfterCompletion:  Transaction status " + this.getStatusAsString(n));
        }
        switch (n) {
            case 1: 
            case 4: 
            case 9: {
                try {
                    this.doRollback();
                }
                catch (Throwable throwable) {
                    if (!Diagnostic.isOn()) break;
                    Diagnostic.println("Error in rollback. Ignored");
                    Diagnostic.printStackTrace(throwable);
                }
                break;
            }
            case 3: 
            case 5: {
                break;
            }
            default: {
                if (!Diagnostic.isOn()) break;
                Diagnostic.println("AfterCompletion: Ignored.");
            }
        }
        this.disconnect();
    }

    private void doPostChanges() {
        try {
            super.postChanges();
        }
        catch (JboException jboException) {
            block4: {
                try {
                    JTATxnHandlerImpl.getCurrentTransaction().setRollbackOnly();
                }
                catch (Exception exception) {
                    if (!Diagnostic.isOn()) break block4;
                    Diagnostic.printStackTrace(exception);
                }
            }
            throw jboException;
        }
    }

    private void doRollback() {
        try {
            super.rollback();
        }
        catch (JboException jboException) {
            block5: {
                try {
                    JTATxnHandlerImpl.getCurrentTransaction().setRollbackOnly();
                    if (Diagnostic.isOn()) {
                        Diagnostic.println("JTATxnHandler: Error in local rollback. Marking global rollback");
                    }
                }
                catch (Exception exception) {
                    if (!Diagnostic.isOn()) break block5;
                    Diagnostic.printStackTrace(exception);
                }
            }
            throw jboException;
        }
    }

    static Transaction getCurrentTransaction() throws IllegalStateException, SystemException {
        try {
            Transaction transaction = JTATxnHandlerImpl.getTransactionManager().getTransaction();
            return transaction;
        }
        catch (NamingException namingException) {
            if (Diagnostic.isOn()) {
                Diagnostic.println("Unable to find Current transaction");
            }
            throw new JboException(namingException);
        }
    }

    private String getStatusAsString(int n) {
        if (n == 0) {
            return "STATUS_ACTIVE";
        }
        if (n == 3) {
            return "STATUS_COMMITTED";
        }
        if (n == 8) {
            return "STATUS_COMMITTING";
        }
        if (n == 1) {
            return "STATUS_MARKED_ROLLBACK";
        }
        if (n == 6) {
            return "STATUS_NO_TRANSACTION";
        }
        if (n == 2) {
            return "STATUS_PREPARED";
        }
        if (n == 7) {
            return "STATUS_PREPARING";
        }
        if (n == 4) {
            return "STATUS_ROLLEDBACK";
        }
        if (n == 9) {
            return "STATUS_ROLLING_BACK";
        }
        if (n == 5) {
            return "STATUS_UNKNOWN";
        }
        return "Error: Invalid status" + n;
    }

    public void suspend() {
        try {
            TransactionManager transactionManager = JTATxnHandlerImpl.getTransactionManager();
            this.mSuspendedTransaction = transactionManager.suspend();
        }
        catch (SystemException systemException) {
            throw new JboException(systemException);
        }
        catch (NamingException namingException) {
            throw new JboException(namingException);
        }
    }

    public void resume() {
        if (this.mSuspendedTransaction != null) {
            try {
                try {
                    TransactionManager transactionManager = JTATxnHandlerImpl.getTransactionManager();
                    transactionManager.resume(this.mSuspendedTransaction);
                }
                catch (SystemException systemException) {
                    throw new JboException(systemException);
                }
                catch (InvalidTransactionException invalidTransactionException) {
                    throw new JboException(invalidTransactionException);
                }
                catch (IllegalStateException illegalStateException) {
                    throw new JboException(illegalStateException);
                }
                catch (NamingException namingException) {
                    throw new JboException(namingException);
                }
                Object var7_2 = null;
                this.mSuspendedTransaction = null;
            }
            catch (Throwable throwable) {
                Object var7_3 = null;
                this.mSuspendedTransaction = null;
                throw throwable;
            }
        }
    }

    static TransactionManager getTransactionManager() throws NamingException {
        return (TransactionManager)new InitialContext().lookup(TM_JNDI_NAME);
    }
}

