/*
 * Decompiled with CFR 0.152.
 */
package oracle.jbo.server;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Random;
import oracle.jbo.JboException;
import oracle.jbo.JboSerializationException;
import oracle.jbo.common.Diagnostic;
import oracle.jbo.common.PropertyMetadata;
import oracle.jbo.server.ApplicationModuleImpl;
import oracle.jbo.server.Serializer;
import oracle.jbo.server.xml.JboXMLUtil;
import oracle.xml.parser.v2.DOMParser;
import oracle.xml.parser.v2.XMLDocument;

class FileSerializer
extends Serializer {
    Random randomGen;
    String tmpDir;
    static final String SNAP_FILE_EXT = "BCD";
    static final String SNAP_FILE_PREFIX = "BC";
    static final byte READ = 0;
    static final byte READ_AND_REMOVE = 1;
    static final byte REMOVE = 2;

    private /* synthetic */ void $init$() {
        this.randomGen = null;
        this.tmpDir = null;
    }

    FileSerializer(ApplicationModuleImpl applicationModuleImpl) {
        super(applicationModuleImpl);
        this.$init$();
        if (Diagnostic.isOn()) {
            Diagnostic.println("*** Serialization to file initialized! ***");
        }
    }

    void setup() {
        this.randomGen = new Random();
        this.tmpDir = (String)this.rootAM.getSession().getEnvironment().get(PropertyMetadata.TEMPORARY_FILES_HOME.pName);
        this.tmpDir = JboXMLUtil.getBC4JTempDir(this.rootAM);
        if (Diagnostic.isOn()) {
            Diagnostic.println("File Serialization will use the directory :" + this.tmpDir);
        }
    }

    int storeToFile(XMLDocument xMLDocument, Integer n) {
        if (this.tmpDir == null) {
            this.setup();
        }
        int n2 = -1;
        File file = null;
        String string = this.tmpDir + SNAP_FILE_PREFIX;
        if (n != null) {
            n2 = n;
            file = new File(string + Integer.toHexString(n2) + SNAP_FILE_EXT);
            if (!file.exists()) {
                throw new JboSerializationException(false, n2, "File", null);
            }
            file.delete();
        } else {
            n2 = this.nextRandomInt();
            while (file == null) {
                file = new File(string + Integer.toHexString(n2) + SNAP_FILE_EXT);
                if (!file.exists()) continue;
                n2 = this.nextRandomInt();
                file = null;
            }
        }
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            xMLDocument.print((OutputStream)fileOutputStream);
            fileOutputStream.close();
            int n3 = n2;
            return n3;
        }
        catch (IOException iOException) {
            throw new JboSerializationException(true, n2, "File", iOException);
        }
    }

    XMLDocument processFile(int n, byte by) {
        String string;
        File file;
        if (this.tmpDir == null) {
            this.setup();
        }
        if ((file = new File(string = this.tmpDir + SNAP_FILE_PREFIX + Integer.toHexString(n) + SNAP_FILE_EXT)).exists() && file.length() > 0L) {
            try {
                if (by == 0 || by == 1) {
                    DOMParser dOMParser = oracle.jbo.common.JboXMLUtil.createDOMParser(false);
                    FileInputStream fileInputStream = new FileInputStream(file);
                    dOMParser.parse((InputStream)fileInputStream);
                    fileInputStream.close();
                    if (by == 1) {
                        file.delete();
                    }
                    XMLDocument xMLDocument = dOMParser.getDocument();
                    return xMLDocument;
                }
                file.delete();
                XMLDocument xMLDocument = null;
                return xMLDocument;
            }
            catch (JboException jboException) {
                throw jboException;
            }
            catch (Exception exception) {
                throw new JboSerializationException(false, n, "File", exception);
            }
        }
        if (by != 2) {
            throw new JboSerializationException(false, n, "File", null);
        }
        return null;
    }

    int snapCommittedEOs() {
        XMLDocument xMLDocument = new XMLDocument();
        this.passivateCommitList(xMLDocument);
        return this.storeToFile(xMLDocument, null);
    }

    void replayCommittedEOs(int n) {
        this.activateCommitList(this.processFile(n, (byte)0));
    }

    void removeCommittedEOs(int n) {
        this.processFile(n, (byte)2);
    }

    int reservePassivationId() {
        if (this.tmpDir == null) {
            this.setup();
        }
        File file = null;
        int n = this.nextRandomInt();
        String string = this.tmpDir + SNAP_FILE_PREFIX;
        while (file == null) {
            file = new File(string + Integer.toHexString(n) + SNAP_FILE_EXT);
            if (!file.exists()) continue;
            n = this.nextRandomInt();
            file = null;
        }
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            fileOutputStream.write(new byte[0]);
            fileOutputStream.close();
        }
        catch (IOException iOException) {
            throw new JboSerializationException(true, n, "File", iOException);
        }
        return n;
    }

    int passivateRootAM(byte[] byArray) {
        return this.passivateRootAM(byArray, 1);
    }

    int passivateRootAM(byte[] byArray, int n) {
        XMLDocument xMLDocument = new XMLDocument();
        this.passivate(xMLDocument, byArray, n);
        return this.storeToFile(xMLDocument, null);
    }

    int passivateRootAM(int n, byte[] byArray) {
        return this.passivateRootAM(n, byArray, 1);
    }

    int passivateRootAM(int n, byte[] byArray, int n2) {
        XMLDocument xMLDocument = new XMLDocument();
        this.passivate(xMLDocument, byArray, n2);
        return this.storeToFile(xMLDocument, new Integer(n));
    }

    byte[] activateRootAM(int n, boolean bl) {
        return this.activateRootAM(n, bl, 1);
    }

    byte[] activateRootAM(int n, boolean bl, int n2) {
        return this.activate(this.processFile(n, bl ? (byte)1 : 0), n2);
    }

    void removeRootAM(int n) {
        this.processFile(n, (byte)2);
    }

    private int nextRandomInt() {
        int n = this.randomGen.nextInt();
        if (n < 0) {
            n = -1 * n;
        }
        return n;
    }
}

