/*
 * Decompiled with CFR 0.152.
 */
package oracle.jbo.server;

import com.sun.java.util.collections.ArrayList;
import com.sun.java.util.collections.HashMap;
import com.sun.java.util.collections.Map;
import java.util.Vector;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import oracle.jbo.AttributeDef;
import oracle.jbo.AttributeList;
import oracle.jbo.InvalidOperException;
import oracle.jbo.JboException;
import oracle.jbo.Key;
import oracle.jbo.KeyNotFoundException;
import oracle.jbo.NameClashException;
import oracle.jbo.NoDefException;
import oracle.jbo.PersistenceException;
import oracle.jbo.Row;
import oracle.jbo.RowCreateException;
import oracle.jbo.RowIterator;
import oracle.jbo.RowNotFoundException;
import oracle.jbo.RowValException;
import oracle.jbo.StructureDef;
import oracle.jbo.TooManyObjectsException;
import oracle.jbo.common.Diagnostic;
import oracle.jbo.common.JBOClass;
import oracle.jbo.common.JboNameUtil;
import oracle.jbo.common.JboTypeMap;
import oracle.jbo.domain.NullValue;
import oracle.jbo.mom.xml.DefElement;
import oracle.jbo.rules.AbstractValidator;
import oracle.jbo.rules.JboAbstractValidator;
import oracle.jbo.rules.JboCompareValidator;
import oracle.jbo.rules.JboLengthValidator;
import oracle.jbo.rules.JboListValidator;
import oracle.jbo.rules.JboMethodValidator;
import oracle.jbo.rules.JboRangeValidator;
import oracle.jbo.rules.JboRegExpValidator;
import oracle.jbo.rules.JboValidatorContext;
import oracle.jbo.rules.JboValidatorInterface;
import oracle.jbo.rules.RulesBeanUtils;
import oracle.jbo.server.AssociationDefImpl;
import oracle.jbo.server.AttributeDefImpl;
import oracle.jbo.server.BaseSQLBuilderImpl;
import oracle.jbo.server.ComponentObjectImpl;
import oracle.jbo.server.DBTransaction;
import oracle.jbo.server.DBTransactionImpl;
import oracle.jbo.server.Entity;
import oracle.jbo.server.EntityAssociation;
import oracle.jbo.server.EntityCache;
import oracle.jbo.server.EntityDefOverRowSet;
import oracle.jbo.server.EntityImpl;
import oracle.jbo.server.GlueCodeGen;
import oracle.jbo.server.JboMandatoryAttributesValidator;
import oracle.jbo.server.MetaObjectManager;
import oracle.jbo.server.RowDef;
import oracle.jbo.server.SQLBuilder;
import oracle.jbo.server.ValidationBeanLoader;
import oracle.jbo.server.ViewDefImpl;
import oracle.jbo.server.java.util.Iterator;
import oracle.jbo.server.rules.JboBaseValidator;
import oracle.jbo.server.rules.JboSQLCompareValidator;
import oracle.jbo.server.rules.JboSQLListValidator;
import oracle.jbo.server.rules.JboVOCompareValidator;
import oracle.jbo.server.rules.JboVOListValidator;
import oracle.jbo.server.util.PropertyChangeEvent;
import oracle.jbo.server.util.PropertyChangeListener;
import oracle.jbo.server.util.VetoableChangeListener;

public class EntityDefImpl
extends RowDef
implements StructureDef {
    public static final String DBOBJ_TYPE_TABLE = "table";
    public static final String DBOBJ_TYPE_VIEW = "view";
    public static final String DBOBJ_TYPE_OBJTYP = "objtyp";
    public static final String DBOBJ_TYPE_OBJTAB = "objtab";
    static int mIdCounter = 0;
    protected ArrayList mAttrAccessors;
    protected ArrayList mAssocAccessors;
    protected ArrayList mAssocs;
    protected AttributeDefImpl[] mFKeys;
    protected AttributeDefImpl[] mPrimaryKeys;
    AttributeDefImpl[] mPersistableAttrs;
    protected AttributeDefImpl mOIDAttribute;
    protected String mSource;
    protected String mSourceType;
    protected boolean mIsObjectTable;
    private String mQuery;
    private ArrayList mValidators;
    private ArrayList mVetoableValidators;
    private Class mRowClass;
    private Class mCollClass;
    private boolean mIsRefPKBased;
    private int mRefAttrIndex;
    private boolean mIsRowIDPrimaryKey;
    private boolean mIsOIDInPrimaryKey;
    private boolean mAssociationAccessorRetained;
    private boolean mUpdateChangedColumns;
    private boolean mUseGlueCode;
    private AttributeDefImpl mChangeIndicatorColumn;
    private HashMap mTempAttrVTable;
    private int mTempAttrIndex;
    private int mNumInheritedAttrs;
    private ArrayList mLobAttrs;
    HashMap mPublishEvents;
    boolean mCascadeDelete;
    protected int mBatchThreshold;
    private int mId;
    private String mEJBHomeJNDIName;
    private String mEJBAppProviderURL;
    private Object mEJBHome;
    AttributeDefImpl[] mHistoryAttrs;
    private boolean mSingleUseKeyStmt;
    private ArrayList mCascadeUpdateAssocs;
    private boolean mUseReturningClause;
    private String mUniquePKValResId;
    private static String VERSION_TWO = "2";
    private static /* synthetic */ Class class$oracle$jbo$server$AttributeDefImpl;
    private static /* synthetic */ Class class$oracle$jbo$domain$BlobDomainInterface;
    private static /* synthetic */ Class class$oracle$jbo$server$EntityDefImpl;
    private static /* synthetic */ Class class$oracle$jbo$server$EntityImpl;
    private static /* synthetic */ Class class$oracle$jbo$server$EntityCache;
    private static /* synthetic */ Class class$oracle$jbo$CSMessageBundle;
    private static /* synthetic */ Class class$oracle$jbo$server$EntityReference;

    private /* synthetic */ void $init$() {
        this.mAttrAccessors = new ArrayList();
        this.mAssocAccessors = new ArrayList();
        this.mAssocs = new ArrayList();
        this.mFKeys = null;
        this.mPrimaryKeys = new AttributeDefImpl[0];
        this.mPersistableAttrs = null;
        this.mOIDAttribute = null;
        this.mIsObjectTable = false;
        this.mQuery = null;
        this.mValidators = null;
        this.mVetoableValidators = null;
        this.mIsRefPKBased = false;
        this.mRefAttrIndex = -2;
        this.mIsRowIDPrimaryKey = false;
        this.mIsOIDInPrimaryKey = false;
        this.mAssociationAccessorRetained = false;
        this.mUpdateChangedColumns = true;
        this.mUseGlueCode = true;
        this.mChangeIndicatorColumn = null;
        this.mTempAttrVTable = new HashMap();
        this.mTempAttrIndex = 0;
        this.mNumInheritedAttrs = 0;
        this.mLobAttrs = null;
        this.mPublishEvents = null;
        this.mCascadeDelete = false;
        this.mBatchThreshold = 0;
        this.mEJBHomeJNDIName = null;
        this.mEJBAppProviderURL = null;
        this.mHistoryAttrs = null;
        this.mSingleUseKeyStmt = false;
        this.mCascadeUpdateAssocs = null;
        this.mUseReturningClause = true;
        this.mUniquePKValResId = null;
    }

    protected EntityDefImpl() {
        this.$init$();
        this.mId = mIdCounter++;
        Class clazz = class$oracle$jbo$server$EntityCache;
        if (clazz == null) {
            clazz = class$oracle$jbo$server$EntityCache = EntityDefImpl.class$("oracle.jbo.server.EntityCache");
        }
        this.setCollClass(clazz);
    }

    public EntityDefImpl(String string) {
        this();
        this.setName(string);
    }

    int getEntityDefId() {
        return this.mId;
    }

    static EntityDefImpl findDefObjectNoSub(String string) {
        Class clazz = class$oracle$jbo$server$EntityDefImpl;
        if (clazz == null) {
            clazz = class$oracle$jbo$server$EntityDefImpl = EntityDefImpl.class$("oracle.jbo.server.EntityDefImpl");
        }
        return (EntityDefImpl)MetaObjectManager.findMetaObject(string, 21, clazz, false);
    }

    public static EntityDefImpl findDefObject(String string) {
        Class clazz = class$oracle$jbo$server$EntityDefImpl;
        if (clazz == null) {
            clazz = class$oracle$jbo$server$EntityDefImpl = EntityDefImpl.class$("oracle.jbo.server.EntityDefImpl");
        }
        return (EntityDefImpl)MetaObjectManager.findMetaObject(string, 21, clazz, true);
    }

    protected void createDef() {
    }

    protected EntityAssociation[] getEntityAssociations() {
        return (EntityAssociation[])this.mAssocs.toArray((Object[])new EntityAssociation[this.mAssocs.size()]);
    }

    protected void addEntityAssociation(EntityAssociation entityAssociation) {
        if (!this.mAssocs.contains((Object)entityAssociation)) {
            this.mAssocs.add((Object)entityAssociation);
        }
    }

    public AttributeDefImpl getAttributeDefImpl(String string) {
        string = string.intern();
        int n = 0;
        while (n < this.mAttrAccessors.size()) {
            if (((AttributeDefImpl)this.mAttrAccessors.get(n)).getName() == string) {
                return (AttributeDefImpl)this.mAttrAccessors.get(n);
            }
            ++n;
        }
        return null;
    }

    public AttributeDefImpl getAttributeDefImpl(int n) {
        if (n >= 0 && n < this.mAttrAccessors.size()) {
            return (AttributeDefImpl)this.mAttrAccessors.get(n);
        }
        return null;
    }

    protected AttributeDefImpl getAttributeDefImplByColumnName(String string) {
        int n = 0;
        while (n < this.mAttrAccessors.size()) {
            String string2 = ((AttributeDefImpl)this.mAttrAccessors.get((int)n)).mColumnName;
            if (string2 != null && string2.equalsIgnoreCase(string)) {
                return (AttributeDefImpl)this.mAttrAccessors.get(n);
            }
            ++n;
        }
        return null;
    }

    protected AttributeDefImpl[] getAttributeDefImpls() {
        return (AttributeDefImpl[])this.mAttrAccessors.toArray((Object[])new AttributeDefImpl[this.mAttrAccessors.size()]);
    }

    public AttributeDef[] getAttributeDefs() {
        return this.getAttributeDefImpls();
    }

    public int getAttributeCount() {
        return this.mAttrAccessors.size();
    }

    public AttributeDef findAttributeDef(String string) {
        AttributeDef attributeDef = this.lookupAttributeDef(string);
        if (attributeDef != null) {
            return attributeDef;
        }
        throw new NoDefException(131, string, this.getName());
    }

    public AttributeDef lookupAttributeDef(String string) {
        return this.getAttributeDefImpl(string);
    }

    public AttributeDef getAttributeDef(int n) {
        return this.getAttributeDefImpl(n);
    }

    void setAttributeDefImpls(AttributeDefImpl[] attributeDefImplArray) {
        boolean bl = false;
        boolean bl2 = false;
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList2 = new ArrayList();
        this.mAttrAccessors.clear();
        ArrayList arrayList3 = new ArrayList();
        int n = 0;
        while (n < attributeDefImplArray.length) {
            this.mAttrAccessors.add((Object)attributeDefImplArray[n]);
            if (attributeDefImplArray[n].isObjectTableOID()) {
                bl2 = true;
                this.mOIDAttribute = attributeDefImplArray[n];
            }
            if (attributeDefImplArray[n].isPrimaryKey()) {
                arrayList.add((Object)attributeDefImplArray[n]);
                if (attributeDefImplArray[n].getColumnName() != null && attributeDefImplArray[n].getColumnName().equalsIgnoreCase(EntityImpl.ORACLE_ROWID_COLUMN)) {
                    bl = true;
                }
            }
            if (attributeDefImplArray[n].isDiscrColumn()) {
                arrayList2.add((Object)attributeDefImplArray[n]);
            }
            if (attributeDefImplArray[n].isMandatory()) {
                arrayList3.add((Object)attributeDefImplArray[n]);
            }
            ++n;
        }
        if (arrayList.size() == 0) {
            throw new KeyNotFoundException(this.getFullName());
        }
        this.mPrimaryKeys = (AttributeDefImpl[])arrayList.toArray((Object[])new AttributeDefImpl[arrayList.size()]);
        if (this.mPrimaryKeys.length == 1) {
            if (bl2) {
                this.mIsOIDInPrimaryKey = true;
            } else if (bl) {
                this.mIsRowIDPrimaryKey = true;
            }
        }
        if (arrayList2.size() > 0) {
            this.setDiscrColumns((AttributeDefImpl[])arrayList2.toArray((Object[])new AttributeDefImpl[arrayList2.size()]));
        }
        if (arrayList3.size() > 0) {
            this.addValidator(new JboMandatoryAttributesValidator(arrayList3));
        }
    }

    public AssociationDefImpl getAssociationDefImpl(String string) {
        string = string.intern();
        int n = this.mAssocAccessors.size();
        int n2 = 0;
        n2 = 0;
        while (n2 < n) {
            Object object = this.mAssocAccessors.get(n2);
            if (((AssociationDefImpl)object).getName() == string) {
                return (AssociationDefImpl)object;
            }
            ++n2;
        }
        return null;
    }

    public AssociationDefImpl getAssociationDefImpl(int n) {
        if (n < 0 && n >= this.mAssocAccessors.size()) {
            return null;
        }
        return (AssociationDefImpl)this.mAssocAccessors.get(n);
    }

    public AssociationDefImpl[] getAssociationDefImpls() {
        return (AssociationDefImpl[])this.mAssocAccessors.toArray((Object[])new AssociationDefImpl[this.mAssocAccessors.size()]);
    }

    void setAssociationDefImpl(String string, AssociationDefImpl associationDefImpl) {
        string = string.intern();
        int n = 0;
        while (n < this.mAssocAccessors.size()) {
            Object object = this.mAssocAccessors.get(n);
            String string2 = null;
            if (object instanceof AssociationDefImpl) {
                string2 = ((AssociationDefImpl)object).getName();
            }
            if (string == string2) {
                this.mAssocAccessors.set(n, (Object)associationDefImpl);
                return;
            }
            ++n;
        }
        this.mAssocAccessors.add((Object)associationDefImpl);
    }

    void addCascadeUpdateAssoc(EntityAssociation entityAssociation) {
        if (this.mCascadeUpdateAssocs == null) {
            this.mCascadeUpdateAssocs = new ArrayList(3);
        } else if (this.mCascadeUpdateAssocs.size() == 2) {
            this.mCascadeUpdateAssocs.ensureCapacity(6);
        }
        this.mCascadeUpdateAssocs.add((Object)entityAssociation);
    }

    void collectCascadeUpdateMap(EntityImpl entityImpl, int n, Map map) {
        EntityAssociation entityAssociation;
        int n2 = this.mCascadeUpdateAssocs.size();
        ArrayList arrayList = new ArrayList(n2);
        int n3 = 0;
        while (n3 < n2) {
            entityAssociation = (EntityAssociation)this.mCascadeUpdateAssocs.get(n3);
            AttributeDefImpl[] attributeDefImplArray = entityAssociation.getSourceEnd().getAttributeDefImpls();
            int n4 = 0;
            while (n4 < attributeDefImplArray.length) {
                if (n == attributeDefImplArray[n4].mIndex) {
                    arrayList.add((Object)entityAssociation);
                    break;
                }
                ++n4;
            }
            ++n3;
        }
        int n5 = 0;
        while (n5 < arrayList.size()) {
            entityAssociation = (EntityAssociation)arrayList.get(n5);
            map.put((Object)entityAssociation, entityAssociation.getSourceEnd().getAccessor().get(entityImpl));
            ++n5;
        }
    }

    void doCascadeUpdate(EntityImpl entityImpl, HashMap hashMap) {
        com.sun.java.util.collections.Iterator iterator = hashMap.keySet().iterator();
        while (iterator.hasNext()) {
            EntityAssociation entityAssociation = (EntityAssociation)iterator.next();
            Object object = hashMap.get((Object)entityAssociation);
            AssociationDefImpl associationDefImpl = entityAssociation.getSourceEnd().getAccessor();
            AssociationDefImpl associationDefImpl2 = entityAssociation.getDestinationEnd().getAccessor();
            if (associationDefImpl.mKind == 2) {
                associationDefImpl2.set((Row)object, entityImpl, false);
                continue;
            }
            RowIterator rowIterator = (RowIterator)object;
            while (rowIterator.hasNext()) {
                associationDefImpl2.set(rowIterator.next(), entityImpl, false);
            }
        }
    }

    public String getSource() {
        return this.mSource;
    }

    public void setSource(String string) {
        this.mSource = string;
    }

    public boolean isObjectTable() {
        return this.mIsObjectTable;
    }

    public String getSourceType() {
        return this.mSourceType;
    }

    public void setSourceType(String string) {
        this.mSourceType = string;
        if (this.mSourceType.equals(DBOBJ_TYPE_OBJTAB)) {
            this.mIsObjectTable = true;
        }
    }

    public String getEJBHomeJNDIName() {
        return this.mEJBHomeJNDIName;
    }

    public void setEJBHomeJNDIName(String string) {
        this.mEJBHomeJNDIName = string;
    }

    public String getEJBAppProviderURL() {
        return this.mEJBAppProviderURL;
    }

    public void setEJBAppProviderURL(String string) {
        this.mEJBAppProviderURL = string;
    }

    public void setBatchThreshold(int n) {
        this.mBatchThreshold = n;
    }

    public Iterator getAllEntityInstances(DBTransaction dBTransaction) {
        if (dBTransaction instanceof DBTransactionImpl) {
            return new 1WrapIterator(((DBTransactionImpl)dBTransaction).findEntityCache(this).iterator());
        }
        return null;
    }

    public com.sun.java.util.collections.Iterator getAllEntityInstancesIterator(DBTransaction dBTransaction) {
        if (dBTransaction instanceof DBTransactionImpl) {
            return ((DBTransactionImpl)dBTransaction).findEntityCache(this).iterator();
        }
        return null;
    }

    public Class getRowClass() {
        Class clazz;
        if (this.mRowClass == null) {
            clazz = class$oracle$jbo$server$EntityImpl;
            if (clazz == null) {
                clazz = class$oracle$jbo$server$EntityImpl = EntityDefImpl.class$("oracle.jbo.server.EntityImpl");
            }
        } else {
            clazz = this.mRowClass;
        }
        return clazz;
    }

    public Class getCollClass() {
        Class clazz;
        if (this.mCollClass == null) {
            clazz = class$oracle$jbo$server$EntityCache;
            if (clazz == null) {
                clazz = class$oracle$jbo$server$EntityCache = EntityDefImpl.class$("oracle.jbo.server.EntityCache");
            }
        } else {
            clazz = this.mCollClass;
        }
        return clazz;
    }

    Object createRowFromDatabase(DBTransaction dBTransaction, Key key) {
        if (this.mSource == null) {
            return null;
        }
        AttributeDefImpl[] attributeDefImplArray = this.getPrimaryKeys();
        Object[] objectArray = key.getKeyValues();
        EntityImpl entityImpl = null;
        if (objectArray.length != attributeDefImplArray.length) {
            return null;
        }
        RowCreateException rowCreateException = null;
        try {
            entityImpl = this.createBlankInstance2(dBTransaction);
        }
        catch (RowCreateException rowCreateException2) {
            rowCreateException = rowCreateException2;
            entityImpl = new EntityImpl();
            entityImpl.init(dBTransaction, this);
        }
        int n = attributeDefImplArray.length - 1;
        while (n >= 0) {
            entityImpl.populateAttribute(attributeDefImplArray[n].getIndex(), objectArray[n]);
            --n;
        }
        try {
            entityImpl.populate();
        }
        catch (RowNotFoundException rowNotFoundException) {
            Object var10_10 = null;
            return var10_10;
        }
        if (rowCreateException != null) {
            return new Object[]{entityImpl, rowCreateException};
        }
        return entityImpl;
    }

    EntityImpl findFromDatabase(EntityCache entityCache, DBTransaction dBTransaction, Key key) {
        EntityImpl entityImpl;
        Object object = this.createRowFromDatabase(dBTransaction, key);
        if (object == null) {
            return null;
        }
        RowCreateException rowCreateException = null;
        if (object instanceof EntityImpl) {
            entityImpl = (EntityImpl)object;
        } else {
            entityImpl = (EntityImpl)((Object[])object)[0];
            rowCreateException = (RowCreateException)((Object[])object)[1];
        }
        AttributeDefImpl[] attributeDefImplArray = this.getDiscrColumns();
        EntityDefImpl entityDefImpl = null;
        if (attributeDefImplArray != null && attributeDefImplArray.length > 0) {
            Object[] objectArray = new Object[attributeDefImplArray.length];
            int n = 0;
            while (n < attributeDefImplArray.length) {
                objectArray[n] = entityImpl.getAttribute(attributeDefImplArray[n].getIndex());
                ++n;
            }
            entityDefImpl = (EntityDefImpl)this.findDefForDiscrValues(objectArray, true);
            if (entityDefImpl == null) {
                return null;
            }
            if (entityDefImpl != this) {
                object = entityDefImpl.createRowFromDatabase(dBTransaction, key);
                if (!(object instanceof EntityImpl)) {
                    throw (RowCreateException)((Object[])object)[1];
                }
                entityImpl = (EntityImpl)object;
                entityCache = ((DBTransactionImpl)dBTransaction).findEntityCache(entityDefImpl);
            } else if (rowCreateException != null) {
                throw rowCreateException;
            }
        }
        if (entityCache == null) {
            entityCache = ((DBTransactionImpl)dBTransaction).findEntityCache(this);
        }
        entityImpl = entityCache.add(entityImpl);
        return entityImpl;
    }

    public EntityImpl findInCacheByPKExtended(DBTransaction dBTransaction, Key key, boolean bl) {
        key = this.prepKeyForFind(key);
        return this.findFromCache(dBTransaction, key, bl);
    }

    EntityImpl findFromCache(DBTransaction dBTransaction, Key key, boolean bl) {
        ArrayList arrayList;
        EntityImpl entityImpl = ((DBTransactionImpl)dBTransaction).findEntityCache(this).get(key);
        if (bl && entityImpl == null && (arrayList = this.getExtendedDefObjects()) != null) {
            int n = 0;
            while (n < arrayList.size()) {
                EntityDefImpl entityDefImpl = (EntityDefImpl)arrayList.get(n);
                entityImpl = entityDefImpl.findInCacheByPKExtended(dBTransaction, key, false);
                if (entityImpl != null) break;
                ++n;
            }
        }
        return entityImpl;
    }

    public EntityImpl findInCacheByPrimaryKey(DBTransaction dBTransaction, Key key) {
        return this.findInCacheByPKExtended(dBTransaction, key, false);
    }

    public EntityImpl findByPKExtended(DBTransaction dBTransaction, Key key, boolean bl) {
        EntityImpl entityImpl = this.findFromCache(dBTransaction, key = this.prepKeyForFind(key), bl);
        if (entityImpl == null) {
            entityImpl = this.findFromDatabase(((DBTransactionImpl)dBTransaction).findEntityCache(this), dBTransaction, key);
        }
        return entityImpl;
    }

    public EntityImpl findByPrimaryKey(DBTransaction dBTransaction, Key key) {
        key = this.prepKeyForFind(key);
        EntityCache entityCache = ((DBTransactionImpl)dBTransaction).findEntityCache(this);
        EntityImpl entityImpl = entityCache.get(key);
        if (entityImpl == null) {
            entityImpl = this.findFromDatabase(entityCache, dBTransaction, key);
        }
        return entityImpl;
    }

    public Key createKey(AttributeList attributeList) {
        Key key;
        block3: {
            key = null;
            try {
                AttributeDefImpl[] attributeDefImplArray = this.getPrimaryKeys();
                Object[] objectArray = new Object[attributeDefImplArray.length];
                int n = attributeDefImplArray.length - 1;
                while (n >= 0) {
                    objectArray[n] = attributeList.getAttribute(attributeDefImplArray[n].getName());
                    --n;
                }
                key = new Key(objectArray);
            }
            catch (Exception exception) {
                if (!Diagnostic.isOn()) break block3;
                Diagnostic.println("Key not created - Error: " + exception.getMessage());
            }
        }
        return key;
    }

    public EntityImpl newInstance2(DBTransaction dBTransaction) {
        return this.newInstance(dBTransaction);
    }

    protected EntityImpl newInstance(DBTransaction dBTransaction) {
        EntityImpl entityImpl = this.createBlankInstance2(dBTransaction);
        entityImpl.initDefaults();
        return entityImpl;
    }

    public EntityImpl createInstance2(DBTransaction dBTransaction, AttributeList attributeList) {
        return this.createInstance(dBTransaction, attributeList);
    }

    protected EntityImpl createInstance(DBTransaction dBTransaction, AttributeList attributeList) {
        EntityImpl entityImpl = this.createBlankInstance2(dBTransaction);
        entityImpl.initDefaults();
        try {
            entityImpl.callCreate(attributeList);
        }
        catch (Exception exception) {
            entityImpl.removeFromValidationManager();
            entityImpl.removeFromTransactionPostManager();
            entityImpl.removeFromTransactionManager();
            if (exception instanceof JboException) {
                throw (JboException)exception;
            }
            throw new RowCreateException(true, this.getName(), exception);
        }
        return entityImpl;
    }

    public EntityImpl createBlankInstance2(DBTransaction dBTransaction) {
        return this.createBlankInstance(dBTransaction);
    }

    /*
     * Unable to fully structure code
     */
    protected EntityImpl createBlankInstance(DBTransaction var1_1) {
        block7: {
            if (!RowDef.isAbstractBaseCheck()) break block7;
            var2_2 = this.getExtendedDefObjects();
            var3_3 = this.getDiscrColumns();
            var4_4 = (EntityDefImpl)this.getBaseDefObject();
            if ((var2_2 == null || var2_2.size() <= 0) && var4_4 == null || var3_3 != null && var3_3.length != 0) break block7;
            if (var2_2 == null || var2_2.size() <= 0) ** GOTO lbl18
            v0 = EntityDefImpl.class$oracle$jbo$CSMessageBundle;
            if (v0 == null) {
                v0 = EntityDefImpl.class$oracle$jbo$CSMessageBundle = EntityDefImpl.class$("oracle.jbo.CSMessageBundle");
            }
            throw new InvalidOperException(v0, "25067", new Object[]{this.getName(), ((EntityDefImpl)var2_2.get(0)).getName()});
lbl-1000:
            // 1 sources

            {
                var5_5 = ((DBTransactionImpl)var1_1).lookupEntityCache(var4_4);
                if (var5_5 != null && var5_5.hasRows()) {
                    v1 = EntityDefImpl.class$oracle$jbo$CSMessageBundle;
                    if (v1 == null) {
                        v1 = EntityDefImpl.class$oracle$jbo$CSMessageBundle = EntityDefImpl.class$("oracle.jbo.CSMessageBundle");
                    }
                    throw new InvalidOperException(v1, "25068", new Object[]{this.getName(), var4_4.getName()});
                }
                var4_4 = (EntityDefImpl)var4_4.getBaseDefObject();
lbl18:
                // 2 sources

                ** while (var4_4 != null)
            }
        }
        try {
            var6_6 = this.mRowClass != null ? (EntityImpl)this.mRowClass.newInstance() : new EntityImpl();
            var6_6.init(var1_1, this);
            var9_7 = var6_6;
            return var9_7;
        }
        catch (InstantiationException var7_8) {
            throw new RowCreateException(true, this.getName(), var7_8);
        }
        catch (IllegalAccessException var8_9) {
            throw new RowCreateException(true, this.getName(), var8_9);
        }
    }

    public void setRowClass(Class clazz) {
        this.mRowClass = clazz;
    }

    public void setCollClass(Class clazz) {
        this.mCollClass = clazz;
    }

    protected Class getComponentClass() {
        Class clazz = class$oracle$jbo$server$EntityReference;
        if (clazz == null) {
            clazz = class$oracle$jbo$server$EntityReference = EntityDefImpl.class$("oracle.jbo.server.EntityReference");
        }
        return clazz;
    }

    protected AttributeDefImpl[] getForeignKeyAttrs() {
        if (this.mFKeys == null) {
            AssociationDefImpl[] associationDefImplArray = this.getAssociationDefImpls();
            AssociationDefImpl associationDefImpl = null;
            if (associationDefImplArray != null) {
                int n = 0;
                while (n < associationDefImplArray.length) {
                    if (associationDefImplArray[n].hasContainer()) {
                        associationDefImpl = associationDefImplArray[n];
                        break;
                    }
                    ++n;
                }
            }
            if (associationDefImpl != null) {
                this.mFKeys = associationDefImpl.getAttributeDefImpls();
            }
        }
        return this.mFKeys;
    }

    protected AttributeDefImpl[] getPrimaryKeys() {
        return this.mPrimaryKeys;
    }

    protected AttributeDefImpl getOIDAttribute() {
        return this.mOIDAttribute;
    }

    protected AttributeDefImpl[] getRetrievedOnInsertAttributes() {
        ArrayList arrayList = new ArrayList(2);
        int n = 0;
        while (n < this.mAttrAccessors.size()) {
            AttributeDefImpl attributeDefImpl = (AttributeDefImpl)this.mAttrAccessors.get(n);
            if (attributeDefImpl.mKind == 0 && !attributeDefImpl.mPrimaryKey && attributeDefImpl.mRetrievedOnInsert) {
                arrayList.add((Object)attributeDefImpl);
            }
            ++n;
        }
        return (AttributeDefImpl[])arrayList.toArray((Object[])new AttributeDefImpl[arrayList.size()]);
    }

    protected AttributeDefImpl[] getRetrievedOnUpdateAttributes() {
        ArrayList arrayList = new ArrayList(2);
        int n = 0;
        while (n < this.mAttrAccessors.size()) {
            AttributeDefImpl attributeDefImpl = (AttributeDefImpl)this.mAttrAccessors.get(n);
            if (attributeDefImpl.mKind == 0 && !attributeDefImpl.mPrimaryKey && attributeDefImpl.mRetrievedOnUpdate) {
                arrayList.add((Object)attributeDefImpl);
            }
            ++n;
        }
        return (AttributeDefImpl[])arrayList.toArray((Object[])new AttributeDefImpl[arrayList.size()]);
    }

    protected AttributeDefImpl[] getRetrievedOnInsertPrimaryKeys() {
        ArrayList arrayList = new ArrayList(2);
        int n = 0;
        while (n < this.mPrimaryKeys.length) {
            AttributeDefImpl attributeDefImpl = this.mPrimaryKeys[n];
            if (attributeDefImpl.mKind == 0 && attributeDefImpl.mRetrievedOnInsert) {
                arrayList.add((Object)attributeDefImpl);
            }
            ++n;
        }
        return (AttributeDefImpl[])arrayList.toArray((Object[])new AttributeDefImpl[arrayList.size()]);
    }

    protected AttributeDefImpl[] getRetrievedOnUpdatePrimaryKeys() {
        ArrayList arrayList = new ArrayList(2);
        int n = 0;
        while (n < this.mPrimaryKeys.length) {
            AttributeDefImpl attributeDefImpl = this.mPrimaryKeys[n];
            if (attributeDefImpl.mKind == 0 && attributeDefImpl.mRetrievedOnUpdate) {
                arrayList.add((Object)attributeDefImpl);
            }
            ++n;
        }
        return (AttributeDefImpl[])arrayList.toArray((Object[])new AttributeDefImpl[arrayList.size()]);
    }

    public AttributeDefImpl[] getUniqueKeys() {
        ArrayList arrayList = new ArrayList(2);
        int n = 0;
        while (n < this.mAttrAccessors.size()) {
            AttributeDefImpl attributeDefImpl = (AttributeDefImpl)this.mAttrAccessors.get(n);
            if (attributeDefImpl.mUnique && attributeDefImpl.mKind == 0) {
                arrayList.add((Object)attributeDefImpl);
            }
            ++n;
        }
        return (AttributeDefImpl[])arrayList.toArray((Object[])new AttributeDefImpl[arrayList.size()]);
    }

    EntityDefImpl[] getSinks() {
        return new EntityDefImpl[]{this};
    }

    protected AttributeDefImpl getChangeIndicatorColumn() {
        return this.mChangeIndicatorColumn;
    }

    void setChangeIndicatorColumn(AttributeDefImpl attributeDefImpl) {
        this.mChangeIndicatorColumn = attributeDefImpl;
    }

    public boolean isUpdateChangedColumns() {
        return this.mUpdateChangedColumns;
    }

    public void setUpdateChangedColumns(boolean bl) {
        this.mUpdateChangedColumns = bl;
    }

    public boolean isUseGlueCode() {
        return this.mUseGlueCode;
    }

    public void setUseGlueCode(boolean bl) {
        this.mUseGlueCode = bl;
    }

    public String getSelectClause(SQLBuilder sQLBuilder) {
        StringBuffer stringBuffer = new StringBuffer(100);
        AttributeDef[] attributeDefArray = this.getAttributeDefs();
        String string = this.getSource();
        if (sQLBuilder == null) {
            BaseSQLBuilderImpl.baseBuildSelectList(stringBuffer, attributeDefArray, string);
        } else {
            sQLBuilder.buildSelectList(stringBuffer, attributeDefArray, string);
        }
        return stringBuffer.toString();
    }

    public String getQuery() {
        if (this.mQuery != null) {
            return this.mQuery;
        }
        StringBuffer stringBuffer = new StringBuffer(100);
        stringBuffer.append("SELECT ");
        stringBuffer.append(this.getSelectClause(null));
        this.mQuery = stringBuffer.append(" FROM ").append(this.getSource()).toString();
        return this.mQuery;
    }

    protected synchronized void addPropertyChangeListener(int n, PropertyChangeListener propertyChangeListener) {
        AttributeDefImpl attributeDefImpl = this.getAttributeDefImpl(n);
        if (attributeDefImpl != null) {
            attributeDefImpl.addPropertyChangeListener(propertyChangeListener);
        }
    }

    protected synchronized void addPropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        AttributeDefImpl attributeDefImpl = this.getAttributeDefImpl(string);
        if (attributeDefImpl != null) {
            attributeDefImpl.addPropertyChangeListener(propertyChangeListener);
        }
    }

    protected synchronized void removePropertyChangeListener(int n, PropertyChangeListener propertyChangeListener) {
        AttributeDefImpl attributeDefImpl = this.getAttributeDefImpl(n);
        if (attributeDefImpl != null) {
            attributeDefImpl.removePropertyChangeListener(propertyChangeListener);
        }
    }

    protected final synchronized void removePropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        AttributeDefImpl attributeDefImpl = this.getAttributeDefImpl(string);
        if (attributeDefImpl != null) {
            attributeDefImpl.removePropertyChangeListener(propertyChangeListener);
        }
    }

    protected synchronized void removeValidator(JboValidatorInterface jboValidatorInterface) {
        if (this.mValidators == null) {
            return;
        }
        this.mValidators.remove((Object)jboValidatorInterface);
    }

    public ArrayList getValidators() {
        return this.mValidators == null ? null : (ArrayList)this.mValidators.clone();
    }

    protected synchronized void addValidator(JboValidatorInterface jboValidatorInterface) {
        if (this.mValidators == null) {
            this.mValidators = new ArrayList();
        }
        this.mValidators.add((Object)jboValidatorInterface);
    }

    protected synchronized void addVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        if (this.mVetoableValidators == null) {
            this.mVetoableValidators = new ArrayList();
        }
        this.mVetoableValidators.add((Object)vetoableChangeListener);
    }

    protected synchronized void addVetoableChangeListener(int n, VetoableChangeListener vetoableChangeListener) {
        AttributeDefImpl attributeDefImpl = this.getAttributeDefImpl(n);
        if (attributeDefImpl != null) {
            attributeDefImpl.addVetoableChangeListener(vetoableChangeListener);
        }
    }

    protected synchronized void addVetoableChangeListener(String string, VetoableChangeListener vetoableChangeListener) {
        AttributeDefImpl attributeDefImpl = this.getAttributeDefImpl(string);
        if (attributeDefImpl != null) {
            attributeDefImpl.addVetoableChangeListener(vetoableChangeListener);
        }
    }

    protected synchronized void removeVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        if (this.mVetoableValidators == null) {
            return;
        }
        this.mVetoableValidators.remove((Object)vetoableChangeListener);
    }

    protected synchronized void removeVetoableChangeListener(int n, VetoableChangeListener vetoableChangeListener) {
        AttributeDefImpl attributeDefImpl = this.getAttributeDefImpl(n);
        if (attributeDefImpl != null) {
            attributeDefImpl.removeVetoableChangeListener(vetoableChangeListener);
        }
    }

    protected final synchronized void removeVetoableChangeListener(String string, VetoableChangeListener vetoableChangeListener) {
        AttributeDefImpl attributeDefImpl = this.getAttributeDefImpl(string);
        if (attributeDefImpl != null) {
            attributeDefImpl.removeVetoableChangeListener(vetoableChangeListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void validate(EntityImpl entityImpl) {
        ArrayList arrayList = null;
        ArrayList arrayList2 = null;
        int n = 0;
        int n2 = 0;
        EntityDefImpl entityDefImpl = this;
        synchronized (entityDefImpl) {
            if (this.mValidators != null) {
                arrayList2 = (ArrayList)this.mValidators.clone();
                n = arrayList2.size();
            }
            if (this.mVetoableValidators != null) {
                arrayList = (ArrayList)this.mVetoableValidators.clone();
                n2 = arrayList.size();
            }
        }
        if (n2 > 0 || n > 0) {
            if (!entityImpl.getDBTransactionImpl().isBundledExceptionMode()) {
                if (n2 > 0) {
                    PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent(entityImpl, this.getName(), entityImpl, entityImpl);
                    int n3 = 0;
                    while (n3 < n2) {
                        ((VetoableChangeListener)arrayList.get(n3)).vetoableChange(propertyChangeEvent);
                        ++n3;
                    }
                }
                if (n > 0) {
                    JboValidatorContext jboValidatorContext = new JboValidatorContext(121, entityImpl, this.getFullName(), null, entityImpl, entityImpl);
                    int n4 = 0;
                    while (n4 < n) {
                        ((JboValidatorInterface)arrayList2.get(n4)).validate(jboValidatorContext);
                        ++n4;
                    }
                }
            } else {
                ArrayList arrayList3 = null;
                if (n2 > 0) {
                    PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent(entityImpl, this.getName(), entityImpl, entityImpl);
                    int n5 = 0;
                    while (n5 < n2) {
                        try {
                            ((VetoableChangeListener)arrayList.get(n5)).vetoableChange(propertyChangeEvent);
                        }
                        catch (JboException jboException) {
                            if (arrayList3 == null) {
                                arrayList3 = new ArrayList();
                            }
                            arrayList3.add((Object)jboException);
                        }
                        ++n5;
                    }
                }
                JboValidatorContext jboValidatorContext = new JboValidatorContext(121, entityImpl, this.getFullName(), null, entityImpl, entityImpl);
                int n6 = 0;
                while (n6 < n) {
                    try {
                        ((JboValidatorInterface)arrayList2.get(n6)).validate(jboValidatorContext);
                    }
                    catch (JboException jboException) {
                        if (arrayList3 == null) {
                            arrayList3 = new ArrayList();
                        }
                        arrayList3.add((Object)jboException);
                    }
                    ++n6;
                }
                if (arrayList3 != null) {
                    Class clazz = class$oracle$jbo$CSMessageBundle;
                    if (clazz == null) {
                        clazz = class$oracle$jbo$CSMessageBundle = EntityDefImpl.class$("oracle.jbo.CSMessageBundle");
                    }
                    throw new RowValException(clazz, "27024", this.getFullName(), entityImpl.getKey(), arrayList3, true);
                }
            }
        }
    }

    void setConnectionInfo(String string) {
    }

    protected void finishedLoading() {
        if (this.mUseGlueCode) {
            if (Diagnostic.isOn()) {
                Diagnostic.println("EntityDef: " + this.getFullName() + " using glue class");
            }
            this.generateGlueClass();
        }
    }

    static EntityDefImpl loadFromXML(DefElement defElement) {
        EntityDefImpl entityDefImpl = EntityDefImpl.loadFromXML(defElement, null);
        entityDefImpl.mTempAttrVTable = null;
        entityDefImpl.createDef();
        return entityDefImpl;
    }

    protected void resolveReferences() {
        Class clazz;
        if (!this.mUseGlueCode && (clazz = this.mRowClass) != null) {
            int n = 0;
            while (n < this.mAttrAccessors.size()) {
                ((AttributeDefImpl)this.mAttrAccessors.get(n)).initAccessors(clazz);
                ++n;
            }
        }
    }

    private void generateGlueClass() {
        if (this.mRowClass != null) {
            Class clazz = class$oracle$jbo$server$EntityImpl;
            if (clazz == null) {
                clazz = class$oracle$jbo$server$EntityImpl = EntityDefImpl.class$("oracle.jbo.server.EntityImpl");
            }
            if (this.mRowClass != clazz) {
                String string = this.mRowClass.getName() + "__Glue__";
                Class clazz2 = GlueCodeGen.loadClass(string, this.mRowClass.getClassLoader());
                if (clazz2 == null) {
                    ArrayList arrayList = new ArrayList(10);
                    ArrayList arrayList2 = new ArrayList(10);
                    ArrayList arrayList3 = new ArrayList(10);
                    ArrayList arrayList4 = new ArrayList(10);
                    ArrayList arrayList5 = new ArrayList(10);
                    ArrayList arrayList6 = new ArrayList(10);
                    int n = 0;
                    while (n < this.mAttrAccessors.size()) {
                        AttributeDefImpl attributeDefImpl = (AttributeDefImpl)this.mAttrAccessors.get(n);
                        String string2 = "get" + attributeDefImpl.getName();
                        Class clazz3 = attributeDefImpl.getJavaType();
                        Class[] classArray = new Class[]{};
                        Class clazz4 = class$oracle$jbo$server$EntityImpl;
                        if (clazz4 == null) {
                            clazz4 = EntityDefImpl.class$("oracle.jbo.server.EntityImpl");
                        }
                        if (JboNameUtil.findMethod(this.mRowClass, string2, classArray, clazz4) != null) {
                            arrayList.add((Object)string2);
                            arrayList2.add((Object)new Integer(attributeDefImpl.getIndex()));
                            arrayList3.add((Object)clazz3);
                        }
                        String string3 = "set" + attributeDefImpl.getName();
                        Class[] classArray2 = new Class[]{clazz3};
                        Class clazz5 = class$oracle$jbo$server$EntityImpl;
                        if (clazz5 == null) {
                            clazz5 = EntityDefImpl.class$("oracle.jbo.server.EntityImpl");
                        }
                        if (JboNameUtil.findMethod(this.mRowClass, string3, classArray2, clazz5) != null) {
                            arrayList4.add((Object)string3);
                            arrayList5.add((Object)new Integer(attributeDefImpl.getIndex()));
                            arrayList6.add((Object)clazz3);
                        }
                        ++n;
                    }
                    Object[] objectArray = new String[arrayList.size()];
                    int[] nArray = new int[arrayList2.size()];
                    Object[] objectArray2 = new Class[arrayList3.size()];
                    Object[] objectArray3 = new String[arrayList4.size()];
                    int[] nArray2 = new int[arrayList5.size()];
                    Object[] objectArray4 = new Class[arrayList6.size()];
                    arrayList.toArray(objectArray);
                    int n2 = 0;
                    while (n2 < arrayList2.size()) {
                        nArray[n2] = (Integer)arrayList2.get(n2);
                        ++n2;
                    }
                    arrayList3.toArray(objectArray2);
                    arrayList4.toArray(objectArray3);
                    int n3 = 0;
                    while (n3 < arrayList5.size()) {
                        nArray2[n3] = (Integer)arrayList5.get(n3);
                        ++n3;
                    }
                    arrayList6.toArray(objectArray4);
                    clazz2 = GlueCodeGen.generateClass(string, this.mRowClass.getName(), "getAttrInvokeAccessor", (String[])objectArray, nArray, (Class[])objectArray2, "getAttributeInternal", "setAttrInvokeAccessor", (String[])objectArray3, nArray2, (Class[])objectArray4, "setAttributeInternal", this.mRowClass.getClassLoader());
                }
                this.mRowClass = clazz2;
            }
        }
    }

    private static EntityDefImpl loadFromXML(DefElement defElement, EntityDefImpl entityDefImpl) {
        try {
            String string;
            String string2;
            String string3;
            String string4 = defElement.readString("Name");
            String string5 = defElement.readString("DBObjectName");
            String string6 = defElement.readString("DBObjectType");
            String string7 = defElement.readString("ViewObjectBase");
            if (entityDefImpl == null) {
                String string8 = defElement.readString("DefClass");
                if (string8 != null) {
                    Class clazz = class$oracle$jbo$server$EntityDefImpl;
                    if (clazz == null) {
                        clazz = class$oracle$jbo$server$EntityDefImpl = EntityDefImpl.class$("oracle.jbo.server.EntityDefImpl");
                    }
                    entityDefImpl = (EntityDefImpl)JBOClass.findCustomClass(string8, clazz).newInstance();
                } else {
                    entityDefImpl = string5 == null && string7 != null ? new EntityDefOverRowSet() : new EntityDefImpl();
                }
            }
            if ((string3 = defElement.readString("RowClass")) != null) {
                Class clazz = entityDefImpl.getRowClass();
                Class clazz2 = class$oracle$jbo$server$EntityImpl;
                if (clazz2 == null) {
                    clazz2 = class$oracle$jbo$server$EntityImpl = EntityDefImpl.class$("oracle.jbo.server.EntityImpl");
                }
                if (clazz.equals(clazz2)) {
                    Class clazz3 = class$oracle$jbo$server$EntityImpl;
                    if (clazz3 == null) {
                        clazz3 = class$oracle$jbo$server$EntityImpl = EntityDefImpl.class$("oracle.jbo.server.EntityImpl");
                    }
                    entityDefImpl.setRowClass(JBOClass.findCustomClass(string3, clazz3));
                }
            }
            if ((string2 = defElement.readString("CollClass")) != null) {
                Class clazz = entityDefImpl.getCollClass();
                Class clazz4 = class$oracle$jbo$server$EntityCache;
                if (clazz4 == null) {
                    clazz4 = class$oracle$jbo$server$EntityCache = EntityDefImpl.class$("oracle.jbo.server.EntityCache");
                }
                if (clazz.equals(clazz4)) {
                    Class clazz5 = class$oracle$jbo$server$EntityCache;
                    if (clazz5 == null) {
                        clazz5 = class$oracle$jbo$server$EntityCache = EntityDefImpl.class$("oracle.jbo.server.EntityCache");
                    }
                    entityDefImpl.setCollClass(JBOClass.findCustomClass(string2, clazz5));
                }
            }
            if ((string = defElement.readString("Extends")) != null && string.length() > 0) {
                entityDefImpl = EntityDefImpl.loadFromXML(MetaObjectManager.loadBaseElement(string), entityDefImpl);
                EntityDefImpl entityDefImpl2 = EntityDefImpl.findDefObjectNoSub(string);
                if (string4 != null) {
                    entityDefImpl.setName(string4);
                }
                entityDefImpl.setBaseDefObject(entityDefImpl2);
            } else if (string4 != null) {
                entityDefImpl.setName(string4);
            }
            entityDefImpl.setMessageBundleClass(defElement.readClassName("MsgBundleClass"));
            boolean bl = defElement.readBoolean("UpdateChangedColumns");
            boolean bl2 = defElement.readBoolean("UseGlueCode");
            if (string5 != null) {
                entityDefImpl.setSource(string5);
                if (string6 != null) {
                    entityDefImpl.setSourceType(string6);
                }
            } else if (string7 != null) {
                ViewDefImpl viewDefImpl = ViewDefImpl.findDefObject(string7);
                ((EntityDefOverRowSet)entityDefImpl).setViewObjectBase(viewDefImpl);
            }
            String string9 = defElement.readString("EJBHomeJNDIName");
            if (string9 != null) {
                entityDefImpl.setEJBHomeJNDIName(string9);
            }
            if ((string9 = defElement.readString("EJBAppProviderURL")) != null) {
                entityDefImpl.setEJBAppProviderURL(string9);
            }
            if ((string9 = defElement.readString("AliasName")) != null) {
                entityDefImpl.setAliasName(string9);
            }
            int n = (string9 = defElement.readString("BindingStyle")) != null && string9.equals("Oracle") ? 1 : (string9 != null && string9.equals("OracleName") ? 2 : 0);
            entityDefImpl.setBindingStyle(n);
            string9 = defElement.readString("BatchThreshold");
            if (string9 != null) {
                entityDefImpl.setBatchThreshold(Integer.parseInt(string9));
            }
            entityDefImpl.setUpdateChangedColumns(bl);
            entityDefImpl.setUseGlueCode(bl2);
            entityDefImpl.setRefPKBased(defElement.readBoolean("IsRefPKBased"));
            entityDefImpl.setAssociationAccessorRetained(defElement.readBoolean("AssociationAccessorRetained"));
            entityDefImpl.loadAttributes(defElement);
            entityDefImpl.loadProperties(defElement);
            entityDefImpl.resolveDefObject();
            entityDefImpl.loadValidators(defElement, null, false);
            entityDefImpl.loadEvents(defElement);
            entityDefImpl.loadCustomDef(defElement);
            entityDefImpl.lookupEJBHome();
            entityDefImpl.loadVariables(defElement);
            EntityDefImpl entityDefImpl3 = entityDefImpl;
            return entityDefImpl3;
        }
        catch (JboException jboException) {
            throw jboException;
        }
        catch (Exception exception) {
            PersistenceException persistenceException = new PersistenceException("26000", null);
            persistenceException.addToDetails(exception);
            throw persistenceException;
        }
    }

    public void resolveDefObject() {
        AttributeDefImpl[] attributeDefImplArray = new AttributeDefImpl[this.mTempAttrVTable.size()];
        com.sun.java.util.collections.Iterator iterator = this.mTempAttrVTable.keySet().iterator();
        EntityDefImpl entityDefImpl = (EntityDefImpl)this.getBaseDefObject();
        while (iterator.hasNext()) {
            AttributeDefImpl attributeDefImpl;
            String string = (String)iterator.next();
            AttributeDefImpl attributeDefImpl2 = (AttributeDefImpl)this.mTempAttrVTable.get((Object)string);
            attributeDefImpl2.setDef(this);
            if (entityDefImpl != null && attributeDefImpl2.getBaseDefObject() == null && (attributeDefImpl = (AttributeDefImpl)entityDefImpl.lookupAttributeDef(string)) != null) {
                attributeDefImpl2.setBaseDefObject(attributeDefImpl);
            }
            attributeDefImplArray[attributeDefImpl2.getIndex()] = attributeDefImpl2;
            if (attributeDefImpl2 instanceof AssociationDefImpl) {
                this.setAssociationDefImpl(string, (AssociationDefImpl)attributeDefImpl2);
                continue;
            }
            if (attributeDefImpl2.mUpdateable == 0) continue;
            Class clazz = class$oracle$jbo$domain$BlobDomainInterface;
            if (clazz == null) {
                clazz = EntityDefImpl.class$("oracle.jbo.domain.BlobDomainInterface");
            }
            if (!clazz.isAssignableFrom(attributeDefImpl2.getJavaType()) || !attributeDefImpl2.isPersistent()) continue;
            this.addUpdateableLOBAttr(attributeDefImpl2);
        }
        this.setAttributeDefImpls(attributeDefImplArray);
        this.verifyExtendedDefObjects();
    }

    void loadEvents(DefElement defElement) {
        ArrayList arrayList = defElement.getSimilarChildrenList("PublishEvent");
        if (arrayList == null || arrayList.size() == 0) {
            return;
        }
        if (this.mPublishEvents == null) {
            this.mPublishEvents = new HashMap(arrayList.size());
        }
        int n = 0;
        while (n < arrayList.size()) {
            ArrayList arrayList2;
            int n2;
            DefElement defElement2 = (DefElement)arrayList.get(n);
            ArrayList arrayList3 = defElement2.getChildrenList("Item");
            int n3 = n2 = arrayList3 != null ? arrayList3.size() : 0;
            if (n2 > 0) {
                arrayList2 = new ArrayList(n2);
                int n4 = 0;
                while (n4 < n2) {
                    DefElement defElement3 = (DefElement)arrayList3.get(n4);
                    arrayList2.add((Object)defElement3.readString("Value"));
                    ++n4;
                }
            } else {
                arrayList2 = new ArrayList(1);
            }
            this.mPublishEvents.put((Object)defElement2.readString("Name"), (Object)arrayList2);
            ++n;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    void loadValidators(DefElement defElement, AttributeDefImpl attributeDefImpl, boolean bl) {
        ArrayList arrayList = defElement.getSimilarChildrenList("ValidationBean");
        if (arrayList == null) {
            return;
        }
        Object object = null;
        int n = 0;
        while (n < arrayList.size()) {
            block35: {
                String string;
                block40: {
                    String string2;
                    DefElement defElement2;
                    AttributeDefImpl attributeDefImpl2;
                    boolean bl2;
                    boolean bl3;
                    block28: {
                        boolean bl4;
                        block39: {
                            String string3;
                            block38: {
                                block37: {
                                    boolean bl5;
                                    block36: {
                                        block33: {
                                            block34: {
                                                block32: {
                                                    block30: {
                                                        int n2;
                                                        String string4;
                                                        block31: {
                                                            bl3 = false;
                                                            bl2 = true;
                                                            attributeDefImpl2 = attributeDefImpl;
                                                            defElement2 = (DefElement)arrayList.get(n);
                                                            string3 = defElement2.getElementName();
                                                            string = defElement2.readString("OnAttribute");
                                                            if (!(string == null || attributeDefImpl != null && string.equals(attributeDefImpl.getName()))) {
                                                                attributeDefImpl2 = this.getAttributeDefImpl(string);
                                                            }
                                                            bl4 = defElement2.readBoolean("Share");
                                                            string2 = defElement2.readString("OperandType");
                                                            bl5 = defElement2.readBoolean("Inverse");
                                                            if (!string3.equals("CompareValidationBean")) break block30;
                                                            string4 = defElement2.readString("CompareValue");
                                                            String string5 = defElement2.readString("CompareType");
                                                            n2 = JboCompareValidator.convertOperType(string5);
                                                            if (!string2.equals("LITERAL")) break block31;
                                                            object = new JboCompareValidator(bl5, n2, string4);
                                                            break block28;
                                                        }
                                                        if (string2.equals("SQL")) {
                                                            object = new JboSQLCompareValidator(bl5, n2, this, string4);
                                                            bl3 = true;
                                                            break block28;
                                                        } else if (string2.equals("JBO")) {
                                                            object = new JboVOCompareValidator(bl5, n2, this, string4);
                                                            bl3 = true;
                                                        }
                                                        break block28;
                                                    }
                                                    if (!string3.equals("RangeValidationBean")) break block32;
                                                    String string6 = defElement2.readString("MinValue");
                                                    String string7 = defElement2.readString("MaxValue");
                                                    object = new JboRangeValidator(bl5, string6, string7);
                                                    break block28;
                                                }
                                                if (!string3.equals("ListValidationBean")) break block33;
                                                if (!string2.equals("LITERAL")) break block34;
                                                Vector vector = defElement2.readStringArray("List");
                                                if (vector == null) break block35;
                                                object = new JboListValidator(bl5, vector);
                                                break block28;
                                            }
                                            if (string2.equals("SQL")) {
                                                bl3 = true;
                                                object = new JboSQLListValidator(bl5, this, defElement2.readString("ListValue"));
                                                break block28;
                                            } else if (string2.equals("JBO")) {
                                                bl3 = true;
                                                object = new JboVOListValidator(bl5, this, defElement2.readString("ListValue"));
                                            }
                                            break block28;
                                        }
                                        if (!string3.equals("LengthValidationBean")) break block36;
                                        String string8 = defElement2.readString("CompareType");
                                        int n3 = JboLengthValidator.convertOperType(string8);
                                        String string9 = defElement2.readString("DataType");
                                        int n4 = JboLengthValidator.convertDataType(string9);
                                        String string10 = defElement2.readString("CompareLength");
                                        object = new JboLengthValidator(bl5, n3, n4, string10);
                                        break block28;
                                    }
                                    if (!string3.equals("RegExpValidationBean")) break block37;
                                    String string11 = defElement2.readString("Pattern");
                                    String string12 = defElement2.readString("Flags");
                                    object = new JboRegExpValidator(bl5, string11, string12);
                                    break block28;
                                }
                                if (!string3.equals("MethodValidationBean")) break block38;
                                String string13 = defElement2.readString("MethodName");
                                object = new JboMethodValidator(string13, this.mRowClass, bl ? attributeDefImpl.mJavaType : null);
                                break block28;
                            }
                            if (string3.equals("ValidationBean")) break block39;
                            if (string3.equals("UniquePKValidationBean")) {
                                this.addUniquePKValidation();
                                string2 = defElement2.readString("ResId");
                                if (string2 != null) {
                                    this.mUniquePKValResId = string2;
                                }
                            }
                            break block35;
                        }
                        if (!bl4) {
                            bl3 = VERSION_TWO.equals(defElement2.readString("Version")) ^ true;
                        }
                        if (bl3) {
                            bl2 = false;
                            object = ValidationBeanLoader.loadValidatorBean(defElement2);
                        } else {
                            object = RulesBeanUtils.loadValidatorBean(defElement2);
                        }
                    }
                    if (bl2 && (string2 = defElement2.readString("ResId")) != null) {
                        if (object instanceof AbstractValidator) {
                            ((AbstractValidator)object).setErrorMsgId(string2);
                            ((AbstractValidator)object).setErrorMessageClass(this.getMessageBundleClass());
                        } else if (Diagnostic.isOn()) {
                            Diagnostic.println("Validation Error message unused :" + string2);
                        }
                    }
                    if (bl) {
                        if (bl3) {
                            attributeDefImpl.addVetoableChangeListener((VetoableChangeListener)object);
                        } else {
                            attributeDefImpl.addValidator((JboValidatorInterface)object);
                        }
                    } else if (bl3) {
                        this.addVetoableChangeListener((VetoableChangeListener)object);
                    } else {
                        this.addValidator((JboValidatorInterface)object);
                    }
                    if (attributeDefImpl2 == null) break block40;
                    if (object instanceof JboAbstractValidator) {
                        ((JboAbstractValidator)object).setValidatingAttribute(attributeDefImpl2);
                        break block35;
                    } else if (object instanceof JboBaseValidator) {
                        ((JboBaseValidator)object).setValidatingAttribute(attributeDefImpl2);
                    }
                    break block35;
                }
                if (string != null && (attributeDefImpl == null || !string.equals(attributeDefImpl.getName())) && object instanceof AbstractValidator) {
                    ((AbstractValidator)object).setValidatingAttributeName(string);
                }
            }
            ++n;
        }
    }

    AttributeDefImpl getSuperAttrDef(String string) {
        AttributeDefImpl attributeDefImpl = (AttributeDefImpl)this.mTempAttrVTable.get((Object)string);
        if (attributeDefImpl != null) {
            RowDef rowDef = attributeDefImpl.getDef();
            if (rowDef == this && attributeDefImpl.getIndex() >= this.mNumInheritedAttrs) {
                throw new NameClashException(131, string);
            }
            attributeDefImpl = ((EntityDefImpl)this.getBaseDefObject()).getAttributeDefImpl(string);
            if (attributeDefImpl == null) {
                Diagnostic.ASSERT(false, "Super attr from base def is null, attr: " + string + ", eDef: " + this.getName());
            }
        }
        return attributeDefImpl;
    }

    void putAttrIntoVTable(String string, AttributeDefImpl attributeDefImpl) {
        this.mTempAttrVTable.put((Object)string, (Object)attributeDefImpl);
    }

    int getNextAttrIndex() {
        return this.mTempAttrIndex++;
    }

    public AttributeDefImpl addAttribute(String string, String string2, Class clazz, boolean bl, boolean bl2, boolean bl3) {
        AttributeDefImpl attributeDefImpl = this.getSuperAttrDef(string);
        int n = attributeDefImpl != null ? attributeDefImpl.getIndex() : this.getNextAttrIndex();
        int n2 = JboTypeMap.javaTypeToSQLTypeId(clazz.getName());
        byte by = bl3 ? (byte)0 : 3;
        AttributeDefImpl attributeDefImpl2 = new AttributeDefImpl(string, string2, this, null, 2, bl, bl2, false, false, false, 0, n, n2, by, clazz, null);
        attributeDefImpl2.setBaseDefObject(attributeDefImpl);
        this.putAttrIntoVTable(string, attributeDefImpl2);
        return attributeDefImpl2;
    }

    void loadAttributes(DefElement defElement) {
        ArrayList arrayList = defElement.getSimilarChildrenList("Attribute");
        this.mNumInheritedAttrs = this.mTempAttrIndex;
        int n = 0;
        while (n < arrayList.size()) {
            this.loadAttribute((DefElement)arrayList.get(n));
            ++n;
        }
        arrayList = defElement.getSimilarChildrenList("ViewLinkAccessor");
        int n2 = 0;
        while (n2 < arrayList.size()) {
            this.loadAttribute((DefElement)arrayList.get(n2));
            ++n2;
        }
    }

    protected void loadAttribute(DefElement defElement) {
        String string = defElement.readString("Name");
        AttributeDefImpl attributeDefImpl = null;
        AttributeDefImpl attributeDefImpl2 = this.getSuperAttrDef(string);
        int n = attributeDefImpl2 != null ? attributeDefImpl2.getIndex() : this.getNextAttrIndex();
        String string2 = defElement.getNodeName();
        if (string2.equalsIgnoreCase("Attribute") || string2.equalsIgnoreCase("CMPAttribute")) {
            attributeDefImpl = AttributeDefImpl.loadFromXML(defElement, this, n);
            attributeDefImpl.loadAttributeCustomizations(defElement, attributeDefImpl2);
        } else if (string2.equalsIgnoreCase("AccessorAttribute")) {
            attributeDefImpl = AssociationDefImpl.loadFromXML(defElement, this, n);
        } else if (string2.equalsIgnoreCase("ViewLinkAccessor")) {
            attributeDefImpl = AssociationDefImpl.loadViewLinkFromXML(defElement, this, n);
        } else if (string2.equalsIgnoreCase("CustomAttribute")) {
            String string3 = defElement.readString("DefClass");
            Class clazz = class$oracle$jbo$server$AttributeDefImpl;
            if (clazz == null) {
                clazz = class$oracle$jbo$server$AttributeDefImpl = EntityDefImpl.class$("oracle.jbo.server.AttributeDefImpl");
            }
            Class clazz2 = JBOClass.findCustomClass(string3, clazz);
            attributeDefImpl = (AttributeDefImpl)JBOClass.newInstance(clazz2);
            attributeDefImpl.initFromXML(defElement, this, n);
        }
        if (attributeDefImpl != null) {
            attributeDefImpl.setBaseDefObject(attributeDefImpl2);
            this.putAttrIntoVTable(string, attributeDefImpl);
        }
    }

    public boolean isRefPKBased() {
        return this.mIsRefPKBased;
    }

    public void setRefPKBased(boolean bl) {
        this.mIsRefPKBased = bl;
    }

    public int getRefAttrIndex() {
        if (this.mRefAttrIndex == -2) {
            this.mRefAttrIndex = -1;
            int n = 0;
            while (n < this.mAttrAccessors.size()) {
                if (((AttributeDefImpl)this.mAttrAccessors.get(n)).isObjectTableRef()) {
                    this.mRefAttrIndex = n;
                    break;
                }
                ++n;
            }
        }
        return this.mRefAttrIndex;
    }

    protected boolean isRowIDPrimaryKey() {
        return this.mIsRowIDPrimaryKey;
    }

    protected boolean isOIDInPrimaryKey() {
        return this.mIsOIDInPrimaryKey;
    }

    public boolean isAssociationAccessorRetained() {
        return this.mAssociationAccessorRetained;
    }

    public void setAssociationAccessorRetained(boolean bl) {
        this.mAssociationAccessorRetained = bl;
    }

    void setDefForComponent(ComponentObjectImpl componentObjectImpl) {
    }

    void unsetDefForComponent(ComponentObjectImpl componentObjectImpl) {
    }

    static boolean isPrimaryKeys(EntityDefImpl entityDefImpl, AttributeDefImpl[] attributeDefImplArray) {
        AttributeDefImpl[] attributeDefImplArray2 = entityDefImpl.getPrimaryKeys();
        if (attributeDefImplArray2.length != attributeDefImplArray.length) {
            return false;
        }
        int n = 0;
        while (n < attributeDefImplArray2.length) {
            boolean bl = false;
            int n2 = 0;
            while (n2 < attributeDefImplArray.length) {
                if (attributeDefImplArray2[n] == attributeDefImplArray[n2]) {
                    bl = true;
                    break;
                }
                ++n2;
            }
            if (!bl) {
                return false;
            }
            ++n;
        }
        return true;
    }

    protected void addUniquePKValidation() {
        int n = 0;
        while (n < this.mPrimaryKeys.length) {
            this.mPrimaryKeys[n].addValidator(new 1JboUniqueKeyValidator(this.mPrimaryKeys[n].getIndex()));
            ++n;
        }
    }

    protected void loadCustomDef(DefElement defElement) throws PersistenceException {
    }

    protected boolean hasLOBAttrs() {
        return this.mLobAttrs != null;
    }

    ArrayList getLOBAttrs() {
        return this.mLobAttrs;
    }

    void addUpdateableLOBAttr(AttributeDefImpl attributeDefImpl) {
        if (this.mLobAttrs == null) {
            this.mLobAttrs = new ArrayList();
        }
        this.mLobAttrs.add((Object)attributeDefImpl);
    }

    public static int getMaxAttrConst(String string) {
        EntityDefImpl entityDefImpl;
        if (string != null && (entityDefImpl = EntityDefImpl.findDefObjectNoSub(string)) != null) {
            return entityDefImpl.mAttrAccessors.size();
        }
        return 0;
    }

    AttributeDefImpl[] getPersistableAttributeDefImpls() {
        if (this.mPersistableAttrs == null) {
            int n = this.mAttrAccessors.size();
            ArrayList arrayList = new ArrayList(n);
            int n2 = 0;
            while (n2 < n) {
                AttributeDefImpl attributeDefImpl = (AttributeDefImpl)this.mAttrAccessors.get(n2);
                if (attributeDefImpl.mKind == 0 && !attributeDefImpl.mObjectTableRef && attributeDefImpl.mColumnName != EntityImpl.ORACLE_ROWID_COLUMN) {
                    arrayList.add((Object)attributeDefImpl);
                }
                ++n2;
            }
            this.mPersistableAttrs = (AttributeDefImpl[])arrayList.toArray((Object[])new AttributeDefImpl[arrayList.size()]);
        }
        return this.mPersistableAttrs;
    }

    AttributeDefImpl[] getHistoryAttributeDefImpls() {
        if (this.mHistoryAttrs == null) {
            int n = this.mAttrAccessors.size();
            ArrayList arrayList = new ArrayList(4);
            int n2 = 0;
            while (n2 < n) {
                AttributeDefImpl attributeDefImpl = (AttributeDefImpl)this.mAttrAccessors.get(n2);
                if (attributeDefImpl.isHistoryColumn()) {
                    arrayList.add((Object)attributeDefImpl);
                }
                ++n2;
            }
            this.mHistoryAttrs = (AttributeDefImpl[])arrayList.toArray((Object[])new AttributeDefImpl[arrayList.size()]);
        }
        return this.mHistoryAttrs;
    }

    boolean hasHistory() {
        AttributeDefImpl[] attributeDefImplArray = this.getHistoryAttributeDefImpls();
        return attributeDefImplArray != null && attributeDefImplArray.length != 0;
    }

    public static boolean checkEntityLocked(Row row) {
        EntityImpl entityImpl;
        return row == null || (entityImpl = (EntityImpl)row).getPostState() == 0 || entityImpl.isLocked();
    }

    void lookupEJBHome() {
        if (this.mEJBHomeJNDIName != null) {
            try {
                this.mEJBHome = new InitialContext().lookup("java:comp/env/ejb/" + this.mEJBHomeJNDIName);
            }
            catch (NamingException namingException) {
                throw new JboException(namingException);
            }
        }
    }

    public Object getEJBHome() {
        return this.mEJBHome;
    }

    public boolean isSingleUseKeyStatement() {
        return this.mSingleUseKeyStmt;
    }

    public void setSingleUseKeyStatement(boolean bl) {
        this.mSingleUseKeyStmt = bl;
    }

    protected void setUseReturningClause(boolean bl) {
        this.mUseReturningClause = bl;
    }

    public boolean isUseReturningClause() {
        return this.mUseReturningClause;
    }

    Key prepKeyForFind(Key key) {
        AttributeDefImpl[] attributeDefImplArray = this.getPrimaryKeys();
        Object[] objectArray = null;
        int n = key.getAttributeCount();
        if (attributeDefImplArray != null) {
            int n2 = 0;
            while (n2 < attributeDefImplArray.length && n2 < n) {
                AttributeDefImpl attributeDefImpl;
                Class clazz;
                Object object = key.getAttribute(n2);
                if (object != null && !(object instanceof NullValue) && !(clazz = (attributeDefImpl = attributeDefImplArray[n2]).getJavaType()).isInstance(object)) {
                    if (objectArray == null) {
                        objectArray = new Object[n];
                    }
                    object = attributeDefImpl.convertToJava(object);
                }
                if (objectArray != null) {
                    objectArray[n2] = object;
                }
                ++n2;
            }
        }
        return objectArray != null ? new Key(objectArray, key.getSignature(), key.getRowHandle()) : key;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public class 1WrapIterator
    implements Iterator {
        com.sun.java.util.collections.Iterator mIter;

        1WrapIterator(com.sun.java.util.collections.Iterator iterator) {
            this.mIter = iterator;
        }

        public boolean hasNext() {
            return this.mIter.hasNext();
        }

        public Object next() {
            return this.mIter.next();
        }

        public void remove() {
            this.mIter.remove();
        }
    }

    public class 1JboUniqueKeyValidator
    extends AbstractValidator
    implements JboValidatorInterface {
        protected transient Object mSource;
        protected transient int mIndex;
        protected transient int mKeySize;
        private static /* synthetic */ Class class$oracle$jbo$CSMessageBundle;

        private /* synthetic */ void $init$() {
            this.mKeySize = 0;
        }

        public 1JboUniqueKeyValidator(int n) {
            this.$init$();
            this.mIndex = n;
        }

        public void validate(JboValidatorContext jboValidatorContext) {
            this.mSource = jboValidatorContext.getSource();
            this.validateValue(jboValidatorContext.getNewValue());
        }

        Key getNewKey(Entity entity, Object object) {
            Key key = entity.getPrimaryKey();
            Object[] objectArray = null;
            byte by = entity.getPostState();
            if (key != null) {
                objectArray = key.getKeyValues();
                if (this.mKeySize == 0) {
                    this.mKeySize = objectArray.length;
                }
            } else if (by == 0 || by == -1) {
                this.mKeySize = EntityDefImpl.this.mPrimaryKeys.length;
                objectArray = new Object[this.mKeySize];
            } else {
                return null;
            }
            int n = 0;
            while (n < this.mKeySize) {
                if (EntityDefImpl.this.mPrimaryKeys[n].getIndex() == this.mIndex) {
                    objectArray[n] = object;
                    break;
                }
                ++n;
            }
            return new Key(objectArray);
        }

        public String getErrorMsgId() {
            return EntityDefImpl.this.mUniquePKValResId != null ? EntityDefImpl.this.mUniquePKValResId : "25013";
        }

        public Class getErrorMessageClass() {
            Class clazz;
            if (EntityDefImpl.this.mUniquePKValResId != null) {
                clazz = EntityDefImpl.this.getMessageBundleClass();
            } else {
                clazz = class$oracle$jbo$CSMessageBundle;
                if (clazz == null) {
                    clazz = class$oracle$jbo$CSMessageBundle = 1JboUniqueKeyValidator.class$("oracle.jbo.CSMessageBundle");
                }
            }
            return clazz;
        }

        public boolean validateValue(Object object) {
            EntityImpl entityImpl;
            Key key;
            EntityImpl entityImpl2 = (EntityImpl)this.mSource;
            if (!(entityImpl2.mOrigData.isPopulated(this.mIndex) && object.equals(entityImpl2.mOrigData.get(this.mIndex)) || (key = this.getNewKey(entityImpl2, object)) == null || (entityImpl = entityImpl2.getEntityDef().findByPrimaryKey(entityImpl2.getDBTransaction(), key)) == null || entityImpl == entityImpl2 || entityImpl.getPostState() == 3 || entityImpl.getPostState() == 4)) {
                if (EntityDefImpl.this.mUniquePKValResId == null) {
                    throw new TooManyObjectsException(entityImpl2.getEntityDef().getFullName(), key);
                }
                RulesBeanUtils.raiseException(this.getErrorMessageClass(), this.getErrorMsgId(), this, 121, EntityDefImpl.this.getFullName(), null, entityImpl2, null, new TooManyObjectsException(entityImpl2.getEntityDef().getFullName(), key));
            }
            return true;
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
    }
}

