/*
 * Decompiled with CFR 0.152.
 */
package oracle.jbo.server;

import com.sun.java.util.collections.ArrayList;
import com.sun.java.util.collections.Collection;
import com.sun.java.util.collections.Collections;
import com.sun.java.util.collections.HashMap;
import com.sun.java.util.collections.Iterator;
import com.sun.java.util.collections.List;
import java.io.PrintWriter;
import java.io.Writer;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Enumeration;
import java.util.EventObject;
import java.util.Hashtable;
import java.util.Properties;
import java.util.TimeZone;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import oracle.jbo.AfterCommitException;
import oracle.jbo.AfterPostException;
import oracle.jbo.AfterRollbackException;
import oracle.jbo.AlreadyConnectedException;
import oracle.jbo.ApplicationModule;
import oracle.jbo.AttributeDef;
import oracle.jbo.AttributeList;
import oracle.jbo.BatchDMLException;
import oracle.jbo.ConnectionMetadata;
import oracle.jbo.DMLException;
import oracle.jbo.InvalidObjAccessException;
import oracle.jbo.InvalidObjNameException;
import oracle.jbo.InvalidOperException;
import oracle.jbo.InvalidParamException;
import oracle.jbo.JboException;
import oracle.jbo.JboWarning;
import oracle.jbo.Key;
import oracle.jbo.LocaleContext;
import oracle.jbo.NotConnectedException;
import oracle.jbo.Row;
import oracle.jbo.SQLStmtException;
import oracle.jbo.Session;
import oracle.jbo.TransactionStateEvent;
import oracle.jbo.TransactionStateListener;
import oracle.jbo.TxnValException;
import oracle.jbo.ValidationException;
import oracle.jbo.ViewClearCacheEvent;
import oracle.jbo.ViewClearCacheListener;
import oracle.jbo.ViewLink;
import oracle.jbo.ViewObject;
import oracle.jbo.common.Diagnostic;
import oracle.jbo.common.EventGroup;
import oracle.jbo.common.InstrumentedEvent;
import oracle.jbo.common.JBOClass;
import oracle.jbo.common.JboEnvUtil;
import oracle.jbo.common.MOMProperties;
import oracle.jbo.common.PropertyMetadata;
import oracle.jbo.common.StringManager;
import oracle.jbo.domain.DataCreationException;
import oracle.jbo.mom.LongRunningStatementHandle;
import oracle.jbo.pcoll.PCollManager;
import oracle.jbo.pcoll.PCollManagerHelper;
import oracle.jbo.server.ApplicationModuleImpl;
import oracle.jbo.server.ConnectionCredentials;
import oracle.jbo.server.ConnectionPoolManager;
import oracle.jbo.server.ConnectionPoolManagerFactory;
import oracle.jbo.server.DBTransaction;
import oracle.jbo.server.DOMSerializer;
import oracle.jbo.server.DatabaseTransactionFactory;
import oracle.jbo.server.Entity;
import oracle.jbo.server.EntityCache;
import oracle.jbo.server.EntityClearCacheEvent;
import oracle.jbo.server.EntityDefImpl;
import oracle.jbo.server.EntityEvent;
import oracle.jbo.server.EntityImpl;
import oracle.jbo.server.JDBCInteract;
import oracle.jbo.server.JTATransactionHandler;
import oracle.jbo.server.MetaObjectManager;
import oracle.jbo.server.QueryCollection;
import oracle.jbo.server.QueryDump;
import oracle.jbo.server.SQLBuilder;
import oracle.jbo.server.SQLBuilderFactory;
import oracle.jbo.server.SessionImpl;
import oracle.jbo.server.TransactionEvent;
import oracle.jbo.server.TransactionHandler;
import oracle.jbo.server.TransactionHandlerFactory;
import oracle.jbo.server.TransactionListener;
import oracle.jbo.server.TransactionPostListener;
import oracle.jbo.server.ValidationListener;
import oracle.jbo.server.ViewObjectImpl;
import oracle.sql.REF;
import oracle.sql.StructDescriptor;
import oracle.xml.parser.v2.XMLDocument;

public class DBTransactionImpl
implements PCollManagerHelper,
DBTransaction {
    public static final int MAX_CURSORS_UNINITIALIZED = -1;
    static final String MTH_executeCommand = "DBTransactionImpl.executeCommand";
    static final String MTH_dumpQueryResult = "DBTransactionImpl.dumpQueryResult";
    static final String SQLSTATE_72000 = "72000";
    static final int ERRORCODE_17002 = 17002;
    private static final String JDBC_URL_PREFIX = "jdbc:";
    private static int mDefaultMaxCursors = -1;
    static final int STATE_CLOSING = 0;
    static final int STATE_ACTIVE = 1;
    static final int STATE_CLOSED = 2;
    static final int STATE_INTRANSACTION = 4;
    static final int STATE_ENDTRANSACTION = 5;
    protected SQLBuilder mSQLBuilder;
    private Connection mjdbcConnection;
    private ConnectionMetadata mjdbcConnectionMetadata;
    private String mConnectionPoolKey;
    private String mInternalConnectionPoolKey;
    protected ConnectionCredentials mConnectionCredentials;
    protected ConnectionCredentials mInternalCredentials;
    private HashMap mRowCache;
    private boolean mIsDirty;
    ArrayList mTransListeners;
    private int mNumTransientTransListeners;
    private int mTransPostHdl;
    ArrayList mTransPostListeners;
    private HashMap mTransPostListenerHash;
    private int mLockingMode;
    HashMap mValidationListeners;
    private boolean mApplyValidationThreshold;
    private int mValidationThreshold;
    private int mPostThreshold;
    private int mBatchPostThreshold;
    private int mMaxCursors;
    private ArrayList mSingleUseStmts;
    private ArrayList mMultiUseStmts;
    private Object mCallback;
    private boolean mIsProcPendingEvents;
    private boolean mIsShared;
    private TransactionHandler mTxnHandler;
    private PCollManager mPCollMgr;
    private int mClearCacheOnCommit;
    private int mClearCacheOnRollback;
    private boolean mPCollUsePMgr;
    private int mTransactionState;
    private ArrayList mBatchStmtOwners;
    int mBindVarNum;
    boolean mUseCallableStmt;
    boolean mDeferValidation;
    private boolean mIsConnected;
    private long mDbTimeDelta;
    private boolean mInitDbTime;
    private boolean mTrackNewAndModified;
    protected ArrayList mTxnListeners;
    private Object mTxnStateListeners;
    private Object mViewClearCacheListeners;
    private ArrayList mTmpTxnPostListeners;
    private XMLDocument mTmpTxnSnapshot;
    private boolean mTmpSavepointExists;
    private boolean mTmpPostStateSaved;
    public static int POST_ALL_NO_RESET_ON_EXCEPTION = 2;
    public static int POST_ALL_RESET_ON_EXCEPTION = 1;
    public static int POST_ABORT_ON_FIRST_EXCEPTION = 0;
    private int mPostAll;
    protected int mDMLOperationTimeOut;
    protected List mLongRunningDMLOperationHandles;
    private static /* synthetic */ Class class$oracle$sql$REF;
    private static /* synthetic */ Class class$oracle$jbo$CSMessageBundle;

    private /* synthetic */ void $init$() {
        this.mSQLBuilder = SQLBuilderFactory.create();
        this.mjdbcConnection = null;
        this.mjdbcConnectionMetadata = null;
        this.mConnectionPoolKey = null;
        this.mInternalConnectionPoolKey = null;
        this.mConnectionCredentials = new ConnectionCredentials();
        this.mInternalCredentials = null;
        this.mRowCache = new HashMap();
        this.mIsDirty = false;
        this.mTransListeners = new ArrayList(20);
        this.mNumTransientTransListeners = 0;
        this.mTransPostHdl = 0;
        this.mTransPostListeners = new ArrayList(20);
        this.mTransPostListenerHash = new HashMap(20);
        this.mLockingMode = 1;
        this.mValidationListeners = new HashMap();
        this.mApplyValidationThreshold = false;
        this.mValidationThreshold = 10;
        this.mPostThreshold = 10;
        this.mBatchPostThreshold = 0;
        this.mSingleUseStmts = new ArrayList(10);
        this.mMultiUseStmts = new ArrayList(10);
        this.mCallback = null;
        this.mIsProcPendingEvents = false;
        this.mIsShared = false;
        this.mTxnHandler = null;
        this.mPCollMgr = null;
        this.mClearCacheOnCommit = -1;
        this.mClearCacheOnRollback = -1;
        this.mPCollUsePMgr = true;
        this.mTransactionState = 2;
        this.mBatchStmtOwners = null;
        this.mBindVarNum = 1;
        this.mUseCallableStmt = false;
        this.mDeferValidation = false;
        this.mIsConnected = false;
        this.mDbTimeDelta = 0L;
        this.mInitDbTime = false;
        this.mTrackNewAndModified = false;
        this.mTxnListeners = null;
        this.mTxnStateListeners = null;
        this.mViewClearCacheListeners = null;
        this.mTmpTxnPostListeners = null;
        this.mTmpTxnSnapshot = null;
        this.mTmpSavepointExists = false;
        this.mTmpPostStateSaved = false;
        this.mPostAll = POST_ABORT_ON_FIRST_EXCEPTION;
        this.mDMLOperationTimeOut = -1;
        this.mLongRunningDMLOperationHandles = Collections.synchronizedList((List)new ArrayList());
    }

    DBTransactionImpl() {
        this.$init$();
    }

    public DBTransactionImpl(DataSource dataSource) {
        this.$init$();
        this.mConnectionCredentials.mDataSource = dataSource;
    }

    public DBTransactionImpl(DataSource dataSource, String string, String string2) {
        this.$init$();
        this.mConnectionCredentials.mDataSource = dataSource;
        this.mConnectionCredentials.mjdbcUser = string;
        this.mConnectionCredentials.mjdbcPassword = string2;
    }

    public DBTransactionImpl(Connection connection) {
        this.$init$();
        this.mjdbcConnection = connection;
        this.mIsConnected = true;
        this.refreshConnectionMetadata();
    }

    public DBTransactionImpl(String string) {
        this.$init$();
        this.mConnectionCredentials.mjdbcURL = string;
    }

    public DBTransactionImpl(String string, Properties properties) {
        this.$init$();
        this.mConnectionCredentials.mjdbcURL = string;
        this.mConnectionCredentials.mjdbcInfo = properties;
    }

    public DBTransactionImpl(String string, String string2, String string3) {
        this.$init$();
        this.mConnectionCredentials.mjdbcURL = string;
        this.mConnectionCredentials.mjdbcUser = string2;
        this.mConnectionCredentials.mjdbcPassword = string3;
    }

    public DBTransactionImpl(String string, String string2, String string3, Properties properties) {
        this.$init$();
        this.mConnectionCredentials.mjdbcURL = string;
        this.mConnectionCredentials.mjdbcUser = string2;
        this.mConnectionCredentials.mjdbcPassword = string3;
        this.mConnectionCredentials.mjdbcInfo = properties;
    }

    public final Object getSyncLock() {
        ApplicationModuleImpl applicationModuleImpl = this.getTxnApplicationModuleImpl();
        if (applicationModuleImpl == null) {
            throw new InvalidObjAccessException(172, this.getClass().getName());
        }
        return this.getTxnApplicationModuleImpl().getSyncLock();
    }

    private Hashtable getEnvironment() {
        ApplicationModuleImpl applicationModuleImpl = this.getTxnApplicationModuleImpl();
        if (applicationModuleImpl != null) {
            return applicationModuleImpl.getSession().getEnvironment();
        }
        return null;
    }

    int getNextBindVarNum() {
        return this.mBindVarNum++;
    }

    String getConnProperty(String string, PropertyMetadata propertyMetadata) {
        Properties properties = this.mConnectionCredentials.mjdbcInfo;
        String string2 = null;
        if (properties != null && (string2 = properties.getProperty(string)) != null) {
            properties.remove(string);
        }
        if (string2 == null) {
            Hashtable hashtable = this.getSession().getEnvironment();
            string2 = (String)hashtable.get(string);
        }
        if (string2 == null) {
            string2 = propertyMetadata.getProperty();
        }
        return string2;
    }

    private void processConnProperties() {
        int n;
        String string = "jbo.use.pers.coll";
        String string2 = this.getConnProperty(string, PropertyMetadata.ENV_USE_PERS_COLL);
        if (string2 != null && string2.equals("false")) {
            this.mPCollUsePMgr = false;
        }
        if ((string2 = this.getConnProperty(string = "jbo.pers.max.rows.per.node", PropertyMetadata.ENV_PERS_MAX_ROWS_PER_NODE)) != null && string2.length() > 0) {
            n = new Integer(string2);
            if (n < 5) {
                if (Diagnostic.isOn()) {
                    Diagnostic.println("Specified " + string + " " + n + " too small.  Defaulting to minimum of " + 5);
                }
                n = 5;
            }
            ViewObjectImpl.mDefaultMaxRowsPerNode = n;
        }
        if ((string2 = this.getConnProperty(string = "jbo.pers.max.active.nodes", PropertyMetadata.ENV_PERS_MAX_ACTIVE_NODES)) != null && string2.length() > 0) {
            n = new Integer(string2);
            if (n != -1 && n < 2) {
                if (Diagnostic.isOn()) {
                    Diagnostic.println("Specified " + string + " " + n + " too small.  Defaulting to minimum of " + 2);
                }
                n = 2;
            }
            ViewObjectImpl.mDefaultMaxActiveNodes = n;
        }
        if (Diagnostic.isOn()) {
            Diagnostic.println("mPCollUsePMgr is " + this.mPCollUsePMgr);
            Diagnostic.println("ViewObjectImpl.mDefaultMaxRowsPerNode is " + ViewObjectImpl.mDefaultMaxRowsPerNode);
            Diagnostic.println("ViewObjectImpl.mDefaultMaxActiveNodes is " + ViewObjectImpl.mDefaultMaxActiveNodes);
        }
    }

    public static String diagCleanURL(String string) {
        if (string == null) {
            return "null";
        }
        int n = string.indexOf(47);
        int n2 = string.indexOf(64);
        String string2 = string;
        if (n >= 0 && n2 < 0) {
            string2 = string.substring(0, n + 1) + "*****";
        } else if (n >= 0 && n2 > n) {
            string2 = string.substring(0, n + 1) + "*****" + string.substring(n2);
        }
        return string2;
    }

    Connection establishNewConnection(ConnectionCredentials connectionCredentials, StringBuffer stringBuffer) {
        if (connectionCredentials.mDataSource == null) {
            try {
                this.mSQLBuilder.doRegisterDefaultDriver(connectionCredentials.mjdbcURL);
            }
            catch (Exception exception) {
                Class clazz;
                if (Diagnostic.isOn()) {
                    Diagnostic.println("Error in DriverManager.registerDriver");
                    Diagnostic.printStackTrace(exception);
                }
                if ((clazz = class$oracle$jbo$CSMessageBundle) == null) {
                    clazz = class$oracle$jbo$CSMessageBundle = DBTransactionImpl.class$("oracle.jbo.CSMessageBundle");
                }
                throw new DMLException(clazz, "26060", null, exception);
            }
        }
        int n = 0;
        if (InstrumentedEvent.isActive) {
            n = InstrumentedEvent.startEvent(EventGroup.JDBC_CONNECT);
        }
        Connection connection = null;
        try {
            if (connectionCredentials.mDataSource != null) {
                if (Diagnostic.isOn()) {
                    DBTransactionImpl.diagnose(n, "Trying connection: DataSource='" + connectionCredentials.mDataSource + "'...");
                }
                connection = connectionCredentials.mjdbcUser != null ? connectionCredentials.mDataSource.getConnection(connectionCredentials.mjdbcUser, connectionCredentials.mjdbcPassword) : connectionCredentials.mDataSource.getConnection();
            }
            String string = null;
            if (connectionCredentials.mDataSource == null && connectionCredentials.mjdbcURL != null && connectionCredentials.mjdbcInfo == null && connectionCredentials.mjdbcUser == null && connectionCredentials.mjdbcPassword == null) {
                ConnectionPoolManager connectionPoolManager = ConnectionPoolManagerFactory.getConnectionPoolManager(MOMProperties.getProperties());
                if (connectionPoolManager.getMaxPoolSize() > 0) {
                    string = connectionPoolManager.generatePoolKey(connectionCredentials.mjdbcURL, null);
                    connection = connectionCredentials.mDefinesInternalConnection ? connectionPoolManager.getConnectionForInternalUse(string, connectionCredentials.mjdbcURL, null, null, null) : connectionPoolManager.getConnection(string, connectionCredentials.mjdbcURL, null, null, null);
                } else {
                    if (Diagnostic.isOn()) {
                        DBTransactionImpl.diagnose(n, "Trying connection/1: url='" + connectionCredentials.mjdbcURL + "'...");
                    }
                    connection = DriverManager.getConnection(connectionCredentials.mjdbcURL);
                }
                if (JDBCInteract.mDoTrace) {
                    JDBCInteract.connect(connectionCredentials.mjdbcURL);
                }
            }
            if (connectionCredentials.mDataSource == null && connectionCredentials.mjdbcURL != null && connectionCredentials.mjdbcInfo != null && connectionCredentials.mjdbcUser == null && connectionCredentials.mjdbcPassword == null) {
                ConnectionPoolManager connectionPoolManager = ConnectionPoolManagerFactory.getConnectionPoolManager(MOMProperties.getProperties());
                if (connectionPoolManager.getMaxPoolSize() > 0) {
                    this.getSQLBuilder().jdbcClientSideSecurity(connectionCredentials.mjdbcInfo, this.getSession().getEnvironment());
                    string = connectionPoolManager.generatePoolKey(connectionCredentials.mjdbcURL, connectionCredentials.mjdbcInfo);
                    connection = connectionCredentials.mDefinesInternalConnection ? connectionPoolManager.getConnectionForInternalUse(string, connectionCredentials.mjdbcURL, connectionCredentials.mjdbcInfo, null, null) : connectionPoolManager.getConnection(string, connectionCredentials.mjdbcURL, connectionCredentials.mjdbcInfo, null, null);
                } else {
                    if (Diagnostic.isOn()) {
                        DBTransactionImpl.diagnose(n, "Trying connection/2: url='" + connectionCredentials.mjdbcURL + "' ...");
                    }
                    connection = DriverManager.getConnection(connectionCredentials.mjdbcURL, connectionCredentials.mjdbcInfo);
                }
                if (JDBCInteract.mDoTrace) {
                    JDBCInteract.connect(connectionCredentials.mjdbcURL, connectionCredentials.mjdbcInfo);
                }
            }
            if (connectionCredentials.mDataSource == null && connectionCredentials.mjdbcURL != null && connectionCredentials.mjdbcInfo == null && connectionCredentials.mjdbcUser != null && connectionCredentials.mjdbcPassword != null) {
                ConnectionPoolManager connectionPoolManager = ConnectionPoolManagerFactory.getConnectionPoolManager(MOMProperties.getProperties());
                if (connectionPoolManager.getMaxPoolSize() > 0) {
                    string = connectionPoolManager.generatePoolKey(connectionCredentials.mjdbcURL, connectionCredentials.mjdbcUser, connectionCredentials.mjdbcPassword);
                    connection = connectionCredentials.mDefinesInternalConnection ? connectionPoolManager.getConnectionForInternalUse(string, connectionCredentials.mjdbcURL, null, connectionCredentials.mjdbcUser, connectionCredentials.mjdbcPassword) : connectionPoolManager.getConnection(string, connectionCredentials.mjdbcURL, null, connectionCredentials.mjdbcUser, connectionCredentials.mjdbcPassword);
                } else {
                    if (Diagnostic.isOn()) {
                        DBTransactionImpl.diagnose(n, "Trying connection/3: url='" + connectionCredentials.mjdbcURL + "' user='" + connectionCredentials.mjdbcUser + "' password='*****' ...");
                    }
                    connection = DriverManager.getConnection(connectionCredentials.mjdbcURL, connectionCredentials.mjdbcUser, connectionCredentials.mjdbcPassword);
                }
                if (JDBCInteract.mDoTrace) {
                    JDBCInteract.connect(connectionCredentials.mjdbcURL, connectionCredentials.mjdbcUser, "*****");
                }
            }
            stringBuffer.append(string);
        }
        catch (SQLException sQLException) {
            Class clazz;
            if (Diagnostic.isOn() || InstrumentedEvent.isActive) {
                DBTransactionImpl.diagnose(n, "DBTransactionImpl.initTransaction: Login failed");
            }
            if (Diagnostic.isOn()) {
                Diagnostic.printStackTrace(sQLException);
            }
            if ((clazz = class$oracle$jbo$CSMessageBundle) == null) {
                clazz = class$oracle$jbo$CSMessageBundle = DBTransactionImpl.class$("oracle.jbo.CSMessageBundle");
            }
            throw new DMLException(clazz, "26061", null, sQLException);
        }
        if (InstrumentedEvent.isActive) {
            InstrumentedEvent.endEvent(n);
        }
        return connection;
    }

    private static void diagnose(int n, String string) {
        if (Diagnostic.isOn()) {
            Diagnostic.println(string);
        }
        if (InstrumentedEvent.isActive) {
            InstrumentedEvent.addComment(n, string);
        }
    }

    String getPersistManagerClassName() {
        String string = this.getConnProperty("jbo.pcoll.mgr", PropertyMetadata.ENV_PCOLL_MGR);
        if (string == null) {
            if (this.mSQLBuilder != null) {
                string = this.mSQLBuilder.getPersistManagerClassName();
            }
            if (string == null) {
                string = "oracle.jbo.pcoll.OraclePersistManager";
            }
        }
        return string;
    }

    void processProperties() {
        int n;
        this.processConnProperties();
        if (mDefaultMaxCursors == -1) {
            String string = JboEnvUtil.getProperty("jbo.max.cursors");
            if (string == null) {
                mDefaultMaxCursors = new Integer("50");
            } else {
                Integer n2 = new Integer(string);
                mDefaultMaxCursors = n2;
            }
            if (Diagnostic.isOn()) {
                Diagnostic.println("DBTransactionImpl Max Cursors is " + mDefaultMaxCursors);
            }
        }
        this.mMaxCursors = mDefaultMaxCursors;
        String string = JboEnvUtil.getProperty("jbo.locking.mode");
        if (string.equalsIgnoreCase("pessimistic")) {
            n = 1;
        } else if (string.equalsIgnoreCase("optimistic")) {
            n = 2;
        } else if (string.equalsIgnoreCase("optupdate")) {
            n = 3;
        } else if (string.equalsIgnoreCase("none")) {
            n = 0;
        } else {
            Diagnostic.println("WARNING: bad lockingmode specified: " + string + " (using NONE)");
            n = 0;
        }
        if (n != this.mLockingMode) {
            this.setLockingMode(n);
            Diagnostic.println("Default locking mode changed to: " + string);
        }
    }

    public boolean isLockOptimistic() {
        return this.mLockingMode == 2 || this.mLockingMode == 3;
    }

    void initPCollManager() {
        String string;
        ApplicationModuleImpl applicationModuleImpl = this.getTxnApplicationModuleImpl();
        String string2 = string = applicationModuleImpl == null ? null : applicationModuleImpl.getName();
        if (this.mPCollMgr == null) {
            String string3 = !this.mPCollUsePMgr ? "None" : this.getPersistManagerClassName();
            this.mPCollMgr = new PCollManager((PCollManagerHelper)this, string, string3);
        } else if (!this.mPCollMgr.isOpen()) {
            this.mPCollMgr.reopen(string);
        }
    }

    void initTransaction() {
        if (this.mjdbcConnection == null) {
            StringBuffer stringBuffer = new StringBuffer();
            boolean bl = true;
            Connection connection = this.establishNewConnection(this.mConnectionCredentials, stringBuffer);
            this.mConnectionPoolKey = stringBuffer.toString();
            try {
                this.getTransactionHandler().handleOpen(connection);
            }
            catch (RuntimeException runtimeException) {
                this.closeConnectionInternal(connection, true);
                throw runtimeException;
            }
            this.mIsConnected = true;
            this.mjdbcConnection = connection;
            this.refreshConnectionMetadata();
            if (this.mjdbcConnection != null) {
                if (Diagnostic.isOn()) {
                    Diagnostic.println("Successfully logged in");
                }
                this.mConnectionCredentials.mCredentialsOK = true;
            } else {
                Diagnostic.ASSERT(false, "Unexpected error.  Connection should have been established");
            }
        }
        if (this.mjdbcConnection != null) {
            try {
                DatabaseMetaData databaseMetaData = this.mjdbcConnection.getMetaData();
                if (Diagnostic.isOn()) {
                    Diagnostic.println("JDBCDriverVersion: " + databaseMetaData.getDriverVersion());
                    Diagnostic.println("DatabaseProductName: " + databaseMetaData.getDatabaseProductName());
                }
                String string = databaseMetaData.getDatabaseProductVersion();
                if (Diagnostic.isOn()) {
                    Diagnostic.println("DatabaseProductVersion: " + string.replace('\n', ' '));
                }
            }
            catch (SQLException sQLException) {
                Class clazz;
                if (Diagnostic.isOn()) {
                    Diagnostic.println("DBTransactionImpl.initTransaction: Initial connection problems");
                    Diagnostic.printStackTrace(sQLException);
                }
                if ((clazz = class$oracle$jbo$CSMessageBundle) == null) {
                    clazz = class$oracle$jbo$CSMessageBundle = DBTransactionImpl.class$("oracle.jbo.CSMessageBundle");
                }
                throw new DMLException(clazz, "26061", null, sQLException);
            }
        }
    }

    String getDatabaseProductName() {
        if (this.mjdbcConnection == null) {
            throw new IllegalStateException();
        }
        try {
            String string = this.mjdbcConnection.getMetaData().getDatabaseProductName();
            int n = string.indexOf(47);
            if (n >= 0) {
                string = string.substring(0, n);
            }
            String string2 = string;
            return string2;
        }
        catch (SQLException sQLException) {
            throw new JboException(sQLException);
        }
    }

    PCollManager getPCollManager() {
        return this.mPCollMgr;
    }

    void releaseInternalConnection(Connection connection, boolean bl) {
        if (connection != null && (bl || this.mPCollMgr == null || this.mPCollMgr.getConnection() == null)) {
            ConnectionPoolManager connectionPoolManager = ConnectionPoolManagerFactory.getConnectionPoolManager(MOMProperties.getProperties());
            if (this.mInternalCredentials.mDataSource == null && connectionPoolManager.getMaxPoolSize() > 0) {
                connectionPoolManager.returnConnectionForInternalUse(this.mInternalConnectionPoolKey, connection, this.mInternalCredentials.mjdbcInfo);
            } else {
                try {
                    connection.close();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
        }
    }

    public Connection getPersistManagerConnection() {
        return this.getInternalConnection(false);
    }

    Connection getInternalConnection(boolean bl) {
        Connection connection = null;
        if (this.mPCollMgr != null) {
            connection = this.mPCollMgr.getConnection();
        }
        if (connection == null) {
            if (Diagnostic.isOn()) {
                Diagnostic.println("Getting a connection for internal use...");
            }
            if (this.mInternalCredentials == null) {
                Hashtable hashtable = this.getSession().getEnvironment();
                String string = PropertyMetadata.INTERNAL_CONNECTION_PARAMS.getProperty(hashtable);
                if (string == null) {
                    if (JboEnvUtil.inJServer()) {
                        if (!bl) {
                            if (Diagnostic.isOn()) {
                                Diagnostic.println("   No internal conn for running inside JServer, force=" + bl);
                            }
                            return null;
                        }
                        if (Diagnostic.isOn()) {
                            Diagnostic.println("   Using main conn as internal conn for running inside JServer, force=" + bl);
                        }
                        return this.mjdbcConnection;
                    }
                    if (this.mTxnHandler instanceof JTATransactionHandler) {
                        Class clazz = class$oracle$jbo$CSMessageBundle;
                        if (clazz == null) {
                            clazz = class$oracle$jbo$CSMessageBundle = DBTransactionImpl.class$("oracle.jbo.CSMessageBundle");
                        }
                        throw new JboException(clazz, "27203", null);
                    }
                    String string2 = this.getDatabaseProductName();
                    if (!string2.equalsIgnoreCase("Oracle") && !string2.equalsIgnoreCase("DB2")) {
                        if (Diagnostic.isOn()) {
                            Diagnostic.println("   No internal conn for dbtype " + string2);
                        }
                        return null;
                    }
                    this.mInternalCredentials = (ConnectionCredentials)this.mConnectionCredentials.clone();
                } else {
                    this.mInternalCredentials = new ConnectionCredentials();
                    if (string.startsWith(JDBC_URL_PREFIX)) {
                        this.mInternalCredentials.mjdbcURL = string;
                    } else {
                        this.mInternalCredentials.mDataSource = DBTransactionImpl.lookupDataSource(null, string);
                    }
                }
                this.mInternalCredentials.mDefinesInternalConnection = true;
            }
            StringBuffer stringBuffer = new StringBuffer();
            if (Diagnostic.isOn()) {
                Diagnostic.println("   Creating internal connection...");
            }
            connection = this.establishNewConnection(this.mInternalCredentials, stringBuffer);
            this.mInternalConnectionPoolKey = stringBuffer.toString();
        }
        return connection;
    }

    static DataSource lookupDataSource(Hashtable hashtable, String string) {
        try {
            InitialContext initialContext = hashtable != null ? new InitialContext(hashtable) : new InitialContext();
            DataSource dataSource = (DataSource)initialContext.lookup(string);
            return dataSource;
        }
        catch (NamingException namingException) {
            Class clazz;
            if (Diagnostic.isOn()) {
                Diagnostic.println("DBTransactionImpl.lookupDataSource() failed");
                Diagnostic.printStackTrace(namingException);
            }
            if ((clazz = class$oracle$jbo$CSMessageBundle) == null) {
                clazz = class$oracle$jbo$CSMessageBundle = DBTransactionImpl.class$("oracle.jbo.CSMessageBundle");
            }
            String string2 = StringManager.getString(clazz.getName(), "01309", null, null);
            Class clazz2 = class$oracle$jbo$CSMessageBundle;
            if (clazz2 == null) {
                clazz2 = class$oracle$jbo$CSMessageBundle = DBTransactionImpl.class$("oracle.jbo.CSMessageBundle");
            }
            throw new DMLException(clazz2, "27200", (Object[])new String[]{string2, string}, namingException);
        }
    }

    private void closeConnectionInternal(Connection connection, boolean bl) {
        ConnectionPoolManager connectionPoolManager = ConnectionPoolManagerFactory.getConnectionPoolManager(MOMProperties.getProperties());
        if (connectionPoolManager.getMaxPoolSize() > 0 && this.mConnectionPoolKey != null && this.mConnectionCredentials.mDataSource == null) {
            if (bl) {
                connectionPoolManager.removeConnection(this.mConnectionPoolKey, connection);
            } else {
                connectionPoolManager.returnConnection(this.mConnectionPoolKey, connection, this.mConnectionCredentials.mjdbcInfo);
            }
        } else {
            try {
                this.mTxnHandler.handleClose(connection);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void closeTransaction() {
        if (Diagnostic.isOn()) {
            Diagnostic.println("*** closing jdbc connection now **** (" + this.mjdbcConnection + ")");
        }
        if (this.mjdbcConnection != null) {
            try {
                block6: {
                    try {
                        this.transitionToState(0);
                        this.doRollback();
                        ApplicationModuleImpl applicationModuleImpl = this.getTxnApplicationModuleImpl();
                        if (applicationModuleImpl == null) break block6;
                        applicationModuleImpl.callBeforeDisconnect();
                    }
                    catch (Exception exception) {
                        Object var4_3 = null;
                        this.closeStatements();
                        this.closeConnectionInternal(this.mjdbcConnection, false);
                        this.mjdbcConnection = null;
                        this.mIsConnected = false;
                        this.mConnectionPoolKey = null;
                        this.transitionToState(2);
                        this.refreshConnectionMetadata();
                    }
                }
                Object var4_2 = null;
                this.closeStatements();
                this.closeConnectionInternal(this.mjdbcConnection, false);
                this.mjdbcConnection = null;
                this.mIsConnected = false;
                this.mConnectionPoolKey = null;
                this.transitionToState(2);
                this.refreshConnectionMetadata();
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                this.closeStatements();
                this.closeConnectionInternal(this.mjdbcConnection, false);
                this.mjdbcConnection = null;
                this.mIsConnected = false;
                this.mConnectionPoolKey = null;
                this.transitionToState(2);
                this.refreshConnectionMetadata();
                throw throwable;
            }
        }
        this.closePCollManager();
    }

    void closePCollManager() {
        this.closePCollManager(0);
    }

    void closePCollManager(int n) {
        try {
            if (this.mPCollMgr != null) {
                Connection connection = this.mPCollMgr.getConnection();
                if ((n & 1) > 0) {
                    this.mPCollMgr.close(1);
                } else {
                    this.mPCollMgr.close(0);
                }
                if (connection != null) {
                    this.releaseInternalConnection(connection, true);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setBundledExceptionMode(boolean bl) {
        this.mDeferValidation = bl;
    }

    public final boolean isBundledExceptionMode() {
        return this.mDeferValidation;
    }

    public SQLBuilder getSQLBuilder() {
        return this.mSQLBuilder;
    }

    public boolean isClearCacheOnCommit() {
        boolean bl = false;
        if (this.mClearCacheOnCommit == -1) {
            ApplicationModuleImpl applicationModuleImpl = this.getTxnApplicationModuleImpl();
            if (applicationModuleImpl != null) {
                bl = applicationModuleImpl.getApplicationModuleDef().isClearCacheOnCommit();
            }
        } else {
            bl = this.mClearCacheOnCommit == 1;
        }
        return bl;
    }

    public void setClearCacheOnCommit(boolean bl) {
        this.mClearCacheOnCommit = bl ? 1 : 0;
    }

    public boolean isClearCacheOnRollback() {
        boolean bl = true;
        if (this.mClearCacheOnRollback == -1) {
            ApplicationModuleImpl applicationModuleImpl = this.getTxnApplicationModuleImpl();
            if (applicationModuleImpl != null) {
                bl = applicationModuleImpl.getApplicationModuleDef().isClearCacheOnRollback();
            }
        } else {
            bl = this.mClearCacheOnRollback == 1;
        }
        return bl;
    }

    public void setClearCacheOnRollback(boolean bl) {
        this.mClearCacheOnRollback = bl ? 1 : 0;
    }

    private void clearTmpPostState() {
        this.mTmpPostStateSaved = false;
        this.mTmpTxnPostListeners = null;
        this.mTmpTxnSnapshot = null;
        this.releaseSavepoint();
    }

    private boolean saveTmpPostState() {
        if (this.mPostAll != POST_ALL_NO_RESET_ON_EXCEPTION) {
            boolean bl = this.setSavepoint();
            boolean bl2 = "true".equals(this.getTxnApplicationModuleImpl().getSession().getEnvironment().get(PropertyMetadata.ENV_TXN_HANDLE_AFTER_POST_EXC.pName));
            if (!this.mTmpPostStateSaved && bl2) {
                this.mTmpTxnPostListeners = (ArrayList)this.mTransPostListeners.clone();
                this.mTmpTxnSnapshot = new DOMSerializer(this.getTxnApplicationModuleImpl()).passivateRootAMToDOM(null, 1);
                this.mTmpPostStateSaved = true;
                bl = true;
            }
            return bl;
        }
        return false;
    }

    private void restoreTmpPostState() {
        this.rollbackToSavepoint();
        if (this.mTmpPostStateSaved) {
            new DOMSerializer(this.getTxnApplicationModuleImpl()).activateRootAMFromDOM(this.mTmpTxnSnapshot, 1);
            this.mTmpPostStateSaved = false;
        }
    }

    private int commitInternal(boolean bl) {
        boolean bl2;
        TransactionListener[] transactionListenerArray;
        int n = -1;
        TransactionEvent transactionEvent = new TransactionEvent(this, this);
        boolean bl3 = false;
        try {
            int n2 = this.getPostThreshold();
            while (n2 > 0 && this.hasObjectsToPost()) {
                ArrayList arrayList = null;
                this.mApplyValidationThreshold = true;
                boolean bl4 = false;
                int n3 = this.getValidationThreshold();
                while (n3 > 0 && this.mValidationListeners.size() > 0 && !bl4) {
                    arrayList = null;
                    try {
                        this.validate();
                    }
                    catch (JboException jboException) {
                        if (arrayList == null) {
                            arrayList = new ArrayList();
                        }
                        if (!(jboException instanceof ValidationException)) {
                            bl4 = true;
                        }
                        arrayList.add((Object)jboException);
                    }
                    --n3;
                }
                this.mApplyValidationThreshold = false;
                if (this.mValidationListeners.size() > 0 || bl4) {
                    if (arrayList != null && arrayList.size() == 1) {
                        throw (JboException)arrayList.get(0);
                    }
                    Class clazz = class$oracle$jbo$CSMessageBundle;
                    if (clazz == null) {
                        clazz = class$oracle$jbo$CSMessageBundle = DBTransactionImpl.class$("oracle.jbo.CSMessageBundle");
                    }
                    ValidationException validationException = new ValidationException(clazz, "28200", null);
                    if (arrayList != null && arrayList.size() > 0) {
                        validationException.setExceptions((Exception[])arrayList.toArray((Object[])new Exception[arrayList.size()]));
                    }
                    throw validationException;
                }
                if (!bl3) {
                    bl3 = this.saveTmpPostState();
                }
                try {
                    this.postChanges(transactionEvent);
                }
                catch (RuntimeException runtimeException) {
                    if (bl3) {
                        this.rollbackToSavepoint();
                    }
                    throw runtimeException;
                }
                --n2;
            }
            if (this.hasObjectsToPost()) {
                Class clazz = class$oracle$jbo$CSMessageBundle;
                if (clazz == null) {
                    clazz = class$oracle$jbo$CSMessageBundle = DBTransactionImpl.class$("oracle.jbo.CSMessageBundle");
                }
                throw new JboException(clazz, "28201", null);
            }
            try {
                transactionListenerArray = (TransactionListener[])this.mTransListeners.toArray((Object[])new TransactionListener[this.mTransListeners.size()]);
                bl2 = true;
                do {
                    int n4 = 0;
                    while (n4 < transactionListenerArray.length) {
                        if (transactionListenerArray[n4].isTransientTransactionListener() == bl2) {
                            transactionListenerArray[n4].beforeCommit(transactionEvent);
                        }
                        ++n4;
                    }
                } while (!(bl2 ^= true));
                if (this.hasTransientTransactionPostListeners()) {
                    Class clazz = class$oracle$jbo$CSMessageBundle;
                    if (clazz == null) {
                        clazz = class$oracle$jbo$CSMessageBundle = DBTransactionImpl.class$("oracle.jbo.CSMessageBundle");
                    }
                    throw new JboException(clazz, "28202", null);
                }
                this.mTmpSavepointExists = false;
                this.doCommit();
            }
            catch (RuntimeException runtimeException) {
                this.restoreTmpPostState();
                throw runtimeException;
            }
            Object var21_16 = null;
            if (bl3) {
                this.clearTmpPostState();
            }
            this.mApplyValidationThreshold = false;
        }
        catch (Throwable throwable) {
            Object var21_17 = null;
            if (bl3) {
                this.clearTmpPostState();
            }
            this.mApplyValidationThreshold = false;
            throw throwable;
        }
        if (bl) {
            n = this.getTxnApplicationModuleImpl().getAMSerializer().snapCommittedEOs();
        }
        ArrayList arrayList = new ArrayList();
        transactionListenerArray = (TransactionListener[])this.mTransListeners.toArray((Object[])new TransactionListener[this.mTransListeners.size()]);
        bl2 = true;
        do {
            int n5 = 0;
            while (n5 < transactionListenerArray.length) {
                if (transactionListenerArray[n5].isTransientTransactionListener() == bl2) {
                    try {
                        transactionListenerArray[n5].afterCommit(transactionEvent);
                        if (bl2) {
                            this.removeTransactionListener(transactionListenerArray[n5]);
                        }
                    }
                    catch (JboException jboException) {
                        arrayList.add((Object)jboException);
                    }
                }
                ++n5;
            }
        } while (!(bl2 ^= true));
        if (arrayList.size() != 0) {
            throw new AfterCommitException((Exception[])arrayList.toArray((Object[])new Exception[arrayList.size()]));
        }
        boolean bl5 = this.isClearCacheOnCommit();
        if (bl5) {
            this.clearECacheWithCheck(null, false, true);
        }
        this.closeLockStatements();
        this.fireTransactionStateEvent(1, bl5);
        this.transitionToState(4);
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit() {
        Object object = this.getSyncLock();
        synchronized (object) {
            DBTransactionImpl dBTransactionImpl = this;
            synchronized (dBTransactionImpl) {
                this.commitInternal(false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int commitAndSaveChangeSet() {
        Object object = this.getSyncLock();
        synchronized (object) {
            DBTransactionImpl dBTransactionImpl = this;
            synchronized (dBTransactionImpl) {
                int n = this.commitInternal(true);
                return n;
            }
        }
    }

    public void applyChangeSet(int n) {
        this.getTxnApplicationModuleImpl().getAMSerializer().replayCommittedEOs(n);
    }

    public void removeChangeSet(int n) {
        this.getTxnApplicationModuleImpl().getAMSerializer().removeCommittedEOs(n);
    }

    private void rollbackValidationListeners(TransactionEvent transactionEvent, boolean bl) {
        if (this.mValidationListeners.size() > 0) {
            HashMap hashMap = (HashMap)this.mValidationListeners.clone();
            Iterator iterator = hashMap.values().iterator();
            while (iterator.hasNext()) {
                Object object = iterator.next();
                if (!(object instanceof TransactionListener) || this.mTransListeners.contains(object)) continue;
                if (bl) {
                    ((TransactionListener)object).beforeRollback(transactionEvent);
                    continue;
                }
                ((TransactionListener)object).afterRollback(transactionEvent);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollback() {
        Object object = this.getSyncLock();
        synchronized (object) {
            DBTransactionImpl dBTransactionImpl = this;
            synchronized (dBTransactionImpl) {
                TransactionEvent transactionEvent = new TransactionEvent(this, this);
                this.rollbackValidationListeners(transactionEvent, true);
                TransactionListener[] transactionListenerArray = (TransactionListener[])this.mTransListeners.toArray((Object[])new TransactionListener[this.mTransListeners.size()]);
                boolean bl = true;
                do {
                    int n = 0;
                    while (n < transactionListenerArray.length) {
                        if (transactionListenerArray[n].isTransientTransactionListener() == bl) {
                            transactionListenerArray[n].beforeRollback(transactionEvent);
                        }
                        ++n;
                    }
                } while (!(bl ^= true));
                this.doRollback();
                this.mIsDirty = false;
                this.closeLockStatements();
                ArrayList arrayList = new ArrayList();
                this.rollbackValidationListeners(transactionEvent, false);
                transactionListenerArray = (TransactionListener[])this.mTransListeners.toArray((Object[])new TransactionListener[this.mTransListeners.size()]);
                bl = true;
                do {
                    int n = 0;
                    while (n < transactionListenerArray.length) {
                        if (transactionListenerArray[n].isTransientTransactionListener() == bl) {
                            try {
                                transactionListenerArray[n].afterRollback(transactionEvent);
                            }
                            catch (JboException jboException) {
                                arrayList.add((Object)jboException);
                            }
                        }
                        ++n;
                    }
                } while (!(bl ^= true));
                this.removeTransientTransactionListeners();
                this.removeTransientTransactionPostListeners();
                this.mValidationListeners = new HashMap();
                if (arrayList.size() != 0) {
                    throw new AfterRollbackException((Exception[])arrayList.toArray((Object[])new Exception[arrayList.size()]));
                }
                boolean bl2 = this.isClearCacheOnRollback();
                if (bl2) {
                    this.clearECacheWithCheck(null, false, true);
                }
                this.fireTransactionStateEvent(0, bl2);
                this.transitionToState(4);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTransactionListener(TransactionListener transactionListener) {
        Object object = this.getSyncLock();
        synchronized (object) {
            DBTransactionImpl dBTransactionImpl = this;
            synchronized (dBTransactionImpl) {
                if (!this.mTransListeners.contains((Object)transactionListener)) {
                    this.mTransListeners.add((Object)transactionListener);
                    if (transactionListener.isTransientTransactionListener()) {
                        this.mIsDirty = true;
                        ++this.mNumTransientTransListeners;
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTransactionListenerNoCheck(TransactionListener transactionListener) {
        Object object = this.getSyncLock();
        synchronized (object) {
            DBTransactionImpl dBTransactionImpl = this;
            synchronized (dBTransactionImpl) {
                this.mTransListeners.add((Object)transactionListener);
                if (transactionListener.isTransientTransactionListener()) {
                    this.mIsDirty = true;
                    ++this.mNumTransientTransListeners;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTransactionListener(TransactionListener transactionListener) {
        Object object = this.getSyncLock();
        synchronized (object) {
            DBTransactionImpl dBTransactionImpl = this;
            synchronized (dBTransactionImpl) {
                if (this.mTransListeners.remove((Object)transactionListener)) {
                    if (transactionListener.isTransientTransactionListener()) {
                        if (this.mNumTransientTransListeners <= 0) {
                            Diagnostic.ASSERT(false, "Num transient transaction listeners is about to go negative");
                        }
                        if (--this.mNumTransientTransListeners == 0) {
                            this.mIsDirty = false;
                        }
                    }
                    transactionListener.afterRemove(new TransactionEvent(this, this));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTransactionPostListener(TransactionPostListener transactionPostListener) {
        Object object = this.getSyncLock();
        synchronized (object) {
            DBTransactionImpl dBTransactionImpl = this;
            synchronized (dBTransactionImpl) {
                if (!this.mTransPostListeners.contains((Object)transactionPostListener)) {
                    this.mTransPostListeners.add((Object)transactionPostListener);
                    if (transactionPostListener.isTransientTransactionPostListener()) {
                        transactionPostListener.setPostedToDB(false);
                        this.setNextTransactionPostHandle(transactionPostListener);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTransactionPostListenerNoCheck(TransactionPostListener transactionPostListener) {
        Object object = this.getSyncLock();
        synchronized (object) {
            DBTransactionImpl dBTransactionImpl = this;
            synchronized (dBTransactionImpl) {
                this.mTransPostListeners.add((Object)transactionPostListener);
                if (transactionPostListener.isTransientTransactionPostListener()) {
                    transactionPostListener.setPostedToDB(false);
                    this.setNextTransactionPostHandle(transactionPostListener);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setNextTransactionPostHandle(TransactionPostListener transactionPostListener) {
        DBTransactionImpl dBTransactionImpl = this;
        synchronized (dBTransactionImpl) {
            if (transactionPostListener.getTransPostHandle() == -1) {
                transactionPostListener.setTransPostHandle(this.mTransPostHdl);
                this.mTransPostListenerHash.put((Object)new Integer(this.mTransPostHdl), (Object)transactionPostListener);
                ++this.mTransPostHdl;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTransactionPostListener(TransactionPostListener transactionPostListener) {
        Object object = this.getSyncLock();
        synchronized (object) {
            DBTransactionImpl dBTransactionImpl = this;
            synchronized (dBTransactionImpl) {
                int n = this.mTransPostListeners.indexOf((Object)transactionPostListener);
                if (n >= 0) {
                    if (transactionPostListener.isTransientTransactionPostListener()) {
                        this.mTransPostListenerHash.remove((Object)new Integer(transactionPostListener.getTransPostHandle()));
                    }
                    this.mTransPostListeners.remove(n);
                } else if (transactionPostListener.isTransientTransactionPostListener()) {
                    this.mTransPostListenerHash.remove((Object)new Integer(transactionPostListener.getTransPostHandle()));
                } else if (transactionPostListener.isTransientTransactionPostListener() && Diagnostic.isOn()) {
                    Diagnostic.println("### removeTransactionPostListener, " + transactionPostListener.getClass().getName() + " -- not found ###");
                }
                transactionPostListener.setTransPostHandle(-1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postChanges() {
        Object object = this.getSyncLock();
        synchronized (object) {
            DBTransactionImpl dBTransactionImpl = this;
            synchronized (dBTransactionImpl) {
                this.postChanges(new TransactionEvent(this, this));
            }
        }
    }

    Entity getTransPostListener(int n) {
        Object object = this.mTransPostListenerHash.get((Object)new Integer(n));
        if (object instanceof Entity) {
            return (Entity)object;
        }
        return null;
    }

    boolean getBatchModeForEntity(EntityDefImpl entityDefImpl) {
        boolean bl = false;
        if (this.mBatchStmtOwners != null) {
            bl = this.mBatchStmtOwners.contains((Object)entityDefImpl.getFullName());
        }
        return bl;
    }

    public void setBatchModeForEntity(EntityDefImpl entityDefImpl, boolean bl) {
        if (this.mBatchStmtOwners == null && bl) {
            this.mBatchStmtOwners = new ArrayList(10);
        }
        if (this.mBatchStmtOwners != null) {
            String string = entityDefImpl.getFullName();
            if (bl && (entityDefImpl.getRetrievedOnInsertPrimaryKeys().length > 0 || entityDefImpl.getRetrievedOnUpdatePrimaryKeys().length > 0)) {
                Diagnostic.println("*** WARNING : BatchMode cannot be set as a primary key attribute has Refresh-On-Insert or update property.");
                Diagnostic.println("*** Entity definition name :" + entityDefImpl.getName());
                Class clazz = class$oracle$jbo$CSMessageBundle;
                if (clazz == null) {
                    clazz = class$oracle$jbo$CSMessageBundle = DBTransactionImpl.class$("oracle.jbo.CSMessageBundle");
                }
                throw new InvalidOperException(clazz, "25049", new Object[]{entityDefImpl.getName()});
            }
            int n = this.mBatchStmtOwners.indexOf((Object)string);
            if (n > -1) {
                if (!bl) {
                    this.mBatchStmtOwners.remove((Object)string);
                    ((EntityCache)this.mRowCache.get((Object)string)).mBatchMode = false;
                } else {
                    ((EntityCache)this.mRowCache.get((Object)string)).mBatchMode = true;
                }
            } else if (bl) {
                this.mBatchStmtOwners.add((Object)string);
                this.findEntityCache((EntityDefImpl)entityDefImpl).mBatchMode = true;
            }
        }
    }

    protected void postChanges(TransactionEvent transactionEvent) {
        int n = this.mTransPostListeners.size();
        if (n == 0) {
            return;
        }
        this.transitionToState(4);
        boolean bl = false;
        try {
            int n2;
            bl = this.saveTmpPostState();
            ArrayList arrayList = (ArrayList)this.mTransPostListeners.clone();
            ArrayList arrayList2 = null;
            int n3 = n2 = this.mBatchStmtOwners != null ? this.mBatchStmtOwners.size() : 0;
            if (n2 > 0) {
                arrayList2 = new ArrayList(n2);
                int n4 = 0;
                while (n4 < n2) {
                    EntityCache entityCache = (EntityCache)this.mRowCache.get(this.mBatchStmtOwners.get(n4));
                    arrayList2.add((Object)entityCache);
                    ++n4;
                }
                int n5 = 0;
                while (n5 < n) {
                    Object object = arrayList.get(n5);
                    if (object instanceof EntityImpl) {
                        EntityImpl entityImpl = (EntityImpl)object;
                        if (entityImpl.getEntityCache().mBatchMode) {
                            entityImpl.prepareForBatch(null, entityImpl.getTransactionListenersList(), transactionEvent);
                        }
                    }
                    ++n5;
                }
            }
            try {
                this.doPostTransactionListeners(transactionEvent, arrayList, this.mTransPostListenerHash, arrayList2, true, true);
                int n6 = 0;
                while (n6 < n) {
                    Object object = arrayList.get(n6);
                    if (object instanceof EntityImpl) {
                        EntityImpl entityImpl = (EntityImpl)object;
                        entityImpl.donePostingAll(transactionEvent);
                    }
                    ++n6;
                }
            }
            catch (RuntimeException runtimeException) {
                this.restoreTmpPostState();
                throw runtimeException;
            }
            Object var17_16 = null;
            if (bl) {
                this.clearTmpPostState();
            }
        }
        catch (Throwable throwable) {
            Object var17_17 = null;
            if (bl) {
                this.clearTmpPostState();
            }
            throw throwable;
        }
    }

    protected boolean hasRollbackSavePoint() {
        return this.mTmpSavepointExists;
    }

    private void rollbackToSavepoint() {
        if (!this.mTmpSavepointExists) {
            return;
        }
        try {
            try {
                this.getSQLBuilder().rollbackToSavepoint(this.mjdbcConnection, this.getSavepointId());
            }
            catch (SQLException sQLException) {
                if (Diagnostic.isOn()) {
                    Diagnostic.println("DBTransactionImpl.postChanges failed...");
                    Diagnostic.printStackTrace(sQLException);
                }
                throw new DMLException(7, null, sQLException);
            }
            Object var3_1 = null;
            this.mTmpSavepointExists = false;
        }
        catch (Throwable throwable) {
            Object var3_2 = null;
            this.mTmpSavepointExists = false;
            throw throwable;
        }
    }

    private void releaseSavepoint() {
        if (!this.mTmpSavepointExists) {
            return;
        }
        try {
            try {
                this.getSQLBuilder().releaseSavepoint(this.mjdbcConnection, this.getSavepointId());
            }
            catch (SQLException sQLException) {
                if (Diagnostic.isOn()) {
                    Diagnostic.println("DBTransactionImpl.postChanges failed...");
                    Diagnostic.printStackTrace(sQLException);
                }
                throw new DMLException(8, this.getSavepointId(), sQLException);
            }
            Object var3_1 = null;
            this.mTmpSavepointExists = false;
        }
        catch (Throwable throwable) {
            Object var3_2 = null;
            this.mTmpSavepointExists = false;
            throw throwable;
        }
    }

    private boolean setSavepoint() {
        if (this.mTmpSavepointExists || this.mjdbcConnection == null) {
            return false;
        }
        this.transitionToState(4);
        try {
            this.getSQLBuilder().setSavepoint(this.mjdbcConnection, this.getSavepointId());
            this.mTmpSavepointExists = true;
            boolean bl = true;
            return bl;
        }
        catch (SQLException sQLException) {
            if (Diagnostic.isOn()) {
                Diagnostic.println("DBTransactionImpl.setSavepoint failed...");
                Diagnostic.printStackTrace(sQLException);
            }
            throw new DMLException(6, this.getSavepointId(), sQLException);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void doPostTransactionListeners(TransactionEvent transactionEvent, ArrayList arrayList, HashMap hashMap, ArrayList arrayList2, boolean bl, boolean bl2) {
        Object var9_7 = null;
        int n = 0;
        TransactionPostListener[] transactionPostListenerArray = (TransactionPostListener[])arrayList.toArray((Object[])new TransactionPostListener[arrayList.size()]);
        boolean bl3 = false;
        try {
            TransactionPostListener transactionPostListener;
            block49: {
                int n2;
                if (bl) {
                    bl3 = this.saveTmpPostState();
                }
                boolean bl4 = false;
                EntityCache[] entityCacheArray = null;
                try {
                    RuntimeException runtimeException;
                    block50: {
                        block48: {
                            try {
                                ArrayList arrayList3;
                                if (arrayList2 != null) {
                                    entityCacheArray = (EntityCache[])arrayList2.toArray((Object[])new EntityCache[arrayList2.size()]);
                                    bl4 = entityCacheArray != null && entityCacheArray.length > 0;
                                }
                                boolean bl5 = true;
                                do {
                                    ArrayList arrayList4 = null;
                                    n = 0;
                                    while (n < transactionPostListenerArray.length) {
                                        block47: {
                                            transactionPostListener = transactionPostListenerArray[n];
                                            if (transactionPostListener.isTransientTransactionPostListener() == bl5) {
                                                if (this.mPostAll != POST_ABORT_ON_FIRST_EXCEPTION) {
                                                    try {
                                                        transactionPostListener.postChanges(transactionEvent);
                                                        break block47;
                                                    }
                                                    catch (JboException jboException) {
                                                        if (arrayList4 == null) {
                                                            arrayList4 = new ArrayList(5);
                                                        }
                                                        arrayList4.add((Object)jboException);
                                                        if (jboException instanceof BatchDMLException) {
                                                            DMLException dMLException = (DMLException)jboException;
                                                            dMLException.setEntityRowHandle(transactionPostListener.getTransPostHandle());
                                                            if (transactionPostListener instanceof Row) {
                                                                dMLException.setEntityRow((Row)((Object)transactionPostListener));
                                                            }
                                                        }
                                                        if (arrayList4.size() == this.getBatchPostExceptionThreshold()) {
                                                            break;
                                                        }
                                                        break block47;
                                                    }
                                                }
                                                transactionPostListener.postChanges(transactionEvent);
                                            }
                                        }
                                        ++n;
                                    }
                                    if (arrayList4 == null) continue;
                                    throw new BatchDMLException(arrayList4);
                                } while (!(bl5 ^= true));
                                if (!bl4) break block48;
                                Object var18_19 = null;
                                ArrayList arrayList5 = new ArrayList();
                                int n3 = entityCacheArray.length - 1;
                                while (true) {
                                    if (n3 < 0) break;
                                    if (entityCacheArray[n3].mDeleteStatement != null && (arrayList3 = entityCacheArray[n3].doBatch(3, transactionEvent)) != null) {
                                        arrayList5.addAll((Collection)arrayList3);
                                    }
                                    --n3;
                                }
                                int n4 = 0;
                                while (true) {
                                    if (n4 >= entityCacheArray.length) {
                                        if (arrayList5.size() <= 0) break;
                                        throw new BatchDMLException(arrayList5);
                                    }
                                    if (entityCacheArray[n4].mInsertStatement != null && (arrayList3 = entityCacheArray[n4].doBatch(1, transactionEvent)) != null) {
                                        arrayList5.addAll((Collection)arrayList3);
                                    }
                                    if (entityCacheArray[n4].mUpdateStatement != null && (arrayList3 = entityCacheArray[n4].doBatch(2, transactionEvent)) != null) {
                                        arrayList5.addAll((Collection)arrayList3);
                                    }
                                    ++n4;
                                }
                                n = 0;
                                while (n < transactionPostListenerArray.length) {
                                    transactionPostListener = transactionPostListenerArray[n];
                                    if (transactionPostListener instanceof EntityImpl) {
                                        EntityImpl entityImpl = (EntityImpl)transactionPostListener;
                                        if (entityImpl.getEntityCache().mBatchMode) {
                                            entityImpl.doRefreshAfterBatch(transactionEvent);
                                        }
                                    }
                                    ++n;
                                }
                            }
                            catch (Throwable throwable) {
                                runtimeException = null;
                                try {
                                    runtimeException = throwable instanceof RuntimeException ? (RuntimeException)throwable : new JboException(throwable);
                                    if (this.mPostAll == POST_ALL_NO_RESET_ON_EXCEPTION) break block50;
                                    int n5 = n;
                                    int n6 = 0;
                                    while (true) {
                                        if (n6 >= n5) {
                                        }
                                        TransactionPostListener transactionPostListener2 = transactionPostListenerArray[n6];
                                        if (transactionPostListener2 instanceof EntityImpl) {
                                            ((EntityImpl)transactionPostListener2).handlePostChangesError();
                                        }
                                        ++n6;
                                    }
                                }
                                catch (Throwable throwable2) {
                                    Object var35_34 = null;
                                    if (!bl3) throw throwable2;
                                    this.rollbackToSavepoint();
                                    throw throwable2;
                                }
                            }
                        }
                        Object var37_25 = null;
                        if (entityCacheArray != null) {
                            int n7 = 0;
                            while (n7 < entityCacheArray.length) {
                                entityCacheArray[n7].resetBatchVariables();
                                ++n7;
                            }
                        }
                        break block49;
                    }
                    Object var35_33 = null;
                    if (bl3) {
                        this.rollbackToSavepoint();
                    }
                    if (bl4) throw runtimeException;
                    if (this.mPostAll != POST_ABORT_ON_FIRST_EXCEPTION) throw runtimeException;
                    if (!(runtimeException instanceof DMLException)) throw runtimeException;
                    DMLException dMLException = (DMLException)runtimeException;
                    if (dMLException.getEntityRow() != null) throw runtimeException;
                    dMLException.setEntityRowHandle(transactionPostListenerArray[n].getTransPostHandle());
                    if (!(transactionPostListenerArray[n] instanceof Row)) throw runtimeException;
                    dMLException.setEntityRow((Row)((Object)transactionPostListenerArray[n]));
                    throw runtimeException;
                }
                catch (Throwable throwable) {
                    Object var37_26 = null;
                    if (entityCacheArray == null) throw throwable;
                    n2 = 0;
                }
                while (true) {
                    if (n2 >= entityCacheArray.length) {
                        throw throwable;
                    }
                    entityCacheArray[n2].resetBatchVariables();
                    ++n2;
                }
            }
            ArrayList arrayList6 = new ArrayList();
            if (bl2) {
                boolean bl6 = false;
                int n8 = 0;
                while (n8 < transactionPostListenerArray.length) {
                    try {
                        transactionPostListener = transactionPostListenerArray[n8];
                        bl6 = transactionPostListener.isTransientTransactionPostListener();
                        if (transactionPostListener instanceof EntityImpl) {
                            bl6 = ((EntityImpl)transactionPostListener).isValid();
                            if (bl6) {
                                ((EntityImpl)transactionPostListener).removeFromTransactionPostManager();
                                bl6 = false;
                            }
                            ((EntityImpl)transactionPostListener).setPostedToDB(false);
                        } else if (transactionPostListener instanceof ViewObjectImpl) {
                            ((ViewObjectImpl)transactionPostListener).afterPost(transactionEvent);
                        }
                        if (bl6) {
                            hashMap.remove((Object)new Integer(transactionPostListener.getTransPostHandle()));
                            arrayList.remove((Object)transactionPostListener);
                        }
                    }
                    catch (JboException jboException) {
                        arrayList6.add((Object)jboException);
                    }
                    ++n8;
                }
            }
            if (arrayList6.size() != 0) {
                this.restoreTmpPostState();
                throw new AfterPostException((Exception[])arrayList6.toArray((Object[])new Exception[arrayList6.size()]));
            }
            Object var39_42 = null;
            if (!bl3) return;
            this.clearTmpPostState();
            return;
        }
        catch (Throwable throwable) {
            Object var39_43 = null;
            if (!bl3) throw throwable;
            this.clearTmpPostState();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeTransientTransactionPostListeners() {
        DBTransactionImpl dBTransactionImpl = this;
        synchronized (dBTransactionImpl) {
            int n = this.mTransPostListeners.size() - 1;
            while (n >= 0) {
                TransactionPostListener transactionPostListener = (TransactionPostListener)this.mTransPostListeners.get(n);
                if (transactionPostListener.isTransientTransactionPostListener()) {
                    if (transactionPostListener instanceof EntityImpl) {
                        ((EntityImpl)transactionPostListener).removeFromTransactionPostManager();
                    } else {
                        this.mTransPostListenerHash.remove((Object)new Integer(transactionPostListener.getTransPostHandle()));
                        this.mTransPostListeners.remove(n);
                    }
                }
                --n;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeTransientTransactionListeners() {
        DBTransactionImpl dBTransactionImpl = this;
        synchronized (dBTransactionImpl) {
            TransactionEvent transactionEvent = new TransactionEvent(this, this);
            int n = this.mTransListeners.size() - 1;
            while (n >= 0) {
                TransactionListener transactionListener = (TransactionListener)this.mTransListeners.get(n);
                if (transactionListener.isTransientTransactionListener()) {
                    this.mTransListeners.remove(n);
                    if (this.mNumTransientTransListeners <= 0) {
                        Diagnostic.ASSERT(false, "Num transient transaction listeners is about to go negative");
                    }
                    if (--this.mNumTransientTransListeners == 0) {
                        this.mIsDirty = false;
                    }
                    transactionListener.afterRemove(transactionEvent);
                }
                --n;
            }
        }
    }

    public Statement createStatement(int n) {
        int n2 = 0;
        if (InstrumentedEvent.isActive) {
            n2 = InstrumentedEvent.startEvent(EventGroup.JDBC_CREATE_STATEMENT, "createStatement - prefetch size: " + n);
        }
        Statement statement = null;
        try {
            statement = this.mjdbcConnection.createStatement();
            if (JDBCInteract.mDoTrace) {
                JDBCInteract.createStatement();
            }
            if (n != -1) {
                this.mSQLBuilder.doStatementSetRowPrefetch(statement, n);
            }
        }
        catch (SQLException sQLException) {
            Class clazz;
            if (Diagnostic.isOn()) {
                Diagnostic.println("DBTransactionImpl.createStatement failed...");
                Diagnostic.printStackTrace(sQLException);
            }
            if ((clazz = class$oracle$jbo$CSMessageBundle) == null) {
                clazz = class$oracle$jbo$CSMessageBundle = DBTransactionImpl.class$("oracle.jbo.CSMessageBundle");
            }
            throw new SQLStmtException(clazz, "27124", "", sQLException);
        }
        if (InstrumentedEvent.isActive) {
            InstrumentedEvent.endEvent(n2);
        }
        return statement;
    }

    public CallableStatement createCallableStatement(String string, int n) {
        int n2 = 0;
        if (InstrumentedEvent.isActive) {
            n2 = InstrumentedEvent.startEvent(EventGroup.JDBC_CREATE_STATEMENT, "createCallableStatement - prefetch size: " + n);
        }
        CallableStatement callableStatement = null;
        try {
            callableStatement = this.mjdbcConnection.prepareCall(string);
            if (JDBCInteract.mDoTrace) {
                JDBCInteract.prepareCall(string);
            }
            if (n != -1) {
                this.mSQLBuilder.doStatementSetRowPrefetch(callableStatement, n);
            }
        }
        catch (SQLException sQLException) {
            Class clazz;
            try {
                if (callableStatement != null) {
                    callableStatement.close();
                    if (JDBCInteract.mDoTrace) {
                        JDBCInteract.closeStmt(callableStatement);
                    }
                }
            }
            catch (SQLException sQLException2) {
                // empty catch block
            }
            if (Diagnostic.isOn()) {
                Diagnostic.println("DBTransactionImpl.createCallableStatement failed...");
                Diagnostic.printStackTrace(sQLException);
            }
            if ((clazz = class$oracle$jbo$CSMessageBundle) == null) {
                clazz = class$oracle$jbo$CSMessageBundle = DBTransactionImpl.class$("oracle.jbo.CSMessageBundle");
            }
            throw new SQLStmtException(clazz, "27123", string, sQLException);
        }
        if (InstrumentedEvent.isActive) {
            InstrumentedEvent.endEvent(n2);
        }
        return callableStatement;
    }

    public PreparedStatement createPreparedStatement(String string, int n) {
        int n2 = 0;
        if (InstrumentedEvent.isActive) {
            n2 = InstrumentedEvent.startEvent(EventGroup.JDBC_CREATE_STATEMENT, "createPreparedStatement - prefetch size: " + n);
        }
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = this.mjdbcConnection.prepareStatement(string);
            if (JDBCInteract.mDoTrace) {
                JDBCInteract.prepareStatement(string);
            }
            this.mSQLBuilder.doStatementSetRowPrefetch(preparedStatement, n);
        }
        catch (SQLException sQLException) {
            Class clazz;
            try {
                if (preparedStatement != null) {
                    preparedStatement.close();
                    if (JDBCInteract.mDoTrace) {
                        JDBCInteract.closeStmt(preparedStatement);
                    }
                }
            }
            catch (SQLException sQLException2) {
                // empty catch block
            }
            if (Diagnostic.isOn()) {
                Diagnostic.println("DBTransactionImpl.createPreparedStatement failed...");
                Diagnostic.printStackTrace(sQLException);
            }
            if ((clazz = class$oracle$jbo$CSMessageBundle) == null) {
                clazz = class$oracle$jbo$CSMessageBundle = DBTransactionImpl.class$("oracle.jbo.CSMessageBundle");
            }
            throw new SQLStmtException(clazz, "27122", string, sQLException);
        }
        if (InstrumentedEvent.isActive) {
            InstrumentedEvent.endEvent(n2);
        }
        return preparedStatement;
    }

    public int executeCommand(String string) {
        int n = 0;
        if (InstrumentedEvent.isActive) {
            n = InstrumentedEvent.startEvent(EventGroup.JDBC_EXECUTE, "Raw JDBC execute: '" + string + "'");
        }
        Statement statement = null;
        int n2 = -1;
        if (string == null || string.length() == 0) {
            throw new InvalidParamException(MTH_executeCommand, "command", null, "null command not allowed");
        }
        statement = this.createStatement(1);
        if (JDBCInteract.mDoTrace) {
            JDBCInteract.createStatement();
        }
        this.getSQLBuilder().doStatementSetBindingStyleDefault(statement);
        try {
            n2 = statement.executeUpdate(string);
            if (JDBCInteract.mDoTrace) {
                JDBCInteract.executeUpdate(statement, string);
            }
            statement.close();
            if (JDBCInteract.mDoTrace) {
                JDBCInteract.closeStmt(statement);
            }
            statement = null;
        }
        catch (SQLException sQLException) {
            Class clazz;
            try {
                if (statement != null) {
                    statement.close();
                    if (JDBCInteract.mDoTrace) {
                        JDBCInteract.closeStmt(statement);
                    }
                }
            }
            catch (SQLException sQLException2) {
                // empty catch block
            }
            if (Diagnostic.isOn()) {
                Diagnostic.println("DBTransactionImpl.executeCommand failed...");
                Diagnostic.printStackTrace(sQLException);
            }
            if ((clazz = class$oracle$jbo$CSMessageBundle) == null) {
                clazz = class$oracle$jbo$CSMessageBundle = DBTransactionImpl.class$("oracle.jbo.CSMessageBundle");
            }
            throw new SQLStmtException(clazz, "27121", string, sQLException);
        }
        if (InstrumentedEvent.isActive) {
            InstrumentedEvent.endEvent(n);
        }
        return n2;
    }

    public String dumpQueryResult(String string, String string2, String[] stringArray) {
        if (string2 == null || string2.length() == 0) {
            string2 = "oracle.jbo.server.QueryDumpTab";
        }
        String string3 = null;
        QueryDump queryDump = null;
        try {
            queryDump = (QueryDump)JBOClass.forName(string2).newInstance();
            string3 = queryDump.initialize(string, stringArray);
            if (string3 != null) {
                String string4 = string3;
                return string4;
            }
        }
        catch (Exception exception) {
            Class clazz;
            if (Diagnostic.isOn()) {
                Diagnostic.println("DBTransactionImpl.dumpQueryResult failed...");
                Diagnostic.printStackTrace(exception);
            }
            if ((clazz = class$oracle$jbo$CSMessageBundle) == null) {
                clazz = class$oracle$jbo$CSMessageBundle = DBTransactionImpl.class$("oracle.jbo.CSMessageBundle");
            }
            throw new SQLStmtException(clazz, "27120", string, exception);
        }
        Statement statement = null;
        ResultSet resultSet = null;
        if (string == null || string.length() == 0) {
            throw new InvalidParamException(MTH_dumpQueryResult, "query", null, "null query not allowed");
        }
        statement = this.createStatement(10);
        this.getSQLBuilder().doStatementSetBindingStyleDefault(statement);
        try {
            resultSet = statement.executeQuery(string);
            string3 = queryDump.dumpQueryResult(resultSet, stringArray);
            resultSet.close();
            statement.close();
        }
        catch (Exception exception) {
            Class clazz;
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            if (Diagnostic.isOn()) {
                Diagnostic.println("DBTransactionImpl.dumpQueryResult failed...");
                Diagnostic.printStackTrace(exception);
            }
            if ((clazz = class$oracle$jbo$CSMessageBundle) == null) {
                clazz = class$oracle$jbo$CSMessageBundle = DBTransactionImpl.class$("oracle.jbo.CSMessageBundle");
            }
            throw new SQLStmtException(clazz, "27120", string, exception);
        }
        return string3;
    }

    public int getLockingMode() {
        return this.mLockingMode;
    }

    public void setLockingMode(int n) {
        if (n != 1 && n != 2 && n != 3 && n != 0) {
            throw new IllegalArgumentException();
        }
        this.mLockingMode = n;
    }

    public EntityCache lookupEntityCache(EntityDefImpl entityDefImpl) {
        String string = entityDefImpl.getFullName();
        return (EntityCache)this.mRowCache.get((Object)string);
    }

    public EntityCache findEntityCache(EntityDefImpl entityDefImpl) {
        String string = entityDefImpl.getFullName();
        EntityCache entityCache = (EntityCache)this.mRowCache.get((Object)string);
        if (entityCache == null) {
            entityCache = (EntityCache)JBOClass.newInstance(entityDefImpl.getCollClass());
            entityCache.init(this, entityDefImpl);
            this.mRowCache.put((Object)string, (Object)entityCache);
        }
        return entityCache;
    }

    public EntityCache getEntityCache(EntityDefImpl entityDefImpl) {
        String string = entityDefImpl.getFullName();
        return (EntityCache)this.mRowCache.get((Object)string);
    }

    void clearECacheWithCheck(String string, boolean bl, boolean bl2) {
        if (string == null || string.length() == 0) {
            Iterator iterator = this.mRowCache.keySet().iterator();
            while (iterator.hasNext()) {
                String string2 = (String)iterator.next();
                if (string2 == null) continue;
                this.clearECacheWithCheck(string2, bl, bl2);
            }
        } else {
            EntityCache entityCache = (EntityCache)this.mRowCache.get((Object)string);
            if (bl && entityCache != null && entityCache.getModifiedRows() != null && entityCache.getModifiedRows().size() > 0) {
                if (MetaObjectManager.getSingleton().is323Compatible()) {
                    this.rollback();
                } else {
                    Class clazz = class$oracle$jbo$CSMessageBundle;
                    if (clazz == null) {
                        clazz = class$oracle$jbo$CSMessageBundle = DBTransactionImpl.class$("oracle.jbo.CSMessageBundle");
                    }
                    throw new InvalidOperException(clazz, "25303", new Object[]{string});
                }
            }
            if (entityCache != null) {
                this.clearEntityCacheInternal(entityCache, true, bl2);
            }
        }
    }

    void clearEntityCachesForResetState() {
        Iterator iterator = this.mRowCache.values().iterator();
        while (iterator.hasNext()) {
            this.clearEntityCacheInternal((EntityCache)iterator.next(), false, false);
        }
    }

    private void clearEntityCacheInternal(EntityCache entityCache, boolean bl, boolean bl2) {
        if (entityCache != null) {
            ApplicationModuleImpl applicationModuleImpl;
            String string = entityCache.getEntityDef().getFullName();
            if (Diagnostic.isOn()) {
                Diagnostic.println("Clearing EO cache for " + string);
            }
            if (bl && (applicationModuleImpl = this.getTxnApplicationModuleImpl()) != null) {
                applicationModuleImpl.doClearVOCaches(string, true, bl2);
            }
            entityCache.clearCache();
            if (bl && this.isShared() && !bl2) {
                this.sendOrQueueEventForSharedTrans((HashMap)this.mViewClearCacheListeners, new EntityClearCacheEvent(this, string));
            }
        }
    }

    public void clearEntityCache(String string) {
        this.clearECacheWithCheck(string, true, false);
    }

    private void addDriver(String string) {
        if (Diagnostic.isOn()) {
            Diagnostic.println("addDriver(" + string + ")");
        }
        try {
            Properties properties = System.getProperties();
            String string2 = properties.getProperty("jdbc.drivers");
            string2 = string2 == null ? "" : string2 + ":";
            if (string2.indexOf(string) < 0) {
                if (Diagnostic.isOn()) {
                    Diagnostic.println("*** adding JDBC driver: " + string);
                }
                properties.put("jdbc.drivers", string2 + string);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            JBOClass.forName(string);
            if (Diagnostic.isOn()) {
                Diagnostic.println("Successfully loaded JDBC driver class " + string);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            Class clazz;
            if (Diagnostic.isOn()) {
                Diagnostic.println("DBTransactionImpl.addDriver failed...");
                Diagnostic.printStackTrace(classNotFoundException);
            }
            if ((clazz = class$oracle$jbo$CSMessageBundle) == null) {
                clazz = class$oracle$jbo$CSMessageBundle = DBTransactionImpl.class$("oracle.jbo.CSMessageBundle");
            }
            throw new DMLException(clazz, "26060", null, classNotFoundException);
        }
    }

    public void addToValidationListeners(ValidationListener validationListener) {
        this.mValidationListeners.put((Object)validationListener, (Object)validationListener);
    }

    void removeFromValidationListeners(ValidationListener validationListener) {
        this.mValidationListeners.remove((Object)validationListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void validate() {
        Object object = this.getSyncLock();
        synchronized (object) {
            DBTransactionImpl dBTransactionImpl = this;
            synchronized (dBTransactionImpl) {
                HashMap hashMap = (HashMap)this.mValidationListeners.clone();
                Iterator iterator = hashMap.values().iterator();
                if (!this.mDeferValidation) {
                    while (iterator.hasNext()) {
                        ValidationListener validationListener = (ValidationListener)iterator.next();
                        validationListener.validate();
                        if (!validationListener.isValid()) continue;
                        this.removeFromValidationListeners(validationListener);
                    }
                } else {
                    ArrayList arrayList = null;
                    while (iterator.hasNext()) {
                        ValidationListener validationListener = (ValidationListener)iterator.next();
                        try {
                            validationListener.validate();
                            if (!validationListener.isValid()) continue;
                            this.removeFromValidationListeners(validationListener);
                        }
                        catch (JboException jboException) {
                            if (arrayList == null) {
                                arrayList = new ArrayList();
                            }
                            arrayList.add((Object)jboException);
                        }
                    }
                    if (arrayList != null) {
                        throw new TxnValException(arrayList);
                    }
                }
            }
        }
    }

    public void setValidationThreshold(int n) {
        this.mValidationThreshold = n > 0 ? n : 1;
    }

    boolean applyValidationThreshold() {
        return this.mApplyValidationThreshold;
    }

    public int getValidationThreshold() {
        return this.mValidationThreshold;
    }

    public void setPostThreshold(int n) {
        this.mPostThreshold = n > 0 ? n : 1;
    }

    public int getPostThreshold() {
        return this.mPostThreshold;
    }

    public int getBatchPostExceptionThreshold() {
        return this.mBatchPostThreshold;
    }

    public void setBatchPostExceptionThreshold(int n) {
        this.mBatchPostThreshold = n > 0 ? n : 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean hasTransientTransactionPostListeners() {
        DBTransactionImpl dBTransactionImpl = this;
        synchronized (dBTransactionImpl) {
            int n = 0;
            while (n < this.mTransPostListeners.size()) {
                TransactionPostListener transactionPostListener = (TransactionPostListener)this.mTransPostListeners.get(n);
                if (transactionPostListener.isTransientTransactionPostListener()) {
                    boolean bl = true;
                    return bl;
                }
                ++n;
            }
            boolean bl = false;
            return bl;
        }
    }

    boolean hasObjectsToPost() {
        return this.hasTransientTransactionPostListeners() || this.mValidationListeners.size() > 0;
    }

    public boolean isDirty() {
        return this.mIsDirty;
    }

    public void dumpEntityCaches(Writer writer) {
        Iterator iterator = this.mRowCache.values().iterator();
        while (iterator.hasNext()) {
            ((EntityCache)iterator.next()).dump(writer);
        }
    }

    void closeStatement(PreparedStatement preparedStatement, boolean bl) {
        block7: {
            if (preparedStatement == null) {
                return;
            }
            if (bl) {
                this.removeStatement(preparedStatement, this.isSingleUseStatement(preparedStatement));
            }
            try {
                preparedStatement.close();
                if (JDBCInteract.mDoTrace) {
                    JDBCInteract.closeStmt(preparedStatement);
                }
            }
            catch (SQLException sQLException) {
                Class clazz;
                if (SQLSTATE_72000.equals(sQLException.getSQLState()) || sQLException.getErrorCode() == 17002) break block7;
                if (Diagnostic.isOn()) {
                    Diagnostic.println("DBTransactionImpl.closeStatement failed...");
                    Diagnostic.printStackTrace(sQLException);
                }
                if ((clazz = class$oracle$jbo$CSMessageBundle) == null) {
                    clazz = class$oracle$jbo$CSMessageBundle = DBTransactionImpl.class$("oracle.jbo.CSMessageBundle");
                }
                throw new DMLException(clazz, "26064", null, sQLException);
            }
        }
    }

    PreparedStatement createReUsePreparedStatement(String string, int n) {
        PreparedStatement preparedStatement = this.createPreparedStatement(string, n);
        int n2 = this.mMultiUseStmts.size() + this.mSingleUseStmts.size();
        if (n2 + 1 > this.mMaxCursors - 10) {
            if (Diagnostic.isOn()) {
                Diagnostic.println("Number of cursor available: " + (this.mMaxCursors - n2));
            }
            this.closeFreedStatements();
            if (Diagnostic.isOn()) {
                Diagnostic.println("Number of cursor available: " + (this.mMaxCursors - n2));
            }
        }
        this.addStatement(preparedStatement, ++n2 > this.mMaxCursors - 10);
        return preparedStatement;
    }

    boolean isSingleUseStatement(PreparedStatement preparedStatement) {
        return this.mMultiUseStmts.contains((Object)preparedStatement) ^ true;
    }

    void removeStatement(PreparedStatement preparedStatement, boolean bl) {
        if (bl) {
            this.mSingleUseStmts.remove((Object)preparedStatement);
        } else {
            this.mMultiUseStmts.remove((Object)preparedStatement);
        }
    }

    void addStatement(PreparedStatement preparedStatement, boolean bl) {
        if (bl) {
            this.mSingleUseStmts.add((Object)preparedStatement);
        } else {
            this.mMultiUseStmts.add((Object)preparedStatement);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeFreedStatements() {
        DBTransactionImpl dBTransactionImpl = this;
        synchronized (dBTransactionImpl) {
            if (Diagnostic.isOn()) {
                Diagnostic.println("Closing freed statements...");
            }
            Iterator iterator = this.mRowCache.values().iterator();
            while (iterator.hasNext()) {
                ((EntityCache)iterator.next()).closeFreeStatements();
            }
            TransactionListener[] transactionListenerArray = (TransactionListener[])this.mTransListeners.toArray((Object[])new TransactionListener[this.mTransListeners.size()]);
            int n = 0;
            while (n < transactionListenerArray.length) {
                if (!transactionListenerArray[n].isTransientTransactionListener() && transactionListenerArray[n] instanceof ViewObjectImpl) {
                    ((ViewObjectImpl)transactionListenerArray[n]).closeFreedStatements();
                }
                ++n;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeStatements() {
        DBTransactionImpl dBTransactionImpl = this;
        synchronized (dBTransactionImpl) {
            Iterator iterator = this.mRowCache.values().iterator();
            while (iterator.hasNext()) {
                ((EntityCache)iterator.next()).closeStatements();
            }
            TransactionListener[] transactionListenerArray = (TransactionListener[])this.mTransListeners.toArray((Object[])new TransactionListener[this.mTransListeners.size()]);
            int n = 0;
            while (n < transactionListenerArray.length) {
                if (!transactionListenerArray[n].isTransientTransactionListener() && transactionListenerArray[n] instanceof ViewObjectImpl) {
                    ((ViewObjectImpl)transactionListenerArray[n]).closeStatements();
                }
                ++n;
            }
        }
    }

    public void showCursorUsage(Writer writer) {
        PrintWriter printWriter = new PrintWriter(writer, true);
        printWriter.println("Number of max cursors: " + this.mMaxCursors);
        printWriter.println("Number of open cursors: " + (this.mMultiUseStmts.size() + this.mSingleUseStmts.size()));
        ViewObject[] viewObjectArray = this.getTxnApplicationModuleImpl().getViewObjects();
        ArrayList arrayList = new ArrayList();
        int n = 0;
        while (n < viewObjectArray.length) {
            EntityDefImpl[] entityDefImplArray = ((ViewObjectImpl)viewObjectArray[n]).getViewDef().getEntityDefs();
            int n2 = 0;
            while (n2 < entityDefImplArray.length) {
                if (!arrayList.contains((Object)entityDefImplArray[n2])) {
                    arrayList.add((Object)entityDefImplArray[n2]);
                }
                ++n2;
            }
            ++n;
        }
        int n3 = 0;
        while (n3 < arrayList.size()) {
            String string = ((EntityDefImpl)arrayList.get(n3)).getFullName();
            EntityCache entityCache = (EntityCache)this.mRowCache.get((Object)string);
            if (entityCache != null) {
                printWriter.println("+++++ " + string + " +++++");
                entityCache.showCursorUsage(writer);
            }
            ++n3;
        }
    }

    protected void doCommit() {
        if (this.mTxnHandler != null) {
            this.mTxnHandler.handleCommit(this.mjdbcConnection, false);
        }
        this.mIsDirty = false;
        this.transitionToState(5);
    }

    protected void doRollback() {
        if (this.mTxnHandler != null) {
            this.mTxnHandler.handleRollback(this.mjdbcConnection, false);
        }
        this.transitionToState(5);
    }

    public void connect(Connection connection) {
        throw new AlreadyConnectedException();
    }

    public void connect(String string) {
        throw new AlreadyConnectedException();
    }

    public void connect(String string, Properties properties) {
        throw new AlreadyConnectedException();
    }

    public void connect(String string, String string2, String string3) {
        throw new AlreadyConnectedException();
    }

    public void connectToDataSource(String string, String string2, String string3, String string4) {
        throw new AlreadyConnectedException();
    }

    public void connectToDataSource(String string, String string2, String string3, String string4, String string5, String string6) {
        throw new AlreadyConnectedException();
    }

    public void connectToDataSource(DataSource dataSource, boolean bl) {
        throw new AlreadyConnectedException();
    }

    public void connectToDataSource(DataSource dataSource, String string, String string2, boolean bl) {
        throw new AlreadyConnectedException();
    }

    public void connectToDataSource(Hashtable hashtable, String string, String string2, String string3, boolean bl) {
        throw new AlreadyConnectedException();
    }

    public void connectToDataSource(Hashtable hashtable, String string, boolean bl) {
        throw new AlreadyConnectedException();
    }

    void refreshConnectionMetadata() {
        if (this.mjdbcConnection != null) {
            String string;
            String string2 = null;
            if (this.mConnectionCredentials.mDataSource != null) {
                string2 = String.valueOf(this.mConnectionCredentials.mDataSource.hashCode());
            }
            if (((string = this.mConnectionCredentials.mjdbcUser) == null || string.length() <= 0) && this.mConnectionCredentials.mjdbcInfo != null) {
                string = (String)this.mConnectionCredentials.mjdbcInfo.get("user");
            }
            this.mjdbcConnectionMetadata = new ConnectionMetadata(string, this.mConnectionCredentials.mjdbcURL, string2);
            TimeZone timeZone = null;
            LocaleContext localeContext = this.getSession().getLocaleContext();
            if (localeContext != null) {
                timeZone = localeContext.getUserTimeZone();
            }
            if (timeZone != null) {
                this.getSQLBuilder().setSessionTimeZone(this.mjdbcConnection, timeZone.getID());
            } else {
                this.getSQLBuilder().setSessionTimeZone(this.mjdbcConnection, TimeZone.getDefault().getID());
            }
        } else {
            this.mjdbcConnectionMetadata = null;
        }
    }

    public ConnectionMetadata getConnectionMetadata() {
        return this.mjdbcConnectionMetadata;
    }

    public boolean isConnected() {
        boolean bl;
        boolean bl2 = bl = this.mjdbcConnection != null && this.mIsConnected;
        if (bl && !"false".equals(this.getTxnApplicationModuleImpl().getSession().getEnvironment().get(PropertyMetadata.ENV_BC4J_CONNECT_FAILOVER.pName))) {
            this.mIsConnected = bl = this.getSQLBuilder().isConnectionAlive(this.mjdbcConnection);
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect(boolean bl) {
        Object object = this.getSyncLock();
        synchronized (object) {
            DBTransactionImpl dBTransactionImpl = this;
            synchronized (dBTransactionImpl) {
                if (bl) {
                    TransactionListener[] transactionListenerArray = (TransactionListener[])this.mTransListeners.toArray((Object[])new TransactionListener[this.mTransListeners.size()]);
                    int n = 0;
                    while (n < transactionListenerArray.length) {
                        if (!transactionListenerArray[n].isTransientTransactionListener() && transactionListenerArray[n] instanceof ViewObjectImpl) {
                            ViewObjectImpl viewObjectImpl = (ViewObjectImpl)transactionListenerArray[n];
                            Enumeration enumeration = viewObjectImpl.getAllCachedQueryCollections();
                            while (enumeration.hasMoreElements()) {
                                QueryCollection queryCollection = (QueryCollection)enumeration.nextElement();
                                if (!queryCollection.hasResultSet()) continue;
                                String string = JboEnvUtil.getProperty(PropertyMetadata.ENV_DISCONNECT_LEVEL.pName, PropertyMetadata.ENV_DISCONNECT_LEVEL.pDefault);
                                int n2 = new Integer(string);
                                if ((n2 & 1) > 0) {
                                    queryCollection.disconnect();
                                    continue;
                                }
                                Class clazz = class$oracle$jbo$CSMessageBundle;
                                if (clazz == null) {
                                    clazz = class$oracle$jbo$CSMessageBundle = DBTransactionImpl.class$("oracle.jbo.CSMessageBundle");
                                }
                                throw new JboException(clazz, "25224", null);
                            }
                        }
                        ++n;
                    }
                    this.getTxnApplicationModuleImpl().passivateConnectionState(null);
                    this.closePCollManager(1);
                    this.closeTransaction();
                } else {
                    ApplicationModuleImpl applicationModuleImpl = this.getTxnApplicationModuleImpl();
                    try {
                        this.closeTransaction();
                        Object var17_12 = null;
                        this.getTxnApplicationModuleImpl().txnRemoved(this);
                    }
                    catch (Throwable throwable) {
                        Object var17_13 = null;
                        this.getTxnApplicationModuleImpl().txnRemoved(this);
                        throw throwable;
                    }
                    int n = this.getTransactionState();
                    int n3 = 0x10 | (n == 1 || n == 4 ? 1 : 0);
                    applicationModuleImpl.resetState(n3);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reconnect() {
        Object object = this.getSyncLock();
        synchronized (object) {
            DBTransactionImpl dBTransactionImpl = this;
            synchronized (dBTransactionImpl) {
                if (!this.mIsConnected) {
                    if (this.mjdbcConnection != null) {
                        this.disconnect(true);
                    }
                    if (this.mConnectionCredentials.mCredentialsOK) {
                        ApplicationModuleImpl applicationModuleImpl = this.getTxnApplicationModuleImpl();
                        if (!applicationModuleImpl.isLoaded()) {
                            applicationModuleImpl.resetState(18);
                        }
                        TransactionHandler transactionHandler = this.mConnectionCredentials.mIsJTABased ? DBTransactionImpl.createJTATransactionHandler(applicationModuleImpl) : DBTransactionImpl.createTransactionHandler(applicationModuleImpl);
                        this.setTransactionHandler(transactionHandler);
                        this.beginTransaction();
                        this.initTransaction();
                        this.registerSynchronization();
                        applicationModuleImpl.callAfterConnect();
                        applicationModuleImpl.activateConnectionState();
                    } else {
                        throw new NotConnectedException();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reconnect(boolean bl) {
        Object object = this.getSyncLock();
        synchronized (object) {
            DBTransactionImpl dBTransactionImpl = this;
            synchronized (dBTransactionImpl) {
                if (bl || !this.mIsConnected) {
                    ApplicationModuleImpl applicationModuleImpl = this.getTxnApplicationModuleImpl();
                    applicationModuleImpl.resetState(18);
                    this.closeTransaction();
                    DBTransactionImpl dBTransactionImpl2 = DatabaseTransactionFactory.getFactory().create(this.mConnectionCredentials.mjdbcURL, this.mConnectionCredentials.mjdbcUser, this.mConnectionCredentials.mjdbcPassword, this.mConnectionCredentials.mjdbcInfo);
                    DBTransactionImpl.initTxn(applicationModuleImpl, dBTransactionImpl2, this.getTransactionHandler());
                }
            }
        }
    }

    public void disconnect() {
        this.disconnect(false);
    }

    public TransactionHandler getTransactionHandler() {
        return this.mTxnHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTransactionHandler(TransactionHandler transactionHandler) {
        Object object = this.getSyncLock();
        synchronized (object) {
            DBTransactionImpl dBTransactionImpl = this;
            synchronized (dBTransactionImpl) {
                if (transactionHandler == null) {
                    throw new IllegalArgumentException();
                }
                if (transactionHandler != this.mTxnHandler) {
                    this.mTxnHandler = transactionHandler;
                    this.registerSynchronization();
                }
            }
        }
    }

    Object getCurrentSessionContext() {
        return SessionImpl.getCurrentSessionContext();
    }

    final boolean isShared() {
        return this.mIsShared;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void addPendingEvent(Object object, EventObject eventObject) {
        if (this.mIsShared) {
            DBTransactionImpl dBTransactionImpl = this;
            synchronized (dBTransactionImpl) {
                HashMap hashMap = (HashMap)this.mCallback;
                SessionTransInfo sessionTransInfo = (SessionTransInfo)hashMap.get(object);
                sessionTransInfo.addPendingEvent(eventObject);
            }
        } else {
            Diagnostic.ASSERT(false, "addPendingEvents called on a non-shared transaction");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final synchronized void processPendingEvents() {
        if (this.mIsShared) {
            DBTransactionImpl dBTransactionImpl = this;
            synchronized (dBTransactionImpl) {
                if (!this.mIsProcPendingEvents) {
                    this.mIsProcPendingEvents = true;
                    try {
                        HashMap hashMap = (HashMap)this.mCallback;
                        Object object = this.getCurrentSessionContext();
                        SessionTransInfo sessionTransInfo = (SessionTransInfo)hashMap.get(object);
                        sessionTransInfo.processPendingEvents();
                        Object var6_5 = null;
                        this.mIsProcPendingEvents = false;
                    }
                    catch (Throwable throwable) {
                        Object var6_6 = null;
                        this.mIsProcPendingEvents = false;
                        throw throwable;
                    }
                }
            }
        }
        Diagnostic.ASSERT(false, "processPendingEvents called on a non-shared transaction");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setTxnApplicationModuleImpl(ApplicationModuleImpl applicationModuleImpl) {
        if (applicationModuleImpl == null) {
            if (!this.isShared()) {
                this.mCallback = null;
            } else {
                DBTransactionImpl dBTransactionImpl = this;
                synchronized (dBTransactionImpl) {
                    HashMap hashMap = (HashMap)this.mCallback;
                    if (hashMap != null) {
                        hashMap.remove(this.getCurrentSessionContext());
                    }
                }
            }
            return;
        }
        this.mIsShared = applicationModuleImpl.isTransactionShared();
        if (!this.mIsShared) {
            if (applicationModuleImpl != this.mCallback) {
                this.mCallback = applicationModuleImpl;
                this.processProperties();
                if (this.mPCollMgr != null) {
                    this.mPCollMgr.setName(applicationModuleImpl.getName());
                }
            }
        } else {
            DBTransactionImpl dBTransactionImpl = this;
            synchronized (dBTransactionImpl) {
                Object object;
                HashMap hashMap;
                boolean bl = false;
                if (this.mCallback == null) {
                    this.mCallback = new HashMap(4);
                    bl = true;
                }
                if ((hashMap = (HashMap)this.mCallback).get(object = this.getCurrentSessionContext()) == null) {
                    SessionTransInfo sessionTransInfo = new SessionTransInfo(object, applicationModuleImpl);
                    hashMap.put(object, (Object)sessionTransInfo);
                }
                if (bl) {
                    this.processProperties();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ApplicationModuleImpl getTxnApplicationModuleImpl() {
        if (!this.isShared()) {
            return (ApplicationModuleImpl)this.mCallback;
        }
        DBTransactionImpl dBTransactionImpl = this;
        synchronized (dBTransactionImpl) {
            if (this.mCallback != null) {
                HashMap hashMap = (HashMap)this.mCallback;
                SessionTransInfo sessionTransInfo = (SessionTransInfo)hashMap.get(this.getCurrentSessionContext());
                ApplicationModuleImpl applicationModuleImpl = sessionTransInfo.getTxnApplicationModuleImpl();
                return applicationModuleImpl;
            }
        }
        return null;
    }

    public ApplicationModule getRootApplicationModule() {
        return this.getTxnApplicationModuleImpl();
    }

    public EntityImpl createEntityInstance(EntityDefImpl entityDefImpl, AttributeList attributeList) {
        return entityDefImpl.createInstance(this, attributeList);
    }

    public EntityImpl createEntityInstance(String string, AttributeList attributeList) {
        return EntityDefImpl.findDefObject(string).createInstance(this, attributeList);
    }

    public EntityImpl findByPrimaryKey(EntityDefImpl entityDefImpl, Key key) {
        return entityDefImpl.findByPrimaryKey(this, key);
    }

    public EntityImpl findByPrimaryKey(String string, Key key) {
        return EntityDefImpl.findDefObject(string).findByPrimaryKey(this, key);
    }

    public ApplicationModule createApplicationModule(String string, String string2) {
        if (string == null || string.trim().length() == 0) {
            throw new InvalidObjNameException(101, string);
        }
        return this.getTxnApplicationModuleImpl().createApplicationModule("TXN_" + string, string2);
    }

    public ApplicationModule findApplicationModule(String string) {
        if (string == null || string.trim().length() == 0) {
            throw new InvalidObjNameException(101, string);
        }
        return this.getTxnApplicationModuleImpl().findApplicationModule("TXN_" + string);
    }

    public ViewObject createViewObject(String string) {
        return this.getTxnApplicationModuleImpl().createViewObject(null, string);
    }

    public ViewObject createViewObjectFromQueryClauses(String string, String string2, String string3, String string4, String string5) {
        return this.getTxnApplicationModuleImpl().createViewObjectFromQueryClauses("", string, string2, string3, string4, string5);
    }

    public ViewObject createViewObjectFromQueryStmt(String string) {
        return this.getTxnApplicationModuleImpl().createViewObjectFromQueryStmt("", string);
    }

    public ApplicationModule createApplicationModule(String string) {
        int n = 0;
        if (InstrumentedEvent.isActive) {
            n = InstrumentedEvent.startEvent(EventGroup.BC4J_CREATE_AM, "Create Application Module '" + string + "'");
        }
        ApplicationModule applicationModule = this.getTxnApplicationModuleImpl().createApplicationModule(null, string);
        if (InstrumentedEvent.isActive) {
            InstrumentedEvent.endEvent(n);
        }
        return applicationModule;
    }

    public ViewLink createViewLink(String string, ViewObject viewObject, ViewObject viewObject2) {
        return this.getTxnApplicationModuleImpl().createViewLink(null, string, viewObject, viewObject2);
    }

    public ViewLink createViewLinkFromEntityAssocName(String string, ViewObject viewObject, ViewObject viewObject2) {
        return this.getTxnApplicationModuleImpl().createViewLinkFromEntityAssocName(null, string, viewObject, viewObject2);
    }

    public ViewLink createViewLinkBetweenViewObjects(String string, ViewObject viewObject, AttributeDef[] attributeDefArray, ViewObject viewObject2, AttributeDef[] attributeDefArray2, String string2) {
        return this.getTxnApplicationModuleImpl().createViewLinkBetweenViewObjects(null, string, viewObject, attributeDefArray, viewObject2, attributeDefArray2, string2);
    }

    public void addWarning(JboWarning jboWarning) {
        this.getTxnApplicationModuleImpl().addWarning(jboWarning);
    }

    public Session getSession() {
        return this.getTxnApplicationModuleImpl().getSession();
    }

    protected Connection getJdbcConnection() {
        return this.mjdbcConnection;
    }

    public Object createRef(String string, byte[] byArray) {
        try {
            REF rEF = new REF(new StructDescriptor(string, this.mjdbcConnection), this.mjdbcConnection, byArray);
            return rEF;
        }
        catch (Exception exception) {
            Class clazz = class$oracle$sql$REF;
            if (clazz == null) {
                clazz = class$oracle$sql$REF = DBTransactionImpl.class$("oracle.sql.REF");
            }
            throw new DataCreationException(clazz.getName(), exception);
        }
    }

    private void registerSynchronization() {
        if (this.mTxnHandler instanceof JTATransactionHandler) {
            ((JTATransactionHandler)this.mTxnHandler).registerSynchronization(this);
        }
    }

    private String getSavepointId() {
        String string = "BO_SP";
        return string;
    }

    private Object addListenerInternal(Object object, Object object2) {
        ArrayList arrayList;
        if (object == null) {
            Object object3 = object = !this.isShared() ? (Object)new ArrayList(4) : (Object)new HashMap(4);
        }
        if (!this.isShared()) {
            arrayList = (ArrayList)object;
        } else {
            Object object4 = this.getCurrentSessionContext();
            arrayList = (ArrayList)((HashMap)object).get(object4);
            if (arrayList == null) {
                arrayList = new ArrayList(4);
                ((HashMap)object).put(object4, (Object)arrayList);
            }
        }
        if (!arrayList.contains(object2)) {
            arrayList.add(object2);
        }
        return object;
    }

    private Object removeListenerInternal(Object object, Object object2) {
        ArrayList arrayList;
        if (object == null) {
            return null;
        }
        Object object3 = null;
        if (!this.isShared()) {
            arrayList = (ArrayList)object;
        } else {
            object3 = this.getCurrentSessionContext();
            arrayList = (ArrayList)((HashMap)object).get(object3);
        }
        if (arrayList != null && arrayList.contains(object2)) {
            arrayList.remove(object2);
            if (arrayList.size() == 0) {
                if (!this.isShared()) {
                    object = null;
                } else {
                    ((HashMap)object).remove(object3);
                    if (((HashMap)object).isEmpty()) {
                        object = null;
                    }
                }
            }
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTransactionStateListener(TransactionStateListener transactionStateListener) {
        Object object = this.getSyncLock();
        synchronized (object) {
            DBTransactionImpl dBTransactionImpl = this;
            synchronized (dBTransactionImpl) {
                this.mTxnStateListeners = this.addListenerInternal(this.mTxnStateListeners, transactionStateListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTransactionStateListener(TransactionStateListener transactionStateListener) {
        Object object = this.getSyncLock();
        synchronized (object) {
            DBTransactionImpl dBTransactionImpl = this;
            synchronized (dBTransactionImpl) {
                this.mTxnStateListeners = this.removeListenerInternal(this.mTxnStateListeners, transactionStateListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addViewClearCacheListener(ViewClearCacheListener viewClearCacheListener) {
        Object object = this.getSyncLock();
        synchronized (object) {
            DBTransactionImpl dBTransactionImpl = this;
            synchronized (dBTransactionImpl) {
                this.mViewClearCacheListeners = this.addListenerInternal(this.mViewClearCacheListeners, viewClearCacheListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeViewClearCacheListener(ViewClearCacheListener viewClearCacheListener) {
        Object object = this.getSyncLock();
        synchronized (object) {
            DBTransactionImpl dBTransactionImpl = this;
            synchronized (dBTransactionImpl) {
                this.mViewClearCacheListeners = this.removeListenerInternal(this.mViewClearCacheListeners, viewClearCacheListener);
            }
        }
    }

    void sendEvent(ArrayList arrayList, EventObject eventObject) {
        block6: {
            block5: {
                if (!(eventObject instanceof TransactionStateEvent)) break block5;
                TransactionStateEvent transactionStateEvent = (TransactionStateEvent)eventObject;
                if (transactionStateEvent.getEventType() == 1) {
                    int n = 0;
                    while (n < arrayList.size()) {
                        ((TransactionStateListener)arrayList.get(n)).doneCommit(transactionStateEvent);
                        ++n;
                    }
                } else {
                    int n = 0;
                    while (n < arrayList.size()) {
                        ((TransactionStateListener)arrayList.get(n)).doneRollback(transactionStateEvent);
                        ++n;
                    }
                }
                break block6;
            }
            if (!(eventObject instanceof ViewClearCacheEvent)) break block6;
            ViewClearCacheEvent viewClearCacheEvent = (ViewClearCacheEvent)eventObject;
            int n = 0;
            while (n < arrayList.size()) {
                ((ViewClearCacheListener)arrayList.get(n)).cacheCleared(viewClearCacheEvent);
                ++n;
            }
        }
    }

    void sendEventForSharedTrans(HashMap hashMap, Object object, EventObject eventObject) {
        this.sendEvent((ArrayList)hashMap.get(object), eventObject);
    }

    void sendOrQueueEventForSharedTrans(HashMap hashMap, EventObject eventObject) {
        Iterator iterator = hashMap.keySet().iterator();
        Object object = this.getCurrentSessionContext();
        while (iterator.hasNext()) {
            Object object2 = iterator.next();
            if (object2 == object) {
                this.sendEventForSharedTrans(hashMap, object2, eventObject);
                continue;
            }
            this.addPendingEvent(object2, eventObject);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fireTransactionStateEvent(int n, boolean bl) {
        DBTransactionImpl dBTransactionImpl = this;
        synchronized (dBTransactionImpl) {
            if (bl) {
                if (this.isShared()) {
                    this.sendOrQueueEventForSharedTrans((HashMap)this.mViewClearCacheListeners, new EntityClearCacheEvent(this, null));
                }
                this.fireViewClearCacheEvent(null);
            }
            if (this.mTxnStateListeners == null) {
                return;
            }
            TransactionStateEvent transactionStateEvent = new TransactionStateEvent(this, n, bl);
            if (!this.isShared()) {
                this.sendEvent((ArrayList)this.mTxnStateListeners, transactionStateEvent);
            } else {
                this.sendOrQueueEventForSharedTrans((HashMap)this.mTxnStateListeners, transactionStateEvent);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fireViewClearCacheEvent(ViewObject[] viewObjectArray) {
        DBTransactionImpl dBTransactionImpl = this;
        synchronized (dBTransactionImpl) {
            if (this.mViewClearCacheListeners == null) {
                return;
            }
            ViewClearCacheEvent viewClearCacheEvent = new ViewClearCacheEvent(this, viewObjectArray);
            if (!this.isShared()) {
                this.sendEvent((ArrayList)this.mViewClearCacheListeners, viewClearCacheEvent);
            } else {
                this.sendEventForSharedTrans((HashMap)this.mViewClearCacheListeners, this.getCurrentSessionContext(), viewClearCacheEvent);
            }
        }
    }

    private void closeLockStatements() {
        Iterator iterator = this.mRowCache.values().iterator();
        while (iterator.hasNext()) {
            ((EntityCache)iterator.next()).closeLockStatement();
        }
    }

    public Timestamp getCurrentDbTime() {
        long l = System.currentTimeMillis();
        if (!this.mInitDbTime) {
            Timestamp timestamp = this.mSQLBuilder.getCurrentDbTime(this.mjdbcConnection);
            if (timestamp != null) {
                this.mDbTimeDelta = ((Date)timestamp).getTime() - l;
            }
            if (Diagnostic.isOn()) {
                if (timestamp != null) {
                    Diagnostic.println("Db Time is: " + timestamp.toString() + ", " + ((Date)timestamp).getTime());
                }
                Diagnostic.println("JVM Time is: " + new Timestamp(l) + ", " + l);
                Diagnostic.println("DbTime delta: " + this.mDbTimeDelta);
            }
            this.mInitDbTime = true;
        }
        return new Timestamp(l + this.mDbTimeDelta);
    }

    public void setTrackNewAndModifiedRowsOnly(boolean bl) {
        this.mTrackNewAndModified = bl;
    }

    public boolean isTrackNewAndModifiedRowsOnly() {
        return this.mTrackNewAndModified;
    }

    public final void setPostChangesFlag(int n) {
        this.mPostAll = n;
    }

    public final int getPostChangesFlag() {
        return this.mPostAll;
    }

    protected void checkConnected() throws NotConnectedException {
        if (this.mjdbcConnection == null) {
            throw new NotConnectedException();
        }
    }

    static TransactionHandler createTransactionHandler(ApplicationModuleImpl applicationModuleImpl) {
        SessionImpl sessionImpl = (SessionImpl)applicationModuleImpl.getSession();
        TransactionHandlerFactory transactionHandlerFactory = sessionImpl.getTransactionHandlerFactory();
        return transactionHandlerFactory.createTransactionHandler();
    }

    static JTATransactionHandler createJTATransactionHandler(ApplicationModuleImpl applicationModuleImpl) {
        SessionImpl sessionImpl = (SessionImpl)applicationModuleImpl.getSession();
        TransactionHandlerFactory transactionHandlerFactory = sessionImpl.getTransactionHandlerFactory();
        return transactionHandlerFactory.createJTATransactionHandler();
    }

    static void initTxn(ApplicationModuleImpl applicationModuleImpl, DBTransactionImpl dBTransactionImpl, TransactionHandler transactionHandler) {
        if (!applicationModuleImpl.isLoaded()) {
            applicationModuleImpl.resetState(18);
        }
        dBTransactionImpl.setTxnApplicationModuleImpl(applicationModuleImpl);
        if (transactionHandler != null) {
            dBTransactionImpl.setTransactionHandler(transactionHandler);
        }
        dBTransactionImpl.beginTransaction();
        dBTransactionImpl.initTransaction();
        applicationModuleImpl.txnCreated(dBTransactionImpl);
    }

    void beginTransaction() {
        if (this.getTransactionState() == 2) {
            this.initPCollManager();
        }
        this.transitionToState(4);
    }

    public boolean isConnected(boolean bl) {
        if (bl) {
            return this.isConnected();
        }
        return this.mIsConnected;
    }

    void setJdbcConnection(Connection connection) {
        this.mjdbcConnection = connection;
        this.mIsConnected = connection != null;
    }

    void transitionToState(int n) {
        if (this.mTransactionState == n || this.mTransactionState == 2 && n == 5) {
            return;
        }
        if (n == 4 || n == 1) {
            if (this.getTransactionHandler() == null) {
                ApplicationModuleImpl applicationModuleImpl = this.getTxnApplicationModuleImpl();
                TransactionHandler transactionHandler = this.mConnectionCredentials.mIsJTABased ? DBTransactionImpl.createJTATransactionHandler(applicationModuleImpl) : DBTransactionImpl.createTransactionHandler(applicationModuleImpl);
                this.setTransactionHandler(transactionHandler);
            }
            if (n == 4) {
                this.getTransactionHandler().begin();
            }
        }
        this.setTransactionState(n);
    }

    void setTransactionState(int n) {
        this.mTransactionState = n;
    }

    protected int getTransactionState() {
        return this.mTransactionState;
    }

    void beginActivation() {
        if (this.mTxnHandler != null) {
            this.mTxnHandler.beginActivation();
        }
    }

    void endActivation() {
        if (this.mTxnHandler != null) {
            this.mTxnHandler.endActivation();
        }
    }

    void beginPassivation() {
        if (this.mTxnHandler != null) {
            this.mTxnHandler.beginPassivation();
        }
    }

    void endPassivation() {
        if (this.mTxnHandler != null) {
            this.mTxnHandler.endPassivation();
        }
    }

    public int getDMLOperationTimeOut() {
        return this.mDMLOperationTimeOut;
    }

    public void setDMLOperationTimeOut(int n) {
        this.mDMLOperationTimeOut = n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addLongRunningDMLOperationHandle(LongRunningStatementHandle longRunningStatementHandle) {
        List list = this.mLongRunningDMLOperationHandles;
        synchronized (list) {
            this.mLongRunningDMLOperationHandles.add((Object)longRunningStatementHandle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeLongRunningDMLOperationHandle(LongRunningStatementHandle longRunningStatementHandle) {
        List list = this.mLongRunningDMLOperationHandles;
        synchronized (list) {
            Iterator iterator = this.mLongRunningDMLOperationHandles.iterator();
            while (iterator.hasNext()) {
                LongRunningStatementHandle longRunningStatementHandle2 = (LongRunningStatementHandle)iterator.next();
                if (longRunningStatementHandle2 != longRunningStatementHandle) continue;
                iterator.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean cancelDMLOperations() {
        boolean bl = true;
        List list = this.mLongRunningDMLOperationHandles;
        synchronized (list) {
            Iterator iterator = this.mLongRunningDMLOperationHandles.iterator();
            while (iterator.hasNext()) {
                LongRunningStatementHandle longRunningStatementHandle = (LongRunningStatementHandle)iterator.next();
                bl = bl && longRunningStatementHandle.cancel();
                iterator.remove();
            }
        }
        return bl;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public class SessionTransInfo {
        Object mSessionContext;
        ApplicationModuleImpl mAppModule;
        ArrayList mPendingEvents;

        SessionTransInfo(Object object, ApplicationModuleImpl applicationModuleImpl) {
            this.mSessionContext = object;
            this.mAppModule = applicationModuleImpl;
            this.mPendingEvents = null;
        }

        final ApplicationModuleImpl getTxnApplicationModuleImpl() {
            return this.mAppModule;
        }

        final ArrayList getPendingEvents() {
            return this.mPendingEvents;
        }

        final void addPendingEvent(EventObject eventObject) {
            if (this.mPendingEvents == null) {
                this.mPendingEvents = new ArrayList(4);
            }
            this.mPendingEvents.add((Object)eventObject);
            ++this.mAppModule.mNumPendingEvents;
        }

        final void processPendingEvents() {
            if (this.mPendingEvents != null) {
                while (this.mPendingEvents.size() > 0) {
                    EventObject eventObject = (EventObject)this.mPendingEvents.get(0);
                    if (eventObject instanceof EntityEvent) {
                        EntityEvent entityEvent = (EntityEvent)eventObject;
                        EntityImpl entityImpl = entityEvent.getEntity();
                        EntityCache entityCache = entityImpl.getEntityCache();
                        entityCache.sendEventForSharedTrans(this.mSessionContext, entityEvent);
                    } else if (eventObject instanceof TransactionStateEvent) {
                        DBTransactionImpl.this.sendEventForSharedTrans((HashMap)DBTransactionImpl.this.mTxnStateListeners, this.mSessionContext, eventObject);
                    } else if (eventObject instanceof EntityClearCacheEvent) {
                        this.mAppModule.doClearVOCaches(((EntityClearCacheEvent)eventObject).getEntityName(), true, false);
                    }
                    this.mPendingEvents.remove(0);
                    --this.mAppModule.mNumPendingEvents;
                }
                this.mPendingEvents = null;
            }
        }
    }
}

