/*
 * Decompiled with CFR 0.152.
 */
package oracle.jbo.mom.xml;

import com.sun.java.util.collections.HashMap;
import com.sun.java.util.collections.Iterator;
import java.util.Enumeration;
import java.util.Hashtable;
import oracle.jbo.common.JboEnvUtil;
import oracle.jbo.mom.xml.DefPersistable;
import oracle.jbo.mom.xml.DefPersistenceException;
import oracle.jbo.mom.xml.DefWriter;
import oracle.jbo.mom.xml.PersistentDefinition;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Element;

public class ElementDefWriter
implements DefWriter {
    protected Element _element;

    public ElementDefWriter(Element element) {
        this._element = element;
    }

    public void writeObject(DefPersistable defPersistable) throws DefPersistenceException {
        Element element = this._element.getOwnerDocument().createElement(defPersistable.getXMLElementTag());
        this._element.appendChild(element);
        ElementDefWriter elementDefWriter = new ElementDefWriter(element);
        defPersistable.writeContents(elementDefWriter);
        defPersistable.writeChildren(elementDefWriter);
    }

    public void writeUserObject(String string, String string2) throws DefPersistenceException {
        Element element = this._element.getOwnerDocument().createElement(string);
        this._element.appendChild(element);
        CDATASection cDATASection = this._element.getOwnerDocument().createCDATASection(string2);
        element.appendChild(cDATASection);
    }

    public boolean writeObject(String string, Object object) {
        if (object instanceof DefPersistable) {
            try {
                ((DefPersistable)object).writeObject(this);
                boolean bl = true;
                return bl;
            }
            catch (DefPersistenceException defPersistenceException) {
                boolean bl = false;
                return bl;
            }
        }
        return true;
    }

    public boolean writeTable(DefPersistable defPersistable, String string, HashMap hashMap) {
        return this.writeTable(defPersistable, string, "Property", "Name", "Value", hashMap);
    }

    public boolean writeTable(DefPersistable defPersistable, String string, Hashtable hashtable) {
        return this.writeTable(defPersistable, string, "Property", "Name", "Value", JboEnvUtil.convertHashTableToHashMap(hashtable));
    }

    public boolean writeTable(DefPersistable defPersistable, String string, String string2, String string3, String string4, HashMap hashMap) {
        if (hashMap == null || hashMap.size() <= 0) {
            return true;
        }
        Element element = this._element.getOwnerDocument().createElement(string);
        this._element.appendChild(element);
        Iterator iterator = hashMap.keySet().iterator();
        while (iterator.hasNext()) {
            String string5 = (String)iterator.next();
            String string6 = (String)hashMap.get((Object)string5);
            Element element2 = this._element.getOwnerDocument().createElement(string2);
            element2.setAttribute(string3, string5);
            element2.setAttribute(string4, string6);
            element.appendChild(element2);
        }
        return true;
    }

    public boolean writeTable(DefPersistable defPersistable, String string, String string2, String string3, String string4, Hashtable hashtable) {
        return this.writeTable(defPersistable, string, string2, string3, string4, JboEnvUtil.convertHashTableToHashMap(hashtable));
    }

    public boolean writeString(String string, String string2) {
        if (string == null || string2 == null) {
            return false;
        }
        if (string.equals("xmlns")) {
            Attr attr = this._element.getOwnerDocument().createAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns");
            attr.setValue(string2);
            this._element.setAttributeNode(attr);
        } else {
            this._element.setAttribute(string, string2);
        }
        return true;
    }

    public boolean writeUserString(String string, String string2) {
        return this.writeString(string, string2);
    }

    public boolean writeStringArray(String string, Iterator iterator) {
        if (string == null || iterator == null) {
            return false;
        }
        Element element = this._element.getOwnerDocument().createElement("AttrArray");
        this._element.appendChild(element);
        element.setAttribute("Name", string);
        while (iterator.hasNext()) {
            String string2 = "";
            Object object = iterator.next();
            if (object instanceof DefPersistable) {
                string2 = ((DefPersistable)object).getFullName();
            } else if (object != null) {
                string2 = object.toString();
            }
            Element element2 = this._element.getOwnerDocument().createElement("Item");
            element.appendChild(element2);
            element2.setAttribute("Value", string2);
        }
        return true;
    }

    public boolean writeStringArray(String string, Enumeration enumeration) {
        if (string == null || enumeration == null) {
            return false;
        }
        Element element = this._element.getOwnerDocument().createElement("AttrArray");
        this._element.appendChild(element);
        element.setAttribute("Name", string);
        while (enumeration.hasMoreElements()) {
            String string2 = "";
            Object e = enumeration.nextElement();
            if (e instanceof DefPersistable) {
                string2 = ((DefPersistable)e).getFullName();
            } else if (e != null) {
                string2 = e.toString();
            }
            Element element2 = this._element.getOwnerDocument().createElement("Item");
            element.appendChild(element2);
            element2.setAttribute("Value", string2);
        }
        return true;
    }

    public boolean writeInt(String string, int n) {
        String string2 = String.valueOf(n);
        return this.writeString(string, string2);
    }

    public boolean writeShort(String string, short s) {
        String string2 = String.valueOf(s);
        return this.writeString(string, string2);
    }

    public boolean writeLong(String string, long l) {
        String string2 = String.valueOf(l);
        return this.writeString(string, string2);
    }

    public boolean writeFloat(String string, float f) {
        String string2 = String.valueOf(f);
        return this.writeString(string, string2);
    }

    public boolean writeDouble(String string, double d) {
        String string2 = String.valueOf(d);
        return this.writeString(string, string2);
    }

    public boolean writeBoolean(String string, boolean bl) {
        String string2 = String.valueOf(bl);
        return this.writeString(string, string2);
    }

    public boolean writeByte(String string, byte by) {
        String string2 = String.valueOf(by);
        return this.writeString(string, string2);
    }

    public boolean writeChar(String string, char c) {
        return true;
    }

    public void writeObject(PersistentDefinition persistentDefinition) throws DefPersistenceException {
        try {
            Element element = this.getExistingObjectElement(persistentDefinition);
            if (element == null) {
                element = this._element.getOwnerDocument().createElement(persistentDefinition.getXMLElementTag());
                this._element.appendChild(element);
            }
            ElementDefWriter elementDefWriter = new ElementDefWriter(element);
            persistentDefinition.writeContents(elementDefWriter);
            persistentDefinition.writeChildren(elementDefWriter);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private Element getExistingObjectElement(PersistentDefinition persistentDefinition) {
        return null;
    }

    public boolean writeStringArrayElement(String string, Iterator iterator) {
        if (string == null || iterator == null) {
            return false;
        }
        Element element = this._element.getOwnerDocument().createElement(string);
        while (iterator.hasNext()) {
            String string2 = "";
            Object object = iterator.next();
            if (object instanceof DefPersistable) {
                string2 = ((DefPersistable)object).getFullName();
            } else if (object != null) {
                string2 = object.toString();
            }
            Element element2 = this._element.getOwnerDocument().createElement("Item");
            element2.setAttribute("Value", string2);
            element.appendChild(element2);
        }
        this._element.appendChild(element);
        return true;
    }

    public void commit() throws DefPersistenceException {
    }

    public void rollback() throws DefPersistenceException {
    }

    public Element getElement() {
        return this._element;
    }
}

