/*
 * Decompiled with CFR 0.152.
 */
package oracle.jbo.mom;

import com.sun.java.util.collections.ArrayList;
import com.sun.java.util.collections.Collections;
import com.sun.java.util.collections.HashMap;
import com.sun.java.util.collections.Iterator;
import com.sun.java.util.collections.List;
import com.sun.java.util.collections.Map;
import java.io.InputStream;
import java.io.ObjectInputStream;
import oracle.jbo.JboException;
import oracle.jbo.NoXMLFileException;
import oracle.jbo.PersistenceException;
import oracle.jbo.common.Diagnostic;
import oracle.jbo.common.JBOClass;
import oracle.jbo.common.JboNameUtil;
import oracle.jbo.mom.DefinitionManager;
import oracle.jbo.mom.DefinitionObject;
import oracle.jbo.mom.xml.DefElement;

public abstract class ContainerDefImpl
extends DefinitionObject {
    protected boolean mXMLLoaded;
    protected boolean mHasJava;
    private boolean mSynchronized;
    protected static List mUnresolvedObjects = null;
    protected Map mContainees;
    protected String mXMLFileName;
    protected String mXMLSectionName;
    protected String mJavaPackageName;
    protected boolean mChildPackage;
    protected boolean mIsProject;
    protected boolean mHasSubstitutes;
    protected boolean mLazyLoading;
    protected DefinitionManager mDefMgr;
    private static final byte CONTAINER_UNINITIALIZED = -1;
    private static final byte CONTAINER_STATIC = 0;
    private static final byte CONTAINER_DYNAMIC = 1;
    private byte mDynamicState;

    private /* synthetic */ void $init$() {
        this.mXMLLoaded = false;
        this.mHasJava = true;
        this.mSynchronized = false;
        this.mContainees = new HashMap(20);
        this.mXMLFileName = null;
        this.mXMLSectionName = null;
        this.mJavaPackageName = null;
        this.mChildPackage = false;
        this.mIsProject = false;
        this.mHasSubstitutes = false;
        this.mLazyLoading = true;
        this.mDynamicState = (byte)-1;
    }

    private ContainerDefImpl() {
        this.$init$();
    }

    protected ContainerDefImpl(DefinitionManager definitionManager) {
        this.$init$();
        this.mDefMgr = definitionManager;
    }

    protected abstract ArrayList getContainerDefNames(boolean var1);

    public boolean isProject() {
        return this.mIsProject;
    }

    protected void setIsProject(boolean bl) {
        this.mIsProject = bl;
    }

    public boolean hasSubstitutes() {
        return this.mHasSubstitutes;
    }

    protected void setHasSubstitutes(boolean bl) {
        this.mHasSubstitutes = bl;
    }

    public boolean isLazyLoading() {
        return this.mLazyLoading;
    }

    public boolean isXMLLoaded() {
        return this.mXMLLoaded;
    }

    protected void setXMLName(String string, String string2) {
        this.mXMLFileName = string;
        this.mXMLSectionName = string2;
    }

    protected void addChild(DefinitionObject definitionObject, String string) {
        this.addChild(definitionObject);
        List list = (List)this.mContainees.get((Object)string);
        if (list == null) {
            list = new ArrayList();
            if (this.mSynchronized) {
                list = Collections.synchronizedList((List)list);
            }
            this.mContainees.put((Object)string, (Object)list);
        }
        list.add((Object)definitionObject.getFullName());
    }

    public void addChild(DefinitionObject definitionObject) {
        definitionObject.setParent(this);
        String string = definitionObject.getFullName();
        this.mDefMgr.insertDefinition(string, definitionObject);
        if (!definitionObject.isObjectResolved()) {
            if (mUnresolvedObjects == null) {
                mUnresolvedObjects = new ArrayList(5);
                if (this.mSynchronized) {
                    mUnresolvedObjects = Collections.synchronizedList((List)mUnresolvedObjects);
                }
            }
            mUnresolvedObjects.add((Object)definitionObject);
        }
    }

    protected void removeChild(DefinitionObject definitionObject, String string) {
        String string2 = definitionObject.getFullName();
        List list = (List)this.mContainees.get((Object)string);
        if (list != null) {
            list.remove((Object)string2);
        }
        if (mUnresolvedObjects != null && mUnresolvedObjects.contains((Object)definitionObject)) {
            mUnresolvedObjects.remove((Object)definitionObject);
        }
        this.mDefMgr.removeDefinition(string2);
        definitionObject.setParent(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected void loadFromXML() {
        InputStream inputStream;
        String string;
        DefElement defElement;
        block25: {
            if (this.mXMLLoaded || this.mXMLFileName == null) {
                Diagnostic.ASSERT(this.mXMLFileName == null, "XML File Name is NULL");
                return;
            }
            defElement = null;
            string = "/" + this.mXMLFileName.replace('.', '/') + ".ser";
            inputStream = JBOClass.getResourceAsStream(string);
            if (inputStream != null) {
                Object object;
                ObjectInputStream objectInputStream = null;
                if (Diagnostic.isOn()) {
                    Diagnostic.println("Loading metadata from serialized file " + string);
                }
                if (!((object = (objectInputStream = new ObjectInputStream(inputStream)).readObject()) instanceof DefElement)) {
                    if (Diagnostic.isOn()) {
                        Diagnostic.println("Invalid serialized file " + string);
                    }
                    throw new PersistenceException("26009", new String[]{string});
                }
                defElement = (DefElement)object;
                Object var14_6 = null;
                try {
                    inputStream.close();
                    if (objectInputStream != null) {
                        objectInputStream.close();
                    }
                    break block25;
                }
                catch (Exception exception) {
                    if (Diagnostic.isOn()) {
                        Diagnostic.println("Warning: Ignoring exception in closing metadata InputStream for serialized file " + string);
                    }
                    break block25;
                }
                {
                    catch (Exception exception) {
                        if (Diagnostic.isOn()) {
                            Diagnostic.println("Generic exception trying to read serialized file " + string);
                            Diagnostic.println(exception.toString());
                        }
                        PersistenceException persistenceException = new PersistenceException("26000", null);
                        persistenceException.addToDetails(exception);
                        throw persistenceException;
                    }
                }
                catch (Throwable throwable) {
                    block26: {
                        Object var14_7 = null;
                        try {
                            inputStream.close();
                            if (objectInputStream != null) {
                                objectInputStream.close();
                            }
                        }
                        catch (Exception exception) {
                            if (!Diagnostic.isOn()) break block26;
                            Diagnostic.println("Warning: Ignoring exception in closing metadata InputStream for serialized file " + string);
                        }
                    }
                    throw throwable;
                }
            }
            defElement = this.mDefMgr.loadDefElement(this.mXMLFileName);
        }
        Object object = this.mDefMgr.getMapLock();
        synchronized (object) {
            try {
                this.loadFromXMLFile(defElement);
                if (!this.mChildPackage) {
                    this.resolveAllReferences();
                }
                this.mXMLLoaded = true;
            }
            catch (JboException jboException) {
                throw jboException;
            }
            catch (Exception exception) {
                if (Diagnostic.isOn()) {
                    String string2 = inputStream != null ? string : JboNameUtil.getDocumentName(this.mXMLFileName);
                    Diagnostic.println("Generic Exception trying to load metadata from XML file " + string2);
                    Diagnostic.println(exception.toString());
                }
                PersistenceException persistenceException = new PersistenceException("26000", null);
                persistenceException.addToDetails(exception);
                throw persistenceException;
            }
        }
        if (Diagnostic.isOn()) {
            Diagnostic.println("Successfully loaded Metadata from the Package '" + this.getFullName() + "'.");
        }
    }

    protected void loadFromXMLFile(DefElement defElement) {
        if (defElement.readString("Name") != null) {
            this.setName(defElement.readString("Name"));
        } else {
            this.setName(defElement.readString("id"));
        }
        String string = defElement.readString("PackageName");
        if (string == null) {
            string = this.getName();
        }
        this.setFullName(string + "." + this.getName());
        this.mHasJava = defElement.readBoolean("HasJava");
        super.loadProperties(defElement);
        if (defElement.getTagName().equalsIgnoreCase("JboProject")) {
            String string2 = defElement.readString("LazyLoad");
            this.mLazyLoading = string2 != null ? defElement.readBoolean("LazyLoad") : this.mDefMgr.getLazyLoadProp();
        }
        boolean bl = defElement.readBoolean("SeparateXMLFiles");
        this.loadContainees(defElement, bl);
        if (!bl) {
            this.loadChildContainers(defElement);
            this.resolveAllReferences();
        }
    }

    protected abstract void loadContainees(DefElement var1, boolean var2);

    protected void loadContainee(DefElement defElement) {
    }

    protected void loadContainees(DefElement defElement) {
        Map map = this.mContainees;
        Diagnostic.println("Loading the Containees for the Package '" + this.getFullName() + "'.");
        ArrayList arrayList = defElement.getChildrenList("Containee");
        DefinitionObject definitionObject = null;
        List list = null;
        if (arrayList != null && arrayList.size() > 0) {
            DefElement defElement2 = null;
            int n = 0;
            while (n < arrayList.size()) {
                defElement2 = (DefElement)arrayList.get(n);
                this.loadContainee(defElement2);
                String string = defElement2.readString("FullName");
                String string2 = defElement2.readString("ObjectType");
                list = (List)map.get((Object)string2);
                if (list == null) {
                    list = new ArrayList();
                    if (this.mSynchronized) {
                        list = Collections.synchronizedList((List)list);
                    }
                    map.put((Object)string2, (Object)list);
                }
                list.add((Object)string);
                if (!this.mDefMgr.isLazyLoadingMode()) {
                    try {
                        definitionObject = (DefinitionObject)this.mDefMgr.loadLazyDefinitionObject(string, this, false, true);
                    }
                    catch (Exception exception) {
                        Diagnostic.println("Error loading Containee : " + string);
                        Diagnostic.println(exception.toString());
                        throw new NoXMLFileException(string);
                    }
                }
                ++n;
            }
        }
    }

    protected abstract ContainerDefImpl createContainerType(String var1);

    private void loadChildContainers(DefElement defElement) {
        Diagnostic.println("Loading Child Containers for the container '" + this.getFullName() + "'.");
        ArrayList arrayList = defElement.getChildrenList("Containee");
        if (arrayList != null && arrayList.size() > 0) {
            ContainerDefImpl containerDefImpl = null;
            DefElement defElement2 = null;
            String string = null;
            int n = 0;
            while (n < arrayList.size()) {
                defElement2 = (DefElement)arrayList.get(n);
                containerDefImpl = this.createContainerType(defElement2.readString("ObjectType"));
                if (containerDefImpl != null) {
                    containerDefImpl.mChildPackage = true;
                    string = defElement2.readString("FullName");
                    containerDefImpl.setXMLName(string, string.substring(string.lastIndexOf(".") + 1));
                    containerDefImpl.loadFromXML();
                    this.addChild(containerDefImpl, "JboPackage");
                }
                ++n;
            }
        }
    }

    protected boolean hasJava() {
        return this.mHasJava;
    }

    protected void resolveAllReferences() {
        if (this.mChildPackage || mUnresolvedObjects == null) {
            return;
        }
        Iterator iterator = mUnresolvedObjects.iterator();
        while (iterator.hasNext()) {
            DefinitionObject definitionObject = (DefinitionObject)iterator.next();
            definitionObject.resolveReferences();
            definitionObject.setObjectResolved(true);
            Diagnostic.println("Successfully resolved references for '" + definitionObject.getFullName());
        }
        mUnresolvedObjects = null;
    }

    protected void getChildObjectNames(boolean bl, String string, ArrayList arrayList) {
        List list;
        List list2 = this.getNames(string);
        if (list2 != null) {
            Iterator iterator = list2.iterator();
            while (iterator.hasNext()) {
                arrayList.add(iterator.next());
            }
        }
        if (bl && (list = this.getPackageNames()) != null) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                ContainerDefImpl containerDefImpl = this.mDefMgr.findContainer(iterator.next().toString());
                if (containerDefImpl == null) continue;
                containerDefImpl.getChildObjectNames(true, string, arrayList);
            }
        }
    }

    protected void getChildObjects(boolean bl, String string, ArrayList arrayList) {
        List list;
        List list2 = this.getNames(string);
        if (list2 != null) {
            Iterator iterator = list2.iterator();
            while (iterator.hasNext()) {
                DefinitionObject definitionObject = null;
                try {
                    definitionObject = this.findChildObject(string, (String)iterator.next());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (definitionObject == null) continue;
                arrayList.add((Object)definitionObject);
            }
        }
        if (bl && (list = this.getPackageNames()) != null) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                ContainerDefImpl containerDefImpl = this.mDefMgr.findContainer(iterator.next().toString());
                if (containerDefImpl == null) continue;
                containerDefImpl.getChildObjects(true, string, arrayList);
            }
        }
    }

    protected String generateUniqueChildName(String string, String string2) {
        List list = (List)this.mContainees.get((Object)string2);
        String string3 = string;
        if (list != null) {
            int n = 1;
            while (list.indexOf((Object)string3) >= 0) {
                string3 = string + Integer.toString(n);
            }
        }
        return string3;
    }

    protected DefinitionObject findChildObject(String string, String string2) {
        List list = (List)this.mContainees.get((Object)string);
        DefinitionObject definitionObject = null;
        if (list != null) {
            int n = 0;
            while (n < list.size()) {
                String string3 = (String)list.get(n);
                if (string3.equals(string2)) {
                    try {
                        definitionObject = (DefinitionObject)this.mDefMgr.loadLazyDefinitionObject(string3, this, false, true);
                    }
                    catch (Exception exception) {
                        Diagnostic.println("Error loading Containee : " + string2);
                        Diagnostic.println(exception.toString());
                        throw new NoXMLFileException(string2);
                    }
                }
                ++n;
            }
        }
        return definitionObject;
    }

    public boolean isDynamicDefinitionObject(DefinitionManager definitionManager) {
        if (this.mDynamicState == -1) {
            this.mDynamicState = this.mParent == definitionManager.getDynamicObjectsContainer() ? (byte)1 : 0;
        }
        return this.mDynamicState == 1;
    }

    public void setSynchronized() {
        this.mSynchronized = true;
        this.mContainees = Collections.synchronizedMap((Map)this.mContainees);
        Iterator iterator = this.mContainees.keySet().iterator();
        while (iterator.hasNext()) {
            Object object = iterator.next();
            Object object2 = this.mContainees.get(object);
            if (!(object2 instanceof List)) continue;
            this.mContainees.put(object, (Object)Collections.synchronizedList((List)((List)object2)));
        }
        if (mUnresolvedObjects != null) {
            mUnresolvedObjects = Collections.synchronizedList((List)mUnresolvedObjects);
        }
    }

    private List getNames(String string) {
        List list = (List)this.mContainees.get((Object)string);
        if (list != null && this.mSynchronized) {
            ArrayList arrayList = new ArrayList(list.size());
            Collections.copy((List)list, (List)arrayList);
            list = arrayList;
        }
        return list;
    }

    private List getPackageNames() {
        List list = (List)this.mContainees.get((Object)"JboPackage");
        if (list != null && this.mSynchronized) {
            ArrayList arrayList = new ArrayList(list.size());
            Collections.copy((List)list, (List)arrayList);
            list = arrayList;
        }
        return list;
    }
}

