/*
 * Decompiled with CFR 0.152.
 */
package oracle.jbo.common;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import oracle.jbo.AttributeDef;
import oracle.jbo.DeleteEvent;
import oracle.jbo.RowSet;
import oracle.jbo.common.DataRowImpl;
import oracle.jbo.common.xml.XmlOutput;
import oracle.jbo.domain.DomainAttributeDef;
import oracle.jbo.server.AttributeDefImpl;
import oracle.jbo.server.ViewObjectImpl;
import oracle.svcmsg.DataRow;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

class RowSetChangeManager {
    private RowSet mRowSet;
    private HashMap mDeletedRows;
    private static int idCounter = 0;
    private int mId;
    private AttributeDef[] mAttrDefs;
    String elementTagName;

    private /* synthetic */ void $init$() {
        this.mDeletedRows = new HashMap();
        this.mId = 0;
        this.mAttrDefs = null;
        this.elementTagName = null;
    }

    RowSetChangeManager(RowSet rowSet) {
        this.$init$();
        this.mRowSet = rowSet;
        this.mId = RowSetChangeManager.nextId();
    }

    String getXMLTagName() {
        if (this.elementTagName == null) {
            this.elementTagName = ((ViewObjectImpl)this.mRowSet.getViewObject()).getXMLRowElementTag();
        }
        return this.elementTagName;
    }

    void handleRowDeleteEvent(DeleteEvent deleteEvent) {
        DataRowImpl dataRowImpl = new DataRowImpl(10, deleteEvent.getRow(), new Integer(this.mId), deleteEvent.getRowIndex());
        AttributeDef[] attributeDefArray = this.getAttributeDefs();
        Object[] objectArray = new Object[attributeDefArray.length];
        int n = 0;
        while (n < attributeDefArray.length) {
            objectArray[n] = deleteEvent.getRow().getAttribute(attributeDefArray[n].getName());
            ++n;
        }
        dataRowImpl.setAttributes(objectArray);
        this.mDeletedRows.put(deleteEvent.getRow().getKey(), dataRowImpl);
    }

    int getId() {
        return this.mId;
    }

    void writeRowToXml(XmlOutput xmlOutput, Node node, DataRow dataRow) {
        AttributeDef[] attributeDefArray = this.getAttributeDefs();
        int n = 0;
        while (n < attributeDefArray.length) {
            AttributeDefImpl attributeDefImpl = (AttributeDefImpl)attributeDefArray[n];
            Object object = dataRow.getAttribute(attributeDefImpl.getIndex());
            Node node2 = DomainAttributeDef.getXMLContentNode(node.getOwnerDocument(), object, attributeDefImpl.getProperty("XML_CDATA") != null);
            Element element = null;
            if (node2 != null) {
                element = node.getOwnerDocument().createElement(attributeDefImpl.getXMLElementTag());
                element.appendChild(node2);
            } else if (attributeDefImpl.getProperty("XML_EXPLICIT_NULL") != null) {
                element = node.getOwnerDocument().createElement(attributeDefImpl.getXMLElementTag());
                element.setAttribute("null", "true");
            }
            if (element != null) {
                node.appendChild(element);
            }
            ++n;
        }
    }

    AttributeDef[] getAttributeDefs() {
        if (this.mAttrDefs == null) {
            ArrayList<AttributeDef> arrayList = new ArrayList<AttributeDef>();
            AttributeDef[] attributeDefArray = this.mRowSet.getViewObject().getAttributeDefs();
            boolean bl = false;
            int n = 0;
            while (n < attributeDefArray.length) {
                if (attributeDefArray[n].getAttributeKind() != 2 && attributeDefArray[n].getAttributeKind() != 6) {
                    arrayList.add(attributeDefArray[n]);
                }
                ++n;
            }
            this.mAttrDefs = arrayList.toArray(new AttributeDef[0]);
        }
        return this.mAttrDefs;
    }

    static int nextId() {
        return ++idCounter;
    }

    Collection getChangedRows() {
        return this.mDeletedRows.values();
    }
}

