/*
 * Decompiled with CFR 0.152.
 */
package oracle.jbo.common;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import oracle.jbo.common.ClientElement;
import oracle.jbo.common.JboXMLUtil;
import oracle.xml.parser.v2.DOMParser;
import oracle.xml.parser.v2.XMLElement;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ClientDocument
implements Serializable {
    static final long serialVersionUID = -1132199426017350583L;
    private ClientElement _root;

    public ClientDocument() {
    }

    public ClientDocument(ClientElement clientElement) {
        this._root = clientElement;
    }

    public ClientElement getRoot() {
        return this._root;
    }

    public void writeXML(File file) throws IOException {
        OutputStreamWriter outputStreamWriter = null;
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        outputStreamWriter = new OutputStreamWriter(fileOutputStream);
        this._root._writeXML(outputStreamWriter, "");
        outputStreamWriter.flush();
        outputStreamWriter.close();
    }

    public void readXML(String string) {
        try {
            this._root = new ClientElement();
            FileInputStream fileInputStream = new FileInputStream(string);
            DOMParser dOMParser = JboXMLUtil.createDOMParser(false);
            dOMParser.parse((InputStream)fileInputStream);
            XMLElement xMLElement = (XMLElement)dOMParser.getDocument().getDocumentElement();
            this.createElementTree(xMLElement, this._root);
        }
        catch (IOException iOException) {
            System.out.println("XML file does not exist");
            return;
        }
        catch (Exception exception) {
            System.out.println("Error Processing the XML File :" + exception.toString());
            exception.printStackTrace();
        }
    }

    private void createElementTree(XMLElement xMLElement, ClientElement clientElement) throws Exception {
        Node node;
        clientElement.setName(xMLElement.getTagName());
        NamedNodeMap namedNodeMap = xMLElement.getAttributes();
        int n = 0;
        while (n < namedNodeMap.getLength()) {
            node = namedNodeMap.item(n);
            if (node.getNodeType() == 2) {
                clientElement.addAttribute(node.getNodeName(), node.getNodeValue());
            }
            ++n;
        }
        NodeList nodeList = xMLElement.getChildNodes();
        int n2 = 0;
        while (n2 < nodeList.getLength()) {
            node = nodeList.item(n2);
            if (node.getNodeType() == 1) {
                ClientElement clientElement2 = new ClientElement();
                clientElement.addChild(clientElement2);
                this.createElementTree((XMLElement)node, clientElement2);
            }
            ++n2;
        }
    }

    public static void main(String[] stringArray) {
        try {
            ClientDocument clientDocument = new ClientDocument();
            clientDocument.readXML("c:\\temp\\temp.xml");
            File file = new File("c:\\temp\\tempout.xml");
            clientDocument.writeXML(file);
        }
        catch (Exception exception) {
            System.out.println("Error in writing File");
            exception.printStackTrace();
        }
    }
}

