/*
 * Decompiled with CFR 0.152.
 */
package br.gov.rs.tce.ws.validacao.client;

import br.gov.rs.tce.ws.validacao.client.CsvReader;
import br.gov.rs.tce.ws.validacao.client.Recebimento;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Locale;
import java.util.Properties;
import java.util.Scanner;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SiapcLicitaconClient {
    private static final Log log = LogFactory.getLog(SiapcLicitaconClient.class);
    static final String ARQUIVO_PROPERTIES = "conf/pad.properties";
    static final String PROP_WSLICITACON = "ws-siapclicitacon.url";
    static final String SQL_UPDATE_REMESSA = "update remessas set cd_recebimento = ?, ano_recebimento = ?, atual = ?, dt_recebimento = ? where cd_entidade = ?";
    static final String SQL_SELECT_RECEBIMENTO = "select cd_recebimento, ano_recebimento, atual, dt_recebimento from remessas where cd_entidade = ?";
    static final String SQL_TRUNCATE_BVER_ENC_ULT_REC = "delete from bver_enc_ult_rec";
    static final String SQL_INSERT_BVER_ENC_ULT_REC = "insert into bver_enc_ult_rec (CD_CONTA_SG, CD_ORGAO, CD_UNIDADE, ISF, CD_FONTE_RECURSO, CD_RECURSO, NIVEL, VL_SALDO_ATUAL_CRE, VL_SALDO_ATUAL_DEV, CD_COMPL_RECURSO) values (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
    static final String SQL_TRUNCATE_LICITACOES_ALL = "delete from licitacoes";
    static final String SQL_TRUNCATE_LICITACOES_ALL_BUT = "delete from licitacoes where cd_orgao != ?";
    static final String SQL_INSERT_LICITACOES = "insert into licitacoes (ANO_LICITACAO, NR_LICITACAO, CD_TIPO_MODALIDADE, CD_ORGAO) values (?, ?, ?, ?)";
    static final String SQL_INSERT_LICITACOES_FROM_VENCEDORES = "insert into licitacoes (CD_ORGAO, ANO_LICITACAO, NR_LICITACAO, CD_TIPO_MODALIDADE) select distinct CD_ORGAO, ANO_LICITACAO, NR_LICITACAO, CD_TIPO_MODALIDADE from licitacoes_vencedores where cd_orgao = ?";
    static final String SQL_TRUNCATE_LICITACOES_VENC_ALL = "delete from licitacoes_vencedores";
    static final String SQL_TRUNCATE_LICITACOES_VENC_ALL_BUT = "delete from licitacoes_vencedores where cd_orgao != ?";
    static final String SQL_INSERT_LICITACOES_VENC = "insert into licitacoes_vencedores (CD_ORGAO, ANO_LICITACAO, NR_LICITACAO, CD_TIPO_MODALIDADE, VENC_CNPJ_CPF, VENC_TP_PESSOA, TP_VENCEDOR) values (?, ?, ?, ?, ?, ?, ?)";
    static final String SQL_TRUNCATE_CONTRATOS_ALL = "delete from contratos";
    static final String SQL_TRUNCATE_CONTRATOS_ALL_BUT = "delete from contratos where cd_orgao != ?";
    static final String SQL_INSERT_CONTRATOS = "insert into contratos (ANO_CONTRATO, NR_CONTRATO, TP_INSTRUMENTO, ANO_LICITACAO, NR_LICITACAO, CD_TIPO_MODALIDADE, CD_ORGAO) values (?, ?, ?, ?, ?, ?, ?)";
    static final String SQL_TRUNCATE_VALORES_SIA_ASPS = "delete from VALORES_SIA where variavel in ('VL_RECEITA_ASPS', 'VL_APLIC_ASPS')";
    static final String SQL_TRUNCATE_VALORES_SIA_FUNDEB = "delete from VALORES_SIA where variavel in ('VL_RECEITA_FUNDEB', 'VL_APLIC_FUNDEB')";
    static final String SQL_INSERT_VALORES_SIA = "insert into VALORES_SIA (ANO, CD_RECEBIMENTO, VARIAVEL, VALOR) values (?, ?, ?, ?)";
    static final String DATE_FORMAT = "yyyy-MM-dd";
    static final BigDecimal BIG_ZERO = new BigDecimal(0);
    static String servicoUrl = null;

    public static void initialize() {
        servicoUrl = SiapcLicitaconClient.carregaConfigUrl();
    }

    public static Recebimento buscaUltimoRecebimento(int cdEntidade, int exercicio, Connection conn) throws IOException {
        String urlCompleta = servicoUrl + "q/siapc.recebimento/" + cdEntidade + "/" + exercicio + ".csv?limit=1";
        urlCompleta = urlCompleta + "&java.version=" + URLEncoder.encode(System.getProperty("java.version")) + "&os.name=" + URLEncoder.encode(System.getProperty("os.name")) + "&os.version=" + URLEncoder.encode(System.getProperty("os.version")) + "&versaoPad=" + URLEncoder.encode("25.0.0.8") + "&charset=" + URLEncoder.encode(Charset.defaultCharset().toString()) + "&locale=" + URLEncoder.encode(Locale.getDefault().toString());
        log.info((Object)("buscaUltimoRecebimento: url: " + urlCompleta));
        try {
            SimpleDateFormat df = new SimpleDateFormat(DATE_FORMAT);
            Scanner scan = SiapcLicitaconClient.getScannerFromUrl(urlCompleta);
            int i = 0;
            Recebimento rec = null;
            CsvReader csvr = null;
            while (scan.hasNext()) {
                String line = scan.nextLine();
                if (i == 0) {
                    csvr = new CsvReader(line);
                } else if (i == 1) {
                    csvr.readLine(line);
                    int cdRecebimento = csvr.getInt("CD_RECEBIMENTO");
                    int anoRecebimento = csvr.getInt("ANO");
                    String atual = csvr.getString("ATUAL");
                    Date dtRecebimento = new Date(df.parse(csvr.getString("DT_RECEBIMENTO")).getTime());
                    log.info((Object)("buscaUltimoRecebimento: cdRecebimento=" + cdRecebimento + " ; anoRecebimento=" + anoRecebimento + " ; atual=" + atual + " ; dtRecebimento=" + dtRecebimento));
                    rec = new Recebimento(cdRecebimento, anoRecebimento, atual, dtRecebimento);
                } else if (i > 1) {
                    scan.close();
                    throw new IllegalStateException("i > 1 [" + i + "]");
                }
                ++i;
            }
            scan.close();
            if (i <= 1) {
                log.info((Object)"Entidade n\u00e3o possui entrega anterior");
                return null;
            }
            return rec;
        }
        catch (ParseException e) {
            log.warn((Object)e);
            throw new RuntimeException(e);
        }
    }

    public static void atualizaRemessa(int cdEntidade, Recebimento rec, Connection conn) {
        try {
            PreparedStatement ps = conn.prepareStatement(SQL_UPDATE_REMESSA);
            ps.setInt(1, rec.getCdRecebimento());
            ps.setInt(2, rec.getAnoRecebimento());
            ps.setString(3, rec.getAtual());
            ps.setDate(4, new Date(rec.getDtRecebimento().getTime()));
            ps.setInt(5, cdEntidade);
            int count = ps.executeUpdate();
            if (count != 1) {
                conn.rollback();
                throw new RuntimeException("count != 1 [" + count + "]");
            }
            conn.commit();
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public static void limpaDadosUltimoRecebimento(int cdEntidade, Connection conn) {
        try {
            PreparedStatement ps = conn.prepareStatement(SQL_UPDATE_REMESSA);
            ps.setObject(1, null);
            ps.setObject(2, null);
            ps.setObject(3, null);
            ps.setDate(4, null);
            ps.setInt(5, cdEntidade);
            int count = ps.executeUpdate();
            if (count != 1) {
                conn.rollback();
                throw new RuntimeException("count != 1 [" + count + "]");
            }
            conn.commit();
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public static Recebimento selectDadosUltimoRecebimento(int cdEntidade, Connection conn) {
        try {
            String atual;
            PreparedStatement ps = conn.prepareStatement(SQL_SELECT_RECEBIMENTO);
            ps.setInt(1, cdEntidade);
            ResultSet rs = ps.executeQuery();
            Recebimento rec = null;
            if (rs.next()) {
                atual = rs.getString(3);
                if (atual == null) {
                    return null;
                }
            } else {
                log.warn((Object)"Nenhuma linha retornada...");
                return null;
            }
            int cdRecebimento = rs.getInt(1);
            int anoRecebimento = rs.getInt(2);
            Date dtRecebimento = rs.getDate(4);
            rec = new Recebimento(cdRecebimento, anoRecebimento, atual, dtRecebimento);
            if (rs.next()) {
                log.warn((Object)"Mais de 1 linha retornada...");
                return null;
            }
            rs.close();
            ps.close();
            return rec;
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public static long buscaBalVerEncECarrega(int cdEntidade, int exercicioAnterior, Connection conn) throws IOException {
        String urlCompleta = servicoUrl + "q/siapc.balver_enc/" + cdEntidade + "/" + exercicioAnterior + ".csv";
        log.info((Object)("buscaBalVerEncECarrega: url: " + urlCompleta));
        String line = null;
        int i = 0;
        try {
            Scanner scan = SiapcLicitaconClient.getScannerFromUrl(urlCompleta);
            Statement s = conn.createStatement();
            int count = s.executeUpdate(SQL_TRUNCATE_BVER_ENC_ULT_REC);
            log.info((Object)("truncate: count==" + count));
            conn.commit();
            int nrCols = -1;
            PreparedStatement ps = conn.prepareStatement(SQL_INSERT_BVER_ENC_ULT_REC);
            CsvReader csvr = null;
            while (scan.hasNext()) {
                line = scan.nextLine();
                if (i == 0) {
                    csvr = new CsvReader(line);
                    nrCols = csvr.getColsLength();
                } else if (i > 0) {
                    csvr.readLine(line);
                    BigDecimal cdContaSg = csvr.getBigDecimal("CD_CONTA_SG");
                    int cdOrgao = csvr.getInt("CD_ORGAO");
                    int cdUnidade = csvr.getInt("CD_UNIDADE");
                    String indicadorSuperavit = csvr.getString("ISF");
                    if ("S".equals(indicadorSuperavit) || !"N".equals(indicadorSuperavit)) {
                        // empty if block
                    }
                    int cdFonteRecurso = csvr.getInt("CD_FONTE_RECURSO");
                    int cdRecurso = csvr.getInt("CD_RECURSO");
                    String nivel = csvr.getString("NIVEL");
                    double vlSaldoCredor = csvr.getDouble("VL_SALDO_ATUAL_CRE");
                    double vlSaldoDevedor = csvr.getDouble("VL_SALDO_ATUAL_DEV");
                    int cdComplRecurso = 0;
                    if (csvr.hasColumnName("CD_COMPL_RECURSO")) {
                        cdComplRecurso = csvr.getIntegerOrDefault("CD_COMPL_RECURSO", cdComplRecurso);
                    }
                    ps.setBigDecimal(1, cdContaSg);
                    ps.setInt(2, cdOrgao);
                    ps.setInt(3, cdUnidade);
                    ps.setString(4, indicadorSuperavit);
                    ps.setInt(5, cdFonteRecurso);
                    ps.setInt(6, cdRecurso);
                    ps.setString(7, nivel);
                    ps.setDouble(8, vlSaldoCredor);
                    ps.setDouble(9, vlSaldoDevedor);
                    ps.setInt(10, cdComplRecurso);
                    ps.addBatch();
                }
                ++i;
            }
            scan.close();
            int[] counts = ps.executeBatch();
            conn.commit();
            long updateCount = SiapcLicitaconClient.sumArray(counts);
            log.info((Object)("rows==" + i + " ; nrCols==" + nrCols + " ; updateCount==" + updateCount));
            return updateCount;
        }
        catch (RuntimeException e) {
            log.warn((Object)("Erro linha [#" + i + "] [" + line + "]"), (Throwable)e);
            throw e;
        }
        catch (SQLException e) {
            log.warn((Object)e);
            throw new RuntimeException(e);
        }
    }

    @Deprecated
    public static long buscaLicitacoesECarrega(int cdEntidade, boolean truncateAll, Connection conn) throws IOException {
        String urlCompleta = servicoUrl + "q/siapc.licitacoes/" + cdEntidade + ".csv";
        log.info((Object)("buscaLicitacoesECarrega:: url: " + urlCompleta));
        try {
            Scanner scan = SiapcLicitaconClient.getScannerFromUrl(urlCompleta);
            int count = -1;
            if (truncateAll) {
                Statement s = conn.createStatement();
                count = s.executeUpdate(SQL_TRUNCATE_LICITACOES_ALL);
                log.debug((Object)("truncate: count==" + count));
                conn.commit();
            }
            int i = 0;
            PreparedStatement ps = conn.prepareStatement(SQL_INSERT_LICITACOES);
            while (scan.hasNext()) {
                String line = scan.nextLine();
                String[] cols = line.split(",");
                if (i > 0) {
                    int ano = Integer.parseInt(cols[0]);
                    BigDecimal nrLicitacao = new BigDecimal(cols[1]);
                    String cdTipoModalidade = cols[2];
                    ps.setInt(1, ano);
                    ps.setBigDecimal(2, nrLicitacao);
                    ps.setString(3, cdTipoModalidade);
                    ps.setInt(4, cdEntidade);
                    ps.addBatch();
                }
                ++i;
            }
            scan.close();
            int[] counts = ps.executeBatch();
            conn.commit();
            long updateCount = SiapcLicitaconClient.sumArray(counts);
            log.info((Object)("rows==" + i + " ; updateCount==" + updateCount));
            return updateCount;
        }
        catch (SQLException e) {
            log.warn((Object)e);
            throw new RuntimeException(e);
        }
    }

    public static long buscaLicitacoesVencedoresECarrega(int cdEntidade, boolean truncateAll, Connection conn) throws IOException {
        String urlCompleta = servicoUrl + "q/siapc.licitacoes_vencedores.csv?cd_orgao=" + cdEntidade;
        log.info((Object)("buscaLicitacoesVencedoresECarrega:: url: " + urlCompleta));
        try {
            Scanner scan = SiapcLicitaconClient.getScannerFromUrl(urlCompleta);
            int count = -1;
            if (truncateAll) {
                Statement s = conn.createStatement();
                count = s.executeUpdate(SQL_TRUNCATE_LICITACOES_VENC_ALL);
                log.debug((Object)("truncate: count==" + count));
                conn.commit();
            }
            int i = 0;
            PreparedStatement ps = conn.prepareStatement(SQL_INSERT_LICITACOES_VENC);
            CsvReader csvr = null;
            while (scan.hasNext()) {
                String line = scan.nextLine();
                if (i == 0) {
                    csvr = new CsvReader(line);
                } else if (i > 0) {
                    csvr.readLine(line);
                    int ano = csvr.getInt("ANO_LICITACAO");
                    BigDecimal nrLicitacao = csvr.getBigDecimal("NR_LICITACAO");
                    String cdTipoModalidade = csvr.getString("CD_TIPO_MODALIDADE");
                    BigDecimal nrDocumento = null;
                    String tpPessoaCredor = null;
                    String tpVencedor = csvr.getString("TP_VENCEDOR");
                    String nrDocumentoStr = csvr.getString("LIC_VENCEDOR_NR_DOC");
                    if (!"".equals(nrDocumentoStr)) {
                        nrDocumento = new BigDecimal(nrDocumentoStr);
                        String tpPessoaLic = csvr.getString("LIC_VENCEDOR_TP_DOC");
                        tpPessoaCredor = "F".equals(tpPessoaLic) ? "01" : "02";
                    }
                    ps.setInt(1, cdEntidade);
                    ps.setInt(2, ano);
                    ps.setBigDecimal(3, nrLicitacao);
                    ps.setString(4, cdTipoModalidade);
                    ps.setBigDecimal(5, nrDocumento);
                    ps.setString(6, tpPessoaCredor);
                    ps.setString(7, tpVencedor);
                    ps.addBatch();
                }
                ++i;
            }
            scan.close();
            int[] counts = ps.executeBatch();
            conn.commit();
            long updateCount = SiapcLicitaconClient.sumArray(counts);
            log.info((Object)("rows==" + i + " ; updateCount==" + updateCount));
            SiapcLicitaconClient.atualizaLicitacoesOrigemVencedores(cdEntidade, truncateAll, conn);
            return updateCount;
        }
        catch (SQLException e) {
            log.warn((Object)e);
            throw new RuntimeException(e);
        }
    }

    public static void atualizaLicitacoesOrigemVencedores(int cdEntidade, boolean truncateAll, Connection conn) {
        try {
            int count;
            if (truncateAll) {
                Statement s = conn.createStatement();
                count = s.executeUpdate(SQL_TRUNCATE_LICITACOES_ALL);
                log.debug((Object)("truncate: count==" + count));
                conn.commit();
            }
            PreparedStatement ps = conn.prepareStatement(SQL_INSERT_LICITACOES_FROM_VENCEDORES);
            ps.setInt(1, cdEntidade);
            count = ps.executeUpdate();
            log.info((Object)("atualizaLicitacoesOrigemVencedores: count==" + count));
            conn.commit();
        }
        catch (SQLException e) {
            log.warn((Object)e);
            throw new RuntimeException(e);
        }
    }

    public static long buscaContratosECarrega(int cdEntidade, boolean truncateAll, Connection conn) throws IOException {
        String urlCompleta = servicoUrl + "q/siapc.contratos/" + cdEntidade + ".csv";
        log.info((Object)("buscaContratosECarrega:: url: " + urlCompleta));
        try {
            Scanner scan = SiapcLicitaconClient.getScannerFromUrl(urlCompleta);
            int count = -1;
            if (truncateAll) {
                Statement s = conn.createStatement();
                count = s.executeUpdate(SQL_TRUNCATE_CONTRATOS_ALL);
                log.debug((Object)("truncate: count==" + count));
                conn.commit();
            }
            int i = 0;
            PreparedStatement ps = conn.prepareStatement(SQL_INSERT_CONTRATOS);
            CsvReader csvr = null;
            while (scan.hasNext()) {
                String line = scan.nextLine();
                if (i == 0) {
                    csvr = new CsvReader(line);
                } else if (i > 0) {
                    csvr.readLine(line);
                    int anoContrato = csvr.getInt("ANO_CONTRATO");
                    BigDecimal nrContrato = csvr.getBigDecimal("NR_CONTRATO");
                    String tpInstrumento = csvr.getString("TP_INSTRUMENTO");
                    Integer anoLicitacao = csvr.getIntegerOrDefault("ANO_LICITACAO", null);
                    BigDecimal nrLicitacao = csvr.getBigDecimalOrDefault("ANO_LICITACAO", null);
                    String cdTipoModalidade = csvr.getString("CD_TIPO_MODALIDADE");
                    ps.setInt(1, anoContrato);
                    ps.setBigDecimal(2, nrContrato);
                    ps.setString(3, tpInstrumento);
                    if (anoLicitacao != null) {
                        ps.setInt(4, anoLicitacao);
                    } else {
                        ps.setNull(4, 4);
                    }
                    ps.setBigDecimal(5, nrLicitacao);
                    ps.setString(6, cdTipoModalidade);
                    ps.setInt(7, cdEntidade);
                    ps.addBatch();
                }
                ++i;
            }
            scan.close();
            int[] counts = ps.executeBatch();
            conn.commit();
            long updateCount = SiapcLicitaconClient.sumArray(counts);
            log.info((Object)("rows==" + i + " ; updateCount==" + updateCount));
            return updateCount;
        }
        catch (SQLException e) {
            log.warn((Object)e);
            throw new RuntimeException(e);
        }
    }

    public static long buscaValoresSiaECarrega(int cdEntidade, int ano, Connection conn) throws IOException {
        return SiapcLicitaconClient.buscaValoresAspsECarrega(cdEntidade, ano, conn) + SiapcLicitaconClient.buscaValoresFundebECarrega(cdEntidade, ano, conn);
    }

    public static long buscaValoresAspsECarrega(int cdEntidade, int ano, Connection conn) throws IOException {
        String urlCompleta = servicoUrl + "q/siapc.valores_asps.csv?cd_orgao=" + cdEntidade + "&ano=" + ano;
        log.info((Object)("buscaValoresAspsECarrega:: url: " + urlCompleta));
        try {
            Scanner scan = SiapcLicitaconClient.getScannerFromUrl(urlCompleta);
            SiapcLicitaconClient.deleteAllValoresAsps(conn);
            return SiapcLicitaconClient.carregaValoreSia(scan, conn);
        }
        catch (SQLException e) {
            log.warn((Object)e);
            throw new RuntimeException(e);
        }
    }

    public static long buscaValoresFundebECarrega(int cdEntidade, int ano, Connection conn) throws IOException {
        String urlCompleta = servicoUrl + "q/siapc.valores_fundeb.csv?cd_orgao=" + cdEntidade + "&ano=" + ano;
        log.info((Object)("buscaValoresFundebECarrega:: url: " + urlCompleta));
        try {
            Scanner scan = SiapcLicitaconClient.getScannerFromUrl(urlCompleta);
            SiapcLicitaconClient.deleteAllValoresFundeb(conn);
            return SiapcLicitaconClient.carregaValoreSia(scan, conn);
        }
        catch (SQLException e) {
            log.warn((Object)e);
            throw new RuntimeException(e);
        }
    }

    public static long carregaValoreSia(Scanner scan, Connection conn) throws IOException, SQLException {
        int i = 0;
        PreparedStatement ps = conn.prepareStatement(SQL_INSERT_VALORES_SIA);
        CsvReader csvr = null;
        while (scan.hasNext()) {
            String line = scan.nextLine();
            if (i == 0) {
                csvr = new CsvReader(line);
            } else {
                csvr.readLine(line);
                int anoRemessa = csvr.getInt("ANO");
                int cdRecebimento = csvr.getInt("CD_RECEBIMENTO");
                String variavel = csvr.getString("VARIAVEL");
                BigDecimal valor = csvr.getBigDecimalOrDefault("VALOR", BIG_ZERO);
                ps.setInt(1, anoRemessa);
                ps.setInt(2, cdRecebimento);
                ps.setString(3, variavel);
                ps.setBigDecimal(4, valor);
                ps.addBatch();
            }
            ++i;
        }
        scan.close();
        int[] counts = ps.executeBatch();
        conn.commit();
        long updateCount = SiapcLicitaconClient.sumArray(counts);
        log.info((Object)("rows==" + i + " ; updateCount==" + updateCount));
        return updateCount;
    }

    public static void deleteAllValoresAsps(Connection conn) {
        try {
            Statement s = conn.createStatement();
            int count = s.executeUpdate(SQL_TRUNCATE_VALORES_SIA_ASPS);
            log.info((Object)("truncate: count==" + count));
            conn.commit();
        }
        catch (SQLException e) {
            log.warn((Object)e);
            throw new RuntimeException(e);
        }
    }

    public static void deleteAllValoresFundeb(Connection conn) {
        try {
            Statement s = conn.createStatement();
            int count = s.executeUpdate(SQL_TRUNCATE_VALORES_SIA_FUNDEB);
            log.info((Object)("truncate: count==" + count));
            conn.commit();
        }
        catch (SQLException e) {
            log.warn((Object)e);
            throw new RuntimeException(e);
        }
    }

    public static void deleteAllValoresSia(Connection conn) {
        SiapcLicitaconClient.deleteAllValoresAsps(conn);
        SiapcLicitaconClient.deleteAllValoresFundeb(conn);
    }

    public static void deleteAllLicitacoesButEntidade(int cdEntidade, Connection conn) {
        try {
            PreparedStatement s = conn.prepareStatement(SQL_TRUNCATE_LICITACOES_ALL_BUT);
            s.setInt(1, cdEntidade);
            int count = s.executeUpdate();
            log.debug((Object)("deleteAllLicitacoesButEntidade: count==" + count));
            conn.commit();
        }
        catch (SQLException e) {
            log.warn((Object)e);
            throw new RuntimeException(e);
        }
    }

    public static void deleteAllLicitacoesVencedoresButEntidade(int cdEntidade, Connection conn) {
        try {
            PreparedStatement s = conn.prepareStatement(SQL_TRUNCATE_LICITACOES_VENC_ALL_BUT);
            s.setInt(1, cdEntidade);
            int count = s.executeUpdate();
            log.debug((Object)("deleteAllLicitacoesVencedoresButEntidade: count==" + count));
            conn.commit();
        }
        catch (SQLException e) {
            log.warn((Object)e);
            throw new RuntimeException(e);
        }
    }

    public static void deleteAllContratosButEntidade(int cdEntidade, Connection conn) {
        try {
            PreparedStatement s = conn.prepareStatement(SQL_TRUNCATE_CONTRATOS_ALL_BUT);
            s.setInt(1, cdEntidade);
            int count = s.executeUpdate();
            log.debug((Object)("deleteAllContratosButEntidade: count==" + count));
            conn.commit();
        }
        catch (SQLException e) {
            log.warn((Object)e);
            throw new RuntimeException(e);
        }
    }

    static Scanner getScannerFromUrl(String url) throws IOException {
        URL servico = new URL(url);
        HttpURLConnection urlconn = (HttpURLConnection)servico.openConnection();
        urlconn.connect();
        int responseCode = urlconn.getResponseCode();
        if (responseCode != 200) {
            throw new RuntimeException("responseCode != 200 [" + responseCode + "]");
        }
        InputStream is = urlconn.getInputStream();
        return new Scanner(is);
    }

    private static String carregaConfigUrl() {
        return SiapcLicitaconClient.getProperty(ARQUIVO_PROPERTIES, PROP_WSLICITACON);
    }

    private static String getProperty(String arquivo, String property) {
        String url = null;
        try {
            File file = new File(arquivo);
            FileInputStream is = new FileInputStream(file);
            Properties props = new Properties();
            props.load(is);
            url = props.getProperty(property);
            ((InputStream)is).close();
            props.clear();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return url;
    }

    static long sumArray(int[] arr) {
        long ret = 0L;
        for (int i : arr) {
            ret += (long)i;
        }
        return ret;
    }

    static Integer getIntegerOrNull(String s) {
        if ("".equals(s)) {
            return null;
        }
        try {
            return Integer.parseInt(s);
        }
        catch (NumberFormatException e) {
            log.warn((Object)("getIntegerOrNull: " + e));
            return null;
        }
    }

    static BigDecimal getBigDecimalOrNull(String s) {
        if ("".equals(s)) {
            return null;
        }
        try {
            return new BigDecimal(s);
        }
        catch (NumberFormatException e) {
            log.warn((Object)("getBigDecimalOrNull: " + e));
            return null;
        }
    }
}

