/*
 * Decompiled with CFR 0.152.
 */
package br.gov.rs.tce.pad.visao.swing;

import br.gov.rs.tce.pad.excecao.PADRuntimeException;
import java.awt.Font;
import java.text.Format;
import java.text.NumberFormat;
import javax.swing.JFormattedTextField;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.MaskFormatter;
import javax.swing.text.PlainDocument;

public abstract class PadAbstractField
extends JFormattedTextField {
    public static final byte NORMAL = 0;
    public static final byte LOWERCASE = 1;
    public static final byte UPPERCASE = 2;
    private char[] maskSeparateSimbols = new char[]{'\\', '/', '-', '(', ')'};
    private int _maxLenght = 30;
    private Format _format = null;
    private MaskFormatter maskedit;

    public PadAbstractField() {
        this.setFont(new Font("Microsoft Sans Serif", 0, 11));
    }

    public PadAbstractField(NumberFormat numberformat) {
        super(numberformat);
        this.setFont(new Font("Microsoft Sans Serif", 0, 11));
    }

    public PadAbstractField(JFormattedTextField.AbstractFormatter formatter) {
        super(formatter);
        this.setFont(new Font("Microsoft Sans Serif", 0, 11));
    }

    public int getMaxLenght() {
        return this._maxLenght;
    }

    public void setMaxLenght(int lenght) {
        this._maxLenght = lenght;
        if (this.getDocument() instanceof PadPlainDocument) {
            ((PadPlainDocument)this.getDocument()).setMaxLength(this._maxLenght);
        }
    }

    public Format getFormat() {
        return this._format;
    }

    public void setFormat(Format format) {
        this._format = format;
    }

    public MaskFormatter getMaskEdit() {
        return this.maskedit;
    }

    public void setMaskEdit(MaskFormatter maskedit) {
        this.maskedit = maskedit;
    }

    public abstract String getTextSemMascara();

    protected boolean containsSeparateSimbol(char chr) {
        boolean exists = false;
        for (int index = 0; index < this.maskSeparateSimbols.length; ++index) {
            if (chr != this.maskSeparateSimbols[index]) continue;
            exists = true;
            break;
        }
        return exists;
    }

    class PadPlainDocument
    extends PlainDocument {
        private static final long serialVersionUID = 1L;
        private int maxLength = 10;
        private byte caseRestriction = 0;

        public PadPlainDocument(int maxLength) {
            this.setMaxLength(maxLength);
        }

        public PadPlainDocument() {
            this(10);
        }

        public int getMaxLength() {
            return this.maxLength;
        }

        public void setMaxLength(int maxLength) {
            this.maxLength = maxLength;
        }

        public byte getCaseRestriction() {
            return this.caseRestriction;
        }

        public void setCaseRestriction(byte caseRestriction) {
            if (caseRestriction == 0 || caseRestriction == 2 || caseRestriction == 1) {
                this.caseRestriction = caseRestriction;
            } else {
                try {
                    throw new PADRuntimeException("This case restriction " + caseRestriction + " not is accept.");
                }
                catch (PADRuntimeException e) {
                    e.printStackTrace();
                }
            }
        }

        private String ajustCaseRestrictionString(String str) {
            if (this.getCaseRestriction() == 2) {
                return str.toUpperCase();
            }
            if (this.getCaseRestriction() == 1) {
                return str.toLowerCase();
            }
            return str;
        }

        private int getTotalLength(String str) {
            return this.getLength() + str.length();
        }

        @Override
        public void insertString(int offset, String str, AttributeSet attr) throws BadLocationException {
            if (str == null) {
                return;
            }
            if (this.getTotalLength(str) <= this.maxLength) {
                super.insertString(offset, this.ajustCaseRestrictionString(str), attr);
            } else {
                if (this.getLength() == this.getMaxLength()) {
                    return;
                }
                String newStr = str.substring(0, this.maxLength - this.getLength());
                super.insertString(offset, this.ajustCaseRestrictionString(newStr), attr);
            }
        }

        @Override
        protected void insertUpdate(AbstractDocument.DefaultDocumentEvent chng, AttributeSet attr) {
            super.insertUpdate(chng, attr);
        }
    }
}

