/*
 * Decompiled with CFR 0.152.
 */
package br.gov.rs.tce.pad.visao.panel.quadros;

import br.gov.rs.tce.adf.util.TCETable;
import br.gov.rs.tce.pad.beans.Parametro;
import br.gov.rs.tce.pad.beans.QuadroAbstrato;
import br.gov.rs.tce.pad.beans.QuadroContas;
import br.gov.rs.tce.pad.beans.remessa.Remessa;
import br.gov.rs.tce.pad.resource.PadImage;
import br.gov.rs.tce.pad.visao.panel.quadros.TelaQuadroComum;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import oracle.adf.model.BindingContext;
import oracle.jbo.AttributeDef;
import oracle.jbo.uicli.binding.JUControlBinding;
import oracle.jbo.uicli.binding.JUCtrlValueBinding;
import oracle.jbo.uicli.controls.JUPanel;
import oracle.jbo.uicli.controls.JUStatusBar;
import oracle.jbo.uicli.jui.JUPanelBinding;

public class QuadroRelacionamento
extends TelaQuadroComum
implements JUPanel {
    private BorderLayout borderLayout1 = new BorderLayout();
    private JPanel pnlRodape = new JPanel();
    private JPanel pnlDireita = new JPanel();
    private JPanel pnlEsquerda = new JPanel();
    private JPanel pnlTopo = new JPanel();
    private JScrollPane spTabela = new JScrollPane();
    private TCETable tblRelacionamentos = new TCETable();
    private JButton btnPopup = new JButton();
    private BoxLayout rodapeLayout = new BoxLayout(this.pnlRodape, 2);
    private JUStatusBar sbNumRegistros = new JUStatusBar();
    private JLabel lblTitulo = new JLabel();
    private JPanel jPanel1 = new JPanel();
    private BorderLayout borderLayout2 = new BorderLayout();

    @Override
    protected void jbInit() throws Exception {
        this.setSize(new Dimension(620, 160));
        this.setLayout(this.borderLayout1);
        this.setPreferredSize(new Dimension(620, 160));
        this.setMinimumSize(new Dimension(620, 120));
        this.pnlRodape.setPreferredSize(new Dimension(620, 24));
        this.pnlRodape.setLayout(this.rodapeLayout);
        this.pnlTopo.setPreferredSize(new Dimension(620, 14));
        this.btnPopup.setIcon(PadImage.createImageIcon("imagens/icone_selecao.png"));
        this.btnPopup.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.btnPopup.setPreferredSize(new Dimension(23, 21));
        this.btnPopup.setToolTipText("Clique para selecionar as contas");
        this.btnPopup.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                QuadroRelacionamento.this.btnPopup_actionPerformed(e);
            }
        });
        this.tblRelacionamentos.setFont(new Font("SansSerif", 0, 10));
        this.sbNumRegistros.setHasMessageArea(false);
        this.sbNumRegistros.setHasModeIcon(false);
        this.sbNumRegistros.setHasModifiedFlag(false);
        this.sbNumRegistros.setHasRowCount(true);
        this.sbNumRegistros.setCurrentRowFormatString("Linha atual ######");
        this.sbNumRegistros.setRowCountFormatString("Total ###### linhas");
        this.pnlRodape.add(Box.createRigidArea(new Dimension(15, 0)));
        this.pnlRodape.add((Component)this.sbNumRegistros);
        this.pnlRodape.add(Box.createHorizontalGlue());
        this.pnlRodape.add(this.btnPopup);
        this.pnlRodape.add(Box.createRigidArea(new Dimension(5, 0)));
        this.add((Component)this.pnlRodape, "South");
        this.add((Component)this.pnlDireita, "East");
        this.add((Component)this.pnlEsquerda, "West");
        this.add((Component)this.pnlTopo, "North");
        this.spTabela.getViewport().add((Component)this.tblRelacionamentos, null);
        this.add((Component)this.spTabela, "Center");
        this.lblTitulo.setText("Titulo quadro");
        this.pnlTopo.setLayout(this.borderLayout2);
        this.pnlTopo.add((Component)this.jPanel1, "West");
        this.pnlTopo.add((Component)this.lblTitulo, "Center");
        this.pnlTopo.setSize(new Dimension(620, 16));
        this.ajustaTamanhoColunas(this.tblRelacionamentos, this.getColunasQuadro(), this.getTamanhoColunas());
        TableColumn c = this.tblRelacionamentos.getColumnModel().getColumn(this.tblRelacionamentos.getColumnModel().getColumnCount() - 1);
        this.lblTitulo.setFont(new Font("Tahoma", 1, 11));
        this.pnlTopo.setMinimumSize(new Dimension(620, 14));
        this.pnlDireita.setPreferredSize(new Dimension(5, 10));
        this.pnlDireita.setMinimumSize(new Dimension(5, 10));
        this.pnlDireita.setSize(new Dimension(5, 121));
        this.pnlEsquerda.setPreferredSize(new Dimension(5, 10));
        this.pnlEsquerda.setMinimumSize(new Dimension(5, 10));
        this.tblRelacionamentos.getTableHeader().setResizingColumn(c);
        this.tblRelacionamentos.doLayout();
        super.jbInit();
        this.sbNumRegistros.setVisible(false);
    }

    @Override
    protected void inicializaPropriedadesTela(Remessa remessa, QuadroContas quadroContas) {
        if (quadroContas != null) {
            this.btnPopup.setVisible(quadroContas.getTelaPopup() != null);
        }
        this.tblRelacionamentos.getTableHeader().setReorderingAllowed(false);
        this.tblRelacionamentos.getTableHeader().setDefaultRenderer(DEFAULT_HEADER_CELL_RENDERER);
        QuadroRelacionamento.desabilitaReziseColunasJTable(this.tblRelacionamentos);
    }

    @Override
    public final void initializaDataBindingsEspecificos(BindingContext bindCtx, QuadroContas quadroContas) {
        this.inicializaBindingQuadro(quadroContas, this.tblRelacionamentos, this.sbNumRegistros);
        QuadroRelacionamento.inicializaTableRenderers(this.tblRelacionamentos, quadroContas, quadroContas.getControlBindingName(), this._panelBinding);
    }

    @Override
    protected void ajustaLabelsQuadro(Remessa remessa, QuadroContas quadro) throws IllegalArgumentException {
        String tituloQuadro;
        if (quadro.getAlturaQuadro() > 0) {
            this.setSize((int)this.getSize().getWidth(), quadro.getAlturaQuadro());
            this.setPreferredSize(this.getSize());
        }
        this.pnlTopo.setVisible((tituloQuadro = quadro.getTituloFormatado(remessa)) != null);
        if (tituloQuadro != null) {
            this.lblTitulo.setText(tituloQuadro);
        }
        if (quadro.hasTituloColunas()) {
            TableColumnModel model = this.tblRelacionamentos.getColumnModel();
            String[] titulos = quadro.getTituloColunasArray();
            if (titulos.length != model.getColumnCount()) {
                throw new IllegalArgumentException("O numero de titulos de colunas do quadro n\u00e3o corresponde ao numero de colunas exibidos no quadro");
            }
            for (int i = 0; i < titulos.length; ++i) {
                model.getColumn(i).setHeaderValue(titulos[i]);
            }
        }
    }

    protected static void inicializaTableRenderers(JTable tabela, QuadroAbstrato quadroContas, String nomeTableCtrlBinding, JUPanelBinding panelBinding) {
        if (tabela == null) {
            return;
        }
        if (panelBinding == null) {
            throw new IllegalArgumentException("PanelBinding n\u00e3o pode ser nulo");
        }
        JUControlBinding ctrBinding = panelBinding.findControlBinding(nomeTableCtrlBinding);
        if (ctrBinding == null) {
            throw new IllegalArgumentException("N\u00e3o foi possivel localizar o Controlbinding: " + nomeTableCtrlBinding);
        }
        AttributeDef[] defs = ((JUCtrlValueBinding)ctrBinding).getAttributeDefs();
        for (int i = 0; i < defs.length; ++i) {
            Class type = defs[i].getJavaType();
            Object renderer = null;
            if (!"CdConta".equals(defs[i].getName())) continue;
            Parametro paramFormatoCdConta = quadroContas.getParametroPorNome("formato-codigo-conta");
            String formatoCdConta = null;
            formatoCdConta = paramFormatoCdConta != null ? paramFormatoCdConta.getValor() : "00000000000000000000";
            TableColumn coluna = tabela.getColumnModel().getColumn(i);
            DefaultTableCellRenderer cdContaRenderer = QuadroRelacionamento.criaTableCellRendererCdConta(formatoCdConta.length());
            cdContaRenderer.setBackground(Color.WHITE);
            coluna.setCellRenderer(cdContaRenderer);
        }
    }

    @Override
    public void finalizaTelaEspecifico() {
    }
}

