/*
 * Decompiled with CFR 0.152.
 */
package br.gov.rs.tce.pad.visao.panel.action;

import br.gov.rs.tce.pad.beans.remessa.Remessa;
import br.gov.rs.tce.pad.excecao.PADActionException;
import br.gov.rs.tce.pad.modelo.servico.common.ServicoPAD;
import br.gov.rs.tce.pad.visao.PadModelo;
import br.gov.rs.tce.pad.visao.PadWizardForm;
import br.gov.rs.tce.pad.visao.PadWizardHelper;
import br.gov.rs.tce.pad.visao.action.PadAbstractAction;
import br.gov.rs.tce.pad.visao.panel.TelaUC201;
import br.gov.rs.tce.pad.visao.panel.action.ActionAvancarUC041;
import java.sql.Date;
import java.text.MessageFormat;
import oracle.adf.model.BindingContext;
import oracle.jbo.Row;
import oracle.jbo.ViewObject;

public class ActionAvancarUC201
extends PadAbstractAction {
    private static final String MENSAGEM_VALIDACAO_DATA = "A data da audi\u00eancia p\u00fablica no {0} quadrimestre {1} n\u00e3o pode ser inferior ao fechamento do Quadrimestre e tamb\u00e9m n\u00e3o pode superar a data de preenchimento em mais de sessenta dias.";
    private static final String MENSAGEM_VALIDACAO_DESC = "O Campo Local no {0} quadrimestre {1} deve estar preenchido adequadamente.";

    @Override
    public boolean executaAction(PadModelo tela, BindingContext binding) throws PADActionException {
        ServicoPAD ser = ActionAvancarUC201.getServicoPADAppModule(binding);
        ViewObject vo = ser.findViewObject("AudienciasPublicasDataLocalView");
        Row row = vo.getCurrentRow();
        Date dtPrimeiroQuadriAtual = (Date)row.getAttribute("dtAtualPrimeiro");
        Date dtSegundoQuadriAtual = (Date)row.getAttribute("dtAualSegundo");
        Date dtTerceiroQuadriAnter = (Date)row.getAttribute("dtAnterior");
        String descPrimeiroQuadriAtual = (String)row.getAttribute("descAtualPrimeiro");
        String descSegundoQuadriAtual = (String)row.getAttribute("descAtualSegundo");
        String descTerceiroQuadriAnter = (String)row.getAttribute("descAnterior");
        PadWizardForm form = PadWizardHelper.getInstance().getForm();
        Remessa remessa = ActionAvancarUC201.getRemessaDataControl(binding);
        int anoExercicio = remessa.getAnoExercicio();
        int periodoInformacoes = remessa.getPeriodoInformacoes();
        TelaUC201 tela201 = (TelaUC201)tela;
        if (tela201.verificaDataInformada()) {
            ActionAvancarUC201.exibeMensagemAviso("Se a data de realiza\u00e7\u00e3o e o local n\u00e3o foram informados, \u00e9 preciso desabilitar o campo correspondente!.", form);
            return false;
        }
        if (!ActionAvancarUC041.validaDataPeriodo(dtTerceiroQuadriAnter, 6, anoExercicio - 1)) {
            ActionAvancarUC201.exibeMensagemAviso(MessageFormat.format(MENSAGEM_VALIDACAO_DATA, "terceiro", "anterior"), form);
            return false;
        }
        if (!this.validaDescricao(descTerceiroQuadriAnter)) {
            ActionAvancarUC201.exibeMensagemAviso(MessageFormat.format(MENSAGEM_VALIDACAO_DESC, "terceiro", "anterior"), form);
            return false;
        }
        if (dtTerceiroQuadriAnter != null && !"".equals(descTerceiroQuadriAnter)) {
            this.persiste(dtTerceiroQuadriAnter, descTerceiroQuadriAnter, remessa, ser, "0", binding);
        } else {
            this.desiste(remessa, ser, "0", binding);
        }
        if (periodoInformacoes >= 2) {
            if (!ActionAvancarUC041.validaDataPeriodo(dtPrimeiroQuadriAtual, 2, anoExercicio)) {
                ActionAvancarUC201.exibeMensagemAviso(MessageFormat.format(MENSAGEM_VALIDACAO_DATA, "primeiro", "atual"), form);
                return false;
            }
            if (!this.validaDescricao(descPrimeiroQuadriAtual)) {
                ActionAvancarUC201.exibeMensagemAviso(MessageFormat.format(MENSAGEM_VALIDACAO_DESC, "primeiro", "atual"), form);
                return false;
            }
            if (dtPrimeiroQuadriAtual != null && !"".equals(descPrimeiroQuadriAtual)) {
                this.persiste(dtPrimeiroQuadriAtual, descPrimeiroQuadriAtual, remessa, ser, "1", binding);
            } else {
                this.desiste(remessa, ser, "1", binding);
            }
        }
        if (periodoInformacoes >= 4) {
            if (!ActionAvancarUC041.validaDataPeriodo(dtSegundoQuadriAtual, 4, anoExercicio)) {
                ActionAvancarUC201.exibeMensagemAviso(MessageFormat.format(MENSAGEM_VALIDACAO_DATA, "segundo", "atual"), form);
                return false;
            }
            if (!this.validaDescricao(descSegundoQuadriAtual)) {
                ActionAvancarUC201.exibeMensagemAviso(MessageFormat.format(MENSAGEM_VALIDACAO_DESC, "terceiro", "anterior"), form);
                return false;
            }
            if (dtSegundoQuadriAtual != null && !"".equals(descSegundoQuadriAtual)) {
                this.persiste(dtSegundoQuadriAtual, descSegundoQuadriAtual, remessa, ser, "2", binding);
            } else {
                this.desiste(remessa, ser, "2", binding);
            }
        }
        ViewObject voData = ser.findViewObject("AudienciasPublicasDataLocalView");
        voData.executeQuery();
        voData.first();
        log.debug((Object)("N\u00ba Linhas View Audiencias Publicas = " + voData.getRowCount()));
        log.debug((Object)("Transacao Suja/Modificada ? = " + ser.getTransaction().isDirty() + " / " + binding.findDataControl("ServicoPADDataControl").isTransactionModified()));
        return true;
    }

    private boolean validaDescricao(String descricao) {
        boolean retorno = false;
        if (descricao == null || "".equalsIgnoreCase(descricao)) {
            retorno = true;
        } else if (descricao.length() > 3) {
            retorno = true;
        }
        return retorno;
    }

    private void persiste(Date dataTela, String descTela, Remessa remessa, ServicoPAD ser, String periodo, BindingContext binding) {
        ViewObject vo = ser.findViewObject("PublicacoesDaRemessa");
        vo.setWhereClause(null);
        vo.setWhereClauseParams(null);
        vo.setWhereClause("TP_PERIODO = 'Q' AND TP_PUBLICACAO = 'A' AND PODER = 'E' AND PERIODO = " + periodo);
        System.out.println(">>> SQL = " + vo.getQuery());
        System.out.println("entidade = " + remessa.getCdEntidade());
        System.out.println("remessa = " + remessa.getCdRemessa());
        System.out.println(">>" + vo.getRowCount());
        vo.executeQuery();
        Row row = null;
        if (vo.getRowCount() == 0) {
            row = vo.createRow();
            row.setAttribute("CdEntidade", (Object)remessa.getCdEntidade());
            row.setAttribute("CdRemessa", (Object)remessa.getCdRemessa());
            row.setAttribute("TpPeriodo", (Object)"Q");
            row.setAttribute("Periodo", (Object)periodo);
            row.setAttribute("TpPublicacao", (Object)"A");
            row.setAttribute("Descricao", (Object)descTela);
            row.setAttribute("DtPublicacao", (Object)dataTela);
            row.setAttribute("Poder", (Object)"E");
            vo.insertRow(row);
        } else {
            row = vo.getCurrentRow();
            row.setAttribute("Descricao", (Object)descTela);
            row.setAttribute("DtPublicacao", (Object)dataTela);
        }
        this.salvaDadosRemessa(binding);
    }

    private void desiste(Remessa remessa, ServicoPAD ser, String periodo, BindingContext binding) {
        ViewObject vo = ser.findViewObject("PublicacoesDaRemessa");
        vo.setWhereClause(null);
        vo.setWhereClauseParams(null);
        vo.setWhereClause("TP_PERIODO = 'Q' AND TP_PUBLICACAO = 'A' AND PODER = 'E' AND PERIODO = " + periodo);
        System.out.println(">>> SQL = " + vo.getQuery());
        System.out.println("entidade = " + remessa.getCdEntidade());
        System.out.println("remessa = " + remessa.getCdRemessa());
        vo.executeQuery();
        Row row = null;
        if (vo.getRowCount() != 0) {
            row = vo.getCurrentRow();
            row.remove();
        }
        this.salvaDadosRemessa(binding);
    }
}

