/*
 * Decompiled with CFR 0.152.
 */
package br.gov.rs.tce.pad.visao.panel.action;

import br.gov.rs.tce.pad.beans.TipoJustificativa;
import br.gov.rs.tce.pad.beans.remessa.Remessa;
import br.gov.rs.tce.pad.beans.types.IdentificadorConta;
import br.gov.rs.tce.pad.excecao.PADActionException;
import br.gov.rs.tce.pad.modelo.decisao.tela.DecisaoUC058;
import br.gov.rs.tce.pad.modelo.servico.common.ServicoPAD;
import br.gov.rs.tce.pad.visao.PadModelo;
import br.gov.rs.tce.pad.visao.action.PadAbstractAction;
import br.gov.rs.tce.pad.visao.panel.TelaUC058;
import java.awt.Component;
import oracle.adf.model.BindingContext;
import oracle.jbo.Row;
import oracle.jbo.ViewObject;

public class ActionAvancarUC058
extends PadAbstractAction {
    @Override
    public boolean executaAction(PadModelo tela, BindingContext binding) throws PADActionException {
        TelaUC058 t = (TelaUC058)tela;
        String resposta = t.getRespostaPergunta();
        if (resposta != null) {
            int nroHabitantes;
            if ("S".equals(resposta) && (nroHabitantes = t.getNroHabitantes()) > 50000) {
                ActionAvancarUC058.exibeMensagemAviso("De acordo com as informa\u00e7\u00f5es contidas no site do IBGE o quantitativo populacional do Munic\u00edpio obriga a entrega dos Demonstrativos da Lei de responsabilidade Fiscal na periodicidade QUADRIMESTRAL.", (Component)((Object)tela));
                return false;
            }
            ServicoPAD ser = ActionAvancarUC058.getServicoPADAppModule(binding);
            ViewObject voRemessa = ser.findViewObject("RemessasDaEntidade");
            Row remessaRow = voRemessa.getCurrentRow();
            if (remessaRow != null) {
                remessaRow.setAttribute("TpEntrega", (Object)resposta);
            }
            ActionAvancarUC058.getRemessaDataControl(binding).setTipoEntrega(resposta);
            this.salvaDadosRemessa(binding);
            this.limpaDadosLrf(binding);
            return true;
        }
        ActionAvancarUC058.exibeMensagemAviso("Voc\u00ea deve selecionar uma forma de entrega!", (Component)((Object)tela));
        return false;
    }

    public void limpaDadosLrf(BindingContext binding) {
        DecisaoUC058 decisao = new DecisaoUC058();
        String proximaTela = decisao.escolheProximaTela("UC058", binding);
        if (proximaTela == "PreUC081") {
            ServicoPAD ser = ActionAvancarUC058.getServicoPADAppModule(binding);
            Remessa remessa = ser.getRemessaPrincipal();
            ViewObject voContas = ser.findViewObject("ContasRemessaViewSelecao");
            if (voContas != null) {
                voContas.clearCache();
                voContas.setWhereClauseParams(null);
                voContas.setWhereClause(null);
                voContas.setWhereClause("CD_TIPO NOT IN (110,111,112,113,114) AND IDENTIFICADOR_CONTA = " + IdentificadorConta.IDENTIFICADOR_CONTA_MODELO.getCodigo() + " AND CD_ENTIDADE = " + remessa.getCdEntidade());
                voContas.executeQuery();
                voContas.first();
                voContas.previous();
                while (voContas.hasNext()) {
                    voContas.next().remove();
                }
            }
            ser.getTransaction().executeCommand("DELETE FROM PUBLICACOES WHERE CD_ENTIDADE = " + remessa.getCdEntidade() + " AND TP_PERIODO IN ('Q', 'S') AND TP_PUBLICACAO IN ('J','M','I') AND PODER IN ('L', 'E')");
            ViewObject voPublicacoes = ser.findViewObject("PublicacoesDaRemessa");
            if (voPublicacoes != null) {
                voPublicacoes.clearCache();
                voPublicacoes.executeQuery();
            }
            ser.getTransaction().executeCommand("DELETE FROM JUSTIFICATIVAS WHERE CD_ENTIDADE = " + remessa.getCdEntidade() + " AND TIPO_PLANILHA = " + TipoJustificativa.JUSTIFICA_MODELOS_SELECAO_MANUAL.getCodigo() + " OR TIPO_PLANILHA = " + TipoJustificativa.JUSTIFICA_MODELOS_ADICAO_EXCLUSAO.getCodigo());
            ser.getTransaction().executeCommand("DELETE FROM JUSTIFICATIVAS WHERE CD_ENTIDADE = " + remessa.getCdEntidade() + " AND TIPO_PLANILHA = " + TipoJustificativa.JUSTIFICA_MED_CORRETIVAS.getCodigo() + " AND (CD_PLANILHA = 1 OR CD_PLANILHA = 2 OR CD_PLANILHA = 4 OR CD_PLANILHA = 5 OR CD_PLANILHA = 61 OR CD_PLANILHA = 62 OR CD_PLANILHA = 10)");
            ViewObject voJustificativas = ser.findViewObject("JustificativasDaRemessa");
            if (voJustificativas != null) {
                voJustificativas.clearCache();
                voJustificativas.executeQuery();
            }
            ser.getTransaction().executeCommand("UPDATE REMESSAS SET MANIFESTACAO_CONCLUSIVA = '' WHERE CD_ENTIDADE = " + remessa.getCdEntidade() + " AND REMESSA_PRINCIPAL = 'S'");
            ViewObject voRemessa = ser.findViewObject("RemessasDaEntidade");
            if (voRemessa != null) {
                voRemessa.clearCache();
                voRemessa.executeQuery();
            }
            if (remessa.isPossuiCamaraIntegrada()) {
                ser.getTransaction().executeCommand("UPDATE REMESSAS_CAMARAS SET MANIFESTACAO_CONCLUSIVA = '' WHERE CD_ENTIDADE = " + remessa.getCdEntidade());
                ViewObject voRemessaCamara = ser.findViewObject("DadosRemessaCamara");
                if (voRemessaCamara != null) {
                    voRemessaCamara.clearCache();
                    voRemessaCamara.executeQuery();
                }
            }
            ser.getTransaction().commit();
        }
    }
}

