/*
 * Decompiled with CFR 0.152.
 */
package br.gov.rs.tce.pad.visao.panel.action;

import br.gov.rs.tce.pad.beans.Arquivo;
import br.gov.rs.tce.pad.beans.Arquivos;
import br.gov.rs.tce.pad.beans.remessa.Remessa;
import br.gov.rs.tce.pad.beans.types.TipoEntidadesList;
import br.gov.rs.tce.pad.excecao.ConfiguracaoException;
import br.gov.rs.tce.pad.excecao.PADActionException;
import br.gov.rs.tce.pad.excecao.SenhaInvalidaException;
import br.gov.rs.tce.pad.modelo.ConfiguracaoControle;
import br.gov.rs.tce.pad.modelo.ConstantesArquivos;
import br.gov.rs.tce.pad.modelo.RemessaControle;
import br.gov.rs.tce.pad.modelo.relatorio.RelatorioControle;
import br.gov.rs.tce.pad.modelo.servico.common.ServicoPAD;
import br.gov.rs.tce.pad.util.DatacontrolHelper;
import br.gov.rs.tce.pad.util.ProcessaArquivoHelper;
import br.gov.rs.tce.pad.util.VersaoUtils;
import br.gov.rs.tce.pad.visao.PadDesktop;
import br.gov.rs.tce.pad.visao.PadModelo;
import br.gov.rs.tce.pad.visao.PadWizardForm;
import br.gov.rs.tce.pad.visao.PadWizardHelper;
import br.gov.rs.tce.pad.visao.action.PadAbstractAction;
import br.gov.rs.tce.pad.visao.panel.TelaUC029;
import java.awt.Component;
import java.io.File;
import java.util.List;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import oracle.adf.model.BindingContext;

public class ActionAvancarUC029
extends PadAbstractAction {
    private TelaUC029 _tela029;
    private static int flagGeracao = 1;

    public ActionAvancarUC029() {
        this.setCriaThreadTratamentoAcao(true);
    }

    @Override
    public boolean executaAction(PadModelo tela, BindingContext binding) throws PADActionException {
        boolean retorno;
        block15: {
            retorno = false;
            try {
                File arquivoPFX = null;
                char[] senha = null;
                this._tela029 = (TelaUC029)tela;
                this._tela029.setStatus("");
                Remessa remessa = ActionAvancarUC029.getRemessaDataControl(binding);
                if (remessa.getTipoOperacao() != 2) {
                    if (!this.verificaExistenciaArquivos(remessa, (Component)((Object)tela), binding)) {
                        return false;
                    }
                    if (this.verificaAlteracaoArquivos(remessa, binding)) {
                        ActionAvancarUC029.exibeMensagemAviso("<html>N\u00e3o ser\u00e1 poss\u00edvel gravar a remessa porque foram detectadas altera\u00e7\u00f5es nos arquivos TXT de informa\u00e7\u00f5es, <BR>ser\u00e1 necess\u00e1rio realizar novamente a carga e verifica\u00e7\u00e3o dos arquivos de informa\u00e7\u00f5es.<BR><BR><B>Aviso IMPORTANTE:</B> Todas as informa\u00e7\u00f5es digitadas no programa ap\u00f3s a carga dos arquivos ser\u00e3o perdidas.</html>", (Component)((Object)tela));
                        return false;
                    }
                }
                if (!this.verificaVersaoTabela(ActionAvancarUC029.getServicoPADAppModule(binding))) {
                    return false;
                }
                if (flagGeracao == 1) {
                    remessa.setTipoCertificado("D");
                    Remessa remPrincipal = this.getRemessaPrincipal(binding);
                    remPrincipal.setTipoCertificado(remessa.getTipoCertificado());
                    remPrincipal.setTipoOperacao(remessa.getTipoOperacao());
                    remPrincipal.setDataFinal(remessa.getDataFinal());
                    remPrincipal.setTipoSetor(remessa.getTipoSetor());
                    remPrincipal.setTipoResponsaveis(remessa.getTipoResponsaveis());
                    if (remessa.getTipoOperacao() == 6) {
                        remPrincipal.setArquivosComplementares(ActionAvancarUC029.getServicoPADAppModule(binding).buscaArquivosComplementaresSelecionados());
                    }
                    try {
                        ActionAvancarUC029.getServicoPADAppModule(binding).atualizaCampoRemessa("VersaoPad", "25.0.0.8");
                        ActionAvancarUC029.getServicoPADAppModule(binding).getTransaction().commit();
                    }
                    catch (Exception e) {
                        log.error((Object)"Erro ao setar vers\u00e3o do pad na tabela", (Throwable)e);
                    }
                    this.salvaDadosRemessa(binding);
                    NotificaEventos notifica = new NotificaEventos();
                    RelatorioControle relatorios = new RelatorioControle(notifica);
                    try {
                        RemessaControle ctrl = new RemessaControle(remPrincipal, new File(ConstantesArquivos.PATH_GRAVACAO_DESKTOP), notifica);
                        log.debug((Object)"vai limpar PDFs da pasta remessa");
                        ctrl.removeArquivosPdfRemessa();
                        log.debug((Object)"vai gerar relatorios");
                        relatorios.geraRelatorios(remPrincipal, DatacontrolHelper.getServicoPADAppModule(binding), null, new File(ConstantesArquivos.PATH_GRAVACAO_DESKTOP), true, false);
                        log.debug((Object)"gerou relatorios");
                        log.debug((Object)"vai gerar remessa");
                        ctrl.geraRemessa(ActionAvancarUC029.getServicoPADAppModule(binding), senha, arquivoPFX, remessa.getTipoOperacao() != 2);
                        log.debug((Object)"gerou remessa");
                        retorno = true;
                        log.debug((Object)"vai gerar relatorios em pdf");
                        relatorios.geraRelatorios(remPrincipal, DatacontrolHelper.getServicoPADAppModule(binding), null, new File(ConstantesArquivos.PATH_GRAVACAO_DESKTOP), false, true);
                        log.debug((Object)"gerou relatorios pdf");
                        ctrl.compactaArquivosXmlPDF(true);
                        ctrl.geraArquivoCrpPDFs();
                        ctrl.geraZipAssinado();
                        log.debug((Object)"removendo arquivos temporarios");
                        ctrl.removeArquivosRemessa();
                        remessa.setRemessaInfo(remPrincipal.getRemessaInfo());
                    }
                    catch (SenhaInvalidaException e) {
                        PadWizardForm form = PadWizardHelper.getInstance().getForm();
                        ActionAvancarUC029.exibeMensagemAviso(e.getMessage(), form);
                        return false;
                    }
                    catch (ConfiguracaoException e) {
                        log.warn((Object)e.getMessage(), (Throwable)((Object)e));
                        PadWizardForm form = PadWizardHelper.getInstance().getForm();
                        ActionAvancarUC029.exibeMensagemAviso(e.getMessage(), form);
                        return false;
                    }
                    catch (IllegalStateException e) {
                        PadWizardForm form = PadWizardHelper.getInstance().getForm();
                        ActionAvancarUC029.exibeMensagemAviso(e.getMessage(), form);
                        return false;
                    }
                    if (retorno) {
                        flagGeracao = 0;
                        this._tela029.setBotao("Avan\u00e7ar >");
                        PadWizardForm form = PadWizardHelper.getInstance().getForm();
                        ActionAvancarUC029.exibeMensagemAviso("Arquivo de Remessa Gerado com Sucesso", form);
                        this._tela029.setMensagem("Clique em \"Avan\u00e7ar\" para continuar, ou \"Fechar\" para sair do PAD");
                    }
                    retorno = false;
                    break block15;
                }
                retorno = true;
            }
            catch (OutOfMemoryError er) {
                String message = "O sistema n\u00e3o conseguiu realizar a gera\u00e7\u00e3o da remessa. Entre em contato com o Tribunal de Contas do Estado (Out Of Memory).";
                log.warn((Object)message, (Throwable)er);
                PadWizardForm form = PadWizardHelper.getInstance().getForm();
                ActionAvancarUC029.exibeMensagemAviso(message, form);
            }
        }
        return retorno;
    }

    public void setFlagAssinatura(int flag) {
        flagGeracao = flag;
    }

    private boolean verificaExistenciaArquivos(Remessa remessa, Component tela, BindingContext binding) {
        ServicoPAD servicoPad = ActionAvancarUC029.getServicoPADAppModule(binding);
        boolean acessiveis = true;
        Arquivos arquivos = (Arquivos)ConfiguracaoControle.carregaDadosArquivoXML(servicoPad.resolveArquivoConfigFluxo(remessa.getTipoOperacao()));
        List<Arquivo> arquivosSel = arquivos.getArquivosPorLeiEntidade(TipoEntidadesList.getLeiPorTipoSetor(remessa.getTipoSetor()), remessa.getTipoSetor(), remessa.getPeriodoInformacoes(), remessa.getMes(), remessa.getTipoOperacao());
        arquivosSel = servicoPad.removeArqComplementaresNaoSelecinados(arquivosSel);
        List<String> arqIgnList = servicoPad.getArquivosIgnoraveis();
        for (int i = 0; i < arquivosSel.size(); ++i) {
            Arquivo arq = arquivosSel.get(i);
            String caminho = remessa.getDiretorioOrigem() + File.separator + arq.getNome();
            File arquivo = new File(caminho);
            if (arquivo.canRead()) continue;
            if (arqIgnList.contains(arq.getNome())) {
                log.info((Object)("ignorando arquivo " + arq.getNome()));
                continue;
            }
            ActionAvancarUC029.exibeMensagemAviso("<html>N\u00e3o foi poss\u00edvel encontrar o arquivo " + arq.getNome() + ".<br>Verifique se o arquivo est\u00e1 acess\u00edvel no diret\u00f3rio <br>" + remessa.getDiretorioOrigem() + "</html>", tela);
            acessiveis = false;
            break;
        }
        return acessiveis;
    }

    private boolean verificaAlteracaoArquivos(Remessa remessa, BindingContext binding) {
        if (VersaoUtils.isDebugModeEnabled()) {
            return false;
        }
        ServicoPAD servicoPad = ActionAvancarUC029.getServicoPADAppModule(binding);
        Arquivos arquivos = (Arquivos)ConfiguracaoControle.carregaDadosArquivoXML(servicoPad.resolveArquivoConfigFluxo(remessa.getTipoOperacao()));
        List<Arquivo> arquivosSel = arquivos.getArquivosPorLeiEntidade(TipoEntidadesList.getLeiPorTipoSetor(remessa.getTipoSetor()), remessa.getTipoSetor(), remessa.getPeriodoInformacoes(), remessa.getMes(), remessa.getTipoOperacao());
        return !ProcessaArquivoHelper.validaIntegridadeArquivosInformacoes(arquivosSel = servicoPad.removeArqComplementaresNaoSelecinados(arquivosSel), remessa);
    }

    public boolean verificaVersaoTabela(ServicoPAD servicoPADApp) {
        VersaoUtils validaVersao = new VersaoUtils(servicoPADApp);
        PadWizardForm padForm = PadWizardHelper.getInstance().getForm();
        if (validaVersao.getVersaoPADDatabase() == null) {
            ActionAvancarUC029.exibeMensagemErro("Foi detectado que a base de dados em uso n\u00e3o corresponde \u00e0 vers\u00e3o do PAD instalada na m\u00e1quina.\n O PAD deve ser instalado novamente em um diret\u00f3rio vazio e nenhum arquivo deve ser alterado ap\u00f3s\n o t\u00e9rmino do procedimento.", padForm);
            padForm.setTitle("PAD " + PadDesktop.getVersaoTitulo() + " (Base de Dados Inv\u00e1lida)");
            return false;
        }
        padForm.setTitle("PAD " + PadDesktop.getVersaoTitulo());
        return true;
    }

    class NotificaEventos
    implements ChangeListener {
        NotificaEventos() {
        }

        @Override
        public void stateChanged(ChangeEvent event) {
            try {
                RemessaControle copia;
                if (event.getSource() instanceof RelatorioControle) {
                    RelatorioControle copia2 = (RelatorioControle)event.getSource();
                    if (copia2.getSituacao() != null) {
                        ActionAvancarUC029.this._tela029.addStatus(copia2.getSituacao());
                    }
                } else if (event.getSource() instanceof RemessaControle && (copia = (RemessaControle)event.getSource()).getSituacao() != null) {
                    ActionAvancarUC029.this._tela029.addStatus(copia.getSituacao());
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

