/*
 * Decompiled with CFR 0.152.
 */
package br.gov.rs.tce.pad.visao.panel;

import br.gov.rs.tce.pad.modelo.servico.acessodados.ConsorciosViewRowImpl;
import br.gov.rs.tce.pad.modelo.servico.common.ServicoPAD;
import br.gov.rs.tce.pad.util.DatacontrolHelper;
import br.gov.rs.tce.pad.util.ValidaCNPJ;
import br.gov.rs.tce.pad.visao.PadModelo;
import br.gov.rs.tce.pad.visao.PadWizardForm;
import br.gov.rs.tce.pad.visao.PadWizardHelper;
import br.gov.rs.tce.pad.visao.panel.PadNavigationBar;
import br.gov.rs.tce.pad.visao.panel.TelaUC220RowSetListener;
import br.gov.rs.tce.pad.visao.swing.PadNumberField;
import br.gov.rs.tce.pad.visao.util.DocumentSizeFilter;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseListener;
import java.util.EventObject;
import javax.swing.ButtonGroup;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import javax.swing.text.AbstractDocument;
import javax.swing.text.Document;
import oracle.adf.model.BindingContext;
import oracle.jbo.ViewObject;
import oracle.jbo.uicli.binding.JUFormBinding;
import oracle.jbo.uicli.binding.JUUtil;
import oracle.jbo.uicli.controls.JUNavigationBar;
import oracle.jbo.uicli.controls.JUPanel;
import oracle.jbo.uicli.controls.JUTestFrame;
import oracle.jbo.uicli.jui.JUPanelBinding;
import oracle.jdeveloper.layout.XYConstraints;
import oracle.jdeveloper.layout.XYLayout;

public class TelaUC220
extends JPanel
implements JUPanel,
PadModelo {
    private XYLayout xyLayout = new XYLayout();
    private BorderLayout borderLayout = new BorderLayout();
    private GridLayout gridLayout = new GridLayout();
    private JUNavigationBar navigationBar;
    private JPanel panelSul = new JPanel();
    private JPanel panelNorte = new JPanel();
    private JPanel dataPanel = new JPanel();
    private JUPanelBinding panelBinding = new JUPanelBinding("TelaUC220UIModel");
    private JScrollPane scroller = new JScrollPane();
    private JTable tableConsorcios = new JTable();
    private JLabel labelPergunta = new JLabel();
    private JLabel labelObservacao = new JLabel();
    private JLabel labelCNPJConsorcio = new JLabel();
    private JLabel labelNomeConsorcio = new JLabel();
    private JRadioButton radioButtonSim = new JRadioButton();
    private JRadioButton radioButtonNao = new JRadioButton();
    private ButtonGroup buttonGroup = new ButtonGroup();
    protected JTextField textFieldCNPJConsorcio = new PadNumberField("99999999999999");
    protected JTextField textFieldNomeConsorcio = new JTextField();

    public void jbInit() throws Exception {
        this.setLayout(this.borderLayout);
        this.setBounds(new Rectangle(0, 0, 620, 320));
        this.dataPanel.setLayout(this.gridLayout);
        this.dataPanel.setMinimumSize(new Dimension(100, 100));
        this.dataPanel.setBounds(new Rectangle(0, 100, 620, 200));
        this.dataPanel.setPreferredSize(new Dimension(620, 120));
        this.dataPanel.add(this.scroller);
        this.scroller.setSize(new Dimension(620, 200));
        this.scroller.setPreferredSize(new Dimension(620, 120));
        this.scroller.getViewport().add((Component)this.tableConsorcios, null);
        this.navigationBar = new PadNavigationBar(this);
        this.navigationBar.setFloatable(false);
        this.navigationBar.setHasExecuteButton(false);
        this.navigationBar.setHasFindButton(false);
        this.panelSul.add((Component)this.navigationBar, null);
        this.labelPergunta.setText("O Munic\u00edpio faz parte de Cons\u00f3rcio P\u00fablico, regido pela Lei Federal 11.107/2005?");
        this.radioButtonSim.setText("Sim");
        this.radioButtonNao.setText("N\u00e3o");
        this.labelObservacao.setText("Obs: Se for respondido \"Sim\" relacionar abaixo o(s) Cons\u00f3rcio(s).");
        this.labelCNPJConsorcio.setText("CNPJ do Cons\u00f3rcio");
        this.labelCNPJConsorcio.setFont(new Font("Dialog", 1, 11));
        this.labelNomeConsorcio.setText("Nome do Cons\u00f3rcio");
        this.labelNomeConsorcio.setFont(new Font("Dialog", 1, 11));
        this.panelNorte.setLayout((LayoutManager)this.xyLayout);
        this.panelNorte.add((Component)this.labelPergunta, new XYConstraints(20, 20, 480, 15));
        this.panelNorte.add((Component)this.radioButtonSim, new XYConstraints(30, 45, 255, 25));
        this.panelNorte.add((Component)this.radioButtonNao, new XYConstraints(30, 70, 255, 25));
        this.panelNorte.add((Component)this.labelObservacao, new XYConstraints(20, 105, 450, 15));
        this.panelNorte.add((Component)this.labelCNPJConsorcio, new XYConstraints(20, 130, 150, 15));
        this.panelNorte.add((Component)this.textFieldCNPJConsorcio, new XYConstraints(20, 145, 255, 20));
        this.panelNorte.add((Component)this.labelNomeConsorcio, new XYConstraints(300, 130, 150, 15));
        this.panelNorte.add((Component)this.textFieldNomeConsorcio, new XYConstraints(300, 145, 300, 20));
        this.panelNorte.setBounds(new Rectangle(0, 0, 620, 100));
        this.panelNorte.setMinimumSize(new Dimension(480, 180));
        this.panelNorte.setPreferredSize(new Dimension(480, 180));
        this.panelNorte.setSize(new Dimension(480, 90));
        this.add((Component)this.panelSul, "South");
        this.add((Component)this.panelNorte, "North");
        this.add((Component)this.dataPanel, "Center");
        this.navigationBar.setModel(JUNavigationBar.createViewBinding((JUPanelBinding)this.panelBinding, (JUNavigationBar)this.navigationBar, (String)"ConsorciosView", null, (String)"ConsorciosViewIterator"));
        this.tableConsorcios.setModel((TableModel)this.panelBinding.bindUIControl("ConsorciosView", (Object)this.tableConsorcios));
        this.textFieldCNPJConsorcio.setDocument((Document)this.panelBinding.bindUIControl("Cgc", (Object)this.textFieldCNPJConsorcio));
        this.textFieldNomeConsorcio.setDocument((Document)this.panelBinding.bindUIControl("NmConsorcio", (Object)this.textFieldNomeConsorcio));
        ((AbstractDocument)this.textFieldNomeConsorcio.getDocument()).setDocumentFilter(new DocumentSizeFilter(60));
        this.radioButtonSim.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                TelaUC220.this.refreshFields(true);
            }
        });
        this.radioButtonNao.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                TelaUC220.this.refreshFields(false);
            }
        });
        this.buttonGroup.add(this.radioButtonSim);
        this.buttonGroup.add(this.radioButtonNao);
        this.getConsorcioViewObject().addListener((Object)new TelaUC220RowSetListener(this));
        this.refreshTable();
        this.refreshSaveAction();
    }

    public ViewObject getConsorcioViewObject() {
        return this.getServicoPAD().findViewObject("ConsorciosView");
    }

    public ViewObject getRemessaViewObject() {
        return this.getServicoPAD().findViewObject("RemessasDaEntidade");
    }

    public ServicoPAD getServicoPAD() {
        return DatacontrolHelper.getServicoPADAppModule(this.panelBinding.getBindingContext());
    }

    public JUPanelBinding getPanelBinding() {
        return this.panelBinding;
    }

    private void registerProjectGlobalVariables(BindingContext bindCtx) {
        JUUtil.registerNavigationBarInterface((JUFormBinding)this.panelBinding, (BindingContext)bindCtx);
    }

    private void unRegisterProjectGlobalVariables(BindingContext bindCtx) {
        JUUtil.unRegisterNavigationBarInterface((JUFormBinding)this.panelBinding, (BindingContext)bindCtx);
    }

    @Override
    public void setBindingContext(BindingContext bindCtx) {
        if (this.panelBinding.getPanel() == null) {
            this.panelBinding = this.panelBinding.setup(bindCtx, (Object)this);
            this.registerProjectGlobalVariables(bindCtx);
            this.panelBinding.refreshControl();
            try {
                this.jbInit();
                this.panelBinding.refreshControl();
            }
            catch (Exception ex) {
                this.panelBinding.reportException((Throwable)ex);
            }
        }
    }

    @Override
    public void preparaTela() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (TelaUC220.this.tableConsorcios.getRowCount() == 0) {
                    TelaUC220.this.radioButtonNao.doClick();
                } else {
                    TelaUC220.this.radioButtonSim.doClick();
                }
            }
        });
    }

    @Override
    public void finalizaTela() {
    }

    @Override
    public boolean validaTela() {
        return true;
    }

    public boolean validaConsorcios() {
        if (this.isConsorcioPublico()) {
            if (this.tableConsorcios.getRowCount() == 0) {
                return this.validaConsorcio(null, -1);
            }
            int rowIndex = 1;
            ConsorciosViewRowImpl consorcioRow = null;
            ViewObject consorcioViewObject = this.getConsorcioViewObject();
            do {
                if (!this.validaConsorcio(consorcioRow = consorcioRow == null ? (ConsorciosViewRowImpl)consorcioViewObject.first() : (ConsorciosViewRowImpl)consorcioViewObject.next(), rowIndex)) {
                    return false;
                }
                ++rowIndex;
            } while (consorcioViewObject.hasNext());
        }
        return true;
    }

    private boolean validaConsorcio(ConsorciosViewRowImpl consorcioRow, int rowIndex) {
        PadWizardForm form = PadWizardHelper.getInstance().getForm();
        if (consorcioRow == null) {
            this.exibeMensagemAviso("\u00c9 preciso preencher ao menos um CNPJ/Nome do Cons\u00f3rcio antes de prosseguir.", form);
            return false;
        }
        Long cgc = consorcioRow.getCgc();
        if (cgc == null) {
            this.exibeMensagemAviso("O CNPJ deve ser preenchido na linha " + rowIndex + ".", form);
            return false;
        }
        if (!ValidaCNPJ.validaCnpj(cgc.toString())) {
            this.exibeMensagemAviso("CNPJ \"" + cgc + "\" inv\u00e1lido na linha " + rowIndex + ".", form);
            return false;
        }
        String nmConsorcio = consorcioRow.getNmConsorcio();
        if (nmConsorcio == null || nmConsorcio.trim().length() == 0) {
            this.exibeMensagemAviso("O Nome do Cons\u00f3rcio deve ser preenchido na linha " + rowIndex + ".", form);
            return false;
        }
        return true;
    }

    private void exibeMensagemAviso(String mensagem, Component parent) {
        JOptionPane.showMessageDialog(parent, mensagem, "Informa\u00e7\u00e3o", 1);
    }

    protected void refreshFields(boolean enabled) {
        boolean ignoreButtonInserir;
        boolean bl = ignoreButtonInserir = enabled && this.tableConsorcios.getRowCount() == 0;
        if (ignoreButtonInserir) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    TelaUC220.this.setEnabled(TelaUC220.this.navigationBar.getButton(4), true);
                }
            });
            enabled = false;
        }
        if (!enabled) {
            this.textFieldCNPJConsorcio.setText("");
            this.textFieldNomeConsorcio.setText("");
            ViewObject consorcioViewObject = this.getConsorcioViewObject();
            while (consorcioViewObject.getCurrentRow() != null) {
                consorcioViewObject.removeCurrentRow();
            }
        }
        this.setEnabled(this.textFieldCNPJConsorcio, enabled);
        this.setEnabled(this.textFieldNomeConsorcio, enabled);
        final boolean enabledButtons = enabled;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                for (int index = 0; index < 8; ++index) {
                    if (enabledButtons && index < 4 || ignoreButtonInserir && index == 4) continue;
                    TelaUC220.this.setEnabled(TelaUC220.this.navigationBar.getButton(index), enabledButtons);
                }
            }
        });
    }

    private void refreshTable() {
        DefaultTableCellRenderer tableCellRendererRight = new DefaultTableCellRenderer();
        tableCellRendererRight.setHorizontalAlignment(4);
        JTextField textFieldDisabled = new JTextField();
        textFieldDisabled.setEditable(false);
        textFieldDisabled.setFocusable(false);
        DefaultCellEditor cellEditorDisabled = new DefaultCellEditor(textFieldDisabled){

            @Override
            public boolean isCellEditable(EventObject event) {
                this.fireEditingCanceled();
                return false;
            }
        };
        TableColumnModel tableColumnModel = this.tableConsorcios.getColumnModel();
        TableColumn firstColumn = tableColumnModel.getColumn(0);
        firstColumn.setHeaderValue("CNPJ do Cons\u00f3rcio");
        firstColumn.setPreferredWidth(120);
        firstColumn.setCellRenderer(tableCellRendererRight);
        firstColumn.setCellEditor(cellEditorDisabled);
        TableColumn secondColumn = tableColumnModel.getColumn(1);
        secondColumn.setHeaderValue("Nome do Cons\u00f3rcio");
        secondColumn.setPreferredWidth(300);
        secondColumn.setCellEditor(cellEditorDisabled);
        JTableHeader tableHeader = this.tableConsorcios.getTableHeader();
        MouseListener[] mouseListeners = tableHeader.getMouseListeners();
        for (int i = 0; i < mouseListeners.length; ++i) {
            tableHeader.removeMouseListener(mouseListeners[i]);
        }
        tableHeader.setReorderingAllowed(false);
        tableHeader.setResizingAllowed(false);
        this.tableConsorcios.grabFocus();
    }

    private void refreshSaveAction() {
        JButton buttonGravar = this.navigationBar.getButton(6);
        final ActionListener[] actionListeners = buttonGravar.getActionListeners();
        for (int i = 0; i < actionListeners.length; ++i) {
            buttonGravar.removeActionListener(actionListeners[i]);
        }
        buttonGravar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                if (TelaUC220.this.validaConsorcios()) {
                    for (ActionListener actionListener : actionListeners) {
                        actionListener.actionPerformed(event);
                    }
                }
            }
        });
    }

    private void setEnabled(JComponent component, boolean enabled) {
        if (component == null) {
            throw new IllegalArgumentException("Componente n\u00e3o pode ser nulo.");
        }
        component.setEnabled(enabled);
        component.setFocusable(enabled);
    }

    public boolean isConsorcioPublico() {
        return this.radioButtonSim.isSelected();
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel("com.jgoodies.looks.plastic.PlasticXPLookAndFeel");
        }
        catch (ClassNotFoundException classNotFoundException) {
            try {
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        TelaUC220 tela = new TelaUC220();
        tela.setBindingContext(JUTestFrame.startTestFrame((String)"DataBindings.cpx", (String)"ServicoPADDataControl", (JPanel)tela, (JUPanelBinding)tela.getPanelBinding(), (Dimension)new Dimension(400, 300)));
        tela.revalidate();
    }
}

