/*
 * Decompiled with CFR 0.152.
 */
package br.gov.rs.tce.pad.visao;

import br.gov.rs.tce.pad.beans.Tela;
import br.gov.rs.tce.pad.visao.PadModelo;
import br.gov.rs.tce.pad.visao.PadWizardControle;
import br.gov.rs.tce.pad.visao.PadWizardHelper;
import java.awt.CardLayout;
import java.awt.Component;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class PadWizardModelo
extends JPanel {
    private static Log log = LogFactory.getLog(PadWizardModelo.class);
    private CardLayout card = (CardLayout)this.getLayout();
    private PadModelo telaAtual;
    private Map telas;
    private Map telasSigleton;

    public PadWizardModelo() {
        super(new CardLayout());
        this.setBorder(BorderFactory.createEtchedBorder(0));
        this.telas = new HashMap(120);
        this.telasSigleton = new HashMap(16);
    }

    public void adicionaTelaModelo(Tela confTela, PadModelo tela) {
        if (confTela == null) {
            throw new IllegalArgumentException("Tela n\u00e3o pode ser nulo.");
        }
        if (tela == null) {
            throw new IllegalArgumentException("PadModeloTela n\u00e3o pode ser nulo.");
        }
        if (confTela.isSingletonPanel()) {
            this.telasSigleton.put(confTela.getPanelClass(), tela);
            log.debug((Object)"Adiciona tela Modelo - SingletonPanel");
            this.add((Component)((Object)tela), confTela.getPanelClass());
        } else {
            this.telas.put(confTela.getCodigo(), tela);
            this.add((Component)((Object)tela), confTela.getCodigo());
            log.debug((Object)"Adiciona tela Modelo - SingletonPanel - false");
        }
    }

    public void removeTelaModelo(String codigo) {
        Component painel = (Component)this.telas.remove(codigo);
        this.remove(painel);
    }

    public void exibeTela(Tela tela, PadModelo panel) {
        this.telaAtual = panel;
        if (tela.isSingletonPanel()) {
            this.card.show(this, tela.getPanelClass());
        } else {
            this.card.show(this, tela.getCodigo());
        }
        this.repaint();
        PadWizardControle control = PadWizardHelper.getInstance().getForm().getPagina().getPadWizardControle();
        control.setDefaultFocus();
    }

    public void setTelaAtual(PadModelo panel) {
        this.telaAtual = panel;
    }

    public PadModelo getTelaAtual() {
        return this.telaAtual;
    }

    public PadModelo getTelaModelo(Tela tela) {
        if (tela == null) {
            throw new IllegalArgumentException("Tela n\u00e3o pode ser nulo");
        }
        if (tela.isSingletonPanel()) {
            log.debug((Object)"Retornou Modelo de Tela - SinglePanel");
            return (PadModelo)this.telasSigleton.get(tela.getPanelClass());
        }
        log.debug((Object)"Retornou Modelo de Tela - N\u00e3o SinglePanel");
        return (PadModelo)this.telas.get(tela.getCodigo());
    }
}

