/*
 * Decompiled with CFR 0.152.
 */
package br.gov.rs.tce.pad.visao;

import br.gov.rs.tce.pad.beans.Tela;
import br.gov.rs.tce.pad.excecao.DecisaoTelaException;
import br.gov.rs.tce.pad.modelo.decisao.DecisaoNavegacaoTelas;
import br.gov.rs.tce.pad.util.VersaoUtils;
import br.gov.rs.tce.pad.visao.PadDesktop;
import br.gov.rs.tce.pad.visao.PadModelo;
import br.gov.rs.tce.pad.visao.PadWizardForm;
import oracle.adf.model.BindingContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class PadWizardHelper {
    private static Log log = LogFactory.getLog(PadWizardHelper.class);
    private PadWizardForm _form;
    private static PadWizardHelper _helper;
    public String titleDebugInfo = null;

    private PadWizardHelper() {
    }

    public static PadWizardHelper getInstance() {
        if (_helper == null) {
            _helper = new PadWizardHelper();
        }
        return _helper;
    }

    public void setPadWizardForm(PadWizardForm form) {
        this._form = form;
    }

    public void inicializaPanels() {
        Tela telaini = DecisaoNavegacaoTelas.getInstancia().getTelaInicial();
        PadModelo panel = PadWizardHelper.criaNovaTela(telaini.getPanelClass(), this._form.getBindingContext());
        this._form.getPagina().getPadWizardModelo().adicionaTelaModelo(telaini, panel);
        this.exibeTela(telaini, panel);
    }

    public void exibeTela(Tela tela, PadModelo panel) {
        log.debug((Object)"Inicia m\u00e9todo de exibir Tela");
        this._form.getPagina().getPadWizardModelo().exibeTela(tela, panel);
        if (VersaoUtils.isDebugModeEnabled()) {
            this._form.setTitle("PAD " + PadDesktop.getVersaoTitulo() + " - " + tela.getCodigo() + (this.titleDebugInfo != null ? " - " + this.titleDebugInfo : ""));
            this.titleDebugInfo = null;
        }
    }

    public PadWizardForm getForm() {
        return this._form;
    }

    public static PadModelo criaNovaTela(String tela, BindingContext ctx) {
        PadModelo modelo = null;
        try {
            log.debug((Object)"Cria nova Tela");
            modelo = (PadModelo)Class.forName(tela).newInstance();
            modelo.setBindingContext(ctx);
            log.debug((Object)"Cria nova Tela - Binding Context");
        }
        catch (Exception e) {
            log.warn((Object)("Erro ao instanciar tela: " + tela), (Throwable)e);
            throw new DecisaoTelaException("Erro ao instanciar tela: " + tela, e);
        }
        catch (NoClassDefFoundError e) {
            log.warn((Object)("Erro ao instanciar tela [NoClassDefFoundError]: " + tela), (Throwable)e);
            throw new DecisaoTelaException("Erro ao instanciar tela [NoClassDefFoundError]: " + tela, new RuntimeException(e));
        }
        return modelo;
    }
}

