/*
 * Decompiled with CFR 0.152.
 */
package br.gov.rs.tce.pad.util;

import br.gov.rs.tce.pad.beans.Arquivos;
import br.gov.rs.tce.pad.beans.Campo;
import br.gov.rs.tce.pad.beans.Mensagem;
import br.gov.rs.tce.pad.beans.Mensagens;
import br.gov.rs.tce.pad.modelo.ConfiguracaoControle;
import br.gov.rs.tce.pad.modelo.verificacao.regras.BaseRegraCampo;
import java.util.LinkedList;
import java.util.List;

public class ValidadorXMLArquivos {
    Arquivos _arquivos;
    Mensagens _mensagens = (Mensagens)ConfiguracaoControle.carregaDadosArquivoXML("mensagens");
    List<String> _erros = new LinkedList<String>();

    public ValidadorXMLArquivos(String xmlArquivos, String xmlMensagens) {
    }

    private void testaXML(String tipoSetor) {
    }

    private void testaCampos(String arquivoNome, Campo[] campos) {
        for (int c = 0; c < campos.length; ++c) {
            Campo campo = campos[c];
            if ((campo.getCodigoMensagem() == null || campo.getCodigoMensagem().equals("")) && campo.getTipoDadoId() != 1) {
                this._erros.add("Campo " + campo.getNome() + " - Arquivo " + arquivoNome + " n\u00e3o possui uma mensagem de tipo de dado inv\u00e1lido definida.");
            } else {
                Mensagem msg = this._mensagens.getMensagemPorCodigo(campo.getCodigoMensagem());
                if (msg == null) {
                    this._erros.add("Campo " + campo.getNome() + " - Arquivo " + arquivoNome + " usa mensagem c\u00f3digo: " + campo.getCodigoMensagem() + " que n\u00e3o foi encontrada.");
                }
            }
            this.verificaRegraCampo(arquivoNome, campo);
        }
    }

    private void verificaRegraCampo(String arquivoNome, Campo campo) {
        if (campo.getBaseRegrasCampo() != null) {
            List<BaseRegraCampo> regras = campo.getBaseRegrasCampo();
            for (int i = 0; i < regras.size(); ++i) {
                String codMsg = regras.get(i).getCodigoMensagem();
                if (codMsg == null || codMsg.equals("")) {
                    this._erros.add("Campo " + campo.getNome() + " - Arquivo " + arquivoNome + " usa c\u00f3digo mensagem vazio o que n\u00e3o \u00e9 suportado.");
                    continue;
                }
                String[] codigos = codMsg.split(",");
                for (int a = 0; a < codigos.length; ++a) {
                    codMsg = codigos[a];
                    Mensagem msg = this._mensagens.getMensagemPorCodigo(codMsg);
                    if (msg != null) continue;
                    this._erros.add("Regra verifica\u00e7\u00e3o do Campo " + campo.getNome() + " - Arquivo " + arquivoNome + " usa mensagem c\u00f3digo: " + campo.getCodigoMensagem() + " que n\u00e3o foi encontrada.");
                }
            }
        }
    }

    public static void main(String[] args) throws Exception {
        ValidadorXMLArquivos validadorXMLArquivos = new ValidadorXMLArquivos(args[0], args[1]);
        for (int i = 0; i < validadorXMLArquivos._erros.size(); ++i) {
            System.out.println(validadorXMLArquivos._erros.get(i) + "\n");
        }
    }
}

