/*
 * Decompiled with CFR 0.152.
 */
package br.gov.rs.tce.pad.util;

import br.gov.rs.tce.pad.excecao.TransferenciaException;
import br.gov.rs.tce.pad.util.IndicadorProgresso;
import br.gov.rs.tce.pcdi.ws.soap.webservice.Response;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.Authenticator;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.PasswordAuthentication;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import sun.net.www.MimeEntry;
import sun.net.www.MimeTable;

public final class EnviaArquivosHttp
implements IndicadorProgresso {
    protected URL _urlServidor;
    static final String _externalBoundary = EnviaArquivosHttp.geraBoudaryString();
    protected HttpURLConnection _conexao;
    protected boolean _deveDesconectar = false;
    protected Map _campos = new HashMap();
    protected Set _arquivos = new HashSet();
    private DataOutputStream _formOutputStream;
    private final List _changeListeners = new LinkedList();
    private String _situacao;
    private int _progresso;
    public static final int OK = 200;
    public static final int CRYPT_ERROR = 507;
    public static final int ZIP_ERROR = 508;
    public static final int CONTENT_ERROR = 509;
    public static final int UNEXPECTED_ERROR = 510;
    public static final int FILE_NOT_FOUND_ERROR = 511;
    public static final int IO_ERROR = 527;
    public static final int ERRO_VERSAO_ANTIGA = 532;
    public static final int REMESSA_PREFEITURA_NAO_ENTREGUE = 534;
    public static final int CADASTRO_RESP_NAO_ENCONTRADO = 559;
    public static final int REMESSA_PAD_INEXISTENTE = 560;
    public static final int REMESSA_EM_ANALISE = 561;
    public static final int EPROTOCOLO_JA_ENVIADO = 564;
    public static final int EPROTOCOLO_PENDENTE = 565;
    public static final String ARQUIVO_PROPERTIES = "remessa/proxy.properties";
    private String usuario;
    private String senha;
    private String servidor;
    private String porta;
    private boolean isProxy;

    private EnviaArquivosHttp() {
    }

    public EnviaArquivosHttp(DataOutputStream dos) throws IOException {
        this();
        this._formOutputStream = dos;
    }

    public EnviaArquivosHttp(URL servidor) throws IOException {
        this();
        this._urlServidor = servidor;
        this._deveDesconectar = true;
    }

    public EnviaArquivosHttp(HttpURLConnection conexao) throws IOException {
        this();
        this._urlServidor = conexao.getURL();
        this._conexao = conexao;
        EnviaArquivosHttp.ajustaCabecalhoHttp(conexao);
    }

    public static HttpURLConnection abreConexaoHttp(URL url) throws IOException {
        HttpURLConnection conexaoServidor = (HttpURLConnection)url.openConnection();
        return conexaoServidor;
    }

    private static void ajustaCabecalhoHttp(HttpURLConnection conexaoServidor) throws IOException {
        conexaoServidor.setDoOutput(true);
        conexaoServidor.setDoInput(true);
        conexaoServidor.setUseCaches(false);
        conexaoServidor.setRequestMethod("POST");
        conexaoServidor.setRequestProperty("Content-Type", "multipart/form-data, boundary=" + _externalBoundary);
    }

    public void adicionaCampoComValor(String nomeCampo, Object valor) {
        this._campos.put(nomeCampo, valor);
    }

    public void adicionaArquivo(IdentificadorArquivoEnvio ident) {
        if (!this._arquivos.add(ident)) {
            throw new IllegalArgumentException("O nome do arquivo n\u00e3o pode ser repetido: " + ident._identificador);
        }
    }

    protected void iniciaEnvioHttp(Map campos, Set arquivos) throws TransferenciaException, IOException {
        this.setSituacao("Iniciando envio de dados...");
        EnviaArquivosHttp.enviaInicioMultipartFormData(this._formOutputStream, _externalBoundary);
        for (String key : campos.keySet()) {
            EnviaArquivosHttp.adicionaCampoFormulario(key, (String)campos.get(key), _externalBoundary, this._formOutputStream);
        }
        MimeTable mimeTable = MimeTable.getDefaultTable();
        String filesBoundary = _externalBoundary;
        if (arquivos != null && arquivos.size() > 0) {
            Iterator i = arquivos.iterator();
            while (i.hasNext()) {
                IdentificadorArquivoEnvio identArquivo = (IdentificadorArquivoEnvio)i.next();
                String nomeArquivo = identArquivo._arquivo.getName();
                MimeEntry mimeTypeEntry = mimeTable.findByFileName(nomeArquivo);
                String mimeType = null;
                mimeType = mimeTypeEntry != null ? mimeTypeEntry.getType() : "application/octet-stream";
                boolean ultimo = !i.hasNext();
                this.adicinaArquivoBinario(identArquivo, mimeType, filesBoundary, ultimo, this._formOutputStream);
            }
        } else {
            StringBuffer streamSend = new StringBuffer();
            streamSend.append("Content-Disposition: form-data; name=\"null\" filename=\"\"\r\n");
            streamSend.append("Content-Type: application/octet-stream\r\n");
            streamSend.append("\r\n");
            this._formOutputStream.write(streamSend.toString().getBytes());
        }
        EnviaArquivosHttp.enviaDelimitadorMultipartFormData(this._formOutputStream, _externalBoundary);
        EnviaArquivosHttp.enviaFinalMultipartFormData(this._formOutputStream, _externalBoundary);
        this._formOutputStream.flush();
    }

    public static void analisaResponse(Response response) throws IOException, TransferenciaException {
        System.out.println(">>> responseMessage: " + response.getMensagem());
        System.out.println(">>> responseCode: " + response.getCodigo());
        if (!response.getCodigo().equals(200)) {
            throw new TransferenciaException(response.getMensagem() + " [code=" + response.getCodigo() + "]");
        }
    }

    private static void enviaDelimitadorMultipartFormData(DataOutputStream postFormStream, String boundary) throws IOException {
        StringBuffer streamSend = new StringBuffer("\r\n--");
        streamSend.append(boundary);
        postFormStream.write(streamSend.toString().getBytes());
    }

    private static void enviaInicioMultipartFormData(DataOutputStream postFormStream, String boundary) throws IOException {
        StringBuffer streamSend = new StringBuffer("--");
        streamSend.append(boundary).append("\r\n");
        postFormStream.write(streamSend.toString().getBytes());
    }

    private static void enviaFinalMultipartFormData(DataOutputStream postFormStream, String boundary) throws IOException {
        postFormStream.write("--\r\n".getBytes());
    }

    private static void adicionaCampoFormulario(String nome, String valor, String boundary, DataOutputStream postFormStream) throws IOException {
        StringBuffer streamSend = new StringBuffer();
        streamSend.append("Content-Disposition: form-data; name=\"").append(nome).append("\"\r\n\r\n");
        streamSend.append(valor).append("\r\n");
        streamSend.append("--").append(boundary).append("\r\n");
        postFormStream.write(streamSend.toString().getBytes());
    }

    private void adicinaArquivoBinario(IdentificadorArquivoEnvio identArquivo, String contentType, String fileBoundary, boolean ultimo, DataOutputStream postFormStream) throws IOException, TransferenciaException {
        if (identArquivo == null) {
            throw new IllegalArgumentException("Identificador do arquivo n\u00e3o pode ser nulo");
        }
        File arquivo = identArquivo._arquivo;
        long fileSize = arquivo.length();
        if (arquivo.exists()) {
            this.setSituacao("Enviando arquivo: " + arquivo.getName());
            StringBuffer streamSend = new StringBuffer();
            streamSend.append("Content-Disposition: form-data; name=\"" + identArquivo._identificador + "\" filename=\"" + arquivo.getName() + "\"\r\n");
            streamSend.append("Content-Type: " + contentType + "\r\n");
            streamSend.append("\r\n");
            postFormStream.write(streamSend.toString().getBytes());
            FileInputStream uploadFileReader = null;
            try {
                int numberOfBytesRead;
                uploadFileReader = new FileInputStream(arquivo);
                int numBytesToRead = 2048;
                int actual = 0;
                int oldStatus = 0;
                byte[] bufferBytesRead = new byte[numBytesToRead];
                int availableBytesToRead = uploadFileReader.available();
                while ((numberOfBytesRead = uploadFileReader.read(bufferBytesRead)) > 0) {
                    postFormStream.write(bufferBytesRead, 0, numberOfBytesRead);
                    int status = (int)Math.round((double)(actual += numberOfBytesRead) / ((double)fileSize * 1.0) * 100.0);
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    if (status == oldStatus) continue;
                    this._progresso = status;
                    oldStatus = status;
                    this.fireChangedEvent();
                }
            }
            catch (IOException e) {
                throw new TransferenciaException(e);
            }
            finally {
                if (uploadFileReader != null) {
                    try {
                        uploadFileReader.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            if (!ultimo) {
                EnviaArquivosHttp.enviaDelimitadorMultipartFormData(postFormStream, _externalBoundary);
            }
        } else {
            throw new FileNotFoundException("Arquivo n\u00e3o encontrado: " + arquivo);
        }
        postFormStream.write("\r\n".getBytes());
        this.setSituacao("Finalizando transmiss\u00e3o de dados");
    }

    private static String geraBoudaryString() {
        return Long.toHexString(System.currentTimeMillis());
    }

    public static IdentificadorArquivoEnvio criaIdentificadorArquivo(String identificador, File arquivo) {
        return new IdentificadorArquivoEnvio(identificador, arquivo);
    }

    public void setDataOutputStream(DataOutputStream output) {
        this._formOutputStream = output;
    }

    private void fireChangedEvent() {
        ChangeEvent evento = new ChangeEvent(this);
        Iterator it = this._changeListeners.iterator();
        while (it.hasNext()) {
            ((ChangeListener)it.next()).stateChanged(evento);
        }
    }

    @Override
    public int getProgresso() {
        return this._progresso;
    }

    @Override
    public String getSituacao() {
        return this._situacao;
    }

    public void addChangeListener(ChangeListener listener) {
        this._changeListeners.add(listener);
    }

    public void setSituacao(String situacao) {
        this._situacao = situacao;
        this.fireChangedEvent();
    }

    private void carregaDadosAutenticacao() {
        try {
            File file = new File(ARQUIVO_PROPERTIES);
            FileInputStream is = null;
            Properties props = null;
            if (file.exists()) {
                is = new FileInputStream(file);
                props = new Properties();
                props.load(is);
                this.servidor = props.getProperty("proxy.servidor");
                this.porta = props.getProperty("proxy.porta");
                this.usuario = props.getProperty("proxy.usuario");
                this.senha = props.getProperty("proxy.senha");
                System.setProperty("proxySet", "true");
                System.setProperty("http.proxyHost", this.servidor);
                System.setProperty("http.proxyPort", this.porta);
                ((InputStream)is).close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public boolean getIsProxy() {
        try {
            File file = new File(ARQUIVO_PROPERTIES);
            FileInputStream is = null;
            Properties props = null;
            if (file.exists()) {
                is = new FileInputStream(file);
                props = new Properties();
                props.load(is);
                this.servidor = props.getProperty("proxy.servidor");
                if (this.servidor != null && !"".equals(this.servidor)) {
                    this.setIsProxy(true);
                }
                ((InputStream)is).close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return this.isProxy;
    }

    public void setIsProxy(boolean proxy) {
        this.isProxy = proxy;
    }

    public class MyAuthenticator
    extends Authenticator {
        @Override
        protected PasswordAuthentication getPasswordAuthentication() {
            String promptString = this.getRequestingPrompt();
            String hostname = this.getRequestingHost();
            InetAddress ipaddr = this.getRequestingSite();
            int port = this.getRequestingPort();
            String username = EnviaArquivosHttp.this.usuario;
            String password = EnviaArquivosHttp.this.senha;
            return new PasswordAuthentication(username, password.toCharArray());
        }
    }

    private static class IdentificadorArquivoEnvio {
        String _identificador;
        File _arquivo;

        public IdentificadorArquivoEnvio(String identificador, File arquivo) {
            this._identificador = identificador;
            this._arquivo = arquivo;
        }
    }
}

