/*
 * Decompiled with CFR 0.152.
 */
package br.gov.rs.tce.pad.util;

import br.gov.rs.tce.pad.excecao.CompactacaoException;
import br.gov.rs.tce.pad.excecao.OrigemEDestinoIdenticosException;
import br.gov.rs.tce.pad.util.CopiaArquivoEvent;
import de.idyl.crypto.zip.AesZipFileEncrypter;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.net.URL;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javax.swing.event.ChangeListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class CompactacaoHelper {
    static final int BUFFER = 2048;
    protected static final Log log = LogFactory.getLog(CompactacaoHelper.class);
    private int situacaoDisquete = 0;
    private boolean _situacao = true;
    private long tamanhoArquivo = 1L;
    private long actual = 0L;

    public void compacta(File arquivo, File arquivoDestino) throws CompactacaoException {
        this.compacta(new File[]{arquivo}, arquivoDestino);
    }

    public void compacta(File[] arquivos, File arquivoDestino) throws CompactacaoException {
        byte[] buf = new byte[2048];
        int count = 0;
        try {
            log.debug((Object)("Criando arquivo compactado em: " + arquivoDestino.getAbsolutePath()));
            ZipOutputStream out = new ZipOutputStream(new FileOutputStream(arquivoDestino.getAbsolutePath()));
            for (int i = 0; i < arquivos.length; ++i) {
                int len;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Compactando arquivo: " + arquivos[i]));
                }
                FileInputStream in = new FileInputStream(arquivos[i]);
                out.putNextEntry(new ZipEntry(arquivos[i].getName()));
                while ((len = in.read(buf)) > 0) {
                    out.write(buf, 0, len);
                }
                out.closeEntry();
                in.close();
                ++count;
            }
            out.close();
        }
        catch (IOException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Erro compactando arquivo: " + arquivos[count]));
            }
            throw new CompactacaoException("Arquivo n\u00e3o localizado no momento de compacta\u00e7\u00e3o.", null, e);
        }
    }

    public void compacta(File[] arquivos, OutputStream destino, String senha) throws CompactacaoException {
        try {
            AesZipFileEncrypter enc = new AesZipFileEncrypter(destino);
            for (int i = 0; i < arquivos.length; ++i) {
                FileInputStream in = new FileInputStream(arquivos[i]);
                String name = arquivos[i].getName();
                enc.add(name, (InputStream)in, senha);
                in.close();
            }
            enc.close();
        }
        catch (IOException e) {
            throw new CompactacaoException("Arquivo n\u00e3o localizado no momento de compacta\u00e7\u00e3o.", null, e);
        }
    }

    public void descompactaSoNome(File arquivoCompactado, File diretorioDestino) throws CompactacaoException {
        try {
            File sourceZipFile = arquivoCompactado;
            File unzipDestinationDirectory = diretorioDestino;
            log.info((Object)("Descompactando arquivo: " + sourceZipFile.getAbsolutePath() + " no diretorio: " + unzipDestinationDirectory.getAbsolutePath()));
            ZipFile zipFile = new ZipFile(sourceZipFile, 1);
            Enumeration<? extends ZipEntry> zipFileEntries = zipFile.entries();
            while (zipFileEntries.hasMoreElements()) {
                int currentByte;
                ZipEntry entry = zipFileEntries.nextElement();
                int inicio = entry.getName().lastIndexOf("\\");
                String currentEntry = null;
                if (inicio > -1) {
                    int fim = entry.getName().length();
                    currentEntry = entry.getName().substring(inicio, fim);
                } else {
                    currentEntry = entry.getName();
                }
                File destFile = new File(unzipDestinationDirectory, currentEntry);
                File destinationParent = destFile.getParentFile();
                destinationParent.mkdirs();
                if (entry.isDirectory()) continue;
                BufferedInputStream is = new BufferedInputStream(zipFile.getInputStream(entry));
                byte[] data = new byte[2048];
                FileOutputStream fos = new FileOutputStream(destFile);
                BufferedOutputStream dest = new BufferedOutputStream(fos, 2048);
                while ((currentByte = is.read(data, 0, 2048)) != -1) {
                    dest.write(data, 0, currentByte);
                }
                dest.flush();
                dest.close();
                fos.close();
                is.close();
            }
            zipFile.close();
        }
        catch (IOException ioe) {
            System.out.println("ERRO: " + ioe.getMessage());
            System.out.println(">>>> ");
            ioe.printStackTrace();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Erro descompactando arquivo: " + arquivoCompactado.getAbsolutePath() + " no diretorio: " + diretorioDestino.getAbsolutePath()));
            }
            throw new CompactacaoException("Erro no momento de descompactar arquivo", null, ioe);
        }
    }

    public synchronized void descompacta(File arquivoCompactado, File diretorioDestino) throws CompactacaoException {
        try {
            File sourceZipFile = arquivoCompactado;
            File unzipDestinationDirectory = diretorioDestino;
            log.info((Object)("Descompactando arquivo: " + sourceZipFile.getAbsolutePath() + " no diretorio: " + unzipDestinationDirectory.getAbsolutePath()));
            ZipFile zipFile = new ZipFile(sourceZipFile, 1);
            Enumeration<? extends ZipEntry> zipFileEntries = zipFile.entries();
            StringBuffer nomesArquivos = new StringBuffer();
            while (zipFileEntries.hasMoreElements()) {
                int currentByte;
                ZipEntry entry = zipFileEntries.nextElement();
                File destFile = new File(unzipDestinationDirectory, entry.getName());
                File destinationParent = destFile.getParentFile();
                destinationParent.mkdirs();
                if (entry.isDirectory()) continue;
                BufferedInputStream is = new BufferedInputStream(zipFile.getInputStream(entry));
                byte[] data = new byte[2048];
                FileOutputStream fos = new FileOutputStream(destFile);
                BufferedOutputStream dest = new BufferedOutputStream(fos, 2048);
                while ((currentByte = is.read(data, 0, 2048)) != -1) {
                    dest.write(data, 0, currentByte);
                }
                dest.flush();
                dest.close();
                fos.flush();
                fos.close();
                is.close();
                nomesArquivos.append(entry.getName());
                nomesArquivos.append(", ");
            }
            log.debug((Object)("Arquivos descompactados: " + nomesArquivos.toString()));
            zipFile.close();
        }
        catch (IOException ioe) {
            System.out.println("Erro descompactando arquivo: " + arquivoCompactado.getAbsolutePath() + " no diretorio: " + diretorioDestino.getAbsolutePath());
            log.warn((Object)("Erro descompactando arquivo: " + arquivoCompactado.getAbsolutePath() + " no diretorio: " + diretorioDestino.getAbsolutePath()));
            System.out.println("ERRO: " + ioe.getMessage());
            ioe.printStackTrace();
            throw new CompactacaoException("Erro no momento de descompactar arquivo", null, ioe);
        }
    }

    public synchronized Map<String, byte[]> descompacta(InputStream arquivoCompactado) throws CompactacaoException {
        try {
            ZipInputStream zipFile = new ZipInputStream(arquivoCompactado);
            HashMap<String, byte[]> files = new HashMap<String, byte[]>();
            byte[] data = new byte[2048];
            ZipEntry ze = null;
            while ((ze = zipFile.getNextEntry()) != null) {
                int currentByte;
                ByteArrayOutputStream bout = new ByteArrayOutputStream();
                while ((currentByte = zipFile.read(data, 0, 2048)) != -1) {
                    bout.write(data, 0, currentByte);
                }
                files.put(ze.getName(), bout.toByteArray());
                zipFile.closeEntry();
                bout.flush();
                bout.close();
            }
            zipFile.close();
            return files;
        }
        catch (IOException ioe) {
            System.out.println("ERRO: " + ioe.getMessage());
            ioe.printStackTrace();
            throw new CompactacaoException("Erro no momento de descompactar arquivo", null, ioe);
        }
    }

    public List<File> divideArquivo(File arquivo, long tamanhoParte) {
        byte[] buf = new byte[2048];
        CRC32 crc32 = new CRC32();
        int fileSize = 0;
        int seq = 1;
        byte numPartes = (byte)Math.ceil((double)arquivo.length() / (double)tamanhoParte);
        DecimalFormat formatter = new DecimalFormat("##00");
        ArrayList<File> file = new ArrayList<File>();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Dividindo o arquivo: " + arquivo + " em " + numPartes + " partes. "));
        }
        try {
            int len;
            String extensao = ".p01";
            String nomeArqCorrente = arquivo.getAbsolutePath().substring(0, arquivo.getAbsolutePath().lastIndexOf(".")) + extensao;
            DataOutputStream out = new DataOutputStream(new FileOutputStream(nomeArqCorrente));
            FileInputStream in = new FileInputStream(arquivo);
            while ((len = in.read(buf)) > 0) {
                out.write(buf, 0, len);
                crc32.update(buf, 0, len);
                if ((long)fileSize > tamanhoParte) {
                    out.writeByte(seq);
                    out.writeByte(numPartes);
                    seq = (byte)(seq + 1);
                    out.writeLong(crc32.getValue());
                    out.close();
                    file.add(new File(nomeArqCorrente));
                    String s = formatter.format(seq);
                    extensao = ".p" + s;
                    nomeArqCorrente = arquivo.getAbsolutePath().substring(0, arquivo.getAbsolutePath().lastIndexOf(".")) + extensao;
                    out = new DataOutputStream(new FileOutputStream(nomeArqCorrente));
                    crc32.reset();
                    fileSize = 0;
                    continue;
                }
                fileSize += len;
            }
            if (len < 0) {
                out.writeByte(seq);
                out.writeByte(numPartes);
                out.writeLong(crc32.getValue());
                file.add(new File(nomeArqCorrente));
            }
            in.close();
            out.close();
        }
        catch (IOException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Erro dividindo o arquivo: " + arquivo + " em " + numPartes + " partes. "));
            }
            throw new CompactacaoException("Erro ao dividir arquivos", null, e);
        }
        return file;
    }

    public void montaArquivo(File[] arquivos, String extensao) {
        byte[] buf = new byte[2048];
        String nomeArquivo = "";
        try {
            Map<String, CabecalhoArquivoCompactado> listaArquivos = this.ordenaArquivos(arquivos);
            FileInputStream in = null;
            nomeArquivo = arquivos[0].getAbsolutePath().substring(0, arquivos[0].getAbsolutePath().lastIndexOf("."));
            nomeArquivo = nomeArquivo + "." + extensao;
            DataOutputStream out = new DataOutputStream(new FileOutputStream(nomeArquivo));
            if (log.isDebugEnabled()) {
                log.debug((Object)("Montando arquivo: " + nomeArquivo));
            }
            Collection<CabecalhoArquivoCompactado> valores = listaArquivos.values();
            for (CabecalhoArquivoCompactado objectFile : valores) {
                int len;
                if (arquivos.length != objectFile.numPartes) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("NUMERO DE ARQUIVOS INVALIDO!!! Esperado: " + arquivos.length + " Encontrado: " + objectFile.numPartes));
                    }
                    throw new CompactacaoException("10024", new Object[]{arquivos.length, objectFile.numPartes});
                }
                File file = objectFile.file;
                in = new FileInputStream(file);
                long fileSize = file.length();
                long count = 0L;
                CRC32 crc = new CRC32();
                while ((len = in.read(buf)) > 0) {
                    if ((count += (long)len) == fileSize) {
                        out.write(buf, 0, len - 10);
                        crc.update(buf, 0, len - 10);
                        continue;
                    }
                    crc.update(buf, 0, len);
                    out.write(buf, 0, len);
                }
                if (crc.getValue() == objectFile.crc) continue;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("CRC INVALIDO!!! Esperado: " + objectFile.crc + " Encontrado: " + crc.getValue()));
                }
                throw new CompactacaoException("10025", new Object[]{objectFile.file.getName()});
            }
            in.close();
            out.close();
        }
        catch (IOException e) {
            throw new CompactacaoException("Erro no momento de montagem de arquivo.", null, e);
        }
    }

    public File montaArquivo(File[] arquivos, String extensao, String param) {
        File retorno = null;
        byte[] buf = new byte[2048];
        String nomeArquivo = "";
        try {
            Map<String, CabecalhoArquivoCompactado> listaArquivos = this.ordenaArquivos(arquivos);
            FileInputStream in = null;
            nomeArquivo = arquivos[0].getAbsolutePath().substring(0, arquivos[0].getAbsolutePath().lastIndexOf("."));
            nomeArquivo = nomeArquivo + "." + extensao;
            DataOutputStream out = new DataOutputStream(new FileOutputStream(nomeArquivo));
            if (log.isDebugEnabled()) {
                log.debug((Object)("Montando arquivo: " + nomeArquivo));
            }
            Collection<CabecalhoArquivoCompactado> valores = listaArquivos.values();
            for (CabecalhoArquivoCompactado objectFile : valores) {
                int len;
                if (arquivos.length != objectFile.numPartes) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("NUMERO DE ARQUIVOS INVALIDO!!! Esperado: " + arquivos.length + " Encontrado: " + objectFile.numPartes));
                    }
                    throw new CompactacaoException("10024", new Object[]{arquivos.length, objectFile.numPartes});
                }
                File file = objectFile.file;
                in = new FileInputStream(file);
                long fileSize = file.length();
                long count = 0L;
                CRC32 crc = new CRC32();
                while ((len = in.read(buf)) > 0) {
                    if ((count += (long)len) == fileSize) {
                        out.write(buf, 0, len - 10);
                        crc.update(buf, 0, len - 10);
                        continue;
                    }
                    crc.update(buf, 0, len);
                    out.write(buf, 0, len);
                }
                if (crc.getValue() == objectFile.crc) continue;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("CRC INVALIDO!!! Esperado: " + objectFile.crc + " Encontrado: " + crc.getValue()));
                }
                throw new CompactacaoException("10025", new Object[]{objectFile.file.getName()});
            }
            retorno = new File(nomeArquivo);
            in.close();
            out.close();
        }
        catch (IOException e) {
            throw new CompactacaoException("Erro no momento de montagem de arquivo.", null, e);
        }
        return retorno;
    }

    public static File[] buscaArquivos(File file) {
        return file.listFiles();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, CabecalhoArquivoCompactado> ordenaArquivos(File[] arquivos) throws IOException {
        TreeMap<String, CabecalhoArquivoCompactado> listaArquivos = new TreeMap<String, CabecalhoArquivoCompactado>();
        try (RandomAccessFile raf = null;){
            for (int i = 0; i < arquivos.length; ++i) {
                File f = arquivos[i];
                raf = new RandomAccessFile(f, "r");
                raf.seek(f.length() - 10L);
                byte seq = raf.readByte();
                String indice = Integer.toString(seq);
                byte numPartes = raf.readByte();
                long crc = raf.readLong();
                listaArquivos.put(indice, new CabecalhoArquivoCompactado(seq, numPartes, crc, arquivos[i]));
            }
        }
        return listaArquivos;
    }

    public boolean copiaArquivoRemessa(File origem, File dirDestino, ChangeListener listener) {
        String nomeArquivo = dirDestino.getPath() + File.separator + origem.getName();
        this.copiaArquivo(origem, new File(nomeArquivo), listener);
        CopiaArquivoEvent evento = new CopiaArquivoEvent(-4, this);
        evento.setArquivoAtual(1);
        evento.setTotalArquivos(1);
        listener.stateChanged(evento);
        return true;
    }

    public void copiaArquivo(File origem, File destino) {
        this.copiaArquivo(origem, destino, null);
    }

    public void copiaArquivo(File origem, File destino, ChangeListener listener) {
        FileInputStream in = null;
        OutputStream out = null;
        if (origem == null) {
            throw new IllegalArgumentException("O arquivo de origem n\u00e3o pode ser nulo.");
        }
        if (destino == null) {
            throw new IllegalArgumentException("O arquivo de destino n\u00e3o pode ser nulo.");
        }
        if (origem.equals(destino)) {
            String mensagem = "copiaArquivo: arquivos de origem e destino identicos, impossivel copiar [arquivo = " + origem + "]";
            log.warn((Object)mensagem);
            throw new OrigemEDestinoIdenticosException(mensagem);
        }
        try {
            if (origem.getCanonicalFile().equals(destino.getCanonicalFile())) {
                String mensagem = "copiaArquivo: arquivos de origem e destino identicos, impossivel copiar [arquivo = " + origem + "]";
                log.warn((Object)mensagem);
                throw new OrigemEDestinoIdenticosException(mensagem);
            }
        }
        catch (IOException e1) {
            String mensagem = "copiaArquivo: erro inesperado ao copiar arquivo [arquivo = " + origem + "]";
            log.warn((Object)mensagem, (Throwable)e1);
        }
        double fileSize = origem.length();
        try {
            int len;
            in = new FileInputStream(origem);
            out = new FileOutputStream(destino);
            byte[] buf = new byte[2048];
            int oldStatus = 0;
            while ((len = ((InputStream)in).read(buf)) != -1) {
                out.write(buf, 0, len);
                if (listener == null) continue;
                this.actual += (long)len;
                int status = Math.round(new Float(this.actual).floatValue() / new Float(this.tamanhoArquivo).floatValue() * 100.0f);
                if (status == oldStatus) continue;
                CopiaArquivoEvent evento = new CopiaArquivoEvent(status, this);
                listener.stateChanged(evento);
            }
            out.flush();
        }
        catch (FileNotFoundException e) {
            throw new CompactacaoException("Erro ao copiar arquivo de diret\u00f3rio tempor\u00e1rio para destino", null, e);
        }
        catch (IOException e) {
            throw new CompactacaoException("Erro ao copiar arquivo de diret\u00f3rio tempor\u00e1rio para destino", null, e);
        }
        finally {
            if (in != null) {
                try {
                    ((InputStream)in).close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (out != null) {
                try {
                    out.flush();
                    out.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        log.info((Object)("arquivo copiado: origem = " + origem + " ; destino = " + destino));
    }

    public static CabecalhoArquivoCompactado getCabecalho(File arquivo) {
        CabecalhoArquivoCompactado cabecalho = null;
        RandomAccessFile raf = null;
        try {
            raf = new RandomAccessFile(arquivo, "r");
            long pos = arquivo.length() - 10L;
            raf.seek(pos);
            byte seq = raf.readByte();
            String indice = Integer.toString(seq);
            byte numPartes = raf.readByte();
            if (numPartes > 1) {
                String mensagem = "getCabecalho: numPartes>1 [" + numPartes + "]";
                log.warn((Object)mensagem);
                numPartes = 1;
            }
            long crc = raf.readLong();
            cabecalho = new CabecalhoArquivoCompactado(seq, numPartes, crc, arquivo);
            raf.close();
        }
        catch (FileNotFoundException e) {
            throw new CompactacaoException("Erro na verifica\u00e7\u00e3o do cabecalho do arquivo", null, e);
        }
        catch (IOException e) {
            throw new CompactacaoException("Erro na verifica\u00e7\u00e3o do cabecalho do arquivo", null, e);
        }
        finally {
            try {
                if (raf != null) {
                    raf.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return cabecalho;
    }

    public boolean copiaArquivoCompactadoTeste(File arquivoOrigem, File diretorioDestino, ChangeListener listener) {
        CabecalhoArquivoCompactado cabecalho;
        block14: {
            if (!arquivoOrigem.getName().toLowerCase().startsWith("remessa")) {
                log.info((Object)("copiaArquivoCompactadoTeste[1]: " + arquivoOrigem.getName()));
                CopiaArquivoEvent event = new CopiaArquivoEvent(-5, this);
                if (listener != null) {
                    listener.stateChanged(event);
                }
                if (!this.getSituacao()) {
                    return false;
                }
            }
            cabecalho = null;
            try {
                log.info((Object)("copiaArquivoCompactadoTeste[2]: " + arquivoOrigem));
                cabecalho = CompactacaoHelper.getCabecalho(arquivoOrigem);
            }
            catch (Exception e) {
                log.error((Object)"Erro ao ler cabecalho do arquivo == ", (Throwable)e);
                CopiaArquivoEvent event = new CopiaArquivoEvent(-5, this);
                if (listener != null) {
                    listener.stateChanged(event);
                }
                if (this.getSituacao()) break block14;
                return false;
            }
        }
        if (cabecalho == null) {
            log.warn((Object)("cabecalho eh null! - arq: " + arquivoOrigem));
            return false;
        }
        File[] arquivos = new File[cabecalho.numPartes];
        if (cabecalho.numPartes > 1) {
            boolean retorno = true;
            File f = arquivoOrigem;
            for (int cont = 0; cont < cabecalho.numPartes && f != null; ++cont) {
                f = new File(arquivoOrigem.getParent() + File.separator + "remessa.p0" + (cont + 1));
                if (f.exists()) {
                    arquivos[cont] = f;
                    continue;
                }
                return false;
            }
            this.montaArquivo(arquivos, "dat");
        } else {
            try {
                this.copiaArquivo(arquivoOrigem, new File(diretorioDestino.getPath() + File.separator + arquivoOrigem.getName()));
            }
            catch (OrigemEDestinoIdenticosException e) {
                log.warn((Object)("Excessao[OrigemEDestinoIdenticosException]: copiaArquivoCompactadoTeste: " + e));
                return false;
            }
            catch (Exception e) {
                log.warn((Object)("Excessao: copiaArquivoCompactadoTeste: " + e));
                e.printStackTrace();
                return false;
            }
        }
        return true;
    }

    public boolean copiaArquivoCompactado(File diretorioOrigem, File diretorioDestino, ChangeListener listener) {
        CabecalhoArquivoCompactado cabecalho;
        File arquivoOrigem;
        block20: {
            CopiaArquivoEvent event;
            arquivoOrigem = diretorioOrigem;
            if (diretorioOrigem.isDirectory()) {
                if (diretorioOrigem.listFiles() == null) {
                    event = new CopiaArquivoEvent(-7, this);
                    if (listener != null) {
                        listener.stateChanged(event);
                    }
                    if (!this.getSituacao()) {
                        return false;
                    }
                }
                if (diretorioOrigem.listFiles().length != 1) {
                    event = new CopiaArquivoEvent(-5, this);
                    if (listener != null) {
                        listener.stateChanged(event);
                    }
                    if (!this.getSituacao()) {
                        return false;
                    }
                }
                arquivoOrigem = diretorioOrigem.listFiles()[0];
            }
            if (arquivoOrigem != null && arquivoOrigem.isDirectory()) {
                event = new CopiaArquivoEvent(-5, this);
                if (listener != null) {
                    listener.stateChanged(event);
                }
                if (!this.getSituacao()) {
                    return false;
                }
            }
            if (!arquivoOrigem.getName().toLowerCase().startsWith("remessa")) {
                System.out.println(arquivoOrigem.getName());
                event = new CopiaArquivoEvent(-5, this);
                if (listener != null) {
                    listener.stateChanged(event);
                }
                if (!this.getSituacao()) {
                    return false;
                }
            }
            cabecalho = null;
            try {
                cabecalho = CompactacaoHelper.getCabecalho(arquivoOrigem);
            }
            catch (Exception e) {
                log.error((Object)"Erro ao ler cabecalho do arquivo == ", (Throwable)e);
                CopiaArquivoEvent event2 = new CopiaArquivoEvent(-5, this);
                if (listener != null) {
                    listener.stateChanged(event2);
                }
                if (this.getSituacao()) break block20;
                return false;
            }
        }
        File[] arquivos = new File[cabecalho.numPartes];
        if (cabecalho.numPartes > 1) {
            boolean retorno = true;
            File f = diretorioOrigem;
            File[] disquetes = new File[cabecalho.numPartes];
            for (int cont = 0; cont < cabecalho.numPartes && f != null; ++cont) {
                f = cont >= 2 ? this.copiaArquivoSequencia(disquetes[cont - 1], diretorioDestino, listener, cont + 1, cabecalho.numPartes) : this.copiaArquivoSequencia(diretorioOrigem, diretorioDestino, listener, cont + 1, cabecalho.numPartes);
                if (f != null) {
                    String nomeArqDisk = diretorioOrigem.getAbsolutePath().substring(0, diretorioOrigem.getAbsolutePath().indexOf("p"));
                    nomeArqDisk = cont > 9 ? nomeArqDisk + "p" + (cont + 1) : nomeArqDisk + "p0" + (cont + 1);
                    disquetes[cont] = new File(nomeArqDisk);
                    arquivos[cont] = f;
                    continue;
                }
                return false;
            }
            this.montaArquivo(arquivos, "dat");
        } else {
            this.copiaArquivo(arquivoOrigem, new File(diretorioDestino.getPath() + File.separator + arquivoOrigem.getName()));
        }
        return true;
    }

    private File copiaArquivoSequencia(File diretorioOrigem, File diretorioDestino, ChangeListener listener, int sequencia, int maximo) {
        File f = null;
        File arquivoOrigem = diretorioOrigem;
        if (diretorioOrigem.isDirectory()) {
            if (diretorioOrigem.listFiles().length != 1) {
                CopiaArquivoEvent event = new CopiaArquivoEvent(-5, this);
                listener.stateChanged(event);
                if (this.getSituacao()) {
                    return f;
                }
            }
            arquivoOrigem = diretorioOrigem.listFiles()[0];
        }
        CabecalhoArquivoCompactado cabecalho = CompactacaoHelper.getCabecalho(arquivoOrigem);
        if (cabecalho.seq == sequencia) {
            f = new File(diretorioDestino.getPath() + File.separator + arquivoOrigem.getName());
            this.copiaArquivo(arquivoOrigem, f);
        } else {
            CopiaArquivoEvent event = new CopiaArquivoEvent(-3, this);
            event.setMensagem("Insira o disco " + sequencia + " de " + maximo + " e clique em Ok");
            listener.stateChanged(event);
            if (!this.getSituacao()) {
                return f;
            }
            diretorioOrigem = sequencia >= 10 ? new File(diretorioOrigem.getAbsolutePath().substring(0, diretorioOrigem.getAbsolutePath().length() - 2) + sequencia) : new File(diretorioOrigem.getAbsolutePath().substring(0, diretorioOrigem.getAbsolutePath().length() - 2) + "0" + sequencia);
            f = this.copiaArquivoSequencia(diretorioOrigem, diretorioDestino, listener, sequencia, maximo);
        }
        return f;
    }

    public void setSituacao(boolean situacao) {
        this._situacao = situacao;
    }

    public boolean getSituacao() {
        return this._situacao;
    }

    public int getSituacaoDisquete() {
        return this.situacaoDisquete;
    }

    public void convertTxtUnixToDos(File path) {
        String so = System.getProperty("os.name").toUpperCase();
        ClassLoader loader = this.getClass().getClassLoader();
        URL url = loader.getResource("todos.exe");
        if (so.indexOf("WINDOWS") != -1) {
            try {
                File f = new File(".");
                String caminho = f.getAbsolutePath().substring(0, f.getAbsolutePath().length() - 1) + "lib" + File.separator + "todos.exe";
                Runtime.getRuntime().exec(caminho + " " + path.getPath() + File.separator + "*.txt");
            }
            catch (IOException e) {
                log.warn((Object)("N\u00e3o conseguiu executar o ToDos: " + e));
            }
            catch (Exception e) {
                log.warn((Object)("N\u00e3o conseguiu executar o ToDos: " + e));
            }
        } else {
            try {
                Runtime.getRuntime().exec("/usr/bin/unix2dos " + path.getPath() + File.separator + "*.TXT");
            }
            catch (IOException e) {
                log.warn((Object)("N\u00e3o conseguiu executar o UnixToDos: " + e));
            }
        }
    }

    public static void main(String[] a) {
        CompactacaoHelper comp = new CompactacaoHelper();
        comp.convertTxtUnixToDos(new File("C:\\PCDI\\"));
    }

    public static class CabecalhoArquivoCompactado {
        public byte seq;
        public byte numPartes;
        public long crc;
        public File file;

        CabecalhoArquivoCompactado(byte seq, byte numPartes, long crc, File file) {
            this.seq = seq;
            this.numPartes = numPartes;
            this.crc = crc;
            this.file = file;
        }
    }
}

