/*
 * Decompiled with CFR 0.152.
 */
package br.gov.rs.tce.pad.util;

import br.gov.rs.tce.pad.beans.remessa.RemessaInfo;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.zip.CRC32;

public class CodigoBarrasICHelper {
    public static final int RELATORIO_RVE = 1;
    public static final int RELATORIO_RDI = 2;
    private static List<Integer> listaRelatoriosPAD = new ArrayList<Integer>();
    static NumberFormat formatter;
    static NumberFormat formatter7Digitos;
    static NumberFormat formatter2Digitos;

    private CodigoBarrasICHelper() {
    }

    public static String constroiCodigoBarra(RemessaInfo remessa, int tipoRelatorio) {
        CRC32 gerador = new CRC32();
        Integer exercicio = remessa.getAnoExercicio();
        byte[] digest = remessa.getDigestRemessaArray();
        Integer periodo = remessa.getPeriodoInformacoes();
        Integer grupoEntrega = remessa.getGrupoEntrega();
        Date dataFinal = remessa.getDataFinalRemessa();
        if (exercicio == null) {
            throw new IllegalArgumentException("AnoExercicio n\u00e3o pode ser nulo.");
        }
        if (digest == null) {
            throw new IllegalArgumentException("Digest da remessa n\u00e3o pode ser nulo.");
        }
        if (periodo == null) {
            throw new IllegalArgumentException("Periodo de informa\u00e7\u00f5es n\u00e3o pode ser nulo.");
        }
        if (grupoEntrega == null) {
            throw new IllegalArgumentException("Grupo de Entrega n\u00e3o pode ser nulo.");
        }
        if (tipoRelatorio == 1 && dataFinal == null) {
            throw new IllegalArgumentException("Data Final da Remessa n\u00e3o pode ser nula.");
        }
        gerador.update(digest);
        String crc32 = formatter.format(gerador.getValue());
        String anoExecicio = exercicio.toString().substring(2);
        StringBuffer codigoBarras = new StringBuffer(15);
        Calendar cal = Calendar.getInstance();
        cal.setTime(dataFinal);
        codigoBarras.append(tipoRelatorio).append(grupoEntrega).append(formatter2Digitos.format(cal.get(5))).append(formatter2Digitos.format(cal.get(2) + 1)).append(anoExecicio).append(crc32);
        return codigoBarras.toString();
    }

    public static synchronized int getGrupoRelatorio(String codBarras) {
        int retorno = -1;
        if (codBarras != null && !"".equals(codBarras)) {
            retorno = Integer.parseInt(codBarras.substring(1, 2));
        }
        return retorno;
    }

    public static synchronized boolean isRelatorioPADPlus(int tipoRelatorio) {
        return listaRelatoriosPAD.contains(tipoRelatorio);
    }

    public static synchronized int getTipoRelatorio(String codBarras) {
        int retorno = -1;
        if (codBarras != null && !"".equals(codBarras)) {
            retorno = Integer.parseInt(codBarras.substring(0, 1));
        }
        return retorno;
    }

    public static synchronized int getAnoRelatorio(String codBarras) {
        int retorno = -1;
        if (codBarras != null && !"".equals(codBarras)) {
            retorno = Integer.parseInt(codBarras.substring(6, 8));
        }
        return 2000 + retorno;
    }

    public static synchronized int getDiaRelatorio(String codBarras) {
        int retorno = -1;
        if (codBarras != null && !"".equals(codBarras)) {
            retorno = Integer.parseInt(codBarras.substring(2, 4));
        }
        return retorno;
    }

    public static synchronized int getMesRelatorio(String codBarras) {
        int retorno = -1;
        if (codBarras != null && !"".equals(codBarras)) {
            retorno = Integer.parseInt(codBarras.substring(4, 6));
        }
        return retorno;
    }

    public static synchronized boolean isRelatorioPAD(int tipoRelatorio) {
        return listaRelatoriosPAD.contains(tipoRelatorio);
    }

    static {
        listaRelatoriosPAD.add(1);
        listaRelatoriosPAD.add(2);
        formatter = new DecimalFormat("0000000000");
        formatter7Digitos = new DecimalFormat("0000000");
        formatter2Digitos = new DecimalFormat("00");
    }
}

