/*
 * Decompiled with CFR 0.152.
 */
package br.gov.rs.tce.pad.modelo.verificacao.test;

import br.gov.rs.tce.pad.modelo.verificacao.regras.RegraDVContaCorrente;
import org.junit.Assert;
import org.junit.Test;

public class RegrasBancoTest {
    @Test
    public void testCaractereApenasNoUltimoDigitoOK() {
        String conta = "0000000000000117051X";
        Assert.assertEquals((Object)true, (Object)RegraDVContaCorrente.verificaCaractereApenasNoUltimoDigito(conta));
    }

    @Test
    public void testCaractereApenasNoUltimoDigitoOK2() {
        String conta = "0000000000000117051";
        Assert.assertEquals((Object)true, (Object)RegraDVContaCorrente.verificaCaractereApenasNoUltimoDigito(conta));
    }

    @Test
    public void testCaractereApenasNoUltimoDigitoErr() {
        String conta = "0000000000000117051XX";
        Assert.assertEquals((Object)false, (Object)RegraDVContaCorrente.verificaCaractereApenasNoUltimoDigito(conta));
    }

    @Test
    public void testZeroNoves() {
        String conta0 = "0000000000000";
        Assert.assertEquals((Object)true, (Object)RegraDVContaCorrente.verificaZeroNoves(conta0));
        String conta9 = "99999";
        Assert.assertEquals((Object)true, (Object)RegraDVContaCorrente.verificaZeroNoves(conta9));
        String outro = "01239";
        Assert.assertEquals((Object)false, (Object)RegraDVContaCorrente.verificaZeroNoves(outro));
    }

    @Test
    public void testsContaOK() {
        String conta = "00000000000001170510";
        Assert.assertEquals((Object)false, (Object)RegraDVContaCorrente.verificaZeroNoves(conta));
        Assert.assertEquals((Object)true, (Object)RegraDVContaCorrente.verificaCaractereApenasNoUltimoDigito(conta));
        Assert.assertEquals((Object)true, (Object)RegraDVContaCorrente.verificaDVConta(0, "333XX", conta));
    }

    @Test
    public void testRegrasDvConta_ValidaContaAgenciaEmConjunto() {
        Assert.assertEquals((Object)false, (Object)RegraDVContaCorrente.verificaDVConta(104, "123", "12345123451234512345"));
        Assert.assertEquals((Object)false, (Object)RegraDVContaCorrente.verificaDVConta(341, "123", "12345123451234512345"));
        Assert.assertEquals((Object)false, (Object)RegraDVContaCorrente.verificaDVConta(399, "123", "12345123451234512345"));
    }
}

