/*
 * Decompiled with CFR 0.152.
 */
package br.gov.rs.tce.pad.modelo.verificacao.regras.sfu;

import br.gov.rs.tce.pad.beans.ValoresCampos;
import br.gov.rs.tce.pad.modelo.importacao.ContextoVerificacao;
import br.gov.rs.tce.pad.modelo.importacao.ImportacaoEvento;
import br.gov.rs.tce.pad.modelo.verificacao.RegraLinha;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class SFU09
extends RegraLinha {
    private Map<Integer, String> funcoes = new HashMap<Integer, String>();
    public static final String LINHAS = "verificacao.SFU09.linhas";
    public static final int MAX_LINHAS = 60;

    @Override
    public void executaRegraVerificacaoLinha(ImportacaoEvento evento, ValoresCampos valoresCampos, Long numeroLinha) {
        try {
            ContextoVerificacao contexto = evento.getContextoVerificacao();
            ArrayList<Long> linhas = (ArrayList<Long>)contexto.getAtributo(LINHAS);
            if (linhas == null) {
                linhas = new ArrayList<Long>();
            }
            if (evento.getTipoEvento() == 3) {
                if (this.funcoes.size() == 0) {
                    this.funcoes = SFU09.initSubfuncoesMap((Connection)contexto.getAtributo("pad.conexaoDB"));
                    contexto.adicionaAtributo(LINHAS, linhas);
                }
                Integer anoSubFuncao = (Integer)valoresCampos.getValorCampo("exercicio");
                Integer codSubFuncao = (Integer)valoresCampos.getValorCampo("codSubFuncao");
                String nomeSubFuncao = (String)valoresCampos.getValorCampo("nomeSubFuncao");
                String dsFuncaoPortaria = null;
                if (anoSubFuncao >= 2016) {
                    if (this.funcoes.containsKey(codSubFuncao)) {
                        String escNomeSubFuncao;
                        dsFuncaoPortaria = this.funcoes.get(codSubFuncao);
                        if (!dsFuncaoPortaria.equals(escNomeSubFuncao = SFU09.escapeString(nomeSubFuncao)) && (codSubFuncao.equals(151) && !escNomeSubFuncao.equals("DEFESA AREA") || codSubFuncao.equals(781) && !escNomeSubFuncao.equals("TRANSPORTE AREO"))) {
                            linhas.add(numeroLinha);
                        }
                    } else {
                        linhas.add(numeroLinha);
                    }
                }
            } else if (evento.getTipoEvento() == 1 && linhas != null && linhas.size() > 0) {
                Object[] argumentos = new Object[]{SFU09.converteLinhastoTxt(linhas)};
                this.geraMensagemAssociadaRegra(evento.getSituacaoVerificacao(), evento.getArquivo(), argumentos);
            }
        }
        catch (SQLException e) {
            System.out.println("erro = " + e.getMessage());
        }
    }

    private static String converteLinhastoTxt(List<Long> linhas) {
        StringBuilder retorno = new StringBuilder();
        for (int i = 0; i < linhas.size(); ++i) {
            Long linha = linhas.get(i);
            retorno.append(linha);
            if (linhas.size() > 60 && i == 59) {
                retorno.append(" e outras");
                break;
            }
            if (i == linhas.size() - 2) {
                retorno.append(" e ");
                continue;
            }
            if (i >= linhas.size() - 1) continue;
            retorno.append(", ");
        }
        return retorno.toString();
    }

    public static String escapeString(String funcao) {
        if (funcao == null) {
            return null;
        }
        String retorno = funcao.toUpperCase();
        String[] caracteres = new String[]{"\u00c1", "\u00c2", "\u00c0", "\u00c3", "\u00c9", "\u00ca", "\u00c8", "\u00cd", "\u00cc", "\u00d3", "\u00d4", "\u00d2", "\u00d5", "\u00da", "\u00d9", "\u00dc", "\u00c7"};
        String[] replaceChars = new String[]{"A", "A", "A", "A", "E", "E", "E", "I", "I", "O", "O", "O", "O", "U", "U", "U", "C"};
        for (int i = 0; i < caracteres.length; ++i) {
            retorno = StringUtils.replace((String)retorno, (String)caracteres[i], (String)replaceChars[i]);
        }
        return retorno;
    }

    public static Map<Integer, String> initSubfuncoesMap(Connection conn) throws SQLException {
        HashMap<Integer, String> subfuncoes = new HashMap<Integer, String>();
        if (subfuncoes.size() == 0) {
            Statement stmt = conn.createStatement();
            ResultSet rs = stmt.executeQuery("select cd_subfuncao, ds_subfuncao from subfuncoes_portaria");
            while (rs.next()) {
                subfuncoes.put(rs.getInt("cd_subfuncao"), rs.getString("ds_subfuncao"));
            }
        }
        return subfuncoes;
    }
}

