/*
 * Decompiled with CFR 0.152.
 */
package br.gov.rs.tce.pad.modelo.verificacao.regras.bdp;

import br.gov.rs.tce.pad.beans.ValoresCampos;
import br.gov.rs.tce.pad.modelo.importacao.ImportacaoEvento;
import br.gov.rs.tce.pad.modelo.verificacao.RegraLinha;
import java.math.BigDecimal;

public class BDP32
extends RegraLinha {
    @Override
    public void executaRegraVerificacaoLinha(ImportacaoEvento evento, ValoresCampos valoresCampos, Long numeroLinha) {
        BigDecimal vlEmpenhado = (BigDecimal)valoresCampos.getValorCampo("vlEmpenhado");
        if (vlEmpenhado.doubleValue() > 0.0) {
            BigDecimal dotacaoInicial = (BigDecimal)valoresCampos.getValorCampo("dotacaoInicial");
            BigDecimal atualizMonetaria = (BigDecimal)valoresCampos.getValorCampo("atualizMonetaria");
            BigDecimal credSuplem = (BigDecimal)valoresCampos.getValorCampo("credSuplem");
            BigDecimal credEspeciais = (BigDecimal)valoresCampos.getValorCampo("credEspeciais");
            BigDecimal credExtraord = (BigDecimal)valoresCampos.getValorCampo("credExtraord");
            BigDecimal redDotacoes = (BigDecimal)valoresCampos.getValorCampo("redDotacoes");
            double total = dotacaoInicial.doubleValue() + atualizMonetaria.doubleValue() + credSuplem.doubleValue() + credEspeciais.doubleValue() + credExtraord.doubleValue() - redDotacoes.doubleValue();
            if (total > vlEmpenhado.doubleValue()) {
                Object[] argumentos = new Object[]{numeroLinha, new Double(total), vlEmpenhado};
                this.geraMensagemAssociadaRegra(evento.getSituacaoVerificacao(), "", numeroLinha, evento.getArquivo(), argumentos);
            }
        }
    }
}

