/*
 * Decompiled with CFR 0.152.
 */
package br.gov.rs.tce.pad.modelo.verificacao.regras;

import br.gov.rs.tce.pad.modelo.verificacao.regras.RegraDVContaCorrente;

public class RegraDVAgencia {
    public static boolean verificaDV(Integer codBancoSG, String codAgenciaBancoSG, String numContaCorrenteSG) {
        boolean ok = false;
        if (codBancoSG == 1) {
            if ((codAgenciaBancoSG = codAgenciaBancoSG.substring(0)).length() == 5) {
                ok = RegraDVAgencia.validaAgenciaBancoBrasil(codAgenciaBancoSG);
            }
        } else if (codBancoSG == 104) {
            String numContaCorrenteVal = RegraDVContaCorrente.substringApos(numContaCorrenteSG, 8);
            if (numContaCorrenteVal.length() == 12 && codAgenciaBancoSG.length() >= 4) {
                ok = RegraDVContaCorrente.validaContaBancoCEF(codAgenciaBancoSG, numContaCorrenteVal);
            }
        } else if (codBancoSG == 341) {
            String numContaCorrenteVal = RegraDVContaCorrente.substringApos(numContaCorrenteSG, 14);
            if (numContaCorrenteVal.length() == 6 && codAgenciaBancoSG.length() >= 4) {
                ok = RegraDVContaCorrente.validaContaBancoItau(codAgenciaBancoSG, numContaCorrenteVal);
            }
        } else if (codBancoSG == 399) {
            String numContaCorrenteVal = RegraDVContaCorrente.substringApos(numContaCorrenteSG, 13);
            if (numContaCorrenteVal.length() == 7 && codAgenciaBancoSG.length() >= 4) {
                ok = RegraDVContaCorrente.validaContaBancoHSBC(codAgenciaBancoSG, numContaCorrenteVal);
            }
        } else {
            ok = true;
        }
        return ok;
    }

    public static boolean validaAgenciaBancoBrasil(String numAgencia) {
        StringBuilder auxAgencia = new StringBuilder();
        auxAgencia.append(numAgencia.substring(0));
        int base = 2;
        int soma = 0;
        for (int i = 3; i >= 0; --i) {
            soma += (auxAgencia.charAt(i) - 48) * base;
            base = (byte)(base + 1);
        }
        int digito = soma % 11;
        digito = 11 - digito;
        char v_digito = (char)(digito + 48);
        if (digito == 10) {
            v_digito = 'X';
        } else if (digito == 11) {
            v_digito = '0';
        }
        return v_digito == 'X' ? numAgencia.charAt(4) == 'X' || numAgencia.charAt(4) == 'x' : v_digito == numAgencia.charAt(4);
    }

    public static boolean validaContaAgenciaBradesco(String numAgencia) {
        char v_digito;
        StringBuilder auxAgencia = new StringBuilder();
        auxAgencia.append(numAgencia.substring(0));
        int base = 2;
        int soma = 0;
        for (int i = 3; i >= 0; --i) {
            soma += (auxAgencia.charAt(i) - 48) * base;
            base = (byte)(base + 1);
        }
        int digito = soma % 11;
        if (digito == 11) {
            v_digito = '0';
        } else if (digito == 10) {
            v_digito = 'P';
        } else {
            digito = 11 - digito;
            v_digito = (char)(digito + 48);
        }
        return v_digito == numAgencia.charAt(4);
    }
}

