/*
 * Decompiled with CFR 0.152.
 */
package br.gov.rs.tce.pad.modelo.verificacao.regras;

import br.gov.rs.tce.pad.beans.Arquivo;
import br.gov.rs.tce.pad.beans.Campo;
import br.gov.rs.tce.pad.beans.MetadadosArquivoContabil;
import br.gov.rs.tce.pad.beans.SituacaoVerificacao;
import br.gov.rs.tce.pad.beans.ValoresCampos;
import br.gov.rs.tce.pad.excecao.VerificacaoException;
import br.gov.rs.tce.pad.modelo.verificacao.regras.BaseRegraCampo;
import java.io.Serializable;
import java.sql.Date;
import java.util.Arrays;

public final class Intervalo
extends BaseRegraCampo
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String _inicio;
    private boolean _has_inicio;
    private String _final;
    private boolean _has_final;

    public void deleteFinal() {
        this._has_final = false;
    }

    public void deleteInicio() {
        this._has_inicio = false;
    }

    public String getFinal() {
        return this._final;
    }

    public String getInicio() {
        return this._inicio;
    }

    public boolean hasFinal() {
        return this._has_final;
    }

    public boolean hasInicio() {
        return this._has_inicio;
    }

    public void setFinal(String _final) {
        this._final = _final;
        this._has_final = true;
    }

    public void setInicio(String inicio) {
        this._inicio = inicio;
        this._has_inicio = true;
    }

    @Override
    public void executaLogicaVerificacaoCampo(ValoresCampos valoresCampo, Campo definicaoCampo, SituacaoVerificacao situacao, MetadadosArquivoContabil metaDados, Long linhaAtual, Integer colunaAtual) throws VerificacaoException {
        Object valorCampo = Intervalo.getValorCampo(valoresCampo, definicaoCampo);
        if (valorCampo instanceof Date) {
            Date valorRegraInicio = (Date)Intervalo.resolveValorAtributo(situacao.getRemessa(), metaDados, this.getInicio(), definicaoCampo.getNome(), definicaoCampo.getTipoDadoId(), definicaoCampo.isInteiro(), definicaoCampo.getMascara(), valoresCampo);
            Date valorRegraFinal = (Date)Intervalo.resolveValorAtributo(situacao.getRemessa(), metaDados, this.getFinal(), definicaoCampo.getNome(), definicaoCampo.getTipoDadoId(), definicaoCampo.isInteiro(), definicaoCampo.getMascara(), valoresCampo);
            this.comparaData(valorCampo, valorRegraInicio, valorRegraFinal, metaDados.getArquivo(), situacao, linhaAtual, colunaAtual);
        } else if (valorCampo instanceof Number) {
            Number valorRegraInicio = (Number)Intervalo.resolveValorAtributo(situacao.getRemessa(), metaDados, this.getInicio(), definicaoCampo.getNome(), definicaoCampo.getTipoDadoId(), definicaoCampo.isInteiro(), definicaoCampo.getMascara(), valoresCampo);
            Number valorRegraFinal = (Number)Intervalo.resolveValorAtributo(situacao.getRemessa(), metaDados, this.getFinal(), definicaoCampo.getNome(), definicaoCampo.getTipoDadoId(), definicaoCampo.isInteiro(), definicaoCampo.getMascara(), valoresCampo);
            this.comparaNumero(valorCampo, valorRegraInicio, valorRegraFinal, metaDados.getArquivo(), situacao, linhaAtual, colunaAtual, definicaoCampo.getTipoDadoId());
        } else if (!definicaoCampo.isAceitaDataVazia() || valorCampo != null) {
            System.err.println("Intervalo: nomecampo:: " + definicaoCampo.getNome() + "; list:: " + Arrays.asList(valoresCampo.getValoresCamposArray()));
            if (valorCampo != null) {
                if (valorCampo.getClass() != null) {
                    throw new IllegalArgumentException("O tipo de dado recebido (" + valorCampo.getClass() + "/" + valorCampo.getClass().getName() + ") n\u00e3o e valido, valores validos sao java.sql.Date ou java.lang.Number.");
                }
                throw new IllegalArgumentException("O tipo de dado recebido (" + valorCampo + ") n\u00e3o e valido, valores validos sao java.sql.Date ou java.lang.Number.");
            }
            throw new IllegalArgumentException("O tipo de dado recebido (null::" + valorCampo + ":" + metaDados.getArquivo().getNome() + ":" + definicaoCampo.getNome() + "[" + definicaoCampo.getInicio() + ":" + definicaoCampo.getFinal() + ";col=" + definicaoCampo.getColuna() + "];lin=" + linhaAtual + ") n\u00e3o e valido, valores validos sao java.sql.Date ou java.lang.Number.");
        }
    }

    private void comparaNumero(Object valorCampo, Number valorRegraInicio, Number valorRegraFinal, Arquivo arquivo, SituacaoVerificacao situacao, Long linhaAtual, Integer colunaAtual, int tipoDado) {
        double valorCampoNumero = ((Number)valorCampo).doubleValue();
        double inicioNumero = valorRegraInicio.doubleValue();
        double finalNumero = valorRegraFinal.doubleValue();
        if (valorCampoNumero < inicioNumero) {
            Object[] args = new Object[]{linhaAtual, valorCampo, tipoDado == 3 || tipoDado == 4 ? (Number)new Double(inicioNumero).longValue() : (Number)inicioNumero};
            this.geraMensagemAssociadaRegra(situacao, this.getCodigoMensagem(1), arquivo, linhaAtual, colunaAtual, args);
        } else if (valorCampoNumero > finalNumero) {
            Object[] args = new Object[]{linhaAtual, valorCampo, tipoDado == 3 || tipoDado == 4 ? (Number)new Double(finalNumero).longValue() : (Number)finalNumero};
            int indiceCodigoMensagem = 1;
            if (this._codigoMensagemArray.length > 1) {
                indiceCodigoMensagem = 2;
            }
            this.geraMensagemAssociadaRegra(situacao, this.getCodigoMensagem(indiceCodigoMensagem), arquivo, linhaAtual, colunaAtual, args);
        }
    }

    private void comparaData(Object valorCampo, Date valorRegraInicio, Date valorRegraFinal, Arquivo arquivo, SituacaoVerificacao situacao, Long linhaAtual, Integer colunaAtual) {
        long zero = 0L;
        long valorCampoData = ((Date)valorCampo).getTime();
        long inicioData = valorRegraInicio.getTime();
        long finalData = valorRegraFinal.getTime();
        if (valorCampoData == zero) {
            Object[] args = new Object[]{linhaAtual, "00/00/0000", inicioData};
            this.geraMensagemAssociadaRegra(situacao, this.getCodigoMensagem(1), arquivo, linhaAtual, colunaAtual, args);
        } else if (valorCampoData < inicioData) {
            Object[] args = new Object[]{linhaAtual, valorCampo, inicioData};
            this.geraMensagemAssociadaRegra(situacao, this.getCodigoMensagem(1), arquivo, linhaAtual, colunaAtual, args);
        } else if (valorCampoData > finalData) {
            int indiceCodigoMensagem = 1;
            if (this._codigoMensagemArray.length > 1) {
                indiceCodigoMensagem = 2;
            }
            Object[] args = new Object[]{linhaAtual, valorCampo, finalData};
            this.geraMensagemAssociadaRegra(situacao, this.getCodigoMensagem(indiceCodigoMensagem), arquivo, linhaAtual, colunaAtual, args);
        }
    }
}

