/*
 * Decompiled with CFR 0.152.
 */
package br.gov.rs.tce.pad.modelo.test;

import br.gov.rs.tce.modelo.beans.TipoBancoDados;
import br.gov.rs.tce.pad.beans.Arquivo;
import br.gov.rs.tce.pad.beans.Arquivos;
import br.gov.rs.tce.pad.beans.ConfigTelas;
import br.gov.rs.tce.pad.beans.ConsultaSQL;
import br.gov.rs.tce.pad.beans.ConsultasQuadrosList;
import br.gov.rs.tce.pad.beans.QuadroContas;
import br.gov.rs.tce.pad.beans.Quadros;
import br.gov.rs.tce.pad.beans.Tela;
import br.gov.rs.tce.pad.beans.test.PADBeansTestFixture;
import br.gov.rs.tce.pad.modelo.ConfiguracaoControle;
import br.gov.rs.tce.pad.modelo.test.DerbyDatabaseConnectionFixture;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Enumeration;
import junit.framework.TestCase;

public class ConfiguracaoControleTest
extends TestCase {
    PADBeansTestFixture beansFixture = new PADBeansTestFixture();
    String dirTest = "src_test";

    public ConfiguracaoControleTest(String sTestName) {
        super(sTestName);
    }

    public void testcarregaDadosArquivoXML() {
    }

    public void testcarregaDadosArquivoXML_Consultaquadros() {
        String fileName = "test/consultas-quadros-test.xml";
        fileName = "consultas-quadros.xml";
        try {
            ConsultasQuadrosList quadros = (ConsultasQuadrosList)ConfiguracaoControle.carregaDadosArquivoXML("consultas-quadros", new File(fileName));
            ConfiguracaoControleTest.assertTrue((String)"A lista de consultas veio vazio talvez n\u00e3o tenha encontrado o arquivo ou ele esteja vazio.", (quadros.getTotalConsultas() > 0 ? 1 : 0) != 0);
            ConsultaSQL sql1 = quadros.getConsultaPorCodigo("UC049-QUADROS");
            ConfiguracaoControleTest.assertNotNull((String)"N\u00e3o foi possivel ler a consulta de teste UC049-QUADROS", (Object)sql1);
            ConsultaSQL sql2 = quadros.getConsultaPorCodigo("POPUP-RUBRICA-ATUAL");
            ConfiguracaoControleTest.assertNotNull((String)"N\u00e3o foi possivel ler a consulta de teste POPUP-RUBRICA-ATUAL", (Object)sql2);
            ConfiguracaoControleTest.assertNotNull((String)"N\u00e3o foi possivel buscar o parametros", (Object)sql2.getParametroPorNome("consulta.parametro.1"));
        }
        catch (Exception e) {
            e.printStackTrace();
            ConfiguracaoControleTest.fail((String)("N\u00e3o conseguiu inicializar as defini\u00e7\u00f5es a partir do arquivo: " + fileName));
        }
    }

    public void testcarregaDadosArquivoXML_Arquivos() {
        String fileName = "test/arquivos.xml";
        try {
            Arquivos arquivos = (Arquivos)ConfiguracaoControle.carregaDadosArquivoXML("arquivos-principal", new File(fileName));
            Arquivo arq = arquivos.getArquivoPorIdentificador(Arquivo.criaIdenficadorArquivo("ORGAO"));
            ConfiguracaoControleTest.assertNotNull((String)"N\u00e3o foi possivel ler a consulta de teste CONSULTA-O1", (Object)arq);
        }
        catch (Exception e) {
            e.printStackTrace();
            ConfiguracaoControleTest.fail((String)("N\u00e3o conseguiu inicializar as defini\u00e7\u00f5es a partir do arquivo: " + fileName));
        }
    }

    public void testcarregaDadosArquivoXML_ConfigTelas() {
        String fileName = this.dirTest + "/config-telas-test.xml";
        try {
            Object[] valores;
            ConsultaSQL sql;
            int i;
            ConfigTelas telas = (ConfigTelas)ConfiguracaoControle.carregaDadosArquivoXML("telas", new File(fileName), true);
            ConfiguracaoControle.carregaDadosArquivoXML("consultas-quadros", new File(this.dirTest + "/consultas-quadros-test.xml"), true);
            Tela t1 = telas.getTelaPorCodigo("TELA-03");
            ConfiguracaoControleTest.assertNotNull((String)"Tela n\u00e3o deveria ser nulo", (Object)t1);
            ConfiguracaoControleTest.assertNotNull((String)"Um Panel deve ser definido para a classe", (Object)t1.getPanelClass());
            Quadros qds = t1.getQuadros();
            ConfiguracaoControleTest.assertNotNull((String)"Quadros n\u00e3o pode ser nulo", (Object)qds);
            QuadroContas[] qcontas = qds.getQuadroContas();
            ConfiguracaoControleTest.assertNotNull((String)"Quadros n\u00e3o pode conter um array nulo de quadrocontas", (Object)qds.getQuadro());
            ConfiguracaoControleTest.assertTrue((String)"Quadros deve contar 1 quadro no minimo", (qcontas.length > 0 ? 1 : 0) != 0);
            for (i = 0; i < qcontas.length; ++i) {
                sql = qcontas[i].recuperaSQLInsereContasRemessa(this.beansFixture.getRemessa(), TipoBancoDados.ORACLE_DB);
                ConfiguracaoControleTest.assertNotNull((String)"SQL nao pode ser vazio", (Object)sql.getSql());
                valores = sql.getValoresParametros(this.beansFixture.getRemessa(), TipoBancoDados.ORACLE_DB);
                ConfiguracaoControleTest.assertNotNull((Object)valores);
            }
            t1 = telas.getTelaPorCodigo("TELA-04");
            ConfiguracaoControleTest.assertNotNull((String)"Tela n\u00e3o deveria ser nulo", (Object)t1);
            ConfiguracaoControleTest.assertNotNull((String)"Um Panel deve ser definido para a classe", (Object)t1.getPanelClass());
            qds = t1.getQuadros();
            ConfiguracaoControleTest.assertNotNull((String)"Quadros n\u00e3o pode ser nulo", (Object)qds);
            qcontas = qds.getQuadroContas();
            ConfiguracaoControleTest.assertNotNull((String)"Quadros n\u00e3o pode conter um array nulo de quadrocontas", (Object)qds.getQuadro());
            ConfiguracaoControleTest.assertTrue((String)"Quadros deve contar 1 quadro no minimo", (qcontas.length > 0 ? 1 : 0) != 0);
            for (i = 0; i < qcontas.length; ++i) {
                sql = qcontas[i].recuperaSQLInsereContasRemessa(this.beansFixture.getRemessa(), TipoBancoDados.ORACLE_DB);
                ConfiguracaoControleTest.assertNotNull((String)"SQL nao pode ser vazio", (Object)sql.getSql());
                valores = sql.getValoresParametros(this.beansFixture.getRemessa(), TipoBancoDados.ORACLE_DB);
                ConfiguracaoControleTest.assertNotNull((Object)valores);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            ConfiguracaoControleTest.fail((String)("N\u00e3o conseguiu inicializar as defini\u00e7\u00f5es a partir do arquivo: " + fileName));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testTipoContaArquivoXML_ConfigTelas() {
        System.out.println("->> test:: testTipoContaArquivoXML_ConfigTelas");
        String fileName = "src/config-telas.xml";
        DerbyDatabaseConnectionFixture fixture = new DerbyDatabaseConnectionFixture("./test/database");
        ArrayList<Integer> tipoComProblemas = new ArrayList<Integer>();
        try {
            fixture.setUp();
            int ultimoAnoBi = this.getUltimoAnoBi(fixture.conexao);
            ConfigTelas telas = (ConfigTelas)ConfiguracaoControle.carregaDadosArquivoXML("telas", new File(fileName));
            Enumeration<Tela> en = telas.enumerateTela();
            PreparedStatement ps = fixture.conexao.prepareStatement("select count(*) from grupo_contas_padrao where cd_tipo = ? and anobi = " + ultimoAnoBi);
            while (en.hasMoreElements()) {
                Tela tela = en.nextElement();
                Quadros quadros = tela.getQuadros();
                if (quadros == null) continue;
                QuadroContas[] qcontas = quadros.getQuadroContas();
                for (int i = 0; i < qcontas.length; ++i) {
                    int qtd;
                    QuadroContas q = qcontas[i];
                    Integer tConta = q.getTipoConta();
                    ps.setInt(1, tConta);
                    ResultSet rs = ps.executeQuery();
                    if (rs.next() && (qtd = rs.getInt(1)) == 0) {
                        System.out.println("ConfiguracaoControleTest: " + tela.getCodigo() + " - " + q.getNome() + " - " + tConta);
                        tipoComProblemas.add(tConta);
                    }
                    rs.close();
                }
            }
            if (tipoComProblemas.size() > 0) {
                String msg = "ConfiguracaoControleTest: Existem tipo de conta no config-telas.xml que n\u00e3o possuem nenhum mascara definida na tabela grupo_contas_padrao [anobi=" + ultimoAnoBi + " ; count=" + tipoComProblemas.size() + "]";
                System.err.println(msg);
            }
        }
        catch (Exception ex) {
            ConfiguracaoControleTest.fail((String)"Nao deveria ter lan\u00e7ado esta exce\u00e7\u00e3o");
        }
        finally {
            fixture.tearDown();
        }
    }

    public void testObjectSerializationConfig() {
        String fileName = "src/config-telas.xml";
        long t = System.currentTimeMillis();
        ConfigTelas telas = (ConfigTelas)ConfiguracaoControle.carregaDadosArquivoXML("telas", new File(fileName), true);
        System.out.println("t1 - " + (System.currentTimeMillis() - t));
        try {
            ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream(new File("./test/config-telas.data")));
            oos.writeObject(telas);
            oos.close();
            t = System.currentTimeMillis();
            ObjectInputStream ios = new ObjectInputStream(new FileInputStream(new File("./test/config-telas.data")));
            telas = (ConfigTelas)ios.readObject();
            System.out.println("t2 - " + (System.currentTimeMillis() - t));
            ios.close();
        }
        catch (ClassNotFoundException oos) {
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        fileName = "src/consultas-quadros.xml";
        t = System.currentTimeMillis();
        ConsultasQuadrosList consultaquadros = (ConsultasQuadrosList)ConfiguracaoControle.carregaDadosArquivoXML("consultas-quadros", new File(fileName), true);
        System.out.println("t1 - " + (System.currentTimeMillis() - t));
        try {
            ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream(new File("./test/consultas-quadros.data")));
            oos.writeObject(consultaquadros);
            oos.close();
            t = System.currentTimeMillis();
            ObjectInputStream ios = new ObjectInputStream(new FileInputStream(new File("./test/consultas-quadros.data")));
            consultaquadros = (ConsultasQuadrosList)ios.readObject();
            System.out.println("t2 - " + (System.currentTimeMillis() - t));
            ios.close();
        }
        catch (ClassNotFoundException oos) {
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    int getUltimoAnoBi(Connection conn) throws SQLException {
        String sql = "select anobi, count(*) from grupo_contas_padrao group by anobi order by anobi desc";
        ResultSet rs = conn.createStatement().executeQuery(sql);
        if (rs.next()) {
            return rs.getInt(1);
        }
        throw new IllegalStateException("tabela grupo_contas_padrao vazia?");
    }

    public void testGravaSerializados() {
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.beansFixture.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.beansFixture.tearDown();
    }
}

