/*
 * Decompiled with CFR 0.152.
 */
package br.gov.rs.tce.pad.modelo.importacao.test;

import br.gov.rs.tce.pad.beans.MensagemInstancia;
import br.gov.rs.tce.pad.beans.SituacaoVerificacao;
import br.gov.rs.tce.pad.modelo.importacao.test.AbstractImportacaoRegras;
import br.gov.rs.tce.pad.modelo.importacao.test.ImportacaoTestUtils;
import java.util.List;
import java.util.Map;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;

public class ImportacaoRegrasLIQ
extends AbstractImportacaoRegras {
    String[] idsEmpenho = new String[]{"ORGAO", "UNIORCAM", "RECURSO", "PROGRAMA", "PROJATIV", "RUBRICA", "CREDOR", "EMPENHO"};
    String[] idsLiquidac = new String[]{"ORGAO", "UNIORCAM", "RECURSO", "PROGRAMA", "PROJATIV", "RUBRICA", "CREDOR", "EMPENHO", "LIQUIDAC"};
    String[] codigosAIgnorar = new String[]{"ARQ_04", "EMP_67", "EMP_68", "EMP_69", "EMP_73", "EMP_74", "EMP_78", "EMP_86", "EMP_87", "LIQ_36", "LIQ_37", "LIQ_38", "LIQ_39", "LIQ_40", "LIQ_41", "LIQ_44"};
    @Rule
    public TestName name = new TestName();

    @Override
    @Before
    public void setup() {
        super.setup();
        System.out.println("->> test:: " + this.name.getMethodName());
    }

    @Test
    public void testEmpenhos() {
        this.setupVerificacaoArquivosControle(this.idsEmpenho);
        SituacaoVerificacao situacaoVerificacao = new SituacaoVerificacao();
        situacaoVerificacao.setRemessa(this.criaRemessaPrefeitura(2013, 6, 71900, "92403567000127", "../PAD-Desktop/src_test/2013b6-taquarucu/liq"));
        this.verificacaoArquivosControle.verificaArquivos(situacaoVerificacao, this.conexao, this.importacaoListenerLoggger);
        List<MensagemInstancia> msgs = situacaoVerificacao.getMensagens();
        msgs = ImportacaoTestUtils.removeByCodigos(msgs, this.codigosAIgnorar);
        this.showMessages(msgs);
        Assert.assertEquals((long)0L, (long)msgs.size());
    }

    @Test
    public void testEmp58_erro() {
        this.setupVerificacaoArquivosControle(this.idsEmpenho);
        SituacaoVerificacao situacaoVerificacao = new SituacaoVerificacao();
        situacaoVerificacao.setRemessa(this.criaRemessaPrefeitura(2013, 6, 71900, "92403567000127", "../PAD-Desktop/src_test/2013b6-taquarucu/liq/emp_58-erro"));
        this.verificacaoArquivosControle.verificaArquivos(situacaoVerificacao, this.conexao, this.importacaoListenerLoggger);
        List<MensagemInstancia> msgs = situacaoVerificacao.getMensagens();
        msgs = ImportacaoTestUtils.removeByCodigos(msgs, this.codigosAIgnorar);
        this.showMessages(msgs);
        Assert.assertEquals((long)3L, (long)msgs.size());
        Assert.assertEquals((Object)"EMP_58", (Object)msgs.get(0).getCodigoMensagem());
        Assert.assertEquals((Object)"EMP_58", (Object)msgs.get(1).getCodigoMensagem());
        Assert.assertEquals((Object)"EMP_61", (Object)msgs.get(2).getCodigoMensagem());
    }

    @Test
    public void testEmp59_erro() {
        this.setupVerificacaoArquivosControle(this.idsEmpenho);
        SituacaoVerificacao situacaoVerificacao = new SituacaoVerificacao();
        situacaoVerificacao.setRemessa(this.criaRemessaPrefeitura(2013, 6, 71900, "92403567000127", "../PAD-Desktop/src_test/2013b6-taquarucu/liq/emp_59-erro"));
        this.verificacaoArquivosControle.verificaArquivos(situacaoVerificacao, this.conexao, this.importacaoListenerLoggger);
        List<MensagemInstancia> msgs = situacaoVerificacao.getMensagens();
        msgs = ImportacaoTestUtils.removeByCodigos(msgs, this.codigosAIgnorar);
        this.showMessages(msgs);
        Assert.assertEquals((long)0L, (long)msgs.size());
    }

    @Test
    public void testLiquidac() {
        this.setupVerificacaoArquivosControle(this.idsLiquidac);
        SituacaoVerificacao situacaoVerificacao = new SituacaoVerificacao();
        situacaoVerificacao.setRemessa(this.criaRemessaPrefeitura(2013, 6, 71900, "92403567000127", "../PAD-Desktop/src_test/2013b6-taquarucu/liq"));
        this.verificacaoArquivosControle.verificaArquivos(situacaoVerificacao, this.conexao, this.importacaoListenerLoggger);
        List<MensagemInstancia> msgs = situacaoVerificacao.getMensagens();
        msgs = ImportacaoTestUtils.removeByCodigos(msgs, this.codigosAIgnorar);
        this.showMessages(msgs);
        Assert.assertEquals((long)0L, (long)msgs.size());
    }

    @Test
    public void testLiq20_erro() {
        this.setupVerificacaoArquivosControle(this.idsLiquidac);
        SituacaoVerificacao situacaoVerificacao = new SituacaoVerificacao();
        situacaoVerificacao.setRemessa(this.criaRemessaPrefeitura(2013, 6, 71900, "92403567000127", "../PAD-Desktop/src_test/2013b6-taquarucu/liq/liq_20"));
        this.verificacaoArquivosControle.verificaArquivos(situacaoVerificacao, this.conexao, this.importacaoListenerLoggger);
        List<MensagemInstancia> msgs = situacaoVerificacao.getMensagens();
        msgs = ImportacaoTestUtils.removeByCodigos(msgs, this.codigosAIgnorar);
        this.showMessages(msgs);
        Assert.assertEquals((long)2L, (long)msgs.size());
        Assert.assertEquals((Object)"LIQ_20", (Object)msgs.get(0).getCodigoMensagem());
        Assert.assertEquals((Object)"LIQ_21", (Object)msgs.get(1).getCodigoMensagem());
    }

    @Test
    public void testLiq24_25_erro() {
        this.setupVerificacaoArquivosControle(this.idsLiquidac);
        SituacaoVerificacao situacaoVerificacao = new SituacaoVerificacao();
        situacaoVerificacao.setRemessa(this.criaRemessaPrefeitura(2013, 6, 71900, "92403567000127", "../PAD-Desktop/src_test/2013b6-taquarucu/liq/liq_24"));
        this.verificacaoArquivosControle.verificaArquivos(situacaoVerificacao, this.conexao, this.importacaoListenerLoggger);
        List<MensagemInstancia> msgs = situacaoVerificacao.getMensagens();
        msgs = ImportacaoTestUtils.removeByCodigos(msgs, this.codigosAIgnorar);
        this.showMessages(msgs);
        Map<String, Integer> countMap = ImportacaoTestUtils.getCountByCodigoMap(msgs);
        Assert.assertEquals((Object)1, (Object)countMap.get("LIQ_24"));
        Assert.assertEquals((Object)1, (Object)countMap.get("LIQ_25"));
        Map<String, List<MensagemInstancia>> msgMap = ImportacaoTestUtils.getListByCodigoMap(msgs);
        Assert.assertEquals((long)2L, (long)msgMap.get("LIQ_24").get(0).getLinha());
        Assert.assertEquals((long)3L, (long)msgMap.get("LIQ_25").get(0).getLinha());
    }
}

