/*
 * Decompiled with CFR 0.152.
 */
package br.gov.rs.tce.pad.modelo.importacao.test;

import br.gov.rs.tce.pad.beans.Arquivo;
import br.gov.rs.tce.pad.beans.Formato;
import br.gov.rs.tce.pad.beans.MetadadosArquivoContabil;
import br.gov.rs.tce.pad.excecao.FinalizadorException;
import br.gov.rs.tce.pad.modelo.importacao.ArquivoContabilReader;
import br.gov.rs.tce.pad.modelo.importacao.ImportacaoArquivoControleImpl;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ArquivoContabilReaderTest
extends TestCase {
    private final String nomeArquivo = "ArquivoContabilReaderTest.txt";
    private ArquivoContabilReader contabilReader = null;
    private Arquivo arquivobean = new Arquivo();
    private MetadadosArquivoContabil metadados = new MetadadosArquivoContabil(this.arquivobean);
    private static final Log log = LogFactory.getLog(ArquivoContabilReaderTest.class);

    public ArquivoContabilReaderTest(String sTestName) {
        super(sTestName);
        this.metadados.setArquivoFisico(new File("ArquivoContabilReaderTest.txt"));
        this.contabilReader = new ArquivoContabilReader(this.metadados);
        this.arquivobean.setFormato(new Formato());
        ImportacaoArquivoControleImpl imp = new ImportacaoArquivoControleImpl();
        this.contabilReader.setImportacaoControle(imp);
    }

    private void deleteFile() {
        boolean success = new File("ArquivoContabilReaderTest.txt").delete();
        if (!success) {
            // empty if block
        }
    }

    private void createFileOk() {
        try {
            BufferedWriter out = this.criaArquivo();
            for (int i = 0; i < 100; ++i) {
                out.write("AGSUYAGSYUAGSUYAGSUYAGSUYGASUYAGSUYAGSUAYSGUAYSGUYASGUYAGSUYSGA");
                out.newLine();
            }
            out.write("FINALIZADOR0000000099");
            out.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void createFileErroNumeroLinhas() {
        try {
            BufferedWriter out = this.criaArquivo();
            for (int i = 0; i < 100; ++i) {
                out.write("AGSUYAGSYUAGSUYAGSUYAGSUYGASUYAGSUYAGSUAYSGUAYSGUYASGUYAGSUYSGA");
                out.newLine();
            }
            out.write("FINALIZADOR000000000101");
            out.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void createFileErroFinalizador() {
        try {
            BufferedWriter out = this.criaArquivo();
            for (int i = 0; i < 100; ++i) {
                out.write("AGSUYAGSYUAGSUYAGSUYAGSUYGASUYAGSUYAGSUAYSGUAYSGUYASGUYAGSUYSGA");
                out.newLine();
            }
            out.write("FINALIZ0000000000099");
            out.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void testArquivoContabilReaderOk() {
        Object importacaoArquivoControle = null;
        this.createFileOk();
        this.deleteFile();
    }

    public void testArquivoContabilReaderErroFinalizador() {
        Object importacaoArquivoControle = null;
        try {
            this.createFileErroFinalizador();
            this.deleteFile();
        }
        catch (FinalizadorException e) {
            System.out.println("Ok Lan\u00e7ou a exception correta: " + e.getMessage());
        }
    }

    public void testArquivoContabilReaderErroNumeroLinhas() {
        Object importacaoArquivoControle = null;
        try {
            this.createFileErroNumeroLinhas();
            this.deleteFile();
        }
        catch (FinalizadorException e) {
            System.out.println("Ok Lan\u00e7ou a exception correta: " + e.getMessage());
        }
    }

    public void testgetMessageDigest() {
        this.createFileOk();
        byte[] messageDigest = this.contabilReader.getMessageDigest();
        System.out.println("messageDigest: " + messageDigest);
        ArquivoContabilReaderTest.assertEquals((Object)messageDigest, (Object)messageDigest);
        this.deleteFile();
    }

    public static Test suite() {
        return new TestSuite(ArquivoContabilReaderTest.class);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)ArquivoContabilReaderTest.suite());
    }

    private BufferedWriter criaArquivo() throws IOException {
        BufferedWriter out = new BufferedWriter(new FileWriter(new File("ArquivoContabilReaderTest.txt")));
        return out;
    }
}

