/*
 * Decompiled with CFR 0.152.
 */
package br.gov.rs.tce.pad.modelo.importacao;

import br.gov.rs.tce.pad.beans.Arquivo;
import br.gov.rs.tce.pad.beans.Arquivos;
import br.gov.rs.tce.pad.beans.MetadadosArquivoContabil;
import br.gov.rs.tce.pad.beans.SituacaoVerificacao;
import br.gov.rs.tce.pad.excecao.ImportacaoException;
import br.gov.rs.tce.pad.excecao.PersistenciaException;
import br.gov.rs.tce.pad.modelo.importacao.ArquivoContabilReader;
import br.gov.rs.tce.pad.modelo.importacao.ContextoVerificacao;
import br.gov.rs.tce.pad.modelo.importacao.ImportacaoArquivoControle;
import br.gov.rs.tce.pad.modelo.importacao.ImportacaoArquivoControleImpl;
import br.gov.rs.tce.pad.modelo.importacao.ImportacaoListener;
import br.gov.rs.tce.pad.modelo.importacao.RepositorioArquivosControle;
import br.gov.rs.tce.pad.modelo.mensagem.MensagemFactory;
import br.gov.rs.tce.pad.modelo.verificacao.ExecutorRegras;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class ImportacaoControle {
    public static final Log log = LogFactory.getLog(ImportacaoControle.class);
    static MensagemFactory msgFactory = MensagemFactory.getInstancia();
    private boolean _validaDependencias = false;
    protected Arquivos _arquivos;

    public final void importaArquivo(RepositorioArquivosControle repositorioArquivosControle, SituacaoVerificacao situacaoVerificacao, ContextoVerificacao contextoVerificacao, MetadadosArquivoContabil metadadosArquivo, ExecutorRegras executorRegras, ImportacaoListener importacaoListener) throws PersistenciaException {
        ImportacaoArquivoControle importacaoArquivoControle = null;
        ArquivoContabilReader arquivoContabilReader = new ArquivoContabilReader(metadadosArquivo);
        Arquivo arquivo = metadadosArquivo.getArquivo();
        repositorioArquivosControle.inicializaTabelaRepositorio(arquivo);
        importacaoArquivoControle = ImportacaoControle.criaImportacaoArquivoControle(arquivo);
        arquivoContabilReader.setImportacaoControle(importacaoArquivoControle);
        importacaoArquivoControle.setRepositorioArquivosControle(repositorioArquivosControle);
        importacaoArquivoControle.setImportacaoListener(importacaoListener);
        importacaoArquivoControle.setExecutorRegras(executorRegras);
        importacaoArquivoControle.carregaArquivo(arquivoContabilReader, contextoVerificacao, situacaoVerificacao);
    }

    public ImportacaoControle(Arquivos arquivos) {
        this._arquivos = arquivos;
    }

    protected static synchronized ImportacaoArquivoControle criaImportacaoArquivoControle(Arquivo arquivoConfig) {
        String nomeClasse = arquivoConfig.getControleImportacaoClass();
        ImportacaoArquivoControleImpl importacaoArquivoControle = null;
        try {
            Class<?> clazz = Class.forName(nomeClasse);
            importacaoArquivoControle = (ImportacaoArquivoControleImpl)clazz.newInstance();
        }
        catch (Exception e) {
            throw new ImportacaoException("10019", new Object[]{nomeClasse}, e);
        }
        return importacaoArquivoControle;
    }

    public void setValidaDependencias(boolean validaDependencias) {
        this._validaDependencias = validaDependencias;
    }

    public boolean isValidaDependencias() {
        return this._validaDependencias;
    }
}

