/*
 * Decompiled with CFR 0.152.
 */
package br.gov.rs.tce.pad.modelo.importacao;

import br.gov.rs.tce.modelo.beans.TipoBancoDados;
import br.gov.rs.tce.pad.beans.Arquivo;
import br.gov.rs.tce.pad.beans.Campo;
import br.gov.rs.tce.pad.beans.Coluna;
import br.gov.rs.tce.pad.beans.Referencia;
import br.gov.rs.tce.pad.beans.Tabela;
import br.gov.rs.tce.pad.excecao.PersistenciaException;
import br.gov.rs.tce.pad.modelo.importacao.RepositorioArquivosControle;
import br.gov.rs.tce.pad.util.DatabaseHelper;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.dbutils.DbUtils;
import org.apache.commons.dbutils.QueryRunner;
import org.apache.commons.dbutils.ResultSetHandler;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class BaseRepositorioArquivosControle
implements RepositorioArquivosControle {
    protected QueryRunner _queryRunner;
    final int TAMANHO_BLOCO_COMMIT = 500;
    protected int _contadorInsert = 0;
    protected Connection _conexao;
    protected TipoBancoDados _tipoBanco = TipoBancoDados.DERBY_DB;
    boolean valoresLengthAvisado = false;
    protected int[] _tipoDadosColunasTabela;
    protected PreparedStatement _pstmtImportacaoImportacaLinha;
    protected static final Log log = LogFactory.getLog(BaseRepositorioArquivosControle.class);
    protected static final boolean LOG_DEBUG_ENABLED = log.isDebugEnabled();

    protected abstract String montaSQLRemoveChavePrimaria(String var1);

    protected abstract String montaSQLCriacaoTabelaAuxiliar(Arquivo var1);

    protected abstract void verificaExcecaoChavePrimaria(SQLException var1, String var2);

    protected abstract void verificaExcecaoChaveEstrangeira(SQLException var1, String var2, String var3);

    @Override
    public final void inicializaRepositorioControle(Connection conexao, QueryRunner queryRunner) {
        this._conexao = conexao;
        try {
            this._tipoBanco = DatabaseHelper.recuperaTipoBancoDados(conexao);
            log.debug((Object)("inicializaRepositorioControle: user == " + this._conexao.getMetaData().getUserName()));
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        if (this._conexao == null) {
            throw new PersistenciaException("10018", new Object[0]);
        }
        this._queryRunner = queryRunner;
    }

    private void inicializaTipoDadoColunasArquivo(Arquivo arquivo) {
        if (arquivo == null) {
            throw new IllegalArgumentException("Arquivo n\u00e3o pode ser nulo.");
        }
        Campo[] campos = arquivo.getFormato().getCampo();
        Tabela tabela = arquivo.getTabela();
        if (this.verificaTipoComandoInsert(tabela)) {
            int i;
            int numCampos = 0;
            for (i = 0; i < campos.length; ++i) {
                if (campos[i].isTemporario()) continue;
                ++numCampos;
            }
            this._tipoDadosColunasTabela = new int[numCampos];
            numCampos = 0;
            for (i = 0; i < campos.length; ++i) {
                if (campos[i].isTemporario()) continue;
                this._tipoDadosColunasTabela[numCampos++] = campos[i].getTipoDadoId();
            }
        } else {
            Coluna[] colunasTabela = tabela.getColuna();
            this._tipoDadosColunasTabela = new int[colunasTabela.length];
            for (int i = 0; i < colunasTabela.length; ++i) {
                this._tipoDadosColunasTabela[i] = colunasTabela[i].getTipoDadoId();
            }
        }
    }

    private final void realizaCommitNoRepositorio() {
        try {
            this._conexao.commit();
        }
        catch (SQLException e) {
            throw new PersistenciaException("10029", new Object[]{"Realiza\u00e7\u00e3o do COMMIT com erro"}, e);
        }
    }

    @Override
    public void armazenaLinha(Object[] valores, long numeroLinha) throws PersistenciaException {
        StringBuffer buf = null;
        if (LOG_DEBUG_ENABLED) {
            buf = new StringBuffer(100);
        }
        try {
            if (this._pstmtImportacaoImportacaLinha == null) {
                throw new IllegalStateException("A classe n\u00e3o foi inicializada atrav\u00e9s do m\u00e9todo inicializaRepositorioControle(Arquivo)");
            }
            this._pstmtImportacaoImportacaLinha.setLong(1, numeroLinha);
            block15: for (int i = 0; i < valores.length; ++i) {
                if (LOG_DEBUG_ENABLED) {
                    buf.append(valores[i]);
                    if (i + 1 < valores.length) {
                        buf.append(", ");
                    }
                }
                if (i >= this._tipoDadosColunasTabela.length) {
                    if (this.valoresLengthAvisado) continue;
                    log.warn((Object)("   valor [#" + i + "] n\u00e3o possui coluna correspondente"));
                    this.valoresLengthAvisado = true;
                    continue;
                }
                switch (this._tipoDadosColunasTabela[i]) {
                    case 5: {
                        this._pstmtImportacaoImportacaLinha.setDate(i + 2, (Date)valores[i]);
                        continue block15;
                    }
                    case 4: {
                        this._pstmtImportacaoImportacaLinha.setLong(i + 2, ((Number)valores[i]).longValue());
                        continue block15;
                    }
                    case 3: {
                        this._pstmtImportacaoImportacaLinha.setInt(i + 2, ((Number)valores[i]).intValue());
                        continue block15;
                    }
                    case 2: {
                        this._pstmtImportacaoImportacaLinha.setBigDecimal(i + 2, (BigDecimal)valores[i]);
                        continue block15;
                    }
                    case 1: 
                    case 6: {
                        this._pstmtImportacaoImportacaLinha.setString(i + 2, (String)valores[i]);
                        continue block15;
                    }
                    default: {
                        throw new IllegalArgumentException("O tipo de dado " + Campo.getTipoDado(this._tipoDadosColunasTabela[i]) + " n\u00e3o possui \num tipo de dados SQL correspondente mapeado. (Valor interno: " + valores[i].getClass().toString() + ")");
                    }
                }
            }
            try {
                this._pstmtImportacaoImportacaLinha.execute();
            }
            catch (SQLException e) {
                log.info((Object)("## ERRO 'execute()'[1] [SQLException] >>>>> \n" + e.getMessage() + "\n  valores = " + Arrays.asList(valores) + "\n  _tipoDadosColunasTabela = " + Arrays.asList(new int[][]{this._tipoDadosColunasTabela})));
                throw e;
            }
            catch (RuntimeException e) {
                log.info((Object)("## ERRO 'execute()'[2] [" + e.getClass().getSimpleName() + "] >>>>> \n" + e.getMessage() + "\n  valores = " + Arrays.asList(valores) + "\n  _tipoDadosColunasTabela = " + Arrays.asList(new int[][]{this._tipoDadosColunasTabela})));
                throw e;
            }
            ++this._contadorInsert;
            if (this._contadorInsert >= 500) {
                this.realizaCommitNoRepositorio();
                this._contadorInsert = 0;
            }
        }
        catch (SQLException e) {
            log.error((Object)("Valores => " + buf));
            log.error((Object)e);
            throw new PersistenciaException("10010", new Object[]{numeroLinha, buf}, e);
        }
        catch (ClassCastException cce) {
            throw new PersistenciaException("10022", new Object[]{"Verifique o tipo de dado da coluna no banco com o tipo de dado da coluna no arquivos.xml: " + cce.getMessage()}, cce);
        }
    }

    @Override
    public final List<ValoresFK> criaChaveEstrangeira(String tabelaOrigem, Referencia referencia) {
        boolean criacaoOk = false;
        long iniTime = System.currentTimeMillis();
        String ddl = BaseRepositorioArquivosControle.montaSQLCriacaoChaveEstrangeira(tabelaOrigem, referencia);
        try {
            this.executaDDL(ddl);
            criacaoOk = true;
        }
        catch (PersistenciaException e) {
            log.info((Object)("Erro FK: " + ddl));
            this.verificaExcecaoChaveEstrangeira((SQLException)e.getCause(), tabelaOrigem, referencia.getTabelaDestino());
            criacaoOk = false;
        }
        List<ValoresFK> retorno = Collections.emptyList();
        if (!criacaoOk) {
            try {
                retorno = this.verificaErrosCriacaoChaveEstrangeira(tabelaOrigem, referencia);
            }
            catch (SQLException e) {
                throw new PersistenciaException("10014", new Object[]{tabelaOrigem, referencia.getTabelaDestino()});
            }
        }
        long endTime = System.currentTimeMillis();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Tempo cria\u00e7\u00e3o FK - " + referencia + ": " + (endTime - iniTime) + " ms."));
        }
        return retorno;
    }

    @Override
    public List<ValoresPK> criaChavePrimaria(String nomeTabela, String[] colunas, String[] colunasMensagem, boolean tabelaNormalizada) {
        boolean criacaoOk = false;
        long iniTime = System.currentTimeMillis();
        try {
            this.executaDDL(this.montaSQLCriacaoChavePrimaria(colunas, nomeTabela));
            criacaoOk = true;
        }
        catch (PersistenciaException e) {
            this.verificaExcecaoChavePrimaria((SQLException)e.getCause(), nomeTabela);
            criacaoOk = false;
        }
        List<ValoresPK> retorno = Collections.emptyList();
        if (!criacaoOk) {
            try {
                if (colunasMensagem == null) {
                    if (tabelaNormalizada) {
                        throw new IllegalArgumentException("Para uma tabela normalizada \u00e9 obrigat\u00f3rio o preenchimento do atributo \"colunas-mensagem-chave-primaria\" no arquivo de configura\u00e7\u00e3o \"arquivos.xml\" para a tabela.");
                    }
                    retorno = this.verificaErrosCriacaoChavePrimaria(colunas, null, nomeTabela);
                } else {
                    retorno = tabelaNormalizada ? this.verificaErrosCriacaoChavePrimaria(colunas, colunasMensagem, nomeTabela) : this.verificaErrosCriacaoChavePrimaria(colunasMensagem, null, nomeTabela);
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
                throw new PersistenciaException("10013", new Object[]{nomeTabela});
            }
        }
        long endTime = System.currentTimeMillis();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Tempo cria\u00e7\u00e3o PK - (" + nomeTabela + "): " + (endTime - iniTime) + " ms."));
        }
        return retorno;
    }

    @Override
    public abstract void criaTabelaAuxiliar(Arquivo var1);

    @Override
    public void processamentoAposCargaArquivo() throws PersistenciaException {
        try {
            if (this._pstmtImportacaoImportacaLinha != null) {
                this._pstmtImportacaoImportacaLinha.close();
            }
        }
        catch (SQLException e) {
            throw new PersistenciaException("10029", new Object[]{e.getMessage()}, e);
        }
    }

    protected String createInsertSQL(Arquivo arquivo) {
        int i;
        String[] colunas = this.getColunasInsert(arquivo);
        StringBuffer sql = new StringBuffer(40);
        sql.append(" INSERT INTO ").append(arquivo.getTabela().getNome()).append(" ( NR_LINHA, ");
        for (i = 0; i < colunas.length; ++i) {
            sql.append(colunas[i]);
            if (i + 1 >= colunas.length) continue;
            sql.append(", ");
        }
        sql.append(" ) VALUES ( ?, ");
        for (i = 0; i < colunas.length; ++i) {
            sql.append("?");
            if (i + 1 >= colunas.length) continue;
            sql.append(", ");
        }
        sql.append(" )");
        if (log.isDebugEnabled()) {
            log.debug((Object)("SQL INSERT: " + sql.toString()));
        }
        return sql.toString();
    }

    protected final String[] getColunasInsert(Arquivo arquivo) {
        Tabela tabela = arquivo.getTabela();
        StringBuffer stringColunas = new StringBuffer(40);
        String[] colunas = null;
        if (this.verificaTipoComandoInsert(tabela)) {
            Campo[] camposArquivo = arquivo.getFormato().getCampo();
            for (int i = 0; i < camposArquivo.length; ++i) {
                if (camposArquivo[i].isTemporario()) continue;
                stringColunas.append(camposArquivo[i].getColuna()).append("#");
            }
            colunas = stringColunas.toString().split("#");
        } else {
            Coluna[] colunasTabela = tabela.getColuna();
            colunas = new String[colunasTabela.length];
            for (int i = 0; i < colunasTabela.length; ++i) {
                colunas[i] = colunasTabela[i].getNome();
            }
        }
        return colunas;
    }

    public static synchronized String montaSQLCriacaoChaveEstrangeira(String tabelaOrigem, Referencia referencia) {
        int i;
        String nomeFK = null;
        String[] colunasOrigem = referencia.getColunasOrigem();
        String[] colunasDestino = referencia.getColunasDestino();
        nomeFK = BaseRepositorioArquivosControle.criaNomeFK(tabelaOrigem, referencia.getTabelaDestino());
        StringBuffer sql = new StringBuffer(40);
        sql.append("ALTER TABLE ").append(tabelaOrigem);
        sql.append(" ADD CONSTRAINT ").append(nomeFK).append(" FOREIGN KEY ( ");
        for (i = 0; i < colunasOrigem.length; ++i) {
            sql.append(colunasOrigem[i]);
            if (i + 1 >= colunasOrigem.length) continue;
            sql.append(", ");
        }
        sql.append(" ) REFERENCES ").append(referencia.getTabelaDestino()).append("( ");
        for (i = 0; i < colunasDestino.length; ++i) {
            sql.append(colunasDestino[i]);
            if (i + 1 >= colunasDestino.length) continue;
            sql.append(", ");
        }
        sql.append(" )");
        if (log.isDebugEnabled()) {
            log.debug((Object)("SQL cria\u00e7\u00e3o FK: " + sql.toString()));
        }
        return sql.toString();
    }

    public static synchronized String criaNomeFK(String tabelaOrigem, String tabelaDestino) {
        HashMap<String, Integer> nomesFK = new HashMap<String, Integer>();
        StringBuffer nomeFK = new StringBuffer("FK_");
        if (tabelaOrigem.length() > 7) {
            nomeFK.append(BaseRepositorioArquivosControle.criaNomeTabelaReduzido(tabelaOrigem));
        } else {
            nomeFK.append(tabelaOrigem);
        }
        nomeFK.append("_");
        if (tabelaDestino.length() > 6) {
            nomeFK.append(BaseRepositorioArquivosControle.criaNomeTabelaReduzido(tabelaDestino));
        } else {
            nomeFK.append(tabelaDestino);
        }
        Integer numero = (Integer)nomesFK.get(nomeFK.append("1").toString());
        if (numero != null) {
            nomeFK.deleteCharAt(nomeFK.length() - 1).append(numero + 1);
        } else {
            numero = 1;
        }
        nomesFK.put(nomeFK.toString(), numero);
        return nomeFK.toString();
    }

    private static synchronized String criaNomeTabelaReduzido(String nomeTabela) {
        StringBuffer nomeReduzido = new StringBuffer(nomeTabela.length());
        String[] nomes = nomeTabela.split("_");
        int parte = nomeTabela.length() / nomes.length;
        for (int i = 0; i < nomes.length; ++i) {
            StringBuffer subParte = new StringBuffer(nomes[i].substring(0, parte > nomes[i].length() ? nomes[i].length() : parte));
            while (subParte.length() > 6 / nomes.length) {
                subParte.deleteCharAt(subParte.length() / 2);
            }
            nomeReduzido.append(subParte);
        }
        return nomeReduzido.toString();
    }

    private String montaSQLCriacaoChavePrimaria(String[] colunas, String nomeTabela) {
        StringBuffer sql = new StringBuffer(60);
        sql.append("ALTER TABLE ").append(nomeTabela);
        sql.append(" ADD CONSTRAINT PK_");
        sql.append(BaseRepositorioArquivosControle.criaNomeTabelaReduzido(nomeTabela));
        sql.append(" PRIMARY KEY ( ");
        for (int i = 0; i < colunas.length; ++i) {
            sql.append(colunas[i]);
            if (i + 1 >= colunas.length) continue;
            sql.append(", ");
        }
        sql.append(" )");
        if (log.isDebugEnabled()) {
            log.debug((Object)("SQL PK: " + sql.toString()));
        }
        return sql.toString();
    }

    private List<ValoresFK> verificaErrosCriacaoChaveEstrangeira(String tabelaOrigem, Referencia referencia) throws SQLException {
        int i;
        final LinkedList<ValoresFK> retorno = new LinkedList<ValoresFK>();
        final String[] colunasOrigem = referencia.getColunasOrigem();
        String[] colunasDestino = referencia.getColunasDestino();
        StringBuffer sql = new StringBuffer("SELECT DISTINCT nr_linha, ");
        for (i = 0; i < colunasOrigem.length; ++i) {
            sql.append(colunasOrigem[i]);
            if (i + 1 >= colunasOrigem.length) continue;
            sql.append(", ");
        }
        sql.append(" FROM " + tabelaOrigem + " WHERE NOT EXISTS ");
        sql.append("(SELECT * ");
        sql.append(" FROM " + referencia.getTabelaDestino() + " WHERE ");
        for (i = 0; i < colunasDestino.length; ++i) {
            sql.append(tabelaOrigem + "." + colunasOrigem[i] + " = " + referencia.getTabelaDestino() + "." + colunasDestino[i]);
            if (i + 1 >= colunasDestino.length) continue;
            sql.append(" AND ");
        }
        sql.append(") ORDER BY nr_linha ");
        if (log.isDebugEnabled()) {
            log.debug((Object)("SQL verifica FK: \n" + sql.toString() + "\n"));
        }
        ResultSetHandler handler = new ResultSetHandler(){

            public Object handle(ResultSet rs) throws SQLException {
                while (rs.next()) {
                    Object[] colunasPK = new Object[colunasOrigem.length];
                    for (int index = 0; index < colunasPK.length; ++index) {
                        colunasPK[index] = rs.getObject(index + 2);
                    }
                    retorno.add(new ValoresFK(rs.getLong(1), colunasPK));
                }
                return null;
            }
        };
        this._queryRunner.query(this._conexao, sql.toString(), new Object[0], handler);
        return retorno;
    }

    public List<ValoresPK> verificaErrosCriacaoChavePrimaria(String[] colunas, String[] colunasMensagem, String nomeTabela) throws SQLException {
        int i;
        final LinkedList<ValoresPK> retorno = new LinkedList<ValoresPK>();
        StringBuffer sql = new StringBuffer();
        StringBuffer columns = new StringBuffer();
        if (colunasMensagem == null) {
            colunasMensagem = colunas;
        }
        final String[] colunasMensagemNew = colunasMensagem;
        for (i = 0; i < colunas.length; ++i) {
            columns.append(this.retornaColuna(colunas[i]));
            if (i + 1 >= colunas.length) continue;
            columns.append(", ");
        }
        sql.append("SELECT DISTINCT A.NR_LINHA, ");
        for (i = 0; i < colunasMensagem.length; ++i) {
            sql.append(this.parseColuna(colunasMensagem[i]));
            if (i + 1 >= colunasMensagem.length) continue;
            sql.append(", ");
        }
        sql.append(" FROM " + nomeTabela + " A, ( SELECT DISTINCT COUNT(*), " + columns);
        sql.append(" FROM " + nomeTabela + " GROUP BY " + columns);
        sql.append(" HAVING COUNT(*) > 1 ) B WHERE ");
        for (i = 0; i < colunasMensagem.length; ++i) {
            sql.append("A." + this.retornaColuna(colunasMensagem[i]) + " = B." + this.retornaColuna(colunasMensagem[i]));
            if (i + 1 >= colunasMensagem.length) continue;
            sql.append(" AND ");
        }
        sql.append(" AND A.NR_LINHA IN (SELECT NR_LINHA  FROM aux_linhas)");
        if (log.isDebugEnabled()) {
            log.debug((Object)("Erros chave primaria => " + sql));
        }
        log.info((Object)("Erros chave primaria => " + sql));
        ResultSetHandler handler = new ResultSetHandler(){

            public Object handle(ResultSet rs) throws SQLException {
                while (rs.next()) {
                    Object[] colunasPK = new Object[colunasMensagemNew.length];
                    for (int index = 0; index < colunasPK.length; ++index) {
                        colunasPK[index] = rs.getObject(index + 2);
                    }
                    retorno.add(new ValoresPK(rs.getLong(1), colunasPK));
                }
                return null;
            }
        };
        this.populaTabelaAuxiliarLinhas("(SELECT MIN(NR_LINHA)  FROM " + nomeTabela + " GROUP BY " + columns + " HAVING COUNT(*) > 1)");
        this._queryRunner.query(this._conexao, sql.toString(), new Object[0], handler);
        return retorno;
    }

    public void populaTabelaAuxiliarLinhas(String sql) throws SQLException {
        this._queryRunner.update(this._conexao, "Delete from aux_linhas");
        this._queryRunner.update(this._conexao, "insert into aux_linhas " + sql);
    }

    public String parseColuna(String column) {
        StringBuffer newColumn = new StringBuffer();
        StringBuffer lpad = new StringBuffer();
        column = column.replaceAll(";", ",");
        newColumn.append("A.");
        if (column.charAt(0) == 'L' && column.charAt(1) == 'P' && column.charAt(2) == 'A' && column.charAt(3) == 'D') {
            if (this._tipoBanco == TipoBancoDados.DERBY_DB) {
                lpad.append("LPAD(RTRIM(CHAR(");
                column = column.replaceAll(" ", "");
                int posicaoFim = column.indexOf(",");
                int posicaoIni = column.indexOf("(");
                int local = posicaoFim - posicaoIni - 1;
                for (int index = 0; index < local; ++index) {
                    newColumn.append(column.charAt(index + 5));
                }
                lpad.append(newColumn + "," + (column.length() - posicaoFim - 4) + "))");
                lpad.append(column.substring(posicaoFim));
            } else {
                lpad.append("LPAD(RTRIM(");
                column = column.replaceAll(" ", "");
                int posicaoFim = column.indexOf(",");
                int posicaoIni = column.indexOf("(");
                int local = posicaoFim - posicaoIni - 1;
                for (int index = 0; index < local; ++index) {
                    newColumn.append(column.charAt(index + 5));
                }
                lpad.append(newColumn);
                newColumn = new StringBuffer(column.substring(posicaoFim));
                if (newColumn.indexOf("'") != -1) {
                    String ncolumn = newColumn.substring(newColumn.indexOf("'") + 1).toString();
                    System.out.println("coluna == " + column + " substring == " + ncolumn);
                    if (ncolumn.indexOf("'") != -1) {
                        ncolumn = ncolumn.substring(0, ncolumn.indexOf("'") - 1);
                    }
                    lpad.append(")," + ncolumn.length());
                }
                lpad.append(column.substring(posicaoFim));
            }
        } else {
            lpad.append("A." + column);
        }
        return lpad.toString();
    }

    public String retornaColuna(String column) {
        StringBuffer newColumn = new StringBuffer();
        if ((column = column.replaceAll(";", ",")).charAt(0) == 'L' && column.charAt(1) == 'P' && column.charAt(2) == 'A' && column.charAt(3) == 'D') {
            column = column.replaceAll(" ", "");
            int posicaoFim = column.indexOf(",");
            int posicaoIni = column.indexOf("(");
            int local = posicaoFim - posicaoIni - 1;
            for (int index = 0; index < local; ++index) {
                newColumn.append(column.charAt(index + 5));
            }
        } else {
            newColumn.append(column);
        }
        return newColumn.toString();
    }

    protected void executaDDL(String ddlSQL) {
        Statement stmt = null;
        try {
            stmt = this._conexao.createStatement();
            stmt.execute(ddlSQL);
        }
        catch (SQLException ex) {
            log.debug((Object)("ERRO SQL: " + ddlSQL));
            throw new PersistenciaException(ex);
        }
        finally {
            try {
                DbUtils.close((Statement)stmt);
            }
            catch (Exception e) {
                throw new PersistenciaException(e);
            }
        }
    }

    private boolean verificaTipoComandoInsert(Tabela tabela) {
        return tabela.getColunaCount() == 0;
    }

    @Override
    public void inicializaTabelaRepositorio(Arquivo arquivo) throws PersistenciaException {
        Tabela tabela = arquivo.getTabela();
        this.inicializaTipoDadoColunasArquivo(arquivo);
        if (tabela.getTabelaAuxiliar() != null) {
            this.removeTabela(tabela.getTabelaAuxiliar());
        }
        this.removeChavePrimaria(tabela.getNome());
        this.limpaTabela(tabela.getNome());
        String sql = null;
        try {
            sql = this.createInsertSQL(arquivo);
            this._pstmtImportacaoImportacaLinha = this._conexao.prepareStatement(sql);
            log.debug((Object)("sql: " + sql));
        }
        catch (SQLException e) {
            log.warn((Object)("erro:: sql: " + sql));
            throw new PersistenciaException("10031", new Object[]{e.getMessage(), "SQL:" + sql}, e);
        }
    }

    public void limpaTabelaArquivo(Arquivo arquivo) {
        Tabela tabela = arquivo.getTabela();
        if (tabela == null) {
            return;
        }
        if (tabela.getTabelaAuxiliar() != null) {
            this.removeTabela(tabela.getTabelaAuxiliar());
        }
        this.removeChavePrimaria(tabela.getNome());
        this.limpaTabela(tabela.getNome());
    }

    @Override
    public void finalizaRespositorioControle() throws PersistenciaException {
        try {
            if (this._pstmtImportacaoImportacaLinha != null) {
                this._pstmtImportacaoImportacaLinha.close();
            }
        }
        catch (SQLException e) {
            throw new PersistenciaException("10029", new Object[]{e.getMessage()}, e);
        }
    }

    @Override
    public void inicializaArquivo(Arquivo arquivo) {
        this.valoresLengthAvisado = false;
    }

    class ValoresPK {
        private Long _numeroLinha;
        private Object[] _colunas;

        private ValoresPK(long linha, Object[] col) {
            this._numeroLinha = linha;
            this._colunas = col;
        }

        public Long getNumeroLinha() {
            return this._numeroLinha;
        }

        public Object[] getValoresColunas() {
            return this._colunas;
        }
    }

    class ValoresFK {
        private Long _numeroLinha;
        private Object[] _colunas;

        private ValoresFK(long linha, Object[] col) {
            this._numeroLinha = linha;
            this._colunas = col;
        }

        public Long getNumeroLinha() {
            return this._numeroLinha;
        }

        public Object[] getValoresColunas() {
            return this._colunas;
        }
    }
}

