/*
 * Decompiled with CFR 0.152.
 */
package br.gov.rs.tce.pad.modelo.action.quadros;

import br.gov.rs.tce.modelo.beans.TipoBancoDados;
import br.gov.rs.tce.pad.beans.ConsultaSQL;
import br.gov.rs.tce.pad.beans.ContasRemessaBean;
import br.gov.rs.tce.pad.beans.QuadroContas;
import br.gov.rs.tce.pad.beans.remessa.Remessa;
import br.gov.rs.tce.pad.beans.types.IdentificadorConta;
import br.gov.rs.tce.pad.excecao.PersistenciaException;
import br.gov.rs.tce.pad.modelo.action.ActionModeloListener;
import br.gov.rs.tce.pad.modelo.action.quadros.ActionCarregaDadosQuadro;
import br.gov.rs.tce.pad.modelo.servico.common.ContasModule;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import oracle.jbo.JboException;
import oracle.jbo.Row;
import oracle.jbo.ViewObject;

public class ActionCarregaQuadroTelaUC085
extends ActionCarregaDadosQuadro {
    private static final String CARREGA_CONTAS_VO = "CarregaContasVO";
    private static final String CARREGA_CONTAS = "select cd_conta as CdConta, ds_conta as DsContas, periodos as Periodos, aux_chave as AuxChave from contas_uc085 where cd_tipo = ? and anobi = ?";

    @Override
    protected void insereDadosTabela(String sqlOrigemInsercao, Integer[] paramsTipoContas, Remessa remessa, Integer tipoContaQuadro, Integer cdPlanilha, IdentificadorConta identificadorConta, ContasModule contasModule, ActionModeloListener listener) {
        List<ContasRemessaBean> listaContas = null;
        listaContas = this.criaListaContasVO(remessa, contasModule, tipoContaQuadro, cdPlanilha);
        try {
            contasModule.insereContasRemessa(remessa, listaContas, identificadorConta);
            contasModule.getTransaction().commit();
        }
        catch (PersistenciaException pe) {
            contasModule.getTransaction().rollback();
            throw pe;
        }
    }

    private List<ContasRemessaBean> criaListaContasVO(Remessa remessa, ContasModule contasModule, Integer tipoContaQuadro, Integer cdPlanilha) {
        ArrayList<ContasRemessaBean> listacontas = new ArrayList<ContasRemessaBean>();
        ViewObject arrayContasVO = null;
        try {
            arrayContasVO = contasModule.createViewObjectFromQueryStmt(CARREGA_CONTAS_VO, CARREGA_CONTAS);
            arrayContasVO.setWhereClauseParam(0, (Object)tipoContaQuadro);
            arrayContasVO.setWhereClauseParam(1, (Object)contasModule.getAnoBiContasUC085());
            arrayContasVO.executeQuery();
            arrayContasVO.first();
            arrayContasVO.previous();
            Row r = null;
            while (arrayContasVO.hasNext()) {
                r = arrayContasVO.next();
                boolean considerar = true;
                if (tipoContaQuadro == 1105) {
                    considerar = false;
                    System.out.println("r.getAttribute[1105]: " + (String)r.getAttribute(2));
                    if (((String)r.getAttribute(2)).indexOf(String.valueOf(remessa.getPeriodoInformacoes())) != -1) {
                        considerar = true;
                    }
                }
                if (!considerar) continue;
                ContasRemessaBean crBean = new ContasRemessaBean();
                crBean.setConta((BigDecimal)r.getAttribute(0));
                crBean.setDescricao((String)r.getAttribute(1));
                crBean.setAutomatica("S");
                crBean.setCdPlanilha(cdPlanilha);
                crBean.setStatus("S");
                crBean.setTipo(tipoContaQuadro);
                if (((BigDecimal)r.getAttribute(3)).intValue() != 0) {
                    crBean.setMes(((BigDecimal)r.getAttribute(3)).intValue());
                }
                listacontas.add(crBean);
            }
        }
        catch (JboException e) {
            throw new PersistenciaException("10030", new Object[]{e.getMessage()}, (Exception)((Object)e));
        }
        finally {
            if (arrayContasVO != null) {
                arrayContasVO.remove();
            }
        }
        return listacontas;
    }

    @Override
    protected ConsultaSQL recuperaConsultaSQL(QuadroContas quadro, TipoBancoDados tpBanco, Remessa remessa) {
        return null;
    }
}

