/*
 * Decompiled with CFR 0.152.
 */
package br.gov.rs.tce.pad.modelo;

import br.gov.rs.tce.pad.excecao.ConfiguracaoException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.exolab.castor.mapping.Mapping;
import org.exolab.castor.xml.Unmarshaller;
import org.xml.sax.InputSource;

public class ConfiguracaoControle {
    public static final String MENSAGENS_MAPPING_CONF = "mensagens";
    public static final String ARQUIVOS_FLUXO_COMPLEMENTARES_MAPPING_CONF = "arquivos-complementares";
    public static final String ARQUIVOS_FLUXO_COMP_CAMARA_INTEG_MAPPING_CONF = "arquivos-comp-camara-integ";
    public static final String ARQUIVOS_FLUXO_PRINCIPAL_MAPPING_CONF = "arquivos-principal";
    public static final String REGRAS_MAPPING_CONF = "regras";
    public static final String TELAS_MAPPING_CONF = "telas";
    public static final String EXTRACAO_MAPPING_CONF = "extracao";
    public static final String CONSULTAS_QUADROS_MAPPING_CONF = "consultas-quadros";
    public static final String CONSULTAS_REGRAS_MAPPING_CONF = "consultas-regras";
    public static final String REMESSA_INFO = "remessa-info";
    public static final String REMESSA_INFO_MCI = "remessa-info-mci";
    public static final String BACKUP_MAPPING_CONF = "backup";
    public static final String CONFIGURACAO_MAPPING_CONF = "configuracao-versao";
    public static final String CONFIGURACAO_MAPPING_CONF_PADP = "configuracao-versao-complementar";
    protected static final Log log = LogFactory.getLog(ConfiguracaoControle.class);
    protected static Map<String, Object> cacheDefinicoes = new HashMap<String, Object>();
    private static final String[] VERSOES_LAYOUT = new String[]{"15", "17", "18", "19", "20", "21"};
    public static final String versaoArquivos = ConfiguracaoControle.carregaArquivosVersao();
    private static String[][] definicoesXML = new String[][]{{"mensagens", "mensagens.xml", "mapping-mensagens.xml"}, {"arquivos-complementares", "arquivos-complementares.xml", "mapping-arquivos.xml"}, {"arquivos-comp-camara-integ", "arquivos-comp-camara-integ.xml", "mapping-arquivos.xml"}, {"arquivos-principal", "arquivos.xml", "mapping-arquivos.xml"}, {"regras", "regras.xml", "mapping-regras.xml"}, {"telas", "config-telas.xml", "mapping-config-telas.xml"}, {"extracao", "consultas-extracao.xml", "mapping-extracao.xml"}, {"consultas-quadros", "consultas-quadros.xml", "mapping-consultas-quadros.xml"}, {"consultas-regras", "consultas-regras.xml", "mapping-consultas-quadros.xml"}, {"remessa-info", "remessa-info.xml", "mapping-remessa-info.xml"}, {"backup", "consultas-backup.xml", "mapping-backup.xml"}, {"configuracao-versao", "configuracao-versao.xml", "mapping-configuracao-versao.xml"}, {"configuracao-versao-complementar", "configuracao-versao-complementar.xml", "mapping-configuracao-versao.xml"}, {"remessa-info-mci", "remessa_info.xml", "mapping-remessa-info-mci.xml"}};
    private static final String ARQUIVOS_START = "arquivos-";
    private static final String CAMINHO_PREPREND = "xml/arquivos/v";
    private static final String CAMINHO_APPEND = "/";
    private static final String ARQUIVO_PROPERTIES = "conf/pad.properties";
    private static final String PROP_ARQUIVOS_VERSAO = "pad.arquivos-versao";

    private ConfiguracaoControle() {
    }

    public static Object carregaDadosArquivoXML(String configArquivo) {
        return ConfiguracaoControle.carregaDadosArquivoXML(configArquivo, null);
    }

    public static Object carregaDadosArquivoXML(String configArquivo, File arquivoXML) {
        return ConfiguracaoControle.carregaDadosArquivoXML(configArquivo, arquivoXML, false);
    }

    public static synchronized Object carregaDadosArquivoXML(String configArquivo, File arquivoXML, boolean reload) {
        Mapping mapping = new Mapping();
        Object conteudo = null;
        String mappingConf = null;
        String arquivoDadosXML = null;
        long iniTime = System.currentTimeMillis();
        conteudo = cacheDefinicoes.get(configArquivo);
        log.debug((Object)("1 - " + configArquivo));
        if (reload || conteudo == null) {
            for (int i = 0; i < definicoesXML.length; ++i) {
                String[] config = definicoesXML[i];
                if (!config[0].equals(configArquivo)) continue;
                arquivoDadosXML = config[1];
                mappingConf = config[2];
                log.debug((Object)("1.5 configArquivo: " + configArquivo + " ; arquivoDadosXML: " + arquivoDadosXML + " ; mappingConf: " + mappingConf));
                if (!configArquivo.startsWith(ARQUIVOS_START) || versaoArquivos == null) continue;
                log.info((Object)("-->> " + configArquivo + ": 'arquivos-versao' == " + versaoArquivos));
            }
            if (arquivoXML == null) {
                log.debug((Object)("2 era null - " + arquivoDadosXML));
                arquivoXML = new File(arquivoDadosXML);
            }
            if (configArquivo.startsWith(ARQUIVOS_START) && versaoArquivos != null) {
                arquivoXML = new File(CAMINHO_PREPREND + versaoArquivos + CAMINHO_APPEND + arquivoXML);
            }
            if (mappingConf == null || arquivoDadosXML == null) {
                throw new ConfiguracaoException("N\u00ef\u00bf\u00bdo foi possivel carregar defini\u00ef\u00bf\u00bd\u00ef\u00bf\u00bdes para o tipo de arquivo - " + configArquivo);
            }
            try {
                mapping.loadMapping(new InputSource(ConfiguracaoControle.class.getClassLoader().getResourceAsStream(mappingConf)));
                Unmarshaller unmar = new Unmarshaller(mapping);
                BufferedReader is = null;
                if (!arquivoXML.exists()) {
                    log.debug((Object)("3 usando classloader - " + arquivoDadosXML + " - " + arquivoXML + " (" + arquivoXML.getName() + ")"));
                    InputStream input = ConfiguracaoControle.class.getClassLoader().getResource(arquivoXML.toString()) != null ? ConfiguracaoControle.class.getClassLoader().getResourceAsStream(arquivoXML.toString()) : ConfiguracaoControle.class.getClassLoader().getResourceAsStream(arquivoXML.getName());
                    is = new BufferedReader(new InputStreamReader(input, "UTF-8"));
                } else {
                    log.debug((Object)("3 usando is - " + arquivoDadosXML + " - " + arquivoXML));
                    is = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(arquivoXML), "UTF-8"));
                }
                conteudo = unmar.unmarshal((Reader)is);
                log.debug((Object)("4 after unmarshall - " + arquivoDadosXML));
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Carga " + configArquivo + " efetuada em " + (System.currentTimeMillis() - iniTime) + " ms."));
                }
            }
            catch (Exception e) {
                log.warn((Object)("5 exception - " + e));
                throw new ConfiguracaoException("Carga do arquivo: " + arquivoXML, e);
            }
            cacheDefinicoes.put(configArquivo, conteudo);
        }
        log.debug((Object)("6 exit - " + conteudo));
        return conteudo;
    }

    private static String carregaArquivosVersao() {
        String versao = null;
        try {
            File file = new File(ARQUIVO_PROPERTIES);
            FileInputStream is = new FileInputStream(file);
            Properties props = new Properties();
            props.load(is);
            versao = props.getProperty(PROP_ARQUIVOS_VERSAO);
            ((InputStream)is).close();
            props.clear();
        }
        catch (Exception e) {
            log.warn((Object)("carregaArquivosVersao: " + e));
        }
        if (versao != null) {
            List<String> versoes = Arrays.asList(VERSOES_LAYOUT);
            if (!versoes.contains(versao)) {
                log.warn((Object)("carregaArquivosVersao: versao '" + versao + "' nao pertence a VERSOES_LAYOUT: " + versoes));
                return null;
            }
            log.info((Object)("carregaArquivosVersao: versao=" + versao));
        }
        return versao;
    }
}

