/*
 * Decompiled with CFR 0.152.
 */
package br.gov.rs.tce.pad.beans;

import br.gov.rs.tce.pad.beans.Formato;
import br.gov.rs.tce.pad.beans.IdentificadorArquivo;
import br.gov.rs.tce.pad.beans.RegrasAssociadas;
import br.gov.rs.tce.pad.beans.Tabela;
import br.gov.rs.tce.pad.beans.types.ArquivoContabil;
import java.io.Serializable;

public final class Arquivo
implements Serializable {
    private IdentificadorArquivo _identificador;
    private String _nome;
    private ArquivoContabil _arquivoContabil;
    private int _tamanhoLinha;
    private boolean _has_tamanhoLinha;
    private boolean _has_arquivoVazioCodigoMensagem;
    private String _controleImportacaoClass;
    private Formato _formato;
    private Tabela _tabela;
    private String _lei;
    private String _entidades;
    private String _periodos;
    private String _meses;
    private String _operacoes;
    private int _tamanhoLinhaMinimo;
    private String _grupoComplementar;
    private boolean _criaChavePrimaria = true;
    private boolean _criaChaveEstrangeira = true;
    private RegrasAssociadas _regrasAssociadas;
    private String _arquivoVazioCodigoMensagem;
    private String _depende;
    private IdentificadorArquivo[] _dependencias = new IdentificadorArquivo[0];

    public boolean equals(Object obj) {
        boolean equal = false;
        if (obj != null && obj instanceof Arquivo && ((Arquivo)obj).getNome() != null) {
            equal = ((Arquivo)obj).getNome().equals(this.getNome());
        }
        return equal;
    }

    public int hashCode() {
        return this._nome != null ? this._nome.hashCode() : super.hashCode();
    }

    public void deleteTamanhoLinha() {
        this._has_tamanhoLinha = false;
    }

    public void deleteArquivoVazioCodigoMensagem() {
        this._has_arquivoVazioCodigoMensagem = false;
    }

    public String getControleImportacaoClass() {
        return this._controleImportacaoClass;
    }

    public Formato getFormato() {
        return this._formato;
    }

    public String getNome() {
        return this._nome;
    }

    public String getNomeCompleto() {
        if (this._arquivoContabil == null) {
            return null;
        }
        return this._arquivoContabil.toString();
    }

    public int getArquivoContabilType() {
        return this._arquivoContabil.getType();
    }

    public RegrasAssociadas getRegrasAssociadas() {
        return this._regrasAssociadas;
    }

    public Tabela getTabela() {
        return this._tabela;
    }

    public int getTamanhoLinha() {
        return this._tamanhoLinha;
    }

    public boolean hasTamanhoLinha() {
        return this._has_tamanhoLinha;
    }

    public boolean hasArquivoVazioCodigoMensagem() {
        return this._has_arquivoVazioCodigoMensagem;
    }

    public void setControleImportacaoClass(String controleImportacaoClass) {
        this._controleImportacaoClass = controleImportacaoClass;
    }

    public void setFormato(Formato formato) {
        this._formato = formato;
    }

    public void setNome(String nome) {
        this._nome = nome;
    }

    public void setNomeCompleto(String nomeCompleto) {
        this._arquivoContabil = ArquivoContabil.valueOf(nomeCompleto);
    }

    public void setRegrasAssociadas(RegrasAssociadas regrasAssociadas) {
        this._regrasAssociadas = regrasAssociadas;
    }

    public void setTabela(Tabela tabela) {
        this._tabela = tabela;
    }

    public void setTamanhoLinha(int tamanhoLinha) {
        this._tamanhoLinha = tamanhoLinha;
        this._has_tamanhoLinha = true;
    }

    public void setLei(String lei) {
        this._lei = lei;
    }

    public String getLei() {
        return this._lei;
    }

    public void setArquivoVazioCodigoMensagem(String arquivoVazioCodigoMensagem) {
        this._arquivoVazioCodigoMensagem = arquivoVazioCodigoMensagem;
        this._has_arquivoVazioCodigoMensagem = true;
    }

    public String getArquivoVazioCodigoMensagem() {
        return this._arquivoVazioCodigoMensagem;
    }

    public void setDepende(String depende) {
        this._depende = depende;
        String[] nomesArquivo = this._depende.split(",");
        this._dependencias = new IdentificadorArquivo[nomesArquivo.length];
        for (int i = 0; i < nomesArquivo.length; ++i) {
            this._dependencias[i] = Arquivo.criaIdenficadorArquivo(nomesArquivo[i].trim());
        }
    }

    public String getDepende() {
        return this._depende;
    }

    public IdentificadorArquivo[] getDependencias() {
        return this._dependencias;
    }

    public void setIdentificador(String identificador) {
        this._identificador = Arquivo.criaIdenficadorArquivo(identificador);
    }

    public String getIdentificadorNome() {
        return this._identificador.toString();
    }

    public IdentificadorArquivo getIdentificador() {
        return this._identificador;
    }

    public static IdentificadorArquivo criaIdenficadorArquivo(String identificador) {
        return new IdentificadorArquivo(identificador);
    }

    public void setEntidades(String entidades) {
        this._entidades = entidades;
    }

    public String getEntidades() {
        return this._entidades;
    }

    public void setPeriodos(String periodos) {
        this._periodos = periodos;
    }

    public String getPeriodos() {
        return this._periodos;
    }

    public void setOperacoes(String operacoes) {
        this._operacoes = operacoes;
    }

    public String getOperacoes() {
        return this._operacoes;
    }

    public boolean isOperacaoValida(Integer operacao) {
        boolean operacaoOk = false;
        if (this._operacoes == null || this._operacoes.equals("")) {
            operacaoOk = true;
        } else {
            String[] operacoes = this._operacoes.split(",");
            for (int i = 0; i < operacoes.length; ++i) {
                if (!Integer.valueOf(operacoes[i]).equals(operacao)) continue;
                operacaoOk = true;
                break;
            }
        }
        return operacaoOk;
    }

    public boolean isPeriodoValido(String periodo) {
        boolean periodoOk = false;
        if (this._periodos == null || this._periodos.equals("")) {
            periodoOk = true;
        } else {
            String[] periodos = this._periodos.split(",");
            for (int i = 0; i < periodos.length; ++i) {
                if (!periodos[i].trim().equals(periodo)) continue;
                periodoOk = true;
                break;
            }
        }
        return periodoOk;
    }

    public boolean isEntidadeValida(String entidade) {
        boolean entidadeOk = false;
        if (this._entidades == null || this._entidades.equals("")) {
            entidadeOk = true;
        } else {
            String[] entidades = this._entidades.split(",");
            for (int i = 0; i < entidades.length; ++i) {
                if (!entidades[i].trim().equals(entidade)) continue;
                entidadeOk = true;
                break;
            }
        }
        return entidadeOk;
    }

    public boolean isPossuiTabelaAuxiliar() {
        return this._tabela != null && this._tabela.getTabelaAuxiliar() != null && this._tabela.getTabelaAuxiliar().length() > 3;
    }

    public boolean isPossuiChavePrimaria() {
        return this._criaChavePrimaria && this._tabela != null && this._tabela.getChavePrimaria() != null && this._tabela.getChavePrimaria().length > 0;
    }

    public boolean isPossuiChaveEstrangeira() {
        return this._criaChaveEstrangeira && this._tabela != null && this._tabela.getReferencia() != null && this._tabela.getReferencia().length > 0;
    }

    public void setCriaChavePrimaria(boolean criaChavePrimaria) {
        this._criaChavePrimaria = criaChavePrimaria;
    }

    public void setCriaChaveEstrangeira(boolean criaChaveEstrangeira) {
        this._criaChaveEstrangeira = criaChaveEstrangeira;
    }

    public void setArquivoContabil(ArquivoContabil arquivoContabil) {
        this._arquivoContabil = arquivoContabil;
    }

    public ArquivoContabil getArquivoContabil() {
        return this._arquivoContabil;
    }

    public String getMeses() {
        return this._meses;
    }

    public void setMeses(String meses) {
        this._meses = meses;
    }

    boolean isMesValido(String mes) {
        if (this._meses == null || this._meses.equals("")) {
            return true;
        }
        String[] meses = this._meses.split(",");
        for (int i = 0; i < meses.length; ++i) {
            if (!meses[i].trim().equals(mes)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return this.getIdentificadorNome();
    }

    public int getTamanhoLinhaMinimo() {
        return this._tamanhoLinhaMinimo;
    }

    public void setTamanhoLinhaMinimo(int tamanhoLinhaMinimo) {
        this._tamanhoLinhaMinimo = tamanhoLinhaMinimo;
    }

    public String getGrupoComplementar() {
        return this._grupoComplementar;
    }

    public void setGrupoComplementar(String grupoComplementar) {
        this._grupoComplementar = grupoComplementar;
    }
}

