/*
 * Decompiled with CFR 0.152.
 */
package br.gov.rs.tce.ldap;

import br.gov.rs.tce.ldap.ManipulaLdap;
import br.gov.rs.tce.ldap.UserAttributes;
import br.gov.rs.tce.ldap.exception.LdapException;
import javax.security.cert.CertificateEncodingException;
import javax.security.cert.CertificateException;
import javax.security.cert.X509Certificate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ManipulaUsuarioLdap
extends ManipulaLdap {
    private static Log LOG = LogFactory.getLog(ManipulaUsuarioLdap.class.getClass());
    private String userDN;

    public ManipulaUsuarioLdap() {
    }

    public ManipulaUsuarioLdap(String userDN) {
        this.userDN = userDN;
    }

    public ManipulaUsuarioLdap(String adminPassword, String adminUsername) {
        super(adminPassword, adminUsername);
    }

    public ManipulaUsuarioLdap(String userDN, String adminPassword, String adminUsername) {
        super(adminPassword, adminUsername);
        this.userDN = userDN;
    }

    public X509Certificate getPublicCertificate() throws LdapException {
        Object array = this.getPublicAttribute(this.userDN, UserAttributes.USER_CERTIFICATE);
        try {
            if (array != null) {
                return X509Certificate.getInstance((byte[])array);
            }
        }
        catch (CertificateException e) {
            LOG.warn((Object)("Erro ao obter o certificado do userDN '" + this.userDN + "'"), (Throwable)e);
            throw new LdapException("Erro ao obter o certificado do userDN '" + this.userDN + "'", e);
        }
        return null;
    }

    public X509Certificate getPublicCertificate(String userDN) throws LdapException {
        Object array = this.getPublicAttribute(userDN, UserAttributes.USER_CERTIFICATE);
        try {
            if (array != null) {
                return X509Certificate.getInstance((byte[])array);
            }
        }
        catch (CertificateException e) {
            LOG.warn((Object)("Erro ao obter o certificado do userDN '" + userDN + "'"), (Throwable)e);
            throw new LdapException("Erro ao obter o certificado do userDN '" + userDN + "'", e);
        }
        return null;
    }

    public X509Certificate getPublicCertificate(String userDN, String username, String password) throws LdapException {
        Object array = this.getPublicAttribute(userDN, UserAttributes.USER_CERTIFICATE, username, password);
        try {
            if (array != null) {
                return X509Certificate.getInstance((byte[])array);
            }
        }
        catch (CertificateException e) {
            LOG.warn((Object)("Erro ao obter o certificado do userDN '" + userDN + "'"), (Throwable)e);
            throw new LdapException("Erro ao obter o certificado do userDN '" + userDN + "'", e);
        }
        return null;
    }

    public boolean setPublicCertificate(String userDN, X509Certificate certificate, String username, String password) throws LdapException {
        try {
            return this.setPublicAttribute(userDN, UserAttributes.USER_CERTIFICATE, certificate.getEncoded(), username, password);
        }
        catch (CertificateEncodingException e) {
            LOG.warn((Object)"Erro ao converter o certificado para gravar no OID", (Throwable)e);
            throw new LdapException("Erro ao converter o certificado para gravar no OID", e);
        }
    }

    public String getUserPassword(String userDN, String username, String password) throws LdapException {
        try {
            return (String)this.getPublicAttribute(userDN, UserAttributes.USER_PASSWORD, username, password);
        }
        catch (LdapException e) {
            LOG.warn((Object)"Erro ao obter a senha do userDN no OID", (Throwable)e);
            throw new LdapException("Erro ao obter a senha do userDN no OID", e);
        }
    }

    public void setUserPassword(String userDN, String userPassword, String usernameLogin, String passwordLogin) throws LdapException {
        try {
            this.setPublicAttribute(userDN, UserAttributes.USER_PASSWORD, userPassword, usernameLogin, passwordLogin);
        }
        catch (LdapException e) {
            LOG.warn((Object)"Erro ao obter a senha do userDN no OID", (Throwable)e);
            throw new LdapException("Erro ao obter a senha do userDN no OID", e);
        }
    }

    public byte[] getPublicCertificateBytes(String userDN, String username, String password) throws LdapException {
        return (byte[])this.getPublicAttribute(userDN, UserAttributes.USER_CERTIFICATE, username, password);
    }

    public boolean setPublicCertificateBytes(String userDN, byte[] certificate, String username, String password) throws LdapException {
        return this.setPublicAttribute(userDN, UserAttributes.USER_CERTIFICATE, certificate, username, password);
    }

    public String getPrivateCertificateString(String userDN, String username, String password) throws LdapException {
        return (String)this.getPublicAttribute(userDN, UserAttributes.USER_PKCS12, username, password);
    }

    public boolean setPrivateCertificateString(String userDN, String certificate, String username, String password) throws LdapException {
        return this.setPublicAttribute(userDN, UserAttributes.USER_PKCS12, certificate, username, password);
    }

    public String getMail(String userDN, String username, String password) throws LdapException {
        return (String)this.getPublicAttribute(userDN, UserAttributes.EMAIL, username, password);
    }

    public boolean setMail(String userDN, String mail, String username, String password) throws LdapException {
        return this.setPublicAttribute(userDN, UserAttributes.EMAIL, mail, username, password);
    }
}

