/*
 * Decompiled with CFR 0.152.
 */
package br.gov.rs.tce.ldap;

import br.gov.rs.tce.ldap.ConfiguracaoLdap;
import br.gov.rs.tce.ldap.UserAttributes;
import br.gov.rs.tce.ldap.exception.LdapAutenticationException;
import br.gov.rs.tce.ldap.exception.LdapException;
import br.gov.rs.tce.ldap.exception.LdapNameNotFoundException;
import java.util.ArrayList;
import java.util.Hashtable;
import javax.naming.AuthenticationException;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.ModificationItem;
import javax.naming.ldap.InitialLdapContext;
import javax.naming.ldap.LdapContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ManipulaLdap {
    private static Log LOG = LogFactory.getLog(ManipulaLdap.class.getClass());
    protected String username;
    protected String password;

    public ManipulaLdap() {
    }

    public ManipulaLdap(String adminPassword, String adminUsername) {
        this.password = adminPassword;
        this.username = adminUsername;
    }

    public boolean createUserDN(String userDN, String username, String password) throws LdapException {
        LdapContext ctx = null;
        boolean retorno = false;
        try {
            ctx = this.getContext(username, password);
            ctx.createSubcontext(userDN);
            retorno = true;
        }
        catch (NamingException e) {
            LOG.warn((Object)("Erro ao criar userDN '" + userDN + "'"), (Throwable)e);
            throw new LdapException("Erro ao criar userDN '" + userDN + "'", e);
        }
        finally {
            this.closeContext(ctx);
        }
        return retorno;
    }

    public boolean createUserDNLike(String newUserDN, String likeUserDN, String[] attributesToRemove, String username, String password) throws LdapException {
        LdapContext ctx = null;
        boolean retorno = false;
        try {
            ctx = this.getContext(username, password);
            Attributes att = ctx.getAttributes(likeUserDN);
            if (attributesToRemove != null && attributesToRemove.length > 0) {
                for (int i = 0; i < attributesToRemove.length; ++i) {
                    att.remove(attributesToRemove[i]);
                }
            }
            ctx.createSubcontext(newUserDN, att);
            retorno = true;
        }
        catch (NameNotFoundException e) {
            LOG.warn((Object)("N\u00e3o foi poss\u00edvel encontrar o userDN '" + likeUserDN + "'! Verifique se ele existe no OID."), (Throwable)e);
            throw new LdapNameNotFoundException("N\u00e3o foi poss\u00edvel encontrar o userDN '" + likeUserDN + "'! Verifique se ele existe no OID.", e);
        }
        catch (NamingException e) {
            LOG.warn((Object)("Erro ao copiar o userDN '" + likeUserDN + "' para o userDN '" + newUserDN + "'"), (Throwable)e);
            throw new LdapException("Erro ao copiar o userDN '" + likeUserDN + "' para o userDN '" + newUserDN + "'", e);
        }
        finally {
            this.closeContext(ctx);
        }
        return retorno;
    }

    public boolean createUserDNLike(String newUserDN, String likeUserDN, String username, String password) throws LdapException {
        String[] remove = new String[]{"authpassword;orclcommonpwd", "authpassword;oid", "cn", "userpkcs12"};
        return this.createUserDNLike(newUserDN, likeUserDN, remove, username, password);
    }

    public boolean destroyUserDN(String userDN, String username, String password) throws LdapException {
        LdapContext ctx = null;
        boolean retorno = false;
        try {
            ctx = this.getContext(username, password);
            ctx.destroySubcontext(userDN);
            retorno = true;
        }
        catch (NameNotFoundException e) {
            LOG.warn((Object)("N\u00e3o foi poss\u00edvel encontrar o userDN '" + userDN + "'! Verifique se ele existe no OID."), (Throwable)e);
            throw new LdapNameNotFoundException("N\u00e3o foi poss\u00edvel encontrar o userDN '" + userDN + "'! Verifique se ele existe no OID.", e);
        }
        catch (NamingException e) {
            LOG.warn((Object)("Erro ao excluir userDN '" + userDN + "'"), (Throwable)e);
            throw new LdapException("Erro ao excluir userDN '" + userDN + "'", e);
        }
        finally {
            this.closeContext(ctx);
        }
        return retorno;
    }

    public Object getPublicAttribute(String userDN, UserAttributes attribute) throws LdapException {
        if (this.username == null || this.password == null) {
            throw new LdapAutenticationException("Autentica\u00e7\u00e3o como administrador sem login e/ou senha.");
        }
        return this.getPublicAttribute(userDN, attribute, this.username, this.password);
    }

    public Object getPublicAttribute(String userDN, UserAttributes attribute, String username, String password) throws LdapException {
        ArrayList<Object> obj = null;
        LdapContext ctx = null;
        try {
            ctx = this.getContext(username, password);
            Attributes atts = ctx.getAttributes(userDN);
            Attribute att = atts.get(attribute.toString());
            if (att != null) {
                if (att.size() == 1) {
                    obj = att.get();
                } else {
                    ArrayList<Object> arr = new ArrayList<Object>();
                    for (int i = 0; i < att.size(); ++i) {
                        arr.add(att.get(i));
                    }
                    obj = arr;
                }
            }
        }
        catch (NameNotFoundException e) {
            LOG.warn((Object)("N\u00e3o foi poss\u00edvel encontrar o userDN '" + userDN + "'! Verifique se ele existe no OID."), (Throwable)e);
            throw new LdapNameNotFoundException("N\u00e3o foi poss\u00edvel encontrar o userDN '" + userDN + "'! Verifique se ele existe no OID.", e);
        }
        catch (NamingException e) {
            LOG.warn((Object)("N\u00e3o foi poss\u00edvel obter o atributo '" + (Object)((Object)attribute) + "' do userDN '" + userDN + "'"), (Throwable)e);
            throw new LdapException("Erro ao obter o atributo '" + (Object)((Object)attribute) + "' do userDN '" + userDN + "'", e);
        }
        finally {
            this.closeContext(ctx);
        }
        return obj;
    }

    public boolean setPublicAttribute(String userDN, UserAttributes attributeName, Object attributeValue, String username, String password) throws LdapException {
        LdapContext ctx = null;
        boolean retorno = false;
        try {
            ctx = this.getContext(username, password);
            Attributes atts = ctx.getAttributes(userDN);
            Attribute att = atts.get(attributeName.toString());
            ModificationItem[] mods = null;
            if (att == null) {
                att = new BasicAttribute(attributeName.toString(), attributeValue);
                mods = new ModificationItem[]{new ModificationItem(1, att)};
            } else {
                att.clear();
                att.add(attributeValue);
                mods = new ModificationItem[]{new ModificationItem(2, att)};
            }
            ctx.modifyAttributes(userDN, mods);
            retorno = true;
        }
        catch (NameNotFoundException e) {
            LOG.warn((Object)("N\u00e3o foi poss\u00edvel encontrar o userDN '" + userDN + "'! Verifique se ele existe no OID."), (Throwable)e);
            throw new LdapNameNotFoundException("N\u00e3o foi poss\u00edvel encontrar o userDN '" + userDN + "'! Verifique se ele existe no OID.", e);
        }
        catch (NamingException e) {
            LOG.warn((Object)("Erro ao setar o atributo '" + (Object)((Object)attributeName) + "' do userDN '" + userDN + "'"), (Throwable)e);
            throw new LdapException("Erro ao setar o atributo '" + (Object)((Object)attributeName) + "' do userDN '" + userDN + "'", e);
        }
        finally {
            this.closeContext(ctx);
        }
        return retorno;
    }

    private LdapContext getContext(String username, String password) throws LdapException {
        Hashtable env = ConfiguracaoLdap.getInstance().getEnvironmentProperties(username, password);
        try {
            return new InitialLdapContext(env, null);
        }
        catch (AuthenticationException e) {
            LOG.warn((Object)("N\u00e3o foi poss\u00edvel autenticar o usu\u00e1rio '" + username + "'"), (Throwable)e);
            throw new LdapAutenticationException("N\u00e3o foi poss\u00edvel autenticar o usu\u00e1rio '" + username + "'", e);
        }
        catch (NamingException e) {
            LOG.warn((Object)"Erro ao criar contexto LDAP", (Throwable)e);
            throw new LdapException("Erro ao criar contexto LDAP", e);
        }
    }

    private void closeContext(LdapContext ctx) throws LdapException {
        try {
            if (ctx != null) {
                ctx.close();
            }
        }
        catch (NamingException e) {
            LOG.warn((Object)"Erro ao fechar contexto LDAP", (Throwable)e);
            throw new LdapException("Erro ao fechar contexto LDAP", e);
        }
    }
}

