/*
 * Decompiled with CFR 0.152.
 */
package br.gov.rs.tce.commons.ldap;

import br.gov.rs.tce.commons.ldap.BeanUtils;
import br.gov.rs.tce.commons.ldap.LdapAutenticationException;
import br.gov.rs.tce.commons.ldap.LdapConfig;
import br.gov.rs.tce.commons.ldap.LdapException;
import br.gov.rs.tce.commons.ldap.Mapping;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.naming.AuthenticationException;
import javax.naming.NameNotFoundException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.ModificationItem;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.InitialLdapContext;
import javax.naming.ldap.LdapContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LdapConnector {
    private static Log LOG = LogFactory.getLog(LdapConnector.class.getClass());
    private BeanUtils beanUtil = new BeanUtils();
    LdapContext ctx = null;
    String beanClass = "java.lang.Object";
    Set<Mapping> mappings = new HashSet<Mapping>();

    public LdapConnector() throws LdapException {
        this.openConnection(null, null);
    }

    public LdapConnector(boolean startConnected) throws LdapException {
        if (startConnected) {
            this.openConnection(null, null);
        }
    }

    public LdapConnector(String username, String password) throws LdapAutenticationException, LdapException {
        this.openConnection(username, password);
    }

    public void openConnection(String username, String password) throws LdapAutenticationException, LdapException {
        if (this.ctx != null) {
            LOG.info((Object)"This LdapConnector instance alread has an ldap connection");
            return;
        }
        Hashtable env = LdapConfig.getInstance().getRootEnvironmentProperties(username, password);
        try {
            this.ctx = new InitialLdapContext(env, null);
            LOG.info((Object)"Connected to LDAP server");
        }
        catch (AuthenticationException e) {
            LOG.info((Object)("Cannot autenticate the given user: " + e.getMessage()));
            throw new LdapAutenticationException("Cannot autenticate the given user: " + e.getMessage(), e);
        }
        catch (NamingException e) {
            LOG.error((Object)("Error on create LDAP connection: " + e.getMessage()), (Throwable)e);
            throw new LdapException("Error on create LDAP connection: " + e.getMessage(), e);
        }
    }

    private void checkConnectionState() {
        if (this.ctx == null) {
            throw new IllegalStateException("The LdapConnector is not connected to LDAP server");
        }
    }

    public void closeConnection() {
        try {
            if (this.ctx != null) {
                this.ctx.close();
                this.ctx = null;
                LOG.info((Object)"Disconected from LDAP server");
            }
        }
        catch (NamingException e) {
            LOG.error((Object)("Error occurred on closing LDAP context: " + e.getMessage()), (Throwable)e);
        }
    }

    protected void finalize() throws Throwable {
        this.closeConnection();
        super.finalize();
    }

    public Object get(String name) throws LdapException {
        this.checkConnectionState();
        Object bean = null;
        try {
            Attributes atts = this.ctx.getAttributes(name);
            bean = this.getBeanFromAttributes(atts);
        }
        catch (NameNotFoundException e) {
            bean = null;
        }
        catch (NamingException e) {
            LOG.error((Object)("A unexpected error has ocurred accessing the LDAP server: " + e.getMessage()), (Throwable)e);
            throw new LdapException("A unexpected error has ocurred accessing the LDAP server: " + e.getMessage(), e);
        }
        return bean;
    }

    public List getByQuery(String query) throws LdapException {
        this.checkConnectionState();
        LinkedList<Object> list = new LinkedList<Object>();
        NamingEnumeration<SearchResult> results = null;
        try {
            SearchControls controls = new SearchControls();
            controls.setSearchScope(2);
            results = this.ctx.search("", query, controls);
            while (results.hasMore()) {
                SearchResult searchResult = results.next();
                Attributes attributes = searchResult.getAttributes();
                Object bean = this.getBeanFromAttributes(attributes);
                if (bean == null) continue;
                list.add(bean);
            }
        }
        catch (NamingException e) {
            LOG.error((Object)("A unexpected error has ocurred accessing the LDAP server: " + e.getMessage()), (Throwable)e);
            throw new LdapException("A unexpected error has ocurred accessing the LDAP server: " + e.getMessage(), e);
        }
        return list;
    }

    public boolean set(String name, Object bean) {
        this.checkConnectionState();
        boolean returnVal = false;
        if (bean == null) {
            return this.remove(name);
        }
        try {
            Attributes atts = this.ctx.getAttributes(name);
            ArrayList<ModificationItem> mods = new ArrayList<ModificationItem>();
            Map<String, Object> propriedades = this.beanUtil.getBeanAttributes(bean);
            for (Map.Entry<String, Object> pair : propriedades.entrySet()) {
                Attribute att;
                String beanKey = pair.getKey();
                Object beanValue = pair.getValue();
                Mapping m = this.getMappingForBean(beanKey);
                if (m != null && m.isIgnoreOnSet()) continue;
                if (m != null) {
                    beanKey = m.getLdapAttribute();
                }
                if ((att = atts.get(beanKey)) == null) {
                    att = this.getAsAttribute(beanKey, beanValue);
                    if (att == null) continue;
                    mods.add(new ModificationItem(1, att));
                    continue;
                }
                boolean overwrite = false;
                Object ldapValue = att.get();
                if (beanValue != null) {
                    if (!beanValue.equals(ldapValue)) {
                        overwrite = true;
                    }
                } else if (ldapValue != null) {
                    overwrite = true;
                }
                if (!overwrite) continue;
                att = this.getAsAttribute(beanKey, beanValue);
                if (att != null) {
                    mods.add(new ModificationItem(2, att));
                    continue;
                }
                mods.add(new ModificationItem(3, new BasicAttribute(beanKey)));
            }
            if (mods.size() > 0) {
                ModificationItem[] modItens = new ModificationItem[mods.size()];
                mods.toArray(modItens);
                this.ctx.modifyAttributes(name, modItens);
            }
            returnVal = true;
        }
        catch (NameNotFoundException e) {
            this.add(name, bean);
        }
        catch (NamingException e) {
            LOG.error((Object)("Error on setting bean on LDAP server: " + e.getMessage()), (Throwable)e);
        }
        return returnVal;
    }

    public boolean remove(String name) {
        this.checkConnectionState();
        boolean returnVal = false;
        try {
            this.ctx.destroySubcontext(name);
            returnVal = true;
        }
        catch (NamingException e) {
            LOG.error((Object)("Error adding bean on LDAP server: " + e.getMessage()), (Throwable)e);
        }
        return returnVal;
    }

    private boolean add(String name, Object bean) {
        boolean returnVal = false;
        try {
            BasicAttributes attrs = new BasicAttributes(true);
            Map<String, Object> beanProperties = this.beanUtil.getBeanAttributes(bean);
            for (Map.Entry<String, Object> pairs : beanProperties.entrySet()) {
                Attribute att;
                String beanKey = pairs.getKey();
                Object beanValue = pairs.getValue();
                Mapping m = this.getMappingForBean(beanKey);
                if (m != null && m.isIgnoreOnSet()) continue;
                if (m != null) {
                    beanKey = m.getLdapAttribute();
                }
                if ((att = this.getAsAttribute(beanKey, beanValue)) == null) continue;
                attrs.put(att);
            }
            this.ctx.createSubcontext(name, (Attributes)attrs);
            returnVal = true;
        }
        catch (NamingException e) {
            LOG.error((Object)("Error adding bean on LDAP server: " + e.getMessage()), (Throwable)e);
        }
        return returnVal;
    }

    private Object getBeanFromAttributes(Attributes atts) throws NamingException {
        Object bean = this.beanUtil.createClassInstance(this.beanClass);
        NamingEnumeration<String> attributeNames = atts.getIDs();
        while (attributeNames.hasMore()) {
            String name = attributeNames.next();
            Attribute attribute = atts.get(name);
            Mapping m = this.getMappingForLdap(name);
            if (m != null && m.isIgnoreOnGet()) continue;
            if (m != null) {
                name = m.getBeanProperty();
            }
            if (attribute.size() > 1) {
                Object first = attribute.get();
                Object attributes = Array.newInstance(first.getClass(), attribute.size());
                for (int i = 0; i < attribute.size(); ++i) {
                    Array.set(attributes, i, attribute.get(i));
                }
                this.beanUtil.setBeanAttribute(bean, name, attributes);
                continue;
            }
            this.beanUtil.setBeanAttribute(bean, name, attribute.get());
        }
        return bean;
    }

    private Attribute getAsAttribute(String beanKey, Object beanValue) {
        BasicAttribute att = null;
        if (beanValue != null) {
            att = new BasicAttribute(beanKey);
            if (beanValue instanceof Object[]) {
                Object[] values = (Object[])beanValue;
                for (int i = 0; i < values.length; ++i) {
                    att.add(values[i]);
                }
            } else {
                att.add(beanValue);
            }
        }
        return att;
    }

    private Mapping getMappingForLdap(String ldapAttribute) {
        for (Mapping m : this.getMappings()) {
            if (!ldapAttribute.equals(m.getLdapAttribute())) continue;
            return m;
        }
        return null;
    }

    private Mapping getMappingForBean(String beanProperty) {
        for (Mapping m : this.getMappings()) {
            if (!beanProperty.equals(m.getBeanProperty())) continue;
            return m;
        }
        return null;
    }

    public String getBeanClass() {
        return this.beanClass;
    }

    public void setBeanClass(String beanClass) {
        this.beanUtil.createClassInstance(beanClass);
        this.beanClass = beanClass;
    }

    public void setBeanClass(Class beanClass) {
        this.beanUtil.createClassInstance(beanClass.getName());
        this.beanClass = beanClass.getName();
    }

    public Set<Mapping> getMappings() {
        return this.mappings;
    }

    public void setMappings(Set<Mapping> mappings) {
        this.mappings = mappings;
    }
}

