/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.pool;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Stack;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.StringRefAddr;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.PooledConnection;
import oracle.dms.instrument.EventIntf;
import oracle.dms.instrument.NounIntf;
import oracle.dms.instrument.PhaseEventIntf;
import oracle.dms.instrument.StateIntf;
import oracle.jdbc.driver.DMSFactory;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.pool.OracleConnectionCache;
import oracle.jdbc.pool.OracleConnectionCacheTimeOutThread;
import oracle.jdbc.pool.OracleConnectionEventListener;
import oracle.jdbc.pool.OracleConnectionPoolDataSource;
import oracle.jdbc.pool.OracleDataSource;
import oracle.jdbc.pool.OraclePooledConnection;

public class OracleConnectionCacheImpl
extends OracleDataSource
implements OracleConnectionCache,
Serializable,
Referenceable {
    protected ConnectionPoolDataSource m_cpds = null;
    protected static int _DEFAULT_MIN_LIMIT = 0;
    protected static int _DEFAULT_MAX_LIMIT = Integer.MAX_VALUE;
    protected int _MIN_LIMIT = _DEFAULT_MIN_LIMIT;
    protected int _MAX_LIMIT = _DEFAULT_MAX_LIMIT;
    protected static final int DEFAULT_CACHE_TIMEOUT = -1;
    protected static final int DEFAULT_THREAD_INTERVAL = 900;
    public static final int ORAERROR_END_OF_FILE_ON_COM_CHANNEL = 3113;
    public static final int ORAERROR_NOT_CONNECTED_TO_ORACLE = 3114;
    public static final int ORAERROR_INIT_SHUTDOWN_IN_PROGRESS = 1033;
    public static final int ORAERROR_ORACLE_NOT_AVAILABLE = 1034;
    public static final int ORAERROR_IMMEDIATE_SHUTDOWN_IN_PROGRESS = 1089;
    public static final int ORAERROR_SHUTDOWN_IN_PROGRESS_NO_CONN = 1090;
    public static final int ORAERROR_NET_IO_EXCEPTION = 17002;
    protected long m_cacheTTLTimeOut = -1L;
    protected long m_cacheInactivityTimeOut = -1L;
    protected long m_cacheFixedWaitTimeOut = -1L;
    protected long m_threadInterval = 900L;
    Stack m_cache = new Stack();
    Hashtable m_activeCache = new Hashtable(50);
    private Object CACHE_SIZE_LOCK = new String("");
    protected int m_cacheSize = 0;
    protected int m_activeSize = 0;
    protected int m_cacheScheme = 1;
    protected long m_cleanupInterval = 30L;
    protected int[] m_fatalErrorCodes = null;
    public static final long DEFAULT_FIXED_WAIT_IDLE_TIME = 30L;
    protected long m_fixedWaitIdleTime = -1L;
    public static final int DYNAMIC_SCHEME = 1;
    public static final int FIXED_WAIT_SCHEME = 2;
    public static final int FIXED_RETURN_NULL_SCHEME = 3;
    protected OracleConnectionEventListener m_ocel = null;
    protected int m_stmtCacheSize = 0;
    protected boolean m_stmtClearMetaData = false;
    protected OracleConnectionCacheTimeOutThread m_timeOutThread = null;
    SQLWarning m_warning = null;
    static final String dms_size_name = "CacheSize";
    static final String dms_size_description = "number of physical connections in the cache";
    static final String dms_size_units = "connections";
    static final String dms_freeSize_name = "CacheFreeSize";
    static final String dms_freeSize_description = "number of additional connections that can be added to the cache before it reaches capacity";
    static final String dms_freeSize_units = "connections";
    static final String dms_hitCount_name = "CacheHit";
    static final String dms_hitCount_description = "a  connection was found in the cache";
    static final String dms_missCount_name = "CacheMiss";
    static final String dms_missCount_description = "no connection was found in the cache";
    static final String dms_getConnection_name = "CacheGetConnection";
    static final String dms_getConnection_description = "time required to get a connection";
    transient NounIntf m_dmsParent = null;
    transient StateIntf m_size = null;
    transient StateIntf m_freeSize = null;
    transient EventIntf m_hitCount = null;
    transient EventIntf m_missCount = null;
    transient PhaseEventIntf m_getCachedConn = null;
    private static final String _Copyright_2003_Oracle_All_Rights_Reserved_ = null;
    public static final boolean TRACE = false;
    public static final boolean PRIVATE_TRACE = false;
    public static final String BUILD_DATE = "051228";

    protected static String dms_data_source_type() {
        return "JDBC_ConnectionCache";
    }

    public OracleConnectionCacheImpl() throws SQLException {
        this(null);
    }

    public OracleConnectionCacheImpl(ConnectionPoolDataSource connectionPoolDataSource) throws SQLException {
        this.m_cpds = connectionPoolDataSource;
        this.m_ocel = new OracleConnectionEventListener(this);
        this.m_dataSourceName = "OracleConnectionCacheImpl";
        this.isOracleDataSource = false;
        if (this.m_dmsParent == null) {
            this.createDMSSensors();
        }
    }

    protected void createDMSSensors() {
        this.m_dmsParent = DMSFactory.createNoun(null, "JDBC", null);
        this.m_dmsParent = DMSFactory.createNoun(this.m_dmsParent, this.m_dataSourceName, "JDBC_ConnectionSource");
        this.m_size = DMSFactory.createState(this.m_dmsParent, dms_size_name, "connections", dms_size_description, this.m_cacheSize);
        this.m_size.deriveMetric(14);
        this.m_freeSize = DMSFactory.createState(this.m_dmsParent, dms_freeSize_name, "connections", dms_freeSize_description, this.m_cacheSize - this.m_activeSize);
        this.m_freeSize.deriveMetric(14);
        this.m_hitCount = DMSFactory.createEvent(this.m_dmsParent, dms_hitCount_name, dms_hitCount_description);
        this.m_missCount = DMSFactory.createEvent(this.m_dmsParent, dms_missCount_name, dms_missCount_description);
        this.m_getCachedConn = DMSFactory.createPhaseEvent(this.m_dmsParent, dms_getConnection_name, dms_getConnection_description);
        this.m_getCachedConn.deriveMetric(511);
    }

    public synchronized void setConnectionPoolDataSource(ConnectionPoolDataSource connectionPoolDataSource) throws SQLException {
        if (this.m_cacheSize > 0) {
            DatabaseError.throwSqlException(78);
        }
        this.m_cpds = connectionPoolDataSource;
    }

    public synchronized Connection getConnection() throws SQLException {
        return this.getConnection(this.m_user, this.m_password);
    }

    public synchronized Connection getConnection(String string, String string2) throws SQLException {
        Connection connection = null;
        PooledConnection pooledConnection = this.getPooledConnection(string, string2);
        if (pooledConnection != null) {
            connection = pooledConnection.getConnection();
        }
        if (connection != null) {
            ((OracleConnection)connection).setStartTime(System.currentTimeMillis());
        }
        return connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected PooledConnection getPooledConnection(String string, String string2) throws SQLException {
        PooledConnection pooledConnection = null;
        long l = DMSFactory.getToken();
        boolean bl = false;
        if (!this.m_cache.empty()) {
            this.checkCredentials(string, string2);
            pooledConnection = this.removeConnectionFromCache();
        } else if (this.m_cacheSize < this._MAX_LIMIT || this.m_cacheScheme == 1) {
            String string3 = null;
            String string4 = null;
            if (this.m_cpds != null) {
                string3 = ((OracleConnectionPoolDataSource)this.m_cpds).getUser();
                string4 = ((OracleConnectionPoolDataSource)this.m_cpds).getPassword();
            }
            if (this.m_cacheSize > 0 && string != null && !string.equalsIgnoreCase(string3)) {
                DatabaseError.throwSqlException(79);
            }
            if (this.m_cacheSize > 0 && string2 != null && !string2.equalsIgnoreCase(string4)) {
                DatabaseError.throwSqlException(79);
            }
            pooledConnection = this.getNewPoolOrXAConnection();
            Object object = this.CACHE_SIZE_LOCK;
            synchronized (object) {
                ++this.m_cacheSize;
            }
            this.m_size.update(this.m_cacheSize);
            this.m_missCount.occurred();
            bl = true;
        } else if (this.m_cacheScheme == 3) {
            this.m_missCount.occurred();
        } else {
            this.checkCredentials(string, string2);
            long l2 = System.currentTimeMillis();
            while (this.m_cache.empty()) {
                if (this.m_cacheFixedWaitTimeOut > 0L && System.currentTimeMillis() - l2 > this.m_cacheFixedWaitTimeOut * 1000L) {
                    DatabaseError.throwSqlException(126);
                }
                Stack stack = this.m_cache;
                synchronized (stack) {
                    try {
                        this.m_cache.wait((this.m_fixedWaitIdleTime == -1L ? 30L : this.m_fixedWaitIdleTime) * 1000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
            pooledConnection = this.removeConnectionFromCache();
        }
        if (pooledConnection != null) {
            pooledConnection.addConnectionEventListener(this.m_ocel);
            this.m_activeCache.put(pooledConnection, pooledConnection);
            this.m_activeSize = this.m_activeCache.size();
            ((OraclePooledConnection)pooledConnection).setStmtCacheSize(this.m_stmtCacheSize, this.m_stmtClearMetaData);
            this.m_freeSize.update(this.m_cacheSize - this.m_activeSize);
            if (!bl) {
                this.m_getCachedConn.start(l);
                this.m_getCachedConn.stop(l);
                this.m_hitCount.occurred();
            }
        }
        return pooledConnection;
    }

    PooledConnection getNewPoolOrXAConnection() throws SQLException {
        if (this.m_cpds == null) {
            if (this.m_user == null || this.m_password == null) {
                DatabaseError.throwSqlException(79);
            }
            this.m_cpds = new OracleConnectionPoolDataSource();
            this.copy((OracleDataSource)((Object)this.m_cpds));
        }
        PooledConnection pooledConnection = this.m_cpds.getPooledConnection();
        ((OraclePooledConnection)pooledConnection).setStmtCacheSize(this.m_stmtCacheSize, this.m_stmtClearMetaData);
        return pooledConnection;
    }

    public void reusePooledConnection(PooledConnection pooledConnection) throws SQLException {
        this.detachSingleConnection(pooledConnection);
        if (this.m_cache.size() >= this._MAX_LIMIT && this.m_cacheScheme == 1) {
            this.closeSingleConnection(pooledConnection, false);
        } else {
            this.putConnectionToCache(pooledConnection);
        }
    }

    public void closePooledConnection(PooledConnection pooledConnection) throws SQLException {
        this.detachSingleConnection(pooledConnection);
        this.closeSingleConnection(pooledConnection, false);
    }

    private void detachSingleConnection(PooledConnection pooledConnection) {
        pooledConnection.removeConnectionEventListener(this.m_ocel);
        this.m_activeCache.remove(pooledConnection);
        this.m_activeSize = this.m_activeCache.size();
        this.m_freeSize.update(this.m_cacheSize - this.m_activeSize);
    }

    public void closeSingleConnection(PooledConnection pooledConnection) throws SQLException {
        this.closeSingleConnection(pooledConnection, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void closeSingleConnection(PooledConnection pooledConnection, boolean bl) throws SQLException {
        if (!this.removeConnectionFromCache(pooledConnection) && bl) {
            return;
        }
        try {
            pooledConnection.close();
        }
        catch (SQLException sQLException) {
            this.m_warning = DatabaseError.addSqlWarning(this.m_warning, new SQLWarning(sQLException.getMessage()));
        }
        Object object = this.CACHE_SIZE_LOCK;
        synchronized (object) {
            --this.m_cacheSize;
        }
        this.m_size.update(this.m_cacheSize);
    }

    public synchronized void close() throws SQLException {
        this.closeConnections();
        if (this.m_dmsParent != null) {
            this.m_dmsParent.destroy();
            this.m_size = null;
            this.m_freeSize = null;
            this.m_hitCount = null;
            this.m_missCount = null;
            this.m_getCachedConn = null;
            this.m_dmsParent = null;
        }
        this.m_cache = null;
        this.m_activeCache = null;
        this.m_ocel = null;
        this.m_cpds = null;
        this.m_timeOutThread = null;
        this.clearWarnings();
    }

    public void closeConnections() {
        Enumeration enumeration = this.m_activeCache.keys();
        while (enumeration.hasMoreElements()) {
            try {
                OraclePooledConnection oraclePooledConnection = (OraclePooledConnection)enumeration.nextElement();
                OraclePooledConnection oraclePooledConnection2 = (OraclePooledConnection)this.m_activeCache.get(oraclePooledConnection);
                if (oraclePooledConnection2 == null) continue;
                OracleConnection oracleConnection = (OracleConnection)oraclePooledConnection2.getLogicalHandle();
                oracleConnection.close();
            }
            catch (Exception exception) {}
        }
        while (!this.m_cache.empty()) {
            try {
                this.closeSingleConnection((PooledConnection)this.m_cache.peek(), false);
            }
            catch (SQLException sQLException) {}
        }
        if (this.m_dmsParent != null) {
            this.m_size.update(this.m_cacheSize);
            this.m_freeSize.update(this.m_cacheSize);
        }
    }

    public synchronized void setConnectionCleanupInterval(long l) throws SQLException {
        if (l > 0L) {
            this.m_cleanupInterval = l;
        }
    }

    public long getConnectionCleanupInterval() throws SQLException {
        return this.m_cleanupInterval;
    }

    public synchronized void setConnectionErrorCodes(int[] nArray) throws SQLException {
        if (nArray != null) {
            this.m_fatalErrorCodes = nArray;
        }
    }

    public int[] getConnectionErrorCodes() throws SQLException {
        return this.m_fatalErrorCodes;
    }

    public boolean isFatalConnectionError(SQLException sQLException) {
        if (this.m_cleanupInterval < 0L) {
            return false;
        }
        boolean bl = false;
        int n = sQLException.getErrorCode();
        if (n == 3113 || n == 3114 || n == 1033 || n == 1034 || n == 1089 || n == 1090 || n == 17002) {
            bl = true;
        } else if (this.m_fatalErrorCodes != null) {
            for (int i = 0; i < this.m_fatalErrorCodes.length; ++i) {
                if (n != this.m_fatalErrorCodes[i]) continue;
                bl = true;
            }
        }
        return bl;
    }

    public synchronized void setMinLimit(int n) throws SQLException {
        if (n < 0 || n > this._MAX_LIMIT) {
            DatabaseError.throwSqlException(68);
        }
        this._MIN_LIMIT = n;
        if (this.m_cacheSize < this._MIN_LIMIT) {
            for (int i = this.m_cacheSize; i < this._MIN_LIMIT; ++i) {
                PooledConnection pooledConnection = this.getNewPoolOrXAConnection();
                this.putConnectionToCache(pooledConnection);
            }
            this.m_cacheSize = this._MIN_LIMIT;
            if (this.m_size != null) {
                this.m_size.update(this.m_cacheSize);
            }
        }
    }

    public synchronized int getMinLimit() {
        return this._MIN_LIMIT;
    }

    public synchronized void setMaxLimit(int n) throws SQLException {
        if (n < 0 || n < this._MIN_LIMIT) {
            DatabaseError.throwSqlException(68);
        }
        this._MAX_LIMIT = n;
        if (this.m_cacheSize > this._MAX_LIMIT && this.m_cacheScheme != 1) {
            for (int i = this._MAX_LIMIT; i < this.m_cacheSize; ++i) {
                if (this.m_cache.empty()) {
                    DatabaseError.throwSqlException(78);
                    continue;
                }
                this.removeConnectionFromCache().close();
            }
            this.m_cacheSize = this._MAX_LIMIT;
            if (this.m_size != null) {
                this.m_size.update(this.m_cacheSize);
            }
        }
    }

    public synchronized int getMaxLimit() {
        return this._MAX_LIMIT;
    }

    public synchronized int getCacheScheme() {
        return this.m_cacheScheme;
    }

    public synchronized void setCacheScheme(int n) throws SQLException {
        if (n == 1 || n == 3 || n == 2) {
            this.m_cacheScheme = n;
            return;
        }
        DatabaseError.throwSqlException(68);
    }

    public synchronized void setCacheScheme(String string) throws SQLException {
        if (string.equalsIgnoreCase("DYNAMIC_SCHEME")) {
            this.m_cacheScheme = 1;
        } else if (string.equalsIgnoreCase("FIXED_RETURN_NULL_SCHEME")) {
            this.m_cacheScheme = 3;
        } else if (string.equalsIgnoreCase("FIXED_WAIT_SCHEME")) {
            this.m_cacheScheme = 2;
        } else {
            DatabaseError.throwSqlException(68);
        }
    }

    public synchronized int getActiveSize() {
        return this.m_activeSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getCacheSize() {
        Object object = this.CACHE_SIZE_LOCK;
        synchronized (object) {
            return this.m_cacheSize;
        }
    }

    public synchronized void setCacheTimeToLiveTimeout(long l) throws SQLException {
        if (this.m_timeOutThread == null) {
            this.m_timeOutThread = new OracleConnectionCacheTimeOutThread(this);
        }
        if (l <= 0L) {
            this.m_cacheTTLTimeOut = -1L;
            this.m_warning = DatabaseError.addSqlWarning(this.m_warning, 111);
        } else {
            this.m_cacheTTLTimeOut = l;
            this.checkAndStartTimeOutThread();
        }
    }

    public synchronized void setCacheInactivityTimeout(long l) throws SQLException {
        if (this.m_timeOutThread == null) {
            this.m_timeOutThread = new OracleConnectionCacheTimeOutThread(this);
        }
        if (l <= 0L) {
            this.m_cacheInactivityTimeOut = -1L;
            this.m_warning = DatabaseError.addSqlWarning(this.m_warning, 124);
        } else {
            this.m_cacheInactivityTimeOut = l;
            this.checkAndStartTimeOutThread();
        }
    }

    public synchronized void setCacheFixedWaitTimeout(long l) throws SQLException {
        if (l <= 0L) {
            this.m_cacheFixedWaitTimeOut = -1L;
            this.m_warning = DatabaseError.addSqlWarning(this.m_warning, 127);
        } else {
            this.m_cacheFixedWaitTimeOut = l;
        }
    }

    public long getCacheTimeToLiveTimeout() throws SQLException {
        return this.m_cacheTTLTimeOut;
    }

    public long getCacheInactivityTimeout() throws SQLException {
        return this.m_cacheInactivityTimeOut;
    }

    public long getCacheFixedWaitTimeout() throws SQLException {
        return this.m_cacheFixedWaitTimeOut;
    }

    public synchronized void setThreadWakeUpInterval(long l) throws SQLException {
        if (l <= 0L) {
            this.m_threadInterval = 900L;
            this.m_warning = DatabaseError.addSqlWarning(this.m_warning, 112);
        } else {
            this.m_threadInterval = l;
        }
        if (this.m_cacheTTLTimeOut > 0L && this.m_threadInterval > this.m_cacheTTLTimeOut || this.m_cacheInactivityTimeOut > 0L && this.m_threadInterval > this.m_cacheInactivityTimeOut) {
            this.m_warning = DatabaseError.addSqlWarning(this.m_warning, 113);
        }
    }

    public long getThreadWakeUpInterval() throws SQLException {
        return this.m_threadInterval;
    }

    private void checkAndStartTimeOutThread() throws SQLException {
        try {
            if (!this.m_timeOutThread.isAlive()) {
                this.m_timeOutThread.setDaemon(true);
                this.m_timeOutThread.start();
            }
        }
        catch (IllegalThreadStateException illegalThreadStateException) {
            // empty catch block
        }
    }

    public SQLWarning getWarnings() throws SQLException {
        return this.m_warning;
    }

    public void clearWarnings() throws SQLException {
        this.m_warning = null;
    }

    private final void checkCredentials(String string, String string2) throws SQLException {
        String string3 = null;
        String string4 = null;
        if (this.m_cpds != null) {
            string3 = ((OracleConnectionPoolDataSource)this.m_cpds).getUser();
            string4 = ((OracleConnectionPoolDataSource)this.m_cpds).getPassword();
        }
        if (string != null && !string.equals(string3) || string2 != null && !string2.equals(string4)) {
            DatabaseError.throwSqlException(79);
        }
    }

    public synchronized Reference getReference() throws NamingException {
        Reference reference = new Reference(this.getClass().getName(), "oracle.jdbc.pool.OracleDataSourceFactory", null);
        super.addRefProperties(reference);
        if (this._MIN_LIMIT != _DEFAULT_MIN_LIMIT) {
            reference.add(new StringRefAddr("minLimit", Integer.toString(this._MIN_LIMIT)));
        }
        if (this._MAX_LIMIT != _DEFAULT_MAX_LIMIT) {
            reference.add(new StringRefAddr("maxLimit", Integer.toString(this._MAX_LIMIT)));
        }
        if (this.m_cacheScheme != 1) {
            reference.add(new StringRefAddr("cacheScheme", Integer.toString(this.m_cacheScheme)));
        }
        return reference;
    }

    public synchronized void setStmtCacheSize(int n) throws SQLException {
        this.setStmtCacheSize(n, false);
    }

    public synchronized void setStmtCacheSize(int n, boolean bl) throws SQLException {
        if (n < 0) {
            DatabaseError.throwSqlException(68);
        }
        this.m_stmtCacheSize = n;
        this.m_stmtClearMetaData = bl;
    }

    public synchronized int getStmtCacheSize() {
        return this.m_stmtCacheSize;
    }

    synchronized boolean isStmtCacheEnabled() {
        return this.m_stmtCacheSize > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void putConnectionToCache(PooledConnection pooledConnection) throws SQLException {
        ((OraclePooledConnection)pooledConnection).setLastAccessedTime(System.currentTimeMillis());
        this.m_cache.push(pooledConnection);
        Stack stack = this.m_cache;
        synchronized (stack) {
            this.m_cache.notify();
        }
    }

    private PooledConnection removeConnectionFromCache() throws SQLException {
        return (PooledConnection)this.m_cache.pop();
    }

    private boolean removeConnectionFromCache(PooledConnection pooledConnection) throws SQLException {
        return this.m_cache.removeElement(pooledConnection);
    }

    public synchronized void setCacheFixedWaitIdleTime(long l) throws SQLException {
        if (this.m_cacheScheme == 2) {
            if (l <= 0L) {
                DatabaseError.addSqlWarning(this.m_warning, 68);
                this.m_fixedWaitIdleTime = 30L;
            } else {
                this.m_fixedWaitIdleTime = l;
            }
        } else {
            DatabaseError.addSqlWarning(this.m_warning, new SQLWarning("Caching scheme is not FIXED_WAIT_SCHEME"));
        }
    }

    public long getCacheFixedWaitIdleTime() throws SQLException {
        return this.m_fixedWaitIdleTime == -1L ? 30L : this.m_fixedWaitIdleTime;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.createDMSSensors();
    }
}

