/*
 * Decompiled with CFR 0.152.
 */
package oracle.adf.share.statemanager;

import java.util.Collection;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import oracle.adf.share.ADFContext;
import oracle.adf.share.ADFScope;
import oracle.adf.share.ADFScopeListener;
import oracle.adf.share.statemanager.Policy;
import oracle.adf.share.statemanager.StateManager;
import oracle.adf.share.statemanager.UUID;

public class StateManagerScopeAdapter
implements Map {
    public static final String STATE_MANAGER_SCOPE_ID_KEY = "adf.statemanager.uuid_key";
    public static final String ENV_STATE_MANAGER_POLICY_KEY = "adf.statemanager.policy_key";
    private final StateManager mStateManager;
    private final String mScopeName;
    private final Object mScopeUUID;
    private final Policy mPolicy;
    private static /* synthetic */ Class class$oracle$adf$share$statemanager$DefaultInitialContextFactory;

    public StateManagerScopeAdapter(String string, Hashtable hashtable) {
        this.mScopeName = string;
        if (hashtable == null) {
            hashtable = new Hashtable<String, String>(4);
        }
        if (hashtable.get("java.naming.factory.initial") == null) {
            Class clazz = class$oracle$adf$share$statemanager$DefaultInitialContextFactory;
            if (clazz == null) {
                clazz = class$oracle$adf$share$statemanager$DefaultInitialContextFactory = StateManagerScopeAdapter.class$("oracle.adf.share.statemanager.DefaultInitialContextFactory");
            }
            hashtable.put("java.naming.factory.initial", clazz.getName());
        }
        try {
            this.mStateManager = (StateManager)new InitialContext(hashtable).lookup("__state_manager__");
        }
        catch (NamingException namingException) {
            throw new RuntimeException(namingException);
        }
        Map map = ADFContext.getCurrent().getScope(this.mScopeName);
        Object object = map.get(STATE_MANAGER_SCOPE_ID_KEY);
        if (object == null) {
            object = this.generateStateManagerId(map);
            map.put(STATE_MANAGER_SCOPE_ID_KEY, object);
            if (map instanceof ADFScope) {
                ((ADFScope)map).addScopeListener(new ADFScopeListenerImpl());
            }
        }
        this.mScopeUUID = object;
        this.mPolicy = (Policy)hashtable.get(ENV_STATE_MANAGER_POLICY_KEY);
    }

    protected Object generateStateManagerId(Map map) {
        return UUID.generateUUID();
    }

    public int size() {
        this.methodNotSupported();
        return 0;
    }

    public void clear() {
        this.mStateManager.clearStates(this.mScopeUUID);
    }

    public boolean isEmpty() {
        this.methodNotSupported();
        return false;
    }

    public boolean containsKey(Object object) {
        this.methodNotSupported();
        return false;
    }

    public boolean containsValue(Object object) {
        this.methodNotSupported();
        return false;
    }

    public Collection values() {
        this.methodNotSupported();
        return null;
    }

    public void putAll(Map map) {
        this.methodNotSupported();
    }

    public Set entrySet() {
        this.methodNotSupported();
        return null;
    }

    public Set keySet() {
        this.methodNotSupported();
        return null;
    }

    public Object get(Object object) {
        return this.mStateManager.getState(this.mScopeUUID, object);
    }

    public Object remove(Object object) {
        return this.mStateManager.removeState(this.mScopeUUID, object);
    }

    public Object put(Object object, Object object2) {
        if (this.mPolicy != null) {
            return this.mStateManager.putState(this.mScopeUUID, object, object2, this.mPolicy);
        }
        return this.mStateManager.putState(this.mScopeUUID, object, object2);
    }

    protected String getScopeName() {
        return this.mScopeName;
    }

    private void methodNotSupported() {
        throw new UnsupportedOperationException();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public class ADFScopeListenerImpl
    implements ADFScopeListener {
        public void scopeInvalidated(String string) {
            Map map = ADFContext.getCurrent().getStateManager(string, null);
            map.clear();
        }

        ADFScopeListenerImpl() {
        }
    }
}

