/*
 * Decompiled with CFR 0.152.
 */
package oracle.adf.share.security.providers.jazn;

import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.Permission;
import java.security.Principal;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import javax.naming.InvalidNameException;
import javax.naming.NamingException;
import javax.security.auth.Subject;
import oracle.adf.share.ADFContext;
import oracle.adf.share.logging.ADFLogger;
import oracle.adf.share.security.ADFSecurityUtil;
import oracle.adf.share.security.SecurityContext;
import oracle.adf.share.security.SecurityContextImpl;
import oracle.adf.share.security.authentication.ADFRolePrincipal;
import oracle.adf.share.security.authentication.ADFUserPrincipal;
import oracle.adf.share.security.providers.jazn.JAZNContextHelper;
import oracle.adf.share.security.providers.jazn.JAZNPolicyProvider;
import oracle.security.jazn.util.JAZNSecurityManager;

public class JAZNSecurityContext
extends SecurityContextImpl
implements SecurityContext {
    private static JAZNContextHelper _ctx;
    private JAZNSecurityManager _jaznSM;
    private ADFLogger _adfSecLogger;
    private static final String AUTH_TIME = "_auth_time_";

    public JAZNSecurityContext() {
        this(null);
    }

    public JAZNSecurityContext(Hashtable hashtable) {
        super(hashtable);
        _ctx = JAZNContextHelper.getInstance(hashtable);
        this._adfSecLogger = _ctx.getADFSecurityLogger();
    }

    public Object addToEnvironment(String string, Object object) throws NamingException {
        if (string == null || string.equals("")) {
            throw new InvalidNameException("Empty name.");
        }
        if (string == "java.naming.security.principal" && object != null) {
            this.setPrincipal(object);
            return object;
        }
        return object != null ? this.mEnv.put(string, object) : null;
    }

    public Principal getUserPrincipal() {
        Principal principal = (Principal)this.mEnv.get("java.naming.security.principal");
        if (principal != null) {
            return principal;
        }
        principal = (Principal)this.mEnv.get("anonymous");
        if (principal != null) {
            return principal;
        }
        Subject subject = this.getSubject();
        if (subject != null && this.isAnyoneEnabled() && !ADFSecurityUtil.hasAnyoneRole(subject)) {
            this.addADFRoleToSubject();
        }
        if (subject != null && subject.getPrincipals() != null) {
            Iterator<Principal> iterator = subject.getPrincipals().iterator();
            while (iterator.hasNext()) {
                principal = iterator.next();
                if (!principal.getName().equals("anonymous")) continue;
                this.mEnv.put("anonymous", principal);
                break;
            }
        }
        return principal;
    }

    public String getUserName() {
        Principal principal = this.getUserPrincipal();
        return principal != null ? principal.getName() : null;
    }

    public boolean isAuthorizationEnabled() {
        Object v = this.mEnv.get("oracle.adf.security.authorization.enforce");
        return v != null ? v.equals("true") : false;
    }

    public boolean hasPermission(Permission permission) {
        long l;
        boolean bl;
        block7: {
            bl = true;
            Principal principal = this.getUserPrincipal();
            AccessControlContext accessControlContext = AccessController.getContext();
            Subject subject = Subject.getSubject(accessControlContext);
            l = System.currentTimeMillis();
            if (subject == null) {
                this._adfSecLogger.log(Level.FINE, "no subject base permission");
                JAZNPolicyProvider jAZNPolicyProvider = _ctx.getPolicyProvider();
                bl = jAZNPolicyProvider.hasPermission(permission, principal);
            } else {
                this.showPrincipals();
                this._adfSecLogger.log(Level.FINE, "-- AccessController.checkPermission " + permission.getName() + ", " + permission.getActions());
                this.initTimeStamp(false);
                l = System.currentTimeMillis();
                try {
                    AccessController.checkPermission(permission);
                }
                catch (Exception exception) {
                    bl = false;
                    if (!this.isAnyoneEnabled() || ADFSecurityUtil.hasAnyoneRole(subject)) break block7;
                    this.addADFRoleToSubject();
                    try {
                        AccessController.checkPermission(permission);
                        bl = true;
                    }
                    catch (Exception exception2) {
                        // empty catch block
                    }
                }
            }
        }
        long l2 = System.currentTimeMillis();
        this.authTime(l, l2);
        if (!bl) {
            this._adfSecLogger.log(Level.FINE, "checkPermission no permission: " + permission.getName() + ", " + permission.getActions());
            this.mEnv.put("jaas.permissioncheck", "true");
        }
        return bl;
    }

    synchronized void setPrincipal(Object object) {
        if (object == null) {
            return;
        }
        this.mEnv.put("oracle.adf.security.authenticated", "true");
        this.mEnv.put("java.naming.security.principal", object);
        try {
            String string = System.getProperty("oracle.adf.security.authorization.enforce");
            if (string != null) {
                this.mEnv.put("oracle.adf.security.authorization.enforce", string);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void refresh(boolean bl) {
        if (bl) {
            _ctx.persistJAZNData();
        }
        _ctx.refresh(new Hashtable());
    }

    void addADFRoleToSubject() {
        AccessControlContext accessControlContext = AccessController.getContext();
        Subject subject = Subject.getSubject(accessControlContext);
        if (subject != null) {
            ADFUserPrincipal aDFUserPrincipal = new ADFUserPrincipal("anonymous");
            subject.getPrincipals().add(aDFUserPrincipal);
            ADFRolePrincipal aDFRolePrincipal = new ADFRolePrincipal("anyone");
            aDFRolePrincipal.addUserGrantee(aDFUserPrincipal);
            subject.getPrincipals().add(aDFRolePrincipal);
        }
    }

    void checkEnableAnyoneRole() {
        String string = null;
        try {
            string = System.getProperty("oracle.adf.security.anyone.enable");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (string != null && string.equals("false")) {
            this.mEnv.put("oracle.adf.security.anyone.enable", "false");
        } else {
            this.mEnv.put("oracle.adf.security.anyone.enable", "true");
        }
    }

    void showPrincipals() {
        if (this._adfSecLogger == null || this._adfSecLogger.getLevel() == null) {
            return;
        }
        if (this._adfSecLogger.getLevel().intValue() > Level.FINE.intValue()) {
            return;
        }
        Subject subject = this.getSubject();
        if (subject != null && subject.getPrincipals() != null) {
            this._adfSecLogger.log(Level.FINE, "---- principals in subject");
            Iterator<Principal> iterator = subject.getPrincipals().iterator();
            while (iterator.hasNext()) {
                Principal principal = iterator.next();
                this._adfSecLogger.log(Level.FINE, "\t---- " + principal.getName());
            }
        } else {
            this._adfSecLogger.log(Level.FINE, "---- no subject, principals ");
        }
    }

    void authTime(long l, long l2) {
        Map map;
        if (!this._adfSecLogger.isFinest()) {
            return;
        }
        long l3 = l2 - l;
        if (ADFContext.getCurrent().isHttpContext() && (map = ADFContext.getCurrent().getSessionScope()) != null) {
            long l4 = 0L;
            Long l5 = (Long)map.get(AUTH_TIME);
            if (l5 != null) {
                l4 = l5;
            }
            map.put(AUTH_TIME, new Long(l4 += l3));
            this._adfSecLogger.log(Level.FINEST, "Permission check time delta: " + l3 + ", cumulative: " + l4);
        }
    }
}

